# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EntryArgs', 'Entry']

@pulumi.input_type
class EntryArgs:
    def __init__(__self__, *,
                 entry_type: pulumi.Input[builtins.str],
                 aspects: Optional[pulumi.Input[Sequence[pulumi.Input['EntryAspectArgs']]]] = None,
                 entry_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 entry_id: Optional[pulumi.Input[builtins.str]] = None,
                 entry_source: Optional[pulumi.Input['EntryEntrySourceArgs']] = None,
                 fully_qualified_name: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 parent_entry: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Entry resource.
        :param pulumi.Input[builtins.str] entry_type: The relative resource name of the entry type that was used to create this entry, in the format projects/{project_number}/locations/{locationId}/entryTypes/{entryTypeId}.
               
               
               - - -
        :param pulumi.Input[Sequence[pulumi.Input['EntryAspectArgs']]] aspects: The aspects that are attached to the entry.
               Structure is documented below.
        :param pulumi.Input[builtins.str] entry_group_id: The entry group id of the entry group the entry will be created in.
        :param pulumi.Input[builtins.str] entry_id: The entry id of the entry.
        :param pulumi.Input['EntryEntrySourceArgs'] entry_source: A nested object resource.
               Structure is documented below.
        :param pulumi.Input[builtins.str] fully_qualified_name: A name for the entry that can be referenced by an external system. For more information, see https://cloud.google.com/dataplex/docs/fully-qualified-names.
               The maximum size of the field is 4000 characters.
        :param pulumi.Input[builtins.str] location: The location where entry will be created.
        :param pulumi.Input[builtins.str] parent_entry: The resource name of the parent entry, in the format projects/{project_number}/locations/{locationId}/entryGroups/{entryGroupId}/entries/{entryId}.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "entry_type", entry_type)
        if aspects is not None:
            pulumi.set(__self__, "aspects", aspects)
        if entry_group_id is not None:
            pulumi.set(__self__, "entry_group_id", entry_group_id)
        if entry_id is not None:
            pulumi.set(__self__, "entry_id", entry_id)
        if entry_source is not None:
            pulumi.set(__self__, "entry_source", entry_source)
        if fully_qualified_name is not None:
            pulumi.set(__self__, "fully_qualified_name", fully_qualified_name)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if parent_entry is not None:
            pulumi.set(__self__, "parent_entry", parent_entry)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="entryType")
    def entry_type(self) -> pulumi.Input[builtins.str]:
        """
        The relative resource name of the entry type that was used to create this entry, in the format projects/{project_number}/locations/{locationId}/entryTypes/{entryTypeId}.


        - - -
        """
        return pulumi.get(self, "entry_type")

    @entry_type.setter
    def entry_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "entry_type", value)

    @property
    @pulumi.getter
    def aspects(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EntryAspectArgs']]]]:
        """
        The aspects that are attached to the entry.
        Structure is documented below.
        """
        return pulumi.get(self, "aspects")

    @aspects.setter
    def aspects(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EntryAspectArgs']]]]):
        pulumi.set(self, "aspects", value)

    @property
    @pulumi.getter(name="entryGroupId")
    def entry_group_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The entry group id of the entry group the entry will be created in.
        """
        return pulumi.get(self, "entry_group_id")

    @entry_group_id.setter
    def entry_group_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "entry_group_id", value)

    @property
    @pulumi.getter(name="entryId")
    def entry_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The entry id of the entry.
        """
        return pulumi.get(self, "entry_id")

    @entry_id.setter
    def entry_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "entry_id", value)

    @property
    @pulumi.getter(name="entrySource")
    def entry_source(self) -> Optional[pulumi.Input['EntryEntrySourceArgs']]:
        """
        A nested object resource.
        Structure is documented below.
        """
        return pulumi.get(self, "entry_source")

    @entry_source.setter
    def entry_source(self, value: Optional[pulumi.Input['EntryEntrySourceArgs']]):
        pulumi.set(self, "entry_source", value)

    @property
    @pulumi.getter(name="fullyQualifiedName")
    def fully_qualified_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A name for the entry that can be referenced by an external system. For more information, see https://cloud.google.com/dataplex/docs/fully-qualified-names.
        The maximum size of the field is 4000 characters.
        """
        return pulumi.get(self, "fully_qualified_name")

    @fully_qualified_name.setter
    def fully_qualified_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "fully_qualified_name", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location where entry will be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="parentEntry")
    def parent_entry(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource name of the parent entry, in the format projects/{project_number}/locations/{locationId}/entryGroups/{entryGroupId}/entries/{entryId}.
        """
        return pulumi.get(self, "parent_entry")

    @parent_entry.setter
    def parent_entry(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "parent_entry", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _EntryState:
    def __init__(__self__, *,
                 aspects: Optional[pulumi.Input[Sequence[pulumi.Input['EntryAspectArgs']]]] = None,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 entry_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 entry_id: Optional[pulumi.Input[builtins.str]] = None,
                 entry_source: Optional[pulumi.Input['EntryEntrySourceArgs']] = None,
                 entry_type: Optional[pulumi.Input[builtins.str]] = None,
                 fully_qualified_name: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 parent_entry: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Entry resources.
        :param pulumi.Input[Sequence[pulumi.Input['EntryAspectArgs']]] aspects: The aspects that are attached to the entry.
               Structure is documented below.
        :param pulumi.Input[builtins.str] create_time: The time when the Entry was created in Dataplex.
        :param pulumi.Input[builtins.str] entry_group_id: The entry group id of the entry group the entry will be created in.
        :param pulumi.Input[builtins.str] entry_id: The entry id of the entry.
        :param pulumi.Input['EntryEntrySourceArgs'] entry_source: A nested object resource.
               Structure is documented below.
        :param pulumi.Input[builtins.str] entry_type: The relative resource name of the entry type that was used to create this entry, in the format projects/{project_number}/locations/{locationId}/entryTypes/{entryTypeId}.
               
               
               - - -
        :param pulumi.Input[builtins.str] fully_qualified_name: A name for the entry that can be referenced by an external system. For more information, see https://cloud.google.com/dataplex/docs/fully-qualified-names.
               The maximum size of the field is 4000 characters.
        :param pulumi.Input[builtins.str] location: The location where entry will be created.
        :param pulumi.Input[builtins.str] name: The relative resource name of the entry, in the format projects/{project_number}/locations/{locationId}/entryGroups/{entryGroupId}/entries/{entryId}.
        :param pulumi.Input[builtins.str] parent_entry: The resource name of the parent entry, in the format projects/{project_number}/locations/{locationId}/entryGroups/{entryGroupId}/entries/{entryId}.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] update_time: The time when the entry was last updated in Dataplex.
        """
        if aspects is not None:
            pulumi.set(__self__, "aspects", aspects)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if entry_group_id is not None:
            pulumi.set(__self__, "entry_group_id", entry_group_id)
        if entry_id is not None:
            pulumi.set(__self__, "entry_id", entry_id)
        if entry_source is not None:
            pulumi.set(__self__, "entry_source", entry_source)
        if entry_type is not None:
            pulumi.set(__self__, "entry_type", entry_type)
        if fully_qualified_name is not None:
            pulumi.set(__self__, "fully_qualified_name", fully_qualified_name)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent_entry is not None:
            pulumi.set(__self__, "parent_entry", parent_entry)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter
    def aspects(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EntryAspectArgs']]]]:
        """
        The aspects that are attached to the entry.
        Structure is documented below.
        """
        return pulumi.get(self, "aspects")

    @aspects.setter
    def aspects(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EntryAspectArgs']]]]):
        pulumi.set(self, "aspects", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time when the Entry was created in Dataplex.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="entryGroupId")
    def entry_group_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The entry group id of the entry group the entry will be created in.
        """
        return pulumi.get(self, "entry_group_id")

    @entry_group_id.setter
    def entry_group_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "entry_group_id", value)

    @property
    @pulumi.getter(name="entryId")
    def entry_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The entry id of the entry.
        """
        return pulumi.get(self, "entry_id")

    @entry_id.setter
    def entry_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "entry_id", value)

    @property
    @pulumi.getter(name="entrySource")
    def entry_source(self) -> Optional[pulumi.Input['EntryEntrySourceArgs']]:
        """
        A nested object resource.
        Structure is documented below.
        """
        return pulumi.get(self, "entry_source")

    @entry_source.setter
    def entry_source(self, value: Optional[pulumi.Input['EntryEntrySourceArgs']]):
        pulumi.set(self, "entry_source", value)

    @property
    @pulumi.getter(name="entryType")
    def entry_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The relative resource name of the entry type that was used to create this entry, in the format projects/{project_number}/locations/{locationId}/entryTypes/{entryTypeId}.


        - - -
        """
        return pulumi.get(self, "entry_type")

    @entry_type.setter
    def entry_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "entry_type", value)

    @property
    @pulumi.getter(name="fullyQualifiedName")
    def fully_qualified_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A name for the entry that can be referenced by an external system. For more information, see https://cloud.google.com/dataplex/docs/fully-qualified-names.
        The maximum size of the field is 4000 characters.
        """
        return pulumi.get(self, "fully_qualified_name")

    @fully_qualified_name.setter
    def fully_qualified_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "fully_qualified_name", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location where entry will be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The relative resource name of the entry, in the format projects/{project_number}/locations/{locationId}/entryGroups/{entryGroupId}/entries/{entryId}.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="parentEntry")
    def parent_entry(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource name of the parent entry, in the format projects/{project_number}/locations/{locationId}/entryGroups/{entryGroupId}/entries/{entryId}.
        """
        return pulumi.get(self, "parent_entry")

    @parent_entry.setter
    def parent_entry(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "parent_entry", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time when the entry was last updated in Dataplex.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:dataplex/entry:Entry")
class Entry(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aspects: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EntryAspectArgs', 'EntryAspectArgsDict']]]]] = None,
                 entry_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 entry_id: Optional[pulumi.Input[builtins.str]] = None,
                 entry_source: Optional[pulumi.Input[Union['EntryEntrySourceArgs', 'EntryEntrySourceArgsDict']]] = None,
                 entry_type: Optional[pulumi.Input[builtins.str]] = None,
                 fully_qualified_name: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 parent_entry: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        An entry represents a data asset for which you capture metadata, such as a BigQuery table.
        The primary constituents of an entry are aspects, which provide thematically coherent information.
        Examples include a table's schema, sensitive data protection profile, data quality information, or a simple tag.

        **Important Considerations:**

        * There is a limit of 99 aspects per entry.
        * The entry resource has to use project numbers and not project IDs. Therefore, if
          a dependency was already provisioned using project ID, it needs to be referenced explicitly as a resource name
          containing the project number.

        To get more information about Entry, see:

        * [API documentation](https://cloud.google.com/dataplex/docs/reference/rest/v1/projects.locations.entryGroups.entries)
        * How-to Guides
            * [Manage entries and ingest custom sources](https://cloud.google.com/dataplex/docs/ingest-custom-sources)

        ## Example Usage

        ### Dataplex Entry Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        entry_group_basic = gcp.dataplex.EntryGroup("entry-group-basic",
            entry_group_id="entry-group-basic",
            project="1111111111111",
            location="us-central1")
        entry_type_basic = gcp.dataplex.EntryType("entry-type-basic",
            entry_type_id="entry-type-basic",
            project="1111111111111",
            location="us-central1")
        test_basic = gcp.dataplex.Entry("test_basic",
            entry_group_id=entry_group_basic.entry_group_id,
            project="1111111111111",
            location="us-central1",
            entry_id="entry-basic",
            entry_type=entry_type_basic.name)
        ```
        ### Dataplex Entry Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        aspect_type_full_one = gcp.dataplex.AspectType("aspect-type-full-one",
            aspect_type_id="aspect-type-full-one",
            location="us-central1",
            project="1111111111111",
            metadata_template=\"\"\"{
          "name": "tf-test-template",
          "type": "record",
          "recordFields": [
            {
              "name": "type",
              "type": "enum",
              "annotations": {
                "displayName": "Type",
                "description": "Specifies the type of view represented by the entry."
              },
              "index": 1,
              "constraints": {
                "required": true
              },
              "enumValues": [
                {
                  "name": "VIEW",
                  "index": 1
                }
              ]
            }
          ]
        }
        \"\"\")
        aspect_type_full_two = gcp.dataplex.AspectType("aspect-type-full-two",
            aspect_type_id="aspect-type-full-two",
            location="us-central1",
            project="1111111111111",
            metadata_template=\"\"\"{
          "name": "tf-test-template",
          "type": "record",
          "recordFields": [
            {
              "name": "story",
              "type": "enum",
              "annotations": {
                "displayName": "Story",
                "description": "Specifies the story of an entry."
              },
              "index": 1,
              "constraints": {
                "required": true
              },
              "enumValues": [
                {
                  "name": "SEQUENCE",
                  "index": 1
                }
              ]
            }
          ]
        }
        \"\"\")
        entry_group_full = gcp.dataplex.EntryGroup("entry-group-full",
            entry_group_id="entry-group-full",
            project="1111111111111",
            location="us-central1")
        entry_type_full = gcp.dataplex.EntryType("entry-type-full",
            entry_type_id="entry-type-full",
            project="1111111111111",
            location="us-central1",
            required_aspects=[{
                "type": aspect_type_full_one.name,
            }])
        test_entry_full = gcp.dataplex.Entry("test_entry_full",
            entry_group_id=entry_group_full.entry_group_id,
            project="1111111111111",
            location="us-central1",
            entry_id="entry-full/has/slashes",
            entry_type=entry_type_full.name,
            fully_qualified_name="bigquery:1111111111111.test-dataset",
            parent_entry="projects/1111111111111/locations/us-central1/entryGroups/entry-group-full/entries/some-other-entry",
            entry_source={
                "resource": "bigquery:1111111111111.test-dataset",
                "system": "System III",
                "platform": "BigQuery",
                "display_name": "Human readable name",
                "description": "Description from source system",
                "labels": {
                    "some-label": "some-value",
                },
                "ancestors": [
                    {
                        "name": "ancestor-one",
                        "type": "type-one",
                    },
                    {
                        "name": "ancestor-two",
                        "type": "type-two",
                    },
                ],
                "create_time": "2023-08-03T19:19:00.094Z",
                "update_time": "2023-08-03T20:19:00.094Z",
            },
            aspects=[
                {
                    "aspect_key": "1111111111111.us-central1.aspect-type-full-one",
                    "aspect": {
                        "data": "          {\\"type\\": \\"VIEW\\"    }\\n",
                    },
                },
                {
                    "aspect_key": "1111111111111.us-central1.aspect-type-full-two",
                    "aspect": {
                        "data": "          {\\"story\\": \\"SEQUENCE\\"    }\\n",
                    },
                },
            ],
            opts = pulumi.ResourceOptions(depends_on=[
                    aspect_type_full_two,
                    aspect_type_full_one,
                ]))
        ```

        ## Import

        Entry can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/entryGroups/{{entry_group_id}}/entries/{{entry_id}}`

        * `{{project}}/{{location}}/{{entry_group_id}}/{{entry_id}}`

        * `{{location}}/{{entry_group_id}}/{{entry_id}}`

        When using the `pulumi import` command, Entry can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:dataplex/entry:Entry default projects/{{project}}/locations/{{location}}/entryGroups/{{entry_group_id}}/entries/{{entry_id}}
        ```

        ```sh
        $ pulumi import gcp:dataplex/entry:Entry default {{project}}/{{location}}/{{entry_group_id}}/{{entry_id}}
        ```

        ```sh
        $ pulumi import gcp:dataplex/entry:Entry default {{location}}/{{entry_group_id}}/{{entry_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EntryAspectArgs', 'EntryAspectArgsDict']]]] aspects: The aspects that are attached to the entry.
               Structure is documented below.
        :param pulumi.Input[builtins.str] entry_group_id: The entry group id of the entry group the entry will be created in.
        :param pulumi.Input[builtins.str] entry_id: The entry id of the entry.
        :param pulumi.Input[Union['EntryEntrySourceArgs', 'EntryEntrySourceArgsDict']] entry_source: A nested object resource.
               Structure is documented below.
        :param pulumi.Input[builtins.str] entry_type: The relative resource name of the entry type that was used to create this entry, in the format projects/{project_number}/locations/{locationId}/entryTypes/{entryTypeId}.
               
               
               - - -
        :param pulumi.Input[builtins.str] fully_qualified_name: A name for the entry that can be referenced by an external system. For more information, see https://cloud.google.com/dataplex/docs/fully-qualified-names.
               The maximum size of the field is 4000 characters.
        :param pulumi.Input[builtins.str] location: The location where entry will be created.
        :param pulumi.Input[builtins.str] parent_entry: The resource name of the parent entry, in the format projects/{project_number}/locations/{locationId}/entryGroups/{entryGroupId}/entries/{entryId}.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EntryArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        An entry represents a data asset for which you capture metadata, such as a BigQuery table.
        The primary constituents of an entry are aspects, which provide thematically coherent information.
        Examples include a table's schema, sensitive data protection profile, data quality information, or a simple tag.

        **Important Considerations:**

        * There is a limit of 99 aspects per entry.
        * The entry resource has to use project numbers and not project IDs. Therefore, if
          a dependency was already provisioned using project ID, it needs to be referenced explicitly as a resource name
          containing the project number.

        To get more information about Entry, see:

        * [API documentation](https://cloud.google.com/dataplex/docs/reference/rest/v1/projects.locations.entryGroups.entries)
        * How-to Guides
            * [Manage entries and ingest custom sources](https://cloud.google.com/dataplex/docs/ingest-custom-sources)

        ## Example Usage

        ### Dataplex Entry Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        entry_group_basic = gcp.dataplex.EntryGroup("entry-group-basic",
            entry_group_id="entry-group-basic",
            project="1111111111111",
            location="us-central1")
        entry_type_basic = gcp.dataplex.EntryType("entry-type-basic",
            entry_type_id="entry-type-basic",
            project="1111111111111",
            location="us-central1")
        test_basic = gcp.dataplex.Entry("test_basic",
            entry_group_id=entry_group_basic.entry_group_id,
            project="1111111111111",
            location="us-central1",
            entry_id="entry-basic",
            entry_type=entry_type_basic.name)
        ```
        ### Dataplex Entry Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        aspect_type_full_one = gcp.dataplex.AspectType("aspect-type-full-one",
            aspect_type_id="aspect-type-full-one",
            location="us-central1",
            project="1111111111111",
            metadata_template=\"\"\"{
          "name": "tf-test-template",
          "type": "record",
          "recordFields": [
            {
              "name": "type",
              "type": "enum",
              "annotations": {
                "displayName": "Type",
                "description": "Specifies the type of view represented by the entry."
              },
              "index": 1,
              "constraints": {
                "required": true
              },
              "enumValues": [
                {
                  "name": "VIEW",
                  "index": 1
                }
              ]
            }
          ]
        }
        \"\"\")
        aspect_type_full_two = gcp.dataplex.AspectType("aspect-type-full-two",
            aspect_type_id="aspect-type-full-two",
            location="us-central1",
            project="1111111111111",
            metadata_template=\"\"\"{
          "name": "tf-test-template",
          "type": "record",
          "recordFields": [
            {
              "name": "story",
              "type": "enum",
              "annotations": {
                "displayName": "Story",
                "description": "Specifies the story of an entry."
              },
              "index": 1,
              "constraints": {
                "required": true
              },
              "enumValues": [
                {
                  "name": "SEQUENCE",
                  "index": 1
                }
              ]
            }
          ]
        }
        \"\"\")
        entry_group_full = gcp.dataplex.EntryGroup("entry-group-full",
            entry_group_id="entry-group-full",
            project="1111111111111",
            location="us-central1")
        entry_type_full = gcp.dataplex.EntryType("entry-type-full",
            entry_type_id="entry-type-full",
            project="1111111111111",
            location="us-central1",
            required_aspects=[{
                "type": aspect_type_full_one.name,
            }])
        test_entry_full = gcp.dataplex.Entry("test_entry_full",
            entry_group_id=entry_group_full.entry_group_id,
            project="1111111111111",
            location="us-central1",
            entry_id="entry-full/has/slashes",
            entry_type=entry_type_full.name,
            fully_qualified_name="bigquery:1111111111111.test-dataset",
            parent_entry="projects/1111111111111/locations/us-central1/entryGroups/entry-group-full/entries/some-other-entry",
            entry_source={
                "resource": "bigquery:1111111111111.test-dataset",
                "system": "System III",
                "platform": "BigQuery",
                "display_name": "Human readable name",
                "description": "Description from source system",
                "labels": {
                    "some-label": "some-value",
                },
                "ancestors": [
                    {
                        "name": "ancestor-one",
                        "type": "type-one",
                    },
                    {
                        "name": "ancestor-two",
                        "type": "type-two",
                    },
                ],
                "create_time": "2023-08-03T19:19:00.094Z",
                "update_time": "2023-08-03T20:19:00.094Z",
            },
            aspects=[
                {
                    "aspect_key": "1111111111111.us-central1.aspect-type-full-one",
                    "aspect": {
                        "data": "          {\\"type\\": \\"VIEW\\"    }\\n",
                    },
                },
                {
                    "aspect_key": "1111111111111.us-central1.aspect-type-full-two",
                    "aspect": {
                        "data": "          {\\"story\\": \\"SEQUENCE\\"    }\\n",
                    },
                },
            ],
            opts = pulumi.ResourceOptions(depends_on=[
                    aspect_type_full_two,
                    aspect_type_full_one,
                ]))
        ```

        ## Import

        Entry can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/entryGroups/{{entry_group_id}}/entries/{{entry_id}}`

        * `{{project}}/{{location}}/{{entry_group_id}}/{{entry_id}}`

        * `{{location}}/{{entry_group_id}}/{{entry_id}}`

        When using the `pulumi import` command, Entry can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:dataplex/entry:Entry default projects/{{project}}/locations/{{location}}/entryGroups/{{entry_group_id}}/entries/{{entry_id}}
        ```

        ```sh
        $ pulumi import gcp:dataplex/entry:Entry default {{project}}/{{location}}/{{entry_group_id}}/{{entry_id}}
        ```

        ```sh
        $ pulumi import gcp:dataplex/entry:Entry default {{location}}/{{entry_group_id}}/{{entry_id}}
        ```

        :param str resource_name: The name of the resource.
        :param EntryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EntryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aspects: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EntryAspectArgs', 'EntryAspectArgsDict']]]]] = None,
                 entry_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 entry_id: Optional[pulumi.Input[builtins.str]] = None,
                 entry_source: Optional[pulumi.Input[Union['EntryEntrySourceArgs', 'EntryEntrySourceArgsDict']]] = None,
                 entry_type: Optional[pulumi.Input[builtins.str]] = None,
                 fully_qualified_name: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 parent_entry: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EntryArgs.__new__(EntryArgs)

            __props__.__dict__["aspects"] = aspects
            __props__.__dict__["entry_group_id"] = entry_group_id
            __props__.__dict__["entry_id"] = entry_id
            __props__.__dict__["entry_source"] = entry_source
            if entry_type is None and not opts.urn:
                raise TypeError("Missing required property 'entry_type'")
            __props__.__dict__["entry_type"] = entry_type
            __props__.__dict__["fully_qualified_name"] = fully_qualified_name
            __props__.__dict__["location"] = location
            __props__.__dict__["parent_entry"] = parent_entry
            __props__.__dict__["project"] = project
            __props__.__dict__["create_time"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["update_time"] = None
        super(Entry, __self__).__init__(
            'gcp:dataplex/entry:Entry',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            aspects: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EntryAspectArgs', 'EntryAspectArgsDict']]]]] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            entry_group_id: Optional[pulumi.Input[builtins.str]] = None,
            entry_id: Optional[pulumi.Input[builtins.str]] = None,
            entry_source: Optional[pulumi.Input[Union['EntryEntrySourceArgs', 'EntryEntrySourceArgsDict']]] = None,
            entry_type: Optional[pulumi.Input[builtins.str]] = None,
            fully_qualified_name: Optional[pulumi.Input[builtins.str]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            parent_entry: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None) -> 'Entry':
        """
        Get an existing Entry resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EntryAspectArgs', 'EntryAspectArgsDict']]]] aspects: The aspects that are attached to the entry.
               Structure is documented below.
        :param pulumi.Input[builtins.str] create_time: The time when the Entry was created in Dataplex.
        :param pulumi.Input[builtins.str] entry_group_id: The entry group id of the entry group the entry will be created in.
        :param pulumi.Input[builtins.str] entry_id: The entry id of the entry.
        :param pulumi.Input[Union['EntryEntrySourceArgs', 'EntryEntrySourceArgsDict']] entry_source: A nested object resource.
               Structure is documented below.
        :param pulumi.Input[builtins.str] entry_type: The relative resource name of the entry type that was used to create this entry, in the format projects/{project_number}/locations/{locationId}/entryTypes/{entryTypeId}.
               
               
               - - -
        :param pulumi.Input[builtins.str] fully_qualified_name: A name for the entry that can be referenced by an external system. For more information, see https://cloud.google.com/dataplex/docs/fully-qualified-names.
               The maximum size of the field is 4000 characters.
        :param pulumi.Input[builtins.str] location: The location where entry will be created.
        :param pulumi.Input[builtins.str] name: The relative resource name of the entry, in the format projects/{project_number}/locations/{locationId}/entryGroups/{entryGroupId}/entries/{entryId}.
        :param pulumi.Input[builtins.str] parent_entry: The resource name of the parent entry, in the format projects/{project_number}/locations/{locationId}/entryGroups/{entryGroupId}/entries/{entryId}.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] update_time: The time when the entry was last updated in Dataplex.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EntryState.__new__(_EntryState)

        __props__.__dict__["aspects"] = aspects
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["entry_group_id"] = entry_group_id
        __props__.__dict__["entry_id"] = entry_id
        __props__.__dict__["entry_source"] = entry_source
        __props__.__dict__["entry_type"] = entry_type
        __props__.__dict__["fully_qualified_name"] = fully_qualified_name
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["parent_entry"] = parent_entry
        __props__.__dict__["project"] = project
        __props__.__dict__["update_time"] = update_time
        return Entry(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def aspects(self) -> pulumi.Output[Optional[Sequence['outputs.EntryAspect']]]:
        """
        The aspects that are attached to the entry.
        Structure is documented below.
        """
        return pulumi.get(self, "aspects")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        The time when the Entry was created in Dataplex.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="entryGroupId")
    def entry_group_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The entry group id of the entry group the entry will be created in.
        """
        return pulumi.get(self, "entry_group_id")

    @property
    @pulumi.getter(name="entryId")
    def entry_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The entry id of the entry.
        """
        return pulumi.get(self, "entry_id")

    @property
    @pulumi.getter(name="entrySource")
    def entry_source(self) -> pulumi.Output['outputs.EntryEntrySource']:
        """
        A nested object resource.
        Structure is documented below.
        """
        return pulumi.get(self, "entry_source")

    @property
    @pulumi.getter(name="entryType")
    def entry_type(self) -> pulumi.Output[builtins.str]:
        """
        The relative resource name of the entry type that was used to create this entry, in the format projects/{project_number}/locations/{locationId}/entryTypes/{entryTypeId}.


        - - -
        """
        return pulumi.get(self, "entry_type")

    @property
    @pulumi.getter(name="fullyQualifiedName")
    def fully_qualified_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A name for the entry that can be referenced by an external system. For more information, see https://cloud.google.com/dataplex/docs/fully-qualified-names.
        The maximum size of the field is 4000 characters.
        """
        return pulumi.get(self, "fully_qualified_name")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The location where entry will be created.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The relative resource name of the entry, in the format projects/{project_number}/locations/{locationId}/entryGroups/{entryGroupId}/entries/{entryId}.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="parentEntry")
    def parent_entry(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The resource name of the parent entry, in the format projects/{project_number}/locations/{locationId}/entryGroups/{entryGroupId}/entries/{entryId}.
        """
        return pulumi.get(self, "parent_entry")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        The time when the entry was last updated in Dataplex.
        """
        return pulumi.get(self, "update_time")

