# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetZoneIamPolicyResult',
    'AwaitableGetZoneIamPolicyResult',
    'get_zone_iam_policy',
    'get_zone_iam_policy_output',
]

@pulumi.output_type
class GetZoneIamPolicyResult:
    """
    A collection of values returned by getZoneIamPolicy.
    """
    def __init__(__self__, dataplex_zone=None, etag=None, id=None, lake=None, location=None, policy_data=None, project=None):
        if dataplex_zone and not isinstance(dataplex_zone, str):
            raise TypeError("Expected argument 'dataplex_zone' to be a str")
        pulumi.set(__self__, "dataplex_zone", dataplex_zone)
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lake and not isinstance(lake, str):
            raise TypeError("Expected argument 'lake' to be a str")
        pulumi.set(__self__, "lake", lake)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if policy_data and not isinstance(policy_data, str):
            raise TypeError("Expected argument 'policy_data' to be a str")
        pulumi.set(__self__, "policy_data", policy_data)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="dataplexZone")
    def dataplex_zone(self) -> builtins.str:
        return pulumi.get(self, "dataplex_zone")

    @property
    @pulumi.getter
    def etag(self) -> builtins.str:
        """
        (Computed) The etag of the IAM policy.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def lake(self) -> builtins.str:
        return pulumi.get(self, "lake")

    @property
    @pulumi.getter
    def location(self) -> builtins.str:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="policyData")
    def policy_data(self) -> builtins.str:
        """
        (Required only by `dataplex.ZoneIamPolicy`) The policy data generated by
        a `organizations_get_iam_policy` data source.
        """
        return pulumi.get(self, "policy_data")

    @property
    @pulumi.getter
    def project(self) -> builtins.str:
        return pulumi.get(self, "project")


class AwaitableGetZoneIamPolicyResult(GetZoneIamPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetZoneIamPolicyResult(
            dataplex_zone=self.dataplex_zone,
            etag=self.etag,
            id=self.id,
            lake=self.lake,
            location=self.location,
            policy_data=self.policy_data,
            project=self.project)


def get_zone_iam_policy(dataplex_zone: Optional[builtins.str] = None,
                        lake: Optional[builtins.str] = None,
                        location: Optional[builtins.str] = None,
                        project: Optional[builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetZoneIamPolicyResult:
    """
    Retrieves the current IAM policy data for zone

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    policy = gcp.dataplex.get_zone_iam_policy(project=example["project"],
        location=example["location"],
        lake=example["lake"],
        dataplex_zone=example["name"])
    ```


    :param builtins.str dataplex_zone: Used to find the parent resource to bind the IAM policy to
    :param builtins.str lake: Used to find the parent resource to bind the IAM policy to
    :param builtins.str location: Used to find the parent resource to bind the IAM policy to. If not specified,
           the value will be parsed from the identifier of the parent resource. If no location is provided in the parent identifier and no
           location is specified, it is taken from the provider configuration.
    :param builtins.str project: The ID of the project in which the resource belongs.
           If it is not provided, the project will be parsed from the identifier of the parent resource. If no project is provided in the parent identifier and no project is specified, the provider project is used.
    """
    __args__ = dict()
    __args__['dataplexZone'] = dataplex_zone
    __args__['lake'] = lake
    __args__['location'] = location
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:dataplex/getZoneIamPolicy:getZoneIamPolicy', __args__, opts=opts, typ=GetZoneIamPolicyResult).value

    return AwaitableGetZoneIamPolicyResult(
        dataplex_zone=pulumi.get(__ret__, 'dataplex_zone'),
        etag=pulumi.get(__ret__, 'etag'),
        id=pulumi.get(__ret__, 'id'),
        lake=pulumi.get(__ret__, 'lake'),
        location=pulumi.get(__ret__, 'location'),
        policy_data=pulumi.get(__ret__, 'policy_data'),
        project=pulumi.get(__ret__, 'project'))
def get_zone_iam_policy_output(dataplex_zone: Optional[pulumi.Input[builtins.str]] = None,
                               lake: Optional[pulumi.Input[builtins.str]] = None,
                               location: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                               project: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetZoneIamPolicyResult]:
    """
    Retrieves the current IAM policy data for zone

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    policy = gcp.dataplex.get_zone_iam_policy(project=example["project"],
        location=example["location"],
        lake=example["lake"],
        dataplex_zone=example["name"])
    ```


    :param builtins.str dataplex_zone: Used to find the parent resource to bind the IAM policy to
    :param builtins.str lake: Used to find the parent resource to bind the IAM policy to
    :param builtins.str location: Used to find the parent resource to bind the IAM policy to. If not specified,
           the value will be parsed from the identifier of the parent resource. If no location is provided in the parent identifier and no
           location is specified, it is taken from the provider configuration.
    :param builtins.str project: The ID of the project in which the resource belongs.
           If it is not provided, the project will be parsed from the identifier of the parent resource. If no project is provided in the parent identifier and no project is specified, the provider project is used.
    """
    __args__ = dict()
    __args__['dataplexZone'] = dataplex_zone
    __args__['lake'] = lake
    __args__['location'] = location
    __args__['project'] = project
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:dataplex/getZoneIamPolicy:getZoneIamPolicy', __args__, opts=opts, typ=GetZoneIamPolicyResult)
    return __ret__.apply(lambda __response__: GetZoneIamPolicyResult(
        dataplex_zone=pulumi.get(__response__, 'dataplex_zone'),
        etag=pulumi.get(__response__, 'etag'),
        id=pulumi.get(__response__, 'id'),
        lake=pulumi.get(__response__, 'lake'),
        location=pulumi.get(__response__, 'location'),
        policy_data=pulumi.get(__response__, 'policy_data'),
        project=pulumi.get(__response__, 'project')))
