# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BatchArgs', 'Batch']

@pulumi.input_type
class BatchArgs:
    def __init__(__self__, *,
                 batch_id: Optional[pulumi.Input[builtins.str]] = None,
                 environment_config: Optional[pulumi.Input['BatchEnvironmentConfigArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 pyspark_batch: Optional[pulumi.Input['BatchPysparkBatchArgs']] = None,
                 runtime_config: Optional[pulumi.Input['BatchRuntimeConfigArgs']] = None,
                 spark_batch: Optional[pulumi.Input['BatchSparkBatchArgs']] = None,
                 spark_r_batch: Optional[pulumi.Input['BatchSparkRBatchArgs']] = None,
                 spark_sql_batch: Optional[pulumi.Input['BatchSparkSqlBatchArgs']] = None):
        """
        The set of arguments for constructing a Batch resource.
        :param pulumi.Input[builtins.str] batch_id: The ID to use for the batch, which will become the final component of the batch's resource name.
               This value must be 4-63 characters. Valid characters are /[a-z][0-9]-/.
        :param pulumi.Input['BatchEnvironmentConfigArgs'] environment_config: Environment configuration for the batch execution.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: The labels to associate with this batch.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The location in which the batch will be created in.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['BatchPysparkBatchArgs'] pyspark_batch: PySpark batch config.
               Structure is documented below.
        :param pulumi.Input['BatchRuntimeConfigArgs'] runtime_config: Runtime configuration for the batch execution.
               Structure is documented below.
        :param pulumi.Input['BatchSparkBatchArgs'] spark_batch: Spark batch config.
               Structure is documented below.
        :param pulumi.Input['BatchSparkRBatchArgs'] spark_r_batch: SparkR batch config.
               Structure is documented below.
        :param pulumi.Input['BatchSparkSqlBatchArgs'] spark_sql_batch: Spark SQL batch config.
               Structure is documented below.
        """
        if batch_id is not None:
            pulumi.set(__self__, "batch_id", batch_id)
        if environment_config is not None:
            pulumi.set(__self__, "environment_config", environment_config)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pyspark_batch is not None:
            pulumi.set(__self__, "pyspark_batch", pyspark_batch)
        if runtime_config is not None:
            pulumi.set(__self__, "runtime_config", runtime_config)
        if spark_batch is not None:
            pulumi.set(__self__, "spark_batch", spark_batch)
        if spark_r_batch is not None:
            pulumi.set(__self__, "spark_r_batch", spark_r_batch)
        if spark_sql_batch is not None:
            pulumi.set(__self__, "spark_sql_batch", spark_sql_batch)

    @property
    @pulumi.getter(name="batchId")
    def batch_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID to use for the batch, which will become the final component of the batch's resource name.
        This value must be 4-63 characters. Valid characters are /[a-z][0-9]-/.
        """
        return pulumi.get(self, "batch_id")

    @batch_id.setter
    def batch_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "batch_id", value)

    @property
    @pulumi.getter(name="environmentConfig")
    def environment_config(self) -> Optional[pulumi.Input['BatchEnvironmentConfigArgs']]:
        """
        Environment configuration for the batch execution.
        Structure is documented below.
        """
        return pulumi.get(self, "environment_config")

    @environment_config.setter
    def environment_config(self, value: Optional[pulumi.Input['BatchEnvironmentConfigArgs']]):
        pulumi.set(self, "environment_config", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The labels to associate with this batch.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location in which the batch will be created in.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pysparkBatch")
    def pyspark_batch(self) -> Optional[pulumi.Input['BatchPysparkBatchArgs']]:
        """
        PySpark batch config.
        Structure is documented below.
        """
        return pulumi.get(self, "pyspark_batch")

    @pyspark_batch.setter
    def pyspark_batch(self, value: Optional[pulumi.Input['BatchPysparkBatchArgs']]):
        pulumi.set(self, "pyspark_batch", value)

    @property
    @pulumi.getter(name="runtimeConfig")
    def runtime_config(self) -> Optional[pulumi.Input['BatchRuntimeConfigArgs']]:
        """
        Runtime configuration for the batch execution.
        Structure is documented below.
        """
        return pulumi.get(self, "runtime_config")

    @runtime_config.setter
    def runtime_config(self, value: Optional[pulumi.Input['BatchRuntimeConfigArgs']]):
        pulumi.set(self, "runtime_config", value)

    @property
    @pulumi.getter(name="sparkBatch")
    def spark_batch(self) -> Optional[pulumi.Input['BatchSparkBatchArgs']]:
        """
        Spark batch config.
        Structure is documented below.
        """
        return pulumi.get(self, "spark_batch")

    @spark_batch.setter
    def spark_batch(self, value: Optional[pulumi.Input['BatchSparkBatchArgs']]):
        pulumi.set(self, "spark_batch", value)

    @property
    @pulumi.getter(name="sparkRBatch")
    def spark_r_batch(self) -> Optional[pulumi.Input['BatchSparkRBatchArgs']]:
        """
        SparkR batch config.
        Structure is documented below.
        """
        return pulumi.get(self, "spark_r_batch")

    @spark_r_batch.setter
    def spark_r_batch(self, value: Optional[pulumi.Input['BatchSparkRBatchArgs']]):
        pulumi.set(self, "spark_r_batch", value)

    @property
    @pulumi.getter(name="sparkSqlBatch")
    def spark_sql_batch(self) -> Optional[pulumi.Input['BatchSparkSqlBatchArgs']]:
        """
        Spark SQL batch config.
        Structure is documented below.
        """
        return pulumi.get(self, "spark_sql_batch")

    @spark_sql_batch.setter
    def spark_sql_batch(self, value: Optional[pulumi.Input['BatchSparkSqlBatchArgs']]):
        pulumi.set(self, "spark_sql_batch", value)


@pulumi.input_type
class _BatchState:
    def __init__(__self__, *,
                 batch_id: Optional[pulumi.Input[builtins.str]] = None,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 creator: Optional[pulumi.Input[builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 environment_config: Optional[pulumi.Input['BatchEnvironmentConfigArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 operation: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 pyspark_batch: Optional[pulumi.Input['BatchPysparkBatchArgs']] = None,
                 runtime_config: Optional[pulumi.Input['BatchRuntimeConfigArgs']] = None,
                 runtime_infos: Optional[pulumi.Input[Sequence[pulumi.Input['BatchRuntimeInfoArgs']]]] = None,
                 spark_batch: Optional[pulumi.Input['BatchSparkBatchArgs']] = None,
                 spark_r_batch: Optional[pulumi.Input['BatchSparkRBatchArgs']] = None,
                 spark_sql_batch: Optional[pulumi.Input['BatchSparkSqlBatchArgs']] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 state_histories: Optional[pulumi.Input[Sequence[pulumi.Input['BatchStateHistoryArgs']]]] = None,
                 state_message: Optional[pulumi.Input[builtins.str]] = None,
                 state_time: Optional[pulumi.Input[builtins.str]] = None,
                 uuid: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Batch resources.
        :param pulumi.Input[builtins.str] batch_id: The ID to use for the batch, which will become the final component of the batch's resource name.
               This value must be 4-63 characters. Valid characters are /[a-z][0-9]-/.
        :param pulumi.Input[builtins.str] create_time: The time when the batch was created.
        :param pulumi.Input[builtins.str] creator: The email address of the user who created the batch.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input['BatchEnvironmentConfigArgs'] environment_config: Environment configuration for the batch execution.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: The labels to associate with this batch.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The location in which the batch will be created in.
        :param pulumi.Input[builtins.str] name: The resource name of the batch.
        :param pulumi.Input[builtins.str] operation: The resource name of the operation associated with this batch.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input['BatchPysparkBatchArgs'] pyspark_batch: PySpark batch config.
               Structure is documented below.
        :param pulumi.Input['BatchRuntimeConfigArgs'] runtime_config: Runtime configuration for the batch execution.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['BatchRuntimeInfoArgs']]] runtime_infos: Runtime information about batch execution.
               Structure is documented below.
        :param pulumi.Input['BatchSparkBatchArgs'] spark_batch: Spark batch config.
               Structure is documented below.
        :param pulumi.Input['BatchSparkRBatchArgs'] spark_r_batch: SparkR batch config.
               Structure is documented below.
        :param pulumi.Input['BatchSparkSqlBatchArgs'] spark_sql_batch: Spark SQL batch config.
               Structure is documented below.
        :param pulumi.Input[builtins.str] state: (Output)
               The state of the batch at this point in history. For possible values, see the [API documentation](https://cloud.google.com/dataproc-serverless/docs/reference/rest/v1/projects.locations.batches#State).
        :param pulumi.Input[Sequence[pulumi.Input['BatchStateHistoryArgs']]] state_histories: Historical state information for the batch.
               Structure is documented below.
        :param pulumi.Input[builtins.str] state_message: (Output)
               Details about the state at this point in history.
        :param pulumi.Input[builtins.str] state_time: Batch state details, such as a failure description if the state is FAILED.
        :param pulumi.Input[builtins.str] uuid: A batch UUID (Unique Universal Identifier). The service generates this value when it creates the batch.
        """
        if batch_id is not None:
            pulumi.set(__self__, "batch_id", batch_id)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if creator is not None:
            pulumi.set(__self__, "creator", creator)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if environment_config is not None:
            pulumi.set(__self__, "environment_config", environment_config)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if operation is not None:
            pulumi.set(__self__, "operation", operation)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if pyspark_batch is not None:
            pulumi.set(__self__, "pyspark_batch", pyspark_batch)
        if runtime_config is not None:
            pulumi.set(__self__, "runtime_config", runtime_config)
        if runtime_infos is not None:
            pulumi.set(__self__, "runtime_infos", runtime_infos)
        if spark_batch is not None:
            pulumi.set(__self__, "spark_batch", spark_batch)
        if spark_r_batch is not None:
            pulumi.set(__self__, "spark_r_batch", spark_r_batch)
        if spark_sql_batch is not None:
            pulumi.set(__self__, "spark_sql_batch", spark_sql_batch)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if state_histories is not None:
            pulumi.set(__self__, "state_histories", state_histories)
        if state_message is not None:
            pulumi.set(__self__, "state_message", state_message)
        if state_time is not None:
            pulumi.set(__self__, "state_time", state_time)
        if uuid is not None:
            pulumi.set(__self__, "uuid", uuid)

    @property
    @pulumi.getter(name="batchId")
    def batch_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID to use for the batch, which will become the final component of the batch's resource name.
        This value must be 4-63 characters. Valid characters are /[a-z][0-9]-/.
        """
        return pulumi.get(self, "batch_id")

    @batch_id.setter
    def batch_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "batch_id", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time when the batch was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def creator(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The email address of the user who created the batch.
        """
        return pulumi.get(self, "creator")

    @creator.setter
    def creator(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "creator", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter(name="environmentConfig")
    def environment_config(self) -> Optional[pulumi.Input['BatchEnvironmentConfigArgs']]:
        """
        Environment configuration for the batch execution.
        Structure is documented below.
        """
        return pulumi.get(self, "environment_config")

    @environment_config.setter
    def environment_config(self, value: Optional[pulumi.Input['BatchEnvironmentConfigArgs']]):
        pulumi.set(self, "environment_config", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The labels to associate with this batch.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location in which the batch will be created in.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource name of the batch.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def operation(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource name of the operation associated with this batch.
        """
        return pulumi.get(self, "operation")

    @operation.setter
    def operation(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "operation", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter(name="pysparkBatch")
    def pyspark_batch(self) -> Optional[pulumi.Input['BatchPysparkBatchArgs']]:
        """
        PySpark batch config.
        Structure is documented below.
        """
        return pulumi.get(self, "pyspark_batch")

    @pyspark_batch.setter
    def pyspark_batch(self, value: Optional[pulumi.Input['BatchPysparkBatchArgs']]):
        pulumi.set(self, "pyspark_batch", value)

    @property
    @pulumi.getter(name="runtimeConfig")
    def runtime_config(self) -> Optional[pulumi.Input['BatchRuntimeConfigArgs']]:
        """
        Runtime configuration for the batch execution.
        Structure is documented below.
        """
        return pulumi.get(self, "runtime_config")

    @runtime_config.setter
    def runtime_config(self, value: Optional[pulumi.Input['BatchRuntimeConfigArgs']]):
        pulumi.set(self, "runtime_config", value)

    @property
    @pulumi.getter(name="runtimeInfos")
    def runtime_infos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BatchRuntimeInfoArgs']]]]:
        """
        Runtime information about batch execution.
        Structure is documented below.
        """
        return pulumi.get(self, "runtime_infos")

    @runtime_infos.setter
    def runtime_infos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BatchRuntimeInfoArgs']]]]):
        pulumi.set(self, "runtime_infos", value)

    @property
    @pulumi.getter(name="sparkBatch")
    def spark_batch(self) -> Optional[pulumi.Input['BatchSparkBatchArgs']]:
        """
        Spark batch config.
        Structure is documented below.
        """
        return pulumi.get(self, "spark_batch")

    @spark_batch.setter
    def spark_batch(self, value: Optional[pulumi.Input['BatchSparkBatchArgs']]):
        pulumi.set(self, "spark_batch", value)

    @property
    @pulumi.getter(name="sparkRBatch")
    def spark_r_batch(self) -> Optional[pulumi.Input['BatchSparkRBatchArgs']]:
        """
        SparkR batch config.
        Structure is documented below.
        """
        return pulumi.get(self, "spark_r_batch")

    @spark_r_batch.setter
    def spark_r_batch(self, value: Optional[pulumi.Input['BatchSparkRBatchArgs']]):
        pulumi.set(self, "spark_r_batch", value)

    @property
    @pulumi.getter(name="sparkSqlBatch")
    def spark_sql_batch(self) -> Optional[pulumi.Input['BatchSparkSqlBatchArgs']]:
        """
        Spark SQL batch config.
        Structure is documented below.
        """
        return pulumi.get(self, "spark_sql_batch")

    @spark_sql_batch.setter
    def spark_sql_batch(self, value: Optional[pulumi.Input['BatchSparkSqlBatchArgs']]):
        pulumi.set(self, "spark_sql_batch", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Output)
        The state of the batch at this point in history. For possible values, see the [API documentation](https://cloud.google.com/dataproc-serverless/docs/reference/rest/v1/projects.locations.batches#State).
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="stateHistories")
    def state_histories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BatchStateHistoryArgs']]]]:
        """
        Historical state information for the batch.
        Structure is documented below.
        """
        return pulumi.get(self, "state_histories")

    @state_histories.setter
    def state_histories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BatchStateHistoryArgs']]]]):
        pulumi.set(self, "state_histories", value)

    @property
    @pulumi.getter(name="stateMessage")
    def state_message(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Output)
        Details about the state at this point in history.
        """
        return pulumi.get(self, "state_message")

    @state_message.setter
    def state_message(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state_message", value)

    @property
    @pulumi.getter(name="stateTime")
    def state_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Batch state details, such as a failure description if the state is FAILED.
        """
        return pulumi.get(self, "state_time")

    @state_time.setter
    def state_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state_time", value)

    @property
    @pulumi.getter
    def uuid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A batch UUID (Unique Universal Identifier). The service generates this value when it creates the batch.
        """
        return pulumi.get(self, "uuid")

    @uuid.setter
    def uuid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "uuid", value)


@pulumi.type_token("gcp:dataproc/batch:Batch")
class Batch(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 batch_id: Optional[pulumi.Input[builtins.str]] = None,
                 environment_config: Optional[pulumi.Input[Union['BatchEnvironmentConfigArgs', 'BatchEnvironmentConfigArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 pyspark_batch: Optional[pulumi.Input[Union['BatchPysparkBatchArgs', 'BatchPysparkBatchArgsDict']]] = None,
                 runtime_config: Optional[pulumi.Input[Union['BatchRuntimeConfigArgs', 'BatchRuntimeConfigArgsDict']]] = None,
                 spark_batch: Optional[pulumi.Input[Union['BatchSparkBatchArgs', 'BatchSparkBatchArgsDict']]] = None,
                 spark_r_batch: Optional[pulumi.Input[Union['BatchSparkRBatchArgs', 'BatchSparkRBatchArgsDict']]] = None,
                 spark_sql_batch: Optional[pulumi.Input[Union['BatchSparkSqlBatchArgs', 'BatchSparkSqlBatchArgsDict']]] = None,
                 __props__=None):
        """
        Dataproc Serverless Batches lets you run Spark workloads without requiring you to
        provision and manage your own Dataproc cluster.

        To get more information about Batch, see:

        * [API documentation](https://cloud.google.com/dataproc-serverless/docs/reference/rest/v1/projects.locations.batches)
        * How-to Guides
            * [Dataproc Serverless Batches Intro](https://cloud.google.com/dataproc-serverless/docs/overview)

        ## Example Usage

        ### Dataproc Batch Spark

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example_batch_spark = gcp.dataproc.Batch("example_batch_spark",
            batch_id="tf-test-batch_22375",
            location="us-central1",
            labels={
                "batch_test": "terraform",
            },
            runtime_config={
                "properties": {
                    "spark.dynamicAllocation.enabled": "false",
                    "spark.executor.instances": "2",
                },
            },
            environment_config={
                "execution_config": {
                    "subnetwork_uri": "default",
                    "ttl": "3600s",
                    "network_tags": ["tag1"],
                },
            },
            spark_batch={
                "main_class": "org.apache.spark.examples.SparkPi",
                "args": ["10"],
                "jar_file_uris": ["file:///usr/lib/spark/examples/jars/spark-examples.jar"],
            })
        ```
        ### Dataproc Batch Spark Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        gcs_account = gcp.storage.get_project_service_account()
        bucket = gcp.storage.Bucket("bucket",
            uniform_bucket_level_access=True,
            name="dataproc-bucket",
            location="US",
            force_destroy=True)
        crypto_key_member1 = gcp.kms.CryptoKeyIAMMember("crypto_key_member_1",
            crypto_key_id="example-key",
            role="roles/cloudkms.cryptoKeyEncrypterDecrypter",
            member=f"serviceAccount:service-{project.number}@dataproc-accounts.iam.gserviceaccount.com")
        ms = gcp.dataproc.MetastoreService("ms",
            service_id="dataproc-batch",
            location="us-central1",
            port=9080,
            tier="DEVELOPER",
            maintenance_window={
                "hour_of_day": 2,
                "day_of_week": "SUNDAY",
            },
            hive_metastore_config={
                "version": "3.1.2",
            })
        basic = gcp.dataproc.Cluster("basic",
            name="dataproc-batch",
            region="us-central1",
            cluster_config={
                "software_config": {
                    "override_properties": {
                        "dataproc:dataproc.allow.zero.workers": "true",
                        "spark:spark.history.fs.logDirectory": bucket.name.apply(lambda name: f"gs://{name}/*/spark-job-history"),
                    },
                },
                "endpoint_config": {
                    "enable_http_port_access": True,
                },
                "master_config": {
                    "num_instances": 1,
                    "machine_type": "e2-standard-2",
                    "disk_config": {
                        "boot_disk_size_gb": 35,
                    },
                },
                "metastore_config": {
                    "dataproc_metastore_service": ms.name,
                },
            })
        example_batch_spark = gcp.dataproc.Batch("example_batch_spark",
            batch_id="dataproc-batch",
            location="us-central1",
            labels={
                "batch_test": "terraform",
            },
            runtime_config={
                "properties": {
                    "spark.dynamicAllocation.enabled": "false",
                    "spark.executor.instances": "2",
                },
                "version": "2.2",
            },
            environment_config={
                "execution_config": {
                    "ttl": "3600s",
                    "network_tags": ["tag1"],
                    "kms_key": "example-key",
                    "network_uri": "default",
                    "service_account": f"{project.number}-compute@developer.gserviceaccount.com",
                    "staging_bucket": bucket.name,
                },
                "peripherals_config": {
                    "metastore_service": ms.name,
                    "spark_history_server_config": {
                        "dataproc_cluster": basic.id,
                    },
                },
            },
            spark_batch={
                "main_class": "org.apache.spark.examples.SparkPi",
                "args": ["10"],
                "jar_file_uris": ["file:///usr/lib/spark/examples/jars/spark-examples.jar"],
            },
            opts = pulumi.ResourceOptions(depends_on=[crypto_key_member1]))
        ```
        ### Dataproc Batch Sparksql

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example_batch_sparsql = gcp.dataproc.Batch("example_batch_sparsql",
            batch_id="tf-test-batch_29439",
            location="us-central1",
            runtime_config={
                "properties": {
                    "spark.dynamicAllocation.enabled": "false",
                    "spark.executor.instances": "2",
                },
            },
            environment_config={
                "execution_config": {
                    "subnetwork_uri": "default",
                },
            },
            spark_sql_batch={
                "query_file_uri": "gs://dataproc-examples/spark-sql/natality/cigarette_correlations.sql",
                "jar_file_uris": ["file:///usr/lib/spark/examples/jars/spark-examples.jar"],
                "query_variables": {
                    "name": "value",
                },
            })
        ```
        ### Dataproc Batch Pyspark

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example_batch_pyspark = gcp.dataproc.Batch("example_batch_pyspark",
            batch_id="tf-test-batch_87786",
            location="us-central1",
            runtime_config={
                "properties": {
                    "spark.dynamicAllocation.enabled": "false",
                    "spark.executor.instances": "2",
                },
            },
            environment_config={
                "execution_config": {
                    "subnetwork_uri": "default",
                },
            },
            pyspark_batch={
                "main_python_file_uri": "https://storage.googleapis.com/terraform-batches/test_util.py",
                "args": ["10"],
                "jar_file_uris": ["file:///usr/lib/spark/examples/jars/spark-examples.jar"],
                "python_file_uris": ["gs://dataproc-examples/pyspark/hello-world/hello-world.py"],
                "archive_uris": [
                    "https://storage.googleapis.com/terraform-batches/animals.txt.tar.gz#unpacked",
                    "https://storage.googleapis.com/terraform-batches/animals.txt.jar",
                    "https://storage.googleapis.com/terraform-batches/animals.txt",
                ],
                "file_uris": ["https://storage.googleapis.com/terraform-batches/people.txt"],
            })
        ```
        ### Dataproc Batch Sparkr

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example_batch_sparkr = gcp.dataproc.Batch("example_batch_sparkr",
            batch_id="tf-test-batch_2067",
            location="us-central1",
            labels={
                "batch_test": "terraform",
            },
            runtime_config={
                "properties": {
                    "spark.dynamicAllocation.enabled": "false",
                    "spark.executor.instances": "2",
                },
            },
            environment_config={
                "execution_config": {
                    "subnetwork_uri": "default",
                    "ttl": "3600s",
                    "network_tags": ["tag1"],
                },
            },
            spark_r_batch={
                "main_r_file_uri": "https://storage.googleapis.com/terraform-batches/spark-r-flights.r",
                "args": ["https://storage.googleapis.com/terraform-batches/flights.csv"],
            })
        ```
        ### Dataproc Batch Autotuning

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example_batch_autotuning = gcp.dataproc.Batch("example_batch_autotuning",
            batch_id="tf-test-batch_40785",
            location="us-central1",
            labels={
                "batch_test": "terraform",
            },
            runtime_config={
                "version": "2.2",
                "properties": {
                    "spark.dynamicAllocation.enabled": "false",
                    "spark.executor.instances": "2",
                },
                "cohort": "tf-dataproc-batch-example",
                "autotuning_config": {
                    "scenarios": [
                        "SCALING",
                        "MEMORY",
                    ],
                },
            },
            environment_config={
                "execution_config": {
                    "subnetwork_uri": "default",
                    "ttl": "3600s",
                },
            },
            spark_batch={
                "main_class": "org.apache.spark.examples.SparkPi",
                "args": ["10"],
                "jar_file_uris": ["file:///usr/lib/spark/examples/jars/spark-examples.jar"],
            })
        ```

        ## Import

        Batch can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/batches/{{batch_id}}`

        * `{{project}}/{{location}}/{{batch_id}}`

        * `{{location}}/{{batch_id}}`

        When using the `pulumi import` command, Batch can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:dataproc/batch:Batch default projects/{{project}}/locations/{{location}}/batches/{{batch_id}}
        ```

        ```sh
        $ pulumi import gcp:dataproc/batch:Batch default {{project}}/{{location}}/{{batch_id}}
        ```

        ```sh
        $ pulumi import gcp:dataproc/batch:Batch default {{location}}/{{batch_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] batch_id: The ID to use for the batch, which will become the final component of the batch's resource name.
               This value must be 4-63 characters. Valid characters are /[a-z][0-9]-/.
        :param pulumi.Input[Union['BatchEnvironmentConfigArgs', 'BatchEnvironmentConfigArgsDict']] environment_config: Environment configuration for the batch execution.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: The labels to associate with this batch.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The location in which the batch will be created in.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['BatchPysparkBatchArgs', 'BatchPysparkBatchArgsDict']] pyspark_batch: PySpark batch config.
               Structure is documented below.
        :param pulumi.Input[Union['BatchRuntimeConfigArgs', 'BatchRuntimeConfigArgsDict']] runtime_config: Runtime configuration for the batch execution.
               Structure is documented below.
        :param pulumi.Input[Union['BatchSparkBatchArgs', 'BatchSparkBatchArgsDict']] spark_batch: Spark batch config.
               Structure is documented below.
        :param pulumi.Input[Union['BatchSparkRBatchArgs', 'BatchSparkRBatchArgsDict']] spark_r_batch: SparkR batch config.
               Structure is documented below.
        :param pulumi.Input[Union['BatchSparkSqlBatchArgs', 'BatchSparkSqlBatchArgsDict']] spark_sql_batch: Spark SQL batch config.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[BatchArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Dataproc Serverless Batches lets you run Spark workloads without requiring you to
        provision and manage your own Dataproc cluster.

        To get more information about Batch, see:

        * [API documentation](https://cloud.google.com/dataproc-serverless/docs/reference/rest/v1/projects.locations.batches)
        * How-to Guides
            * [Dataproc Serverless Batches Intro](https://cloud.google.com/dataproc-serverless/docs/overview)

        ## Example Usage

        ### Dataproc Batch Spark

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example_batch_spark = gcp.dataproc.Batch("example_batch_spark",
            batch_id="tf-test-batch_22375",
            location="us-central1",
            labels={
                "batch_test": "terraform",
            },
            runtime_config={
                "properties": {
                    "spark.dynamicAllocation.enabled": "false",
                    "spark.executor.instances": "2",
                },
            },
            environment_config={
                "execution_config": {
                    "subnetwork_uri": "default",
                    "ttl": "3600s",
                    "network_tags": ["tag1"],
                },
            },
            spark_batch={
                "main_class": "org.apache.spark.examples.SparkPi",
                "args": ["10"],
                "jar_file_uris": ["file:///usr/lib/spark/examples/jars/spark-examples.jar"],
            })
        ```
        ### Dataproc Batch Spark Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        gcs_account = gcp.storage.get_project_service_account()
        bucket = gcp.storage.Bucket("bucket",
            uniform_bucket_level_access=True,
            name="dataproc-bucket",
            location="US",
            force_destroy=True)
        crypto_key_member1 = gcp.kms.CryptoKeyIAMMember("crypto_key_member_1",
            crypto_key_id="example-key",
            role="roles/cloudkms.cryptoKeyEncrypterDecrypter",
            member=f"serviceAccount:service-{project.number}@dataproc-accounts.iam.gserviceaccount.com")
        ms = gcp.dataproc.MetastoreService("ms",
            service_id="dataproc-batch",
            location="us-central1",
            port=9080,
            tier="DEVELOPER",
            maintenance_window={
                "hour_of_day": 2,
                "day_of_week": "SUNDAY",
            },
            hive_metastore_config={
                "version": "3.1.2",
            })
        basic = gcp.dataproc.Cluster("basic",
            name="dataproc-batch",
            region="us-central1",
            cluster_config={
                "software_config": {
                    "override_properties": {
                        "dataproc:dataproc.allow.zero.workers": "true",
                        "spark:spark.history.fs.logDirectory": bucket.name.apply(lambda name: f"gs://{name}/*/spark-job-history"),
                    },
                },
                "endpoint_config": {
                    "enable_http_port_access": True,
                },
                "master_config": {
                    "num_instances": 1,
                    "machine_type": "e2-standard-2",
                    "disk_config": {
                        "boot_disk_size_gb": 35,
                    },
                },
                "metastore_config": {
                    "dataproc_metastore_service": ms.name,
                },
            })
        example_batch_spark = gcp.dataproc.Batch("example_batch_spark",
            batch_id="dataproc-batch",
            location="us-central1",
            labels={
                "batch_test": "terraform",
            },
            runtime_config={
                "properties": {
                    "spark.dynamicAllocation.enabled": "false",
                    "spark.executor.instances": "2",
                },
                "version": "2.2",
            },
            environment_config={
                "execution_config": {
                    "ttl": "3600s",
                    "network_tags": ["tag1"],
                    "kms_key": "example-key",
                    "network_uri": "default",
                    "service_account": f"{project.number}-compute@developer.gserviceaccount.com",
                    "staging_bucket": bucket.name,
                },
                "peripherals_config": {
                    "metastore_service": ms.name,
                    "spark_history_server_config": {
                        "dataproc_cluster": basic.id,
                    },
                },
            },
            spark_batch={
                "main_class": "org.apache.spark.examples.SparkPi",
                "args": ["10"],
                "jar_file_uris": ["file:///usr/lib/spark/examples/jars/spark-examples.jar"],
            },
            opts = pulumi.ResourceOptions(depends_on=[crypto_key_member1]))
        ```
        ### Dataproc Batch Sparksql

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example_batch_sparsql = gcp.dataproc.Batch("example_batch_sparsql",
            batch_id="tf-test-batch_29439",
            location="us-central1",
            runtime_config={
                "properties": {
                    "spark.dynamicAllocation.enabled": "false",
                    "spark.executor.instances": "2",
                },
            },
            environment_config={
                "execution_config": {
                    "subnetwork_uri": "default",
                },
            },
            spark_sql_batch={
                "query_file_uri": "gs://dataproc-examples/spark-sql/natality/cigarette_correlations.sql",
                "jar_file_uris": ["file:///usr/lib/spark/examples/jars/spark-examples.jar"],
                "query_variables": {
                    "name": "value",
                },
            })
        ```
        ### Dataproc Batch Pyspark

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example_batch_pyspark = gcp.dataproc.Batch("example_batch_pyspark",
            batch_id="tf-test-batch_87786",
            location="us-central1",
            runtime_config={
                "properties": {
                    "spark.dynamicAllocation.enabled": "false",
                    "spark.executor.instances": "2",
                },
            },
            environment_config={
                "execution_config": {
                    "subnetwork_uri": "default",
                },
            },
            pyspark_batch={
                "main_python_file_uri": "https://storage.googleapis.com/terraform-batches/test_util.py",
                "args": ["10"],
                "jar_file_uris": ["file:///usr/lib/spark/examples/jars/spark-examples.jar"],
                "python_file_uris": ["gs://dataproc-examples/pyspark/hello-world/hello-world.py"],
                "archive_uris": [
                    "https://storage.googleapis.com/terraform-batches/animals.txt.tar.gz#unpacked",
                    "https://storage.googleapis.com/terraform-batches/animals.txt.jar",
                    "https://storage.googleapis.com/terraform-batches/animals.txt",
                ],
                "file_uris": ["https://storage.googleapis.com/terraform-batches/people.txt"],
            })
        ```
        ### Dataproc Batch Sparkr

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example_batch_sparkr = gcp.dataproc.Batch("example_batch_sparkr",
            batch_id="tf-test-batch_2067",
            location="us-central1",
            labels={
                "batch_test": "terraform",
            },
            runtime_config={
                "properties": {
                    "spark.dynamicAllocation.enabled": "false",
                    "spark.executor.instances": "2",
                },
            },
            environment_config={
                "execution_config": {
                    "subnetwork_uri": "default",
                    "ttl": "3600s",
                    "network_tags": ["tag1"],
                },
            },
            spark_r_batch={
                "main_r_file_uri": "https://storage.googleapis.com/terraform-batches/spark-r-flights.r",
                "args": ["https://storage.googleapis.com/terraform-batches/flights.csv"],
            })
        ```
        ### Dataproc Batch Autotuning

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example_batch_autotuning = gcp.dataproc.Batch("example_batch_autotuning",
            batch_id="tf-test-batch_40785",
            location="us-central1",
            labels={
                "batch_test": "terraform",
            },
            runtime_config={
                "version": "2.2",
                "properties": {
                    "spark.dynamicAllocation.enabled": "false",
                    "spark.executor.instances": "2",
                },
                "cohort": "tf-dataproc-batch-example",
                "autotuning_config": {
                    "scenarios": [
                        "SCALING",
                        "MEMORY",
                    ],
                },
            },
            environment_config={
                "execution_config": {
                    "subnetwork_uri": "default",
                    "ttl": "3600s",
                },
            },
            spark_batch={
                "main_class": "org.apache.spark.examples.SparkPi",
                "args": ["10"],
                "jar_file_uris": ["file:///usr/lib/spark/examples/jars/spark-examples.jar"],
            })
        ```

        ## Import

        Batch can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/batches/{{batch_id}}`

        * `{{project}}/{{location}}/{{batch_id}}`

        * `{{location}}/{{batch_id}}`

        When using the `pulumi import` command, Batch can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:dataproc/batch:Batch default projects/{{project}}/locations/{{location}}/batches/{{batch_id}}
        ```

        ```sh
        $ pulumi import gcp:dataproc/batch:Batch default {{project}}/{{location}}/{{batch_id}}
        ```

        ```sh
        $ pulumi import gcp:dataproc/batch:Batch default {{location}}/{{batch_id}}
        ```

        :param str resource_name: The name of the resource.
        :param BatchArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BatchArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 batch_id: Optional[pulumi.Input[builtins.str]] = None,
                 environment_config: Optional[pulumi.Input[Union['BatchEnvironmentConfigArgs', 'BatchEnvironmentConfigArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 pyspark_batch: Optional[pulumi.Input[Union['BatchPysparkBatchArgs', 'BatchPysparkBatchArgsDict']]] = None,
                 runtime_config: Optional[pulumi.Input[Union['BatchRuntimeConfigArgs', 'BatchRuntimeConfigArgsDict']]] = None,
                 spark_batch: Optional[pulumi.Input[Union['BatchSparkBatchArgs', 'BatchSparkBatchArgsDict']]] = None,
                 spark_r_batch: Optional[pulumi.Input[Union['BatchSparkRBatchArgs', 'BatchSparkRBatchArgsDict']]] = None,
                 spark_sql_batch: Optional[pulumi.Input[Union['BatchSparkSqlBatchArgs', 'BatchSparkSqlBatchArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BatchArgs.__new__(BatchArgs)

            __props__.__dict__["batch_id"] = batch_id
            __props__.__dict__["environment_config"] = environment_config
            __props__.__dict__["labels"] = labels
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            __props__.__dict__["pyspark_batch"] = pyspark_batch
            __props__.__dict__["runtime_config"] = runtime_config
            __props__.__dict__["spark_batch"] = spark_batch
            __props__.__dict__["spark_r_batch"] = spark_r_batch
            __props__.__dict__["spark_sql_batch"] = spark_sql_batch
            __props__.__dict__["create_time"] = None
            __props__.__dict__["creator"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["operation"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["runtime_infos"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["state_histories"] = None
            __props__.__dict__["state_message"] = None
            __props__.__dict__["state_time"] = None
            __props__.__dict__["uuid"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Batch, __self__).__init__(
            'gcp:dataproc/batch:Batch',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            batch_id: Optional[pulumi.Input[builtins.str]] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            creator: Optional[pulumi.Input[builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            environment_config: Optional[pulumi.Input[Union['BatchEnvironmentConfigArgs', 'BatchEnvironmentConfigArgsDict']]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            operation: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            pyspark_batch: Optional[pulumi.Input[Union['BatchPysparkBatchArgs', 'BatchPysparkBatchArgsDict']]] = None,
            runtime_config: Optional[pulumi.Input[Union['BatchRuntimeConfigArgs', 'BatchRuntimeConfigArgsDict']]] = None,
            runtime_infos: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BatchRuntimeInfoArgs', 'BatchRuntimeInfoArgsDict']]]]] = None,
            spark_batch: Optional[pulumi.Input[Union['BatchSparkBatchArgs', 'BatchSparkBatchArgsDict']]] = None,
            spark_r_batch: Optional[pulumi.Input[Union['BatchSparkRBatchArgs', 'BatchSparkRBatchArgsDict']]] = None,
            spark_sql_batch: Optional[pulumi.Input[Union['BatchSparkSqlBatchArgs', 'BatchSparkSqlBatchArgsDict']]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            state_histories: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BatchStateHistoryArgs', 'BatchStateHistoryArgsDict']]]]] = None,
            state_message: Optional[pulumi.Input[builtins.str]] = None,
            state_time: Optional[pulumi.Input[builtins.str]] = None,
            uuid: Optional[pulumi.Input[builtins.str]] = None) -> 'Batch':
        """
        Get an existing Batch resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] batch_id: The ID to use for the batch, which will become the final component of the batch's resource name.
               This value must be 4-63 characters. Valid characters are /[a-z][0-9]-/.
        :param pulumi.Input[builtins.str] create_time: The time when the batch was created.
        :param pulumi.Input[builtins.str] creator: The email address of the user who created the batch.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Union['BatchEnvironmentConfigArgs', 'BatchEnvironmentConfigArgsDict']] environment_config: Environment configuration for the batch execution.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: The labels to associate with this batch.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The location in which the batch will be created in.
        :param pulumi.Input[builtins.str] name: The resource name of the batch.
        :param pulumi.Input[builtins.str] operation: The resource name of the operation associated with this batch.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[Union['BatchPysparkBatchArgs', 'BatchPysparkBatchArgsDict']] pyspark_batch: PySpark batch config.
               Structure is documented below.
        :param pulumi.Input[Union['BatchRuntimeConfigArgs', 'BatchRuntimeConfigArgsDict']] runtime_config: Runtime configuration for the batch execution.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BatchRuntimeInfoArgs', 'BatchRuntimeInfoArgsDict']]]] runtime_infos: Runtime information about batch execution.
               Structure is documented below.
        :param pulumi.Input[Union['BatchSparkBatchArgs', 'BatchSparkBatchArgsDict']] spark_batch: Spark batch config.
               Structure is documented below.
        :param pulumi.Input[Union['BatchSparkRBatchArgs', 'BatchSparkRBatchArgsDict']] spark_r_batch: SparkR batch config.
               Structure is documented below.
        :param pulumi.Input[Union['BatchSparkSqlBatchArgs', 'BatchSparkSqlBatchArgsDict']] spark_sql_batch: Spark SQL batch config.
               Structure is documented below.
        :param pulumi.Input[builtins.str] state: (Output)
               The state of the batch at this point in history. For possible values, see the [API documentation](https://cloud.google.com/dataproc-serverless/docs/reference/rest/v1/projects.locations.batches#State).
        :param pulumi.Input[Sequence[pulumi.Input[Union['BatchStateHistoryArgs', 'BatchStateHistoryArgsDict']]]] state_histories: Historical state information for the batch.
               Structure is documented below.
        :param pulumi.Input[builtins.str] state_message: (Output)
               Details about the state at this point in history.
        :param pulumi.Input[builtins.str] state_time: Batch state details, such as a failure description if the state is FAILED.
        :param pulumi.Input[builtins.str] uuid: A batch UUID (Unique Universal Identifier). The service generates this value when it creates the batch.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BatchState.__new__(_BatchState)

        __props__.__dict__["batch_id"] = batch_id
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["creator"] = creator
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["environment_config"] = environment_config
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["operation"] = operation
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["pyspark_batch"] = pyspark_batch
        __props__.__dict__["runtime_config"] = runtime_config
        __props__.__dict__["runtime_infos"] = runtime_infos
        __props__.__dict__["spark_batch"] = spark_batch
        __props__.__dict__["spark_r_batch"] = spark_r_batch
        __props__.__dict__["spark_sql_batch"] = spark_sql_batch
        __props__.__dict__["state"] = state
        __props__.__dict__["state_histories"] = state_histories
        __props__.__dict__["state_message"] = state_message
        __props__.__dict__["state_time"] = state_time
        __props__.__dict__["uuid"] = uuid
        return Batch(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="batchId")
    def batch_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ID to use for the batch, which will become the final component of the batch's resource name.
        This value must be 4-63 characters. Valid characters are /[a-z][0-9]-/.
        """
        return pulumi.get(self, "batch_id")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        The time when the batch was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def creator(self) -> pulumi.Output[builtins.str]:
        """
        The email address of the user who created the batch.
        """
        return pulumi.get(self, "creator")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter(name="environmentConfig")
    def environment_config(self) -> pulumi.Output[Optional['outputs.BatchEnvironmentConfig']]:
        """
        Environment configuration for the batch execution.
        Structure is documented below.
        """
        return pulumi.get(self, "environment_config")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        The labels to associate with this batch.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The location in which the batch will be created in.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The resource name of the batch.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def operation(self) -> pulumi.Output[builtins.str]:
        """
        The resource name of the operation associated with this batch.
        """
        return pulumi.get(self, "operation")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter(name="pysparkBatch")
    def pyspark_batch(self) -> pulumi.Output[Optional['outputs.BatchPysparkBatch']]:
        """
        PySpark batch config.
        Structure is documented below.
        """
        return pulumi.get(self, "pyspark_batch")

    @property
    @pulumi.getter(name="runtimeConfig")
    def runtime_config(self) -> pulumi.Output[Optional['outputs.BatchRuntimeConfig']]:
        """
        Runtime configuration for the batch execution.
        Structure is documented below.
        """
        return pulumi.get(self, "runtime_config")

    @property
    @pulumi.getter(name="runtimeInfos")
    def runtime_infos(self) -> pulumi.Output[Sequence['outputs.BatchRuntimeInfo']]:
        """
        Runtime information about batch execution.
        Structure is documented below.
        """
        return pulumi.get(self, "runtime_infos")

    @property
    @pulumi.getter(name="sparkBatch")
    def spark_batch(self) -> pulumi.Output[Optional['outputs.BatchSparkBatch']]:
        """
        Spark batch config.
        Structure is documented below.
        """
        return pulumi.get(self, "spark_batch")

    @property
    @pulumi.getter(name="sparkRBatch")
    def spark_r_batch(self) -> pulumi.Output[Optional['outputs.BatchSparkRBatch']]:
        """
        SparkR batch config.
        Structure is documented below.
        """
        return pulumi.get(self, "spark_r_batch")

    @property
    @pulumi.getter(name="sparkSqlBatch")
    def spark_sql_batch(self) -> pulumi.Output[Optional['outputs.BatchSparkSqlBatch']]:
        """
        Spark SQL batch config.
        Structure is documented below.
        """
        return pulumi.get(self, "spark_sql_batch")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        (Output)
        The state of the batch at this point in history. For possible values, see the [API documentation](https://cloud.google.com/dataproc-serverless/docs/reference/rest/v1/projects.locations.batches#State).
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stateHistories")
    def state_histories(self) -> pulumi.Output[Sequence['outputs.BatchStateHistory']]:
        """
        Historical state information for the batch.
        Structure is documented below.
        """
        return pulumi.get(self, "state_histories")

    @property
    @pulumi.getter(name="stateMessage")
    def state_message(self) -> pulumi.Output[builtins.str]:
        """
        (Output)
        Details about the state at this point in history.
        """
        return pulumi.get(self, "state_message")

    @property
    @pulumi.getter(name="stateTime")
    def state_time(self) -> pulumi.Output[builtins.str]:
        """
        Batch state details, such as a failure description if the state is FAILED.
        """
        return pulumi.get(self, "state_time")

    @property
    @pulumi.getter
    def uuid(self) -> pulumi.Output[builtins.str]:
        """
        A batch UUID (Unique Universal Identifier). The service generates this value when it creates the batch.
        """
        return pulumi.get(self, "uuid")

