# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetAutoscalingPolicyIamPolicyResult',
    'AwaitableGetAutoscalingPolicyIamPolicyResult',
    'get_autoscaling_policy_iam_policy',
    'get_autoscaling_policy_iam_policy_output',
]

@pulumi.output_type
class GetAutoscalingPolicyIamPolicyResult:
    """
    A collection of values returned by getAutoscalingPolicyIamPolicy.
    """
    def __init__(__self__, etag=None, id=None, location=None, policy_data=None, policy_id=None, project=None):
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if policy_data and not isinstance(policy_data, str):
            raise TypeError("Expected argument 'policy_data' to be a str")
        pulumi.set(__self__, "policy_data", policy_data)
        if policy_id and not isinstance(policy_id, str):
            raise TypeError("Expected argument 'policy_id' to be a str")
        pulumi.set(__self__, "policy_id", policy_id)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter
    def etag(self) -> builtins.str:
        """
        (Computed) The etag of the IAM policy.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> builtins.str:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="policyData")
    def policy_data(self) -> builtins.str:
        """
        (Required only by `dataproc.AutoscalingPolicyIamPolicy`) The policy data generated by
        a `organizations_get_iam_policy` data source.
        """
        return pulumi.get(self, "policy_data")

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> builtins.str:
        return pulumi.get(self, "policy_id")

    @property
    @pulumi.getter
    def project(self) -> builtins.str:
        return pulumi.get(self, "project")


class AwaitableGetAutoscalingPolicyIamPolicyResult(GetAutoscalingPolicyIamPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAutoscalingPolicyIamPolicyResult(
            etag=self.etag,
            id=self.id,
            location=self.location,
            policy_data=self.policy_data,
            policy_id=self.policy_id,
            project=self.project)


def get_autoscaling_policy_iam_policy(location: Optional[builtins.str] = None,
                                      policy_id: Optional[builtins.str] = None,
                                      project: Optional[builtins.str] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAutoscalingPolicyIamPolicyResult:
    """
    Retrieves the current IAM policy data for autoscalingpolicy

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    policy = gcp.dataproc.get_autoscaling_policy_iam_policy(project=basic["project"],
        location=basic["location"],
        policy_id=basic["policyId"])
    ```


    :param builtins.str location: The  location where the autoscaling policy should reside.
           The default value is `global`.
           Used to find the parent resource to bind the IAM policy to. If not specified,
           the value will be parsed from the identifier of the parent resource. If no location is provided in the parent identifier and no
           location is specified, it is taken from the provider configuration.
    :param builtins.str policy_id: Used to find the parent resource to bind the IAM policy to
    :param builtins.str project: The ID of the project in which the resource belongs.
           If it is not provided, the project will be parsed from the identifier of the parent resource. If no project is provided in the parent identifier and no project is specified, the provider project is used.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['policyId'] = policy_id
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:dataproc/getAutoscalingPolicyIamPolicy:getAutoscalingPolicyIamPolicy', __args__, opts=opts, typ=GetAutoscalingPolicyIamPolicyResult).value

    return AwaitableGetAutoscalingPolicyIamPolicyResult(
        etag=pulumi.get(__ret__, 'etag'),
        id=pulumi.get(__ret__, 'id'),
        location=pulumi.get(__ret__, 'location'),
        policy_data=pulumi.get(__ret__, 'policy_data'),
        policy_id=pulumi.get(__ret__, 'policy_id'),
        project=pulumi.get(__ret__, 'project'))
def get_autoscaling_policy_iam_policy_output(location: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                             policy_id: Optional[pulumi.Input[builtins.str]] = None,
                                             project: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAutoscalingPolicyIamPolicyResult]:
    """
    Retrieves the current IAM policy data for autoscalingpolicy

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    policy = gcp.dataproc.get_autoscaling_policy_iam_policy(project=basic["project"],
        location=basic["location"],
        policy_id=basic["policyId"])
    ```


    :param builtins.str location: The  location where the autoscaling policy should reside.
           The default value is `global`.
           Used to find the parent resource to bind the IAM policy to. If not specified,
           the value will be parsed from the identifier of the parent resource. If no location is provided in the parent identifier and no
           location is specified, it is taken from the provider configuration.
    :param builtins.str policy_id: Used to find the parent resource to bind the IAM policy to
    :param builtins.str project: The ID of the project in which the resource belongs.
           If it is not provided, the project will be parsed from the identifier of the parent resource. If no project is provided in the parent identifier and no project is specified, the provider project is used.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['policyId'] = policy_id
    __args__['project'] = project
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:dataproc/getAutoscalingPolicyIamPolicy:getAutoscalingPolicyIamPolicy', __args__, opts=opts, typ=GetAutoscalingPolicyIamPolicyResult)
    return __ret__.apply(lambda __response__: GetAutoscalingPolicyIamPolicyResult(
        etag=pulumi.get(__response__, 'etag'),
        id=pulumi.get(__response__, 'id'),
        location=pulumi.get(__response__, 'location'),
        policy_data=pulumi.get(__response__, 'policy_data'),
        policy_id=pulumi.get(__response__, 'policy_id'),
        project=pulumi.get(__response__, 'project')))
