# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SessionTemplateArgs', 'SessionTemplate']

@pulumi.input_type
class SessionTemplateArgs:
    def __init__(__self__, *,
                 environment_config: Optional[pulumi.Input['SessionTemplateEnvironmentConfigArgs']] = None,
                 jupyter_session: Optional[pulumi.Input['SessionTemplateJupyterSessionArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 runtime_config: Optional[pulumi.Input['SessionTemplateRuntimeConfigArgs']] = None,
                 spark_connect_session: Optional[pulumi.Input['SessionTemplateSparkConnectSessionArgs']] = None):
        """
        The set of arguments for constructing a SessionTemplate resource.
        :param pulumi.Input['SessionTemplateEnvironmentConfigArgs'] environment_config: Environment configuration for the session execution.
               Structure is documented below.
        :param pulumi.Input['SessionTemplateJupyterSessionArgs'] jupyter_session: Jupyter configuration for an interactive session.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: The labels to associate with this session template.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The location in which the session template will be created in.
        :param pulumi.Input[builtins.str] name: The resource name of the session template in the following format:
               projects/{project}/locations/{location}/sessionTemplates/{template_id}
               
               
               - - -
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['SessionTemplateRuntimeConfigArgs'] runtime_config: Runtime configuration for the session template.
               Structure is documented below.
        :param pulumi.Input['SessionTemplateSparkConnectSessionArgs'] spark_connect_session: Spark connect configuration for an interactive session.
        """
        if environment_config is not None:
            pulumi.set(__self__, "environment_config", environment_config)
        if jupyter_session is not None:
            pulumi.set(__self__, "jupyter_session", jupyter_session)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if runtime_config is not None:
            pulumi.set(__self__, "runtime_config", runtime_config)
        if spark_connect_session is not None:
            pulumi.set(__self__, "spark_connect_session", spark_connect_session)

    @property
    @pulumi.getter(name="environmentConfig")
    def environment_config(self) -> Optional[pulumi.Input['SessionTemplateEnvironmentConfigArgs']]:
        """
        Environment configuration for the session execution.
        Structure is documented below.
        """
        return pulumi.get(self, "environment_config")

    @environment_config.setter
    def environment_config(self, value: Optional[pulumi.Input['SessionTemplateEnvironmentConfigArgs']]):
        pulumi.set(self, "environment_config", value)

    @property
    @pulumi.getter(name="jupyterSession")
    def jupyter_session(self) -> Optional[pulumi.Input['SessionTemplateJupyterSessionArgs']]:
        """
        Jupyter configuration for an interactive session.
        Structure is documented below.
        """
        return pulumi.get(self, "jupyter_session")

    @jupyter_session.setter
    def jupyter_session(self, value: Optional[pulumi.Input['SessionTemplateJupyterSessionArgs']]):
        pulumi.set(self, "jupyter_session", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The labels to associate with this session template.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location in which the session template will be created in.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource name of the session template in the following format:
        projects/{project}/locations/{location}/sessionTemplates/{template_id}


        - - -
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="runtimeConfig")
    def runtime_config(self) -> Optional[pulumi.Input['SessionTemplateRuntimeConfigArgs']]:
        """
        Runtime configuration for the session template.
        Structure is documented below.
        """
        return pulumi.get(self, "runtime_config")

    @runtime_config.setter
    def runtime_config(self, value: Optional[pulumi.Input['SessionTemplateRuntimeConfigArgs']]):
        pulumi.set(self, "runtime_config", value)

    @property
    @pulumi.getter(name="sparkConnectSession")
    def spark_connect_session(self) -> Optional[pulumi.Input['SessionTemplateSparkConnectSessionArgs']]:
        """
        Spark connect configuration for an interactive session.
        """
        return pulumi.get(self, "spark_connect_session")

    @spark_connect_session.setter
    def spark_connect_session(self, value: Optional[pulumi.Input['SessionTemplateSparkConnectSessionArgs']]):
        pulumi.set(self, "spark_connect_session", value)


@pulumi.input_type
class _SessionTemplateState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 creator: Optional[pulumi.Input[builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 environment_config: Optional[pulumi.Input['SessionTemplateEnvironmentConfigArgs']] = None,
                 jupyter_session: Optional[pulumi.Input['SessionTemplateJupyterSessionArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 runtime_config: Optional[pulumi.Input['SessionTemplateRuntimeConfigArgs']] = None,
                 spark_connect_session: Optional[pulumi.Input['SessionTemplateSparkConnectSessionArgs']] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None,
                 uuid: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering SessionTemplate resources.
        :param pulumi.Input[builtins.str] create_time: The time when the session template was created.
        :param pulumi.Input[builtins.str] creator: The email address of the user who created the session template.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input['SessionTemplateEnvironmentConfigArgs'] environment_config: Environment configuration for the session execution.
               Structure is documented below.
        :param pulumi.Input['SessionTemplateJupyterSessionArgs'] jupyter_session: Jupyter configuration for an interactive session.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: The labels to associate with this session template.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The location in which the session template will be created in.
        :param pulumi.Input[builtins.str] name: The resource name of the session template in the following format:
               projects/{project}/locations/{location}/sessionTemplates/{template_id}
               
               
               - - -
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input['SessionTemplateRuntimeConfigArgs'] runtime_config: Runtime configuration for the session template.
               Structure is documented below.
        :param pulumi.Input['SessionTemplateSparkConnectSessionArgs'] spark_connect_session: Spark connect configuration for an interactive session.
        :param pulumi.Input[builtins.str] update_time: The time when the session template was updated.
        :param pulumi.Input[builtins.str] uuid: A session template UUID (Unique Universal Identifier). The service generates this value when it creates the session template.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if creator is not None:
            pulumi.set(__self__, "creator", creator)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if environment_config is not None:
            pulumi.set(__self__, "environment_config", environment_config)
        if jupyter_session is not None:
            pulumi.set(__self__, "jupyter_session", jupyter_session)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if runtime_config is not None:
            pulumi.set(__self__, "runtime_config", runtime_config)
        if spark_connect_session is not None:
            pulumi.set(__self__, "spark_connect_session", spark_connect_session)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if uuid is not None:
            pulumi.set(__self__, "uuid", uuid)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time when the session template was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def creator(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The email address of the user who created the session template.
        """
        return pulumi.get(self, "creator")

    @creator.setter
    def creator(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "creator", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter(name="environmentConfig")
    def environment_config(self) -> Optional[pulumi.Input['SessionTemplateEnvironmentConfigArgs']]:
        """
        Environment configuration for the session execution.
        Structure is documented below.
        """
        return pulumi.get(self, "environment_config")

    @environment_config.setter
    def environment_config(self, value: Optional[pulumi.Input['SessionTemplateEnvironmentConfigArgs']]):
        pulumi.set(self, "environment_config", value)

    @property
    @pulumi.getter(name="jupyterSession")
    def jupyter_session(self) -> Optional[pulumi.Input['SessionTemplateJupyterSessionArgs']]:
        """
        Jupyter configuration for an interactive session.
        Structure is documented below.
        """
        return pulumi.get(self, "jupyter_session")

    @jupyter_session.setter
    def jupyter_session(self, value: Optional[pulumi.Input['SessionTemplateJupyterSessionArgs']]):
        pulumi.set(self, "jupyter_session", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The labels to associate with this session template.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location in which the session template will be created in.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource name of the session template in the following format:
        projects/{project}/locations/{location}/sessionTemplates/{template_id}


        - - -
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter(name="runtimeConfig")
    def runtime_config(self) -> Optional[pulumi.Input['SessionTemplateRuntimeConfigArgs']]:
        """
        Runtime configuration for the session template.
        Structure is documented below.
        """
        return pulumi.get(self, "runtime_config")

    @runtime_config.setter
    def runtime_config(self, value: Optional[pulumi.Input['SessionTemplateRuntimeConfigArgs']]):
        pulumi.set(self, "runtime_config", value)

    @property
    @pulumi.getter(name="sparkConnectSession")
    def spark_connect_session(self) -> Optional[pulumi.Input['SessionTemplateSparkConnectSessionArgs']]:
        """
        Spark connect configuration for an interactive session.
        """
        return pulumi.get(self, "spark_connect_session")

    @spark_connect_session.setter
    def spark_connect_session(self, value: Optional[pulumi.Input['SessionTemplateSparkConnectSessionArgs']]):
        pulumi.set(self, "spark_connect_session", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time when the session template was updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)

    @property
    @pulumi.getter
    def uuid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A session template UUID (Unique Universal Identifier). The service generates this value when it creates the session template.
        """
        return pulumi.get(self, "uuid")

    @uuid.setter
    def uuid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "uuid", value)


@pulumi.type_token("gcp:dataproc/sessionTemplate:SessionTemplate")
class SessionTemplate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 environment_config: Optional[pulumi.Input[Union['SessionTemplateEnvironmentConfigArgs', 'SessionTemplateEnvironmentConfigArgsDict']]] = None,
                 jupyter_session: Optional[pulumi.Input[Union['SessionTemplateJupyterSessionArgs', 'SessionTemplateJupyterSessionArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 runtime_config: Optional[pulumi.Input[Union['SessionTemplateRuntimeConfigArgs', 'SessionTemplateRuntimeConfigArgsDict']]] = None,
                 spark_connect_session: Optional[pulumi.Input[Union['SessionTemplateSparkConnectSessionArgs', 'SessionTemplateSparkConnectSessionArgsDict']]] = None,
                 __props__=None):
        """
        A Dataproc Serverless session template defines the configuration settings for
        creating one or more Dataproc Serverless interactive sessions.

        To get more information about SessionTemplate, see:

        * [API documentation](https://cloud.google.com/dataproc-serverless/docs/reference/rest/v1/projects.locations.sessionTemplates)
        * How-to Guides
            * [Dataproc Serverless Session Templates](https://cloud.google.com/dataproc-serverless/docs/guides/create-serverless-sessions-templates#create-dataproc-serverless-session-template)

        ## Example Usage

        ### Dataproc Session Templates Jupyter

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example_session_templates_jupyter = gcp.dataproc.SessionTemplate("example_session_templates_jupyter",
            name="projects/my-project-name/locations/us-central1/sessionTemplates/jupyter-session-template",
            location="us-central1",
            labels={
                "session_template_test": "terraform",
            },
            runtime_config={
                "properties": {
                    "spark.dynamicAllocation.enabled": "false",
                    "spark.executor.instances": "2",
                },
            },
            environment_config={
                "execution_config": {
                    "subnetwork_uri": "default",
                    "ttl": "3600s",
                    "network_tags": ["tag1"],
                },
            },
            jupyter_session={
                "kernel": "PYTHON",
                "display_name": "tf python kernel",
            })
        ```
        ### Dataproc Session Templates Jupyter Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        gcs_account = gcp.storage.get_project_service_account()
        bucket = gcp.storage.Bucket("bucket",
            uniform_bucket_level_access=True,
            name="dataproc-bucket",
            location="US",
            force_destroy=True)
        crypto_key_member1 = gcp.kms.CryptoKeyIAMMember("crypto_key_member_1",
            crypto_key_id="example-key",
            role="roles/cloudkms.cryptoKeyEncrypterDecrypter",
            member=f"serviceAccount:service-{project.number}@dataproc-accounts.iam.gserviceaccount.com")
        ms = gcp.dataproc.MetastoreService("ms",
            service_id="jupyter-session-template",
            location="us-central1",
            port=9080,
            tier="DEVELOPER",
            maintenance_window={
                "hour_of_day": 2,
                "day_of_week": "SUNDAY",
            },
            hive_metastore_config={
                "version": "3.1.2",
            },
            network_config={
                "consumers": [{
                    "subnetwork": "projects/my-project-name/regions/us-central1/subnetworks/default",
                }],
            })
        basic = gcp.dataproc.Cluster("basic",
            name="jupyter-session-template",
            region="us-central1",
            cluster_config={
                "software_config": {
                    "override_properties": {
                        "dataproc:dataproc.allow.zero.workers": "true",
                        "spark:spark.history.fs.logDirectory": bucket.name.apply(lambda name: f"gs://{name}/*/spark-job-history"),
                    },
                },
                "gce_cluster_config": {
                    "subnetwork": "default",
                },
                "endpoint_config": {
                    "enable_http_port_access": True,
                },
                "master_config": {
                    "num_instances": 1,
                    "machine_type": "e2-standard-2",
                    "disk_config": {
                        "boot_disk_size_gb": 35,
                    },
                },
                "metastore_config": {
                    "dataproc_metastore_service": ms.name,
                },
            })
        dataproc_session_templates_jupyter_full = gcp.dataproc.SessionTemplate("dataproc_session_templates_jupyter_full",
            name="projects/my-project-name/locations/us-central1/sessionTemplates/jupyter-session-template",
            location="us-central1",
            labels={
                "session_template_test": "terraform",
            },
            runtime_config={
                "properties": {
                    "spark.dynamicAllocation.enabled": "false",
                    "spark.executor.instances": "2",
                },
                "version": "2.2",
                "container_image": "us-docker.pkg.dev/my-project-name/s8s-spark-test-images/s8s-spark:latest",
            },
            environment_config={
                "execution_config": {
                    "ttl": "3600s",
                    "network_tags": ["tag1"],
                    "kms_key": "example-key",
                    "subnetwork_uri": "default",
                    "service_account": f"{project.number}-compute@developer.gserviceaccount.com",
                    "staging_bucket": bucket.name,
                },
                "peripherals_config": {
                    "metastore_service": ms.name,
                    "spark_history_server_config": {
                        "dataproc_cluster": basic.id,
                    },
                },
            },
            jupyter_session={
                "kernel": "PYTHON",
                "display_name": "tf python kernel",
            },
            opts = pulumi.ResourceOptions(depends_on=[crypto_key_member1]))
        ```
        ### Dataproc Session Templates Spark Connect

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example_session_templates_spark_connect = gcp.dataproc.SessionTemplate("example_session_templates_spark_connect",
            name="projects/my-project-name/locations/us-central1/sessionTemplates/sc-session-template",
            location="us-central1",
            labels={
                "session_template_test": "terraform",
            },
            runtime_config={
                "properties": {
                    "spark.dynamicAllocation.enabled": "false",
                    "spark.executor.instances": "2",
                },
            },
            environment_config={
                "execution_config": {
                    "subnetwork_uri": "default",
                    "ttl": "3600s",
                    "network_tags": ["tag1"],
                },
            })
        ```

        ## Import

        SessionTemplate can be imported using any of these accepted formats:

        * `{{name}}`

        When using the `pulumi import` command, SessionTemplate can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:dataproc/sessionTemplate:SessionTemplate default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['SessionTemplateEnvironmentConfigArgs', 'SessionTemplateEnvironmentConfigArgsDict']] environment_config: Environment configuration for the session execution.
               Structure is documented below.
        :param pulumi.Input[Union['SessionTemplateJupyterSessionArgs', 'SessionTemplateJupyterSessionArgsDict']] jupyter_session: Jupyter configuration for an interactive session.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: The labels to associate with this session template.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The location in which the session template will be created in.
        :param pulumi.Input[builtins.str] name: The resource name of the session template in the following format:
               projects/{project}/locations/{location}/sessionTemplates/{template_id}
               
               
               - - -
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['SessionTemplateRuntimeConfigArgs', 'SessionTemplateRuntimeConfigArgsDict']] runtime_config: Runtime configuration for the session template.
               Structure is documented below.
        :param pulumi.Input[Union['SessionTemplateSparkConnectSessionArgs', 'SessionTemplateSparkConnectSessionArgsDict']] spark_connect_session: Spark connect configuration for an interactive session.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[SessionTemplateArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Dataproc Serverless session template defines the configuration settings for
        creating one or more Dataproc Serverless interactive sessions.

        To get more information about SessionTemplate, see:

        * [API documentation](https://cloud.google.com/dataproc-serverless/docs/reference/rest/v1/projects.locations.sessionTemplates)
        * How-to Guides
            * [Dataproc Serverless Session Templates](https://cloud.google.com/dataproc-serverless/docs/guides/create-serverless-sessions-templates#create-dataproc-serverless-session-template)

        ## Example Usage

        ### Dataproc Session Templates Jupyter

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example_session_templates_jupyter = gcp.dataproc.SessionTemplate("example_session_templates_jupyter",
            name="projects/my-project-name/locations/us-central1/sessionTemplates/jupyter-session-template",
            location="us-central1",
            labels={
                "session_template_test": "terraform",
            },
            runtime_config={
                "properties": {
                    "spark.dynamicAllocation.enabled": "false",
                    "spark.executor.instances": "2",
                },
            },
            environment_config={
                "execution_config": {
                    "subnetwork_uri": "default",
                    "ttl": "3600s",
                    "network_tags": ["tag1"],
                },
            },
            jupyter_session={
                "kernel": "PYTHON",
                "display_name": "tf python kernel",
            })
        ```
        ### Dataproc Session Templates Jupyter Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        gcs_account = gcp.storage.get_project_service_account()
        bucket = gcp.storage.Bucket("bucket",
            uniform_bucket_level_access=True,
            name="dataproc-bucket",
            location="US",
            force_destroy=True)
        crypto_key_member1 = gcp.kms.CryptoKeyIAMMember("crypto_key_member_1",
            crypto_key_id="example-key",
            role="roles/cloudkms.cryptoKeyEncrypterDecrypter",
            member=f"serviceAccount:service-{project.number}@dataproc-accounts.iam.gserviceaccount.com")
        ms = gcp.dataproc.MetastoreService("ms",
            service_id="jupyter-session-template",
            location="us-central1",
            port=9080,
            tier="DEVELOPER",
            maintenance_window={
                "hour_of_day": 2,
                "day_of_week": "SUNDAY",
            },
            hive_metastore_config={
                "version": "3.1.2",
            },
            network_config={
                "consumers": [{
                    "subnetwork": "projects/my-project-name/regions/us-central1/subnetworks/default",
                }],
            })
        basic = gcp.dataproc.Cluster("basic",
            name="jupyter-session-template",
            region="us-central1",
            cluster_config={
                "software_config": {
                    "override_properties": {
                        "dataproc:dataproc.allow.zero.workers": "true",
                        "spark:spark.history.fs.logDirectory": bucket.name.apply(lambda name: f"gs://{name}/*/spark-job-history"),
                    },
                },
                "gce_cluster_config": {
                    "subnetwork": "default",
                },
                "endpoint_config": {
                    "enable_http_port_access": True,
                },
                "master_config": {
                    "num_instances": 1,
                    "machine_type": "e2-standard-2",
                    "disk_config": {
                        "boot_disk_size_gb": 35,
                    },
                },
                "metastore_config": {
                    "dataproc_metastore_service": ms.name,
                },
            })
        dataproc_session_templates_jupyter_full = gcp.dataproc.SessionTemplate("dataproc_session_templates_jupyter_full",
            name="projects/my-project-name/locations/us-central1/sessionTemplates/jupyter-session-template",
            location="us-central1",
            labels={
                "session_template_test": "terraform",
            },
            runtime_config={
                "properties": {
                    "spark.dynamicAllocation.enabled": "false",
                    "spark.executor.instances": "2",
                },
                "version": "2.2",
                "container_image": "us-docker.pkg.dev/my-project-name/s8s-spark-test-images/s8s-spark:latest",
            },
            environment_config={
                "execution_config": {
                    "ttl": "3600s",
                    "network_tags": ["tag1"],
                    "kms_key": "example-key",
                    "subnetwork_uri": "default",
                    "service_account": f"{project.number}-compute@developer.gserviceaccount.com",
                    "staging_bucket": bucket.name,
                },
                "peripherals_config": {
                    "metastore_service": ms.name,
                    "spark_history_server_config": {
                        "dataproc_cluster": basic.id,
                    },
                },
            },
            jupyter_session={
                "kernel": "PYTHON",
                "display_name": "tf python kernel",
            },
            opts = pulumi.ResourceOptions(depends_on=[crypto_key_member1]))
        ```
        ### Dataproc Session Templates Spark Connect

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example_session_templates_spark_connect = gcp.dataproc.SessionTemplate("example_session_templates_spark_connect",
            name="projects/my-project-name/locations/us-central1/sessionTemplates/sc-session-template",
            location="us-central1",
            labels={
                "session_template_test": "terraform",
            },
            runtime_config={
                "properties": {
                    "spark.dynamicAllocation.enabled": "false",
                    "spark.executor.instances": "2",
                },
            },
            environment_config={
                "execution_config": {
                    "subnetwork_uri": "default",
                    "ttl": "3600s",
                    "network_tags": ["tag1"],
                },
            })
        ```

        ## Import

        SessionTemplate can be imported using any of these accepted formats:

        * `{{name}}`

        When using the `pulumi import` command, SessionTemplate can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:dataproc/sessionTemplate:SessionTemplate default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param SessionTemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SessionTemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 environment_config: Optional[pulumi.Input[Union['SessionTemplateEnvironmentConfigArgs', 'SessionTemplateEnvironmentConfigArgsDict']]] = None,
                 jupyter_session: Optional[pulumi.Input[Union['SessionTemplateJupyterSessionArgs', 'SessionTemplateJupyterSessionArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 runtime_config: Optional[pulumi.Input[Union['SessionTemplateRuntimeConfigArgs', 'SessionTemplateRuntimeConfigArgsDict']]] = None,
                 spark_connect_session: Optional[pulumi.Input[Union['SessionTemplateSparkConnectSessionArgs', 'SessionTemplateSparkConnectSessionArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SessionTemplateArgs.__new__(SessionTemplateArgs)

            __props__.__dict__["environment_config"] = environment_config
            __props__.__dict__["jupyter_session"] = jupyter_session
            __props__.__dict__["labels"] = labels
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["runtime_config"] = runtime_config
            __props__.__dict__["spark_connect_session"] = spark_connect_session
            __props__.__dict__["create_time"] = None
            __props__.__dict__["creator"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["update_time"] = None
            __props__.__dict__["uuid"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(SessionTemplate, __self__).__init__(
            'gcp:dataproc/sessionTemplate:SessionTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            creator: Optional[pulumi.Input[builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            environment_config: Optional[pulumi.Input[Union['SessionTemplateEnvironmentConfigArgs', 'SessionTemplateEnvironmentConfigArgsDict']]] = None,
            jupyter_session: Optional[pulumi.Input[Union['SessionTemplateJupyterSessionArgs', 'SessionTemplateJupyterSessionArgsDict']]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            runtime_config: Optional[pulumi.Input[Union['SessionTemplateRuntimeConfigArgs', 'SessionTemplateRuntimeConfigArgsDict']]] = None,
            spark_connect_session: Optional[pulumi.Input[Union['SessionTemplateSparkConnectSessionArgs', 'SessionTemplateSparkConnectSessionArgsDict']]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None,
            uuid: Optional[pulumi.Input[builtins.str]] = None) -> 'SessionTemplate':
        """
        Get an existing SessionTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] create_time: The time when the session template was created.
        :param pulumi.Input[builtins.str] creator: The email address of the user who created the session template.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Union['SessionTemplateEnvironmentConfigArgs', 'SessionTemplateEnvironmentConfigArgsDict']] environment_config: Environment configuration for the session execution.
               Structure is documented below.
        :param pulumi.Input[Union['SessionTemplateJupyterSessionArgs', 'SessionTemplateJupyterSessionArgsDict']] jupyter_session: Jupyter configuration for an interactive session.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: The labels to associate with this session template.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The location in which the session template will be created in.
        :param pulumi.Input[builtins.str] name: The resource name of the session template in the following format:
               projects/{project}/locations/{location}/sessionTemplates/{template_id}
               
               
               - - -
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[Union['SessionTemplateRuntimeConfigArgs', 'SessionTemplateRuntimeConfigArgsDict']] runtime_config: Runtime configuration for the session template.
               Structure is documented below.
        :param pulumi.Input[Union['SessionTemplateSparkConnectSessionArgs', 'SessionTemplateSparkConnectSessionArgsDict']] spark_connect_session: Spark connect configuration for an interactive session.
        :param pulumi.Input[builtins.str] update_time: The time when the session template was updated.
        :param pulumi.Input[builtins.str] uuid: A session template UUID (Unique Universal Identifier). The service generates this value when it creates the session template.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SessionTemplateState.__new__(_SessionTemplateState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["creator"] = creator
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["environment_config"] = environment_config
        __props__.__dict__["jupyter_session"] = jupyter_session
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["runtime_config"] = runtime_config
        __props__.__dict__["spark_connect_session"] = spark_connect_session
        __props__.__dict__["update_time"] = update_time
        __props__.__dict__["uuid"] = uuid
        return SessionTemplate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        The time when the session template was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def creator(self) -> pulumi.Output[builtins.str]:
        """
        The email address of the user who created the session template.
        """
        return pulumi.get(self, "creator")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter(name="environmentConfig")
    def environment_config(self) -> pulumi.Output[Optional['outputs.SessionTemplateEnvironmentConfig']]:
        """
        Environment configuration for the session execution.
        Structure is documented below.
        """
        return pulumi.get(self, "environment_config")

    @property
    @pulumi.getter(name="jupyterSession")
    def jupyter_session(self) -> pulumi.Output[Optional['outputs.SessionTemplateJupyterSession']]:
        """
        Jupyter configuration for an interactive session.
        Structure is documented below.
        """
        return pulumi.get(self, "jupyter_session")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        The labels to associate with this session template.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The location in which the session template will be created in.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The resource name of the session template in the following format:
        projects/{project}/locations/{location}/sessionTemplates/{template_id}


        - - -
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter(name="runtimeConfig")
    def runtime_config(self) -> pulumi.Output[Optional['outputs.SessionTemplateRuntimeConfig']]:
        """
        Runtime configuration for the session template.
        Structure is documented below.
        """
        return pulumi.get(self, "runtime_config")

    @property
    @pulumi.getter(name="sparkConnectSession")
    def spark_connect_session(self) -> pulumi.Output[Optional['outputs.SessionTemplateSparkConnectSession']]:
        """
        Spark connect configuration for an interactive session.
        """
        return pulumi.get(self, "spark_connect_session")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        The time when the session template was updated.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter
    def uuid(self) -> pulumi.Output[builtins.str]:
        """
        A session template UUID (Unique Universal Identifier). The service generates this value when it creates the session template.
        """
        return pulumi.get(self, "uuid")

