# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ConnectionArgs', 'Connection']

@pulumi.input_type
class ConnectionArgs:
    def __init__(__self__, *,
                 connection_id: pulumi.Input[builtins.str],
                 location: pulumi.Input[builtins.str],
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 bitbucket_cloud_config: Optional[pulumi.Input['ConnectionBitbucketCloudConfigArgs']] = None,
                 bitbucket_data_center_config: Optional[pulumi.Input['ConnectionBitbucketDataCenterConfigArgs']] = None,
                 crypto_key_config: Optional[pulumi.Input['ConnectionCryptoKeyConfigArgs']] = None,
                 disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 etag: Optional[pulumi.Input[builtins.str]] = None,
                 github_config: Optional[pulumi.Input['ConnectionGithubConfigArgs']] = None,
                 github_enterprise_config: Optional[pulumi.Input['ConnectionGithubEnterpriseConfigArgs']] = None,
                 gitlab_config: Optional[pulumi.Input['ConnectionGitlabConfigArgs']] = None,
                 gitlab_enterprise_config: Optional[pulumi.Input['ConnectionGitlabEnterpriseConfigArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Connection resource.
        :param pulumi.Input[builtins.str] connection_id: Required. Id of the requesting object
               If auto-generating Id server-side, remove this field and
               connection_id from the method_signature of Create RPC
               
               
               - - -
        :param pulumi.Input[builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] annotations: Optional. Allows clients to store small amounts of arbitrary data.
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input['ConnectionBitbucketCloudConfigArgs'] bitbucket_cloud_config: Configuration for connections to an instance of Bitbucket Cloud.
               Structure is documented below.
        :param pulumi.Input['ConnectionBitbucketDataCenterConfigArgs'] bitbucket_data_center_config: Configuration for connections to an instance of Bitbucket Data Center.
               Structure is documented below.
        :param pulumi.Input['ConnectionCryptoKeyConfigArgs'] crypto_key_config: The crypto key configuration. This field is used by the Customer-managed
               encryption keys (CMEK) feature.
               Structure is documented below.
        :param pulumi.Input[builtins.bool] disabled: Optional. If disabled is set to true, functionality is disabled for this connection.
               Repository based API methods and webhooks processing for repositories in
               this connection will be disabled.
        :param pulumi.Input[builtins.str] etag: Optional. This checksum is computed by the server based on the value of other
               fields, and may be sent on update and delete requests to ensure the
               client has an up-to-date value before proceeding.
        :param pulumi.Input['ConnectionGithubConfigArgs'] github_config: Configuration for connections to github.com.
               Structure is documented below.
        :param pulumi.Input['ConnectionGithubEnterpriseConfigArgs'] github_enterprise_config: Configuration for connections to an instance of GitHub Enterprise.
               Structure is documented below.
        :param pulumi.Input['ConnectionGitlabConfigArgs'] gitlab_config: Configuration for connections to gitlab.com.
               Structure is documented below.
        :param pulumi.Input['ConnectionGitlabEnterpriseConfigArgs'] gitlab_enterprise_config: Configuration for connections to an instance of GitLab Enterprise.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Optional. Labels as key value pairs
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "connection_id", connection_id)
        pulumi.set(__self__, "location", location)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if bitbucket_cloud_config is not None:
            pulumi.set(__self__, "bitbucket_cloud_config", bitbucket_cloud_config)
        if bitbucket_data_center_config is not None:
            pulumi.set(__self__, "bitbucket_data_center_config", bitbucket_data_center_config)
        if crypto_key_config is not None:
            pulumi.set(__self__, "crypto_key_config", crypto_key_config)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if github_config is not None:
            pulumi.set(__self__, "github_config", github_config)
        if github_enterprise_config is not None:
            pulumi.set(__self__, "github_enterprise_config", github_enterprise_config)
        if gitlab_config is not None:
            pulumi.set(__self__, "gitlab_config", gitlab_config)
        if gitlab_enterprise_config is not None:
            pulumi.set(__self__, "gitlab_enterprise_config", gitlab_enterprise_config)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="connectionId")
    def connection_id(self) -> pulumi.Input[builtins.str]:
        """
        Required. Id of the requesting object
        If auto-generating Id server-side, remove this field and
        connection_id from the method_signature of Create RPC


        - - -
        """
        return pulumi.get(self, "connection_id")

    @connection_id.setter
    def connection_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "connection_id", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Optional. Allows clients to store small amounts of arbitrary data.
        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="bitbucketCloudConfig")
    def bitbucket_cloud_config(self) -> Optional[pulumi.Input['ConnectionBitbucketCloudConfigArgs']]:
        """
        Configuration for connections to an instance of Bitbucket Cloud.
        Structure is documented below.
        """
        return pulumi.get(self, "bitbucket_cloud_config")

    @bitbucket_cloud_config.setter
    def bitbucket_cloud_config(self, value: Optional[pulumi.Input['ConnectionBitbucketCloudConfigArgs']]):
        pulumi.set(self, "bitbucket_cloud_config", value)

    @property
    @pulumi.getter(name="bitbucketDataCenterConfig")
    def bitbucket_data_center_config(self) -> Optional[pulumi.Input['ConnectionBitbucketDataCenterConfigArgs']]:
        """
        Configuration for connections to an instance of Bitbucket Data Center.
        Structure is documented below.
        """
        return pulumi.get(self, "bitbucket_data_center_config")

    @bitbucket_data_center_config.setter
    def bitbucket_data_center_config(self, value: Optional[pulumi.Input['ConnectionBitbucketDataCenterConfigArgs']]):
        pulumi.set(self, "bitbucket_data_center_config", value)

    @property
    @pulumi.getter(name="cryptoKeyConfig")
    def crypto_key_config(self) -> Optional[pulumi.Input['ConnectionCryptoKeyConfigArgs']]:
        """
        The crypto key configuration. This field is used by the Customer-managed
        encryption keys (CMEK) feature.
        Structure is documented below.
        """
        return pulumi.get(self, "crypto_key_config")

    @crypto_key_config.setter
    def crypto_key_config(self, value: Optional[pulumi.Input['ConnectionCryptoKeyConfigArgs']]):
        pulumi.set(self, "crypto_key_config", value)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Optional. If disabled is set to true, functionality is disabled for this connection.
        Repository based API methods and webhooks processing for repositories in
        this connection will be disabled.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "disabled", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional. This checksum is computed by the server based on the value of other
        fields, and may be sent on update and delete requests to ensure the
        client has an up-to-date value before proceeding.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter(name="githubConfig")
    def github_config(self) -> Optional[pulumi.Input['ConnectionGithubConfigArgs']]:
        """
        Configuration for connections to github.com.
        Structure is documented below.
        """
        return pulumi.get(self, "github_config")

    @github_config.setter
    def github_config(self, value: Optional[pulumi.Input['ConnectionGithubConfigArgs']]):
        pulumi.set(self, "github_config", value)

    @property
    @pulumi.getter(name="githubEnterpriseConfig")
    def github_enterprise_config(self) -> Optional[pulumi.Input['ConnectionGithubEnterpriseConfigArgs']]:
        """
        Configuration for connections to an instance of GitHub Enterprise.
        Structure is documented below.
        """
        return pulumi.get(self, "github_enterprise_config")

    @github_enterprise_config.setter
    def github_enterprise_config(self, value: Optional[pulumi.Input['ConnectionGithubEnterpriseConfigArgs']]):
        pulumi.set(self, "github_enterprise_config", value)

    @property
    @pulumi.getter(name="gitlabConfig")
    def gitlab_config(self) -> Optional[pulumi.Input['ConnectionGitlabConfigArgs']]:
        """
        Configuration for connections to gitlab.com.
        Structure is documented below.
        """
        return pulumi.get(self, "gitlab_config")

    @gitlab_config.setter
    def gitlab_config(self, value: Optional[pulumi.Input['ConnectionGitlabConfigArgs']]):
        pulumi.set(self, "gitlab_config", value)

    @property
    @pulumi.getter(name="gitlabEnterpriseConfig")
    def gitlab_enterprise_config(self) -> Optional[pulumi.Input['ConnectionGitlabEnterpriseConfigArgs']]:
        """
        Configuration for connections to an instance of GitLab Enterprise.
        Structure is documented below.
        """
        return pulumi.get(self, "gitlab_enterprise_config")

    @gitlab_enterprise_config.setter
    def gitlab_enterprise_config(self, value: Optional[pulumi.Input['ConnectionGitlabEnterpriseConfigArgs']]):
        pulumi.set(self, "gitlab_enterprise_config", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Optional. Labels as key value pairs
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _ConnectionState:
    def __init__(__self__, *,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 bitbucket_cloud_config: Optional[pulumi.Input['ConnectionBitbucketCloudConfigArgs']] = None,
                 bitbucket_data_center_config: Optional[pulumi.Input['ConnectionBitbucketDataCenterConfigArgs']] = None,
                 connection_id: Optional[pulumi.Input[builtins.str]] = None,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 crypto_key_config: Optional[pulumi.Input['ConnectionCryptoKeyConfigArgs']] = None,
                 delete_time: Optional[pulumi.Input[builtins.str]] = None,
                 disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 effective_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 etag: Optional[pulumi.Input[builtins.str]] = None,
                 github_config: Optional[pulumi.Input['ConnectionGithubConfigArgs']] = None,
                 github_enterprise_config: Optional[pulumi.Input['ConnectionGithubEnterpriseConfigArgs']] = None,
                 gitlab_config: Optional[pulumi.Input['ConnectionGitlabConfigArgs']] = None,
                 gitlab_enterprise_config: Optional[pulumi.Input['ConnectionGitlabEnterpriseConfigArgs']] = None,
                 installation_states: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionInstallationStateArgs']]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 reconciling: Optional[pulumi.Input[builtins.bool]] = None,
                 uid: Optional[pulumi.Input[builtins.str]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Connection resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] annotations: Optional. Allows clients to store small amounts of arbitrary data.
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input['ConnectionBitbucketCloudConfigArgs'] bitbucket_cloud_config: Configuration for connections to an instance of Bitbucket Cloud.
               Structure is documented below.
        :param pulumi.Input['ConnectionBitbucketDataCenterConfigArgs'] bitbucket_data_center_config: Configuration for connections to an instance of Bitbucket Data Center.
               Structure is documented below.
        :param pulumi.Input[builtins.str] connection_id: Required. Id of the requesting object
               If auto-generating Id server-side, remove this field and
               connection_id from the method_signature of Create RPC
               
               
               - - -
        :param pulumi.Input[builtins.str] create_time: Output only. [Output only] Create timestamp
        :param pulumi.Input['ConnectionCryptoKeyConfigArgs'] crypto_key_config: The crypto key configuration. This field is used by the Customer-managed
               encryption keys (CMEK) feature.
               Structure is documented below.
        :param pulumi.Input[builtins.str] delete_time: Output only. [Output only] Delete timestamp
        :param pulumi.Input[builtins.bool] disabled: Optional. If disabled is set to true, functionality is disabled for this connection.
               Repository based API methods and webhooks processing for repositories in
               this connection will be disabled.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.str] etag: Optional. This checksum is computed by the server based on the value of other
               fields, and may be sent on update and delete requests to ensure the
               client has an up-to-date value before proceeding.
        :param pulumi.Input['ConnectionGithubConfigArgs'] github_config: Configuration for connections to github.com.
               Structure is documented below.
        :param pulumi.Input['ConnectionGithubEnterpriseConfigArgs'] github_enterprise_config: Configuration for connections to an instance of GitHub Enterprise.
               Structure is documented below.
        :param pulumi.Input['ConnectionGitlabConfigArgs'] gitlab_config: Configuration for connections to gitlab.com.
               Structure is documented below.
        :param pulumi.Input['ConnectionGitlabEnterpriseConfigArgs'] gitlab_enterprise_config: Configuration for connections to an instance of GitLab Enterprise.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['ConnectionInstallationStateArgs']]] installation_states: Describes stage and necessary actions to be taken by the
               user to complete the installation. Used for GitHub and GitHub Enterprise
               based connections.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Optional. Labels as key value pairs
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[builtins.str] name: Identifier. The resource name of the connection, in the format
               `projects/{project}/locations/{location}/connections/{connection_id}`.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.bool] reconciling: Output only. Set to true when the connection is being set up or updated in the
               background.
        :param pulumi.Input[builtins.str] uid: Output only. A system-assigned unique identifier for a the GitRepositoryLink.
        :param pulumi.Input[builtins.str] update_time: Output only. [Output only] Update timestamp
        """
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if bitbucket_cloud_config is not None:
            pulumi.set(__self__, "bitbucket_cloud_config", bitbucket_cloud_config)
        if bitbucket_data_center_config is not None:
            pulumi.set(__self__, "bitbucket_data_center_config", bitbucket_data_center_config)
        if connection_id is not None:
            pulumi.set(__self__, "connection_id", connection_id)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if crypto_key_config is not None:
            pulumi.set(__self__, "crypto_key_config", crypto_key_config)
        if delete_time is not None:
            pulumi.set(__self__, "delete_time", delete_time)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if effective_annotations is not None:
            pulumi.set(__self__, "effective_annotations", effective_annotations)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if github_config is not None:
            pulumi.set(__self__, "github_config", github_config)
        if github_enterprise_config is not None:
            pulumi.set(__self__, "github_enterprise_config", github_enterprise_config)
        if gitlab_config is not None:
            pulumi.set(__self__, "gitlab_config", gitlab_config)
        if gitlab_enterprise_config is not None:
            pulumi.set(__self__, "gitlab_enterprise_config", gitlab_enterprise_config)
        if installation_states is not None:
            pulumi.set(__self__, "installation_states", installation_states)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if reconciling is not None:
            pulumi.set(__self__, "reconciling", reconciling)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Optional. Allows clients to store small amounts of arbitrary data.
        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="bitbucketCloudConfig")
    def bitbucket_cloud_config(self) -> Optional[pulumi.Input['ConnectionBitbucketCloudConfigArgs']]:
        """
        Configuration for connections to an instance of Bitbucket Cloud.
        Structure is documented below.
        """
        return pulumi.get(self, "bitbucket_cloud_config")

    @bitbucket_cloud_config.setter
    def bitbucket_cloud_config(self, value: Optional[pulumi.Input['ConnectionBitbucketCloudConfigArgs']]):
        pulumi.set(self, "bitbucket_cloud_config", value)

    @property
    @pulumi.getter(name="bitbucketDataCenterConfig")
    def bitbucket_data_center_config(self) -> Optional[pulumi.Input['ConnectionBitbucketDataCenterConfigArgs']]:
        """
        Configuration for connections to an instance of Bitbucket Data Center.
        Structure is documented below.
        """
        return pulumi.get(self, "bitbucket_data_center_config")

    @bitbucket_data_center_config.setter
    def bitbucket_data_center_config(self, value: Optional[pulumi.Input['ConnectionBitbucketDataCenterConfigArgs']]):
        pulumi.set(self, "bitbucket_data_center_config", value)

    @property
    @pulumi.getter(name="connectionId")
    def connection_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Required. Id of the requesting object
        If auto-generating Id server-side, remove this field and
        connection_id from the method_signature of Create RPC


        - - -
        """
        return pulumi.get(self, "connection_id")

    @connection_id.setter
    def connection_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "connection_id", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. [Output only] Create timestamp
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="cryptoKeyConfig")
    def crypto_key_config(self) -> Optional[pulumi.Input['ConnectionCryptoKeyConfigArgs']]:
        """
        The crypto key configuration. This field is used by the Customer-managed
        encryption keys (CMEK) feature.
        Structure is documented below.
        """
        return pulumi.get(self, "crypto_key_config")

    @crypto_key_config.setter
    def crypto_key_config(self, value: Optional[pulumi.Input['ConnectionCryptoKeyConfigArgs']]):
        pulumi.set(self, "crypto_key_config", value)

    @property
    @pulumi.getter(name="deleteTime")
    def delete_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. [Output only] Delete timestamp
        """
        return pulumi.get(self, "delete_time")

    @delete_time.setter
    def delete_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "delete_time", value)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Optional. If disabled is set to true, functionality is disabled for this connection.
        Repository based API methods and webhooks processing for repositories in
        this connection will be disabled.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "disabled", value)

    @property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "effective_annotations")

    @effective_annotations.setter
    def effective_annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_annotations", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional. This checksum is computed by the server based on the value of other
        fields, and may be sent on update and delete requests to ensure the
        client has an up-to-date value before proceeding.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter(name="githubConfig")
    def github_config(self) -> Optional[pulumi.Input['ConnectionGithubConfigArgs']]:
        """
        Configuration for connections to github.com.
        Structure is documented below.
        """
        return pulumi.get(self, "github_config")

    @github_config.setter
    def github_config(self, value: Optional[pulumi.Input['ConnectionGithubConfigArgs']]):
        pulumi.set(self, "github_config", value)

    @property
    @pulumi.getter(name="githubEnterpriseConfig")
    def github_enterprise_config(self) -> Optional[pulumi.Input['ConnectionGithubEnterpriseConfigArgs']]:
        """
        Configuration for connections to an instance of GitHub Enterprise.
        Structure is documented below.
        """
        return pulumi.get(self, "github_enterprise_config")

    @github_enterprise_config.setter
    def github_enterprise_config(self, value: Optional[pulumi.Input['ConnectionGithubEnterpriseConfigArgs']]):
        pulumi.set(self, "github_enterprise_config", value)

    @property
    @pulumi.getter(name="gitlabConfig")
    def gitlab_config(self) -> Optional[pulumi.Input['ConnectionGitlabConfigArgs']]:
        """
        Configuration for connections to gitlab.com.
        Structure is documented below.
        """
        return pulumi.get(self, "gitlab_config")

    @gitlab_config.setter
    def gitlab_config(self, value: Optional[pulumi.Input['ConnectionGitlabConfigArgs']]):
        pulumi.set(self, "gitlab_config", value)

    @property
    @pulumi.getter(name="gitlabEnterpriseConfig")
    def gitlab_enterprise_config(self) -> Optional[pulumi.Input['ConnectionGitlabEnterpriseConfigArgs']]:
        """
        Configuration for connections to an instance of GitLab Enterprise.
        Structure is documented below.
        """
        return pulumi.get(self, "gitlab_enterprise_config")

    @gitlab_enterprise_config.setter
    def gitlab_enterprise_config(self, value: Optional[pulumi.Input['ConnectionGitlabEnterpriseConfigArgs']]):
        pulumi.set(self, "gitlab_enterprise_config", value)

    @property
    @pulumi.getter(name="installationStates")
    def installation_states(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionInstallationStateArgs']]]]:
        """
        Describes stage and necessary actions to be taken by the
        user to complete the installation. Used for GitHub and GitHub Enterprise
        based connections.
        Structure is documented below.
        """
        return pulumi.get(self, "installation_states")

    @installation_states.setter
    def installation_states(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionInstallationStateArgs']]]]):
        pulumi.set(self, "installation_states", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Optional. Labels as key value pairs
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier. The resource name of the connection, in the format
        `projects/{project}/locations/{location}/connections/{connection_id}`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter
    def reconciling(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Output only. Set to true when the connection is being set up or updated in the
        background.
        """
        return pulumi.get(self, "reconciling")

    @reconciling.setter
    def reconciling(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "reconciling", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. A system-assigned unique identifier for a the GitRepositoryLink.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "uid", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. [Output only] Update timestamp
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:developerconnect/connection:Connection")
class Connection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 bitbucket_cloud_config: Optional[pulumi.Input[Union['ConnectionBitbucketCloudConfigArgs', 'ConnectionBitbucketCloudConfigArgsDict']]] = None,
                 bitbucket_data_center_config: Optional[pulumi.Input[Union['ConnectionBitbucketDataCenterConfigArgs', 'ConnectionBitbucketDataCenterConfigArgsDict']]] = None,
                 connection_id: Optional[pulumi.Input[builtins.str]] = None,
                 crypto_key_config: Optional[pulumi.Input[Union['ConnectionCryptoKeyConfigArgs', 'ConnectionCryptoKeyConfigArgsDict']]] = None,
                 disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 etag: Optional[pulumi.Input[builtins.str]] = None,
                 github_config: Optional[pulumi.Input[Union['ConnectionGithubConfigArgs', 'ConnectionGithubConfigArgsDict']]] = None,
                 github_enterprise_config: Optional[pulumi.Input[Union['ConnectionGithubEnterpriseConfigArgs', 'ConnectionGithubEnterpriseConfigArgsDict']]] = None,
                 gitlab_config: Optional[pulumi.Input[Union['ConnectionGitlabConfigArgs', 'ConnectionGitlabConfigArgsDict']]] = None,
                 gitlab_enterprise_config: Optional[pulumi.Input[Union['ConnectionGitlabEnterpriseConfigArgs', 'ConnectionGitlabEnterpriseConfigArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        A connection for GitHub, GitHub Enterprise, GitLab, and GitLab Enterprise.

        To get more information about Connection, see:

        * [API documentation](https://cloud.google.com/developer-connect/docs/api/reference/rest/v1/projects.locations.connections)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/developer-connect/docs/overview)

        ## Example Usage

        ### Developer Connect Connection New

        ```python
        import pulumi
        import pulumi_gcp as gcp

        # Setup permissions. Only needed once per project
        devconnect_p4sa = gcp.projects.ServiceIdentity("devconnect-p4sa", service="developerconnect.googleapis.com")
        devconnect_secret = gcp.projects.IAMMember("devconnect-secret",
            project="my-project-name",
            role="roles/secretmanager.admin",
            member=devconnect_p4sa.member)
        my_connection = gcp.developerconnect.Connection("my-connection",
            location="us-central1",
            connection_id="tf-test-connection-new",
            github_config={
                "github_app": "FIREBASE",
            },
            opts = pulumi.ResourceOptions(depends_on=[devconnect_secret]))
        pulumi.export("nextSteps", my_connection.installation_states)
        ```
        ### Developer Connect Connection Existing Credentials

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_connection = gcp.developerconnect.Connection("my-connection",
            location="us-central1",
            connection_id="tf-test-connection-cred",
            github_config={
                "github_app": "DEVELOPER_CONNECT",
                "authorizer_credential": {
                    "oauth_token_secret_version": "projects/your-project/secrets/your-secret-id/versions/latest",
                },
            })
        pulumi.export("nextSteps", my_connection.installation_states)
        ```
        ### Developer Connect Connection Existing Installation

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        github_token_secret = gcp.secretmanager.Secret("github-token-secret",
            secret_id="github-token-secret",
            replication={
                "auto": {},
            })
        github_token_secret_version = gcp.secretmanager.SecretVersion("github-token-secret-version",
            secret=github_token_secret.id,
            secret_data=std.file(input="my-github-token.txt").result)
        devconnect_p4sa = gcp.projects.ServiceIdentity("devconnect-p4sa", service="developerconnect.googleapis.com")
        p4sa_secret_accessor = gcp.organizations.get_iam_policy_output(bindings=[{
            "role": "roles/secretmanager.secretAccessor",
            "members": [devconnect_p4sa.member],
        }])
        policy = gcp.secretmanager.SecretIamPolicy("policy",
            secret_id=github_token_secret.secret_id,
            policy_data=p4sa_secret_accessor.policy_data)
        my_connection = gcp.developerconnect.Connection("my-connection",
            location="us-central1",
            connection_id="my-connection",
            github_config={
                "github_app": "DEVELOPER_CONNECT",
                "app_installation_id": "123123",
                "authorizer_credential": {
                    "oauth_token_secret_version": github_token_secret_version.id,
                },
            })
        ```
        ### Developer Connect Connection Github

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_connection = gcp.developerconnect.Connection("my-connection",
            location="us-central1",
            connection_id="tf-test-connection",
            github_config={
                "github_app": "DEVELOPER_CONNECT",
                "authorizer_credential": {
                    "oauth_token_secret_version": "projects/devconnect-terraform-creds/secrets/tf-test-do-not-change-github-oauthtoken-e0b9e7/versions/1",
                },
            })
        ```
        ### Developer Connect Connection Github Doc

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        github_token_secret = gcp.secretmanager.Secret("github-token-secret",
            secret_id="github-token-secret",
            replication={
                "auto": {},
            })
        github_token_secret_version = gcp.secretmanager.SecretVersion("github-token-secret-version",
            secret=github_token_secret.id,
            secret_data=std.file(input="my-github-token.txt").result)
        p4sa_secret_accessor = gcp.organizations.get_iam_policy(bindings=[{
            "role": "roles/secretmanager.secretAccessor",
            "members": ["serviceAccount:service-123456789@gcp-sa-devconnect.iam.gserviceaccount.com"],
        }])
        policy = gcp.secretmanager.SecretIamPolicy("policy",
            secret_id=github_token_secret.secret_id,
            policy_data=p4sa_secret_accessor.policy_data)
        my_connection = gcp.developerconnect.Connection("my-connection",
            location="us-central1",
            connection_id="my-connection",
            github_config={
                "github_app": "DEVELOPER_CONNECT",
                "app_installation_id": "123123",
                "authorizer_credential": {
                    "oauth_token_secret_version": github_token_secret_version.id,
                },
            })
        ```
        ### Developer Connect Connection Github Enterprise

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_connection = gcp.developerconnect.Connection("my-connection",
            location="us-central1",
            connection_id="tf-test-connection",
            github_enterprise_config={
                "host_uri": "https://ghe.proctor-staging-test.com",
                "app_id": "864434",
                "private_key_secret_version": "projects/devconnect-terraform-creds/secrets/tf-test-ghe-do-not-change-ghe-private-key-f522d2/versions/latest",
                "webhook_secret_secret_version": "projects/devconnect-terraform-creds/secrets/tf-test-ghe-do-not-change-ghe-webhook-secret-3c806f/versions/latest",
                "app_installation_id": "837537",
            })
        ```
        ### Developer Connect Connection Github Enterprise Doc

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        private_key_secret = gcp.secretmanager.Secret("private-key-secret",
            secret_id="ghe-pk-secret",
            replication={
                "auto": {},
            })
        private_key_secret_version = gcp.secretmanager.SecretVersion("private-key-secret-version",
            secret=private_key_secret.id,
            secret_data=std.file(input="private-key.pem").result)
        webhook_secret_secret = gcp.secretmanager.Secret("webhook-secret-secret",
            secret_id="ghe-token-secret",
            replication={
                "auto": {},
            })
        webhook_secret_secret_version = gcp.secretmanager.SecretVersion("webhook-secret-secret-version",
            secret=webhook_secret_secret.id,
            secret_data="<webhook-secret-data>")
        p4sa_secret_accessor = gcp.organizations.get_iam_policy(bindings=[{
            "role": "roles/secretmanager.secretAccessor",
            "members": ["serviceAccount:service-123456789@gcp-sa-devconnect.iam.gserviceaccount.com"],
        }])
        policy_pk = gcp.secretmanager.SecretIamPolicy("policy-pk",
            secret_id=private_key_secret.secret_id,
            policy_data=p4sa_secret_accessor.policy_data)
        policy_whs = gcp.secretmanager.SecretIamPolicy("policy-whs",
            secret_id=webhook_secret_secret.secret_id,
            policy_data=p4sa_secret_accessor.policy_data)
        my_connection = gcp.developerconnect.Connection("my-connection",
            location="us-central1",
            connection_id="my-connection",
            github_enterprise_config={
                "host_uri": "https://ghe.com",
                "private_key_secret_version": private_key_secret_version.id,
                "webhook_secret_secret_version": webhook_secret_secret_version.id,
                "app_id": "100",
                "app_installation_id": "123123",
            },
            opts = pulumi.ResourceOptions(depends_on=[
                    policy_pk,
                    policy_whs,
                ]))
        ```
        ### Developer Connect Connection Gitlab

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_connection = gcp.developerconnect.Connection("my-connection",
            location="us-central1",
            connection_id="tf-test-connection",
            gitlab_config={
                "webhook_secret_secret_version": "projects/devconnect-terraform-creds/secrets/gitlab-webhook/versions/latest",
                "read_authorizer_credential": {
                    "user_token_secret_version": "projects/devconnect-terraform-creds/secrets/gitlab-read-cred/versions/latest",
                },
                "authorizer_credential": {
                    "user_token_secret_version": "projects/devconnect-terraform-creds/secrets/gitlab-auth-cred/versions/latest",
                },
            })
        ```
        ### Developer Connect Connection Gitlab Enterprise

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_connection = gcp.developerconnect.Connection("my-connection",
            location="us-central1",
            connection_id="tf-test-connection",
            gitlab_enterprise_config={
                "host_uri": "https://gle-us-central1.gcb-test.com",
                "webhook_secret_secret_version": "projects/devconnect-terraform-creds/secrets/gitlab-enterprise-webhook/versions/latest",
                "read_authorizer_credential": {
                    "user_token_secret_version": "projects/devconnect-terraform-creds/secrets/gitlab-enterprise-read-cred/versions/latest",
                },
                "authorizer_credential": {
                    "user_token_secret_version": "projects/devconnect-terraform-creds/secrets/gitlab-enterprise-auth-cred/versions/latest",
                },
            })
        ```
        ### Developer Connect Connection Bbc

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_connection = gcp.developerconnect.Connection("my-connection",
            location="us-central1",
            connection_id="tf-test-connection",
            bitbucket_cloud_config={
                "workspace": "proctor-test",
                "webhook_secret_secret_version": "projects/devconnect-terraform-creds/secrets/bbc-webhook/versions/latest",
                "read_authorizer_credential": {
                    "user_token_secret_version": "projects/devconnect-terraform-creds/secrets/bbc-read-token/versions/latest",
                },
                "authorizer_credential": {
                    "user_token_secret_version": "projects/devconnect-terraform-creds/secrets/bbc-auth-token/versions/latest",
                },
            })
        ```
        ### Developer Connect Connection Bbdc

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_connection = gcp.developerconnect.Connection("my-connection",
            location="us-central1",
            connection_id="tf-test-connection",
            bitbucket_data_center_config={
                "host_uri": "https://bitbucket-us-central.gcb-test.com",
                "webhook_secret_secret_version": "projects/devconnect-terraform-creds/secrets/bbdc-webhook/versions/latest",
                "read_authorizer_credential": {
                    "user_token_secret_version": "projects/devconnect-terraform-creds/secrets/bbdc-read-token/versions/latest",
                },
                "authorizer_credential": {
                    "user_token_secret_version": "projects/devconnect-terraform-creds/secrets/bbdc-auth-token/versions/latest",
                },
            })
        ```
        ## Import

        Connection can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/connections/{{connection_id}}`

        * `{{project}}/{{location}}/{{connection_id}}`

        * `{{location}}/{{connection_id}}`

        When using the `pulumi import` command, Connection can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:developerconnect/connection:Connection default projects/{{project}}/locations/{{location}}/connections/{{connection_id}}
        ```

        ```sh
        $ pulumi import gcp:developerconnect/connection:Connection default {{project}}/{{location}}/{{connection_id}}
        ```

        ```sh
        $ pulumi import gcp:developerconnect/connection:Connection default {{location}}/{{connection_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] annotations: Optional. Allows clients to store small amounts of arbitrary data.
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[Union['ConnectionBitbucketCloudConfigArgs', 'ConnectionBitbucketCloudConfigArgsDict']] bitbucket_cloud_config: Configuration for connections to an instance of Bitbucket Cloud.
               Structure is documented below.
        :param pulumi.Input[Union['ConnectionBitbucketDataCenterConfigArgs', 'ConnectionBitbucketDataCenterConfigArgsDict']] bitbucket_data_center_config: Configuration for connections to an instance of Bitbucket Data Center.
               Structure is documented below.
        :param pulumi.Input[builtins.str] connection_id: Required. Id of the requesting object
               If auto-generating Id server-side, remove this field and
               connection_id from the method_signature of Create RPC
               
               
               - - -
        :param pulumi.Input[Union['ConnectionCryptoKeyConfigArgs', 'ConnectionCryptoKeyConfigArgsDict']] crypto_key_config: The crypto key configuration. This field is used by the Customer-managed
               encryption keys (CMEK) feature.
               Structure is documented below.
        :param pulumi.Input[builtins.bool] disabled: Optional. If disabled is set to true, functionality is disabled for this connection.
               Repository based API methods and webhooks processing for repositories in
               this connection will be disabled.
        :param pulumi.Input[builtins.str] etag: Optional. This checksum is computed by the server based on the value of other
               fields, and may be sent on update and delete requests to ensure the
               client has an up-to-date value before proceeding.
        :param pulumi.Input[Union['ConnectionGithubConfigArgs', 'ConnectionGithubConfigArgsDict']] github_config: Configuration for connections to github.com.
               Structure is documented below.
        :param pulumi.Input[Union['ConnectionGithubEnterpriseConfigArgs', 'ConnectionGithubEnterpriseConfigArgsDict']] github_enterprise_config: Configuration for connections to an instance of GitHub Enterprise.
               Structure is documented below.
        :param pulumi.Input[Union['ConnectionGitlabConfigArgs', 'ConnectionGitlabConfigArgsDict']] gitlab_config: Configuration for connections to gitlab.com.
               Structure is documented below.
        :param pulumi.Input[Union['ConnectionGitlabEnterpriseConfigArgs', 'ConnectionGitlabEnterpriseConfigArgsDict']] gitlab_enterprise_config: Configuration for connections to an instance of GitLab Enterprise.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Optional. Labels as key value pairs
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConnectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A connection for GitHub, GitHub Enterprise, GitLab, and GitLab Enterprise.

        To get more information about Connection, see:

        * [API documentation](https://cloud.google.com/developer-connect/docs/api/reference/rest/v1/projects.locations.connections)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/developer-connect/docs/overview)

        ## Example Usage

        ### Developer Connect Connection New

        ```python
        import pulumi
        import pulumi_gcp as gcp

        # Setup permissions. Only needed once per project
        devconnect_p4sa = gcp.projects.ServiceIdentity("devconnect-p4sa", service="developerconnect.googleapis.com")
        devconnect_secret = gcp.projects.IAMMember("devconnect-secret",
            project="my-project-name",
            role="roles/secretmanager.admin",
            member=devconnect_p4sa.member)
        my_connection = gcp.developerconnect.Connection("my-connection",
            location="us-central1",
            connection_id="tf-test-connection-new",
            github_config={
                "github_app": "FIREBASE",
            },
            opts = pulumi.ResourceOptions(depends_on=[devconnect_secret]))
        pulumi.export("nextSteps", my_connection.installation_states)
        ```
        ### Developer Connect Connection Existing Credentials

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_connection = gcp.developerconnect.Connection("my-connection",
            location="us-central1",
            connection_id="tf-test-connection-cred",
            github_config={
                "github_app": "DEVELOPER_CONNECT",
                "authorizer_credential": {
                    "oauth_token_secret_version": "projects/your-project/secrets/your-secret-id/versions/latest",
                },
            })
        pulumi.export("nextSteps", my_connection.installation_states)
        ```
        ### Developer Connect Connection Existing Installation

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        github_token_secret = gcp.secretmanager.Secret("github-token-secret",
            secret_id="github-token-secret",
            replication={
                "auto": {},
            })
        github_token_secret_version = gcp.secretmanager.SecretVersion("github-token-secret-version",
            secret=github_token_secret.id,
            secret_data=std.file(input="my-github-token.txt").result)
        devconnect_p4sa = gcp.projects.ServiceIdentity("devconnect-p4sa", service="developerconnect.googleapis.com")
        p4sa_secret_accessor = gcp.organizations.get_iam_policy_output(bindings=[{
            "role": "roles/secretmanager.secretAccessor",
            "members": [devconnect_p4sa.member],
        }])
        policy = gcp.secretmanager.SecretIamPolicy("policy",
            secret_id=github_token_secret.secret_id,
            policy_data=p4sa_secret_accessor.policy_data)
        my_connection = gcp.developerconnect.Connection("my-connection",
            location="us-central1",
            connection_id="my-connection",
            github_config={
                "github_app": "DEVELOPER_CONNECT",
                "app_installation_id": "123123",
                "authorizer_credential": {
                    "oauth_token_secret_version": github_token_secret_version.id,
                },
            })
        ```
        ### Developer Connect Connection Github

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_connection = gcp.developerconnect.Connection("my-connection",
            location="us-central1",
            connection_id="tf-test-connection",
            github_config={
                "github_app": "DEVELOPER_CONNECT",
                "authorizer_credential": {
                    "oauth_token_secret_version": "projects/devconnect-terraform-creds/secrets/tf-test-do-not-change-github-oauthtoken-e0b9e7/versions/1",
                },
            })
        ```
        ### Developer Connect Connection Github Doc

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        github_token_secret = gcp.secretmanager.Secret("github-token-secret",
            secret_id="github-token-secret",
            replication={
                "auto": {},
            })
        github_token_secret_version = gcp.secretmanager.SecretVersion("github-token-secret-version",
            secret=github_token_secret.id,
            secret_data=std.file(input="my-github-token.txt").result)
        p4sa_secret_accessor = gcp.organizations.get_iam_policy(bindings=[{
            "role": "roles/secretmanager.secretAccessor",
            "members": ["serviceAccount:service-123456789@gcp-sa-devconnect.iam.gserviceaccount.com"],
        }])
        policy = gcp.secretmanager.SecretIamPolicy("policy",
            secret_id=github_token_secret.secret_id,
            policy_data=p4sa_secret_accessor.policy_data)
        my_connection = gcp.developerconnect.Connection("my-connection",
            location="us-central1",
            connection_id="my-connection",
            github_config={
                "github_app": "DEVELOPER_CONNECT",
                "app_installation_id": "123123",
                "authorizer_credential": {
                    "oauth_token_secret_version": github_token_secret_version.id,
                },
            })
        ```
        ### Developer Connect Connection Github Enterprise

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_connection = gcp.developerconnect.Connection("my-connection",
            location="us-central1",
            connection_id="tf-test-connection",
            github_enterprise_config={
                "host_uri": "https://ghe.proctor-staging-test.com",
                "app_id": "864434",
                "private_key_secret_version": "projects/devconnect-terraform-creds/secrets/tf-test-ghe-do-not-change-ghe-private-key-f522d2/versions/latest",
                "webhook_secret_secret_version": "projects/devconnect-terraform-creds/secrets/tf-test-ghe-do-not-change-ghe-webhook-secret-3c806f/versions/latest",
                "app_installation_id": "837537",
            })
        ```
        ### Developer Connect Connection Github Enterprise Doc

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        private_key_secret = gcp.secretmanager.Secret("private-key-secret",
            secret_id="ghe-pk-secret",
            replication={
                "auto": {},
            })
        private_key_secret_version = gcp.secretmanager.SecretVersion("private-key-secret-version",
            secret=private_key_secret.id,
            secret_data=std.file(input="private-key.pem").result)
        webhook_secret_secret = gcp.secretmanager.Secret("webhook-secret-secret",
            secret_id="ghe-token-secret",
            replication={
                "auto": {},
            })
        webhook_secret_secret_version = gcp.secretmanager.SecretVersion("webhook-secret-secret-version",
            secret=webhook_secret_secret.id,
            secret_data="<webhook-secret-data>")
        p4sa_secret_accessor = gcp.organizations.get_iam_policy(bindings=[{
            "role": "roles/secretmanager.secretAccessor",
            "members": ["serviceAccount:service-123456789@gcp-sa-devconnect.iam.gserviceaccount.com"],
        }])
        policy_pk = gcp.secretmanager.SecretIamPolicy("policy-pk",
            secret_id=private_key_secret.secret_id,
            policy_data=p4sa_secret_accessor.policy_data)
        policy_whs = gcp.secretmanager.SecretIamPolicy("policy-whs",
            secret_id=webhook_secret_secret.secret_id,
            policy_data=p4sa_secret_accessor.policy_data)
        my_connection = gcp.developerconnect.Connection("my-connection",
            location="us-central1",
            connection_id="my-connection",
            github_enterprise_config={
                "host_uri": "https://ghe.com",
                "private_key_secret_version": private_key_secret_version.id,
                "webhook_secret_secret_version": webhook_secret_secret_version.id,
                "app_id": "100",
                "app_installation_id": "123123",
            },
            opts = pulumi.ResourceOptions(depends_on=[
                    policy_pk,
                    policy_whs,
                ]))
        ```
        ### Developer Connect Connection Gitlab

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_connection = gcp.developerconnect.Connection("my-connection",
            location="us-central1",
            connection_id="tf-test-connection",
            gitlab_config={
                "webhook_secret_secret_version": "projects/devconnect-terraform-creds/secrets/gitlab-webhook/versions/latest",
                "read_authorizer_credential": {
                    "user_token_secret_version": "projects/devconnect-terraform-creds/secrets/gitlab-read-cred/versions/latest",
                },
                "authorizer_credential": {
                    "user_token_secret_version": "projects/devconnect-terraform-creds/secrets/gitlab-auth-cred/versions/latest",
                },
            })
        ```
        ### Developer Connect Connection Gitlab Enterprise

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_connection = gcp.developerconnect.Connection("my-connection",
            location="us-central1",
            connection_id="tf-test-connection",
            gitlab_enterprise_config={
                "host_uri": "https://gle-us-central1.gcb-test.com",
                "webhook_secret_secret_version": "projects/devconnect-terraform-creds/secrets/gitlab-enterprise-webhook/versions/latest",
                "read_authorizer_credential": {
                    "user_token_secret_version": "projects/devconnect-terraform-creds/secrets/gitlab-enterprise-read-cred/versions/latest",
                },
                "authorizer_credential": {
                    "user_token_secret_version": "projects/devconnect-terraform-creds/secrets/gitlab-enterprise-auth-cred/versions/latest",
                },
            })
        ```
        ### Developer Connect Connection Bbc

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_connection = gcp.developerconnect.Connection("my-connection",
            location="us-central1",
            connection_id="tf-test-connection",
            bitbucket_cloud_config={
                "workspace": "proctor-test",
                "webhook_secret_secret_version": "projects/devconnect-terraform-creds/secrets/bbc-webhook/versions/latest",
                "read_authorizer_credential": {
                    "user_token_secret_version": "projects/devconnect-terraform-creds/secrets/bbc-read-token/versions/latest",
                },
                "authorizer_credential": {
                    "user_token_secret_version": "projects/devconnect-terraform-creds/secrets/bbc-auth-token/versions/latest",
                },
            })
        ```
        ### Developer Connect Connection Bbdc

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_connection = gcp.developerconnect.Connection("my-connection",
            location="us-central1",
            connection_id="tf-test-connection",
            bitbucket_data_center_config={
                "host_uri": "https://bitbucket-us-central.gcb-test.com",
                "webhook_secret_secret_version": "projects/devconnect-terraform-creds/secrets/bbdc-webhook/versions/latest",
                "read_authorizer_credential": {
                    "user_token_secret_version": "projects/devconnect-terraform-creds/secrets/bbdc-read-token/versions/latest",
                },
                "authorizer_credential": {
                    "user_token_secret_version": "projects/devconnect-terraform-creds/secrets/bbdc-auth-token/versions/latest",
                },
            })
        ```
        ## Import

        Connection can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/connections/{{connection_id}}`

        * `{{project}}/{{location}}/{{connection_id}}`

        * `{{location}}/{{connection_id}}`

        When using the `pulumi import` command, Connection can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:developerconnect/connection:Connection default projects/{{project}}/locations/{{location}}/connections/{{connection_id}}
        ```

        ```sh
        $ pulumi import gcp:developerconnect/connection:Connection default {{project}}/{{location}}/{{connection_id}}
        ```

        ```sh
        $ pulumi import gcp:developerconnect/connection:Connection default {{location}}/{{connection_id}}
        ```

        :param str resource_name: The name of the resource.
        :param ConnectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConnectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 bitbucket_cloud_config: Optional[pulumi.Input[Union['ConnectionBitbucketCloudConfigArgs', 'ConnectionBitbucketCloudConfigArgsDict']]] = None,
                 bitbucket_data_center_config: Optional[pulumi.Input[Union['ConnectionBitbucketDataCenterConfigArgs', 'ConnectionBitbucketDataCenterConfigArgsDict']]] = None,
                 connection_id: Optional[pulumi.Input[builtins.str]] = None,
                 crypto_key_config: Optional[pulumi.Input[Union['ConnectionCryptoKeyConfigArgs', 'ConnectionCryptoKeyConfigArgsDict']]] = None,
                 disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 etag: Optional[pulumi.Input[builtins.str]] = None,
                 github_config: Optional[pulumi.Input[Union['ConnectionGithubConfigArgs', 'ConnectionGithubConfigArgsDict']]] = None,
                 github_enterprise_config: Optional[pulumi.Input[Union['ConnectionGithubEnterpriseConfigArgs', 'ConnectionGithubEnterpriseConfigArgsDict']]] = None,
                 gitlab_config: Optional[pulumi.Input[Union['ConnectionGitlabConfigArgs', 'ConnectionGitlabConfigArgsDict']]] = None,
                 gitlab_enterprise_config: Optional[pulumi.Input[Union['ConnectionGitlabEnterpriseConfigArgs', 'ConnectionGitlabEnterpriseConfigArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConnectionArgs.__new__(ConnectionArgs)

            __props__.__dict__["annotations"] = annotations
            __props__.__dict__["bitbucket_cloud_config"] = bitbucket_cloud_config
            __props__.__dict__["bitbucket_data_center_config"] = bitbucket_data_center_config
            if connection_id is None and not opts.urn:
                raise TypeError("Missing required property 'connection_id'")
            __props__.__dict__["connection_id"] = connection_id
            __props__.__dict__["crypto_key_config"] = crypto_key_config
            __props__.__dict__["disabled"] = disabled
            __props__.__dict__["etag"] = etag
            __props__.__dict__["github_config"] = github_config
            __props__.__dict__["github_enterprise_config"] = github_enterprise_config
            __props__.__dict__["gitlab_config"] = gitlab_config
            __props__.__dict__["gitlab_enterprise_config"] = gitlab_enterprise_config
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            __props__.__dict__["create_time"] = None
            __props__.__dict__["delete_time"] = None
            __props__.__dict__["effective_annotations"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["installation_states"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["reconciling"] = None
            __props__.__dict__["uid"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Connection, __self__).__init__(
            'gcp:developerconnect/connection:Connection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            bitbucket_cloud_config: Optional[pulumi.Input[Union['ConnectionBitbucketCloudConfigArgs', 'ConnectionBitbucketCloudConfigArgsDict']]] = None,
            bitbucket_data_center_config: Optional[pulumi.Input[Union['ConnectionBitbucketDataCenterConfigArgs', 'ConnectionBitbucketDataCenterConfigArgsDict']]] = None,
            connection_id: Optional[pulumi.Input[builtins.str]] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            crypto_key_config: Optional[pulumi.Input[Union['ConnectionCryptoKeyConfigArgs', 'ConnectionCryptoKeyConfigArgsDict']]] = None,
            delete_time: Optional[pulumi.Input[builtins.str]] = None,
            disabled: Optional[pulumi.Input[builtins.bool]] = None,
            effective_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            etag: Optional[pulumi.Input[builtins.str]] = None,
            github_config: Optional[pulumi.Input[Union['ConnectionGithubConfigArgs', 'ConnectionGithubConfigArgsDict']]] = None,
            github_enterprise_config: Optional[pulumi.Input[Union['ConnectionGithubEnterpriseConfigArgs', 'ConnectionGithubEnterpriseConfigArgsDict']]] = None,
            gitlab_config: Optional[pulumi.Input[Union['ConnectionGitlabConfigArgs', 'ConnectionGitlabConfigArgsDict']]] = None,
            gitlab_enterprise_config: Optional[pulumi.Input[Union['ConnectionGitlabEnterpriseConfigArgs', 'ConnectionGitlabEnterpriseConfigArgsDict']]] = None,
            installation_states: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConnectionInstallationStateArgs', 'ConnectionInstallationStateArgsDict']]]]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            reconciling: Optional[pulumi.Input[builtins.bool]] = None,
            uid: Optional[pulumi.Input[builtins.str]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None) -> 'Connection':
        """
        Get an existing Connection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] annotations: Optional. Allows clients to store small amounts of arbitrary data.
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[Union['ConnectionBitbucketCloudConfigArgs', 'ConnectionBitbucketCloudConfigArgsDict']] bitbucket_cloud_config: Configuration for connections to an instance of Bitbucket Cloud.
               Structure is documented below.
        :param pulumi.Input[Union['ConnectionBitbucketDataCenterConfigArgs', 'ConnectionBitbucketDataCenterConfigArgsDict']] bitbucket_data_center_config: Configuration for connections to an instance of Bitbucket Data Center.
               Structure is documented below.
        :param pulumi.Input[builtins.str] connection_id: Required. Id of the requesting object
               If auto-generating Id server-side, remove this field and
               connection_id from the method_signature of Create RPC
               
               
               - - -
        :param pulumi.Input[builtins.str] create_time: Output only. [Output only] Create timestamp
        :param pulumi.Input[Union['ConnectionCryptoKeyConfigArgs', 'ConnectionCryptoKeyConfigArgsDict']] crypto_key_config: The crypto key configuration. This field is used by the Customer-managed
               encryption keys (CMEK) feature.
               Structure is documented below.
        :param pulumi.Input[builtins.str] delete_time: Output only. [Output only] Delete timestamp
        :param pulumi.Input[builtins.bool] disabled: Optional. If disabled is set to true, functionality is disabled for this connection.
               Repository based API methods and webhooks processing for repositories in
               this connection will be disabled.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.str] etag: Optional. This checksum is computed by the server based on the value of other
               fields, and may be sent on update and delete requests to ensure the
               client has an up-to-date value before proceeding.
        :param pulumi.Input[Union['ConnectionGithubConfigArgs', 'ConnectionGithubConfigArgsDict']] github_config: Configuration for connections to github.com.
               Structure is documented below.
        :param pulumi.Input[Union['ConnectionGithubEnterpriseConfigArgs', 'ConnectionGithubEnterpriseConfigArgsDict']] github_enterprise_config: Configuration for connections to an instance of GitHub Enterprise.
               Structure is documented below.
        :param pulumi.Input[Union['ConnectionGitlabConfigArgs', 'ConnectionGitlabConfigArgsDict']] gitlab_config: Configuration for connections to gitlab.com.
               Structure is documented below.
        :param pulumi.Input[Union['ConnectionGitlabEnterpriseConfigArgs', 'ConnectionGitlabEnterpriseConfigArgsDict']] gitlab_enterprise_config: Configuration for connections to an instance of GitLab Enterprise.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ConnectionInstallationStateArgs', 'ConnectionInstallationStateArgsDict']]]] installation_states: Describes stage and necessary actions to be taken by the
               user to complete the installation. Used for GitHub and GitHub Enterprise
               based connections.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Optional. Labels as key value pairs
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[builtins.str] name: Identifier. The resource name of the connection, in the format
               `projects/{project}/locations/{location}/connections/{connection_id}`.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.bool] reconciling: Output only. Set to true when the connection is being set up or updated in the
               background.
        :param pulumi.Input[builtins.str] uid: Output only. A system-assigned unique identifier for a the GitRepositoryLink.
        :param pulumi.Input[builtins.str] update_time: Output only. [Output only] Update timestamp
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConnectionState.__new__(_ConnectionState)

        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["bitbucket_cloud_config"] = bitbucket_cloud_config
        __props__.__dict__["bitbucket_data_center_config"] = bitbucket_data_center_config
        __props__.__dict__["connection_id"] = connection_id
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["crypto_key_config"] = crypto_key_config
        __props__.__dict__["delete_time"] = delete_time
        __props__.__dict__["disabled"] = disabled
        __props__.__dict__["effective_annotations"] = effective_annotations
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["etag"] = etag
        __props__.__dict__["github_config"] = github_config
        __props__.__dict__["github_enterprise_config"] = github_enterprise_config
        __props__.__dict__["gitlab_config"] = gitlab_config
        __props__.__dict__["gitlab_enterprise_config"] = gitlab_enterprise_config
        __props__.__dict__["installation_states"] = installation_states
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["reconciling"] = reconciling
        __props__.__dict__["uid"] = uid
        __props__.__dict__["update_time"] = update_time
        return Connection(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Optional. Allows clients to store small amounts of arbitrary data.
        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="bitbucketCloudConfig")
    def bitbucket_cloud_config(self) -> pulumi.Output[Optional['outputs.ConnectionBitbucketCloudConfig']]:
        """
        Configuration for connections to an instance of Bitbucket Cloud.
        Structure is documented below.
        """
        return pulumi.get(self, "bitbucket_cloud_config")

    @property
    @pulumi.getter(name="bitbucketDataCenterConfig")
    def bitbucket_data_center_config(self) -> pulumi.Output[Optional['outputs.ConnectionBitbucketDataCenterConfig']]:
        """
        Configuration for connections to an instance of Bitbucket Data Center.
        Structure is documented below.
        """
        return pulumi.get(self, "bitbucket_data_center_config")

    @property
    @pulumi.getter(name="connectionId")
    def connection_id(self) -> pulumi.Output[builtins.str]:
        """
        Required. Id of the requesting object
        If auto-generating Id server-side, remove this field and
        connection_id from the method_signature of Create RPC


        - - -
        """
        return pulumi.get(self, "connection_id")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        Output only. [Output only] Create timestamp
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="cryptoKeyConfig")
    def crypto_key_config(self) -> pulumi.Output[Optional['outputs.ConnectionCryptoKeyConfig']]:
        """
        The crypto key configuration. This field is used by the Customer-managed
        encryption keys (CMEK) feature.
        Structure is documented below.
        """
        return pulumi.get(self, "crypto_key_config")

    @property
    @pulumi.getter(name="deleteTime")
    def delete_time(self) -> pulumi.Output[builtins.str]:
        """
        Output only. [Output only] Delete timestamp
        """
        return pulumi.get(self, "delete_time")

    @property
    @pulumi.getter
    def disabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Optional. If disabled is set to true, functionality is disabled for this connection.
        Repository based API methods and webhooks processing for repositories in
        this connection will be disabled.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        return pulumi.get(self, "effective_annotations")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Optional. This checksum is computed by the server based on the value of other
        fields, and may be sent on update and delete requests to ensure the
        client has an up-to-date value before proceeding.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="githubConfig")
    def github_config(self) -> pulumi.Output[Optional['outputs.ConnectionGithubConfig']]:
        """
        Configuration for connections to github.com.
        Structure is documented below.
        """
        return pulumi.get(self, "github_config")

    @property
    @pulumi.getter(name="githubEnterpriseConfig")
    def github_enterprise_config(self) -> pulumi.Output[Optional['outputs.ConnectionGithubEnterpriseConfig']]:
        """
        Configuration for connections to an instance of GitHub Enterprise.
        Structure is documented below.
        """
        return pulumi.get(self, "github_enterprise_config")

    @property
    @pulumi.getter(name="gitlabConfig")
    def gitlab_config(self) -> pulumi.Output[Optional['outputs.ConnectionGitlabConfig']]:
        """
        Configuration for connections to gitlab.com.
        Structure is documented below.
        """
        return pulumi.get(self, "gitlab_config")

    @property
    @pulumi.getter(name="gitlabEnterpriseConfig")
    def gitlab_enterprise_config(self) -> pulumi.Output[Optional['outputs.ConnectionGitlabEnterpriseConfig']]:
        """
        Configuration for connections to an instance of GitLab Enterprise.
        Structure is documented below.
        """
        return pulumi.get(self, "gitlab_enterprise_config")

    @property
    @pulumi.getter(name="installationStates")
    def installation_states(self) -> pulumi.Output[Sequence['outputs.ConnectionInstallationState']]:
        """
        Describes stage and necessary actions to be taken by the
        user to complete the installation. Used for GitHub and GitHub Enterprise
        based connections.
        Structure is documented below.
        """
        return pulumi.get(self, "installation_states")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Optional. Labels as key value pairs
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Identifier. The resource name of the connection, in the format
        `projects/{project}/locations/{location}/connections/{connection_id}`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter
    def reconciling(self) -> pulumi.Output[builtins.bool]:
        """
        Output only. Set to true when the connection is being set up or updated in the
        background.
        """
        return pulumi.get(self, "reconciling")

    @property
    @pulumi.getter
    def uid(self) -> pulumi.Output[builtins.str]:
        """
        Output only. A system-assigned unique identifier for a the GitRepositoryLink.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        Output only. [Output only] Update timestamp
        """
        return pulumi.get(self, "update_time")

