# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CxSecuritySettingsArgs', 'CxSecuritySettings']

@pulumi.input_type
class CxSecuritySettingsArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[builtins.str],
                 location: pulumi.Input[builtins.str],
                 audio_export_settings: Optional[pulumi.Input['CxSecuritySettingsAudioExportSettingsArgs']] = None,
                 deidentify_template: Optional[pulumi.Input[builtins.str]] = None,
                 insights_export_settings: Optional[pulumi.Input['CxSecuritySettingsInsightsExportSettingsArgs']] = None,
                 inspect_template: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 purge_data_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 redaction_scope: Optional[pulumi.Input[builtins.str]] = None,
                 redaction_strategy: Optional[pulumi.Input[builtins.str]] = None,
                 retention_strategy: Optional[pulumi.Input[builtins.str]] = None,
                 retention_window_days: Optional[pulumi.Input[builtins.int]] = None):
        """
        The set of arguments for constructing a CxSecuritySettings resource.
        :param pulumi.Input[builtins.str] display_name: The human-readable name of the security settings, unique within the location.
               
               
               - - -
        :param pulumi.Input[builtins.str] location: The location these settings are located in. Settings can only be applied to an agent in the same location.
               See [Available Regions](https://cloud.google.com/dialogflow/cx/docs/concept/region#avail) for a list of supported locations.
        :param pulumi.Input['CxSecuritySettingsAudioExportSettingsArgs'] audio_export_settings: Controls audio export settings for post-conversation analytics when ingesting audio to conversations.
               If retention_strategy is set to REMOVE_AFTER_CONVERSATION or gcs_bucket is empty, audio export is disabled.
               If audio export is enabled, audio is recorded and saved to gcs_bucket, subject to retention policy of gcs_bucket.
               This setting won't effect audio input for implicit sessions via [Sessions.DetectIntent](https://cloud.google.com/dialogflow/cx/docs/reference/rest/v3/projects.locations.agents.sessions/detectIntent#google.cloud.dialogflow.cx.v3.Sessions.DetectIntent).
               Structure is documented below.
        :param pulumi.Input[builtins.str] deidentify_template: [DLP](https://cloud.google.com/dlp/docs) deidentify template name. Use this template to define de-identification configuration for the content. If empty, Dialogflow replaces sensitive info with [redacted] text.
               Note: deidentifyTemplate must be located in the same region as the SecuritySettings.
               Format: projects/<Project ID>/locations/<Location ID>/deidentifyTemplates/<Template ID> OR organizations/<Organization ID>/locations/<Location ID>/deidentifyTemplates/<Template ID>
        :param pulumi.Input['CxSecuritySettingsInsightsExportSettingsArgs'] insights_export_settings: Controls conversation exporting settings to Insights after conversation is completed.
               If retentionStrategy is set to REMOVE_AFTER_CONVERSATION, Insights export is disabled no matter what you configure here.
               Structure is documented below.
        :param pulumi.Input[builtins.str] inspect_template: [DLP](https://cloud.google.com/dlp/docs) inspect template name. Use this template to define inspect base settings. If empty, we use the default DLP inspect config.
               Note: inspectTemplate must be located in the same region as the SecuritySettings.
               Format: projects/<Project ID>/locations/<Location ID>/inspectTemplates/<Template ID> OR organizations/<Organization ID>/locations/<Location ID>/inspectTemplates/<Template ID>
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] purge_data_types: List of types of data to remove when retention settings triggers purge.
               Each value may be one of: `DIALOGFLOW_HISTORY`.
        :param pulumi.Input[builtins.str] redaction_scope: Defines what types of data to redact. If not set, defaults to not redacting any kind of data.
               * REDACT_DISK_STORAGE: On data to be written to disk or similar devices that are capable of holding data even if power is disconnected. This includes data that are temporarily saved on disk.
               Possible values are: `REDACT_DISK_STORAGE`.
        :param pulumi.Input[builtins.str] redaction_strategy: Defines how we redact data. If not set, defaults to not redacting.
               * REDACT_WITH_SERVICE: Call redaction service to clean up the data to be persisted.
               Possible values are: `REDACT_WITH_SERVICE`.
        :param pulumi.Input[builtins.str] retention_strategy: Defines how long we retain persisted data that contains sensitive info. Only one of `retention_window_days` and `retention_strategy` may be set.
               * REMOVE_AFTER_CONVERSATION: Removes data when the conversation ends. If there is no conversation explicitly established, a default conversation ends when the corresponding Dialogflow session ends.
               Possible values are: `REMOVE_AFTER_CONVERSATION`.
        :param pulumi.Input[builtins.int] retention_window_days: Retains the data for the specified number of days. User must set a value lower than Dialogflow's default 365d TTL (30 days for Agent Assist traffic), higher value will be ignored and use default. Setting a value higher than that has no effect. A missing value or setting to 0 also means we use default TTL.
               Only one of `retention_window_days` and `retention_strategy` may be set.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "location", location)
        if audio_export_settings is not None:
            pulumi.set(__self__, "audio_export_settings", audio_export_settings)
        if deidentify_template is not None:
            pulumi.set(__self__, "deidentify_template", deidentify_template)
        if insights_export_settings is not None:
            pulumi.set(__self__, "insights_export_settings", insights_export_settings)
        if inspect_template is not None:
            pulumi.set(__self__, "inspect_template", inspect_template)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if purge_data_types is not None:
            pulumi.set(__self__, "purge_data_types", purge_data_types)
        if redaction_scope is not None:
            pulumi.set(__self__, "redaction_scope", redaction_scope)
        if redaction_strategy is not None:
            pulumi.set(__self__, "redaction_strategy", redaction_strategy)
        if retention_strategy is not None:
            pulumi.set(__self__, "retention_strategy", retention_strategy)
        if retention_window_days is not None:
            pulumi.set(__self__, "retention_window_days", retention_window_days)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[builtins.str]:
        """
        The human-readable name of the security settings, unique within the location.


        - - -
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        The location these settings are located in. Settings can only be applied to an agent in the same location.
        See [Available Regions](https://cloud.google.com/dialogflow/cx/docs/concept/region#avail) for a list of supported locations.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="audioExportSettings")
    def audio_export_settings(self) -> Optional[pulumi.Input['CxSecuritySettingsAudioExportSettingsArgs']]:
        """
        Controls audio export settings for post-conversation analytics when ingesting audio to conversations.
        If retention_strategy is set to REMOVE_AFTER_CONVERSATION or gcs_bucket is empty, audio export is disabled.
        If audio export is enabled, audio is recorded and saved to gcs_bucket, subject to retention policy of gcs_bucket.
        This setting won't effect audio input for implicit sessions via [Sessions.DetectIntent](https://cloud.google.com/dialogflow/cx/docs/reference/rest/v3/projects.locations.agents.sessions/detectIntent#google.cloud.dialogflow.cx.v3.Sessions.DetectIntent).
        Structure is documented below.
        """
        return pulumi.get(self, "audio_export_settings")

    @audio_export_settings.setter
    def audio_export_settings(self, value: Optional[pulumi.Input['CxSecuritySettingsAudioExportSettingsArgs']]):
        pulumi.set(self, "audio_export_settings", value)

    @property
    @pulumi.getter(name="deidentifyTemplate")
    def deidentify_template(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        [DLP](https://cloud.google.com/dlp/docs) deidentify template name. Use this template to define de-identification configuration for the content. If empty, Dialogflow replaces sensitive info with [redacted] text.
        Note: deidentifyTemplate must be located in the same region as the SecuritySettings.
        Format: projects/<Project ID>/locations/<Location ID>/deidentifyTemplates/<Template ID> OR organizations/<Organization ID>/locations/<Location ID>/deidentifyTemplates/<Template ID>
        """
        return pulumi.get(self, "deidentify_template")

    @deidentify_template.setter
    def deidentify_template(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "deidentify_template", value)

    @property
    @pulumi.getter(name="insightsExportSettings")
    def insights_export_settings(self) -> Optional[pulumi.Input['CxSecuritySettingsInsightsExportSettingsArgs']]:
        """
        Controls conversation exporting settings to Insights after conversation is completed.
        If retentionStrategy is set to REMOVE_AFTER_CONVERSATION, Insights export is disabled no matter what you configure here.
        Structure is documented below.
        """
        return pulumi.get(self, "insights_export_settings")

    @insights_export_settings.setter
    def insights_export_settings(self, value: Optional[pulumi.Input['CxSecuritySettingsInsightsExportSettingsArgs']]):
        pulumi.set(self, "insights_export_settings", value)

    @property
    @pulumi.getter(name="inspectTemplate")
    def inspect_template(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        [DLP](https://cloud.google.com/dlp/docs) inspect template name. Use this template to define inspect base settings. If empty, we use the default DLP inspect config.
        Note: inspectTemplate must be located in the same region as the SecuritySettings.
        Format: projects/<Project ID>/locations/<Location ID>/inspectTemplates/<Template ID> OR organizations/<Organization ID>/locations/<Location ID>/inspectTemplates/<Template ID>
        """
        return pulumi.get(self, "inspect_template")

    @inspect_template.setter
    def inspect_template(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "inspect_template", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="purgeDataTypes")
    def purge_data_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of types of data to remove when retention settings triggers purge.
        Each value may be one of: `DIALOGFLOW_HISTORY`.
        """
        return pulumi.get(self, "purge_data_types")

    @purge_data_types.setter
    def purge_data_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "purge_data_types", value)

    @property
    @pulumi.getter(name="redactionScope")
    def redaction_scope(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Defines what types of data to redact. If not set, defaults to not redacting any kind of data.
        * REDACT_DISK_STORAGE: On data to be written to disk or similar devices that are capable of holding data even if power is disconnected. This includes data that are temporarily saved on disk.
        Possible values are: `REDACT_DISK_STORAGE`.
        """
        return pulumi.get(self, "redaction_scope")

    @redaction_scope.setter
    def redaction_scope(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "redaction_scope", value)

    @property
    @pulumi.getter(name="redactionStrategy")
    def redaction_strategy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Defines how we redact data. If not set, defaults to not redacting.
        * REDACT_WITH_SERVICE: Call redaction service to clean up the data to be persisted.
        Possible values are: `REDACT_WITH_SERVICE`.
        """
        return pulumi.get(self, "redaction_strategy")

    @redaction_strategy.setter
    def redaction_strategy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "redaction_strategy", value)

    @property
    @pulumi.getter(name="retentionStrategy")
    def retention_strategy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Defines how long we retain persisted data that contains sensitive info. Only one of `retention_window_days` and `retention_strategy` may be set.
        * REMOVE_AFTER_CONVERSATION: Removes data when the conversation ends. If there is no conversation explicitly established, a default conversation ends when the corresponding Dialogflow session ends.
        Possible values are: `REMOVE_AFTER_CONVERSATION`.
        """
        return pulumi.get(self, "retention_strategy")

    @retention_strategy.setter
    def retention_strategy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "retention_strategy", value)

    @property
    @pulumi.getter(name="retentionWindowDays")
    def retention_window_days(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Retains the data for the specified number of days. User must set a value lower than Dialogflow's default 365d TTL (30 days for Agent Assist traffic), higher value will be ignored and use default. Setting a value higher than that has no effect. A missing value or setting to 0 also means we use default TTL.
        Only one of `retention_window_days` and `retention_strategy` may be set.
        """
        return pulumi.get(self, "retention_window_days")

    @retention_window_days.setter
    def retention_window_days(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "retention_window_days", value)


@pulumi.input_type
class _CxSecuritySettingsState:
    def __init__(__self__, *,
                 audio_export_settings: Optional[pulumi.Input['CxSecuritySettingsAudioExportSettingsArgs']] = None,
                 deidentify_template: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 insights_export_settings: Optional[pulumi.Input['CxSecuritySettingsInsightsExportSettingsArgs']] = None,
                 inspect_template: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 purge_data_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 redaction_scope: Optional[pulumi.Input[builtins.str]] = None,
                 redaction_strategy: Optional[pulumi.Input[builtins.str]] = None,
                 retention_strategy: Optional[pulumi.Input[builtins.str]] = None,
                 retention_window_days: Optional[pulumi.Input[builtins.int]] = None):
        """
        Input properties used for looking up and filtering CxSecuritySettings resources.
        :param pulumi.Input['CxSecuritySettingsAudioExportSettingsArgs'] audio_export_settings: Controls audio export settings for post-conversation analytics when ingesting audio to conversations.
               If retention_strategy is set to REMOVE_AFTER_CONVERSATION or gcs_bucket is empty, audio export is disabled.
               If audio export is enabled, audio is recorded and saved to gcs_bucket, subject to retention policy of gcs_bucket.
               This setting won't effect audio input for implicit sessions via [Sessions.DetectIntent](https://cloud.google.com/dialogflow/cx/docs/reference/rest/v3/projects.locations.agents.sessions/detectIntent#google.cloud.dialogflow.cx.v3.Sessions.DetectIntent).
               Structure is documented below.
        :param pulumi.Input[builtins.str] deidentify_template: [DLP](https://cloud.google.com/dlp/docs) deidentify template name. Use this template to define de-identification configuration for the content. If empty, Dialogflow replaces sensitive info with [redacted] text.
               Note: deidentifyTemplate must be located in the same region as the SecuritySettings.
               Format: projects/<Project ID>/locations/<Location ID>/deidentifyTemplates/<Template ID> OR organizations/<Organization ID>/locations/<Location ID>/deidentifyTemplates/<Template ID>
        :param pulumi.Input[builtins.str] display_name: The human-readable name of the security settings, unique within the location.
               
               
               - - -
        :param pulumi.Input['CxSecuritySettingsInsightsExportSettingsArgs'] insights_export_settings: Controls conversation exporting settings to Insights after conversation is completed.
               If retentionStrategy is set to REMOVE_AFTER_CONVERSATION, Insights export is disabled no matter what you configure here.
               Structure is documented below.
        :param pulumi.Input[builtins.str] inspect_template: [DLP](https://cloud.google.com/dlp/docs) inspect template name. Use this template to define inspect base settings. If empty, we use the default DLP inspect config.
               Note: inspectTemplate must be located in the same region as the SecuritySettings.
               Format: projects/<Project ID>/locations/<Location ID>/inspectTemplates/<Template ID> OR organizations/<Organization ID>/locations/<Location ID>/inspectTemplates/<Template ID>
        :param pulumi.Input[builtins.str] location: The location these settings are located in. Settings can only be applied to an agent in the same location.
               See [Available Regions](https://cloud.google.com/dialogflow/cx/docs/concept/region#avail) for a list of supported locations.
        :param pulumi.Input[builtins.str] name: The unique identifier of the settings.
               Format: projects/<Project ID>/locations/<Location ID>/securitySettings/<Security Settings ID>.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] purge_data_types: List of types of data to remove when retention settings triggers purge.
               Each value may be one of: `DIALOGFLOW_HISTORY`.
        :param pulumi.Input[builtins.str] redaction_scope: Defines what types of data to redact. If not set, defaults to not redacting any kind of data.
               * REDACT_DISK_STORAGE: On data to be written to disk or similar devices that are capable of holding data even if power is disconnected. This includes data that are temporarily saved on disk.
               Possible values are: `REDACT_DISK_STORAGE`.
        :param pulumi.Input[builtins.str] redaction_strategy: Defines how we redact data. If not set, defaults to not redacting.
               * REDACT_WITH_SERVICE: Call redaction service to clean up the data to be persisted.
               Possible values are: `REDACT_WITH_SERVICE`.
        :param pulumi.Input[builtins.str] retention_strategy: Defines how long we retain persisted data that contains sensitive info. Only one of `retention_window_days` and `retention_strategy` may be set.
               * REMOVE_AFTER_CONVERSATION: Removes data when the conversation ends. If there is no conversation explicitly established, a default conversation ends when the corresponding Dialogflow session ends.
               Possible values are: `REMOVE_AFTER_CONVERSATION`.
        :param pulumi.Input[builtins.int] retention_window_days: Retains the data for the specified number of days. User must set a value lower than Dialogflow's default 365d TTL (30 days for Agent Assist traffic), higher value will be ignored and use default. Setting a value higher than that has no effect. A missing value or setting to 0 also means we use default TTL.
               Only one of `retention_window_days` and `retention_strategy` may be set.
        """
        if audio_export_settings is not None:
            pulumi.set(__self__, "audio_export_settings", audio_export_settings)
        if deidentify_template is not None:
            pulumi.set(__self__, "deidentify_template", deidentify_template)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if insights_export_settings is not None:
            pulumi.set(__self__, "insights_export_settings", insights_export_settings)
        if inspect_template is not None:
            pulumi.set(__self__, "inspect_template", inspect_template)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if purge_data_types is not None:
            pulumi.set(__self__, "purge_data_types", purge_data_types)
        if redaction_scope is not None:
            pulumi.set(__self__, "redaction_scope", redaction_scope)
        if redaction_strategy is not None:
            pulumi.set(__self__, "redaction_strategy", redaction_strategy)
        if retention_strategy is not None:
            pulumi.set(__self__, "retention_strategy", retention_strategy)
        if retention_window_days is not None:
            pulumi.set(__self__, "retention_window_days", retention_window_days)

    @property
    @pulumi.getter(name="audioExportSettings")
    def audio_export_settings(self) -> Optional[pulumi.Input['CxSecuritySettingsAudioExportSettingsArgs']]:
        """
        Controls audio export settings for post-conversation analytics when ingesting audio to conversations.
        If retention_strategy is set to REMOVE_AFTER_CONVERSATION or gcs_bucket is empty, audio export is disabled.
        If audio export is enabled, audio is recorded and saved to gcs_bucket, subject to retention policy of gcs_bucket.
        This setting won't effect audio input for implicit sessions via [Sessions.DetectIntent](https://cloud.google.com/dialogflow/cx/docs/reference/rest/v3/projects.locations.agents.sessions/detectIntent#google.cloud.dialogflow.cx.v3.Sessions.DetectIntent).
        Structure is documented below.
        """
        return pulumi.get(self, "audio_export_settings")

    @audio_export_settings.setter
    def audio_export_settings(self, value: Optional[pulumi.Input['CxSecuritySettingsAudioExportSettingsArgs']]):
        pulumi.set(self, "audio_export_settings", value)

    @property
    @pulumi.getter(name="deidentifyTemplate")
    def deidentify_template(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        [DLP](https://cloud.google.com/dlp/docs) deidentify template name. Use this template to define de-identification configuration for the content. If empty, Dialogflow replaces sensitive info with [redacted] text.
        Note: deidentifyTemplate must be located in the same region as the SecuritySettings.
        Format: projects/<Project ID>/locations/<Location ID>/deidentifyTemplates/<Template ID> OR organizations/<Organization ID>/locations/<Location ID>/deidentifyTemplates/<Template ID>
        """
        return pulumi.get(self, "deidentify_template")

    @deidentify_template.setter
    def deidentify_template(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "deidentify_template", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The human-readable name of the security settings, unique within the location.


        - - -
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="insightsExportSettings")
    def insights_export_settings(self) -> Optional[pulumi.Input['CxSecuritySettingsInsightsExportSettingsArgs']]:
        """
        Controls conversation exporting settings to Insights after conversation is completed.
        If retentionStrategy is set to REMOVE_AFTER_CONVERSATION, Insights export is disabled no matter what you configure here.
        Structure is documented below.
        """
        return pulumi.get(self, "insights_export_settings")

    @insights_export_settings.setter
    def insights_export_settings(self, value: Optional[pulumi.Input['CxSecuritySettingsInsightsExportSettingsArgs']]):
        pulumi.set(self, "insights_export_settings", value)

    @property
    @pulumi.getter(name="inspectTemplate")
    def inspect_template(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        [DLP](https://cloud.google.com/dlp/docs) inspect template name. Use this template to define inspect base settings. If empty, we use the default DLP inspect config.
        Note: inspectTemplate must be located in the same region as the SecuritySettings.
        Format: projects/<Project ID>/locations/<Location ID>/inspectTemplates/<Template ID> OR organizations/<Organization ID>/locations/<Location ID>/inspectTemplates/<Template ID>
        """
        return pulumi.get(self, "inspect_template")

    @inspect_template.setter
    def inspect_template(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "inspect_template", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location these settings are located in. Settings can only be applied to an agent in the same location.
        See [Available Regions](https://cloud.google.com/dialogflow/cx/docs/concept/region#avail) for a list of supported locations.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unique identifier of the settings.
        Format: projects/<Project ID>/locations/<Location ID>/securitySettings/<Security Settings ID>.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="purgeDataTypes")
    def purge_data_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of types of data to remove when retention settings triggers purge.
        Each value may be one of: `DIALOGFLOW_HISTORY`.
        """
        return pulumi.get(self, "purge_data_types")

    @purge_data_types.setter
    def purge_data_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "purge_data_types", value)

    @property
    @pulumi.getter(name="redactionScope")
    def redaction_scope(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Defines what types of data to redact. If not set, defaults to not redacting any kind of data.
        * REDACT_DISK_STORAGE: On data to be written to disk or similar devices that are capable of holding data even if power is disconnected. This includes data that are temporarily saved on disk.
        Possible values are: `REDACT_DISK_STORAGE`.
        """
        return pulumi.get(self, "redaction_scope")

    @redaction_scope.setter
    def redaction_scope(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "redaction_scope", value)

    @property
    @pulumi.getter(name="redactionStrategy")
    def redaction_strategy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Defines how we redact data. If not set, defaults to not redacting.
        * REDACT_WITH_SERVICE: Call redaction service to clean up the data to be persisted.
        Possible values are: `REDACT_WITH_SERVICE`.
        """
        return pulumi.get(self, "redaction_strategy")

    @redaction_strategy.setter
    def redaction_strategy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "redaction_strategy", value)

    @property
    @pulumi.getter(name="retentionStrategy")
    def retention_strategy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Defines how long we retain persisted data that contains sensitive info. Only one of `retention_window_days` and `retention_strategy` may be set.
        * REMOVE_AFTER_CONVERSATION: Removes data when the conversation ends. If there is no conversation explicitly established, a default conversation ends when the corresponding Dialogflow session ends.
        Possible values are: `REMOVE_AFTER_CONVERSATION`.
        """
        return pulumi.get(self, "retention_strategy")

    @retention_strategy.setter
    def retention_strategy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "retention_strategy", value)

    @property
    @pulumi.getter(name="retentionWindowDays")
    def retention_window_days(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Retains the data for the specified number of days. User must set a value lower than Dialogflow's default 365d TTL (30 days for Agent Assist traffic), higher value will be ignored and use default. Setting a value higher than that has no effect. A missing value or setting to 0 also means we use default TTL.
        Only one of `retention_window_days` and `retention_strategy` may be set.
        """
        return pulumi.get(self, "retention_window_days")

    @retention_window_days.setter
    def retention_window_days(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "retention_window_days", value)


@pulumi.type_token("gcp:diagflow/cxSecuritySettings:CxSecuritySettings")
class CxSecuritySettings(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 audio_export_settings: Optional[pulumi.Input[Union['CxSecuritySettingsAudioExportSettingsArgs', 'CxSecuritySettingsAudioExportSettingsArgsDict']]] = None,
                 deidentify_template: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 insights_export_settings: Optional[pulumi.Input[Union['CxSecuritySettingsInsightsExportSettingsArgs', 'CxSecuritySettingsInsightsExportSettingsArgsDict']]] = None,
                 inspect_template: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 purge_data_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 redaction_scope: Optional[pulumi.Input[builtins.str]] = None,
                 redaction_strategy: Optional[pulumi.Input[builtins.str]] = None,
                 retention_strategy: Optional[pulumi.Input[builtins.str]] = None,
                 retention_window_days: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        """
        Represents the settings related to security issues, such as data redaction and data retention. It may take hours for updates on the settings to propagate to all the related components and take effect.
        Multiple security settings can be configured in each location. Each agent can specify the security settings to apply, and each setting can be applied to multiple agents in the same project and location.

        To get more information about SecuritySettings, see:

        * [API documentation](https://cloud.google.com/dialogflow/cx/docs/reference/rest/v3/projects.locations.securitySettings)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/dialogflow/cx/docs)

        ## Example Usage

        ### Dialogflowcx Security Settings Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic_security_settings = gcp.diagflow.CxSecuritySettings("basic_security_settings",
            display_name="dialogflowcx-security-settings",
            location="global",
            purge_data_types=[],
            retention_window_days=7)
        ```
        ### Dialogflowcx Security Settings Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        inspect = gcp.dataloss.PreventionInspectTemplate("inspect",
            parent="projects/my-project-name/locations/global",
            display_name="dialogflowcx-inspect-template",
            inspect_config={
                "info_types": [{
                    "name": "EMAIL_ADDRESS",
                }],
            })
        deidentify = gcp.dataloss.PreventionDeidentifyTemplate("deidentify",
            parent="projects/my-project-name/locations/global",
            display_name="dialogflowcx-deidentify-template",
            deidentify_config={
                "info_type_transformations": {
                    "transformations": [{
                        "primitive_transformation": {
                            "replace_config": {
                                "new_value": {
                                    "string_value": "[REDACTED]",
                                },
                            },
                        },
                    }],
                },
            })
        bucket = gcp.storage.Bucket("bucket",
            name="dialogflowcx-bucket",
            location="US",
            uniform_bucket_level_access=True)
        basic_security_settings = gcp.diagflow.CxSecuritySettings("basic_security_settings",
            display_name="dialogflowcx-security-settings",
            location="global",
            redaction_strategy="REDACT_WITH_SERVICE",
            redaction_scope="REDACT_DISK_STORAGE",
            inspect_template=inspect.id,
            deidentify_template=deidentify.id,
            purge_data_types=["DIALOGFLOW_HISTORY"],
            audio_export_settings={
                "gcs_bucket": bucket.id,
                "audio_export_pattern": "export",
                "enable_audio_redaction": True,
                "audio_format": "OGG",
            },
            insights_export_settings={
                "enable_insights_export": True,
            },
            retention_strategy="REMOVE_AFTER_CONVERSATION")
        ```

        ## Import

        SecuritySettings can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/securitySettings/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, SecuritySettings can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:diagflow/cxSecuritySettings:CxSecuritySettings default projects/{{project}}/locations/{{location}}/securitySettings/{{name}}
        ```

        ```sh
        $ pulumi import gcp:diagflow/cxSecuritySettings:CxSecuritySettings default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:diagflow/cxSecuritySettings:CxSecuritySettings default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['CxSecuritySettingsAudioExportSettingsArgs', 'CxSecuritySettingsAudioExportSettingsArgsDict']] audio_export_settings: Controls audio export settings for post-conversation analytics when ingesting audio to conversations.
               If retention_strategy is set to REMOVE_AFTER_CONVERSATION or gcs_bucket is empty, audio export is disabled.
               If audio export is enabled, audio is recorded and saved to gcs_bucket, subject to retention policy of gcs_bucket.
               This setting won't effect audio input for implicit sessions via [Sessions.DetectIntent](https://cloud.google.com/dialogflow/cx/docs/reference/rest/v3/projects.locations.agents.sessions/detectIntent#google.cloud.dialogflow.cx.v3.Sessions.DetectIntent).
               Structure is documented below.
        :param pulumi.Input[builtins.str] deidentify_template: [DLP](https://cloud.google.com/dlp/docs) deidentify template name. Use this template to define de-identification configuration for the content. If empty, Dialogflow replaces sensitive info with [redacted] text.
               Note: deidentifyTemplate must be located in the same region as the SecuritySettings.
               Format: projects/<Project ID>/locations/<Location ID>/deidentifyTemplates/<Template ID> OR organizations/<Organization ID>/locations/<Location ID>/deidentifyTemplates/<Template ID>
        :param pulumi.Input[builtins.str] display_name: The human-readable name of the security settings, unique within the location.
               
               
               - - -
        :param pulumi.Input[Union['CxSecuritySettingsInsightsExportSettingsArgs', 'CxSecuritySettingsInsightsExportSettingsArgsDict']] insights_export_settings: Controls conversation exporting settings to Insights after conversation is completed.
               If retentionStrategy is set to REMOVE_AFTER_CONVERSATION, Insights export is disabled no matter what you configure here.
               Structure is documented below.
        :param pulumi.Input[builtins.str] inspect_template: [DLP](https://cloud.google.com/dlp/docs) inspect template name. Use this template to define inspect base settings. If empty, we use the default DLP inspect config.
               Note: inspectTemplate must be located in the same region as the SecuritySettings.
               Format: projects/<Project ID>/locations/<Location ID>/inspectTemplates/<Template ID> OR organizations/<Organization ID>/locations/<Location ID>/inspectTemplates/<Template ID>
        :param pulumi.Input[builtins.str] location: The location these settings are located in. Settings can only be applied to an agent in the same location.
               See [Available Regions](https://cloud.google.com/dialogflow/cx/docs/concept/region#avail) for a list of supported locations.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] purge_data_types: List of types of data to remove when retention settings triggers purge.
               Each value may be one of: `DIALOGFLOW_HISTORY`.
        :param pulumi.Input[builtins.str] redaction_scope: Defines what types of data to redact. If not set, defaults to not redacting any kind of data.
               * REDACT_DISK_STORAGE: On data to be written to disk or similar devices that are capable of holding data even if power is disconnected. This includes data that are temporarily saved on disk.
               Possible values are: `REDACT_DISK_STORAGE`.
        :param pulumi.Input[builtins.str] redaction_strategy: Defines how we redact data. If not set, defaults to not redacting.
               * REDACT_WITH_SERVICE: Call redaction service to clean up the data to be persisted.
               Possible values are: `REDACT_WITH_SERVICE`.
        :param pulumi.Input[builtins.str] retention_strategy: Defines how long we retain persisted data that contains sensitive info. Only one of `retention_window_days` and `retention_strategy` may be set.
               * REMOVE_AFTER_CONVERSATION: Removes data when the conversation ends. If there is no conversation explicitly established, a default conversation ends when the corresponding Dialogflow session ends.
               Possible values are: `REMOVE_AFTER_CONVERSATION`.
        :param pulumi.Input[builtins.int] retention_window_days: Retains the data for the specified number of days. User must set a value lower than Dialogflow's default 365d TTL (30 days for Agent Assist traffic), higher value will be ignored and use default. Setting a value higher than that has no effect. A missing value or setting to 0 also means we use default TTL.
               Only one of `retention_window_days` and `retention_strategy` may be set.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CxSecuritySettingsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Represents the settings related to security issues, such as data redaction and data retention. It may take hours for updates on the settings to propagate to all the related components and take effect.
        Multiple security settings can be configured in each location. Each agent can specify the security settings to apply, and each setting can be applied to multiple agents in the same project and location.

        To get more information about SecuritySettings, see:

        * [API documentation](https://cloud.google.com/dialogflow/cx/docs/reference/rest/v3/projects.locations.securitySettings)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/dialogflow/cx/docs)

        ## Example Usage

        ### Dialogflowcx Security Settings Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic_security_settings = gcp.diagflow.CxSecuritySettings("basic_security_settings",
            display_name="dialogflowcx-security-settings",
            location="global",
            purge_data_types=[],
            retention_window_days=7)
        ```
        ### Dialogflowcx Security Settings Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        inspect = gcp.dataloss.PreventionInspectTemplate("inspect",
            parent="projects/my-project-name/locations/global",
            display_name="dialogflowcx-inspect-template",
            inspect_config={
                "info_types": [{
                    "name": "EMAIL_ADDRESS",
                }],
            })
        deidentify = gcp.dataloss.PreventionDeidentifyTemplate("deidentify",
            parent="projects/my-project-name/locations/global",
            display_name="dialogflowcx-deidentify-template",
            deidentify_config={
                "info_type_transformations": {
                    "transformations": [{
                        "primitive_transformation": {
                            "replace_config": {
                                "new_value": {
                                    "string_value": "[REDACTED]",
                                },
                            },
                        },
                    }],
                },
            })
        bucket = gcp.storage.Bucket("bucket",
            name="dialogflowcx-bucket",
            location="US",
            uniform_bucket_level_access=True)
        basic_security_settings = gcp.diagflow.CxSecuritySettings("basic_security_settings",
            display_name="dialogflowcx-security-settings",
            location="global",
            redaction_strategy="REDACT_WITH_SERVICE",
            redaction_scope="REDACT_DISK_STORAGE",
            inspect_template=inspect.id,
            deidentify_template=deidentify.id,
            purge_data_types=["DIALOGFLOW_HISTORY"],
            audio_export_settings={
                "gcs_bucket": bucket.id,
                "audio_export_pattern": "export",
                "enable_audio_redaction": True,
                "audio_format": "OGG",
            },
            insights_export_settings={
                "enable_insights_export": True,
            },
            retention_strategy="REMOVE_AFTER_CONVERSATION")
        ```

        ## Import

        SecuritySettings can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/securitySettings/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, SecuritySettings can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:diagflow/cxSecuritySettings:CxSecuritySettings default projects/{{project}}/locations/{{location}}/securitySettings/{{name}}
        ```

        ```sh
        $ pulumi import gcp:diagflow/cxSecuritySettings:CxSecuritySettings default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:diagflow/cxSecuritySettings:CxSecuritySettings default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param CxSecuritySettingsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CxSecuritySettingsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 audio_export_settings: Optional[pulumi.Input[Union['CxSecuritySettingsAudioExportSettingsArgs', 'CxSecuritySettingsAudioExportSettingsArgsDict']]] = None,
                 deidentify_template: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 insights_export_settings: Optional[pulumi.Input[Union['CxSecuritySettingsInsightsExportSettingsArgs', 'CxSecuritySettingsInsightsExportSettingsArgsDict']]] = None,
                 inspect_template: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 purge_data_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 redaction_scope: Optional[pulumi.Input[builtins.str]] = None,
                 redaction_strategy: Optional[pulumi.Input[builtins.str]] = None,
                 retention_strategy: Optional[pulumi.Input[builtins.str]] = None,
                 retention_window_days: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CxSecuritySettingsArgs.__new__(CxSecuritySettingsArgs)

            __props__.__dict__["audio_export_settings"] = audio_export_settings
            __props__.__dict__["deidentify_template"] = deidentify_template
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["insights_export_settings"] = insights_export_settings
            __props__.__dict__["inspect_template"] = inspect_template
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            __props__.__dict__["purge_data_types"] = purge_data_types
            __props__.__dict__["redaction_scope"] = redaction_scope
            __props__.__dict__["redaction_strategy"] = redaction_strategy
            __props__.__dict__["retention_strategy"] = retention_strategy
            __props__.__dict__["retention_window_days"] = retention_window_days
            __props__.__dict__["name"] = None
        super(CxSecuritySettings, __self__).__init__(
            'gcp:diagflow/cxSecuritySettings:CxSecuritySettings',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            audio_export_settings: Optional[pulumi.Input[Union['CxSecuritySettingsAudioExportSettingsArgs', 'CxSecuritySettingsAudioExportSettingsArgsDict']]] = None,
            deidentify_template: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            insights_export_settings: Optional[pulumi.Input[Union['CxSecuritySettingsInsightsExportSettingsArgs', 'CxSecuritySettingsInsightsExportSettingsArgsDict']]] = None,
            inspect_template: Optional[pulumi.Input[builtins.str]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            purge_data_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            redaction_scope: Optional[pulumi.Input[builtins.str]] = None,
            redaction_strategy: Optional[pulumi.Input[builtins.str]] = None,
            retention_strategy: Optional[pulumi.Input[builtins.str]] = None,
            retention_window_days: Optional[pulumi.Input[builtins.int]] = None) -> 'CxSecuritySettings':
        """
        Get an existing CxSecuritySettings resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['CxSecuritySettingsAudioExportSettingsArgs', 'CxSecuritySettingsAudioExportSettingsArgsDict']] audio_export_settings: Controls audio export settings for post-conversation analytics when ingesting audio to conversations.
               If retention_strategy is set to REMOVE_AFTER_CONVERSATION or gcs_bucket is empty, audio export is disabled.
               If audio export is enabled, audio is recorded and saved to gcs_bucket, subject to retention policy of gcs_bucket.
               This setting won't effect audio input for implicit sessions via [Sessions.DetectIntent](https://cloud.google.com/dialogflow/cx/docs/reference/rest/v3/projects.locations.agents.sessions/detectIntent#google.cloud.dialogflow.cx.v3.Sessions.DetectIntent).
               Structure is documented below.
        :param pulumi.Input[builtins.str] deidentify_template: [DLP](https://cloud.google.com/dlp/docs) deidentify template name. Use this template to define de-identification configuration for the content. If empty, Dialogflow replaces sensitive info with [redacted] text.
               Note: deidentifyTemplate must be located in the same region as the SecuritySettings.
               Format: projects/<Project ID>/locations/<Location ID>/deidentifyTemplates/<Template ID> OR organizations/<Organization ID>/locations/<Location ID>/deidentifyTemplates/<Template ID>
        :param pulumi.Input[builtins.str] display_name: The human-readable name of the security settings, unique within the location.
               
               
               - - -
        :param pulumi.Input[Union['CxSecuritySettingsInsightsExportSettingsArgs', 'CxSecuritySettingsInsightsExportSettingsArgsDict']] insights_export_settings: Controls conversation exporting settings to Insights after conversation is completed.
               If retentionStrategy is set to REMOVE_AFTER_CONVERSATION, Insights export is disabled no matter what you configure here.
               Structure is documented below.
        :param pulumi.Input[builtins.str] inspect_template: [DLP](https://cloud.google.com/dlp/docs) inspect template name. Use this template to define inspect base settings. If empty, we use the default DLP inspect config.
               Note: inspectTemplate must be located in the same region as the SecuritySettings.
               Format: projects/<Project ID>/locations/<Location ID>/inspectTemplates/<Template ID> OR organizations/<Organization ID>/locations/<Location ID>/inspectTemplates/<Template ID>
        :param pulumi.Input[builtins.str] location: The location these settings are located in. Settings can only be applied to an agent in the same location.
               See [Available Regions](https://cloud.google.com/dialogflow/cx/docs/concept/region#avail) for a list of supported locations.
        :param pulumi.Input[builtins.str] name: The unique identifier of the settings.
               Format: projects/<Project ID>/locations/<Location ID>/securitySettings/<Security Settings ID>.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] purge_data_types: List of types of data to remove when retention settings triggers purge.
               Each value may be one of: `DIALOGFLOW_HISTORY`.
        :param pulumi.Input[builtins.str] redaction_scope: Defines what types of data to redact. If not set, defaults to not redacting any kind of data.
               * REDACT_DISK_STORAGE: On data to be written to disk or similar devices that are capable of holding data even if power is disconnected. This includes data that are temporarily saved on disk.
               Possible values are: `REDACT_DISK_STORAGE`.
        :param pulumi.Input[builtins.str] redaction_strategy: Defines how we redact data. If not set, defaults to not redacting.
               * REDACT_WITH_SERVICE: Call redaction service to clean up the data to be persisted.
               Possible values are: `REDACT_WITH_SERVICE`.
        :param pulumi.Input[builtins.str] retention_strategy: Defines how long we retain persisted data that contains sensitive info. Only one of `retention_window_days` and `retention_strategy` may be set.
               * REMOVE_AFTER_CONVERSATION: Removes data when the conversation ends. If there is no conversation explicitly established, a default conversation ends when the corresponding Dialogflow session ends.
               Possible values are: `REMOVE_AFTER_CONVERSATION`.
        :param pulumi.Input[builtins.int] retention_window_days: Retains the data for the specified number of days. User must set a value lower than Dialogflow's default 365d TTL (30 days for Agent Assist traffic), higher value will be ignored and use default. Setting a value higher than that has no effect. A missing value or setting to 0 also means we use default TTL.
               Only one of `retention_window_days` and `retention_strategy` may be set.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CxSecuritySettingsState.__new__(_CxSecuritySettingsState)

        __props__.__dict__["audio_export_settings"] = audio_export_settings
        __props__.__dict__["deidentify_template"] = deidentify_template
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["insights_export_settings"] = insights_export_settings
        __props__.__dict__["inspect_template"] = inspect_template
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["purge_data_types"] = purge_data_types
        __props__.__dict__["redaction_scope"] = redaction_scope
        __props__.__dict__["redaction_strategy"] = redaction_strategy
        __props__.__dict__["retention_strategy"] = retention_strategy
        __props__.__dict__["retention_window_days"] = retention_window_days
        return CxSecuritySettings(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="audioExportSettings")
    def audio_export_settings(self) -> pulumi.Output[Optional['outputs.CxSecuritySettingsAudioExportSettings']]:
        """
        Controls audio export settings for post-conversation analytics when ingesting audio to conversations.
        If retention_strategy is set to REMOVE_AFTER_CONVERSATION or gcs_bucket is empty, audio export is disabled.
        If audio export is enabled, audio is recorded and saved to gcs_bucket, subject to retention policy of gcs_bucket.
        This setting won't effect audio input for implicit sessions via [Sessions.DetectIntent](https://cloud.google.com/dialogflow/cx/docs/reference/rest/v3/projects.locations.agents.sessions/detectIntent#google.cloud.dialogflow.cx.v3.Sessions.DetectIntent).
        Structure is documented below.
        """
        return pulumi.get(self, "audio_export_settings")

    @property
    @pulumi.getter(name="deidentifyTemplate")
    def deidentify_template(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        [DLP](https://cloud.google.com/dlp/docs) deidentify template name. Use this template to define de-identification configuration for the content. If empty, Dialogflow replaces sensitive info with [redacted] text.
        Note: deidentifyTemplate must be located in the same region as the SecuritySettings.
        Format: projects/<Project ID>/locations/<Location ID>/deidentifyTemplates/<Template ID> OR organizations/<Organization ID>/locations/<Location ID>/deidentifyTemplates/<Template ID>
        """
        return pulumi.get(self, "deidentify_template")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        The human-readable name of the security settings, unique within the location.


        - - -
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="insightsExportSettings")
    def insights_export_settings(self) -> pulumi.Output[Optional['outputs.CxSecuritySettingsInsightsExportSettings']]:
        """
        Controls conversation exporting settings to Insights after conversation is completed.
        If retentionStrategy is set to REMOVE_AFTER_CONVERSATION, Insights export is disabled no matter what you configure here.
        Structure is documented below.
        """
        return pulumi.get(self, "insights_export_settings")

    @property
    @pulumi.getter(name="inspectTemplate")
    def inspect_template(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        [DLP](https://cloud.google.com/dlp/docs) inspect template name. Use this template to define inspect base settings. If empty, we use the default DLP inspect config.
        Note: inspectTemplate must be located in the same region as the SecuritySettings.
        Format: projects/<Project ID>/locations/<Location ID>/inspectTemplates/<Template ID> OR organizations/<Organization ID>/locations/<Location ID>/inspectTemplates/<Template ID>
        """
        return pulumi.get(self, "inspect_template")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The location these settings are located in. Settings can only be applied to an agent in the same location.
        See [Available Regions](https://cloud.google.com/dialogflow/cx/docs/concept/region#avail) for a list of supported locations.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The unique identifier of the settings.
        Format: projects/<Project ID>/locations/<Location ID>/securitySettings/<Security Settings ID>.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="purgeDataTypes")
    def purge_data_types(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        List of types of data to remove when retention settings triggers purge.
        Each value may be one of: `DIALOGFLOW_HISTORY`.
        """
        return pulumi.get(self, "purge_data_types")

    @property
    @pulumi.getter(name="redactionScope")
    def redaction_scope(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Defines what types of data to redact. If not set, defaults to not redacting any kind of data.
        * REDACT_DISK_STORAGE: On data to be written to disk or similar devices that are capable of holding data even if power is disconnected. This includes data that are temporarily saved on disk.
        Possible values are: `REDACT_DISK_STORAGE`.
        """
        return pulumi.get(self, "redaction_scope")

    @property
    @pulumi.getter(name="redactionStrategy")
    def redaction_strategy(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Defines how we redact data. If not set, defaults to not redacting.
        * REDACT_WITH_SERVICE: Call redaction service to clean up the data to be persisted.
        Possible values are: `REDACT_WITH_SERVICE`.
        """
        return pulumi.get(self, "redaction_strategy")

    @property
    @pulumi.getter(name="retentionStrategy")
    def retention_strategy(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Defines how long we retain persisted data that contains sensitive info. Only one of `retention_window_days` and `retention_strategy` may be set.
        * REMOVE_AFTER_CONVERSATION: Removes data when the conversation ends. If there is no conversation explicitly established, a default conversation ends when the corresponding Dialogflow session ends.
        Possible values are: `REMOVE_AFTER_CONVERSATION`.
        """
        return pulumi.get(self, "retention_strategy")

    @property
    @pulumi.getter(name="retentionWindowDays")
    def retention_window_days(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Retains the data for the specified number of days. User must set a value lower than Dialogflow's default 365d TTL (30 days for Agent Assist traffic), higher value will be ignored and use default. Setting a value higher than that has no effect. A missing value or setting to 0 also means we use default TTL.
        Only one of `retention_window_days` and `retention_strategy` may be set.
        """
        return pulumi.get(self, "retention_window_days")

