# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CxToolArgs', 'CxTool']

@pulumi.input_type
class CxToolArgs:
    def __init__(__self__, *,
                 description: pulumi.Input[builtins.str],
                 display_name: pulumi.Input[builtins.str],
                 data_store_spec: Optional[pulumi.Input['CxToolDataStoreSpecArgs']] = None,
                 function_spec: Optional[pulumi.Input['CxToolFunctionSpecArgs']] = None,
                 open_api_spec: Optional[pulumi.Input['CxToolOpenApiSpecArgs']] = None,
                 parent: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a CxTool resource.
        :param pulumi.Input[builtins.str] description: High level description of the Tool and its usage.
               
               
               - - -
        :param pulumi.Input[builtins.str] display_name: The human-readable name of the tool, unique within the agent.
        :param pulumi.Input['CxToolDataStoreSpecArgs'] data_store_spec: Data store search tool specification.
               This field is part of a union field `specification`: Only one of `openApiSpec`, `dataStoreSpec`, or `functionSpec` may be set.
               Structure is documented below.
        :param pulumi.Input['CxToolFunctionSpecArgs'] function_spec: Client side executed function specification.
               This field is part of a union field `specification`: Only one of `openApiSpec`, `dataStoreSpec`, or `functionSpec` may be set.
               Structure is documented below.
        :param pulumi.Input['CxToolOpenApiSpecArgs'] open_api_spec: OpenAPI specification of the Tool.
               This field is part of a union field `specification`: Only one of `openApiSpec`, `dataStoreSpec`, or `functionSpec` may be set.
               Structure is documented below.
        :param pulumi.Input[builtins.str] parent: The agent to create a Tool for.
               Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        if data_store_spec is not None:
            pulumi.set(__self__, "data_store_spec", data_store_spec)
        if function_spec is not None:
            pulumi.set(__self__, "function_spec", function_spec)
        if open_api_spec is not None:
            pulumi.set(__self__, "open_api_spec", open_api_spec)
        if parent is not None:
            pulumi.set(__self__, "parent", parent)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[builtins.str]:
        """
        High level description of the Tool and its usage.


        - - -
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[builtins.str]:
        """
        The human-readable name of the tool, unique within the agent.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="dataStoreSpec")
    def data_store_spec(self) -> Optional[pulumi.Input['CxToolDataStoreSpecArgs']]:
        """
        Data store search tool specification.
        This field is part of a union field `specification`: Only one of `openApiSpec`, `dataStoreSpec`, or `functionSpec` may be set.
        Structure is documented below.
        """
        return pulumi.get(self, "data_store_spec")

    @data_store_spec.setter
    def data_store_spec(self, value: Optional[pulumi.Input['CxToolDataStoreSpecArgs']]):
        pulumi.set(self, "data_store_spec", value)

    @property
    @pulumi.getter(name="functionSpec")
    def function_spec(self) -> Optional[pulumi.Input['CxToolFunctionSpecArgs']]:
        """
        Client side executed function specification.
        This field is part of a union field `specification`: Only one of `openApiSpec`, `dataStoreSpec`, or `functionSpec` may be set.
        Structure is documented below.
        """
        return pulumi.get(self, "function_spec")

    @function_spec.setter
    def function_spec(self, value: Optional[pulumi.Input['CxToolFunctionSpecArgs']]):
        pulumi.set(self, "function_spec", value)

    @property
    @pulumi.getter(name="openApiSpec")
    def open_api_spec(self) -> Optional[pulumi.Input['CxToolOpenApiSpecArgs']]:
        """
        OpenAPI specification of the Tool.
        This field is part of a union field `specification`: Only one of `openApiSpec`, `dataStoreSpec`, or `functionSpec` may be set.
        Structure is documented below.
        """
        return pulumi.get(self, "open_api_spec")

    @open_api_spec.setter
    def open_api_spec(self, value: Optional[pulumi.Input['CxToolOpenApiSpecArgs']]):
        pulumi.set(self, "open_api_spec", value)

    @property
    @pulumi.getter
    def parent(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The agent to create a Tool for.
        Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "parent", value)


@pulumi.input_type
class _CxToolState:
    def __init__(__self__, *,
                 data_store_spec: Optional[pulumi.Input['CxToolDataStoreSpecArgs']] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 function_spec: Optional[pulumi.Input['CxToolFunctionSpecArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 open_api_spec: Optional[pulumi.Input['CxToolOpenApiSpecArgs']] = None,
                 parent: Optional[pulumi.Input[builtins.str]] = None,
                 tool_type: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering CxTool resources.
        :param pulumi.Input['CxToolDataStoreSpecArgs'] data_store_spec: Data store search tool specification.
               This field is part of a union field `specification`: Only one of `openApiSpec`, `dataStoreSpec`, or `functionSpec` may be set.
               Structure is documented below.
        :param pulumi.Input[builtins.str] description: High level description of the Tool and its usage.
               
               
               - - -
        :param pulumi.Input[builtins.str] display_name: The human-readable name of the tool, unique within the agent.
        :param pulumi.Input['CxToolFunctionSpecArgs'] function_spec: Client side executed function specification.
               This field is part of a union field `specification`: Only one of `openApiSpec`, `dataStoreSpec`, or `functionSpec` may be set.
               Structure is documented below.
        :param pulumi.Input[builtins.str] name: The unique identifier of the Tool.
               Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/tools/<Tool ID>.
        :param pulumi.Input['CxToolOpenApiSpecArgs'] open_api_spec: OpenAPI specification of the Tool.
               This field is part of a union field `specification`: Only one of `openApiSpec`, `dataStoreSpec`, or `functionSpec` may be set.
               Structure is documented below.
        :param pulumi.Input[builtins.str] parent: The agent to create a Tool for.
               Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
        :param pulumi.Input[builtins.str] tool_type: The tool type.
        """
        if data_store_spec is not None:
            pulumi.set(__self__, "data_store_spec", data_store_spec)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if function_spec is not None:
            pulumi.set(__self__, "function_spec", function_spec)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if open_api_spec is not None:
            pulumi.set(__self__, "open_api_spec", open_api_spec)
        if parent is not None:
            pulumi.set(__self__, "parent", parent)
        if tool_type is not None:
            pulumi.set(__self__, "tool_type", tool_type)

    @property
    @pulumi.getter(name="dataStoreSpec")
    def data_store_spec(self) -> Optional[pulumi.Input['CxToolDataStoreSpecArgs']]:
        """
        Data store search tool specification.
        This field is part of a union field `specification`: Only one of `openApiSpec`, `dataStoreSpec`, or `functionSpec` may be set.
        Structure is documented below.
        """
        return pulumi.get(self, "data_store_spec")

    @data_store_spec.setter
    def data_store_spec(self, value: Optional[pulumi.Input['CxToolDataStoreSpecArgs']]):
        pulumi.set(self, "data_store_spec", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        High level description of the Tool and its usage.


        - - -
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The human-readable name of the tool, unique within the agent.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="functionSpec")
    def function_spec(self) -> Optional[pulumi.Input['CxToolFunctionSpecArgs']]:
        """
        Client side executed function specification.
        This field is part of a union field `specification`: Only one of `openApiSpec`, `dataStoreSpec`, or `functionSpec` may be set.
        Structure is documented below.
        """
        return pulumi.get(self, "function_spec")

    @function_spec.setter
    def function_spec(self, value: Optional[pulumi.Input['CxToolFunctionSpecArgs']]):
        pulumi.set(self, "function_spec", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unique identifier of the Tool.
        Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/tools/<Tool ID>.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="openApiSpec")
    def open_api_spec(self) -> Optional[pulumi.Input['CxToolOpenApiSpecArgs']]:
        """
        OpenAPI specification of the Tool.
        This field is part of a union field `specification`: Only one of `openApiSpec`, `dataStoreSpec`, or `functionSpec` may be set.
        Structure is documented below.
        """
        return pulumi.get(self, "open_api_spec")

    @open_api_spec.setter
    def open_api_spec(self, value: Optional[pulumi.Input['CxToolOpenApiSpecArgs']]):
        pulumi.set(self, "open_api_spec", value)

    @property
    @pulumi.getter
    def parent(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The agent to create a Tool for.
        Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "parent", value)

    @property
    @pulumi.getter(name="toolType")
    def tool_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The tool type.
        """
        return pulumi.get(self, "tool_type")

    @tool_type.setter
    def tool_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tool_type", value)


@pulumi.type_token("gcp:diagflow/cxTool:CxTool")
class CxTool(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_store_spec: Optional[pulumi.Input[Union['CxToolDataStoreSpecArgs', 'CxToolDataStoreSpecArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 function_spec: Optional[pulumi.Input[Union['CxToolFunctionSpecArgs', 'CxToolFunctionSpecArgsDict']]] = None,
                 open_api_spec: Optional[pulumi.Input[Union['CxToolOpenApiSpecArgs', 'CxToolOpenApiSpecArgsDict']]] = None,
                 parent: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        A tool provides a list of actions which are available to the Playbook to attain its goal.
        A Tool consists of a description of the tool's usage and a specification of the tool which contains the schema and authentication information.

        To get more information about Tool, see:

        * [API documentation](https://cloud.google.com/dialogflow/cx/docs/reference/rest/v3/projects.locations.agents.tools)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/dialogflow/cx/docs)

        ## Example Usage

        ### Dialogflowcx Tool Open Api

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        agent = gcp.diagflow.CxAgent("agent",
            display_name="dialogflowcx-agent-open-api",
            location="global",
            default_language_code="en",
            time_zone="America/New_York",
            description="Example description.")
        open_api_tool = gcp.diagflow.CxTool("open_api_tool",
            parent=agent.id,
            display_name="Example Open API Tool",
            description="Example Description",
            open_api_spec={
                "authentication": {
                    "oauth_config": {
                        "oauth_grant_type": "CLIENT_CREDENTIAL",
                        "client_id": "example client ID",
                        "client_secret": "example client secret",
                        "scopes": ["example scope"],
                        "secret_version_for_client_secret": "projects/-/secrets/-/versions/-",
                        "token_endpoint": "https://example.com/oauth/token",
                    },
                },
                "tls_config": {
                    "ca_certs": [{
                        "display_name": "example ca cert name",
                        "cert": std.base64encode(input="example cert").result,
                    }],
                },
                "service_directory_config": {
                    "service": "projects/-/locations/-/namespaces/-/services/-",
                },
                "text_schema": \"\"\"    {
              "openapi": "3.0.0",
              "info": {
                "title": "Time API",
                "version": "1.0.0",
                "description": "A simple API to get the current time."
              },
              "servers": [
                {
                  "url": "https://example-api-endpoint.com"
                }
              ],
              "paths": {
                "/time": {
                  "get": {
                    "operationId": "getCurrentTime",
                    "summary": "Gets the current server time.",
                    "responses": {
                      "200": {
                        "description": "Successful response with the current time.",
                        "content": {
                          "application/json": {
                            "schema": {
                              "type": "object",
                              "properties": {
                                "currentTime": {
                                  "type": "string",
                                  "format": "date-time",
                                  "description": "The current time in ISO 8601 format."
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
        \"\"\",
            })
        ```
        ### Dialogflowcx Tool Data Store

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_datastore = gcp.discoveryengine.DataStore("my_datastore",
            location="global",
            data_store_id="datastore-tool-test-_79169",
            display_name="datastore for Tool test",
            industry_vertical="GENERIC",
            content_config="NO_CONTENT",
            solution_types=["SOLUTION_TYPE_CHAT"])
        agent = gcp.diagflow.CxAgent("agent",
            display_name="dialogflowcx-agent-data-store",
            location="global",
            default_language_code="en",
            time_zone="America/New_York",
            description="Example description.",
            delete_chat_engine_on_destroy=True,
            opts = pulumi.ResourceOptions(depends_on=[my_datastore]))
        project = gcp.organizations.get_project()
        data_store_tool = gcp.diagflow.CxTool("data_store_tool",
            parent=agent.id,
            display_name="Example Data Store Tool",
            description="Example Description",
            data_store_spec={
                "data_store_connections": [{
                    "data_store_type": "UNSTRUCTURED",
                    "data_store": my_datastore.data_store_id.apply(lambda data_store_id: f"projects/{project.number}/locations/global/collections/default_collection/dataStores/{data_store_id}"),
                    "document_processing_mode": "DOCUMENTS",
                }],
                "fallback_prompt": {},
            },
            opts = pulumi.ResourceOptions(depends_on=[
                    my_datastore,
                    agent,
                ]))
        ```
        ### Dialogflowcx Tool Function

        ```python
        import pulumi
        import pulumi_gcp as gcp

        agent = gcp.diagflow.CxAgent("agent",
            display_name="dialogflowcx-agent-fucntion",
            location="global",
            default_language_code="en",
            time_zone="America/New_York",
            description="Example description.")
        function_tool = gcp.diagflow.CxTool("function_tool",
            parent=agent.id,
            display_name="Example Function Tool",
            description="Example Description",
            function_spec={
                "input_schema": \"\"\"      {
                "type": "object",
                "properties": {
                  "message_to_echo": {
                    "type": "string",
                    "description": "The message that should be echoed back."
                  }
                },
                "required": [
                  "message_to_echo"
                ]
              }
        \"\"\",
                "output_schema": \"\"\"      {
                "type": "object",
                "properties": {
                  "echoed_message": {
                    "type": "string",
                    "description": "The message that is echoed back."
                  }
                }
              }
        \"\"\",
            })
        ```

        ## Import

        Tool can be imported using any of these accepted formats:

        * `{{parent}}/tools/{{name}}`

        * `{{parent}}/{{name}}`

        When using the `pulumi import` command, Tool can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:diagflow/cxTool:CxTool default {{parent}}/tools/{{name}}
        ```

        ```sh
        $ pulumi import gcp:diagflow/cxTool:CxTool default {{parent}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['CxToolDataStoreSpecArgs', 'CxToolDataStoreSpecArgsDict']] data_store_spec: Data store search tool specification.
               This field is part of a union field `specification`: Only one of `openApiSpec`, `dataStoreSpec`, or `functionSpec` may be set.
               Structure is documented below.
        :param pulumi.Input[builtins.str] description: High level description of the Tool and its usage.
               
               
               - - -
        :param pulumi.Input[builtins.str] display_name: The human-readable name of the tool, unique within the agent.
        :param pulumi.Input[Union['CxToolFunctionSpecArgs', 'CxToolFunctionSpecArgsDict']] function_spec: Client side executed function specification.
               This field is part of a union field `specification`: Only one of `openApiSpec`, `dataStoreSpec`, or `functionSpec` may be set.
               Structure is documented below.
        :param pulumi.Input[Union['CxToolOpenApiSpecArgs', 'CxToolOpenApiSpecArgsDict']] open_api_spec: OpenAPI specification of the Tool.
               This field is part of a union field `specification`: Only one of `openApiSpec`, `dataStoreSpec`, or `functionSpec` may be set.
               Structure is documented below.
        :param pulumi.Input[builtins.str] parent: The agent to create a Tool for.
               Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CxToolArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A tool provides a list of actions which are available to the Playbook to attain its goal.
        A Tool consists of a description of the tool's usage and a specification of the tool which contains the schema and authentication information.

        To get more information about Tool, see:

        * [API documentation](https://cloud.google.com/dialogflow/cx/docs/reference/rest/v3/projects.locations.agents.tools)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/dialogflow/cx/docs)

        ## Example Usage

        ### Dialogflowcx Tool Open Api

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        agent = gcp.diagflow.CxAgent("agent",
            display_name="dialogflowcx-agent-open-api",
            location="global",
            default_language_code="en",
            time_zone="America/New_York",
            description="Example description.")
        open_api_tool = gcp.diagflow.CxTool("open_api_tool",
            parent=agent.id,
            display_name="Example Open API Tool",
            description="Example Description",
            open_api_spec={
                "authentication": {
                    "oauth_config": {
                        "oauth_grant_type": "CLIENT_CREDENTIAL",
                        "client_id": "example client ID",
                        "client_secret": "example client secret",
                        "scopes": ["example scope"],
                        "secret_version_for_client_secret": "projects/-/secrets/-/versions/-",
                        "token_endpoint": "https://example.com/oauth/token",
                    },
                },
                "tls_config": {
                    "ca_certs": [{
                        "display_name": "example ca cert name",
                        "cert": std.base64encode(input="example cert").result,
                    }],
                },
                "service_directory_config": {
                    "service": "projects/-/locations/-/namespaces/-/services/-",
                },
                "text_schema": \"\"\"    {
              "openapi": "3.0.0",
              "info": {
                "title": "Time API",
                "version": "1.0.0",
                "description": "A simple API to get the current time."
              },
              "servers": [
                {
                  "url": "https://example-api-endpoint.com"
                }
              ],
              "paths": {
                "/time": {
                  "get": {
                    "operationId": "getCurrentTime",
                    "summary": "Gets the current server time.",
                    "responses": {
                      "200": {
                        "description": "Successful response with the current time.",
                        "content": {
                          "application/json": {
                            "schema": {
                              "type": "object",
                              "properties": {
                                "currentTime": {
                                  "type": "string",
                                  "format": "date-time",
                                  "description": "The current time in ISO 8601 format."
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
        \"\"\",
            })
        ```
        ### Dialogflowcx Tool Data Store

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_datastore = gcp.discoveryengine.DataStore("my_datastore",
            location="global",
            data_store_id="datastore-tool-test-_79169",
            display_name="datastore for Tool test",
            industry_vertical="GENERIC",
            content_config="NO_CONTENT",
            solution_types=["SOLUTION_TYPE_CHAT"])
        agent = gcp.diagflow.CxAgent("agent",
            display_name="dialogflowcx-agent-data-store",
            location="global",
            default_language_code="en",
            time_zone="America/New_York",
            description="Example description.",
            delete_chat_engine_on_destroy=True,
            opts = pulumi.ResourceOptions(depends_on=[my_datastore]))
        project = gcp.organizations.get_project()
        data_store_tool = gcp.diagflow.CxTool("data_store_tool",
            parent=agent.id,
            display_name="Example Data Store Tool",
            description="Example Description",
            data_store_spec={
                "data_store_connections": [{
                    "data_store_type": "UNSTRUCTURED",
                    "data_store": my_datastore.data_store_id.apply(lambda data_store_id: f"projects/{project.number}/locations/global/collections/default_collection/dataStores/{data_store_id}"),
                    "document_processing_mode": "DOCUMENTS",
                }],
                "fallback_prompt": {},
            },
            opts = pulumi.ResourceOptions(depends_on=[
                    my_datastore,
                    agent,
                ]))
        ```
        ### Dialogflowcx Tool Function

        ```python
        import pulumi
        import pulumi_gcp as gcp

        agent = gcp.diagflow.CxAgent("agent",
            display_name="dialogflowcx-agent-fucntion",
            location="global",
            default_language_code="en",
            time_zone="America/New_York",
            description="Example description.")
        function_tool = gcp.diagflow.CxTool("function_tool",
            parent=agent.id,
            display_name="Example Function Tool",
            description="Example Description",
            function_spec={
                "input_schema": \"\"\"      {
                "type": "object",
                "properties": {
                  "message_to_echo": {
                    "type": "string",
                    "description": "The message that should be echoed back."
                  }
                },
                "required": [
                  "message_to_echo"
                ]
              }
        \"\"\",
                "output_schema": \"\"\"      {
                "type": "object",
                "properties": {
                  "echoed_message": {
                    "type": "string",
                    "description": "The message that is echoed back."
                  }
                }
              }
        \"\"\",
            })
        ```

        ## Import

        Tool can be imported using any of these accepted formats:

        * `{{parent}}/tools/{{name}}`

        * `{{parent}}/{{name}}`

        When using the `pulumi import` command, Tool can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:diagflow/cxTool:CxTool default {{parent}}/tools/{{name}}
        ```

        ```sh
        $ pulumi import gcp:diagflow/cxTool:CxTool default {{parent}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param CxToolArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CxToolArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_store_spec: Optional[pulumi.Input[Union['CxToolDataStoreSpecArgs', 'CxToolDataStoreSpecArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 function_spec: Optional[pulumi.Input[Union['CxToolFunctionSpecArgs', 'CxToolFunctionSpecArgsDict']]] = None,
                 open_api_spec: Optional[pulumi.Input[Union['CxToolOpenApiSpecArgs', 'CxToolOpenApiSpecArgsDict']]] = None,
                 parent: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CxToolArgs.__new__(CxToolArgs)

            __props__.__dict__["data_store_spec"] = data_store_spec
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["function_spec"] = function_spec
            __props__.__dict__["open_api_spec"] = open_api_spec
            __props__.__dict__["parent"] = parent
            __props__.__dict__["name"] = None
            __props__.__dict__["tool_type"] = None
        super(CxTool, __self__).__init__(
            'gcp:diagflow/cxTool:CxTool',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            data_store_spec: Optional[pulumi.Input[Union['CxToolDataStoreSpecArgs', 'CxToolDataStoreSpecArgsDict']]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            function_spec: Optional[pulumi.Input[Union['CxToolFunctionSpecArgs', 'CxToolFunctionSpecArgsDict']]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            open_api_spec: Optional[pulumi.Input[Union['CxToolOpenApiSpecArgs', 'CxToolOpenApiSpecArgsDict']]] = None,
            parent: Optional[pulumi.Input[builtins.str]] = None,
            tool_type: Optional[pulumi.Input[builtins.str]] = None) -> 'CxTool':
        """
        Get an existing CxTool resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['CxToolDataStoreSpecArgs', 'CxToolDataStoreSpecArgsDict']] data_store_spec: Data store search tool specification.
               This field is part of a union field `specification`: Only one of `openApiSpec`, `dataStoreSpec`, or `functionSpec` may be set.
               Structure is documented below.
        :param pulumi.Input[builtins.str] description: High level description of the Tool and its usage.
               
               
               - - -
        :param pulumi.Input[builtins.str] display_name: The human-readable name of the tool, unique within the agent.
        :param pulumi.Input[Union['CxToolFunctionSpecArgs', 'CxToolFunctionSpecArgsDict']] function_spec: Client side executed function specification.
               This field is part of a union field `specification`: Only one of `openApiSpec`, `dataStoreSpec`, or `functionSpec` may be set.
               Structure is documented below.
        :param pulumi.Input[builtins.str] name: The unique identifier of the Tool.
               Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/tools/<Tool ID>.
        :param pulumi.Input[Union['CxToolOpenApiSpecArgs', 'CxToolOpenApiSpecArgsDict']] open_api_spec: OpenAPI specification of the Tool.
               This field is part of a union field `specification`: Only one of `openApiSpec`, `dataStoreSpec`, or `functionSpec` may be set.
               Structure is documented below.
        :param pulumi.Input[builtins.str] parent: The agent to create a Tool for.
               Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
        :param pulumi.Input[builtins.str] tool_type: The tool type.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CxToolState.__new__(_CxToolState)

        __props__.__dict__["data_store_spec"] = data_store_spec
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["function_spec"] = function_spec
        __props__.__dict__["name"] = name
        __props__.__dict__["open_api_spec"] = open_api_spec
        __props__.__dict__["parent"] = parent
        __props__.__dict__["tool_type"] = tool_type
        return CxTool(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="dataStoreSpec")
    def data_store_spec(self) -> pulumi.Output[Optional['outputs.CxToolDataStoreSpec']]:
        """
        Data store search tool specification.
        This field is part of a union field `specification`: Only one of `openApiSpec`, `dataStoreSpec`, or `functionSpec` may be set.
        Structure is documented below.
        """
        return pulumi.get(self, "data_store_spec")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        High level description of the Tool and its usage.


        - - -
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        The human-readable name of the tool, unique within the agent.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="functionSpec")
    def function_spec(self) -> pulumi.Output[Optional['outputs.CxToolFunctionSpec']]:
        """
        Client side executed function specification.
        This field is part of a union field `specification`: Only one of `openApiSpec`, `dataStoreSpec`, or `functionSpec` may be set.
        Structure is documented below.
        """
        return pulumi.get(self, "function_spec")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The unique identifier of the Tool.
        Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/tools/<Tool ID>.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="openApiSpec")
    def open_api_spec(self) -> pulumi.Output[Optional['outputs.CxToolOpenApiSpec']]:
        """
        OpenAPI specification of the Tool.
        This field is part of a union field `specification`: Only one of `openApiSpec`, `dataStoreSpec`, or `functionSpec` may be set.
        Structure is documented below.
        """
        return pulumi.get(self, "open_api_spec")

    @property
    @pulumi.getter
    def parent(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The agent to create a Tool for.
        Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
        """
        return pulumi.get(self, "parent")

    @property
    @pulumi.getter(name="toolType")
    def tool_type(self) -> pulumi.Output[builtins.str]:
        """
        The tool type.
        """
        return pulumi.get(self, "tool_type")

