# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SchemaArgs', 'Schema']

@pulumi.input_type
class SchemaArgs:
    def __init__(__self__, *,
                 data_store_id: pulumi.Input[builtins.str],
                 location: pulumi.Input[builtins.str],
                 schema_id: pulumi.Input[builtins.str],
                 json_schema: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Schema resource.
        :param pulumi.Input[builtins.str] data_store_id: The unique id of the data store.
        :param pulumi.Input[builtins.str] location: The geographic location where the data store should reside. The value can
               only be one of "global", "us" and "eu".
        :param pulumi.Input[builtins.str] schema_id: The unique id of the schema.
               
               
               - - -
        :param pulumi.Input[builtins.str] json_schema: The JSON representation of the schema.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "data_store_id", data_store_id)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "schema_id", schema_id)
        if json_schema is not None:
            pulumi.set(__self__, "json_schema", json_schema)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="dataStoreId")
    def data_store_id(self) -> pulumi.Input[builtins.str]:
        """
        The unique id of the data store.
        """
        return pulumi.get(self, "data_store_id")

    @data_store_id.setter
    def data_store_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "data_store_id", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        The geographic location where the data store should reside. The value can
        only be one of "global", "us" and "eu".
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="schemaId")
    def schema_id(self) -> pulumi.Input[builtins.str]:
        """
        The unique id of the schema.


        - - -
        """
        return pulumi.get(self, "schema_id")

    @schema_id.setter
    def schema_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "schema_id", value)

    @property
    @pulumi.getter(name="jsonSchema")
    def json_schema(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The JSON representation of the schema.
        """
        return pulumi.get(self, "json_schema")

    @json_schema.setter
    def json_schema(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "json_schema", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _SchemaState:
    def __init__(__self__, *,
                 data_store_id: Optional[pulumi.Input[builtins.str]] = None,
                 json_schema: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 schema_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Schema resources.
        :param pulumi.Input[builtins.str] data_store_id: The unique id of the data store.
        :param pulumi.Input[builtins.str] json_schema: The JSON representation of the schema.
        :param pulumi.Input[builtins.str] location: The geographic location where the data store should reside. The value can
               only be one of "global", "us" and "eu".
        :param pulumi.Input[builtins.str] name: The unique full resource name of the schema. Values are of the format
               `projects/{project}/locations/{location}/collections/{collection_id}/dataStores/{data_store_id}/schemas/{schema_id}`.
               This field must be a UTF-8 encoded string with a length limit of 1024
               characters.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] schema_id: The unique id of the schema.
               
               
               - - -
        """
        if data_store_id is not None:
            pulumi.set(__self__, "data_store_id", data_store_id)
        if json_schema is not None:
            pulumi.set(__self__, "json_schema", json_schema)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if schema_id is not None:
            pulumi.set(__self__, "schema_id", schema_id)

    @property
    @pulumi.getter(name="dataStoreId")
    def data_store_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unique id of the data store.
        """
        return pulumi.get(self, "data_store_id")

    @data_store_id.setter
    def data_store_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "data_store_id", value)

    @property
    @pulumi.getter(name="jsonSchema")
    def json_schema(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The JSON representation of the schema.
        """
        return pulumi.get(self, "json_schema")

    @json_schema.setter
    def json_schema(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "json_schema", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The geographic location where the data store should reside. The value can
        only be one of "global", "us" and "eu".
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unique full resource name of the schema. Values are of the format
        `projects/{project}/locations/{location}/collections/{collection_id}/dataStores/{data_store_id}/schemas/{schema_id}`.
        This field must be a UTF-8 encoded string with a length limit of 1024
        characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="schemaId")
    def schema_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unique id of the schema.


        - - -
        """
        return pulumi.get(self, "schema_id")

    @schema_id.setter
    def schema_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "schema_id", value)


@pulumi.type_token("gcp:discoveryengine/schema:Schema")
class Schema(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_store_id: Optional[pulumi.Input[builtins.str]] = None,
                 json_schema: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 schema_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Schema defines the structure and layout of a type of document data.

        To get more information about Schema, see:

        * [API documentation](https://cloud.google.com/generative-ai-app-builder/docs/reference/rest/v1/projects.locations.collections.dataStores.schemas)
        * How-to Guides
            * [Provide a schema for your data store](https://cloud.google.com/generative-ai-app-builder/docs/provide-schema)

        ## Example Usage

        ### Discoveryengine Schema Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic_data_store = gcp.discoveryengine.DataStore("basic",
            location="global",
            data_store_id="data-store-id",
            display_name="tf-test-structured-datastore",
            industry_vertical="GENERIC",
            content_config="NO_CONTENT",
            solution_types=["SOLUTION_TYPE_SEARCH"],
            create_advanced_site_search=False,
            skip_default_schema_creation=True)
        basic = gcp.discoveryengine.Schema("basic",
            location=basic_data_store.location,
            data_store_id=basic_data_store.data_store_id,
            schema_id="schema-id",
            json_schema="{\\"$schema\\":\\"https://json-schema.org/draft/2020-12/schema\\",\\"datetime_detection\\":true,\\"type\\":\\"object\\",\\"geolocation_detection\\":true}")
        ```

        ## Import

        Schema can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/collections/default_collection/dataStores/{{data_store_id}}/schemas/{{schema_id}}`

        * `{{project}}/{{location}}/{{data_store_id}}/{{schema_id}}`

        * `{{location}}/{{data_store_id}}/{{schema_id}}`

        When using the `pulumi import` command, Schema can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:discoveryengine/schema:Schema default projects/{{project}}/locations/{{location}}/collections/default_collection/dataStores/{{data_store_id}}/schemas/{{schema_id}}
        ```

        ```sh
        $ pulumi import gcp:discoveryengine/schema:Schema default {{project}}/{{location}}/{{data_store_id}}/{{schema_id}}
        ```

        ```sh
        $ pulumi import gcp:discoveryengine/schema:Schema default {{location}}/{{data_store_id}}/{{schema_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] data_store_id: The unique id of the data store.
        :param pulumi.Input[builtins.str] json_schema: The JSON representation of the schema.
        :param pulumi.Input[builtins.str] location: The geographic location where the data store should reside. The value can
               only be one of "global", "us" and "eu".
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] schema_id: The unique id of the schema.
               
               
               - - -
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SchemaArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Schema defines the structure and layout of a type of document data.

        To get more information about Schema, see:

        * [API documentation](https://cloud.google.com/generative-ai-app-builder/docs/reference/rest/v1/projects.locations.collections.dataStores.schemas)
        * How-to Guides
            * [Provide a schema for your data store](https://cloud.google.com/generative-ai-app-builder/docs/provide-schema)

        ## Example Usage

        ### Discoveryengine Schema Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic_data_store = gcp.discoveryengine.DataStore("basic",
            location="global",
            data_store_id="data-store-id",
            display_name="tf-test-structured-datastore",
            industry_vertical="GENERIC",
            content_config="NO_CONTENT",
            solution_types=["SOLUTION_TYPE_SEARCH"],
            create_advanced_site_search=False,
            skip_default_schema_creation=True)
        basic = gcp.discoveryengine.Schema("basic",
            location=basic_data_store.location,
            data_store_id=basic_data_store.data_store_id,
            schema_id="schema-id",
            json_schema="{\\"$schema\\":\\"https://json-schema.org/draft/2020-12/schema\\",\\"datetime_detection\\":true,\\"type\\":\\"object\\",\\"geolocation_detection\\":true}")
        ```

        ## Import

        Schema can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/collections/default_collection/dataStores/{{data_store_id}}/schemas/{{schema_id}}`

        * `{{project}}/{{location}}/{{data_store_id}}/{{schema_id}}`

        * `{{location}}/{{data_store_id}}/{{schema_id}}`

        When using the `pulumi import` command, Schema can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:discoveryengine/schema:Schema default projects/{{project}}/locations/{{location}}/collections/default_collection/dataStores/{{data_store_id}}/schemas/{{schema_id}}
        ```

        ```sh
        $ pulumi import gcp:discoveryengine/schema:Schema default {{project}}/{{location}}/{{data_store_id}}/{{schema_id}}
        ```

        ```sh
        $ pulumi import gcp:discoveryengine/schema:Schema default {{location}}/{{data_store_id}}/{{schema_id}}
        ```

        :param str resource_name: The name of the resource.
        :param SchemaArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SchemaArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_store_id: Optional[pulumi.Input[builtins.str]] = None,
                 json_schema: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 schema_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SchemaArgs.__new__(SchemaArgs)

            if data_store_id is None and not opts.urn:
                raise TypeError("Missing required property 'data_store_id'")
            __props__.__dict__["data_store_id"] = data_store_id
            __props__.__dict__["json_schema"] = json_schema
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            if schema_id is None and not opts.urn:
                raise TypeError("Missing required property 'schema_id'")
            __props__.__dict__["schema_id"] = schema_id
            __props__.__dict__["name"] = None
        super(Schema, __self__).__init__(
            'gcp:discoveryengine/schema:Schema',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            data_store_id: Optional[pulumi.Input[builtins.str]] = None,
            json_schema: Optional[pulumi.Input[builtins.str]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            schema_id: Optional[pulumi.Input[builtins.str]] = None) -> 'Schema':
        """
        Get an existing Schema resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] data_store_id: The unique id of the data store.
        :param pulumi.Input[builtins.str] json_schema: The JSON representation of the schema.
        :param pulumi.Input[builtins.str] location: The geographic location where the data store should reside. The value can
               only be one of "global", "us" and "eu".
        :param pulumi.Input[builtins.str] name: The unique full resource name of the schema. Values are of the format
               `projects/{project}/locations/{location}/collections/{collection_id}/dataStores/{data_store_id}/schemas/{schema_id}`.
               This field must be a UTF-8 encoded string with a length limit of 1024
               characters.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] schema_id: The unique id of the schema.
               
               
               - - -
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SchemaState.__new__(_SchemaState)

        __props__.__dict__["data_store_id"] = data_store_id
        __props__.__dict__["json_schema"] = json_schema
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["schema_id"] = schema_id
        return Schema(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="dataStoreId")
    def data_store_id(self) -> pulumi.Output[builtins.str]:
        """
        The unique id of the data store.
        """
        return pulumi.get(self, "data_store_id")

    @property
    @pulumi.getter(name="jsonSchema")
    def json_schema(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The JSON representation of the schema.
        """
        return pulumi.get(self, "json_schema")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The geographic location where the data store should reside. The value can
        only be one of "global", "us" and "eu".
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The unique full resource name of the schema. Values are of the format
        `projects/{project}/locations/{location}/collections/{collection_id}/dataStores/{data_store_id}/schemas/{schema_id}`.
        This field must be a UTF-8 encoded string with a length limit of 1024
        characters.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="schemaId")
    def schema_id(self) -> pulumi.Output[builtins.str]:
        """
        The unique id of the schema.


        - - -
        """
        return pulumi.get(self, "schema_id")

