# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NodePoolArgs', 'NodePool']

@pulumi.input_type
class NodePoolArgs:
    def __init__(__self__, *,
                 cluster: pulumi.Input[builtins.str],
                 location: pulumi.Input[builtins.str],
                 node_count: pulumi.Input[builtins.int],
                 node_location: pulumi.Input[builtins.str],
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 local_disk_encryption: Optional[pulumi.Input['NodePoolLocalDiskEncryptionArgs']] = None,
                 machine_filter: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 node_config: Optional[pulumi.Input['NodePoolNodeConfigArgs']] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a NodePool resource.
        :param pulumi.Input[builtins.str] cluster: The name of the target Distributed Cloud Edge Cluster.
               
               
               - - -
        :param pulumi.Input[builtins.str] location: The location of the resource.
        :param pulumi.Input[builtins.int] node_count: The number of nodes in the pool.
        :param pulumi.Input[builtins.str] node_location: Name of the Google Distributed Cloud Edge zone where this node pool will be created. For example: `us-central1-edge-customer-a`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels associated with this resource.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input['NodePoolLocalDiskEncryptionArgs'] local_disk_encryption: Local disk encryption options. This field is only used when enabling CMEK support.
               Structure is documented below.
        :param pulumi.Input[builtins.str] machine_filter: Only machines matching this filter will be allowed to join the node pool.
               The filtering language accepts strings like "name=<name>", and is
               documented in more detail in [AIP-160](https://google.aip.dev/160).
        :param pulumi.Input[builtins.str] name: The resource name of the node pool.
        :param pulumi.Input['NodePoolNodeConfigArgs'] node_config: Configuration for each node in the NodePool
               Structure is documented below.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "cluster", cluster)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "node_count", node_count)
        pulumi.set(__self__, "node_location", node_location)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if local_disk_encryption is not None:
            pulumi.set(__self__, "local_disk_encryption", local_disk_encryption)
        if machine_filter is not None:
            pulumi.set(__self__, "machine_filter", machine_filter)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_config is not None:
            pulumi.set(__self__, "node_config", node_config)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter
    def cluster(self) -> pulumi.Input[builtins.str]:
        """
        The name of the target Distributed Cloud Edge Cluster.


        - - -
        """
        return pulumi.get(self, "cluster")

    @cluster.setter
    def cluster(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "cluster", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        The location of the resource.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> pulumi.Input[builtins.int]:
        """
        The number of nodes in the pool.
        """
        return pulumi.get(self, "node_count")

    @node_count.setter
    def node_count(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "node_count", value)

    @property
    @pulumi.getter(name="nodeLocation")
    def node_location(self) -> pulumi.Input[builtins.str]:
        """
        Name of the Google Distributed Cloud Edge zone where this node pool will be created. For example: `us-central1-edge-customer-a`.
        """
        return pulumi.get(self, "node_location")

    @node_location.setter
    def node_location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "node_location", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Labels associated with this resource.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="localDiskEncryption")
    def local_disk_encryption(self) -> Optional[pulumi.Input['NodePoolLocalDiskEncryptionArgs']]:
        """
        Local disk encryption options. This field is only used when enabling CMEK support.
        Structure is documented below.
        """
        return pulumi.get(self, "local_disk_encryption")

    @local_disk_encryption.setter
    def local_disk_encryption(self, value: Optional[pulumi.Input['NodePoolLocalDiskEncryptionArgs']]):
        pulumi.set(self, "local_disk_encryption", value)

    @property
    @pulumi.getter(name="machineFilter")
    def machine_filter(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Only machines matching this filter will be allowed to join the node pool.
        The filtering language accepts strings like "name=<name>", and is
        documented in more detail in [AIP-160](https://google.aip.dev/160).
        """
        return pulumi.get(self, "machine_filter")

    @machine_filter.setter
    def machine_filter(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "machine_filter", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource name of the node pool.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nodeConfig")
    def node_config(self) -> Optional[pulumi.Input['NodePoolNodeConfigArgs']]:
        """
        Configuration for each node in the NodePool
        Structure is documented below.
        """
        return pulumi.get(self, "node_config")

    @node_config.setter
    def node_config(self, value: Optional[pulumi.Input['NodePoolNodeConfigArgs']]):
        pulumi.set(self, "node_config", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _NodePoolState:
    def __init__(__self__, *,
                 cluster: Optional[pulumi.Input[builtins.str]] = None,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 local_disk_encryption: Optional[pulumi.Input['NodePoolLocalDiskEncryptionArgs']] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 machine_filter: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 node_config: Optional[pulumi.Input['NodePoolNodeConfigArgs']] = None,
                 node_count: Optional[pulumi.Input[builtins.int]] = None,
                 node_location: Optional[pulumi.Input[builtins.str]] = None,
                 node_version: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering NodePool resources.
        :param pulumi.Input[builtins.str] cluster: The name of the target Distributed Cloud Edge Cluster.
               
               
               - - -
        :param pulumi.Input[builtins.str] create_time: The time when the node pool was created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels associated with this resource.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input['NodePoolLocalDiskEncryptionArgs'] local_disk_encryption: Local disk encryption options. This field is only used when enabling CMEK support.
               Structure is documented below.
        :param pulumi.Input[builtins.str] location: The location of the resource.
        :param pulumi.Input[builtins.str] machine_filter: Only machines matching this filter will be allowed to join the node pool.
               The filtering language accepts strings like "name=<name>", and is
               documented in more detail in [AIP-160](https://google.aip.dev/160).
        :param pulumi.Input[builtins.str] name: The resource name of the node pool.
        :param pulumi.Input['NodePoolNodeConfigArgs'] node_config: Configuration for each node in the NodePool
               Structure is documented below.
        :param pulumi.Input[builtins.int] node_count: The number of nodes in the pool.
        :param pulumi.Input[builtins.str] node_location: Name of the Google Distributed Cloud Edge zone where this node pool will be created. For example: `us-central1-edge-customer-a`.
        :param pulumi.Input[builtins.str] node_version: The lowest release version among all worker nodes.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.str] update_time: The time when the node pool was last updated.
        """
        if cluster is not None:
            pulumi.set(__self__, "cluster", cluster)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if local_disk_encryption is not None:
            pulumi.set(__self__, "local_disk_encryption", local_disk_encryption)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if machine_filter is not None:
            pulumi.set(__self__, "machine_filter", machine_filter)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_config is not None:
            pulumi.set(__self__, "node_config", node_config)
        if node_count is not None:
            pulumi.set(__self__, "node_count", node_count)
        if node_location is not None:
            pulumi.set(__self__, "node_location", node_location)
        if node_version is not None:
            pulumi.set(__self__, "node_version", node_version)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter
    def cluster(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the target Distributed Cloud Edge Cluster.


        - - -
        """
        return pulumi.get(self, "cluster")

    @cluster.setter
    def cluster(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cluster", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time when the node pool was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Labels associated with this resource.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="localDiskEncryption")
    def local_disk_encryption(self) -> Optional[pulumi.Input['NodePoolLocalDiskEncryptionArgs']]:
        """
        Local disk encryption options. This field is only used when enabling CMEK support.
        Structure is documented below.
        """
        return pulumi.get(self, "local_disk_encryption")

    @local_disk_encryption.setter
    def local_disk_encryption(self, value: Optional[pulumi.Input['NodePoolLocalDiskEncryptionArgs']]):
        pulumi.set(self, "local_disk_encryption", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location of the resource.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="machineFilter")
    def machine_filter(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Only machines matching this filter will be allowed to join the node pool.
        The filtering language accepts strings like "name=<name>", and is
        documented in more detail in [AIP-160](https://google.aip.dev/160).
        """
        return pulumi.get(self, "machine_filter")

    @machine_filter.setter
    def machine_filter(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "machine_filter", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource name of the node pool.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nodeConfig")
    def node_config(self) -> Optional[pulumi.Input['NodePoolNodeConfigArgs']]:
        """
        Configuration for each node in the NodePool
        Structure is documented below.
        """
        return pulumi.get(self, "node_config")

    @node_config.setter
    def node_config(self, value: Optional[pulumi.Input['NodePoolNodeConfigArgs']]):
        pulumi.set(self, "node_config", value)

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of nodes in the pool.
        """
        return pulumi.get(self, "node_count")

    @node_count.setter
    def node_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "node_count", value)

    @property
    @pulumi.getter(name="nodeLocation")
    def node_location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the Google Distributed Cloud Edge zone where this node pool will be created. For example: `us-central1-edge-customer-a`.
        """
        return pulumi.get(self, "node_location")

    @node_location.setter
    def node_location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "node_location", value)

    @property
    @pulumi.getter(name="nodeVersion")
    def node_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The lowest release version among all worker nodes.
        """
        return pulumi.get(self, "node_version")

    @node_version.setter
    def node_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "node_version", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time when the node pool was last updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:edgecontainer/nodePool:NodePool")
class NodePool(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 local_disk_encryption: Optional[pulumi.Input[Union['NodePoolLocalDiskEncryptionArgs', 'NodePoolLocalDiskEncryptionArgsDict']]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 machine_filter: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 node_config: Optional[pulumi.Input[Union['NodePoolNodeConfigArgs', 'NodePoolNodeConfigArgsDict']]] = None,
                 node_count: Optional[pulumi.Input[builtins.int]] = None,
                 node_location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        "A set of Kubernetes nodes in a cluster with common configuration and specification."

        To get more information about NodePool, see:

        * [API documentation](https://cloud.google.com/distributed-cloud/edge/latest/docs/reference/container/rest/v1/projects.locations.clusters.nodePools)
        * How-to Guides
            * [Google Distributed Cloud Edge](https://cloud.google.com/distributed-cloud/edge/latest/docs)

        ## Example Usage

        ### Edgecontainer Node Pool

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        cluster = gcp.edgecontainer.Cluster("cluster",
            name="default",
            location="us-central1",
            authorization={
                "admin_users": {
                    "username": "admin@hashicorptest.com",
                },
            },
            networking={
                "cluster_ipv4_cidr_blocks": ["10.0.0.0/16"],
                "services_ipv4_cidr_blocks": ["10.1.0.0/16"],
            },
            fleet={
                "project": f"projects/{project.number}",
            })
        default = gcp.edgecontainer.NodePool("default",
            name="nodepool-1",
            cluster=cluster.name,
            location="us-central1",
            node_location="us-central1-edge-example-edgesite",
            node_count=3,
            labels={
                "my_key": "my_val",
                "other_key": "other_val",
            })
        ```
        ### Edgecontainer Node Pool With Cmek

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        cluster = gcp.edgecontainer.Cluster("cluster",
            name="default",
            location="us-central1",
            authorization={
                "admin_users": {
                    "username": "admin@hashicorptest.com",
                },
            },
            networking={
                "cluster_ipv4_cidr_blocks": ["10.0.0.0/16"],
                "services_ipv4_cidr_blocks": ["10.1.0.0/16"],
            },
            fleet={
                "project": f"projects/{project.number}",
            })
        key_ring = gcp.kms.KeyRing("key_ring",
            name="keyring",
            location="us-central1")
        crypto_key_crypto_key = gcp.kms.CryptoKey("crypto_key",
            name="key",
            key_ring=key_ring.id)
        crypto_key = gcp.kms.CryptoKeyIAMMember("crypto_key",
            crypto_key_id=crypto_key_crypto_key.id,
            role="roles/cloudkms.cryptoKeyEncrypterDecrypter",
            member=f"serviceAccount:service-{project.number}@gcp-sa-edgecontainer.iam.gserviceaccount.com")
        default = gcp.edgecontainer.NodePool("default",
            name="nodepool-1",
            cluster=cluster.name,
            location="us-central1",
            node_location="us-central1-edge-example-edgesite",
            node_count=3,
            local_disk_encryption={
                "kms_key": crypto_key_crypto_key.id,
            },
            opts = pulumi.ResourceOptions(depends_on=[crypto_key]))
        ```
        ### Edgecontainer Local Control Plane Node Pool

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        default = gcp.edgecontainer.Cluster("default",
            name="default",
            location="us-central1",
            authorization={
                "admin_users": {
                    "username": "admin@hashicorptest.com",
                },
            },
            networking={
                "cluster_ipv4_cidr_blocks": ["10.0.0.0/16"],
                "services_ipv4_cidr_blocks": ["10.1.0.0/16"],
            },
            fleet={
                "project": f"projects/{project.number}",
            },
            external_load_balancer_ipv4_address_pools=["10.100.0.0-10.100.0.10"],
            control_plane={
                "local": {
                    "node_location": "us-central1-edge-example-edgesite",
                    "node_count": 1,
                    "machine_filter": "machine-name",
                    "shared_deployment_policy": "ALLOWED",
                },
            })
        default_node_pool = gcp.edgecontainer.NodePool("default",
            name="nodepool-1",
            cluster=cluster["name"],
            location="us-central1",
            node_location="us-central1-edge-example-edgesite",
            node_count=3)
        ```

        ## Import

        NodePool can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/clusters/{{cluster}}/nodePools/{{name}}`

        * `{{project}}/{{location}}/{{cluster}}/{{name}}`

        * `{{location}}/{{cluster}}/{{name}}`

        When using the `pulumi import` command, NodePool can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:edgecontainer/nodePool:NodePool default projects/{{project}}/locations/{{location}}/clusters/{{cluster}}/nodePools/{{name}}
        ```

        ```sh
        $ pulumi import gcp:edgecontainer/nodePool:NodePool default {{project}}/{{location}}/{{cluster}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:edgecontainer/nodePool:NodePool default {{location}}/{{cluster}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] cluster: The name of the target Distributed Cloud Edge Cluster.
               
               
               - - -
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels associated with this resource.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[Union['NodePoolLocalDiskEncryptionArgs', 'NodePoolLocalDiskEncryptionArgsDict']] local_disk_encryption: Local disk encryption options. This field is only used when enabling CMEK support.
               Structure is documented below.
        :param pulumi.Input[builtins.str] location: The location of the resource.
        :param pulumi.Input[builtins.str] machine_filter: Only machines matching this filter will be allowed to join the node pool.
               The filtering language accepts strings like "name=<name>", and is
               documented in more detail in [AIP-160](https://google.aip.dev/160).
        :param pulumi.Input[builtins.str] name: The resource name of the node pool.
        :param pulumi.Input[Union['NodePoolNodeConfigArgs', 'NodePoolNodeConfigArgsDict']] node_config: Configuration for each node in the NodePool
               Structure is documented below.
        :param pulumi.Input[builtins.int] node_count: The number of nodes in the pool.
        :param pulumi.Input[builtins.str] node_location: Name of the Google Distributed Cloud Edge zone where this node pool will be created. For example: `us-central1-edge-customer-a`.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NodePoolArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        "A set of Kubernetes nodes in a cluster with common configuration and specification."

        To get more information about NodePool, see:

        * [API documentation](https://cloud.google.com/distributed-cloud/edge/latest/docs/reference/container/rest/v1/projects.locations.clusters.nodePools)
        * How-to Guides
            * [Google Distributed Cloud Edge](https://cloud.google.com/distributed-cloud/edge/latest/docs)

        ## Example Usage

        ### Edgecontainer Node Pool

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        cluster = gcp.edgecontainer.Cluster("cluster",
            name="default",
            location="us-central1",
            authorization={
                "admin_users": {
                    "username": "admin@hashicorptest.com",
                },
            },
            networking={
                "cluster_ipv4_cidr_blocks": ["10.0.0.0/16"],
                "services_ipv4_cidr_blocks": ["10.1.0.0/16"],
            },
            fleet={
                "project": f"projects/{project.number}",
            })
        default = gcp.edgecontainer.NodePool("default",
            name="nodepool-1",
            cluster=cluster.name,
            location="us-central1",
            node_location="us-central1-edge-example-edgesite",
            node_count=3,
            labels={
                "my_key": "my_val",
                "other_key": "other_val",
            })
        ```
        ### Edgecontainer Node Pool With Cmek

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        cluster = gcp.edgecontainer.Cluster("cluster",
            name="default",
            location="us-central1",
            authorization={
                "admin_users": {
                    "username": "admin@hashicorptest.com",
                },
            },
            networking={
                "cluster_ipv4_cidr_blocks": ["10.0.0.0/16"],
                "services_ipv4_cidr_blocks": ["10.1.0.0/16"],
            },
            fleet={
                "project": f"projects/{project.number}",
            })
        key_ring = gcp.kms.KeyRing("key_ring",
            name="keyring",
            location="us-central1")
        crypto_key_crypto_key = gcp.kms.CryptoKey("crypto_key",
            name="key",
            key_ring=key_ring.id)
        crypto_key = gcp.kms.CryptoKeyIAMMember("crypto_key",
            crypto_key_id=crypto_key_crypto_key.id,
            role="roles/cloudkms.cryptoKeyEncrypterDecrypter",
            member=f"serviceAccount:service-{project.number}@gcp-sa-edgecontainer.iam.gserviceaccount.com")
        default = gcp.edgecontainer.NodePool("default",
            name="nodepool-1",
            cluster=cluster.name,
            location="us-central1",
            node_location="us-central1-edge-example-edgesite",
            node_count=3,
            local_disk_encryption={
                "kms_key": crypto_key_crypto_key.id,
            },
            opts = pulumi.ResourceOptions(depends_on=[crypto_key]))
        ```
        ### Edgecontainer Local Control Plane Node Pool

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        default = gcp.edgecontainer.Cluster("default",
            name="default",
            location="us-central1",
            authorization={
                "admin_users": {
                    "username": "admin@hashicorptest.com",
                },
            },
            networking={
                "cluster_ipv4_cidr_blocks": ["10.0.0.0/16"],
                "services_ipv4_cidr_blocks": ["10.1.0.0/16"],
            },
            fleet={
                "project": f"projects/{project.number}",
            },
            external_load_balancer_ipv4_address_pools=["10.100.0.0-10.100.0.10"],
            control_plane={
                "local": {
                    "node_location": "us-central1-edge-example-edgesite",
                    "node_count": 1,
                    "machine_filter": "machine-name",
                    "shared_deployment_policy": "ALLOWED",
                },
            })
        default_node_pool = gcp.edgecontainer.NodePool("default",
            name="nodepool-1",
            cluster=cluster["name"],
            location="us-central1",
            node_location="us-central1-edge-example-edgesite",
            node_count=3)
        ```

        ## Import

        NodePool can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/clusters/{{cluster}}/nodePools/{{name}}`

        * `{{project}}/{{location}}/{{cluster}}/{{name}}`

        * `{{location}}/{{cluster}}/{{name}}`

        When using the `pulumi import` command, NodePool can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:edgecontainer/nodePool:NodePool default projects/{{project}}/locations/{{location}}/clusters/{{cluster}}/nodePools/{{name}}
        ```

        ```sh
        $ pulumi import gcp:edgecontainer/nodePool:NodePool default {{project}}/{{location}}/{{cluster}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:edgecontainer/nodePool:NodePool default {{location}}/{{cluster}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param NodePoolArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NodePoolArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 local_disk_encryption: Optional[pulumi.Input[Union['NodePoolLocalDiskEncryptionArgs', 'NodePoolLocalDiskEncryptionArgsDict']]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 machine_filter: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 node_config: Optional[pulumi.Input[Union['NodePoolNodeConfigArgs', 'NodePoolNodeConfigArgsDict']]] = None,
                 node_count: Optional[pulumi.Input[builtins.int]] = None,
                 node_location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NodePoolArgs.__new__(NodePoolArgs)

            if cluster is None and not opts.urn:
                raise TypeError("Missing required property 'cluster'")
            __props__.__dict__["cluster"] = cluster
            __props__.__dict__["labels"] = labels
            __props__.__dict__["local_disk_encryption"] = local_disk_encryption
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["machine_filter"] = machine_filter
            __props__.__dict__["name"] = name
            __props__.__dict__["node_config"] = node_config
            if node_count is None and not opts.urn:
                raise TypeError("Missing required property 'node_count'")
            __props__.__dict__["node_count"] = node_count
            if node_location is None and not opts.urn:
                raise TypeError("Missing required property 'node_location'")
            __props__.__dict__["node_location"] = node_location
            __props__.__dict__["project"] = project
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["node_version"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(NodePool, __self__).__init__(
            'gcp:edgecontainer/nodePool:NodePool',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster: Optional[pulumi.Input[builtins.str]] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            local_disk_encryption: Optional[pulumi.Input[Union['NodePoolLocalDiskEncryptionArgs', 'NodePoolLocalDiskEncryptionArgsDict']]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            machine_filter: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            node_config: Optional[pulumi.Input[Union['NodePoolNodeConfigArgs', 'NodePoolNodeConfigArgsDict']]] = None,
            node_count: Optional[pulumi.Input[builtins.int]] = None,
            node_location: Optional[pulumi.Input[builtins.str]] = None,
            node_version: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None) -> 'NodePool':
        """
        Get an existing NodePool resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] cluster: The name of the target Distributed Cloud Edge Cluster.
               
               
               - - -
        :param pulumi.Input[builtins.str] create_time: The time when the node pool was created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels associated with this resource.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[Union['NodePoolLocalDiskEncryptionArgs', 'NodePoolLocalDiskEncryptionArgsDict']] local_disk_encryption: Local disk encryption options. This field is only used when enabling CMEK support.
               Structure is documented below.
        :param pulumi.Input[builtins.str] location: The location of the resource.
        :param pulumi.Input[builtins.str] machine_filter: Only machines matching this filter will be allowed to join the node pool.
               The filtering language accepts strings like "name=<name>", and is
               documented in more detail in [AIP-160](https://google.aip.dev/160).
        :param pulumi.Input[builtins.str] name: The resource name of the node pool.
        :param pulumi.Input[Union['NodePoolNodeConfigArgs', 'NodePoolNodeConfigArgsDict']] node_config: Configuration for each node in the NodePool
               Structure is documented below.
        :param pulumi.Input[builtins.int] node_count: The number of nodes in the pool.
        :param pulumi.Input[builtins.str] node_location: Name of the Google Distributed Cloud Edge zone where this node pool will be created. For example: `us-central1-edge-customer-a`.
        :param pulumi.Input[builtins.str] node_version: The lowest release version among all worker nodes.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.str] update_time: The time when the node pool was last updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NodePoolState.__new__(_NodePoolState)

        __props__.__dict__["cluster"] = cluster
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["labels"] = labels
        __props__.__dict__["local_disk_encryption"] = local_disk_encryption
        __props__.__dict__["location"] = location
        __props__.__dict__["machine_filter"] = machine_filter
        __props__.__dict__["name"] = name
        __props__.__dict__["node_config"] = node_config
        __props__.__dict__["node_count"] = node_count
        __props__.__dict__["node_location"] = node_location
        __props__.__dict__["node_version"] = node_version
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["update_time"] = update_time
        return NodePool(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def cluster(self) -> pulumi.Output[builtins.str]:
        """
        The name of the target Distributed Cloud Edge Cluster.


        - - -
        """
        return pulumi.get(self, "cluster")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        The time when the node pool was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Labels associated with this resource.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="localDiskEncryption")
    def local_disk_encryption(self) -> pulumi.Output[Optional['outputs.NodePoolLocalDiskEncryption']]:
        """
        Local disk encryption options. This field is only used when enabling CMEK support.
        Structure is documented below.
        """
        return pulumi.get(self, "local_disk_encryption")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The location of the resource.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="machineFilter")
    def machine_filter(self) -> pulumi.Output[builtins.str]:
        """
        Only machines matching this filter will be allowed to join the node pool.
        The filtering language accepts strings like "name=<name>", and is
        documented in more detail in [AIP-160](https://google.aip.dev/160).
        """
        return pulumi.get(self, "machine_filter")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The resource name of the node pool.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nodeConfig")
    def node_config(self) -> pulumi.Output['outputs.NodePoolNodeConfig']:
        """
        Configuration for each node in the NodePool
        Structure is documented below.
        """
        return pulumi.get(self, "node_config")

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> pulumi.Output[builtins.int]:
        """
        The number of nodes in the pool.
        """
        return pulumi.get(self, "node_count")

    @property
    @pulumi.getter(name="nodeLocation")
    def node_location(self) -> pulumi.Output[builtins.str]:
        """
        Name of the Google Distributed Cloud Edge zone where this node pool will be created. For example: `us-central1-edge-customer-a`.
        """
        return pulumi.get(self, "node_location")

    @property
    @pulumi.getter(name="nodeVersion")
    def node_version(self) -> pulumi.Output[builtins.str]:
        """
        The lowest release version among all worker nodes.
        """
        return pulumi.get(self, "node_version")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        The time when the node pool was last updated.
        """
        return pulumi.get(self, "update_time")

