# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ClusterAuthorization',
    'ClusterAuthorizationAdminUsers',
    'ClusterControlPlane',
    'ClusterControlPlaneEncryption',
    'ClusterControlPlaneEncryptionKmsStatus',
    'ClusterControlPlaneLocal',
    'ClusterControlPlaneRemote',
    'ClusterFleet',
    'ClusterMaintenanceEvent',
    'ClusterMaintenancePolicy',
    'ClusterMaintenancePolicyMaintenanceExclusion',
    'ClusterMaintenancePolicyMaintenanceExclusionWindow',
    'ClusterMaintenancePolicyWindow',
    'ClusterMaintenancePolicyWindowRecurringWindow',
    'ClusterMaintenancePolicyWindowRecurringWindowWindow',
    'ClusterNetworking',
    'ClusterSystemAddonsConfig',
    'ClusterSystemAddonsConfigIngress',
    'NodePoolLocalDiskEncryption',
    'NodePoolNodeConfig',
    'VpnConnectionDetail',
    'VpnConnectionDetailCloudRouter',
    'VpnConnectionDetailCloudVpn',
    'VpnConnectionVpcProject',
]

@pulumi.output_type
class ClusterAuthorization(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adminUsers":
            suggest = "admin_users"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterAuthorization. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterAuthorization.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterAuthorization.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 admin_users: 'outputs.ClusterAuthorizationAdminUsers'):
        """
        :param 'ClusterAuthorizationAdminUsersArgs' admin_users: User that will be granted the cluster-admin role on the cluster, providing
               full access to the cluster. Currently, this is a singular field, but will
               be expanded to allow multiple admins in the future.
               Structure is documented below.
        """
        pulumi.set(__self__, "admin_users", admin_users)

    @property
    @pulumi.getter(name="adminUsers")
    def admin_users(self) -> 'outputs.ClusterAuthorizationAdminUsers':
        """
        User that will be granted the cluster-admin role on the cluster, providing
        full access to the cluster. Currently, this is a singular field, but will
        be expanded to allow multiple admins in the future.
        Structure is documented below.
        """
        return pulumi.get(self, "admin_users")


@pulumi.output_type
class ClusterAuthorizationAdminUsers(dict):
    def __init__(__self__, *,
                 username: builtins.str):
        """
        :param builtins.str username: An active Google username.
               
               - - -
        """
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def username(self) -> builtins.str:
        """
        An active Google username.

        - - -
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class ClusterControlPlane(dict):
    def __init__(__self__, *,
                 local: Optional['outputs.ClusterControlPlaneLocal'] = None,
                 remote: Optional['outputs.ClusterControlPlaneRemote'] = None):
        """
        :param 'ClusterControlPlaneLocalArgs' local: Local control plane configuration.
               Structure is documented below.
        :param 'ClusterControlPlaneRemoteArgs' remote: Remote control plane configuration.
               Structure is documented below.
        """
        if local is not None:
            pulumi.set(__self__, "local", local)
        if remote is not None:
            pulumi.set(__self__, "remote", remote)

    @property
    @pulumi.getter
    def local(self) -> Optional['outputs.ClusterControlPlaneLocal']:
        """
        Local control plane configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "local")

    @property
    @pulumi.getter
    def remote(self) -> Optional['outputs.ClusterControlPlaneRemote']:
        """
        Remote control plane configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "remote")


@pulumi.output_type
class ClusterControlPlaneEncryption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKey":
            suggest = "kms_key"
        elif key == "kmsKeyActiveVersion":
            suggest = "kms_key_active_version"
        elif key == "kmsKeyState":
            suggest = "kms_key_state"
        elif key == "kmsStatuses":
            suggest = "kms_statuses"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterControlPlaneEncryption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterControlPlaneEncryption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterControlPlaneEncryption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key: Optional[builtins.str] = None,
                 kms_key_active_version: Optional[builtins.str] = None,
                 kms_key_state: Optional[builtins.str] = None,
                 kms_statuses: Optional[Sequence['outputs.ClusterControlPlaneEncryptionKmsStatus']] = None):
        """
        :param builtins.str kms_key: The Cloud KMS CryptoKey e.g.
               projects/{project}/locations/{location}/keyRings/{keyRing}/cryptoKeys/{cryptoKey}
               to use for protecting control plane disks. If not specified, a
               Google-managed key will be used instead.
        :param builtins.str kms_key_active_version: (Output)
               The Cloud KMS CryptoKeyVersion currently in use for protecting control
               plane disks. Only applicable if kms_key is set.
        :param builtins.str kms_key_state: (Output)
               Availability of the Cloud KMS CryptoKey. If not `KEY_AVAILABLE`, then
               nodes may go offline as they cannot access their local data. This can be
               caused by a lack of permissions to use the key, or if the key is disabled
               or deleted.
        :param Sequence['ClusterControlPlaneEncryptionKmsStatusArgs'] kms_statuses: (Output)
               Error status returned by Cloud KMS when using this key. This field may be
               populated only if `kms_key_state` is not `KMS_KEY_STATE_KEY_AVAILABLE`.
               If populated, this field contains the error status reported by Cloud KMS.
               Structure is documented below.
               
               
               <a name="nested_control_plane_encryption_kms_status"></a>The `kms_status` block contains:
        """
        if kms_key is not None:
            pulumi.set(__self__, "kms_key", kms_key)
        if kms_key_active_version is not None:
            pulumi.set(__self__, "kms_key_active_version", kms_key_active_version)
        if kms_key_state is not None:
            pulumi.set(__self__, "kms_key_state", kms_key_state)
        if kms_statuses is not None:
            pulumi.set(__self__, "kms_statuses", kms_statuses)

    @property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> Optional[builtins.str]:
        """
        The Cloud KMS CryptoKey e.g.
        projects/{project}/locations/{location}/keyRings/{keyRing}/cryptoKeys/{cryptoKey}
        to use for protecting control plane disks. If not specified, a
        Google-managed key will be used instead.
        """
        return pulumi.get(self, "kms_key")

    @property
    @pulumi.getter(name="kmsKeyActiveVersion")
    def kms_key_active_version(self) -> Optional[builtins.str]:
        """
        (Output)
        The Cloud KMS CryptoKeyVersion currently in use for protecting control
        plane disks. Only applicable if kms_key is set.
        """
        return pulumi.get(self, "kms_key_active_version")

    @property
    @pulumi.getter(name="kmsKeyState")
    def kms_key_state(self) -> Optional[builtins.str]:
        """
        (Output)
        Availability of the Cloud KMS CryptoKey. If not `KEY_AVAILABLE`, then
        nodes may go offline as they cannot access their local data. This can be
        caused by a lack of permissions to use the key, or if the key is disabled
        or deleted.
        """
        return pulumi.get(self, "kms_key_state")

    @property
    @pulumi.getter(name="kmsStatuses")
    def kms_statuses(self) -> Optional[Sequence['outputs.ClusterControlPlaneEncryptionKmsStatus']]:
        """
        (Output)
        Error status returned by Cloud KMS when using this key. This field may be
        populated only if `kms_key_state` is not `KMS_KEY_STATE_KEY_AVAILABLE`.
        If populated, this field contains the error status reported by Cloud KMS.
        Structure is documented below.


        <a name="nested_control_plane_encryption_kms_status"></a>The `kms_status` block contains:
        """
        return pulumi.get(self, "kms_statuses")


@pulumi.output_type
class ClusterControlPlaneEncryptionKmsStatus(dict):
    def __init__(__self__, *,
                 code: Optional[builtins.int] = None,
                 message: Optional[builtins.str] = None):
        """
        :param builtins.int code: The status code, which should be an enum value of google.rpc.Code.
        :param builtins.str message: A developer-facing error message, which should be in English. Any user-facing error message should be localized and sent in the google.rpc.Status.details field, or localized by the client.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if message is not None:
            pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> Optional[builtins.int]:
        """
        The status code, which should be an enum value of google.rpc.Code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def message(self) -> Optional[builtins.str]:
        """
        A developer-facing error message, which should be in English. Any user-facing error message should be localized and sent in the google.rpc.Status.details field, or localized by the client.
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class ClusterControlPlaneLocal(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "machineFilter":
            suggest = "machine_filter"
        elif key == "nodeCount":
            suggest = "node_count"
        elif key == "nodeLocation":
            suggest = "node_location"
        elif key == "sharedDeploymentPolicy":
            suggest = "shared_deployment_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterControlPlaneLocal. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterControlPlaneLocal.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterControlPlaneLocal.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 machine_filter: Optional[builtins.str] = None,
                 node_count: Optional[builtins.int] = None,
                 node_location: Optional[builtins.str] = None,
                 shared_deployment_policy: Optional[builtins.str] = None):
        """
        :param builtins.str machine_filter: Only machines matching this filter will be allowed to host control
               plane nodes. The filtering language accepts strings like "name=<name>",
               and is documented here: [AIP-160](https://google.aip.dev/160).
        :param builtins.int node_count: The number of nodes to serve as replicas of the Control Plane.
               Only 1 and 3 are supported.
        :param builtins.str node_location: Name of the Google Distributed Cloud Edge zones where this node pool
               will be created. For example: `us-central1-edge-customer-a`.
        :param builtins.str shared_deployment_policy: Policy configuration about how user applications are deployed.
               Possible values are: `SHARED_DEPLOYMENT_POLICY_UNSPECIFIED`, `ALLOWED`, `DISALLOWED`.
        """
        if machine_filter is not None:
            pulumi.set(__self__, "machine_filter", machine_filter)
        if node_count is not None:
            pulumi.set(__self__, "node_count", node_count)
        if node_location is not None:
            pulumi.set(__self__, "node_location", node_location)
        if shared_deployment_policy is not None:
            pulumi.set(__self__, "shared_deployment_policy", shared_deployment_policy)

    @property
    @pulumi.getter(name="machineFilter")
    def machine_filter(self) -> Optional[builtins.str]:
        """
        Only machines matching this filter will be allowed to host control
        plane nodes. The filtering language accepts strings like "name=<name>",
        and is documented here: [AIP-160](https://google.aip.dev/160).
        """
        return pulumi.get(self, "machine_filter")

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> Optional[builtins.int]:
        """
        The number of nodes to serve as replicas of the Control Plane.
        Only 1 and 3 are supported.
        """
        return pulumi.get(self, "node_count")

    @property
    @pulumi.getter(name="nodeLocation")
    def node_location(self) -> Optional[builtins.str]:
        """
        Name of the Google Distributed Cloud Edge zones where this node pool
        will be created. For example: `us-central1-edge-customer-a`.
        """
        return pulumi.get(self, "node_location")

    @property
    @pulumi.getter(name="sharedDeploymentPolicy")
    def shared_deployment_policy(self) -> Optional[builtins.str]:
        """
        Policy configuration about how user applications are deployed.
        Possible values are: `SHARED_DEPLOYMENT_POLICY_UNSPECIFIED`, `ALLOWED`, `DISALLOWED`.
        """
        return pulumi.get(self, "shared_deployment_policy")


@pulumi.output_type
class ClusterControlPlaneRemote(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodeLocation":
            suggest = "node_location"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterControlPlaneRemote. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterControlPlaneRemote.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterControlPlaneRemote.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 node_location: Optional[builtins.str] = None):
        """
        :param builtins.str node_location: Name of the Google Distributed Cloud Edge zones where this node pool
               will be created. For example: `us-central1-edge-customer-a`.
        """
        if node_location is not None:
            pulumi.set(__self__, "node_location", node_location)

    @property
    @pulumi.getter(name="nodeLocation")
    def node_location(self) -> Optional[builtins.str]:
        """
        Name of the Google Distributed Cloud Edge zones where this node pool
        will be created. For example: `us-central1-edge-customer-a`.
        """
        return pulumi.get(self, "node_location")


@pulumi.output_type
class ClusterFleet(dict):
    def __init__(__self__, *,
                 project: builtins.str,
                 membership: Optional[builtins.str] = None):
        """
        :param builtins.str project: The name of the Fleet host project where this cluster will be registered.
               Project names are formatted as
               `projects/<project-number>`.
        :param builtins.str membership: (Output)
               The name of the managed Hub Membership resource associated to this cluster.
               Membership names are formatted as
               `projects/<project-number>/locations/global/membership/<cluster-id>`.
        """
        pulumi.set(__self__, "project", project)
        if membership is not None:
            pulumi.set(__self__, "membership", membership)

    @property
    @pulumi.getter
    def project(self) -> builtins.str:
        """
        The name of the Fleet host project where this cluster will be registered.
        Project names are formatted as
        `projects/<project-number>`.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def membership(self) -> Optional[builtins.str]:
        """
        (Output)
        The name of the managed Hub Membership resource associated to this cluster.
        Membership names are formatted as
        `projects/<project-number>/locations/global/membership/<cluster-id>`.
        """
        return pulumi.get(self, "membership")


@pulumi.output_type
class ClusterMaintenanceEvent(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createTime":
            suggest = "create_time"
        elif key == "endTime":
            suggest = "end_time"
        elif key == "startTime":
            suggest = "start_time"
        elif key == "targetVersion":
            suggest = "target_version"
        elif key == "updateTime":
            suggest = "update_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterMaintenanceEvent. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterMaintenanceEvent.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterMaintenanceEvent.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 create_time: Optional[builtins.str] = None,
                 end_time: Optional[builtins.str] = None,
                 operation: Optional[builtins.str] = None,
                 schedule: Optional[builtins.str] = None,
                 start_time: Optional[builtins.str] = None,
                 state: Optional[builtins.str] = None,
                 target_version: Optional[builtins.str] = None,
                 type: Optional[builtins.str] = None,
                 update_time: Optional[builtins.str] = None,
                 uuid: Optional[builtins.str] = None):
        """
        :param builtins.str create_time: (Output)
               The time when the maintenance event request was created.
        :param builtins.str end_time: (Output)
               The time when the maintenance event ended, either successfully or not. If
               the maintenance event is split into multiple maintenance windows,
               end_time is only updated when the whole flow ends.
        :param builtins.str operation: (Output)
               The operation for running the maintenance event. Specified in the format
               projects/*/locations/*/operations/*. If the maintenance event is split
               into multiple operations (e.g. due to maintenance windows), the latest
               one is recorded.
        :param builtins.str schedule: (Output)
               The schedule of the maintenance event.
        :param builtins.str start_time: (Output)
               The time when the maintenance event started.
        :param builtins.str state: (Output)
               Indicates the maintenance event state.
        :param builtins.str target_version: (Output)
               The target version of the cluster.
        :param builtins.str type: (Output)
               Indicates the maintenance event type.
        :param builtins.str update_time: (Output)
               The time when the maintenance event message was updated.
        :param builtins.str uuid: (Output)
               UUID of the maintenance event.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if operation is not None:
            pulumi.set(__self__, "operation", operation)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if target_version is not None:
            pulumi.set(__self__, "target_version", target_version)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if uuid is not None:
            pulumi.set(__self__, "uuid", uuid)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[builtins.str]:
        """
        (Output)
        The time when the maintenance event request was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[builtins.str]:
        """
        (Output)
        The time when the maintenance event ended, either successfully or not. If
        the maintenance event is split into multiple maintenance windows,
        end_time is only updated when the whole flow ends.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter
    def operation(self) -> Optional[builtins.str]:
        """
        (Output)
        The operation for running the maintenance event. Specified in the format
        projects/*/locations/*/operations/*. If the maintenance event is split
        into multiple operations (e.g. due to maintenance windows), the latest
        one is recorded.
        """
        return pulumi.get(self, "operation")

    @property
    @pulumi.getter
    def schedule(self) -> Optional[builtins.str]:
        """
        (Output)
        The schedule of the maintenance event.
        """
        return pulumi.get(self, "schedule")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[builtins.str]:
        """
        (Output)
        The time when the maintenance event started.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        (Output)
        Indicates the maintenance event state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="targetVersion")
    def target_version(self) -> Optional[builtins.str]:
        """
        (Output)
        The target version of the cluster.
        """
        return pulumi.get(self, "target_version")

    @property
    @pulumi.getter
    def type(self) -> Optional[builtins.str]:
        """
        (Output)
        Indicates the maintenance event type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[builtins.str]:
        """
        (Output)
        The time when the maintenance event message was updated.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter
    def uuid(self) -> Optional[builtins.str]:
        """
        (Output)
        UUID of the maintenance event.
        """
        return pulumi.get(self, "uuid")


@pulumi.output_type
class ClusterMaintenancePolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maintenanceExclusions":
            suggest = "maintenance_exclusions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterMaintenancePolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterMaintenancePolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterMaintenancePolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 window: 'outputs.ClusterMaintenancePolicyWindow',
                 maintenance_exclusions: Optional[Sequence['outputs.ClusterMaintenancePolicyMaintenanceExclusion']] = None):
        """
        :param 'ClusterMaintenancePolicyWindowArgs' window: Specifies the maintenance window in which maintenance may be performed.
               Structure is documented below.
        :param Sequence['ClusterMaintenancePolicyMaintenanceExclusionArgs'] maintenance_exclusions: Exclusions to automatic maintenance. Non-emergency maintenance should not occur
               in these windows. Each exclusion has a unique name and may be active or expired.
               The max number of maintenance exclusions allowed at a given time is 3.
               Structure is documented below.
        """
        pulumi.set(__self__, "window", window)
        if maintenance_exclusions is not None:
            pulumi.set(__self__, "maintenance_exclusions", maintenance_exclusions)

    @property
    @pulumi.getter
    def window(self) -> 'outputs.ClusterMaintenancePolicyWindow':
        """
        Specifies the maintenance window in which maintenance may be performed.
        Structure is documented below.
        """
        return pulumi.get(self, "window")

    @property
    @pulumi.getter(name="maintenanceExclusions")
    def maintenance_exclusions(self) -> Optional[Sequence['outputs.ClusterMaintenancePolicyMaintenanceExclusion']]:
        """
        Exclusions to automatic maintenance. Non-emergency maintenance should not occur
        in these windows. Each exclusion has a unique name and may be active or expired.
        The max number of maintenance exclusions allowed at a given time is 3.
        Structure is documented below.
        """
        return pulumi.get(self, "maintenance_exclusions")


@pulumi.output_type
class ClusterMaintenancePolicyMaintenanceExclusion(dict):
    def __init__(__self__, *,
                 id: Optional[builtins.str] = None,
                 window: Optional['outputs.ClusterMaintenancePolicyMaintenanceExclusionWindow'] = None):
        """
        :param builtins.str id: A unique (per cluster) id for the window.
        :param 'ClusterMaintenancePolicyMaintenanceExclusionWindowArgs' window: Represents an arbitrary window of time.
               Structure is documented below.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if window is not None:
            pulumi.set(__self__, "window", window)

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        A unique (per cluster) id for the window.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def window(self) -> Optional['outputs.ClusterMaintenancePolicyMaintenanceExclusionWindow']:
        """
        Represents an arbitrary window of time.
        Structure is documented below.
        """
        return pulumi.get(self, "window")


@pulumi.output_type
class ClusterMaintenancePolicyMaintenanceExclusionWindow(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endTime":
            suggest = "end_time"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterMaintenancePolicyMaintenanceExclusionWindow. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterMaintenancePolicyMaintenanceExclusionWindow.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterMaintenancePolicyMaintenanceExclusionWindow.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_time: Optional[builtins.str] = None,
                 start_time: Optional[builtins.str] = None):
        """
        :param builtins.str end_time: The time that the window ends. The end time must take place after the
               start time.
        :param builtins.str start_time: The time that the window first starts.
        """
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[builtins.str]:
        """
        The time that the window ends. The end time must take place after the
        start time.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[builtins.str]:
        """
        The time that the window first starts.
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class ClusterMaintenancePolicyWindow(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "recurringWindow":
            suggest = "recurring_window"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterMaintenancePolicyWindow. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterMaintenancePolicyWindow.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterMaintenancePolicyWindow.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 recurring_window: 'outputs.ClusterMaintenancePolicyWindowRecurringWindow'):
        """
        :param 'ClusterMaintenancePolicyWindowRecurringWindowArgs' recurring_window: Represents an arbitrary window of time that recurs.
               Structure is documented below.
        """
        pulumi.set(__self__, "recurring_window", recurring_window)

    @property
    @pulumi.getter(name="recurringWindow")
    def recurring_window(self) -> 'outputs.ClusterMaintenancePolicyWindowRecurringWindow':
        """
        Represents an arbitrary window of time that recurs.
        Structure is documented below.
        """
        return pulumi.get(self, "recurring_window")


@pulumi.output_type
class ClusterMaintenancePolicyWindowRecurringWindow(dict):
    def __init__(__self__, *,
                 recurrence: Optional[builtins.str] = None,
                 window: Optional['outputs.ClusterMaintenancePolicyWindowRecurringWindowWindow'] = None):
        """
        :param builtins.str recurrence: An RRULE (https://tools.ietf.org/html/rfc5545#section-3.8.5.3) for how
               this window recurs. They go on for the span of time between the start and
               end time.
        :param 'ClusterMaintenancePolicyWindowRecurringWindowWindowArgs' window: Represents an arbitrary window of time.
               Structure is documented below.
        """
        if recurrence is not None:
            pulumi.set(__self__, "recurrence", recurrence)
        if window is not None:
            pulumi.set(__self__, "window", window)

    @property
    @pulumi.getter
    def recurrence(self) -> Optional[builtins.str]:
        """
        An RRULE (https://tools.ietf.org/html/rfc5545#section-3.8.5.3) for how
        this window recurs. They go on for the span of time between the start and
        end time.
        """
        return pulumi.get(self, "recurrence")

    @property
    @pulumi.getter
    def window(self) -> Optional['outputs.ClusterMaintenancePolicyWindowRecurringWindowWindow']:
        """
        Represents an arbitrary window of time.
        Structure is documented below.
        """
        return pulumi.get(self, "window")


@pulumi.output_type
class ClusterMaintenancePolicyWindowRecurringWindowWindow(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endTime":
            suggest = "end_time"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterMaintenancePolicyWindowRecurringWindowWindow. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterMaintenancePolicyWindowRecurringWindowWindow.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterMaintenancePolicyWindowRecurringWindowWindow.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_time: Optional[builtins.str] = None,
                 start_time: Optional[builtins.str] = None):
        """
        :param builtins.str end_time: The time that the window ends. The end time must take place after the
               start time.
        :param builtins.str start_time: The time that the window first starts.
        """
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[builtins.str]:
        """
        The time that the window ends. The end time must take place after the
        start time.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[builtins.str]:
        """
        The time that the window first starts.
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class ClusterNetworking(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterIpv4CidrBlocks":
            suggest = "cluster_ipv4_cidr_blocks"
        elif key == "servicesIpv4CidrBlocks":
            suggest = "services_ipv4_cidr_blocks"
        elif key == "clusterIpv6CidrBlocks":
            suggest = "cluster_ipv6_cidr_blocks"
        elif key == "networkType":
            suggest = "network_type"
        elif key == "servicesIpv6CidrBlocks":
            suggest = "services_ipv6_cidr_blocks"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterNetworking. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterNetworking.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterNetworking.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_ipv4_cidr_blocks: Sequence[builtins.str],
                 services_ipv4_cidr_blocks: Sequence[builtins.str],
                 cluster_ipv6_cidr_blocks: Optional[Sequence[builtins.str]] = None,
                 network_type: Optional[builtins.str] = None,
                 services_ipv6_cidr_blocks: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence[builtins.str] cluster_ipv4_cidr_blocks: All pods in the cluster are assigned an RFC1918 IPv4 address from these
               blocks. Only a single block is supported. This field cannot be changed
               after creation.
        :param Sequence[builtins.str] services_ipv4_cidr_blocks: All services in the cluster are assigned an RFC1918 IPv4 address from these
               blocks. Only a single block is supported. This field cannot be changed
               after creation.
        :param Sequence[builtins.str] cluster_ipv6_cidr_blocks: If specified, dual stack mode is enabled and all pods in the cluster are
               assigned an IPv6 address from these blocks alongside from an IPv4
               address. Only a single block is supported. This field cannot be changed
               after creation.
        :param builtins.str network_type: (Output)
               IP addressing type of this cluster i.e. SINGLESTACK_V4 vs DUALSTACK_V4_V6.
        :param Sequence[builtins.str] services_ipv6_cidr_blocks: If specified, dual stack mode is enabled and all services in the cluster are
               assigned an IPv6 address from these blocks alongside from an IPv4
               address. Only a single block is supported. This field cannot be changed
               after creation.
        """
        pulumi.set(__self__, "cluster_ipv4_cidr_blocks", cluster_ipv4_cidr_blocks)
        pulumi.set(__self__, "services_ipv4_cidr_blocks", services_ipv4_cidr_blocks)
        if cluster_ipv6_cidr_blocks is not None:
            pulumi.set(__self__, "cluster_ipv6_cidr_blocks", cluster_ipv6_cidr_blocks)
        if network_type is not None:
            pulumi.set(__self__, "network_type", network_type)
        if services_ipv6_cidr_blocks is not None:
            pulumi.set(__self__, "services_ipv6_cidr_blocks", services_ipv6_cidr_blocks)

    @property
    @pulumi.getter(name="clusterIpv4CidrBlocks")
    def cluster_ipv4_cidr_blocks(self) -> Sequence[builtins.str]:
        """
        All pods in the cluster are assigned an RFC1918 IPv4 address from these
        blocks. Only a single block is supported. This field cannot be changed
        after creation.
        """
        return pulumi.get(self, "cluster_ipv4_cidr_blocks")

    @property
    @pulumi.getter(name="servicesIpv4CidrBlocks")
    def services_ipv4_cidr_blocks(self) -> Sequence[builtins.str]:
        """
        All services in the cluster are assigned an RFC1918 IPv4 address from these
        blocks. Only a single block is supported. This field cannot be changed
        after creation.
        """
        return pulumi.get(self, "services_ipv4_cidr_blocks")

    @property
    @pulumi.getter(name="clusterIpv6CidrBlocks")
    def cluster_ipv6_cidr_blocks(self) -> Optional[Sequence[builtins.str]]:
        """
        If specified, dual stack mode is enabled and all pods in the cluster are
        assigned an IPv6 address from these blocks alongside from an IPv4
        address. Only a single block is supported. This field cannot be changed
        after creation.
        """
        return pulumi.get(self, "cluster_ipv6_cidr_blocks")

    @property
    @pulumi.getter(name="networkType")
    def network_type(self) -> Optional[builtins.str]:
        """
        (Output)
        IP addressing type of this cluster i.e. SINGLESTACK_V4 vs DUALSTACK_V4_V6.
        """
        return pulumi.get(self, "network_type")

    @property
    @pulumi.getter(name="servicesIpv6CidrBlocks")
    def services_ipv6_cidr_blocks(self) -> Optional[Sequence[builtins.str]]:
        """
        If specified, dual stack mode is enabled and all services in the cluster are
        assigned an IPv6 address from these blocks alongside from an IPv4
        address. Only a single block is supported. This field cannot be changed
        after creation.
        """
        return pulumi.get(self, "services_ipv6_cidr_blocks")


@pulumi.output_type
class ClusterSystemAddonsConfig(dict):
    def __init__(__self__, *,
                 ingress: Optional['outputs.ClusterSystemAddonsConfigIngress'] = None):
        """
        :param 'ClusterSystemAddonsConfigIngressArgs' ingress: Config for the Ingress add-on which allows customers to create an Ingress
               object to manage external access to the servers in a cluster. The add-on
               consists of istiod and istio-ingress.
               Structure is documented below.
        """
        if ingress is not None:
            pulumi.set(__self__, "ingress", ingress)

    @property
    @pulumi.getter
    def ingress(self) -> Optional['outputs.ClusterSystemAddonsConfigIngress']:
        """
        Config for the Ingress add-on which allows customers to create an Ingress
        object to manage external access to the servers in a cluster. The add-on
        consists of istiod and istio-ingress.
        Structure is documented below.
        """
        return pulumi.get(self, "ingress")


@pulumi.output_type
class ClusterSystemAddonsConfigIngress(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipv4Vip":
            suggest = "ipv4_vip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterSystemAddonsConfigIngress. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterSystemAddonsConfigIngress.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterSystemAddonsConfigIngress.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disabled: Optional[builtins.bool] = None,
                 ipv4_vip: Optional[builtins.str] = None):
        """
        :param builtins.bool disabled: Whether Ingress is disabled.
        :param builtins.str ipv4_vip: Ingress VIP.
        """
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if ipv4_vip is not None:
            pulumi.set(__self__, "ipv4_vip", ipv4_vip)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[builtins.bool]:
        """
        Whether Ingress is disabled.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter(name="ipv4Vip")
    def ipv4_vip(self) -> Optional[builtins.str]:
        """
        Ingress VIP.
        """
        return pulumi.get(self, "ipv4_vip")


@pulumi.output_type
class NodePoolLocalDiskEncryption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKey":
            suggest = "kms_key"
        elif key == "kmsKeyActiveVersion":
            suggest = "kms_key_active_version"
        elif key == "kmsKeyState":
            suggest = "kms_key_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodePoolLocalDiskEncryption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodePoolLocalDiskEncryption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodePoolLocalDiskEncryption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key: Optional[builtins.str] = None,
                 kms_key_active_version: Optional[builtins.str] = None,
                 kms_key_state: Optional[builtins.str] = None):
        """
        :param builtins.str kms_key: The Cloud KMS CryptoKey e.g. projects/{project}/locations/{location}/keyRings/{keyRing}/cryptoKeys/{cryptoKey} to use for protecting node local disks.
               If not specified, a Google-managed key will be used instead.
        :param builtins.str kms_key_active_version: (Output)
               The Cloud KMS CryptoKeyVersion currently in use for protecting node local disks. Only applicable if kmsKey is set.
        :param builtins.str kms_key_state: (Output)
               Availability of the Cloud KMS CryptoKey. If not KEY_AVAILABLE, then nodes may go offline as they cannot access their local data.
               This can be caused by a lack of permissions to use the key, or if the key is disabled or deleted.
        """
        if kms_key is not None:
            pulumi.set(__self__, "kms_key", kms_key)
        if kms_key_active_version is not None:
            pulumi.set(__self__, "kms_key_active_version", kms_key_active_version)
        if kms_key_state is not None:
            pulumi.set(__self__, "kms_key_state", kms_key_state)

    @property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> Optional[builtins.str]:
        """
        The Cloud KMS CryptoKey e.g. projects/{project}/locations/{location}/keyRings/{keyRing}/cryptoKeys/{cryptoKey} to use for protecting node local disks.
        If not specified, a Google-managed key will be used instead.
        """
        return pulumi.get(self, "kms_key")

    @property
    @pulumi.getter(name="kmsKeyActiveVersion")
    def kms_key_active_version(self) -> Optional[builtins.str]:
        """
        (Output)
        The Cloud KMS CryptoKeyVersion currently in use for protecting node local disks. Only applicable if kmsKey is set.
        """
        return pulumi.get(self, "kms_key_active_version")

    @property
    @pulumi.getter(name="kmsKeyState")
    def kms_key_state(self) -> Optional[builtins.str]:
        """
        (Output)
        Availability of the Cloud KMS CryptoKey. If not KEY_AVAILABLE, then nodes may go offline as they cannot access their local data.
        This can be caused by a lack of permissions to use the key, or if the key is disabled or deleted.
        """
        return pulumi.get(self, "kms_key_state")


@pulumi.output_type
class NodePoolNodeConfig(dict):
    def __init__(__self__, *,
                 labels: Optional[Mapping[str, builtins.str]] = None):
        """
        :param Mapping[str, builtins.str] labels: "The Kubernetes node labels"
        """
        if labels is not None:
            pulumi.set(__self__, "labels", labels)

    @property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, builtins.str]]:
        """
        "The Kubernetes node labels"
        """
        return pulumi.get(self, "labels")


@pulumi.output_type
class VpnConnectionDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudRouters":
            suggest = "cloud_routers"
        elif key == "cloudVpns":
            suggest = "cloud_vpns"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VpnConnectionDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VpnConnectionDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VpnConnectionDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_routers: Optional[Sequence['outputs.VpnConnectionDetailCloudRouter']] = None,
                 cloud_vpns: Optional[Sequence['outputs.VpnConnectionDetailCloudVpn']] = None,
                 error: Optional[builtins.str] = None,
                 state: Optional[builtins.str] = None):
        """
        :param Sequence['VpnConnectionDetailCloudRouterArgs'] cloud_routers: (Output)
               The Cloud Router info.
               Structure is documented below.
        :param Sequence['VpnConnectionDetailCloudVpnArgs'] cloud_vpns: (Output)
               Each connection has multiple Cloud VPN gateways.
               Structure is documented below.
        :param builtins.str error: (Output)
               The error message. This is only populated when state=ERROR.
        :param builtins.str state: (Output)
               The current connection state.
        """
        if cloud_routers is not None:
            pulumi.set(__self__, "cloud_routers", cloud_routers)
        if cloud_vpns is not None:
            pulumi.set(__self__, "cloud_vpns", cloud_vpns)
        if error is not None:
            pulumi.set(__self__, "error", error)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="cloudRouters")
    def cloud_routers(self) -> Optional[Sequence['outputs.VpnConnectionDetailCloudRouter']]:
        """
        (Output)
        The Cloud Router info.
        Structure is documented below.
        """
        return pulumi.get(self, "cloud_routers")

    @property
    @pulumi.getter(name="cloudVpns")
    def cloud_vpns(self) -> Optional[Sequence['outputs.VpnConnectionDetailCloudVpn']]:
        """
        (Output)
        Each connection has multiple Cloud VPN gateways.
        Structure is documented below.
        """
        return pulumi.get(self, "cloud_vpns")

    @property
    @pulumi.getter
    def error(self) -> Optional[builtins.str]:
        """
        (Output)
        The error message. This is only populated when state=ERROR.
        """
        return pulumi.get(self, "error")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        (Output)
        The current connection state.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class VpnConnectionDetailCloudRouter(dict):
    def __init__(__self__, *,
                 name: Optional[builtins.str] = None):
        """
        :param builtins.str name: The resource name of VPN connection
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The resource name of VPN connection
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class VpnConnectionDetailCloudVpn(dict):
    def __init__(__self__, *,
                 gateway: Optional[builtins.str] = None):
        """
        :param builtins.str gateway: (Output)
               The created Cloud VPN gateway name.
        """
        if gateway is not None:
            pulumi.set(__self__, "gateway", gateway)

    @property
    @pulumi.getter
    def gateway(self) -> Optional[builtins.str]:
        """
        (Output)
        The created Cloud VPN gateway name.
        """
        return pulumi.get(self, "gateway")


@pulumi.output_type
class VpnConnectionVpcProject(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "projectId":
            suggest = "project_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VpnConnectionVpcProject. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VpnConnectionVpcProject.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VpnConnectionVpcProject.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 project_id: Optional[builtins.str] = None):
        """
        :param builtins.str project_id: The project of the VPC to connect to. If not specified, it is the same as the cluster project.
        """
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[builtins.str]:
        """
        The project of the VPC to connect to. If not specified, it is the same as the cluster project.
        """
        return pulumi.get(self, "project_id")


