# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GoogleApiSourceLoggingConfigArgs',
    'GoogleApiSourceLoggingConfigArgsDict',
    'MessageBusLoggingConfigArgs',
    'MessageBusLoggingConfigArgsDict',
    'PipelineDestinationArgs',
    'PipelineDestinationArgsDict',
    'PipelineDestinationAuthenticationConfigArgs',
    'PipelineDestinationAuthenticationConfigArgsDict',
    'PipelineDestinationAuthenticationConfigGoogleOidcArgs',
    'PipelineDestinationAuthenticationConfigGoogleOidcArgsDict',
    'PipelineDestinationAuthenticationConfigOauthTokenArgs',
    'PipelineDestinationAuthenticationConfigOauthTokenArgsDict',
    'PipelineDestinationHttpEndpointArgs',
    'PipelineDestinationHttpEndpointArgsDict',
    'PipelineDestinationNetworkConfigArgs',
    'PipelineDestinationNetworkConfigArgsDict',
    'PipelineDestinationOutputPayloadFormatArgs',
    'PipelineDestinationOutputPayloadFormatArgsDict',
    'PipelineDestinationOutputPayloadFormatAvroArgs',
    'PipelineDestinationOutputPayloadFormatAvroArgsDict',
    'PipelineDestinationOutputPayloadFormatJsonArgs',
    'PipelineDestinationOutputPayloadFormatJsonArgsDict',
    'PipelineDestinationOutputPayloadFormatProtobufArgs',
    'PipelineDestinationOutputPayloadFormatProtobufArgsDict',
    'PipelineInputPayloadFormatArgs',
    'PipelineInputPayloadFormatArgsDict',
    'PipelineInputPayloadFormatAvroArgs',
    'PipelineInputPayloadFormatAvroArgsDict',
    'PipelineInputPayloadFormatJsonArgs',
    'PipelineInputPayloadFormatJsonArgsDict',
    'PipelineInputPayloadFormatProtobufArgs',
    'PipelineInputPayloadFormatProtobufArgsDict',
    'PipelineLoggingConfigArgs',
    'PipelineLoggingConfigArgsDict',
    'PipelineMediationArgs',
    'PipelineMediationArgsDict',
    'PipelineMediationTransformationArgs',
    'PipelineMediationTransformationArgsDict',
    'PipelineRetryPolicyArgs',
    'PipelineRetryPolicyArgsDict',
    'TriggerDestinationArgs',
    'TriggerDestinationArgsDict',
    'TriggerDestinationCloudRunServiceArgs',
    'TriggerDestinationCloudRunServiceArgsDict',
    'TriggerDestinationGkeArgs',
    'TriggerDestinationGkeArgsDict',
    'TriggerDestinationHttpEndpointArgs',
    'TriggerDestinationHttpEndpointArgsDict',
    'TriggerDestinationNetworkConfigArgs',
    'TriggerDestinationNetworkConfigArgsDict',
    'TriggerMatchingCriteriaArgs',
    'TriggerMatchingCriteriaArgsDict',
    'TriggerTransportArgs',
    'TriggerTransportArgsDict',
    'TriggerTransportPubsubArgs',
    'TriggerTransportPubsubArgsDict',
]

MYPY = False

if not MYPY:
    class GoogleApiSourceLoggingConfigArgsDict(TypedDict):
        log_severity: NotRequired[pulumi.Input[builtins.str]]
        """
        The minimum severity of logs that will be sent to Stackdriver/Platform
        Telemetry. Logs at severitiy ≥ this value will be sent, unless it is NONE.
        Possible values are: `NONE`, `DEBUG`, `INFO`, `NOTICE`, `WARNING`, `ERROR`, `CRITICAL`, `ALERT`, `EMERGENCY`.
        """
elif False:
    GoogleApiSourceLoggingConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GoogleApiSourceLoggingConfigArgs:
    def __init__(__self__, *,
                 log_severity: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] log_severity: The minimum severity of logs that will be sent to Stackdriver/Platform
               Telemetry. Logs at severitiy ≥ this value will be sent, unless it is NONE.
               Possible values are: `NONE`, `DEBUG`, `INFO`, `NOTICE`, `WARNING`, `ERROR`, `CRITICAL`, `ALERT`, `EMERGENCY`.
        """
        if log_severity is not None:
            pulumi.set(__self__, "log_severity", log_severity)

    @property
    @pulumi.getter(name="logSeverity")
    def log_severity(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The minimum severity of logs that will be sent to Stackdriver/Platform
        Telemetry. Logs at severitiy ≥ this value will be sent, unless it is NONE.
        Possible values are: `NONE`, `DEBUG`, `INFO`, `NOTICE`, `WARNING`, `ERROR`, `CRITICAL`, `ALERT`, `EMERGENCY`.
        """
        return pulumi.get(self, "log_severity")

    @log_severity.setter
    def log_severity(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "log_severity", value)


if not MYPY:
    class MessageBusLoggingConfigArgsDict(TypedDict):
        log_severity: NotRequired[pulumi.Input[builtins.str]]
        """
        Optional. The minimum severity of logs that will be sent to Stackdriver/Platform
        Telemetry. Logs at severitiy ≥ this value will be sent, unless it is NONE.
        Possible values are: `NONE`, `DEBUG`, `INFO`, `NOTICE`, `WARNING`, `ERROR`, `CRITICAL`, `ALERT`, `EMERGENCY`.
        """
elif False:
    MessageBusLoggingConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MessageBusLoggingConfigArgs:
    def __init__(__self__, *,
                 log_severity: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] log_severity: Optional. The minimum severity of logs that will be sent to Stackdriver/Platform
               Telemetry. Logs at severitiy ≥ this value will be sent, unless it is NONE.
               Possible values are: `NONE`, `DEBUG`, `INFO`, `NOTICE`, `WARNING`, `ERROR`, `CRITICAL`, `ALERT`, `EMERGENCY`.
        """
        if log_severity is not None:
            pulumi.set(__self__, "log_severity", log_severity)

    @property
    @pulumi.getter(name="logSeverity")
    def log_severity(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional. The minimum severity of logs that will be sent to Stackdriver/Platform
        Telemetry. Logs at severitiy ≥ this value will be sent, unless it is NONE.
        Possible values are: `NONE`, `DEBUG`, `INFO`, `NOTICE`, `WARNING`, `ERROR`, `CRITICAL`, `ALERT`, `EMERGENCY`.
        """
        return pulumi.get(self, "log_severity")

    @log_severity.setter
    def log_severity(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "log_severity", value)


if not MYPY:
    class PipelineDestinationArgsDict(TypedDict):
        authentication_config: NotRequired[pulumi.Input['PipelineDestinationAuthenticationConfigArgsDict']]
        """
        Represents a config used to authenticate message requests.
        Structure is documented below.
        """
        http_endpoint: NotRequired[pulumi.Input['PipelineDestinationHttpEndpointArgsDict']]
        """
        Represents a HTTP endpoint destination.
        Structure is documented below.
        """
        message_bus: NotRequired[pulumi.Input[builtins.str]]
        """
        The resource name of the Message Bus to which events should be
        published. The Message Bus resource should exist in the same project as
        the Pipeline. Format:
        `projects/{project}/locations/{location}/messageBuses/{message_bus}`
        """
        network_config: NotRequired[pulumi.Input['PipelineDestinationNetworkConfigArgsDict']]
        """
        Represents a network config to be used for destination resolution and
        connectivity.
        Structure is documented below.
        """
        output_payload_format: NotRequired[pulumi.Input['PipelineDestinationOutputPayloadFormatArgsDict']]
        """
        Represents the format of message data.
        Structure is documented below.
        """
        topic: NotRequired[pulumi.Input[builtins.str]]
        """
        The resource name of the Pub/Sub topic to which events should be
        published. Format:
        `projects/{project}/locations/{location}/topics/{topic}`
        """
        workflow: NotRequired[pulumi.Input[builtins.str]]
        """
        The resource name of the Workflow whose Executions are triggered by
        the events. The Workflow resource should be deployed in the same
        project as the Pipeline. Format:
        `projects/{project}/locations/{location}/workflows/{workflow}`
        """
elif False:
    PipelineDestinationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PipelineDestinationArgs:
    def __init__(__self__, *,
                 authentication_config: Optional[pulumi.Input['PipelineDestinationAuthenticationConfigArgs']] = None,
                 http_endpoint: Optional[pulumi.Input['PipelineDestinationHttpEndpointArgs']] = None,
                 message_bus: Optional[pulumi.Input[builtins.str]] = None,
                 network_config: Optional[pulumi.Input['PipelineDestinationNetworkConfigArgs']] = None,
                 output_payload_format: Optional[pulumi.Input['PipelineDestinationOutputPayloadFormatArgs']] = None,
                 topic: Optional[pulumi.Input[builtins.str]] = None,
                 workflow: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input['PipelineDestinationAuthenticationConfigArgs'] authentication_config: Represents a config used to authenticate message requests.
               Structure is documented below.
        :param pulumi.Input['PipelineDestinationHttpEndpointArgs'] http_endpoint: Represents a HTTP endpoint destination.
               Structure is documented below.
        :param pulumi.Input[builtins.str] message_bus: The resource name of the Message Bus to which events should be
               published. The Message Bus resource should exist in the same project as
               the Pipeline. Format:
               `projects/{project}/locations/{location}/messageBuses/{message_bus}`
        :param pulumi.Input['PipelineDestinationNetworkConfigArgs'] network_config: Represents a network config to be used for destination resolution and
               connectivity.
               Structure is documented below.
        :param pulumi.Input['PipelineDestinationOutputPayloadFormatArgs'] output_payload_format: Represents the format of message data.
               Structure is documented below.
        :param pulumi.Input[builtins.str] topic: The resource name of the Pub/Sub topic to which events should be
               published. Format:
               `projects/{project}/locations/{location}/topics/{topic}`
        :param pulumi.Input[builtins.str] workflow: The resource name of the Workflow whose Executions are triggered by
               the events. The Workflow resource should be deployed in the same
               project as the Pipeline. Format:
               `projects/{project}/locations/{location}/workflows/{workflow}`
        """
        if authentication_config is not None:
            pulumi.set(__self__, "authentication_config", authentication_config)
        if http_endpoint is not None:
            pulumi.set(__self__, "http_endpoint", http_endpoint)
        if message_bus is not None:
            pulumi.set(__self__, "message_bus", message_bus)
        if network_config is not None:
            pulumi.set(__self__, "network_config", network_config)
        if output_payload_format is not None:
            pulumi.set(__self__, "output_payload_format", output_payload_format)
        if topic is not None:
            pulumi.set(__self__, "topic", topic)
        if workflow is not None:
            pulumi.set(__self__, "workflow", workflow)

    @property
    @pulumi.getter(name="authenticationConfig")
    def authentication_config(self) -> Optional[pulumi.Input['PipelineDestinationAuthenticationConfigArgs']]:
        """
        Represents a config used to authenticate message requests.
        Structure is documented below.
        """
        return pulumi.get(self, "authentication_config")

    @authentication_config.setter
    def authentication_config(self, value: Optional[pulumi.Input['PipelineDestinationAuthenticationConfigArgs']]):
        pulumi.set(self, "authentication_config", value)

    @property
    @pulumi.getter(name="httpEndpoint")
    def http_endpoint(self) -> Optional[pulumi.Input['PipelineDestinationHttpEndpointArgs']]:
        """
        Represents a HTTP endpoint destination.
        Structure is documented below.
        """
        return pulumi.get(self, "http_endpoint")

    @http_endpoint.setter
    def http_endpoint(self, value: Optional[pulumi.Input['PipelineDestinationHttpEndpointArgs']]):
        pulumi.set(self, "http_endpoint", value)

    @property
    @pulumi.getter(name="messageBus")
    def message_bus(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource name of the Message Bus to which events should be
        published. The Message Bus resource should exist in the same project as
        the Pipeline. Format:
        `projects/{project}/locations/{location}/messageBuses/{message_bus}`
        """
        return pulumi.get(self, "message_bus")

    @message_bus.setter
    def message_bus(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "message_bus", value)

    @property
    @pulumi.getter(name="networkConfig")
    def network_config(self) -> Optional[pulumi.Input['PipelineDestinationNetworkConfigArgs']]:
        """
        Represents a network config to be used for destination resolution and
        connectivity.
        Structure is documented below.
        """
        return pulumi.get(self, "network_config")

    @network_config.setter
    def network_config(self, value: Optional[pulumi.Input['PipelineDestinationNetworkConfigArgs']]):
        pulumi.set(self, "network_config", value)

    @property
    @pulumi.getter(name="outputPayloadFormat")
    def output_payload_format(self) -> Optional[pulumi.Input['PipelineDestinationOutputPayloadFormatArgs']]:
        """
        Represents the format of message data.
        Structure is documented below.
        """
        return pulumi.get(self, "output_payload_format")

    @output_payload_format.setter
    def output_payload_format(self, value: Optional[pulumi.Input['PipelineDestinationOutputPayloadFormatArgs']]):
        pulumi.set(self, "output_payload_format", value)

    @property
    @pulumi.getter
    def topic(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource name of the Pub/Sub topic to which events should be
        published. Format:
        `projects/{project}/locations/{location}/topics/{topic}`
        """
        return pulumi.get(self, "topic")

    @topic.setter
    def topic(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "topic", value)

    @property
    @pulumi.getter
    def workflow(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource name of the Workflow whose Executions are triggered by
        the events. The Workflow resource should be deployed in the same
        project as the Pipeline. Format:
        `projects/{project}/locations/{location}/workflows/{workflow}`
        """
        return pulumi.get(self, "workflow")

    @workflow.setter
    def workflow(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "workflow", value)


if not MYPY:
    class PipelineDestinationAuthenticationConfigArgsDict(TypedDict):
        google_oidc: NotRequired[pulumi.Input['PipelineDestinationAuthenticationConfigGoogleOidcArgsDict']]
        """
        Represents a config used to authenticate with a Google OIDC token using
        a GCP service account. Use this authentication method to invoke your
        Cloud Run and Cloud Functions destinations or HTTP endpoints that
        support Google OIDC.
        Structure is documented below.
        """
        oauth_token: NotRequired[pulumi.Input['PipelineDestinationAuthenticationConfigOauthTokenArgsDict']]
        """
        Contains information needed for generating an
        [OAuth token](https://developers.google.com/identity/protocols/OAuth2).
        This type of authorization should generally only be used when calling
        Google APIs hosted on *.googleapis.com.
        Structure is documented below.
        """
elif False:
    PipelineDestinationAuthenticationConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PipelineDestinationAuthenticationConfigArgs:
    def __init__(__self__, *,
                 google_oidc: Optional[pulumi.Input['PipelineDestinationAuthenticationConfigGoogleOidcArgs']] = None,
                 oauth_token: Optional[pulumi.Input['PipelineDestinationAuthenticationConfigOauthTokenArgs']] = None):
        """
        :param pulumi.Input['PipelineDestinationAuthenticationConfigGoogleOidcArgs'] google_oidc: Represents a config used to authenticate with a Google OIDC token using
               a GCP service account. Use this authentication method to invoke your
               Cloud Run and Cloud Functions destinations or HTTP endpoints that
               support Google OIDC.
               Structure is documented below.
        :param pulumi.Input['PipelineDestinationAuthenticationConfigOauthTokenArgs'] oauth_token: Contains information needed for generating an
               [OAuth token](https://developers.google.com/identity/protocols/OAuth2).
               This type of authorization should generally only be used when calling
               Google APIs hosted on *.googleapis.com.
               Structure is documented below.
        """
        if google_oidc is not None:
            pulumi.set(__self__, "google_oidc", google_oidc)
        if oauth_token is not None:
            pulumi.set(__self__, "oauth_token", oauth_token)

    @property
    @pulumi.getter(name="googleOidc")
    def google_oidc(self) -> Optional[pulumi.Input['PipelineDestinationAuthenticationConfigGoogleOidcArgs']]:
        """
        Represents a config used to authenticate with a Google OIDC token using
        a GCP service account. Use this authentication method to invoke your
        Cloud Run and Cloud Functions destinations or HTTP endpoints that
        support Google OIDC.
        Structure is documented below.
        """
        return pulumi.get(self, "google_oidc")

    @google_oidc.setter
    def google_oidc(self, value: Optional[pulumi.Input['PipelineDestinationAuthenticationConfigGoogleOidcArgs']]):
        pulumi.set(self, "google_oidc", value)

    @property
    @pulumi.getter(name="oauthToken")
    def oauth_token(self) -> Optional[pulumi.Input['PipelineDestinationAuthenticationConfigOauthTokenArgs']]:
        """
        Contains information needed for generating an
        [OAuth token](https://developers.google.com/identity/protocols/OAuth2).
        This type of authorization should generally only be used when calling
        Google APIs hosted on *.googleapis.com.
        Structure is documented below.
        """
        return pulumi.get(self, "oauth_token")

    @oauth_token.setter
    def oauth_token(self, value: Optional[pulumi.Input['PipelineDestinationAuthenticationConfigOauthTokenArgs']]):
        pulumi.set(self, "oauth_token", value)


if not MYPY:
    class PipelineDestinationAuthenticationConfigGoogleOidcArgsDict(TypedDict):
        service_account: pulumi.Input[builtins.str]
        """
        Service account email used to generate the OIDC Token.
        The principal who calls this API must have
        iam.serviceAccounts.actAs permission in the service account. See
        https://cloud.google.com/iam/docs/understanding-service-accounts
        for more information. Eventarc service agents must have
        roles/roles/iam.serviceAccountTokenCreator role to allow the
        Pipeline to create OpenID tokens for authenticated requests.
        """
        audience: NotRequired[pulumi.Input[builtins.str]]
        """
        Audience to be used to generate the OIDC Token. The audience claim
        identifies the recipient that the JWT is intended for. If
        unspecified, the destination URI will be used.
        """
elif False:
    PipelineDestinationAuthenticationConfigGoogleOidcArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PipelineDestinationAuthenticationConfigGoogleOidcArgs:
    def __init__(__self__, *,
                 service_account: pulumi.Input[builtins.str],
                 audience: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] service_account: Service account email used to generate the OIDC Token.
               The principal who calls this API must have
               iam.serviceAccounts.actAs permission in the service account. See
               https://cloud.google.com/iam/docs/understanding-service-accounts
               for more information. Eventarc service agents must have
               roles/roles/iam.serviceAccountTokenCreator role to allow the
               Pipeline to create OpenID tokens for authenticated requests.
        :param pulumi.Input[builtins.str] audience: Audience to be used to generate the OIDC Token. The audience claim
               identifies the recipient that the JWT is intended for. If
               unspecified, the destination URI will be used.
        """
        pulumi.set(__self__, "service_account", service_account)
        if audience is not None:
            pulumi.set(__self__, "audience", audience)

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> pulumi.Input[builtins.str]:
        """
        Service account email used to generate the OIDC Token.
        The principal who calls this API must have
        iam.serviceAccounts.actAs permission in the service account. See
        https://cloud.google.com/iam/docs/understanding-service-accounts
        for more information. Eventarc service agents must have
        roles/roles/iam.serviceAccountTokenCreator role to allow the
        Pipeline to create OpenID tokens for authenticated requests.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "service_account", value)

    @property
    @pulumi.getter
    def audience(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Audience to be used to generate the OIDC Token. The audience claim
        identifies the recipient that the JWT is intended for. If
        unspecified, the destination URI will be used.
        """
        return pulumi.get(self, "audience")

    @audience.setter
    def audience(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "audience", value)


if not MYPY:
    class PipelineDestinationAuthenticationConfigOauthTokenArgsDict(TypedDict):
        service_account: pulumi.Input[builtins.str]
        """
        Service account email used to generate the [OAuth
        token](https://developers.google.com/identity/protocols/OAuth2).
        The principal who calls this API must have
        iam.serviceAccounts.actAs permission in the service account. See
        https://cloud.google.com/iam/docs/understanding-service-accounts
        for more information. Eventarc service agents must have
        roles/roles/iam.serviceAccountTokenCreator role to allow Pipeline
        to create OAuth2 tokens for authenticated requests.
        """
        scope: NotRequired[pulumi.Input[builtins.str]]
        """
        OAuth scope to be used for generating OAuth access token. If not
        specified, "https://www.googleapis.com/auth/cloud-platform" will be
        used.
        """
elif False:
    PipelineDestinationAuthenticationConfigOauthTokenArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PipelineDestinationAuthenticationConfigOauthTokenArgs:
    def __init__(__self__, *,
                 service_account: pulumi.Input[builtins.str],
                 scope: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] service_account: Service account email used to generate the [OAuth
               token](https://developers.google.com/identity/protocols/OAuth2).
               The principal who calls this API must have
               iam.serviceAccounts.actAs permission in the service account. See
               https://cloud.google.com/iam/docs/understanding-service-accounts
               for more information. Eventarc service agents must have
               roles/roles/iam.serviceAccountTokenCreator role to allow Pipeline
               to create OAuth2 tokens for authenticated requests.
        :param pulumi.Input[builtins.str] scope: OAuth scope to be used for generating OAuth access token. If not
               specified, "https://www.googleapis.com/auth/cloud-platform" will be
               used.
        """
        pulumi.set(__self__, "service_account", service_account)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> pulumi.Input[builtins.str]:
        """
        Service account email used to generate the [OAuth
        token](https://developers.google.com/identity/protocols/OAuth2).
        The principal who calls this API must have
        iam.serviceAccounts.actAs permission in the service account. See
        https://cloud.google.com/iam/docs/understanding-service-accounts
        for more information. Eventarc service agents must have
        roles/roles/iam.serviceAccountTokenCreator role to allow Pipeline
        to create OAuth2 tokens for authenticated requests.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "service_account", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        OAuth scope to be used for generating OAuth access token. If not
        specified, "https://www.googleapis.com/auth/cloud-platform" will be
        used.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "scope", value)


if not MYPY:
    class PipelineDestinationHttpEndpointArgsDict(TypedDict):
        uri: pulumi.Input[builtins.str]
        """
        The URI of the HTTP enpdoint.
        The value must be a RFC2396 URI string.
        Examples: `https://svc.us-central1.p.local:8080/route`.
        Only the HTTPS protocol is supported.
        """
        message_binding_template: NotRequired[pulumi.Input[builtins.str]]
        """
        The CEL expression used to modify how the destination-bound HTTP
        request is constructed.
        If a binding expression is not specified here, the message
        is treated as a CloudEvent and is mapped to the HTTP request according
        to the CloudEvent HTTP Protocol Binding Binary Content Mode
        (https://github.com/cloudevents/spec/blob/main/cloudevents/bindings/http-protocol-binding.md#31-binary-content-mode).
        In this representation, all fields except the `data` and
        `datacontenttype` field on the message are mapped to HTTP request
        headers with a prefix of `ce-`.
        To construct the HTTP request payload and the value of the content-type
        HTTP header, the payload format is defined as follows:
        1) Use the output_payload_format_type on the Pipeline.Destination if it
        is set, else:
        2) Use the input_payload_format_type on the Pipeline if it is set,
        else:
        3) Treat the payload as opaque binary data.
        The `data` field of the message is converted to the payload format or
        left as-is for case 3) and then attached as the payload of the HTTP
        request. The `content-type` header on the HTTP request is set to the
        payload format type or left empty for case 3). However, if a mediation
        has updated the `datacontenttype` field on the message so that it is
        not the same as the payload format type but it is still a prefix of the
        payload format type, then the `content-type` header on the HTTP request
        is set to this `datacontenttype` value. For example, if the
        `datacontenttype` is "application/json" and the payload format type is
        "application/json; charset=utf-8", then the `content-type` header on
        the HTTP request is set to "application/json; charset=utf-8".
        If a non-empty binding expression is specified then this expression is
        used to modify the default CloudEvent HTTP Protocol Binding Binary
        Content representation.
        The result of the CEL expression must be a map of key/value pairs
        which is used as follows:
        - If a map named `headers` exists on the result of the expression,
        then its key/value pairs are directly mapped to the HTTP request
        headers. The headers values are constructed from the corresponding
        value type's canonical representation. If the `headers` field doesn't
        exist then the resulting HTTP request will be the headers of the
        CloudEvent HTTP Binding Binary Content Mode representation of the final
        message. Note: If the specified binding expression, has updated the
        `datacontenttype` field on the message so that it is not the same as
        the payload format type but it is still a prefix of the payload format
        type, then the `content-type` header in the `headers` map is set to
        this `datacontenttype` value.
        - If a field named `body` exists on the result of the expression then
        its value is directly mapped to the body of the request. If the value
        of the `body` field is of type bytes or string then it is used for
        the HTTP request body as-is, with no conversion. If the body field is
        of any other type then it is converted to a JSON string. If the body
        field does not exist then the resulting payload of the HTTP request
        will be data value of the CloudEvent HTTP Binding Binary Content Mode
        representation of the final message as described earlier.
        - Any other fields in the resulting expression will be ignored.
        The CEL expression may access the incoming CloudEvent message in its
        definition, as follows:
        - The `data` field of the incoming CloudEvent message can be accessed
        using the `message.data` value. Subfields of `message.data` may also be
        accessed if an input_payload_format has been specified on the Pipeline.
        - Each attribute of the incoming CloudEvent message can be accessed
        using the `message.` value, where  is replaced with the
        name of the attribute.
        - Existing headers can be accessed in the CEL expression using the
        `headers` variable. The `headers` variable defines a map of key/value
        pairs corresponding to the HTTP headers of the CloudEvent HTTP Binding
        Binary Content Mode representation of the final message as described
        earlier. For example, the following CEL expression can be used to
        construct an HTTP request by adding an additional header to the HTTP
        headers of the CloudEvent HTTP Binding Binary Content Mode
        representation of the final message and by overwriting the body of the
        request:
        ```
        {
        "headers": headers.merge({"new-header-key": "new-header-value"}),
        "body": "new-body"
        }
        ```
        - The default binding for the message payload can be accessed using the
        `body` variable. It conatins a string representation of the message
        payload in the format specified by the `output_payload_format` field.
        If the `input_payload_format` field is not set, the `body`
        variable contains the same message payload bytes that were published.
        Additionally, the following CEL extension functions are provided for
        use in this CEL expression:
        - toBase64Url:
        map.toBase64Url() > string
        - Converts a CelValue to a base64url encoded string
        - toJsonString: map.toJsonString() > string
        - Converts a CelValue to a JSON string
        - merge:
        map1.merge(map2) > map3
        - Merges the passed CEL map with the existing CEL map the
        function is applied to.
        - If the same key exists in both maps, if the key's value is type
        map both maps are merged else the value from the passed map is
        used.
        - denormalize:
        map.denormalize() > map
        - Denormalizes a CEL map such that every value of type map or key
        in the map is expanded to return a single level map.
        - The resulting keys are "." separated indices of the map keys.
        - For example:
        {
        "a": 1,
        "b": {
        "c": 2,
        "d": 3
        }
        "e": [4, 5]
        }
        .denormalize()
        > {
        "a": 1,
        "b.c": 2,
        "b.d": 3,
        "e.0": 4,
        "e.1": 5
        }
        - setField:
        map.setField(key, value) > message
        - Sets the field of the message with the given key to the
        given value.
        - If the field is not present it will be added.
        - If the field is present it will be overwritten.
        - The key can be a dot separated path to set a field in a nested
        message.
        - Key must be of type string.
        - Value may be any valid type.
        - removeFields:
        map.removeFields([key1, key2, ...]) > message
        - Removes the fields of the map with the given keys.
        - The keys can be a dot separated path to remove a field in a
        nested message.
        - If a key is not found it will be ignored.
        - Keys must be of type string.
        - toMap:
        [map1, map2, ...].toMap() > map
        - Converts a CEL list of CEL maps to a single CEL map
        - toCloudEventJsonWithPayloadFormat:
        message.toCloudEventJsonWithPayloadFormat() > map
        - Converts a message to the corresponding structure of JSON
        format for CloudEvents.
        - It converts `data` to destination payload format
        specified in `output_payload_format`. If `output_payload_format` is
        not set, the data will remain unchanged.
        - It also sets the corresponding datacontenttype of
        the CloudEvent, as indicated by
        `output_payload_format`. If no
        `output_payload_format` is set it will use the value of the
        "datacontenttype" attribute on the CloudEvent if present, else
        remove "datacontenttype" attribute.
        - This function expects that the content of the message will
        adhere to the standard CloudEvent format. If it doesn't then this
        function will fail.
        - The result is a CEL map that corresponds to the JSON
        representation of the CloudEvent. To convert that data to a JSON
        string it can be chained with the toJsonString function.
        The Pipeline expects that the message it receives adheres to the
        standard CloudEvent format. If it doesn't then the outgoing message
        request may fail with a persistent error.

        - - -
        """
elif False:
    PipelineDestinationHttpEndpointArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PipelineDestinationHttpEndpointArgs:
    def __init__(__self__, *,
                 uri: pulumi.Input[builtins.str],
                 message_binding_template: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] uri: The URI of the HTTP enpdoint.
               The value must be a RFC2396 URI string.
               Examples: `https://svc.us-central1.p.local:8080/route`.
               Only the HTTPS protocol is supported.
        :param pulumi.Input[builtins.str] message_binding_template: The CEL expression used to modify how the destination-bound HTTP
               request is constructed.
               If a binding expression is not specified here, the message
               is treated as a CloudEvent and is mapped to the HTTP request according
               to the CloudEvent HTTP Protocol Binding Binary Content Mode
               (https://github.com/cloudevents/spec/blob/main/cloudevents/bindings/http-protocol-binding.md#31-binary-content-mode).
               In this representation, all fields except the `data` and
               `datacontenttype` field on the message are mapped to HTTP request
               headers with a prefix of `ce-`.
               To construct the HTTP request payload and the value of the content-type
               HTTP header, the payload format is defined as follows:
               1) Use the output_payload_format_type on the Pipeline.Destination if it
               is set, else:
               2) Use the input_payload_format_type on the Pipeline if it is set,
               else:
               3) Treat the payload as opaque binary data.
               The `data` field of the message is converted to the payload format or
               left as-is for case 3) and then attached as the payload of the HTTP
               request. The `content-type` header on the HTTP request is set to the
               payload format type or left empty for case 3). However, if a mediation
               has updated the `datacontenttype` field on the message so that it is
               not the same as the payload format type but it is still a prefix of the
               payload format type, then the `content-type` header on the HTTP request
               is set to this `datacontenttype` value. For example, if the
               `datacontenttype` is "application/json" and the payload format type is
               "application/json; charset=utf-8", then the `content-type` header on
               the HTTP request is set to "application/json; charset=utf-8".
               If a non-empty binding expression is specified then this expression is
               used to modify the default CloudEvent HTTP Protocol Binding Binary
               Content representation.
               The result of the CEL expression must be a map of key/value pairs
               which is used as follows:
               - If a map named `headers` exists on the result of the expression,
               then its key/value pairs are directly mapped to the HTTP request
               headers. The headers values are constructed from the corresponding
               value type's canonical representation. If the `headers` field doesn't
               exist then the resulting HTTP request will be the headers of the
               CloudEvent HTTP Binding Binary Content Mode representation of the final
               message. Note: If the specified binding expression, has updated the
               `datacontenttype` field on the message so that it is not the same as
               the payload format type but it is still a prefix of the payload format
               type, then the `content-type` header in the `headers` map is set to
               this `datacontenttype` value.
               - If a field named `body` exists on the result of the expression then
               its value is directly mapped to the body of the request. If the value
               of the `body` field is of type bytes or string then it is used for
               the HTTP request body as-is, with no conversion. If the body field is
               of any other type then it is converted to a JSON string. If the body
               field does not exist then the resulting payload of the HTTP request
               will be data value of the CloudEvent HTTP Binding Binary Content Mode
               representation of the final message as described earlier.
               - Any other fields in the resulting expression will be ignored.
               The CEL expression may access the incoming CloudEvent message in its
               definition, as follows:
               - The `data` field of the incoming CloudEvent message can be accessed
               using the `message.data` value. Subfields of `message.data` may also be
               accessed if an input_payload_format has been specified on the Pipeline.
               - Each attribute of the incoming CloudEvent message can be accessed
               using the `message.` value, where  is replaced with the
               name of the attribute.
               - Existing headers can be accessed in the CEL expression using the
               `headers` variable. The `headers` variable defines a map of key/value
               pairs corresponding to the HTTP headers of the CloudEvent HTTP Binding
               Binary Content Mode representation of the final message as described
               earlier. For example, the following CEL expression can be used to
               construct an HTTP request by adding an additional header to the HTTP
               headers of the CloudEvent HTTP Binding Binary Content Mode
               representation of the final message and by overwriting the body of the
               request:
               ```
               {
               "headers": headers.merge({"new-header-key": "new-header-value"}),
               "body": "new-body"
               }
               ```
               - The default binding for the message payload can be accessed using the
               `body` variable. It conatins a string representation of the message
               payload in the format specified by the `output_payload_format` field.
               If the `input_payload_format` field is not set, the `body`
               variable contains the same message payload bytes that were published.
               Additionally, the following CEL extension functions are provided for
               use in this CEL expression:
               - toBase64Url:
               map.toBase64Url() > string
               - Converts a CelValue to a base64url encoded string
               - toJsonString: map.toJsonString() > string
               - Converts a CelValue to a JSON string
               - merge:
               map1.merge(map2) > map3
               - Merges the passed CEL map with the existing CEL map the
               function is applied to.
               - If the same key exists in both maps, if the key's value is type
               map both maps are merged else the value from the passed map is
               used.
               - denormalize:
               map.denormalize() > map
               - Denormalizes a CEL map such that every value of type map or key
               in the map is expanded to return a single level map.
               - The resulting keys are "." separated indices of the map keys.
               - For example:
               {
               "a": 1,
               "b": {
               "c": 2,
               "d": 3
               }
               "e": [4, 5]
               }
               .denormalize()
               > {
               "a": 1,
               "b.c": 2,
               "b.d": 3,
               "e.0": 4,
               "e.1": 5
               }
               - setField:
               map.setField(key, value) > message
               - Sets the field of the message with the given key to the
               given value.
               - If the field is not present it will be added.
               - If the field is present it will be overwritten.
               - The key can be a dot separated path to set a field in a nested
               message.
               - Key must be of type string.
               - Value may be any valid type.
               - removeFields:
               map.removeFields([key1, key2, ...]) > message
               - Removes the fields of the map with the given keys.
               - The keys can be a dot separated path to remove a field in a
               nested message.
               - If a key is not found it will be ignored.
               - Keys must be of type string.
               - toMap:
               [map1, map2, ...].toMap() > map
               - Converts a CEL list of CEL maps to a single CEL map
               - toCloudEventJsonWithPayloadFormat:
               message.toCloudEventJsonWithPayloadFormat() > map
               - Converts a message to the corresponding structure of JSON
               format for CloudEvents.
               - It converts `data` to destination payload format
               specified in `output_payload_format`. If `output_payload_format` is
               not set, the data will remain unchanged.
               - It also sets the corresponding datacontenttype of
               the CloudEvent, as indicated by
               `output_payload_format`. If no
               `output_payload_format` is set it will use the value of the
               "datacontenttype" attribute on the CloudEvent if present, else
               remove "datacontenttype" attribute.
               - This function expects that the content of the message will
               adhere to the standard CloudEvent format. If it doesn't then this
               function will fail.
               - The result is a CEL map that corresponds to the JSON
               representation of the CloudEvent. To convert that data to a JSON
               string it can be chained with the toJsonString function.
               The Pipeline expects that the message it receives adheres to the
               standard CloudEvent format. If it doesn't then the outgoing message
               request may fail with a persistent error.
               
               - - -
        """
        pulumi.set(__self__, "uri", uri)
        if message_binding_template is not None:
            pulumi.set(__self__, "message_binding_template", message_binding_template)

    @property
    @pulumi.getter
    def uri(self) -> pulumi.Input[builtins.str]:
        """
        The URI of the HTTP enpdoint.
        The value must be a RFC2396 URI string.
        Examples: `https://svc.us-central1.p.local:8080/route`.
        Only the HTTPS protocol is supported.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "uri", value)

    @property
    @pulumi.getter(name="messageBindingTemplate")
    def message_binding_template(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The CEL expression used to modify how the destination-bound HTTP
        request is constructed.
        If a binding expression is not specified here, the message
        is treated as a CloudEvent and is mapped to the HTTP request according
        to the CloudEvent HTTP Protocol Binding Binary Content Mode
        (https://github.com/cloudevents/spec/blob/main/cloudevents/bindings/http-protocol-binding.md#31-binary-content-mode).
        In this representation, all fields except the `data` and
        `datacontenttype` field on the message are mapped to HTTP request
        headers with a prefix of `ce-`.
        To construct the HTTP request payload and the value of the content-type
        HTTP header, the payload format is defined as follows:
        1) Use the output_payload_format_type on the Pipeline.Destination if it
        is set, else:
        2) Use the input_payload_format_type on the Pipeline if it is set,
        else:
        3) Treat the payload as opaque binary data.
        The `data` field of the message is converted to the payload format or
        left as-is for case 3) and then attached as the payload of the HTTP
        request. The `content-type` header on the HTTP request is set to the
        payload format type or left empty for case 3). However, if a mediation
        has updated the `datacontenttype` field on the message so that it is
        not the same as the payload format type but it is still a prefix of the
        payload format type, then the `content-type` header on the HTTP request
        is set to this `datacontenttype` value. For example, if the
        `datacontenttype` is "application/json" and the payload format type is
        "application/json; charset=utf-8", then the `content-type` header on
        the HTTP request is set to "application/json; charset=utf-8".
        If a non-empty binding expression is specified then this expression is
        used to modify the default CloudEvent HTTP Protocol Binding Binary
        Content representation.
        The result of the CEL expression must be a map of key/value pairs
        which is used as follows:
        - If a map named `headers` exists on the result of the expression,
        then its key/value pairs are directly mapped to the HTTP request
        headers. The headers values are constructed from the corresponding
        value type's canonical representation. If the `headers` field doesn't
        exist then the resulting HTTP request will be the headers of the
        CloudEvent HTTP Binding Binary Content Mode representation of the final
        message. Note: If the specified binding expression, has updated the
        `datacontenttype` field on the message so that it is not the same as
        the payload format type but it is still a prefix of the payload format
        type, then the `content-type` header in the `headers` map is set to
        this `datacontenttype` value.
        - If a field named `body` exists on the result of the expression then
        its value is directly mapped to the body of the request. If the value
        of the `body` field is of type bytes or string then it is used for
        the HTTP request body as-is, with no conversion. If the body field is
        of any other type then it is converted to a JSON string. If the body
        field does not exist then the resulting payload of the HTTP request
        will be data value of the CloudEvent HTTP Binding Binary Content Mode
        representation of the final message as described earlier.
        - Any other fields in the resulting expression will be ignored.
        The CEL expression may access the incoming CloudEvent message in its
        definition, as follows:
        - The `data` field of the incoming CloudEvent message can be accessed
        using the `message.data` value. Subfields of `message.data` may also be
        accessed if an input_payload_format has been specified on the Pipeline.
        - Each attribute of the incoming CloudEvent message can be accessed
        using the `message.` value, where  is replaced with the
        name of the attribute.
        - Existing headers can be accessed in the CEL expression using the
        `headers` variable. The `headers` variable defines a map of key/value
        pairs corresponding to the HTTP headers of the CloudEvent HTTP Binding
        Binary Content Mode representation of the final message as described
        earlier. For example, the following CEL expression can be used to
        construct an HTTP request by adding an additional header to the HTTP
        headers of the CloudEvent HTTP Binding Binary Content Mode
        representation of the final message and by overwriting the body of the
        request:
        ```
        {
        "headers": headers.merge({"new-header-key": "new-header-value"}),
        "body": "new-body"
        }
        ```
        - The default binding for the message payload can be accessed using the
        `body` variable. It conatins a string representation of the message
        payload in the format specified by the `output_payload_format` field.
        If the `input_payload_format` field is not set, the `body`
        variable contains the same message payload bytes that were published.
        Additionally, the following CEL extension functions are provided for
        use in this CEL expression:
        - toBase64Url:
        map.toBase64Url() > string
        - Converts a CelValue to a base64url encoded string
        - toJsonString: map.toJsonString() > string
        - Converts a CelValue to a JSON string
        - merge:
        map1.merge(map2) > map3
        - Merges the passed CEL map with the existing CEL map the
        function is applied to.
        - If the same key exists in both maps, if the key's value is type
        map both maps are merged else the value from the passed map is
        used.
        - denormalize:
        map.denormalize() > map
        - Denormalizes a CEL map such that every value of type map or key
        in the map is expanded to return a single level map.
        - The resulting keys are "." separated indices of the map keys.
        - For example:
        {
        "a": 1,
        "b": {
        "c": 2,
        "d": 3
        }
        "e": [4, 5]
        }
        .denormalize()
        > {
        "a": 1,
        "b.c": 2,
        "b.d": 3,
        "e.0": 4,
        "e.1": 5
        }
        - setField:
        map.setField(key, value) > message
        - Sets the field of the message with the given key to the
        given value.
        - If the field is not present it will be added.
        - If the field is present it will be overwritten.
        - The key can be a dot separated path to set a field in a nested
        message.
        - Key must be of type string.
        - Value may be any valid type.
        - removeFields:
        map.removeFields([key1, key2, ...]) > message
        - Removes the fields of the map with the given keys.
        - The keys can be a dot separated path to remove a field in a
        nested message.
        - If a key is not found it will be ignored.
        - Keys must be of type string.
        - toMap:
        [map1, map2, ...].toMap() > map
        - Converts a CEL list of CEL maps to a single CEL map
        - toCloudEventJsonWithPayloadFormat:
        message.toCloudEventJsonWithPayloadFormat() > map
        - Converts a message to the corresponding structure of JSON
        format for CloudEvents.
        - It converts `data` to destination payload format
        specified in `output_payload_format`. If `output_payload_format` is
        not set, the data will remain unchanged.
        - It also sets the corresponding datacontenttype of
        the CloudEvent, as indicated by
        `output_payload_format`. If no
        `output_payload_format` is set it will use the value of the
        "datacontenttype" attribute on the CloudEvent if present, else
        remove "datacontenttype" attribute.
        - This function expects that the content of the message will
        adhere to the standard CloudEvent format. If it doesn't then this
        function will fail.
        - The result is a CEL map that corresponds to the JSON
        representation of the CloudEvent. To convert that data to a JSON
        string it can be chained with the toJsonString function.
        The Pipeline expects that the message it receives adheres to the
        standard CloudEvent format. If it doesn't then the outgoing message
        request may fail with a persistent error.

        - - -
        """
        return pulumi.get(self, "message_binding_template")

    @message_binding_template.setter
    def message_binding_template(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "message_binding_template", value)


if not MYPY:
    class PipelineDestinationNetworkConfigArgsDict(TypedDict):
        network_attachment: NotRequired[pulumi.Input[builtins.str]]
        """
        Name of the NetworkAttachment that allows access to the consumer VPC.
        Format:
        `projects/{PROJECT_ID}/regions/{REGION}/networkAttachments/{NETWORK_ATTACHMENT_NAME}`
        Required for HTTP endpoint destinations. Must not be specified for
        Workflows, MessageBus, or Topic destinations.
        """
elif False:
    PipelineDestinationNetworkConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PipelineDestinationNetworkConfigArgs:
    def __init__(__self__, *,
                 network_attachment: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] network_attachment: Name of the NetworkAttachment that allows access to the consumer VPC.
               Format:
               `projects/{PROJECT_ID}/regions/{REGION}/networkAttachments/{NETWORK_ATTACHMENT_NAME}`
               Required for HTTP endpoint destinations. Must not be specified for
               Workflows, MessageBus, or Topic destinations.
        """
        if network_attachment is not None:
            pulumi.set(__self__, "network_attachment", network_attachment)

    @property
    @pulumi.getter(name="networkAttachment")
    def network_attachment(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the NetworkAttachment that allows access to the consumer VPC.
        Format:
        `projects/{PROJECT_ID}/regions/{REGION}/networkAttachments/{NETWORK_ATTACHMENT_NAME}`
        Required for HTTP endpoint destinations. Must not be specified for
        Workflows, MessageBus, or Topic destinations.
        """
        return pulumi.get(self, "network_attachment")

    @network_attachment.setter
    def network_attachment(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network_attachment", value)


if not MYPY:
    class PipelineDestinationOutputPayloadFormatArgsDict(TypedDict):
        avro: NotRequired[pulumi.Input['PipelineDestinationOutputPayloadFormatAvroArgsDict']]
        """
        The format of an AVRO message payload.
        Structure is documented below.
        """
        json: NotRequired[pulumi.Input['PipelineDestinationOutputPayloadFormatJsonArgsDict']]
        """
        The format of a JSON message payload.
        """
        protobuf: NotRequired[pulumi.Input['PipelineDestinationOutputPayloadFormatProtobufArgsDict']]
        """
        The format of a Protobuf message payload.
        Structure is documented below.
        """
elif False:
    PipelineDestinationOutputPayloadFormatArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PipelineDestinationOutputPayloadFormatArgs:
    def __init__(__self__, *,
                 avro: Optional[pulumi.Input['PipelineDestinationOutputPayloadFormatAvroArgs']] = None,
                 json: Optional[pulumi.Input['PipelineDestinationOutputPayloadFormatJsonArgs']] = None,
                 protobuf: Optional[pulumi.Input['PipelineDestinationOutputPayloadFormatProtobufArgs']] = None):
        """
        :param pulumi.Input['PipelineDestinationOutputPayloadFormatAvroArgs'] avro: The format of an AVRO message payload.
               Structure is documented below.
        :param pulumi.Input['PipelineDestinationOutputPayloadFormatJsonArgs'] json: The format of a JSON message payload.
        :param pulumi.Input['PipelineDestinationOutputPayloadFormatProtobufArgs'] protobuf: The format of a Protobuf message payload.
               Structure is documented below.
        """
        if avro is not None:
            pulumi.set(__self__, "avro", avro)
        if json is not None:
            pulumi.set(__self__, "json", json)
        if protobuf is not None:
            pulumi.set(__self__, "protobuf", protobuf)

    @property
    @pulumi.getter
    def avro(self) -> Optional[pulumi.Input['PipelineDestinationOutputPayloadFormatAvroArgs']]:
        """
        The format of an AVRO message payload.
        Structure is documented below.
        """
        return pulumi.get(self, "avro")

    @avro.setter
    def avro(self, value: Optional[pulumi.Input['PipelineDestinationOutputPayloadFormatAvroArgs']]):
        pulumi.set(self, "avro", value)

    @property
    @pulumi.getter
    def json(self) -> Optional[pulumi.Input['PipelineDestinationOutputPayloadFormatJsonArgs']]:
        """
        The format of a JSON message payload.
        """
        return pulumi.get(self, "json")

    @json.setter
    def json(self, value: Optional[pulumi.Input['PipelineDestinationOutputPayloadFormatJsonArgs']]):
        pulumi.set(self, "json", value)

    @property
    @pulumi.getter
    def protobuf(self) -> Optional[pulumi.Input['PipelineDestinationOutputPayloadFormatProtobufArgs']]:
        """
        The format of a Protobuf message payload.
        Structure is documented below.
        """
        return pulumi.get(self, "protobuf")

    @protobuf.setter
    def protobuf(self, value: Optional[pulumi.Input['PipelineDestinationOutputPayloadFormatProtobufArgs']]):
        pulumi.set(self, "protobuf", value)


if not MYPY:
    class PipelineDestinationOutputPayloadFormatAvroArgsDict(TypedDict):
        schema_definition: NotRequired[pulumi.Input[builtins.str]]
        """
        The entire schema definition is stored in this field.
        """
elif False:
    PipelineDestinationOutputPayloadFormatAvroArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PipelineDestinationOutputPayloadFormatAvroArgs:
    def __init__(__self__, *,
                 schema_definition: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] schema_definition: The entire schema definition is stored in this field.
        """
        if schema_definition is not None:
            pulumi.set(__self__, "schema_definition", schema_definition)

    @property
    @pulumi.getter(name="schemaDefinition")
    def schema_definition(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The entire schema definition is stored in this field.
        """
        return pulumi.get(self, "schema_definition")

    @schema_definition.setter
    def schema_definition(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "schema_definition", value)


if not MYPY:
    class PipelineDestinationOutputPayloadFormatJsonArgsDict(TypedDict):
        pass
elif False:
    PipelineDestinationOutputPayloadFormatJsonArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PipelineDestinationOutputPayloadFormatJsonArgs:
    def __init__(__self__):
        pass


if not MYPY:
    class PipelineDestinationOutputPayloadFormatProtobufArgsDict(TypedDict):
        schema_definition: NotRequired[pulumi.Input[builtins.str]]
        """
        The entire schema definition is stored in this field.
        """
elif False:
    PipelineDestinationOutputPayloadFormatProtobufArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PipelineDestinationOutputPayloadFormatProtobufArgs:
    def __init__(__self__, *,
                 schema_definition: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] schema_definition: The entire schema definition is stored in this field.
        """
        if schema_definition is not None:
            pulumi.set(__self__, "schema_definition", schema_definition)

    @property
    @pulumi.getter(name="schemaDefinition")
    def schema_definition(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The entire schema definition is stored in this field.
        """
        return pulumi.get(self, "schema_definition")

    @schema_definition.setter
    def schema_definition(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "schema_definition", value)


if not MYPY:
    class PipelineInputPayloadFormatArgsDict(TypedDict):
        avro: NotRequired[pulumi.Input['PipelineInputPayloadFormatAvroArgsDict']]
        """
        The format of an AVRO message payload.
        Structure is documented below.
        """
        json: NotRequired[pulumi.Input['PipelineInputPayloadFormatJsonArgsDict']]
        """
        The format of a JSON message payload.
        """
        protobuf: NotRequired[pulumi.Input['PipelineInputPayloadFormatProtobufArgsDict']]
        """
        The format of a Protobuf message payload.
        Structure is documented below.
        """
elif False:
    PipelineInputPayloadFormatArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PipelineInputPayloadFormatArgs:
    def __init__(__self__, *,
                 avro: Optional[pulumi.Input['PipelineInputPayloadFormatAvroArgs']] = None,
                 json: Optional[pulumi.Input['PipelineInputPayloadFormatJsonArgs']] = None,
                 protobuf: Optional[pulumi.Input['PipelineInputPayloadFormatProtobufArgs']] = None):
        """
        :param pulumi.Input['PipelineInputPayloadFormatAvroArgs'] avro: The format of an AVRO message payload.
               Structure is documented below.
        :param pulumi.Input['PipelineInputPayloadFormatJsonArgs'] json: The format of a JSON message payload.
        :param pulumi.Input['PipelineInputPayloadFormatProtobufArgs'] protobuf: The format of a Protobuf message payload.
               Structure is documented below.
        """
        if avro is not None:
            pulumi.set(__self__, "avro", avro)
        if json is not None:
            pulumi.set(__self__, "json", json)
        if protobuf is not None:
            pulumi.set(__self__, "protobuf", protobuf)

    @property
    @pulumi.getter
    def avro(self) -> Optional[pulumi.Input['PipelineInputPayloadFormatAvroArgs']]:
        """
        The format of an AVRO message payload.
        Structure is documented below.
        """
        return pulumi.get(self, "avro")

    @avro.setter
    def avro(self, value: Optional[pulumi.Input['PipelineInputPayloadFormatAvroArgs']]):
        pulumi.set(self, "avro", value)

    @property
    @pulumi.getter
    def json(self) -> Optional[pulumi.Input['PipelineInputPayloadFormatJsonArgs']]:
        """
        The format of a JSON message payload.
        """
        return pulumi.get(self, "json")

    @json.setter
    def json(self, value: Optional[pulumi.Input['PipelineInputPayloadFormatJsonArgs']]):
        pulumi.set(self, "json", value)

    @property
    @pulumi.getter
    def protobuf(self) -> Optional[pulumi.Input['PipelineInputPayloadFormatProtobufArgs']]:
        """
        The format of a Protobuf message payload.
        Structure is documented below.
        """
        return pulumi.get(self, "protobuf")

    @protobuf.setter
    def protobuf(self, value: Optional[pulumi.Input['PipelineInputPayloadFormatProtobufArgs']]):
        pulumi.set(self, "protobuf", value)


if not MYPY:
    class PipelineInputPayloadFormatAvroArgsDict(TypedDict):
        schema_definition: NotRequired[pulumi.Input[builtins.str]]
        """
        The entire schema definition is stored in this field.
        """
elif False:
    PipelineInputPayloadFormatAvroArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PipelineInputPayloadFormatAvroArgs:
    def __init__(__self__, *,
                 schema_definition: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] schema_definition: The entire schema definition is stored in this field.
        """
        if schema_definition is not None:
            pulumi.set(__self__, "schema_definition", schema_definition)

    @property
    @pulumi.getter(name="schemaDefinition")
    def schema_definition(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The entire schema definition is stored in this field.
        """
        return pulumi.get(self, "schema_definition")

    @schema_definition.setter
    def schema_definition(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "schema_definition", value)


if not MYPY:
    class PipelineInputPayloadFormatJsonArgsDict(TypedDict):
        pass
elif False:
    PipelineInputPayloadFormatJsonArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PipelineInputPayloadFormatJsonArgs:
    def __init__(__self__):
        pass


if not MYPY:
    class PipelineInputPayloadFormatProtobufArgsDict(TypedDict):
        schema_definition: NotRequired[pulumi.Input[builtins.str]]
        """
        The entire schema definition is stored in this field.
        """
elif False:
    PipelineInputPayloadFormatProtobufArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PipelineInputPayloadFormatProtobufArgs:
    def __init__(__self__, *,
                 schema_definition: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] schema_definition: The entire schema definition is stored in this field.
        """
        if schema_definition is not None:
            pulumi.set(__self__, "schema_definition", schema_definition)

    @property
    @pulumi.getter(name="schemaDefinition")
    def schema_definition(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The entire schema definition is stored in this field.
        """
        return pulumi.get(self, "schema_definition")

    @schema_definition.setter
    def schema_definition(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "schema_definition", value)


if not MYPY:
    class PipelineLoggingConfigArgsDict(TypedDict):
        log_severity: NotRequired[pulumi.Input[builtins.str]]
        """
        The minimum severity of logs that will be sent to Stackdriver/Platform
        Telemetry. Logs at severitiy ≥ this value will be sent, unless it is NONE.
        Possible values are: `NONE`, `DEBUG`, `INFO`, `NOTICE`, `WARNING`, `ERROR`, `CRITICAL`, `ALERT`, `EMERGENCY`.
        """
elif False:
    PipelineLoggingConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PipelineLoggingConfigArgs:
    def __init__(__self__, *,
                 log_severity: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] log_severity: The minimum severity of logs that will be sent to Stackdriver/Platform
               Telemetry. Logs at severitiy ≥ this value will be sent, unless it is NONE.
               Possible values are: `NONE`, `DEBUG`, `INFO`, `NOTICE`, `WARNING`, `ERROR`, `CRITICAL`, `ALERT`, `EMERGENCY`.
        """
        if log_severity is not None:
            pulumi.set(__self__, "log_severity", log_severity)

    @property
    @pulumi.getter(name="logSeverity")
    def log_severity(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The minimum severity of logs that will be sent to Stackdriver/Platform
        Telemetry. Logs at severitiy ≥ this value will be sent, unless it is NONE.
        Possible values are: `NONE`, `DEBUG`, `INFO`, `NOTICE`, `WARNING`, `ERROR`, `CRITICAL`, `ALERT`, `EMERGENCY`.
        """
        return pulumi.get(self, "log_severity")

    @log_severity.setter
    def log_severity(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "log_severity", value)


if not MYPY:
    class PipelineMediationArgsDict(TypedDict):
        transformation: NotRequired[pulumi.Input['PipelineMediationTransformationArgsDict']]
        """
        Transformation defines the way to transform an incoming message.
        Structure is documented below.
        """
elif False:
    PipelineMediationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PipelineMediationArgs:
    def __init__(__self__, *,
                 transformation: Optional[pulumi.Input['PipelineMediationTransformationArgs']] = None):
        """
        :param pulumi.Input['PipelineMediationTransformationArgs'] transformation: Transformation defines the way to transform an incoming message.
               Structure is documented below.
        """
        if transformation is not None:
            pulumi.set(__self__, "transformation", transformation)

    @property
    @pulumi.getter
    def transformation(self) -> Optional[pulumi.Input['PipelineMediationTransformationArgs']]:
        """
        Transformation defines the way to transform an incoming message.
        Structure is documented below.
        """
        return pulumi.get(self, "transformation")

    @transformation.setter
    def transformation(self, value: Optional[pulumi.Input['PipelineMediationTransformationArgs']]):
        pulumi.set(self, "transformation", value)


if not MYPY:
    class PipelineMediationTransformationArgsDict(TypedDict):
        transformation_template: NotRequired[pulumi.Input[builtins.str]]
        """
        The CEL expression template to apply to transform messages.
        The following CEL extension functions are provided for
        use in this CEL expression:
        - merge:
        map1.merge(map2) > map3
        - Merges the passed CEL map with the existing CEL map the
        function is applied to.
        - If the same key exists in both maps, if the key's value is type
        map both maps are merged else the value from the passed map is
        used.
        - denormalize:
        map.denormalize() > map
        - Denormalizes a CEL map such that every value of type map or key
        in the map is expanded to return a single level map.
        - The resulting keys are "." separated indices of the map keys.
        - For example:
        {
        "a": 1,
        "b": {
        "c": 2,
        "d": 3
        }
        "e": [4, 5]
        }
        .denormalize()
        > {
        "a": 1,
        "b.c": 2,
        "b.d": 3,
        "e.0": 4,
        "e.1": 5
        }
        - setField:
        map.setField(key, value) > message
        - Sets the field of the message with the given key to the
        given value.
        - If the field is not present it will be added.
        - If the field is present it will be overwritten.
        - The key can be a dot separated path to set a field in a nested
        message.
        - Key must be of type string.
        - Value may be any valid type.
        - removeFields:
        map.removeFields([key1, key2, ...]) > message
        - Removes the fields of the map with the given keys.
        - The keys can be a dot separated path to remove a field in a
        nested message.
        - If a key is not found it will be ignored.
        - Keys must be of type string.
        - toMap:
        [map1, map2, ...].toMap() > map
        - Converts a CEL list of CEL maps to a single CEL map
        - toDestinationPayloadFormat():
        message.data.toDestinationPayloadFormat() > string or bytes
        - Converts the message data to the destination payload format
        specified in Pipeline.Destination.output_payload_format
        - This function is meant to be applied to the message.data field.
        - If the destination payload format is not set, the function will
        return the message data unchanged.
        - toCloudEventJsonWithPayloadFormat:
        message.toCloudEventJsonWithPayloadFormat() > map
        - Converts a message to the corresponding structure of JSON
        format for CloudEvents
        - This function applies toDestinationPayloadFormat() to the
        message data. It also sets the corresponding datacontenttype of
        the CloudEvent, as indicated by
        Pipeline.Destination.output_payload_format. If no
        output_payload_format is set it will use the existing
        datacontenttype on the CloudEvent if present, else leave
        datacontenttype absent.
        - This function expects that the content of the message will
        adhere to the standard CloudEvent format. If it doesn't then this
        function will fail.
        - The result is a CEL map that corresponds to the JSON
        representation of the CloudEvent. To convert that data to a JSON
        string it can be chained with the toJsonString function.
        """
elif False:
    PipelineMediationTransformationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PipelineMediationTransformationArgs:
    def __init__(__self__, *,
                 transformation_template: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] transformation_template: The CEL expression template to apply to transform messages.
               The following CEL extension functions are provided for
               use in this CEL expression:
               - merge:
               map1.merge(map2) > map3
               - Merges the passed CEL map with the existing CEL map the
               function is applied to.
               - If the same key exists in both maps, if the key's value is type
               map both maps are merged else the value from the passed map is
               used.
               - denormalize:
               map.denormalize() > map
               - Denormalizes a CEL map such that every value of type map or key
               in the map is expanded to return a single level map.
               - The resulting keys are "." separated indices of the map keys.
               - For example:
               {
               "a": 1,
               "b": {
               "c": 2,
               "d": 3
               }
               "e": [4, 5]
               }
               .denormalize()
               > {
               "a": 1,
               "b.c": 2,
               "b.d": 3,
               "e.0": 4,
               "e.1": 5
               }
               - setField:
               map.setField(key, value) > message
               - Sets the field of the message with the given key to the
               given value.
               - If the field is not present it will be added.
               - If the field is present it will be overwritten.
               - The key can be a dot separated path to set a field in a nested
               message.
               - Key must be of type string.
               - Value may be any valid type.
               - removeFields:
               map.removeFields([key1, key2, ...]) > message
               - Removes the fields of the map with the given keys.
               - The keys can be a dot separated path to remove a field in a
               nested message.
               - If a key is not found it will be ignored.
               - Keys must be of type string.
               - toMap:
               [map1, map2, ...].toMap() > map
               - Converts a CEL list of CEL maps to a single CEL map
               - toDestinationPayloadFormat():
               message.data.toDestinationPayloadFormat() > string or bytes
               - Converts the message data to the destination payload format
               specified in Pipeline.Destination.output_payload_format
               - This function is meant to be applied to the message.data field.
               - If the destination payload format is not set, the function will
               return the message data unchanged.
               - toCloudEventJsonWithPayloadFormat:
               message.toCloudEventJsonWithPayloadFormat() > map
               - Converts a message to the corresponding structure of JSON
               format for CloudEvents
               - This function applies toDestinationPayloadFormat() to the
               message data. It also sets the corresponding datacontenttype of
               the CloudEvent, as indicated by
               Pipeline.Destination.output_payload_format. If no
               output_payload_format is set it will use the existing
               datacontenttype on the CloudEvent if present, else leave
               datacontenttype absent.
               - This function expects that the content of the message will
               adhere to the standard CloudEvent format. If it doesn't then this
               function will fail.
               - The result is a CEL map that corresponds to the JSON
               representation of the CloudEvent. To convert that data to a JSON
               string it can be chained with the toJsonString function.
        """
        if transformation_template is not None:
            pulumi.set(__self__, "transformation_template", transformation_template)

    @property
    @pulumi.getter(name="transformationTemplate")
    def transformation_template(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The CEL expression template to apply to transform messages.
        The following CEL extension functions are provided for
        use in this CEL expression:
        - merge:
        map1.merge(map2) > map3
        - Merges the passed CEL map with the existing CEL map the
        function is applied to.
        - If the same key exists in both maps, if the key's value is type
        map both maps are merged else the value from the passed map is
        used.
        - denormalize:
        map.denormalize() > map
        - Denormalizes a CEL map such that every value of type map or key
        in the map is expanded to return a single level map.
        - The resulting keys are "." separated indices of the map keys.
        - For example:
        {
        "a": 1,
        "b": {
        "c": 2,
        "d": 3
        }
        "e": [4, 5]
        }
        .denormalize()
        > {
        "a": 1,
        "b.c": 2,
        "b.d": 3,
        "e.0": 4,
        "e.1": 5
        }
        - setField:
        map.setField(key, value) > message
        - Sets the field of the message with the given key to the
        given value.
        - If the field is not present it will be added.
        - If the field is present it will be overwritten.
        - The key can be a dot separated path to set a field in a nested
        message.
        - Key must be of type string.
        - Value may be any valid type.
        - removeFields:
        map.removeFields([key1, key2, ...]) > message
        - Removes the fields of the map with the given keys.
        - The keys can be a dot separated path to remove a field in a
        nested message.
        - If a key is not found it will be ignored.
        - Keys must be of type string.
        - toMap:
        [map1, map2, ...].toMap() > map
        - Converts a CEL list of CEL maps to a single CEL map
        - toDestinationPayloadFormat():
        message.data.toDestinationPayloadFormat() > string or bytes
        - Converts the message data to the destination payload format
        specified in Pipeline.Destination.output_payload_format
        - This function is meant to be applied to the message.data field.
        - If the destination payload format is not set, the function will
        return the message data unchanged.
        - toCloudEventJsonWithPayloadFormat:
        message.toCloudEventJsonWithPayloadFormat() > map
        - Converts a message to the corresponding structure of JSON
        format for CloudEvents
        - This function applies toDestinationPayloadFormat() to the
        message data. It also sets the corresponding datacontenttype of
        the CloudEvent, as indicated by
        Pipeline.Destination.output_payload_format. If no
        output_payload_format is set it will use the existing
        datacontenttype on the CloudEvent if present, else leave
        datacontenttype absent.
        - This function expects that the content of the message will
        adhere to the standard CloudEvent format. If it doesn't then this
        function will fail.
        - The result is a CEL map that corresponds to the JSON
        representation of the CloudEvent. To convert that data to a JSON
        string it can be chained with the toJsonString function.
        """
        return pulumi.get(self, "transformation_template")

    @transformation_template.setter
    def transformation_template(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "transformation_template", value)


if not MYPY:
    class PipelineRetryPolicyArgsDict(TypedDict):
        max_attempts: NotRequired[pulumi.Input[builtins.int]]
        """
        The maximum number of delivery attempts for any message. The value must
        be between 1 and 100.
        The default value for this field is 5.
        """
        max_retry_delay: NotRequired[pulumi.Input[builtins.str]]
        """
        The maximum amount of seconds to wait between retry attempts. The value
        must be between 1 and 600.
        The default value for this field is 60.
        """
        min_retry_delay: NotRequired[pulumi.Input[builtins.str]]
        """
        The minimum amount of seconds to wait between retry attempts. The value
        must be between 1 and 600.
        The default value for this field is 5.
        """
elif False:
    PipelineRetryPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PipelineRetryPolicyArgs:
    def __init__(__self__, *,
                 max_attempts: Optional[pulumi.Input[builtins.int]] = None,
                 max_retry_delay: Optional[pulumi.Input[builtins.str]] = None,
                 min_retry_delay: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.int] max_attempts: The maximum number of delivery attempts for any message. The value must
               be between 1 and 100.
               The default value for this field is 5.
        :param pulumi.Input[builtins.str] max_retry_delay: The maximum amount of seconds to wait between retry attempts. The value
               must be between 1 and 600.
               The default value for this field is 60.
        :param pulumi.Input[builtins.str] min_retry_delay: The minimum amount of seconds to wait between retry attempts. The value
               must be between 1 and 600.
               The default value for this field is 5.
        """
        if max_attempts is not None:
            pulumi.set(__self__, "max_attempts", max_attempts)
        if max_retry_delay is not None:
            pulumi.set(__self__, "max_retry_delay", max_retry_delay)
        if min_retry_delay is not None:
            pulumi.set(__self__, "min_retry_delay", min_retry_delay)

    @property
    @pulumi.getter(name="maxAttempts")
    def max_attempts(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum number of delivery attempts for any message. The value must
        be between 1 and 100.
        The default value for this field is 5.
        """
        return pulumi.get(self, "max_attempts")

    @max_attempts.setter
    def max_attempts(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_attempts", value)

    @property
    @pulumi.getter(name="maxRetryDelay")
    def max_retry_delay(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The maximum amount of seconds to wait between retry attempts. The value
        must be between 1 and 600.
        The default value for this field is 60.
        """
        return pulumi.get(self, "max_retry_delay")

    @max_retry_delay.setter
    def max_retry_delay(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "max_retry_delay", value)

    @property
    @pulumi.getter(name="minRetryDelay")
    def min_retry_delay(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The minimum amount of seconds to wait between retry attempts. The value
        must be between 1 and 600.
        The default value for this field is 5.
        """
        return pulumi.get(self, "min_retry_delay")

    @min_retry_delay.setter
    def min_retry_delay(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "min_retry_delay", value)


if not MYPY:
    class TriggerDestinationArgsDict(TypedDict):
        cloud_function: NotRequired[pulumi.Input[builtins.str]]
        """
        (Output)
        The Cloud Function resource name. Only Cloud Functions V2 is supported. Format projects/{project}/locations/{location}/functions/{function} This is a read-only field. [WARNING] Creating Cloud Functions V2 triggers is only supported via the Cloud Functions product. An error will be returned if the user sets this value.
        """
        cloud_run_service: NotRequired[pulumi.Input['TriggerDestinationCloudRunServiceArgsDict']]
        """
        Cloud Run fully-managed service that receives the events. The service should be running in the same project of the trigger.
        Structure is documented below.
        """
        gke: NotRequired[pulumi.Input['TriggerDestinationGkeArgsDict']]
        """
        A GKE service capable of receiving events. The service should be running in the same project as the trigger.
        Structure is documented below.
        """
        http_endpoint: NotRequired[pulumi.Input['TriggerDestinationHttpEndpointArgsDict']]
        """
        An HTTP endpoint destination described by an URI.
        Structure is documented below.
        """
        network_config: NotRequired[pulumi.Input['TriggerDestinationNetworkConfigArgsDict']]
        """
        Optional. Network config is used to configure how Eventarc resolves and connect to a destination. This should only be used with HttpEndpoint destination type.
        Structure is documented below.
        """
        workflow: NotRequired[pulumi.Input[builtins.str]]
        """
        The resource name of the Workflow whose Executions are triggered by the events. The Workflow resource should be deployed in the same project as the trigger. Format: `projects/{project}/locations/{location}/workflows/{workflow}`
        """
elif False:
    TriggerDestinationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TriggerDestinationArgs:
    def __init__(__self__, *,
                 cloud_function: Optional[pulumi.Input[builtins.str]] = None,
                 cloud_run_service: Optional[pulumi.Input['TriggerDestinationCloudRunServiceArgs']] = None,
                 gke: Optional[pulumi.Input['TriggerDestinationGkeArgs']] = None,
                 http_endpoint: Optional[pulumi.Input['TriggerDestinationHttpEndpointArgs']] = None,
                 network_config: Optional[pulumi.Input['TriggerDestinationNetworkConfigArgs']] = None,
                 workflow: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] cloud_function: (Output)
               The Cloud Function resource name. Only Cloud Functions V2 is supported. Format projects/{project}/locations/{location}/functions/{function} This is a read-only field. [WARNING] Creating Cloud Functions V2 triggers is only supported via the Cloud Functions product. An error will be returned if the user sets this value.
        :param pulumi.Input['TriggerDestinationCloudRunServiceArgs'] cloud_run_service: Cloud Run fully-managed service that receives the events. The service should be running in the same project of the trigger.
               Structure is documented below.
        :param pulumi.Input['TriggerDestinationGkeArgs'] gke: A GKE service capable of receiving events. The service should be running in the same project as the trigger.
               Structure is documented below.
        :param pulumi.Input['TriggerDestinationHttpEndpointArgs'] http_endpoint: An HTTP endpoint destination described by an URI.
               Structure is documented below.
        :param pulumi.Input['TriggerDestinationNetworkConfigArgs'] network_config: Optional. Network config is used to configure how Eventarc resolves and connect to a destination. This should only be used with HttpEndpoint destination type.
               Structure is documented below.
        :param pulumi.Input[builtins.str] workflow: The resource name of the Workflow whose Executions are triggered by the events. The Workflow resource should be deployed in the same project as the trigger. Format: `projects/{project}/locations/{location}/workflows/{workflow}`
        """
        if cloud_function is not None:
            pulumi.set(__self__, "cloud_function", cloud_function)
        if cloud_run_service is not None:
            pulumi.set(__self__, "cloud_run_service", cloud_run_service)
        if gke is not None:
            pulumi.set(__self__, "gke", gke)
        if http_endpoint is not None:
            pulumi.set(__self__, "http_endpoint", http_endpoint)
        if network_config is not None:
            pulumi.set(__self__, "network_config", network_config)
        if workflow is not None:
            pulumi.set(__self__, "workflow", workflow)

    @property
    @pulumi.getter(name="cloudFunction")
    def cloud_function(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Output)
        The Cloud Function resource name. Only Cloud Functions V2 is supported. Format projects/{project}/locations/{location}/functions/{function} This is a read-only field. [WARNING] Creating Cloud Functions V2 triggers is only supported via the Cloud Functions product. An error will be returned if the user sets this value.
        """
        return pulumi.get(self, "cloud_function")

    @cloud_function.setter
    def cloud_function(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cloud_function", value)

    @property
    @pulumi.getter(name="cloudRunService")
    def cloud_run_service(self) -> Optional[pulumi.Input['TriggerDestinationCloudRunServiceArgs']]:
        """
        Cloud Run fully-managed service that receives the events. The service should be running in the same project of the trigger.
        Structure is documented below.
        """
        return pulumi.get(self, "cloud_run_service")

    @cloud_run_service.setter
    def cloud_run_service(self, value: Optional[pulumi.Input['TriggerDestinationCloudRunServiceArgs']]):
        pulumi.set(self, "cloud_run_service", value)

    @property
    @pulumi.getter
    def gke(self) -> Optional[pulumi.Input['TriggerDestinationGkeArgs']]:
        """
        A GKE service capable of receiving events. The service should be running in the same project as the trigger.
        Structure is documented below.
        """
        return pulumi.get(self, "gke")

    @gke.setter
    def gke(self, value: Optional[pulumi.Input['TriggerDestinationGkeArgs']]):
        pulumi.set(self, "gke", value)

    @property
    @pulumi.getter(name="httpEndpoint")
    def http_endpoint(self) -> Optional[pulumi.Input['TriggerDestinationHttpEndpointArgs']]:
        """
        An HTTP endpoint destination described by an URI.
        Structure is documented below.
        """
        return pulumi.get(self, "http_endpoint")

    @http_endpoint.setter
    def http_endpoint(self, value: Optional[pulumi.Input['TriggerDestinationHttpEndpointArgs']]):
        pulumi.set(self, "http_endpoint", value)

    @property
    @pulumi.getter(name="networkConfig")
    def network_config(self) -> Optional[pulumi.Input['TriggerDestinationNetworkConfigArgs']]:
        """
        Optional. Network config is used to configure how Eventarc resolves and connect to a destination. This should only be used with HttpEndpoint destination type.
        Structure is documented below.
        """
        return pulumi.get(self, "network_config")

    @network_config.setter
    def network_config(self, value: Optional[pulumi.Input['TriggerDestinationNetworkConfigArgs']]):
        pulumi.set(self, "network_config", value)

    @property
    @pulumi.getter
    def workflow(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource name of the Workflow whose Executions are triggered by the events. The Workflow resource should be deployed in the same project as the trigger. Format: `projects/{project}/locations/{location}/workflows/{workflow}`
        """
        return pulumi.get(self, "workflow")

    @workflow.setter
    def workflow(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "workflow", value)


if not MYPY:
    class TriggerDestinationCloudRunServiceArgsDict(TypedDict):
        service: pulumi.Input[builtins.str]
        """
        Required. The name of the Cloud Run service being addressed. See https://cloud.google.com/run/docs/reference/rest/v1/namespaces.services. Only services located in the same project of the trigger object can be addressed.
        """
        path: NotRequired[pulumi.Input[builtins.str]]
        """
        Optional. The relative path on the Cloud Run service the events should be sent to. The value must conform to the definition of URI path segment (section 3.3 of RFC2396). Examples: "/route", "route", "route/subroute".
        """
        region: NotRequired[pulumi.Input[builtins.str]]
        """
        Required. The region the Cloud Run service is deployed in.
        """
elif False:
    TriggerDestinationCloudRunServiceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TriggerDestinationCloudRunServiceArgs:
    def __init__(__self__, *,
                 service: pulumi.Input[builtins.str],
                 path: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] service: Required. The name of the Cloud Run service being addressed. See https://cloud.google.com/run/docs/reference/rest/v1/namespaces.services. Only services located in the same project of the trigger object can be addressed.
        :param pulumi.Input[builtins.str] path: Optional. The relative path on the Cloud Run service the events should be sent to. The value must conform to the definition of URI path segment (section 3.3 of RFC2396). Examples: "/route", "route", "route/subroute".
        :param pulumi.Input[builtins.str] region: Required. The region the Cloud Run service is deployed in.
        """
        pulumi.set(__self__, "service", service)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def service(self) -> pulumi.Input[builtins.str]:
        """
        Required. The name of the Cloud Run service being addressed. See https://cloud.google.com/run/docs/reference/rest/v1/namespaces.services. Only services located in the same project of the trigger object can be addressed.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "service", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional. The relative path on the Cloud Run service the events should be sent to. The value must conform to the definition of URI path segment (section 3.3 of RFC2396). Examples: "/route", "route", "route/subroute".
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Required. The region the Cloud Run service is deployed in.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)


if not MYPY:
    class TriggerDestinationGkeArgsDict(TypedDict):
        cluster: pulumi.Input[builtins.str]
        """
        Required. The name of the cluster the GKE service is running in. The cluster must be running in the same project as the trigger being created.
        """
        location: pulumi.Input[builtins.str]
        """
        Required. The name of the Google Compute Engine in which the cluster resides, which can either be compute zone (for example, us-central1-a) for the zonal clusters or region (for example, us-central1) for regional clusters.
        """
        namespace: pulumi.Input[builtins.str]
        """
        Required. The namespace the GKE service is running in.
        """
        service: pulumi.Input[builtins.str]
        """
        Required. Name of the GKE service.
        """
        path: NotRequired[pulumi.Input[builtins.str]]
        """
        Optional. The relative path on the GKE service the events should be sent to. The value must conform to the definition of a URI path segment (section 3.3 of RFC2396). Examples: "/route", "route", "route/subroute".
        """
elif False:
    TriggerDestinationGkeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TriggerDestinationGkeArgs:
    def __init__(__self__, *,
                 cluster: pulumi.Input[builtins.str],
                 location: pulumi.Input[builtins.str],
                 namespace: pulumi.Input[builtins.str],
                 service: pulumi.Input[builtins.str],
                 path: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] cluster: Required. The name of the cluster the GKE service is running in. The cluster must be running in the same project as the trigger being created.
        :param pulumi.Input[builtins.str] location: Required. The name of the Google Compute Engine in which the cluster resides, which can either be compute zone (for example, us-central1-a) for the zonal clusters or region (for example, us-central1) for regional clusters.
        :param pulumi.Input[builtins.str] namespace: Required. The namespace the GKE service is running in.
        :param pulumi.Input[builtins.str] service: Required. Name of the GKE service.
        :param pulumi.Input[builtins.str] path: Optional. The relative path on the GKE service the events should be sent to. The value must conform to the definition of a URI path segment (section 3.3 of RFC2396). Examples: "/route", "route", "route/subroute".
        """
        pulumi.set(__self__, "cluster", cluster)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "service", service)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def cluster(self) -> pulumi.Input[builtins.str]:
        """
        Required. The name of the cluster the GKE service is running in. The cluster must be running in the same project as the trigger being created.
        """
        return pulumi.get(self, "cluster")

    @cluster.setter
    def cluster(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "cluster", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        Required. The name of the Google Compute Engine in which the cluster resides, which can either be compute zone (for example, us-central1-a) for the zonal clusters or region (for example, us-central1) for regional clusters.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Input[builtins.str]:
        """
        Required. The namespace the GKE service is running in.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def service(self) -> pulumi.Input[builtins.str]:
        """
        Required. Name of the GKE service.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "service", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional. The relative path on the GKE service the events should be sent to. The value must conform to the definition of a URI path segment (section 3.3 of RFC2396). Examples: "/route", "route", "route/subroute".
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "path", value)


if not MYPY:
    class TriggerDestinationHttpEndpointArgsDict(TypedDict):
        uri: pulumi.Input[builtins.str]
        """
        Required. The URI of the HTTP enpdoint. The value must be a RFC2396 URI string. Examples: `http://10.10.10.8:80/route`, `http://svc.us-central1.p.local:8080/`. Only HTTP and HTTPS protocols are supported. The host can be either a static IP addressable from the VPC specified by the network config, or an internal DNS hostname of the service resolvable via Cloud DNS.
        """
elif False:
    TriggerDestinationHttpEndpointArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TriggerDestinationHttpEndpointArgs:
    def __init__(__self__, *,
                 uri: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] uri: Required. The URI of the HTTP enpdoint. The value must be a RFC2396 URI string. Examples: `http://10.10.10.8:80/route`, `http://svc.us-central1.p.local:8080/`. Only HTTP and HTTPS protocols are supported. The host can be either a static IP addressable from the VPC specified by the network config, or an internal DNS hostname of the service resolvable via Cloud DNS.
        """
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def uri(self) -> pulumi.Input[builtins.str]:
        """
        Required. The URI of the HTTP enpdoint. The value must be a RFC2396 URI string. Examples: `http://10.10.10.8:80/route`, `http://svc.us-central1.p.local:8080/`. Only HTTP and HTTPS protocols are supported. The host can be either a static IP addressable from the VPC specified by the network config, or an internal DNS hostname of the service resolvable via Cloud DNS.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "uri", value)


if not MYPY:
    class TriggerDestinationNetworkConfigArgsDict(TypedDict):
        network_attachment: pulumi.Input[builtins.str]
        """
        Required. Name of the NetworkAttachment that allows access to the destination VPC. Format: `projects/{PROJECT_ID}/regions/{REGION}/networkAttachments/{NETWORK_ATTACHMENT_NAME}`

        - - -
        """
elif False:
    TriggerDestinationNetworkConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TriggerDestinationNetworkConfigArgs:
    def __init__(__self__, *,
                 network_attachment: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] network_attachment: Required. Name of the NetworkAttachment that allows access to the destination VPC. Format: `projects/{PROJECT_ID}/regions/{REGION}/networkAttachments/{NETWORK_ATTACHMENT_NAME}`
               
               - - -
        """
        pulumi.set(__self__, "network_attachment", network_attachment)

    @property
    @pulumi.getter(name="networkAttachment")
    def network_attachment(self) -> pulumi.Input[builtins.str]:
        """
        Required. Name of the NetworkAttachment that allows access to the destination VPC. Format: `projects/{PROJECT_ID}/regions/{REGION}/networkAttachments/{NETWORK_ATTACHMENT_NAME}`

        - - -
        """
        return pulumi.get(self, "network_attachment")

    @network_attachment.setter
    def network_attachment(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "network_attachment", value)


if not MYPY:
    class TriggerMatchingCriteriaArgsDict(TypedDict):
        attribute: pulumi.Input[builtins.str]
        """
        Required. The name of a CloudEvents attribute. Currently, only a subset of attributes are supported for filtering. All triggers MUST provide a filter for the 'type' attribute.
        """
        value: pulumi.Input[builtins.str]
        """
        Required. The value for the attribute. See https://cloud.google.com/eventarc/docs/creating-triggers#trigger-gcloud for available values.
        """
        operator: NotRequired[pulumi.Input[builtins.str]]
        """
        Optional. The operator used for matching the events with the value of the filter. If not specified, only events that have an exact key-value pair specified in the filter are matched. The only allowed value is `match-path-pattern`.
        """
elif False:
    TriggerMatchingCriteriaArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TriggerMatchingCriteriaArgs:
    def __init__(__self__, *,
                 attribute: pulumi.Input[builtins.str],
                 value: pulumi.Input[builtins.str],
                 operator: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] attribute: Required. The name of a CloudEvents attribute. Currently, only a subset of attributes are supported for filtering. All triggers MUST provide a filter for the 'type' attribute.
        :param pulumi.Input[builtins.str] value: Required. The value for the attribute. See https://cloud.google.com/eventarc/docs/creating-triggers#trigger-gcloud for available values.
        :param pulumi.Input[builtins.str] operator: Optional. The operator used for matching the events with the value of the filter. If not specified, only events that have an exact key-value pair specified in the filter are matched. The only allowed value is `match-path-pattern`.
        """
        pulumi.set(__self__, "attribute", attribute)
        pulumi.set(__self__, "value", value)
        if operator is not None:
            pulumi.set(__self__, "operator", operator)

    @property
    @pulumi.getter
    def attribute(self) -> pulumi.Input[builtins.str]:
        """
        Required. The name of a CloudEvents attribute. Currently, only a subset of attributes are supported for filtering. All triggers MUST provide a filter for the 'type' attribute.
        """
        return pulumi.get(self, "attribute")

    @attribute.setter
    def attribute(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "attribute", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[builtins.str]:
        """
        Required. The value for the attribute. See https://cloud.google.com/eventarc/docs/creating-triggers#trigger-gcloud for available values.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter
    def operator(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional. The operator used for matching the events with the value of the filter. If not specified, only events that have an exact key-value pair specified in the filter are matched. The only allowed value is `match-path-pattern`.
        """
        return pulumi.get(self, "operator")

    @operator.setter
    def operator(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "operator", value)


if not MYPY:
    class TriggerTransportArgsDict(TypedDict):
        pubsub: NotRequired[pulumi.Input['TriggerTransportPubsubArgsDict']]
        """
        The Pub/Sub topic and subscription used by Eventarc as delivery intermediary.
        Structure is documented below.
        """
elif False:
    TriggerTransportArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TriggerTransportArgs:
    def __init__(__self__, *,
                 pubsub: Optional[pulumi.Input['TriggerTransportPubsubArgs']] = None):
        """
        :param pulumi.Input['TriggerTransportPubsubArgs'] pubsub: The Pub/Sub topic and subscription used by Eventarc as delivery intermediary.
               Structure is documented below.
        """
        if pubsub is not None:
            pulumi.set(__self__, "pubsub", pubsub)

    @property
    @pulumi.getter
    def pubsub(self) -> Optional[pulumi.Input['TriggerTransportPubsubArgs']]:
        """
        The Pub/Sub topic and subscription used by Eventarc as delivery intermediary.
        Structure is documented below.
        """
        return pulumi.get(self, "pubsub")

    @pubsub.setter
    def pubsub(self, value: Optional[pulumi.Input['TriggerTransportPubsubArgs']]):
        pulumi.set(self, "pubsub", value)


if not MYPY:
    class TriggerTransportPubsubArgsDict(TypedDict):
        subscription: NotRequired[pulumi.Input[builtins.str]]
        """
        (Output)
        Output only. The name of the Pub/Sub subscription created and managed by Eventarc system as a transport for the event delivery. Format: `projects/{PROJECT_ID}/subscriptions/{SUBSCRIPTION_NAME}`.
        """
        topic: NotRequired[pulumi.Input[builtins.str]]
        """
        Optional. The name of the Pub/Sub topic created and managed by Eventarc system as a transport for the event delivery. Format: `projects/{PROJECT_ID}/topics/{TOPIC_NAME}. You may set an existing topic for triggers of the type google.cloud.pubsub.topic.v1.messagePublished` only. The topic you provide here will not be deleted by Eventarc at trigger deletion.
        """
elif False:
    TriggerTransportPubsubArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TriggerTransportPubsubArgs:
    def __init__(__self__, *,
                 subscription: Optional[pulumi.Input[builtins.str]] = None,
                 topic: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] subscription: (Output)
               Output only. The name of the Pub/Sub subscription created and managed by Eventarc system as a transport for the event delivery. Format: `projects/{PROJECT_ID}/subscriptions/{SUBSCRIPTION_NAME}`.
        :param pulumi.Input[builtins.str] topic: Optional. The name of the Pub/Sub topic created and managed by Eventarc system as a transport for the event delivery. Format: `projects/{PROJECT_ID}/topics/{TOPIC_NAME}. You may set an existing topic for triggers of the type google.cloud.pubsub.topic.v1.messagePublished` only. The topic you provide here will not be deleted by Eventarc at trigger deletion.
        """
        if subscription is not None:
            pulumi.set(__self__, "subscription", subscription)
        if topic is not None:
            pulumi.set(__self__, "topic", topic)

    @property
    @pulumi.getter
    def subscription(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Output)
        Output only. The name of the Pub/Sub subscription created and managed by Eventarc system as a transport for the event delivery. Format: `projects/{PROJECT_ID}/subscriptions/{SUBSCRIPTION_NAME}`.
        """
        return pulumi.get(self, "subscription")

    @subscription.setter
    def subscription(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "subscription", value)

    @property
    @pulumi.getter
    def topic(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional. The name of the Pub/Sub topic created and managed by Eventarc system as a transport for the event delivery. Format: `projects/{PROJECT_ID}/topics/{TOPIC_NAME}. You may set an existing topic for triggers of the type google.cloud.pubsub.topic.v1.messagePublished` only. The topic you provide here will not be deleted by Eventarc at trigger deletion.
        """
        return pulumi.get(self, "topic")

    @topic.setter
    def topic(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "topic", value)


