# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetInstanceResult',
    'AwaitableGetInstanceResult',
    'get_instance',
    'get_instance_output',
]

@pulumi.output_type
class GetInstanceResult:
    """
    A collection of values returned by getInstance.
    """
    def __init__(__self__, create_time=None, deletion_protection_enabled=None, deletion_protection_reason=None, description=None, directory_services=None, effective_labels=None, effective_replications=None, etag=None, file_shares=None, id=None, initial_replications=None, kms_key_name=None, labels=None, location=None, name=None, networks=None, performance_configs=None, project=None, protocol=None, pulumi_labels=None, tags=None, tier=None, zone=None):
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if deletion_protection_enabled and not isinstance(deletion_protection_enabled, bool):
            raise TypeError("Expected argument 'deletion_protection_enabled' to be a bool")
        pulumi.set(__self__, "deletion_protection_enabled", deletion_protection_enabled)
        if deletion_protection_reason and not isinstance(deletion_protection_reason, str):
            raise TypeError("Expected argument 'deletion_protection_reason' to be a str")
        pulumi.set(__self__, "deletion_protection_reason", deletion_protection_reason)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if directory_services and not isinstance(directory_services, list):
            raise TypeError("Expected argument 'directory_services' to be a list")
        pulumi.set(__self__, "directory_services", directory_services)
        if effective_labels and not isinstance(effective_labels, dict):
            raise TypeError("Expected argument 'effective_labels' to be a dict")
        pulumi.set(__self__, "effective_labels", effective_labels)
        if effective_replications and not isinstance(effective_replications, list):
            raise TypeError("Expected argument 'effective_replications' to be a list")
        pulumi.set(__self__, "effective_replications", effective_replications)
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if file_shares and not isinstance(file_shares, list):
            raise TypeError("Expected argument 'file_shares' to be a list")
        pulumi.set(__self__, "file_shares", file_shares)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if initial_replications and not isinstance(initial_replications, list):
            raise TypeError("Expected argument 'initial_replications' to be a list")
        pulumi.set(__self__, "initial_replications", initial_replications)
        if kms_key_name and not isinstance(kms_key_name, str):
            raise TypeError("Expected argument 'kms_key_name' to be a str")
        pulumi.set(__self__, "kms_key_name", kms_key_name)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if networks and not isinstance(networks, list):
            raise TypeError("Expected argument 'networks' to be a list")
        pulumi.set(__self__, "networks", networks)
        if performance_configs and not isinstance(performance_configs, list):
            raise TypeError("Expected argument 'performance_configs' to be a list")
        pulumi.set(__self__, "performance_configs", performance_configs)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if protocol and not isinstance(protocol, str):
            raise TypeError("Expected argument 'protocol' to be a str")
        pulumi.set(__self__, "protocol", protocol)
        if pulumi_labels and not isinstance(pulumi_labels, dict):
            raise TypeError("Expected argument 'pulumi_labels' to be a dict")
        pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if tier and not isinstance(tier, str):
            raise TypeError("Expected argument 'tier' to be a str")
        pulumi.set(__self__, "tier", tier)
        if zone and not isinstance(zone, str):
            raise TypeError("Expected argument 'zone' to be a str")
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> builtins.str:
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="deletionProtectionEnabled")
    def deletion_protection_enabled(self) -> builtins.bool:
        return pulumi.get(self, "deletion_protection_enabled")

    @property
    @pulumi.getter(name="deletionProtectionReason")
    def deletion_protection_reason(self) -> builtins.str:
        return pulumi.get(self, "deletion_protection_reason")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="directoryServices")
    def directory_services(self) -> Sequence['outputs.GetInstanceDirectoryServiceResult']:
        return pulumi.get(self, "directory_services")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Mapping[str, builtins.str]:
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter(name="effectiveReplications")
    def effective_replications(self) -> Sequence['outputs.GetInstanceEffectiveReplicationResult']:
        return pulumi.get(self, "effective_replications")

    @property
    @pulumi.getter
    def etag(self) -> builtins.str:
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="fileShares")
    def file_shares(self) -> Sequence['outputs.GetInstanceFileShareResult']:
        return pulumi.get(self, "file_shares")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="initialReplications")
    def initial_replications(self) -> Sequence['outputs.GetInstanceInitialReplicationResult']:
        return pulumi.get(self, "initial_replications")

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> builtins.str:
        return pulumi.get(self, "kms_key_name")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, builtins.str]:
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> Optional[builtins.str]:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def networks(self) -> Sequence['outputs.GetInstanceNetworkResult']:
        return pulumi.get(self, "networks")

    @property
    @pulumi.getter(name="performanceConfigs")
    def performance_configs(self) -> Sequence['outputs.GetInstancePerformanceConfigResult']:
        return pulumi.get(self, "performance_configs")

    @property
    @pulumi.getter
    def project(self) -> Optional[builtins.str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def protocol(self) -> builtins.str:
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Mapping[str, builtins.str]:
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def tier(self) -> builtins.str:
        return pulumi.get(self, "tier")

    @property
    @pulumi.getter
    def zone(self) -> builtins.str:
        return pulumi.get(self, "zone")


class AwaitableGetInstanceResult(GetInstanceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInstanceResult(
            create_time=self.create_time,
            deletion_protection_enabled=self.deletion_protection_enabled,
            deletion_protection_reason=self.deletion_protection_reason,
            description=self.description,
            directory_services=self.directory_services,
            effective_labels=self.effective_labels,
            effective_replications=self.effective_replications,
            etag=self.etag,
            file_shares=self.file_shares,
            id=self.id,
            initial_replications=self.initial_replications,
            kms_key_name=self.kms_key_name,
            labels=self.labels,
            location=self.location,
            name=self.name,
            networks=self.networks,
            performance_configs=self.performance_configs,
            project=self.project,
            protocol=self.protocol,
            pulumi_labels=self.pulumi_labels,
            tags=self.tags,
            tier=self.tier,
            zone=self.zone)


def get_instance(location: Optional[builtins.str] = None,
                 name: Optional[builtins.str] = None,
                 project: Optional[builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInstanceResult:
    """
    Get info about a Google Cloud Filestore instance.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_instance = gcp.filestore.get_instance(name="my-filestore-instance")
    pulumi.export("instanceIpAddresses", my_instance.networks.ip_addresses)
    pulumi.export("instanceConnectMode", my_instance.networks.connect_mode)
    pulumi.export("instanceFileShareName", my_instance.file_shares.name)
    ```


    :param builtins.str location: The name of the location of the instance. This 
           can be a region for ENTERPRISE tier instances. If it is not provided,
           the provider region or zone is used.
    :param builtins.str name: The name of a Filestore instance.
           
           - - -
    :param builtins.str project: The project in which the resource belongs. If it
           is not provided, the provider project is used.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['name'] = name
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:filestore/getInstance:getInstance', __args__, opts=opts, typ=GetInstanceResult).value

    return AwaitableGetInstanceResult(
        create_time=pulumi.get(__ret__, 'create_time'),
        deletion_protection_enabled=pulumi.get(__ret__, 'deletion_protection_enabled'),
        deletion_protection_reason=pulumi.get(__ret__, 'deletion_protection_reason'),
        description=pulumi.get(__ret__, 'description'),
        directory_services=pulumi.get(__ret__, 'directory_services'),
        effective_labels=pulumi.get(__ret__, 'effective_labels'),
        effective_replications=pulumi.get(__ret__, 'effective_replications'),
        etag=pulumi.get(__ret__, 'etag'),
        file_shares=pulumi.get(__ret__, 'file_shares'),
        id=pulumi.get(__ret__, 'id'),
        initial_replications=pulumi.get(__ret__, 'initial_replications'),
        kms_key_name=pulumi.get(__ret__, 'kms_key_name'),
        labels=pulumi.get(__ret__, 'labels'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        networks=pulumi.get(__ret__, 'networks'),
        performance_configs=pulumi.get(__ret__, 'performance_configs'),
        project=pulumi.get(__ret__, 'project'),
        protocol=pulumi.get(__ret__, 'protocol'),
        pulumi_labels=pulumi.get(__ret__, 'pulumi_labels'),
        tags=pulumi.get(__ret__, 'tags'),
        tier=pulumi.get(__ret__, 'tier'),
        zone=pulumi.get(__ret__, 'zone'))
def get_instance_output(location: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                        name: Optional[pulumi.Input[builtins.str]] = None,
                        project: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetInstanceResult]:
    """
    Get info about a Google Cloud Filestore instance.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_instance = gcp.filestore.get_instance(name="my-filestore-instance")
    pulumi.export("instanceIpAddresses", my_instance.networks.ip_addresses)
    pulumi.export("instanceConnectMode", my_instance.networks.connect_mode)
    pulumi.export("instanceFileShareName", my_instance.file_shares.name)
    ```


    :param builtins.str location: The name of the location of the instance. This 
           can be a region for ENTERPRISE tier instances. If it is not provided,
           the provider region or zone is used.
    :param builtins.str name: The name of a Filestore instance.
           
           - - -
    :param builtins.str project: The project in which the resource belongs. If it
           is not provided, the provider project is used.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['name'] = name
    __args__['project'] = project
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:filestore/getInstance:getInstance', __args__, opts=opts, typ=GetInstanceResult)
    return __ret__.apply(lambda __response__: GetInstanceResult(
        create_time=pulumi.get(__response__, 'create_time'),
        deletion_protection_enabled=pulumi.get(__response__, 'deletion_protection_enabled'),
        deletion_protection_reason=pulumi.get(__response__, 'deletion_protection_reason'),
        description=pulumi.get(__response__, 'description'),
        directory_services=pulumi.get(__response__, 'directory_services'),
        effective_labels=pulumi.get(__response__, 'effective_labels'),
        effective_replications=pulumi.get(__response__, 'effective_replications'),
        etag=pulumi.get(__response__, 'etag'),
        file_shares=pulumi.get(__response__, 'file_shares'),
        id=pulumi.get(__response__, 'id'),
        initial_replications=pulumi.get(__response__, 'initial_replications'),
        kms_key_name=pulumi.get(__response__, 'kms_key_name'),
        labels=pulumi.get(__response__, 'labels'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        networks=pulumi.get(__response__, 'networks'),
        performance_configs=pulumi.get(__response__, 'performance_configs'),
        project=pulumi.get(__response__, 'project'),
        protocol=pulumi.get(__response__, 'protocol'),
        pulumi_labels=pulumi.get(__response__, 'pulumi_labels'),
        tags=pulumi.get(__response__, 'tags'),
        tier=pulumi.get(__response__, 'tier'),
        zone=pulumi.get(__response__, 'zone')))
