# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AppHostingDomainArgs', 'AppHostingDomain']

@pulumi.input_type
class AppHostingDomainArgs:
    def __init__(__self__, *,
                 backend: pulumi.Input[builtins.str],
                 domain_id: pulumi.Input[builtins.str],
                 location: pulumi.Input[builtins.str],
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 serve: Optional[pulumi.Input['AppHostingDomainServeArgs']] = None):
        """
        The set of arguments for constructing a AppHostingDomain resource.
        :param pulumi.Input[builtins.str] backend: The ID of the Backend that this Domain is associated with
        :param pulumi.Input[builtins.str] domain_id: Id of the domain to create.
               Must be a valid domain name, such as "foo.com"
               
               
               - - -
        :param pulumi.Input[builtins.str] location: The location of the Backend that this Domain is associated with
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['AppHostingDomainServeArgs'] serve: The serving behavior of the domain. If specified, the domain will
               serve content other than its Backend's live content.
               Structure is documented below.
        """
        pulumi.set(__self__, "backend", backend)
        pulumi.set(__self__, "domain_id", domain_id)
        pulumi.set(__self__, "location", location)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if serve is not None:
            pulumi.set(__self__, "serve", serve)

    @property
    @pulumi.getter
    def backend(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Backend that this Domain is associated with
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "backend", value)

    @property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> pulumi.Input[builtins.str]:
        """
        Id of the domain to create.
        Must be a valid domain name, such as "foo.com"


        - - -
        """
        return pulumi.get(self, "domain_id")

    @domain_id.setter
    def domain_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "domain_id", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        The location of the Backend that this Domain is associated with
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def serve(self) -> Optional[pulumi.Input['AppHostingDomainServeArgs']]:
        """
        The serving behavior of the domain. If specified, the domain will
        serve content other than its Backend's live content.
        Structure is documented below.
        """
        return pulumi.get(self, "serve")

    @serve.setter
    def serve(self, value: Optional[pulumi.Input['AppHostingDomainServeArgs']]):
        pulumi.set(self, "serve", value)


@pulumi.input_type
class _AppHostingDomainState:
    def __init__(__self__, *,
                 backend: Optional[pulumi.Input[builtins.str]] = None,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 custom_domain_statuses: Optional[pulumi.Input[Sequence[pulumi.Input['AppHostingDomainCustomDomainStatusArgs']]]] = None,
                 delete_time: Optional[pulumi.Input[builtins.str]] = None,
                 domain_id: Optional[pulumi.Input[builtins.str]] = None,
                 etag: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 purge_time: Optional[pulumi.Input[builtins.str]] = None,
                 serve: Optional[pulumi.Input['AppHostingDomainServeArgs']] = None,
                 uid: Optional[pulumi.Input[builtins.str]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering AppHostingDomain resources.
        :param pulumi.Input[builtins.str] backend: The ID of the Backend that this Domain is associated with
        :param pulumi.Input[builtins.str] create_time: Time at which the domain was created.
        :param pulumi.Input[Sequence[pulumi.Input['AppHostingDomainCustomDomainStatusArgs']]] custom_domain_statuses: The status of a custom domain's linkage to the Backend.
               Structure is documented below.
        :param pulumi.Input[builtins.str] delete_time: Time at which the domain was deleted.
        :param pulumi.Input[builtins.str] domain_id: Id of the domain to create.
               Must be a valid domain name, such as "foo.com"
               
               
               - - -
        :param pulumi.Input[builtins.str] etag: Server-computed checksum based on other values; may be sent
               on update or delete to ensure operation is done on expected resource.
        :param pulumi.Input[builtins.str] location: The location of the Backend that this Domain is associated with
        :param pulumi.Input[builtins.str] name: Identifier. The resource name of the domain, e.g.
               `projects/{project}/locations/{locationId}/backends/{backendId}/domains/{domainId}`
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] purge_time: Time at which a soft-deleted domain will be purged, rendering in
               permanently deleted.
        :param pulumi.Input['AppHostingDomainServeArgs'] serve: The serving behavior of the domain. If specified, the domain will
               serve content other than its Backend's live content.
               Structure is documented below.
        :param pulumi.Input[builtins.str] uid: System-assigned, unique identifier.
        :param pulumi.Input[builtins.str] update_time: Time at which the domain was last updated.
        """
        if backend is not None:
            pulumi.set(__self__, "backend", backend)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if custom_domain_statuses is not None:
            pulumi.set(__self__, "custom_domain_statuses", custom_domain_statuses)
        if delete_time is not None:
            pulumi.set(__self__, "delete_time", delete_time)
        if domain_id is not None:
            pulumi.set(__self__, "domain_id", domain_id)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if purge_time is not None:
            pulumi.set(__self__, "purge_time", purge_time)
        if serve is not None:
            pulumi.set(__self__, "serve", serve)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter
    def backend(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Backend that this Domain is associated with
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "backend", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Time at which the domain was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="customDomainStatuses")
    def custom_domain_statuses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppHostingDomainCustomDomainStatusArgs']]]]:
        """
        The status of a custom domain's linkage to the Backend.
        Structure is documented below.
        """
        return pulumi.get(self, "custom_domain_statuses")

    @custom_domain_statuses.setter
    def custom_domain_statuses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppHostingDomainCustomDomainStatusArgs']]]]):
        pulumi.set(self, "custom_domain_statuses", value)

    @property
    @pulumi.getter(name="deleteTime")
    def delete_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Time at which the domain was deleted.
        """
        return pulumi.get(self, "delete_time")

    @delete_time.setter
    def delete_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "delete_time", value)

    @property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Id of the domain to create.
        Must be a valid domain name, such as "foo.com"


        - - -
        """
        return pulumi.get(self, "domain_id")

    @domain_id.setter
    def domain_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "domain_id", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Server-computed checksum based on other values; may be sent
        on update or delete to ensure operation is done on expected resource.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location of the Backend that this Domain is associated with
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier. The resource name of the domain, e.g.
        `projects/{project}/locations/{locationId}/backends/{backendId}/domains/{domainId}`
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="purgeTime")
    def purge_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Time at which a soft-deleted domain will be purged, rendering in
        permanently deleted.
        """
        return pulumi.get(self, "purge_time")

    @purge_time.setter
    def purge_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "purge_time", value)

    @property
    @pulumi.getter
    def serve(self) -> Optional[pulumi.Input['AppHostingDomainServeArgs']]:
        """
        The serving behavior of the domain. If specified, the domain will
        serve content other than its Backend's live content.
        Structure is documented below.
        """
        return pulumi.get(self, "serve")

    @serve.setter
    def serve(self, value: Optional[pulumi.Input['AppHostingDomainServeArgs']]):
        pulumi.set(self, "serve", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        System-assigned, unique identifier.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "uid", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Time at which the domain was last updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:firebase/appHostingDomain:AppHostingDomain")
class AppHostingDomain(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backend: Optional[pulumi.Input[builtins.str]] = None,
                 domain_id: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 serve: Optional[pulumi.Input[Union['AppHostingDomainServeArgs', 'AppHostingDomainServeArgsDict']]] = None,
                 __props__=None):
        """
        A domain name that is associated with a backend.

        ## Example Usage

        ### Firebase App Hosting Domain Minimal

        ```python
        import pulumi
        import pulumi_gcp as gcp

        service_account = gcp.serviceaccount.Account("service_account",
            project="my-project-name",
            account_id="sa-id",
            display_name="Firebase App Hosting compute service account",
            create_ignore_already_exists=True)
        example_app_hosting_backend = gcp.firebase.AppHostingBackend("example",
            project="my-project-name",
            location="us-central1",
            backend_id="domain-mini",
            app_id="1:0000000000:web:674cde32020e16fbce9dbd",
            serving_locality="GLOBAL_ACCESS",
            service_account=service_account.email)
        example = gcp.firebase.AppHostingDomain("example",
            project=example_app_hosting_backend.project,
            location=example_app_hosting_backend.location,
            backend=example_app_hosting_backend.backend_id,
            domain_id="example.com")
        ```
        ### Firebase App Hosting Domain Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        service_account = gcp.serviceaccount.Account("service_account",
            project="my-project-name",
            account_id="sa-id",
            display_name="Firebase App Hosting compute service account",
            create_ignore_already_exists=True)
        example_app_hosting_backend = gcp.firebase.AppHostingBackend("example",
            project="my-project-name",
            location="us-central1",
            backend_id="domain-full",
            app_id="1:0000000000:web:674cde32020e16fbce9dbd",
            serving_locality="GLOBAL_ACCESS",
            service_account=service_account.email)
        example = gcp.firebase.AppHostingDomain("example",
            project=example_app_hosting_backend.project,
            location=example_app_hosting_backend.location,
            backend=example_app_hosting_backend.backend_id,
            domain_id="example.com",
            serve={
                "redirect": {
                    "uri": "google.com",
                    "status": "302",
                },
            })
        ```

        ## Import

        Domain can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/backends/{{backend}}/domains/{{domain_id}}`

        * `{{project}}/{{location}}/{{backend}}/{{domain_id}}`

        * `{{location}}/{{backend}}/{{domain_id}}`

        When using the `pulumi import` command, Domain can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:firebase/appHostingDomain:AppHostingDomain default projects/{{project}}/locations/{{location}}/backends/{{backend}}/domains/{{domain_id}}
        ```

        ```sh
        $ pulumi import gcp:firebase/appHostingDomain:AppHostingDomain default {{project}}/{{location}}/{{backend}}/{{domain_id}}
        ```

        ```sh
        $ pulumi import gcp:firebase/appHostingDomain:AppHostingDomain default {{location}}/{{backend}}/{{domain_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] backend: The ID of the Backend that this Domain is associated with
        :param pulumi.Input[builtins.str] domain_id: Id of the domain to create.
               Must be a valid domain name, such as "foo.com"
               
               
               - - -
        :param pulumi.Input[builtins.str] location: The location of the Backend that this Domain is associated with
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['AppHostingDomainServeArgs', 'AppHostingDomainServeArgsDict']] serve: The serving behavior of the domain. If specified, the domain will
               serve content other than its Backend's live content.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AppHostingDomainArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A domain name that is associated with a backend.

        ## Example Usage

        ### Firebase App Hosting Domain Minimal

        ```python
        import pulumi
        import pulumi_gcp as gcp

        service_account = gcp.serviceaccount.Account("service_account",
            project="my-project-name",
            account_id="sa-id",
            display_name="Firebase App Hosting compute service account",
            create_ignore_already_exists=True)
        example_app_hosting_backend = gcp.firebase.AppHostingBackend("example",
            project="my-project-name",
            location="us-central1",
            backend_id="domain-mini",
            app_id="1:0000000000:web:674cde32020e16fbce9dbd",
            serving_locality="GLOBAL_ACCESS",
            service_account=service_account.email)
        example = gcp.firebase.AppHostingDomain("example",
            project=example_app_hosting_backend.project,
            location=example_app_hosting_backend.location,
            backend=example_app_hosting_backend.backend_id,
            domain_id="example.com")
        ```
        ### Firebase App Hosting Domain Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        service_account = gcp.serviceaccount.Account("service_account",
            project="my-project-name",
            account_id="sa-id",
            display_name="Firebase App Hosting compute service account",
            create_ignore_already_exists=True)
        example_app_hosting_backend = gcp.firebase.AppHostingBackend("example",
            project="my-project-name",
            location="us-central1",
            backend_id="domain-full",
            app_id="1:0000000000:web:674cde32020e16fbce9dbd",
            serving_locality="GLOBAL_ACCESS",
            service_account=service_account.email)
        example = gcp.firebase.AppHostingDomain("example",
            project=example_app_hosting_backend.project,
            location=example_app_hosting_backend.location,
            backend=example_app_hosting_backend.backend_id,
            domain_id="example.com",
            serve={
                "redirect": {
                    "uri": "google.com",
                    "status": "302",
                },
            })
        ```

        ## Import

        Domain can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/backends/{{backend}}/domains/{{domain_id}}`

        * `{{project}}/{{location}}/{{backend}}/{{domain_id}}`

        * `{{location}}/{{backend}}/{{domain_id}}`

        When using the `pulumi import` command, Domain can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:firebase/appHostingDomain:AppHostingDomain default projects/{{project}}/locations/{{location}}/backends/{{backend}}/domains/{{domain_id}}
        ```

        ```sh
        $ pulumi import gcp:firebase/appHostingDomain:AppHostingDomain default {{project}}/{{location}}/{{backend}}/{{domain_id}}
        ```

        ```sh
        $ pulumi import gcp:firebase/appHostingDomain:AppHostingDomain default {{location}}/{{backend}}/{{domain_id}}
        ```

        :param str resource_name: The name of the resource.
        :param AppHostingDomainArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AppHostingDomainArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backend: Optional[pulumi.Input[builtins.str]] = None,
                 domain_id: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 serve: Optional[pulumi.Input[Union['AppHostingDomainServeArgs', 'AppHostingDomainServeArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AppHostingDomainArgs.__new__(AppHostingDomainArgs)

            if backend is None and not opts.urn:
                raise TypeError("Missing required property 'backend'")
            __props__.__dict__["backend"] = backend
            if domain_id is None and not opts.urn:
                raise TypeError("Missing required property 'domain_id'")
            __props__.__dict__["domain_id"] = domain_id
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            __props__.__dict__["serve"] = serve
            __props__.__dict__["create_time"] = None
            __props__.__dict__["custom_domain_statuses"] = None
            __props__.__dict__["delete_time"] = None
            __props__.__dict__["etag"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["purge_time"] = None
            __props__.__dict__["uid"] = None
            __props__.__dict__["update_time"] = None
        super(AppHostingDomain, __self__).__init__(
            'gcp:firebase/appHostingDomain:AppHostingDomain',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backend: Optional[pulumi.Input[builtins.str]] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            custom_domain_statuses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AppHostingDomainCustomDomainStatusArgs', 'AppHostingDomainCustomDomainStatusArgsDict']]]]] = None,
            delete_time: Optional[pulumi.Input[builtins.str]] = None,
            domain_id: Optional[pulumi.Input[builtins.str]] = None,
            etag: Optional[pulumi.Input[builtins.str]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            purge_time: Optional[pulumi.Input[builtins.str]] = None,
            serve: Optional[pulumi.Input[Union['AppHostingDomainServeArgs', 'AppHostingDomainServeArgsDict']]] = None,
            uid: Optional[pulumi.Input[builtins.str]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None) -> 'AppHostingDomain':
        """
        Get an existing AppHostingDomain resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] backend: The ID of the Backend that this Domain is associated with
        :param pulumi.Input[builtins.str] create_time: Time at which the domain was created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AppHostingDomainCustomDomainStatusArgs', 'AppHostingDomainCustomDomainStatusArgsDict']]]] custom_domain_statuses: The status of a custom domain's linkage to the Backend.
               Structure is documented below.
        :param pulumi.Input[builtins.str] delete_time: Time at which the domain was deleted.
        :param pulumi.Input[builtins.str] domain_id: Id of the domain to create.
               Must be a valid domain name, such as "foo.com"
               
               
               - - -
        :param pulumi.Input[builtins.str] etag: Server-computed checksum based on other values; may be sent
               on update or delete to ensure operation is done on expected resource.
        :param pulumi.Input[builtins.str] location: The location of the Backend that this Domain is associated with
        :param pulumi.Input[builtins.str] name: Identifier. The resource name of the domain, e.g.
               `projects/{project}/locations/{locationId}/backends/{backendId}/domains/{domainId}`
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] purge_time: Time at which a soft-deleted domain will be purged, rendering in
               permanently deleted.
        :param pulumi.Input[Union['AppHostingDomainServeArgs', 'AppHostingDomainServeArgsDict']] serve: The serving behavior of the domain. If specified, the domain will
               serve content other than its Backend's live content.
               Structure is documented below.
        :param pulumi.Input[builtins.str] uid: System-assigned, unique identifier.
        :param pulumi.Input[builtins.str] update_time: Time at which the domain was last updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AppHostingDomainState.__new__(_AppHostingDomainState)

        __props__.__dict__["backend"] = backend
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["custom_domain_statuses"] = custom_domain_statuses
        __props__.__dict__["delete_time"] = delete_time
        __props__.__dict__["domain_id"] = domain_id
        __props__.__dict__["etag"] = etag
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["purge_time"] = purge_time
        __props__.__dict__["serve"] = serve
        __props__.__dict__["uid"] = uid
        __props__.__dict__["update_time"] = update_time
        return AppHostingDomain(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def backend(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Backend that this Domain is associated with
        """
        return pulumi.get(self, "backend")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        Time at which the domain was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="customDomainStatuses")
    def custom_domain_statuses(self) -> pulumi.Output[Sequence['outputs.AppHostingDomainCustomDomainStatus']]:
        """
        The status of a custom domain's linkage to the Backend.
        Structure is documented below.
        """
        return pulumi.get(self, "custom_domain_statuses")

    @property
    @pulumi.getter(name="deleteTime")
    def delete_time(self) -> pulumi.Output[builtins.str]:
        """
        Time at which the domain was deleted.
        """
        return pulumi.get(self, "delete_time")

    @property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> pulumi.Output[builtins.str]:
        """
        Id of the domain to create.
        Must be a valid domain name, such as "foo.com"


        - - -
        """
        return pulumi.get(self, "domain_id")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[builtins.str]:
        """
        Server-computed checksum based on other values; may be sent
        on update or delete to ensure operation is done on expected resource.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The location of the Backend that this Domain is associated with
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Identifier. The resource name of the domain, e.g.
        `projects/{project}/locations/{locationId}/backends/{backendId}/domains/{domainId}`
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="purgeTime")
    def purge_time(self) -> pulumi.Output[builtins.str]:
        """
        Time at which a soft-deleted domain will be purged, rendering in
        permanently deleted.
        """
        return pulumi.get(self, "purge_time")

    @property
    @pulumi.getter
    def serve(self) -> pulumi.Output[Optional['outputs.AppHostingDomainServe']]:
        """
        The serving behavior of the domain. If specified, the domain will
        serve content other than its Backend's live content.
        Structure is documented below.
        """
        return pulumi.get(self, "serve")

    @property
    @pulumi.getter
    def uid(self) -> pulumi.Output[builtins.str]:
        """
        System-assigned, unique identifier.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        Time at which the domain was last updated.
        """
        return pulumi.get(self, "update_time")

