# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AppHostingTrafficArgs', 'AppHostingTraffic']

@pulumi.input_type
class AppHostingTrafficArgs:
    def __init__(__self__, *,
                 backend: pulumi.Input[builtins.str],
                 location: pulumi.Input[builtins.str],
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 rollout_policy: Optional[pulumi.Input['AppHostingTrafficRolloutPolicyArgs']] = None,
                 target: Optional[pulumi.Input['AppHostingTrafficTargetArgs']] = None):
        """
        The set of arguments for constructing a AppHostingTraffic resource.
        :param pulumi.Input[builtins.str] backend: Id of the backend that this Traffic config applies to
               
               
               - - -
        :param pulumi.Input[builtins.str] location: The location the Backend that this Traffic config applies to
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['AppHostingTrafficRolloutPolicyArgs'] rollout_policy: The policy for how builds and rollouts are triggered and rolled out.
               Structure is documented below.
        :param pulumi.Input['AppHostingTrafficTargetArgs'] target: Set to manually control the desired traffic for the backend. This will
               cause current to eventually match this value. The percentages must add
               up to 100.
               Structure is documented below.
        """
        pulumi.set(__self__, "backend", backend)
        pulumi.set(__self__, "location", location)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if rollout_policy is not None:
            pulumi.set(__self__, "rollout_policy", rollout_policy)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter
    def backend(self) -> pulumi.Input[builtins.str]:
        """
        Id of the backend that this Traffic config applies to


        - - -
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "backend", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        The location the Backend that this Traffic config applies to
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="rolloutPolicy")
    def rollout_policy(self) -> Optional[pulumi.Input['AppHostingTrafficRolloutPolicyArgs']]:
        """
        The policy for how builds and rollouts are triggered and rolled out.
        Structure is documented below.
        """
        return pulumi.get(self, "rollout_policy")

    @rollout_policy.setter
    def rollout_policy(self, value: Optional[pulumi.Input['AppHostingTrafficRolloutPolicyArgs']]):
        pulumi.set(self, "rollout_policy", value)

    @property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input['AppHostingTrafficTargetArgs']]:
        """
        Set to manually control the desired traffic for the backend. This will
        cause current to eventually match this value. The percentages must add
        up to 100.
        Structure is documented below.
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input['AppHostingTrafficTargetArgs']]):
        pulumi.set(self, "target", value)


@pulumi.input_type
class _AppHostingTrafficState:
    def __init__(__self__, *,
                 backend: Optional[pulumi.Input[builtins.str]] = None,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 currents: Optional[pulumi.Input[Sequence[pulumi.Input['AppHostingTrafficCurrentArgs']]]] = None,
                 delete_time: Optional[pulumi.Input[builtins.str]] = None,
                 etag: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 rollout_policy: Optional[pulumi.Input['AppHostingTrafficRolloutPolicyArgs']] = None,
                 target: Optional[pulumi.Input['AppHostingTrafficTargetArgs']] = None,
                 uid: Optional[pulumi.Input[builtins.str]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering AppHostingTraffic resources.
        :param pulumi.Input[builtins.str] backend: Id of the backend that this Traffic config applies to
               
               
               - - -
        :param pulumi.Input[builtins.str] create_time: Time at which the backend was created.
        :param pulumi.Input[Sequence[pulumi.Input['AppHostingTrafficCurrentArgs']]] currents: Current state of traffic allocation for the backend.
               When setting `target`, this field may differ for some time until the desired state is reached.
               Structure is documented below.
        :param pulumi.Input[builtins.str] delete_time: Time at which the backend was deleted.
        :param pulumi.Input[builtins.str] etag: Server-computed checksum based on other values; may be sent
               on update or delete to ensure operation is done on expected resource.
        :param pulumi.Input[builtins.str] location: The location the Backend that this Traffic config applies to
        :param pulumi.Input[builtins.str] name: Identifier. The resource name of the backend traffic config
               Format:
               `projects/{project}/locations/{locationId}/backends/{backendId}/traffic`.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['AppHostingTrafficRolloutPolicyArgs'] rollout_policy: The policy for how builds and rollouts are triggered and rolled out.
               Structure is documented below.
        :param pulumi.Input['AppHostingTrafficTargetArgs'] target: Set to manually control the desired traffic for the backend. This will
               cause current to eventually match this value. The percentages must add
               up to 100.
               Structure is documented below.
        :param pulumi.Input[builtins.str] uid: System-assigned, unique identifier.
        :param pulumi.Input[builtins.str] update_time: Time at which the backend was last updated.
        """
        if backend is not None:
            pulumi.set(__self__, "backend", backend)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if currents is not None:
            pulumi.set(__self__, "currents", currents)
        if delete_time is not None:
            pulumi.set(__self__, "delete_time", delete_time)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if rollout_policy is not None:
            pulumi.set(__self__, "rollout_policy", rollout_policy)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter
    def backend(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Id of the backend that this Traffic config applies to


        - - -
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "backend", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Time at which the backend was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def currents(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppHostingTrafficCurrentArgs']]]]:
        """
        Current state of traffic allocation for the backend.
        When setting `target`, this field may differ for some time until the desired state is reached.
        Structure is documented below.
        """
        return pulumi.get(self, "currents")

    @currents.setter
    def currents(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppHostingTrafficCurrentArgs']]]]):
        pulumi.set(self, "currents", value)

    @property
    @pulumi.getter(name="deleteTime")
    def delete_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Time at which the backend was deleted.
        """
        return pulumi.get(self, "delete_time")

    @delete_time.setter
    def delete_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "delete_time", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Server-computed checksum based on other values; may be sent
        on update or delete to ensure operation is done on expected resource.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location the Backend that this Traffic config applies to
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier. The resource name of the backend traffic config
        Format:
        `projects/{project}/locations/{locationId}/backends/{backendId}/traffic`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="rolloutPolicy")
    def rollout_policy(self) -> Optional[pulumi.Input['AppHostingTrafficRolloutPolicyArgs']]:
        """
        The policy for how builds and rollouts are triggered and rolled out.
        Structure is documented below.
        """
        return pulumi.get(self, "rollout_policy")

    @rollout_policy.setter
    def rollout_policy(self, value: Optional[pulumi.Input['AppHostingTrafficRolloutPolicyArgs']]):
        pulumi.set(self, "rollout_policy", value)

    @property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input['AppHostingTrafficTargetArgs']]:
        """
        Set to manually control the desired traffic for the backend. This will
        cause current to eventually match this value. The percentages must add
        up to 100.
        Structure is documented below.
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input['AppHostingTrafficTargetArgs']]):
        pulumi.set(self, "target", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        System-assigned, unique identifier.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "uid", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Time at which the backend was last updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:firebase/appHostingTraffic:AppHostingTraffic")
class AppHostingTraffic(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backend: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 rollout_policy: Optional[pulumi.Input[Union['AppHostingTrafficRolloutPolicyArgs', 'AppHostingTrafficRolloutPolicyArgsDict']]] = None,
                 target: Optional[pulumi.Input[Union['AppHostingTrafficTargetArgs', 'AppHostingTrafficTargetArgsDict']]] = None,
                 __props__=None):
        """
        Controls traffic configuration for a backend.

        ## Example Usage

        ### Firebase App Hosting Traffic Target

        ```python
        import pulumi
        import pulumi_gcp as gcp

        ### Include these blocks only once per project if you are starting from scratch ###
        service_account = gcp.serviceaccount.Account("service_account",
            project="my-project-name",
            account_id="firebase-app-hosting-compute",
            display_name="Firebase App Hosting compute service account",
            create_ignore_already_exists=True)
        fah = gcp.projects.Service("fah",
            project="my-project-name",
            service="firebaseapphosting.googleapis.com",
            disable_on_destroy=False)
        example_app_hosting_backend = gcp.firebase.AppHostingBackend("example",
            project="my-project-name",
            location="asia-east1",
            backend_id="traffic-tg",
            app_id="1:0000000000:web:674cde32020e16fbce9dbd",
            serving_locality="GLOBAL_ACCESS",
            service_account=service_account.email,
            opts = pulumi.ResourceOptions(depends_on=[fah]))
        example_app_hosting_build = gcp.firebase.AppHostingBuild("example",
            project=example_app_hosting_backend.project,
            location=example_app_hosting_backend.location,
            backend=example_app_hosting_backend.backend_id,
            build_id="target-build",
            source={
                "container": {
                    "image": "us-docker.pkg.dev/cloudrun/container/hello",
                },
            })
        example = gcp.firebase.AppHostingTraffic("example",
            project=example_app_hosting_backend.project,
            location=example_app_hosting_backend.location,
            backend=example_app_hosting_backend.backend_id,
            target={
                "splits": [{
                    "build": example_app_hosting_build.name,
                    "percent": 100,
                }],
            })
        app_hosting_sa_runner = gcp.projects.IAMMember("app_hosting_sa_runner",
            project="my-project-name",
            role="roles/firebaseapphosting.computeRunner",
            member=service_account.member)
        ```
        ### Firebase App Hosting Traffic Rollout Policy

        ```python
        import pulumi
        import pulumi_gcp as gcp

        ### Include these blocks only once per project if you are starting from scratch ###
        service_account = gcp.serviceaccount.Account("service_account",
            project="my-project-name",
            account_id="firebase-app-hosting-compute",
            display_name="Firebase App Hosting compute service account",
            create_ignore_already_exists=True)
        fah = gcp.projects.Service("fah",
            project="my-project-name",
            service="firebaseapphosting.googleapis.com",
            disable_on_destroy=False)
        example_app_hosting_backend = gcp.firebase.AppHostingBackend("example",
            project="my-project-name",
            location="asia-east1",
            backend_id="traffic-rp",
            app_id="1:0000000000:web:674cde32020e16fbce9dbd",
            serving_locality="GLOBAL_ACCESS",
            service_account=service_account.email,
            opts = pulumi.ResourceOptions(depends_on=[fah]))
        example = gcp.firebase.AppHostingTraffic("example",
            project=example_app_hosting_backend.project,
            location=example_app_hosting_backend.location,
            backend=example_app_hosting_backend.backend_id,
            rollout_policy={
                "codebase_branch": "main",
            })
        app_hosting_sa_runner = gcp.projects.IAMMember("app_hosting_sa_runner",
            project="my-project-name",
            role="roles/firebaseapphosting.computeRunner",
            member=service_account.member)
        ```
        ### Firebase App Hosting Traffic Rollout Policy Disabled

        ```python
        import pulumi
        import pulumi_gcp as gcp

        ### Include these blocks only once per project if you are starting from scratch ###
        service_account = gcp.serviceaccount.Account("service_account",
            project="my-project-name",
            account_id="firebase-app-hosting-compute",
            display_name="Firebase App Hosting compute service account",
            create_ignore_already_exists=True)
        fah = gcp.projects.Service("fah",
            project="my-project-name",
            service="firebaseapphosting.googleapis.com",
            disable_on_destroy=False)
        example_app_hosting_backend = gcp.firebase.AppHostingBackend("example",
            project="my-project-name",
            location="asia-east1",
            backend_id="traffic-rpd",
            app_id="1:0000000000:web:674cde32020e16fbce9dbd",
            serving_locality="GLOBAL_ACCESS",
            service_account=service_account.email,
            opts = pulumi.ResourceOptions(depends_on=[fah]))
        example = gcp.firebase.AppHostingTraffic("example",
            project=example_app_hosting_backend.project,
            location=example_app_hosting_backend.location,
            backend=example_app_hosting_backend.backend_id,
            rollout_policy={
                "disabled": True,
                "codebase_branch": "main",
            })
        app_hosting_sa_runner = gcp.projects.IAMMember("app_hosting_sa_runner",
            project="my-project-name",
            role="roles/firebaseapphosting.computeRunner",
            member=service_account.member)
        ```

        ## Import

        Traffic can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/backends/{{backend}}/traffic`

        * `{{project}}/{{location}}/{{backend}}`

        * `{{location}}/{{backend}}`

        When using the `pulumi import` command, Traffic can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:firebase/appHostingTraffic:AppHostingTraffic default projects/{{project}}/locations/{{location}}/backends/{{backend}}/traffic
        ```

        ```sh
        $ pulumi import gcp:firebase/appHostingTraffic:AppHostingTraffic default {{project}}/{{location}}/{{backend}}
        ```

        ```sh
        $ pulumi import gcp:firebase/appHostingTraffic:AppHostingTraffic default {{location}}/{{backend}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] backend: Id of the backend that this Traffic config applies to
               
               
               - - -
        :param pulumi.Input[builtins.str] location: The location the Backend that this Traffic config applies to
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['AppHostingTrafficRolloutPolicyArgs', 'AppHostingTrafficRolloutPolicyArgsDict']] rollout_policy: The policy for how builds and rollouts are triggered and rolled out.
               Structure is documented below.
        :param pulumi.Input[Union['AppHostingTrafficTargetArgs', 'AppHostingTrafficTargetArgsDict']] target: Set to manually control the desired traffic for the backend. This will
               cause current to eventually match this value. The percentages must add
               up to 100.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AppHostingTrafficArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Controls traffic configuration for a backend.

        ## Example Usage

        ### Firebase App Hosting Traffic Target

        ```python
        import pulumi
        import pulumi_gcp as gcp

        ### Include these blocks only once per project if you are starting from scratch ###
        service_account = gcp.serviceaccount.Account("service_account",
            project="my-project-name",
            account_id="firebase-app-hosting-compute",
            display_name="Firebase App Hosting compute service account",
            create_ignore_already_exists=True)
        fah = gcp.projects.Service("fah",
            project="my-project-name",
            service="firebaseapphosting.googleapis.com",
            disable_on_destroy=False)
        example_app_hosting_backend = gcp.firebase.AppHostingBackend("example",
            project="my-project-name",
            location="asia-east1",
            backend_id="traffic-tg",
            app_id="1:0000000000:web:674cde32020e16fbce9dbd",
            serving_locality="GLOBAL_ACCESS",
            service_account=service_account.email,
            opts = pulumi.ResourceOptions(depends_on=[fah]))
        example_app_hosting_build = gcp.firebase.AppHostingBuild("example",
            project=example_app_hosting_backend.project,
            location=example_app_hosting_backend.location,
            backend=example_app_hosting_backend.backend_id,
            build_id="target-build",
            source={
                "container": {
                    "image": "us-docker.pkg.dev/cloudrun/container/hello",
                },
            })
        example = gcp.firebase.AppHostingTraffic("example",
            project=example_app_hosting_backend.project,
            location=example_app_hosting_backend.location,
            backend=example_app_hosting_backend.backend_id,
            target={
                "splits": [{
                    "build": example_app_hosting_build.name,
                    "percent": 100,
                }],
            })
        app_hosting_sa_runner = gcp.projects.IAMMember("app_hosting_sa_runner",
            project="my-project-name",
            role="roles/firebaseapphosting.computeRunner",
            member=service_account.member)
        ```
        ### Firebase App Hosting Traffic Rollout Policy

        ```python
        import pulumi
        import pulumi_gcp as gcp

        ### Include these blocks only once per project if you are starting from scratch ###
        service_account = gcp.serviceaccount.Account("service_account",
            project="my-project-name",
            account_id="firebase-app-hosting-compute",
            display_name="Firebase App Hosting compute service account",
            create_ignore_already_exists=True)
        fah = gcp.projects.Service("fah",
            project="my-project-name",
            service="firebaseapphosting.googleapis.com",
            disable_on_destroy=False)
        example_app_hosting_backend = gcp.firebase.AppHostingBackend("example",
            project="my-project-name",
            location="asia-east1",
            backend_id="traffic-rp",
            app_id="1:0000000000:web:674cde32020e16fbce9dbd",
            serving_locality="GLOBAL_ACCESS",
            service_account=service_account.email,
            opts = pulumi.ResourceOptions(depends_on=[fah]))
        example = gcp.firebase.AppHostingTraffic("example",
            project=example_app_hosting_backend.project,
            location=example_app_hosting_backend.location,
            backend=example_app_hosting_backend.backend_id,
            rollout_policy={
                "codebase_branch": "main",
            })
        app_hosting_sa_runner = gcp.projects.IAMMember("app_hosting_sa_runner",
            project="my-project-name",
            role="roles/firebaseapphosting.computeRunner",
            member=service_account.member)
        ```
        ### Firebase App Hosting Traffic Rollout Policy Disabled

        ```python
        import pulumi
        import pulumi_gcp as gcp

        ### Include these blocks only once per project if you are starting from scratch ###
        service_account = gcp.serviceaccount.Account("service_account",
            project="my-project-name",
            account_id="firebase-app-hosting-compute",
            display_name="Firebase App Hosting compute service account",
            create_ignore_already_exists=True)
        fah = gcp.projects.Service("fah",
            project="my-project-name",
            service="firebaseapphosting.googleapis.com",
            disable_on_destroy=False)
        example_app_hosting_backend = gcp.firebase.AppHostingBackend("example",
            project="my-project-name",
            location="asia-east1",
            backend_id="traffic-rpd",
            app_id="1:0000000000:web:674cde32020e16fbce9dbd",
            serving_locality="GLOBAL_ACCESS",
            service_account=service_account.email,
            opts = pulumi.ResourceOptions(depends_on=[fah]))
        example = gcp.firebase.AppHostingTraffic("example",
            project=example_app_hosting_backend.project,
            location=example_app_hosting_backend.location,
            backend=example_app_hosting_backend.backend_id,
            rollout_policy={
                "disabled": True,
                "codebase_branch": "main",
            })
        app_hosting_sa_runner = gcp.projects.IAMMember("app_hosting_sa_runner",
            project="my-project-name",
            role="roles/firebaseapphosting.computeRunner",
            member=service_account.member)
        ```

        ## Import

        Traffic can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/backends/{{backend}}/traffic`

        * `{{project}}/{{location}}/{{backend}}`

        * `{{location}}/{{backend}}`

        When using the `pulumi import` command, Traffic can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:firebase/appHostingTraffic:AppHostingTraffic default projects/{{project}}/locations/{{location}}/backends/{{backend}}/traffic
        ```

        ```sh
        $ pulumi import gcp:firebase/appHostingTraffic:AppHostingTraffic default {{project}}/{{location}}/{{backend}}
        ```

        ```sh
        $ pulumi import gcp:firebase/appHostingTraffic:AppHostingTraffic default {{location}}/{{backend}}
        ```

        :param str resource_name: The name of the resource.
        :param AppHostingTrafficArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AppHostingTrafficArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backend: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 rollout_policy: Optional[pulumi.Input[Union['AppHostingTrafficRolloutPolicyArgs', 'AppHostingTrafficRolloutPolicyArgsDict']]] = None,
                 target: Optional[pulumi.Input[Union['AppHostingTrafficTargetArgs', 'AppHostingTrafficTargetArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AppHostingTrafficArgs.__new__(AppHostingTrafficArgs)

            if backend is None and not opts.urn:
                raise TypeError("Missing required property 'backend'")
            __props__.__dict__["backend"] = backend
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            __props__.__dict__["rollout_policy"] = rollout_policy
            __props__.__dict__["target"] = target
            __props__.__dict__["create_time"] = None
            __props__.__dict__["currents"] = None
            __props__.__dict__["delete_time"] = None
            __props__.__dict__["etag"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["uid"] = None
            __props__.__dict__["update_time"] = None
        super(AppHostingTraffic, __self__).__init__(
            'gcp:firebase/appHostingTraffic:AppHostingTraffic',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backend: Optional[pulumi.Input[builtins.str]] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            currents: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AppHostingTrafficCurrentArgs', 'AppHostingTrafficCurrentArgsDict']]]]] = None,
            delete_time: Optional[pulumi.Input[builtins.str]] = None,
            etag: Optional[pulumi.Input[builtins.str]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            rollout_policy: Optional[pulumi.Input[Union['AppHostingTrafficRolloutPolicyArgs', 'AppHostingTrafficRolloutPolicyArgsDict']]] = None,
            target: Optional[pulumi.Input[Union['AppHostingTrafficTargetArgs', 'AppHostingTrafficTargetArgsDict']]] = None,
            uid: Optional[pulumi.Input[builtins.str]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None) -> 'AppHostingTraffic':
        """
        Get an existing AppHostingTraffic resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] backend: Id of the backend that this Traffic config applies to
               
               
               - - -
        :param pulumi.Input[builtins.str] create_time: Time at which the backend was created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AppHostingTrafficCurrentArgs', 'AppHostingTrafficCurrentArgsDict']]]] currents: Current state of traffic allocation for the backend.
               When setting `target`, this field may differ for some time until the desired state is reached.
               Structure is documented below.
        :param pulumi.Input[builtins.str] delete_time: Time at which the backend was deleted.
        :param pulumi.Input[builtins.str] etag: Server-computed checksum based on other values; may be sent
               on update or delete to ensure operation is done on expected resource.
        :param pulumi.Input[builtins.str] location: The location the Backend that this Traffic config applies to
        :param pulumi.Input[builtins.str] name: Identifier. The resource name of the backend traffic config
               Format:
               `projects/{project}/locations/{locationId}/backends/{backendId}/traffic`.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['AppHostingTrafficRolloutPolicyArgs', 'AppHostingTrafficRolloutPolicyArgsDict']] rollout_policy: The policy for how builds and rollouts are triggered and rolled out.
               Structure is documented below.
        :param pulumi.Input[Union['AppHostingTrafficTargetArgs', 'AppHostingTrafficTargetArgsDict']] target: Set to manually control the desired traffic for the backend. This will
               cause current to eventually match this value. The percentages must add
               up to 100.
               Structure is documented below.
        :param pulumi.Input[builtins.str] uid: System-assigned, unique identifier.
        :param pulumi.Input[builtins.str] update_time: Time at which the backend was last updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AppHostingTrafficState.__new__(_AppHostingTrafficState)

        __props__.__dict__["backend"] = backend
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["currents"] = currents
        __props__.__dict__["delete_time"] = delete_time
        __props__.__dict__["etag"] = etag
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["rollout_policy"] = rollout_policy
        __props__.__dict__["target"] = target
        __props__.__dict__["uid"] = uid
        __props__.__dict__["update_time"] = update_time
        return AppHostingTraffic(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def backend(self) -> pulumi.Output[builtins.str]:
        """
        Id of the backend that this Traffic config applies to


        - - -
        """
        return pulumi.get(self, "backend")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        Time at which the backend was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def currents(self) -> pulumi.Output[Sequence['outputs.AppHostingTrafficCurrent']]:
        """
        Current state of traffic allocation for the backend.
        When setting `target`, this field may differ for some time until the desired state is reached.
        Structure is documented below.
        """
        return pulumi.get(self, "currents")

    @property
    @pulumi.getter(name="deleteTime")
    def delete_time(self) -> pulumi.Output[builtins.str]:
        """
        Time at which the backend was deleted.
        """
        return pulumi.get(self, "delete_time")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[builtins.str]:
        """
        Server-computed checksum based on other values; may be sent
        on update or delete to ensure operation is done on expected resource.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The location the Backend that this Traffic config applies to
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Identifier. The resource name of the backend traffic config
        Format:
        `projects/{project}/locations/{locationId}/backends/{backendId}/traffic`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="rolloutPolicy")
    def rollout_policy(self) -> pulumi.Output[Optional['outputs.AppHostingTrafficRolloutPolicy']]:
        """
        The policy for how builds and rollouts are triggered and rolled out.
        Structure is documented below.
        """
        return pulumi.get(self, "rollout_policy")

    @property
    @pulumi.getter
    def target(self) -> pulumi.Output[Optional['outputs.AppHostingTrafficTarget']]:
        """
        Set to manually control the desired traffic for the backend. This will
        cause current to eventually match this value. The percentages must add
        up to 100.
        Structure is documented below.
        """
        return pulumi.get(self, "target")

    @property
    @pulumi.getter
    def uid(self) -> pulumi.Output[builtins.str]:
        """
        System-assigned, unique identifier.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        Time at which the backend was last updated.
        """
        return pulumi.get(self, "update_time")

