# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DatabaseArgs', 'Database']

@pulumi.input_type
class DatabaseArgs:
    def __init__(__self__, *,
                 location_id: pulumi.Input[builtins.str],
                 type: pulumi.Input[builtins.str],
                 app_engine_integration_mode: Optional[pulumi.Input[builtins.str]] = None,
                 cmek_config: Optional[pulumi.Input['DatabaseCmekConfigArgs']] = None,
                 concurrency_mode: Optional[pulumi.Input[builtins.str]] = None,
                 database_edition: Optional[pulumi.Input[builtins.str]] = None,
                 delete_protection_state: Optional[pulumi.Input[builtins.str]] = None,
                 deletion_policy: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 point_in_time_recovery_enablement: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Database resource.
        :param pulumi.Input[builtins.str] location_id: The location of the database. Available locations are listed at
               https://cloud.google.com/firestore/docs/locations.
        :param pulumi.Input[builtins.str] type: The type of the database.
               See https://cloud.google.com/datastore/docs/firestore-or-datastore
               for information about how to choose.
               Possible values are: `FIRESTORE_NATIVE`, `DATASTORE_MODE`.
               
               
               - - -
        :param pulumi.Input[builtins.str] app_engine_integration_mode: The App Engine integration mode to use for this database.
               Possible values are: `ENABLED`, `DISABLED`.
        :param pulumi.Input['DatabaseCmekConfigArgs'] cmek_config: The CMEK (Customer Managed Encryption Key) configuration for a Firestore
               database. If not present, the database is secured by the default Google
               encryption key.
               Structure is documented below.
        :param pulumi.Input[builtins.str] concurrency_mode: The concurrency control mode to use for this database.
               Possible values are: `OPTIMISTIC`, `PESSIMISTIC`, `OPTIMISTIC_WITH_ENTITY_GROUPS`.
        :param pulumi.Input[builtins.str] database_edition: The database edition.
               Possible values are: `STANDARD`, `ENTERPRISE`.
        :param pulumi.Input[builtins.str] name: The ID to use for the database, which will become the final
               component of the database's resource name. This value should be 4-63
               characters. Valid characters are /[a-z][0-9]-/ with first character
               a letter and the last a letter or a number. Must not be
               UUID-like /[0-9a-f]{8}(-[0-9a-f]{4}){3}-[0-9a-f]{12}/.
               "(default)" database id is also valid.
        :param pulumi.Input[builtins.str] point_in_time_recovery_enablement: Whether to enable the PITR feature on this database.
               If `POINT_IN_TIME_RECOVERY_ENABLED` is selected, reads are supported on selected versions of the data from within the past 7 days.
               versionRetentionPeriod and earliestVersionTime can be used to determine the supported versions. These include reads against any timestamp within the past hour
               and reads against 1-minute snapshots beyond 1 hour and within 7 days.
               If `POINT_IN_TIME_RECOVERY_DISABLED` is selected, reads are supported on any version of the data from within the past 1 hour.
               Default value is `POINT_IN_TIME_RECOVERY_DISABLED`.
               Possible values are: `POINT_IN_TIME_RECOVERY_ENABLED`, `POINT_IN_TIME_RECOVERY_DISABLED`.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "location_id", location_id)
        pulumi.set(__self__, "type", type)
        if app_engine_integration_mode is not None:
            pulumi.set(__self__, "app_engine_integration_mode", app_engine_integration_mode)
        if cmek_config is not None:
            pulumi.set(__self__, "cmek_config", cmek_config)
        if concurrency_mode is not None:
            pulumi.set(__self__, "concurrency_mode", concurrency_mode)
        if database_edition is not None:
            pulumi.set(__self__, "database_edition", database_edition)
        if delete_protection_state is not None:
            pulumi.set(__self__, "delete_protection_state", delete_protection_state)
        if deletion_policy is not None:
            pulumi.set(__self__, "deletion_policy", deletion_policy)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if point_in_time_recovery_enablement is not None:
            pulumi.set(__self__, "point_in_time_recovery_enablement", point_in_time_recovery_enablement)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="locationId")
    def location_id(self) -> pulumi.Input[builtins.str]:
        """
        The location of the database. Available locations are listed at
        https://cloud.google.com/firestore/docs/locations.
        """
        return pulumi.get(self, "location_id")

    @location_id.setter
    def location_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location_id", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        The type of the database.
        See https://cloud.google.com/datastore/docs/firestore-or-datastore
        for information about how to choose.
        Possible values are: `FIRESTORE_NATIVE`, `DATASTORE_MODE`.


        - - -
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="appEngineIntegrationMode")
    def app_engine_integration_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The App Engine integration mode to use for this database.
        Possible values are: `ENABLED`, `DISABLED`.
        """
        return pulumi.get(self, "app_engine_integration_mode")

    @app_engine_integration_mode.setter
    def app_engine_integration_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "app_engine_integration_mode", value)

    @property
    @pulumi.getter(name="cmekConfig")
    def cmek_config(self) -> Optional[pulumi.Input['DatabaseCmekConfigArgs']]:
        """
        The CMEK (Customer Managed Encryption Key) configuration for a Firestore
        database. If not present, the database is secured by the default Google
        encryption key.
        Structure is documented below.
        """
        return pulumi.get(self, "cmek_config")

    @cmek_config.setter
    def cmek_config(self, value: Optional[pulumi.Input['DatabaseCmekConfigArgs']]):
        pulumi.set(self, "cmek_config", value)

    @property
    @pulumi.getter(name="concurrencyMode")
    def concurrency_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The concurrency control mode to use for this database.
        Possible values are: `OPTIMISTIC`, `PESSIMISTIC`, `OPTIMISTIC_WITH_ENTITY_GROUPS`.
        """
        return pulumi.get(self, "concurrency_mode")

    @concurrency_mode.setter
    def concurrency_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "concurrency_mode", value)

    @property
    @pulumi.getter(name="databaseEdition")
    def database_edition(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The database edition.
        Possible values are: `STANDARD`, `ENTERPRISE`.
        """
        return pulumi.get(self, "database_edition")

    @database_edition.setter
    def database_edition(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "database_edition", value)

    @property
    @pulumi.getter(name="deleteProtectionState")
    def delete_protection_state(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "delete_protection_state")

    @delete_protection_state.setter
    def delete_protection_state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "delete_protection_state", value)

    @property
    @pulumi.getter(name="deletionPolicy")
    def deletion_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "deletion_policy")

    @deletion_policy.setter
    def deletion_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "deletion_policy", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID to use for the database, which will become the final
        component of the database's resource name. This value should be 4-63
        characters. Valid characters are /[a-z][0-9]-/ with first character
        a letter and the last a letter or a number. Must not be
        UUID-like /[0-9a-f]{8}(-[0-9a-f]{4}){3}-[0-9a-f]{12}/.
        "(default)" database id is also valid.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="pointInTimeRecoveryEnablement")
    def point_in_time_recovery_enablement(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Whether to enable the PITR feature on this database.
        If `POINT_IN_TIME_RECOVERY_ENABLED` is selected, reads are supported on selected versions of the data from within the past 7 days.
        versionRetentionPeriod and earliestVersionTime can be used to determine the supported versions. These include reads against any timestamp within the past hour
        and reads against 1-minute snapshots beyond 1 hour and within 7 days.
        If `POINT_IN_TIME_RECOVERY_DISABLED` is selected, reads are supported on any version of the data from within the past 1 hour.
        Default value is `POINT_IN_TIME_RECOVERY_DISABLED`.
        Possible values are: `POINT_IN_TIME_RECOVERY_ENABLED`, `POINT_IN_TIME_RECOVERY_DISABLED`.
        """
        return pulumi.get(self, "point_in_time_recovery_enablement")

    @point_in_time_recovery_enablement.setter
    def point_in_time_recovery_enablement(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "point_in_time_recovery_enablement", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _DatabaseState:
    def __init__(__self__, *,
                 app_engine_integration_mode: Optional[pulumi.Input[builtins.str]] = None,
                 cmek_config: Optional[pulumi.Input['DatabaseCmekConfigArgs']] = None,
                 concurrency_mode: Optional[pulumi.Input[builtins.str]] = None,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 database_edition: Optional[pulumi.Input[builtins.str]] = None,
                 delete_protection_state: Optional[pulumi.Input[builtins.str]] = None,
                 deletion_policy: Optional[pulumi.Input[builtins.str]] = None,
                 earliest_version_time: Optional[pulumi.Input[builtins.str]] = None,
                 etag: Optional[pulumi.Input[builtins.str]] = None,
                 key_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 location_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 point_in_time_recovery_enablement: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 uid: Optional[pulumi.Input[builtins.str]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None,
                 version_retention_period: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Database resources.
        :param pulumi.Input[builtins.str] app_engine_integration_mode: The App Engine integration mode to use for this database.
               Possible values are: `ENABLED`, `DISABLED`.
        :param pulumi.Input['DatabaseCmekConfigArgs'] cmek_config: The CMEK (Customer Managed Encryption Key) configuration for a Firestore
               database. If not present, the database is secured by the default Google
               encryption key.
               Structure is documented below.
        :param pulumi.Input[builtins.str] concurrency_mode: The concurrency control mode to use for this database.
               Possible values are: `OPTIMISTIC`, `PESSIMISTIC`, `OPTIMISTIC_WITH_ENTITY_GROUPS`.
        :param pulumi.Input[builtins.str] create_time: Output only. The timestamp at which this database was created.
        :param pulumi.Input[builtins.str] database_edition: The database edition.
               Possible values are: `STANDARD`, `ENTERPRISE`.
        :param pulumi.Input[builtins.str] earliest_version_time: Output only. The earliest timestamp at which older versions of the data can be read from the database. See versionRetentionPeriod above; this field is populated with now - versionRetentionPeriod.
               This value is continuously updated, and becomes stale the moment it is queried. If you are using this value to recover data, make sure to account for the time from the moment when the value is queried to the moment when you initiate the recovery.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input[builtins.str] etag: Output only. This checksum is computed by the server based on the value of other fields,
               and may be sent on update and delete requests to ensure the client has an
               up-to-date value before proceeding.
        :param pulumi.Input[builtins.str] key_prefix: Output only. The keyPrefix for this database.
               This keyPrefix is used, in combination with the project id ("~") to construct the application id
               that is returned from the Cloud Datastore APIs in Google App Engine first generation runtimes.
               This value may be empty in which case the appid to use for URL-encoded keys is the project_id (eg: foo instead of v~foo).
        :param pulumi.Input[builtins.str] location_id: The location of the database. Available locations are listed at
               https://cloud.google.com/firestore/docs/locations.
        :param pulumi.Input[builtins.str] name: The ID to use for the database, which will become the final
               component of the database's resource name. This value should be 4-63
               characters. Valid characters are /[a-z][0-9]-/ with first character
               a letter and the last a letter or a number. Must not be
               UUID-like /[0-9a-f]{8}(-[0-9a-f]{4}){3}-[0-9a-f]{12}/.
               "(default)" database id is also valid.
        :param pulumi.Input[builtins.str] point_in_time_recovery_enablement: Whether to enable the PITR feature on this database.
               If `POINT_IN_TIME_RECOVERY_ENABLED` is selected, reads are supported on selected versions of the data from within the past 7 days.
               versionRetentionPeriod and earliestVersionTime can be used to determine the supported versions. These include reads against any timestamp within the past hour
               and reads against 1-minute snapshots beyond 1 hour and within 7 days.
               If `POINT_IN_TIME_RECOVERY_DISABLED` is selected, reads are supported on any version of the data from within the past 1 hour.
               Default value is `POINT_IN_TIME_RECOVERY_DISABLED`.
               Possible values are: `POINT_IN_TIME_RECOVERY_ENABLED`, `POINT_IN_TIME_RECOVERY_DISABLED`.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] type: The type of the database.
               See https://cloud.google.com/datastore/docs/firestore-or-datastore
               for information about how to choose.
               Possible values are: `FIRESTORE_NATIVE`, `DATASTORE_MODE`.
               
               
               - - -
        :param pulumi.Input[builtins.str] uid: Output only. The system-generated UUID4 for this Database.
        :param pulumi.Input[builtins.str] update_time: Output only. The timestamp at which this database was most recently updated.
        :param pulumi.Input[builtins.str] version_retention_period: Output only. The period during which past versions of data are retained in the database.
               Any read or query can specify a readTime within this window, and will read the state of the database at that time.
               If the PITR feature is enabled, the retention period is 7 days. Otherwise, the retention period is 1 hour.
               A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        """
        if app_engine_integration_mode is not None:
            pulumi.set(__self__, "app_engine_integration_mode", app_engine_integration_mode)
        if cmek_config is not None:
            pulumi.set(__self__, "cmek_config", cmek_config)
        if concurrency_mode is not None:
            pulumi.set(__self__, "concurrency_mode", concurrency_mode)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if database_edition is not None:
            pulumi.set(__self__, "database_edition", database_edition)
        if delete_protection_state is not None:
            pulumi.set(__self__, "delete_protection_state", delete_protection_state)
        if deletion_policy is not None:
            pulumi.set(__self__, "deletion_policy", deletion_policy)
        if earliest_version_time is not None:
            pulumi.set(__self__, "earliest_version_time", earliest_version_time)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if key_prefix is not None:
            pulumi.set(__self__, "key_prefix", key_prefix)
        if location_id is not None:
            pulumi.set(__self__, "location_id", location_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if point_in_time_recovery_enablement is not None:
            pulumi.set(__self__, "point_in_time_recovery_enablement", point_in_time_recovery_enablement)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if version_retention_period is not None:
            pulumi.set(__self__, "version_retention_period", version_retention_period)

    @property
    @pulumi.getter(name="appEngineIntegrationMode")
    def app_engine_integration_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The App Engine integration mode to use for this database.
        Possible values are: `ENABLED`, `DISABLED`.
        """
        return pulumi.get(self, "app_engine_integration_mode")

    @app_engine_integration_mode.setter
    def app_engine_integration_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "app_engine_integration_mode", value)

    @property
    @pulumi.getter(name="cmekConfig")
    def cmek_config(self) -> Optional[pulumi.Input['DatabaseCmekConfigArgs']]:
        """
        The CMEK (Customer Managed Encryption Key) configuration for a Firestore
        database. If not present, the database is secured by the default Google
        encryption key.
        Structure is documented below.
        """
        return pulumi.get(self, "cmek_config")

    @cmek_config.setter
    def cmek_config(self, value: Optional[pulumi.Input['DatabaseCmekConfigArgs']]):
        pulumi.set(self, "cmek_config", value)

    @property
    @pulumi.getter(name="concurrencyMode")
    def concurrency_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The concurrency control mode to use for this database.
        Possible values are: `OPTIMISTIC`, `PESSIMISTIC`, `OPTIMISTIC_WITH_ENTITY_GROUPS`.
        """
        return pulumi.get(self, "concurrency_mode")

    @concurrency_mode.setter
    def concurrency_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "concurrency_mode", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. The timestamp at which this database was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="databaseEdition")
    def database_edition(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The database edition.
        Possible values are: `STANDARD`, `ENTERPRISE`.
        """
        return pulumi.get(self, "database_edition")

    @database_edition.setter
    def database_edition(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "database_edition", value)

    @property
    @pulumi.getter(name="deleteProtectionState")
    def delete_protection_state(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "delete_protection_state")

    @delete_protection_state.setter
    def delete_protection_state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "delete_protection_state", value)

    @property
    @pulumi.getter(name="deletionPolicy")
    def deletion_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "deletion_policy")

    @deletion_policy.setter
    def deletion_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "deletion_policy", value)

    @property
    @pulumi.getter(name="earliestVersionTime")
    def earliest_version_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. The earliest timestamp at which older versions of the data can be read from the database. See versionRetentionPeriod above; this field is populated with now - versionRetentionPeriod.
        This value is continuously updated, and becomes stale the moment it is queried. If you are using this value to recover data, make sure to account for the time from the moment when the value is queried to the moment when you initiate the recovery.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "earliest_version_time")

    @earliest_version_time.setter
    def earliest_version_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "earliest_version_time", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. This checksum is computed by the server based on the value of other fields,
        and may be sent on update and delete requests to ensure the client has an
        up-to-date value before proceeding.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter(name="keyPrefix")
    def key_prefix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. The keyPrefix for this database.
        This keyPrefix is used, in combination with the project id ("~") to construct the application id
        that is returned from the Cloud Datastore APIs in Google App Engine first generation runtimes.
        This value may be empty in which case the appid to use for URL-encoded keys is the project_id (eg: foo instead of v~foo).
        """
        return pulumi.get(self, "key_prefix")

    @key_prefix.setter
    def key_prefix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key_prefix", value)

    @property
    @pulumi.getter(name="locationId")
    def location_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location of the database. Available locations are listed at
        https://cloud.google.com/firestore/docs/locations.
        """
        return pulumi.get(self, "location_id")

    @location_id.setter
    def location_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID to use for the database, which will become the final
        component of the database's resource name. This value should be 4-63
        characters. Valid characters are /[a-z][0-9]-/ with first character
        a letter and the last a letter or a number. Must not be
        UUID-like /[0-9a-f]{8}(-[0-9a-f]{4}){3}-[0-9a-f]{12}/.
        "(default)" database id is also valid.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="pointInTimeRecoveryEnablement")
    def point_in_time_recovery_enablement(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Whether to enable the PITR feature on this database.
        If `POINT_IN_TIME_RECOVERY_ENABLED` is selected, reads are supported on selected versions of the data from within the past 7 days.
        versionRetentionPeriod and earliestVersionTime can be used to determine the supported versions. These include reads against any timestamp within the past hour
        and reads against 1-minute snapshots beyond 1 hour and within 7 days.
        If `POINT_IN_TIME_RECOVERY_DISABLED` is selected, reads are supported on any version of the data from within the past 1 hour.
        Default value is `POINT_IN_TIME_RECOVERY_DISABLED`.
        Possible values are: `POINT_IN_TIME_RECOVERY_ENABLED`, `POINT_IN_TIME_RECOVERY_DISABLED`.
        """
        return pulumi.get(self, "point_in_time_recovery_enablement")

    @point_in_time_recovery_enablement.setter
    def point_in_time_recovery_enablement(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "point_in_time_recovery_enablement", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of the database.
        See https://cloud.google.com/datastore/docs/firestore-or-datastore
        for information about how to choose.
        Possible values are: `FIRESTORE_NATIVE`, `DATASTORE_MODE`.


        - - -
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. The system-generated UUID4 for this Database.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "uid", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. The timestamp at which this database was most recently updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)

    @property
    @pulumi.getter(name="versionRetentionPeriod")
    def version_retention_period(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. The period during which past versions of data are retained in the database.
        Any read or query can specify a readTime within this window, and will read the state of the database at that time.
        If the PITR feature is enabled, the retention period is 7 days. Otherwise, the retention period is 1 hour.
        A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        """
        return pulumi.get(self, "version_retention_period")

    @version_retention_period.setter
    def version_retention_period(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version_retention_period", value)


@pulumi.type_token("gcp:firestore/database:Database")
class Database(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_engine_integration_mode: Optional[pulumi.Input[builtins.str]] = None,
                 cmek_config: Optional[pulumi.Input[Union['DatabaseCmekConfigArgs', 'DatabaseCmekConfigArgsDict']]] = None,
                 concurrency_mode: Optional[pulumi.Input[builtins.str]] = None,
                 database_edition: Optional[pulumi.Input[builtins.str]] = None,
                 delete_protection_state: Optional[pulumi.Input[builtins.str]] = None,
                 deletion_policy: Optional[pulumi.Input[builtins.str]] = None,
                 location_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 point_in_time_recovery_enablement: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        A Cloud Firestore Database.

        If you wish to use Firestore with App Engine, use the
        `appengine.Application`
        resource instead. If you were previously using the `appengine.Application` resource exclusively for managing a Firestore database
        and would like to use the `firestore.Database` resource instead, please follow the instructions
        [here](https://cloud.google.com/firestore/docs/app-engine-requirement).

        To get more information about Database, see:

        * [API documentation](https://cloud.google.com/firestore/docs/reference/rest/v1/projects.databases)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/firestore/docs/)

        ## Example Usage

        ### Firestore Default Database

        ```python
        import pulumi
        import pulumi_gcp as gcp

        database = gcp.firestore.Database("database",
            project="my-project-name",
            name="(default)",
            location_id="nam5",
            type="FIRESTORE_NATIVE")
        ```
        ### Firestore Database

        ```python
        import pulumi
        import pulumi_gcp as gcp

        database = gcp.firestore.Database("database",
            project="my-project-name",
            name="database-id",
            location_id="nam5",
            type="FIRESTORE_NATIVE",
            concurrency_mode="OPTIMISTIC",
            app_engine_integration_mode="DISABLED",
            point_in_time_recovery_enablement="POINT_IN_TIME_RECOVERY_ENABLED",
            delete_protection_state="DELETE_PROTECTION_ENABLED",
            deletion_policy="DELETE")
        ```
        ### Firestore Cmek Database

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        key_ring = gcp.kms.KeyRing("key_ring",
            name="kms-key-ring",
            location="us")
        crypto_key = gcp.kms.CryptoKey("crypto_key",
            name="kms-key",
            key_ring=key_ring.id,
            purpose="ENCRYPT_DECRYPT")
        firestore_cmek_keyuser = gcp.kms.CryptoKeyIAMBinding("firestore_cmek_keyuser",
            crypto_key_id=crypto_key.id,
            role="roles/cloudkms.cryptoKeyEncrypterDecrypter",
            members=[f"serviceAccount:service-{project.number}@gcp-sa-firestore.iam.gserviceaccount.com"])
        database = gcp.firestore.Database("database",
            project="my-project-name",
            name="cmek-database-id",
            location_id="nam5",
            type="FIRESTORE_NATIVE",
            concurrency_mode="OPTIMISTIC",
            app_engine_integration_mode="DISABLED",
            point_in_time_recovery_enablement="POINT_IN_TIME_RECOVERY_ENABLED",
            delete_protection_state="DELETE_PROTECTION_ENABLED",
            deletion_policy="DELETE",
            cmek_config={
                "kms_key_name": crypto_key.id,
            },
            opts = pulumi.ResourceOptions(depends_on=[firestore_cmek_keyuser]))
        ```
        ### Firestore Default Database In Datastore Mode

        ```python
        import pulumi
        import pulumi_gcp as gcp

        datastore_mode_database = gcp.firestore.Database("datastore_mode_database",
            project="my-project-name",
            name="(default)",
            location_id="nam5",
            type="DATASTORE_MODE")
        ```
        ### Firestore Database In Datastore Mode

        ```python
        import pulumi
        import pulumi_gcp as gcp

        datastore_mode_database = gcp.firestore.Database("datastore_mode_database",
            project="my-project-name",
            name="database-id",
            location_id="nam5",
            type="DATASTORE_MODE",
            concurrency_mode="OPTIMISTIC",
            app_engine_integration_mode="DISABLED",
            point_in_time_recovery_enablement="POINT_IN_TIME_RECOVERY_ENABLED",
            delete_protection_state="DELETE_PROTECTION_ENABLED",
            deletion_policy="DELETE")
        ```
        ### Firestore Cmek Database In Datastore Mode

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        key_ring = gcp.kms.KeyRing("key_ring",
            name="kms-key-ring",
            location="us")
        crypto_key = gcp.kms.CryptoKey("crypto_key",
            name="kms-key",
            key_ring=key_ring.id,
            purpose="ENCRYPT_DECRYPT")
        firestore_cmek_keyuser = gcp.kms.CryptoKeyIAMBinding("firestore_cmek_keyuser",
            crypto_key_id=crypto_key.id,
            role="roles/cloudkms.cryptoKeyEncrypterDecrypter",
            members=[f"serviceAccount:service-{project.number}@gcp-sa-firestore.iam.gserviceaccount.com"])
        database = gcp.firestore.Database("database",
            project="my-project-name",
            name="cmek-database-id",
            location_id="nam5",
            type="DATASTORE_MODE",
            concurrency_mode="OPTIMISTIC",
            app_engine_integration_mode="DISABLED",
            point_in_time_recovery_enablement="POINT_IN_TIME_RECOVERY_ENABLED",
            delete_protection_state="DELETE_PROTECTION_ENABLED",
            deletion_policy="DELETE",
            cmek_config={
                "kms_key_name": crypto_key.id,
            },
            opts = pulumi.ResourceOptions(depends_on=[firestore_cmek_keyuser]))
        ```
        ### Firestore Database Enterprise

        ```python
        import pulumi
        import pulumi_gcp as gcp

        enterprise_db = gcp.firestore.Database("enterprise-db",
            project="my-project-name",
            name="database-id",
            location_id="nam5",
            type="FIRESTORE_NATIVE",
            database_edition="ENTERPRISE",
            deletion_policy="DELETE")
        ```

        ## Import

        Database can be imported using any of these accepted formats:

        * `projects/{{project}}/databases/{{name}}`

        * `{{project}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, Database can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:firestore/database:Database default projects/{{project}}/databases/{{name}}
        ```

        ```sh
        $ pulumi import gcp:firestore/database:Database default {{project}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:firestore/database:Database default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] app_engine_integration_mode: The App Engine integration mode to use for this database.
               Possible values are: `ENABLED`, `DISABLED`.
        :param pulumi.Input[Union['DatabaseCmekConfigArgs', 'DatabaseCmekConfigArgsDict']] cmek_config: The CMEK (Customer Managed Encryption Key) configuration for a Firestore
               database. If not present, the database is secured by the default Google
               encryption key.
               Structure is documented below.
        :param pulumi.Input[builtins.str] concurrency_mode: The concurrency control mode to use for this database.
               Possible values are: `OPTIMISTIC`, `PESSIMISTIC`, `OPTIMISTIC_WITH_ENTITY_GROUPS`.
        :param pulumi.Input[builtins.str] database_edition: The database edition.
               Possible values are: `STANDARD`, `ENTERPRISE`.
        :param pulumi.Input[builtins.str] location_id: The location of the database. Available locations are listed at
               https://cloud.google.com/firestore/docs/locations.
        :param pulumi.Input[builtins.str] name: The ID to use for the database, which will become the final
               component of the database's resource name. This value should be 4-63
               characters. Valid characters are /[a-z][0-9]-/ with first character
               a letter and the last a letter or a number. Must not be
               UUID-like /[0-9a-f]{8}(-[0-9a-f]{4}){3}-[0-9a-f]{12}/.
               "(default)" database id is also valid.
        :param pulumi.Input[builtins.str] point_in_time_recovery_enablement: Whether to enable the PITR feature on this database.
               If `POINT_IN_TIME_RECOVERY_ENABLED` is selected, reads are supported on selected versions of the data from within the past 7 days.
               versionRetentionPeriod and earliestVersionTime can be used to determine the supported versions. These include reads against any timestamp within the past hour
               and reads against 1-minute snapshots beyond 1 hour and within 7 days.
               If `POINT_IN_TIME_RECOVERY_DISABLED` is selected, reads are supported on any version of the data from within the past 1 hour.
               Default value is `POINT_IN_TIME_RECOVERY_DISABLED`.
               Possible values are: `POINT_IN_TIME_RECOVERY_ENABLED`, `POINT_IN_TIME_RECOVERY_DISABLED`.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] type: The type of the database.
               See https://cloud.google.com/datastore/docs/firestore-or-datastore
               for information about how to choose.
               Possible values are: `FIRESTORE_NATIVE`, `DATASTORE_MODE`.
               
               
               - - -
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DatabaseArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Cloud Firestore Database.

        If you wish to use Firestore with App Engine, use the
        `appengine.Application`
        resource instead. If you were previously using the `appengine.Application` resource exclusively for managing a Firestore database
        and would like to use the `firestore.Database` resource instead, please follow the instructions
        [here](https://cloud.google.com/firestore/docs/app-engine-requirement).

        To get more information about Database, see:

        * [API documentation](https://cloud.google.com/firestore/docs/reference/rest/v1/projects.databases)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/firestore/docs/)

        ## Example Usage

        ### Firestore Default Database

        ```python
        import pulumi
        import pulumi_gcp as gcp

        database = gcp.firestore.Database("database",
            project="my-project-name",
            name="(default)",
            location_id="nam5",
            type="FIRESTORE_NATIVE")
        ```
        ### Firestore Database

        ```python
        import pulumi
        import pulumi_gcp as gcp

        database = gcp.firestore.Database("database",
            project="my-project-name",
            name="database-id",
            location_id="nam5",
            type="FIRESTORE_NATIVE",
            concurrency_mode="OPTIMISTIC",
            app_engine_integration_mode="DISABLED",
            point_in_time_recovery_enablement="POINT_IN_TIME_RECOVERY_ENABLED",
            delete_protection_state="DELETE_PROTECTION_ENABLED",
            deletion_policy="DELETE")
        ```
        ### Firestore Cmek Database

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        key_ring = gcp.kms.KeyRing("key_ring",
            name="kms-key-ring",
            location="us")
        crypto_key = gcp.kms.CryptoKey("crypto_key",
            name="kms-key",
            key_ring=key_ring.id,
            purpose="ENCRYPT_DECRYPT")
        firestore_cmek_keyuser = gcp.kms.CryptoKeyIAMBinding("firestore_cmek_keyuser",
            crypto_key_id=crypto_key.id,
            role="roles/cloudkms.cryptoKeyEncrypterDecrypter",
            members=[f"serviceAccount:service-{project.number}@gcp-sa-firestore.iam.gserviceaccount.com"])
        database = gcp.firestore.Database("database",
            project="my-project-name",
            name="cmek-database-id",
            location_id="nam5",
            type="FIRESTORE_NATIVE",
            concurrency_mode="OPTIMISTIC",
            app_engine_integration_mode="DISABLED",
            point_in_time_recovery_enablement="POINT_IN_TIME_RECOVERY_ENABLED",
            delete_protection_state="DELETE_PROTECTION_ENABLED",
            deletion_policy="DELETE",
            cmek_config={
                "kms_key_name": crypto_key.id,
            },
            opts = pulumi.ResourceOptions(depends_on=[firestore_cmek_keyuser]))
        ```
        ### Firestore Default Database In Datastore Mode

        ```python
        import pulumi
        import pulumi_gcp as gcp

        datastore_mode_database = gcp.firestore.Database("datastore_mode_database",
            project="my-project-name",
            name="(default)",
            location_id="nam5",
            type="DATASTORE_MODE")
        ```
        ### Firestore Database In Datastore Mode

        ```python
        import pulumi
        import pulumi_gcp as gcp

        datastore_mode_database = gcp.firestore.Database("datastore_mode_database",
            project="my-project-name",
            name="database-id",
            location_id="nam5",
            type="DATASTORE_MODE",
            concurrency_mode="OPTIMISTIC",
            app_engine_integration_mode="DISABLED",
            point_in_time_recovery_enablement="POINT_IN_TIME_RECOVERY_ENABLED",
            delete_protection_state="DELETE_PROTECTION_ENABLED",
            deletion_policy="DELETE")
        ```
        ### Firestore Cmek Database In Datastore Mode

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        key_ring = gcp.kms.KeyRing("key_ring",
            name="kms-key-ring",
            location="us")
        crypto_key = gcp.kms.CryptoKey("crypto_key",
            name="kms-key",
            key_ring=key_ring.id,
            purpose="ENCRYPT_DECRYPT")
        firestore_cmek_keyuser = gcp.kms.CryptoKeyIAMBinding("firestore_cmek_keyuser",
            crypto_key_id=crypto_key.id,
            role="roles/cloudkms.cryptoKeyEncrypterDecrypter",
            members=[f"serviceAccount:service-{project.number}@gcp-sa-firestore.iam.gserviceaccount.com"])
        database = gcp.firestore.Database("database",
            project="my-project-name",
            name="cmek-database-id",
            location_id="nam5",
            type="DATASTORE_MODE",
            concurrency_mode="OPTIMISTIC",
            app_engine_integration_mode="DISABLED",
            point_in_time_recovery_enablement="POINT_IN_TIME_RECOVERY_ENABLED",
            delete_protection_state="DELETE_PROTECTION_ENABLED",
            deletion_policy="DELETE",
            cmek_config={
                "kms_key_name": crypto_key.id,
            },
            opts = pulumi.ResourceOptions(depends_on=[firestore_cmek_keyuser]))
        ```
        ### Firestore Database Enterprise

        ```python
        import pulumi
        import pulumi_gcp as gcp

        enterprise_db = gcp.firestore.Database("enterprise-db",
            project="my-project-name",
            name="database-id",
            location_id="nam5",
            type="FIRESTORE_NATIVE",
            database_edition="ENTERPRISE",
            deletion_policy="DELETE")
        ```

        ## Import

        Database can be imported using any of these accepted formats:

        * `projects/{{project}}/databases/{{name}}`

        * `{{project}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, Database can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:firestore/database:Database default projects/{{project}}/databases/{{name}}
        ```

        ```sh
        $ pulumi import gcp:firestore/database:Database default {{project}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:firestore/database:Database default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param DatabaseArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DatabaseArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_engine_integration_mode: Optional[pulumi.Input[builtins.str]] = None,
                 cmek_config: Optional[pulumi.Input[Union['DatabaseCmekConfigArgs', 'DatabaseCmekConfigArgsDict']]] = None,
                 concurrency_mode: Optional[pulumi.Input[builtins.str]] = None,
                 database_edition: Optional[pulumi.Input[builtins.str]] = None,
                 delete_protection_state: Optional[pulumi.Input[builtins.str]] = None,
                 deletion_policy: Optional[pulumi.Input[builtins.str]] = None,
                 location_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 point_in_time_recovery_enablement: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DatabaseArgs.__new__(DatabaseArgs)

            __props__.__dict__["app_engine_integration_mode"] = app_engine_integration_mode
            __props__.__dict__["cmek_config"] = cmek_config
            __props__.__dict__["concurrency_mode"] = concurrency_mode
            __props__.__dict__["database_edition"] = database_edition
            __props__.__dict__["delete_protection_state"] = delete_protection_state
            __props__.__dict__["deletion_policy"] = deletion_policy
            if location_id is None and not opts.urn:
                raise TypeError("Missing required property 'location_id'")
            __props__.__dict__["location_id"] = location_id
            __props__.__dict__["name"] = name
            __props__.__dict__["point_in_time_recovery_enablement"] = point_in_time_recovery_enablement
            __props__.__dict__["project"] = project
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["create_time"] = None
            __props__.__dict__["earliest_version_time"] = None
            __props__.__dict__["etag"] = None
            __props__.__dict__["key_prefix"] = None
            __props__.__dict__["uid"] = None
            __props__.__dict__["update_time"] = None
            __props__.__dict__["version_retention_period"] = None
        super(Database, __self__).__init__(
            'gcp:firestore/database:Database',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            app_engine_integration_mode: Optional[pulumi.Input[builtins.str]] = None,
            cmek_config: Optional[pulumi.Input[Union['DatabaseCmekConfigArgs', 'DatabaseCmekConfigArgsDict']]] = None,
            concurrency_mode: Optional[pulumi.Input[builtins.str]] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            database_edition: Optional[pulumi.Input[builtins.str]] = None,
            delete_protection_state: Optional[pulumi.Input[builtins.str]] = None,
            deletion_policy: Optional[pulumi.Input[builtins.str]] = None,
            earliest_version_time: Optional[pulumi.Input[builtins.str]] = None,
            etag: Optional[pulumi.Input[builtins.str]] = None,
            key_prefix: Optional[pulumi.Input[builtins.str]] = None,
            location_id: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            point_in_time_recovery_enablement: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None,
            uid: Optional[pulumi.Input[builtins.str]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None,
            version_retention_period: Optional[pulumi.Input[builtins.str]] = None) -> 'Database':
        """
        Get an existing Database resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] app_engine_integration_mode: The App Engine integration mode to use for this database.
               Possible values are: `ENABLED`, `DISABLED`.
        :param pulumi.Input[Union['DatabaseCmekConfigArgs', 'DatabaseCmekConfigArgsDict']] cmek_config: The CMEK (Customer Managed Encryption Key) configuration for a Firestore
               database. If not present, the database is secured by the default Google
               encryption key.
               Structure is documented below.
        :param pulumi.Input[builtins.str] concurrency_mode: The concurrency control mode to use for this database.
               Possible values are: `OPTIMISTIC`, `PESSIMISTIC`, `OPTIMISTIC_WITH_ENTITY_GROUPS`.
        :param pulumi.Input[builtins.str] create_time: Output only. The timestamp at which this database was created.
        :param pulumi.Input[builtins.str] database_edition: The database edition.
               Possible values are: `STANDARD`, `ENTERPRISE`.
        :param pulumi.Input[builtins.str] earliest_version_time: Output only. The earliest timestamp at which older versions of the data can be read from the database. See versionRetentionPeriod above; this field is populated with now - versionRetentionPeriod.
               This value is continuously updated, and becomes stale the moment it is queried. If you are using this value to recover data, make sure to account for the time from the moment when the value is queried to the moment when you initiate the recovery.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input[builtins.str] etag: Output only. This checksum is computed by the server based on the value of other fields,
               and may be sent on update and delete requests to ensure the client has an
               up-to-date value before proceeding.
        :param pulumi.Input[builtins.str] key_prefix: Output only. The keyPrefix for this database.
               This keyPrefix is used, in combination with the project id ("~") to construct the application id
               that is returned from the Cloud Datastore APIs in Google App Engine first generation runtimes.
               This value may be empty in which case the appid to use for URL-encoded keys is the project_id (eg: foo instead of v~foo).
        :param pulumi.Input[builtins.str] location_id: The location of the database. Available locations are listed at
               https://cloud.google.com/firestore/docs/locations.
        :param pulumi.Input[builtins.str] name: The ID to use for the database, which will become the final
               component of the database's resource name. This value should be 4-63
               characters. Valid characters are /[a-z][0-9]-/ with first character
               a letter and the last a letter or a number. Must not be
               UUID-like /[0-9a-f]{8}(-[0-9a-f]{4}){3}-[0-9a-f]{12}/.
               "(default)" database id is also valid.
        :param pulumi.Input[builtins.str] point_in_time_recovery_enablement: Whether to enable the PITR feature on this database.
               If `POINT_IN_TIME_RECOVERY_ENABLED` is selected, reads are supported on selected versions of the data from within the past 7 days.
               versionRetentionPeriod and earliestVersionTime can be used to determine the supported versions. These include reads against any timestamp within the past hour
               and reads against 1-minute snapshots beyond 1 hour and within 7 days.
               If `POINT_IN_TIME_RECOVERY_DISABLED` is selected, reads are supported on any version of the data from within the past 1 hour.
               Default value is `POINT_IN_TIME_RECOVERY_DISABLED`.
               Possible values are: `POINT_IN_TIME_RECOVERY_ENABLED`, `POINT_IN_TIME_RECOVERY_DISABLED`.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] type: The type of the database.
               See https://cloud.google.com/datastore/docs/firestore-or-datastore
               for information about how to choose.
               Possible values are: `FIRESTORE_NATIVE`, `DATASTORE_MODE`.
               
               
               - - -
        :param pulumi.Input[builtins.str] uid: Output only. The system-generated UUID4 for this Database.
        :param pulumi.Input[builtins.str] update_time: Output only. The timestamp at which this database was most recently updated.
        :param pulumi.Input[builtins.str] version_retention_period: Output only. The period during which past versions of data are retained in the database.
               Any read or query can specify a readTime within this window, and will read the state of the database at that time.
               If the PITR feature is enabled, the retention period is 7 days. Otherwise, the retention period is 1 hour.
               A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DatabaseState.__new__(_DatabaseState)

        __props__.__dict__["app_engine_integration_mode"] = app_engine_integration_mode
        __props__.__dict__["cmek_config"] = cmek_config
        __props__.__dict__["concurrency_mode"] = concurrency_mode
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["database_edition"] = database_edition
        __props__.__dict__["delete_protection_state"] = delete_protection_state
        __props__.__dict__["deletion_policy"] = deletion_policy
        __props__.__dict__["earliest_version_time"] = earliest_version_time
        __props__.__dict__["etag"] = etag
        __props__.__dict__["key_prefix"] = key_prefix
        __props__.__dict__["location_id"] = location_id
        __props__.__dict__["name"] = name
        __props__.__dict__["point_in_time_recovery_enablement"] = point_in_time_recovery_enablement
        __props__.__dict__["project"] = project
        __props__.__dict__["type"] = type
        __props__.__dict__["uid"] = uid
        __props__.__dict__["update_time"] = update_time
        __props__.__dict__["version_retention_period"] = version_retention_period
        return Database(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="appEngineIntegrationMode")
    def app_engine_integration_mode(self) -> pulumi.Output[builtins.str]:
        """
        The App Engine integration mode to use for this database.
        Possible values are: `ENABLED`, `DISABLED`.
        """
        return pulumi.get(self, "app_engine_integration_mode")

    @property
    @pulumi.getter(name="cmekConfig")
    def cmek_config(self) -> pulumi.Output[Optional['outputs.DatabaseCmekConfig']]:
        """
        The CMEK (Customer Managed Encryption Key) configuration for a Firestore
        database. If not present, the database is secured by the default Google
        encryption key.
        Structure is documented below.
        """
        return pulumi.get(self, "cmek_config")

    @property
    @pulumi.getter(name="concurrencyMode")
    def concurrency_mode(self) -> pulumi.Output[builtins.str]:
        """
        The concurrency control mode to use for this database.
        Possible values are: `OPTIMISTIC`, `PESSIMISTIC`, `OPTIMISTIC_WITH_ENTITY_GROUPS`.
        """
        return pulumi.get(self, "concurrency_mode")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        Output only. The timestamp at which this database was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="databaseEdition")
    def database_edition(self) -> pulumi.Output[builtins.str]:
        """
        The database edition.
        Possible values are: `STANDARD`, `ENTERPRISE`.
        """
        return pulumi.get(self, "database_edition")

    @property
    @pulumi.getter(name="deleteProtectionState")
    def delete_protection_state(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "delete_protection_state")

    @property
    @pulumi.getter(name="deletionPolicy")
    def deletion_policy(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "deletion_policy")

    @property
    @pulumi.getter(name="earliestVersionTime")
    def earliest_version_time(self) -> pulumi.Output[builtins.str]:
        """
        Output only. The earliest timestamp at which older versions of the data can be read from the database. See versionRetentionPeriod above; this field is populated with now - versionRetentionPeriod.
        This value is continuously updated, and becomes stale the moment it is queried. If you are using this value to recover data, make sure to account for the time from the moment when the value is queried to the moment when you initiate the recovery.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "earliest_version_time")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[builtins.str]:
        """
        Output only. This checksum is computed by the server based on the value of other fields,
        and may be sent on update and delete requests to ensure the client has an
        up-to-date value before proceeding.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="keyPrefix")
    def key_prefix(self) -> pulumi.Output[builtins.str]:
        """
        Output only. The keyPrefix for this database.
        This keyPrefix is used, in combination with the project id ("~") to construct the application id
        that is returned from the Cloud Datastore APIs in Google App Engine first generation runtimes.
        This value may be empty in which case the appid to use for URL-encoded keys is the project_id (eg: foo instead of v~foo).
        """
        return pulumi.get(self, "key_prefix")

    @property
    @pulumi.getter(name="locationId")
    def location_id(self) -> pulumi.Output[builtins.str]:
        """
        The location of the database. Available locations are listed at
        https://cloud.google.com/firestore/docs/locations.
        """
        return pulumi.get(self, "location_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The ID to use for the database, which will become the final
        component of the database's resource name. This value should be 4-63
        characters. Valid characters are /[a-z][0-9]-/ with first character
        a letter and the last a letter or a number. Must not be
        UUID-like /[0-9a-f]{8}(-[0-9a-f]{4}){3}-[0-9a-f]{12}/.
        "(default)" database id is also valid.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="pointInTimeRecoveryEnablement")
    def point_in_time_recovery_enablement(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Whether to enable the PITR feature on this database.
        If `POINT_IN_TIME_RECOVERY_ENABLED` is selected, reads are supported on selected versions of the data from within the past 7 days.
        versionRetentionPeriod and earliestVersionTime can be used to determine the supported versions. These include reads against any timestamp within the past hour
        and reads against 1-minute snapshots beyond 1 hour and within 7 days.
        If `POINT_IN_TIME_RECOVERY_DISABLED` is selected, reads are supported on any version of the data from within the past 1 hour.
        Default value is `POINT_IN_TIME_RECOVERY_DISABLED`.
        Possible values are: `POINT_IN_TIME_RECOVERY_ENABLED`, `POINT_IN_TIME_RECOVERY_DISABLED`.
        """
        return pulumi.get(self, "point_in_time_recovery_enablement")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[builtins.str]:
        """
        The type of the database.
        See https://cloud.google.com/datastore/docs/firestore-or-datastore
        for information about how to choose.
        Possible values are: `FIRESTORE_NATIVE`, `DATASTORE_MODE`.


        - - -
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def uid(self) -> pulumi.Output[builtins.str]:
        """
        Output only. The system-generated UUID4 for this Database.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        Output only. The timestamp at which this database was most recently updated.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter(name="versionRetentionPeriod")
    def version_retention_period(self) -> pulumi.Output[builtins.str]:
        """
        Output only. The period during which past versions of data are retained in the database.
        Any read or query can specify a readTime within this window, and will read the state of the database at that time.
        If the PITR feature is enabled, the retention period is 7 days. Otherwise, the retention period is 1 hour.
        A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        """
        return pulumi.get(self, "version_retention_period")

