# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ServiceIdentityArgs', 'ServiceIdentity']

@pulumi.input_type
class ServiceIdentityArgs:
    def __init__(__self__, *,
                 folder: pulumi.Input[builtins.str],
                 service: pulumi.Input[builtins.str]):
        """
        The set of arguments for constructing a ServiceIdentity resource.
        :param pulumi.Input[builtins.str] folder: The folder in which the resource belongs.
        :param pulumi.Input[builtins.str] service: The service to generate identity for.
               
               - - -
        """
        pulumi.set(__self__, "folder", folder)
        pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter
    def folder(self) -> pulumi.Input[builtins.str]:
        """
        The folder in which the resource belongs.
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "folder", value)

    @property
    @pulumi.getter
    def service(self) -> pulumi.Input[builtins.str]:
        """
        The service to generate identity for.

        - - -
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "service", value)


@pulumi.input_type
class _ServiceIdentityState:
    def __init__(__self__, *,
                 email: Optional[pulumi.Input[builtins.str]] = None,
                 folder: Optional[pulumi.Input[builtins.str]] = None,
                 member: Optional[pulumi.Input[builtins.str]] = None,
                 service: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ServiceIdentity resources.
        :param pulumi.Input[builtins.str] email: The email address of the Google managed service account.
        :param pulumi.Input[builtins.str] folder: The folder in which the resource belongs.
        :param pulumi.Input[builtins.str] member: The Identity of the Google managed service account in the form 'serviceAccount:{email}'. This value is often used to refer to the service account in order to grant IAM permissions.
        :param pulumi.Input[builtins.str] service: The service to generate identity for.
               
               - - -
        """
        if email is not None:
            pulumi.set(__self__, "email", email)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if member is not None:
            pulumi.set(__self__, "member", member)
        if service is not None:
            pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The email address of the Google managed service account.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The folder in which the resource belongs.
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "folder", value)

    @property
    @pulumi.getter
    def member(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Identity of the Google managed service account in the form 'serviceAccount:{email}'. This value is often used to refer to the service account in order to grant IAM permissions.
        """
        return pulumi.get(self, "member")

    @member.setter
    def member(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "member", value)

    @property
    @pulumi.getter
    def service(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The service to generate identity for.

        - - -
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service", value)


@pulumi.type_token("gcp:folder/serviceIdentity:ServiceIdentity")
class ServiceIdentity(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 folder: Optional[pulumi.Input[builtins.str]] = None,
                 service: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ### Folder Service Identity Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_folder = gcp.organizations.Folder("my_folder",
            parent="organizations/1234567",
            display_name="my-folder")
        osconfig_sa = gcp.folder.ServiceIdentity("osconfig_sa",
            folder=my_folder.folder_id,
            service="osconfig.googleapis.com")
        admin = gcp.folder.IAMMember("admin",
            folder=my_folder.name,
            role="roles/osconfig.serviceAgent",
            member=osconfig_sa.member)
        ```

        ## Import

        This resource does not support import.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] folder: The folder in which the resource belongs.
        :param pulumi.Input[builtins.str] service: The service to generate identity for.
               
               - - -
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceIdentityArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ### Folder Service Identity Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_folder = gcp.organizations.Folder("my_folder",
            parent="organizations/1234567",
            display_name="my-folder")
        osconfig_sa = gcp.folder.ServiceIdentity("osconfig_sa",
            folder=my_folder.folder_id,
            service="osconfig.googleapis.com")
        admin = gcp.folder.IAMMember("admin",
            folder=my_folder.name,
            role="roles/osconfig.serviceAgent",
            member=osconfig_sa.member)
        ```

        ## Import

        This resource does not support import.

        :param str resource_name: The name of the resource.
        :param ServiceIdentityArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceIdentityArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 folder: Optional[pulumi.Input[builtins.str]] = None,
                 service: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceIdentityArgs.__new__(ServiceIdentityArgs)

            if folder is None and not opts.urn:
                raise TypeError("Missing required property 'folder'")
            __props__.__dict__["folder"] = folder
            if service is None and not opts.urn:
                raise TypeError("Missing required property 'service'")
            __props__.__dict__["service"] = service
            __props__.__dict__["email"] = None
            __props__.__dict__["member"] = None
        super(ServiceIdentity, __self__).__init__(
            'gcp:folder/serviceIdentity:ServiceIdentity',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            email: Optional[pulumi.Input[builtins.str]] = None,
            folder: Optional[pulumi.Input[builtins.str]] = None,
            member: Optional[pulumi.Input[builtins.str]] = None,
            service: Optional[pulumi.Input[builtins.str]] = None) -> 'ServiceIdentity':
        """
        Get an existing ServiceIdentity resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] email: The email address of the Google managed service account.
        :param pulumi.Input[builtins.str] folder: The folder in which the resource belongs.
        :param pulumi.Input[builtins.str] member: The Identity of the Google managed service account in the form 'serviceAccount:{email}'. This value is often used to refer to the service account in order to grant IAM permissions.
        :param pulumi.Input[builtins.str] service: The service to generate identity for.
               
               - - -
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceIdentityState.__new__(_ServiceIdentityState)

        __props__.__dict__["email"] = email
        __props__.__dict__["folder"] = folder
        __props__.__dict__["member"] = member
        __props__.__dict__["service"] = service
        return ServiceIdentity(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def email(self) -> pulumi.Output[builtins.str]:
        """
        The email address of the Google managed service account.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def folder(self) -> pulumi.Output[builtins.str]:
        """
        The folder in which the resource belongs.
        """
        return pulumi.get(self, "folder")

    @property
    @pulumi.getter
    def member(self) -> pulumi.Output[builtins.str]:
        """
        The Identity of the Google managed service account in the form 'serviceAccount:{email}'. This value is often used to refer to the service account in order to grant IAM permissions.
        """
        return pulumi.get(self, "member")

    @property
    @pulumi.getter
    def service(self) -> pulumi.Output[builtins.str]:
        """
        The service to generate identity for.

        - - -
        """
        return pulumi.get(self, "service")

