# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'CodeToolsSettingEnabledTool',
    'CodeToolsSettingEnabledToolConfig',
    'RepositoryGroupIamBindingCondition',
    'RepositoryGroupIamMemberCondition',
    'RepositoryGroupRepository',
]

@pulumi.output_type
class CodeToolsSettingEnabledTool(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountConnector":
            suggest = "account_connector"
        elif key == "uriOverride":
            suggest = "uri_override"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CodeToolsSettingEnabledTool. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CodeToolsSettingEnabledTool.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CodeToolsSettingEnabledTool.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 handle: builtins.str,
                 tool: builtins.str,
                 account_connector: Optional[builtins.str] = None,
                 configs: Optional[Sequence['outputs.CodeToolsSettingEnabledToolConfig']] = None,
                 uri_override: Optional[builtins.str] = None):
        """
        :param builtins.str handle: Handle used to invoke the tool.
        :param builtins.str tool: Link to the Tool
        :param builtins.str account_connector: Link to the Dev Connect Account Connector that holds the user credentials.
               projects/{project}/locations/{location}/accountConnectors/{account_connector_id}
        :param Sequence['CodeToolsSettingEnabledToolConfigArgs'] configs: Configuration parameters for the tool.
               Structure is documented below.
        :param builtins.str uri_override: Overridden URI, if allowed by Tool.
        """
        pulumi.set(__self__, "handle", handle)
        pulumi.set(__self__, "tool", tool)
        if account_connector is not None:
            pulumi.set(__self__, "account_connector", account_connector)
        if configs is not None:
            pulumi.set(__self__, "configs", configs)
        if uri_override is not None:
            pulumi.set(__self__, "uri_override", uri_override)

    @property
    @pulumi.getter
    def handle(self) -> builtins.str:
        """
        Handle used to invoke the tool.
        """
        return pulumi.get(self, "handle")

    @property
    @pulumi.getter
    def tool(self) -> builtins.str:
        """
        Link to the Tool
        """
        return pulumi.get(self, "tool")

    @property
    @pulumi.getter(name="accountConnector")
    def account_connector(self) -> Optional[builtins.str]:
        """
        Link to the Dev Connect Account Connector that holds the user credentials.
        projects/{project}/locations/{location}/accountConnectors/{account_connector_id}
        """
        return pulumi.get(self, "account_connector")

    @property
    @pulumi.getter
    def configs(self) -> Optional[Sequence['outputs.CodeToolsSettingEnabledToolConfig']]:
        """
        Configuration parameters for the tool.
        Structure is documented below.
        """
        return pulumi.get(self, "configs")

    @property
    @pulumi.getter(name="uriOverride")
    def uri_override(self) -> Optional[builtins.str]:
        """
        Overridden URI, if allowed by Tool.
        """
        return pulumi.get(self, "uri_override")


@pulumi.output_type
class CodeToolsSettingEnabledToolConfig(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str key: Key of the configuration item.
        :param builtins.str value: Value of the configuration item.
               
               - - -
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        Key of the configuration item.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        Value of the configuration item.

        - - -
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class RepositoryGroupIamBindingCondition(dict):
    def __init__(__self__, *,
                 expression: builtins.str,
                 title: builtins.str,
                 description: Optional[builtins.str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> builtins.str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> builtins.str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class RepositoryGroupIamMemberCondition(dict):
    def __init__(__self__, *,
                 expression: builtins.str,
                 title: builtins.str,
                 description: Optional[builtins.str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> builtins.str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> builtins.str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class RepositoryGroupRepository(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "branchPattern":
            suggest = "branch_pattern"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepositoryGroupRepository. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepositoryGroupRepository.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepositoryGroupRepository.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 branch_pattern: builtins.str,
                 resource: builtins.str):
        """
        :param builtins.str branch_pattern: Required. The Git branch pattern used for indexing in RE2 syntax.
               See https://github.com/google/re2/wiki/syntax for syntax.
               
               - - -
        :param builtins.str resource: Required. The DeveloperConnect repository full resource name, relative resource name
               or resource URL to be indexed.
        """
        pulumi.set(__self__, "branch_pattern", branch_pattern)
        pulumi.set(__self__, "resource", resource)

    @property
    @pulumi.getter(name="branchPattern")
    def branch_pattern(self) -> builtins.str:
        """
        Required. The Git branch pattern used for indexing in RE2 syntax.
        See https://github.com/google/re2/wiki/syntax for syntax.

        - - -
        """
        return pulumi.get(self, "branch_pattern")

    @property
    @pulumi.getter
    def resource(self) -> builtins.str:
        """
        Required. The DeveloperConnect repository full resource name, relative resource name
        or resource URL to be indexed.
        """
        return pulumi.get(self, "resource")


