# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FleetArgs', 'Fleet']

@pulumi.input_type
class FleetArgs:
    def __init__(__self__, *,
                 default_cluster_config: Optional[pulumi.Input['FleetDefaultClusterConfigArgs']] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Fleet resource.
        :param pulumi.Input['FleetDefaultClusterConfigArgs'] default_cluster_config: The default cluster configurations to apply across the fleet.
               Structure is documented below.
        :param pulumi.Input[builtins.str] display_name: A user-assigned display name of the Fleet. When present, it must be between 4 to 30 characters.
               Allowed characters are: lowercase and uppercase letters, numbers, hyphen, single-quote, double-quote, space, and exclamation point.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        if default_cluster_config is not None:
            pulumi.set(__self__, "default_cluster_config", default_cluster_config)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="defaultClusterConfig")
    def default_cluster_config(self) -> Optional[pulumi.Input['FleetDefaultClusterConfigArgs']]:
        """
        The default cluster configurations to apply across the fleet.
        Structure is documented below.
        """
        return pulumi.get(self, "default_cluster_config")

    @default_cluster_config.setter
    def default_cluster_config(self, value: Optional[pulumi.Input['FleetDefaultClusterConfigArgs']]):
        pulumi.set(self, "default_cluster_config", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A user-assigned display name of the Fleet. When present, it must be between 4 to 30 characters.
        Allowed characters are: lowercase and uppercase letters, numbers, hyphen, single-quote, double-quote, space, and exclamation point.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _FleetState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 default_cluster_config: Optional[pulumi.Input['FleetDefaultClusterConfigArgs']] = None,
                 delete_time: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 states: Optional[pulumi.Input[Sequence[pulumi.Input['FleetStateArgs']]]] = None,
                 uid: Optional[pulumi.Input[builtins.str]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Fleet resources.
        :param pulumi.Input[builtins.str] create_time: The time the fleet was created, in RFC3339 text format.
        :param pulumi.Input['FleetDefaultClusterConfigArgs'] default_cluster_config: The default cluster configurations to apply across the fleet.
               Structure is documented below.
        :param pulumi.Input[builtins.str] delete_time: The time the fleet was deleted, in RFC3339 text format.
        :param pulumi.Input[builtins.str] display_name: A user-assigned display name of the Fleet. When present, it must be between 4 to 30 characters.
               Allowed characters are: lowercase and uppercase letters, numbers, hyphen, single-quote, double-quote, space, and exclamation point.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Sequence[pulumi.Input['FleetStateArgs']]] states: The state of the fleet resource.
               Structure is documented below.
        :param pulumi.Input[builtins.str] uid: Google-generated UUID for this resource. This is unique across all
               Fleet resources. If a Fleet resource is deleted and another
               resource with the same name is created, it gets a different uid.
        :param pulumi.Input[builtins.str] update_time: The time the fleet was last updated, in RFC3339 text format.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if default_cluster_config is not None:
            pulumi.set(__self__, "default_cluster_config", default_cluster_config)
        if delete_time is not None:
            pulumi.set(__self__, "delete_time", delete_time)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if states is not None:
            pulumi.set(__self__, "states", states)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time the fleet was created, in RFC3339 text format.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="defaultClusterConfig")
    def default_cluster_config(self) -> Optional[pulumi.Input['FleetDefaultClusterConfigArgs']]:
        """
        The default cluster configurations to apply across the fleet.
        Structure is documented below.
        """
        return pulumi.get(self, "default_cluster_config")

    @default_cluster_config.setter
    def default_cluster_config(self, value: Optional[pulumi.Input['FleetDefaultClusterConfigArgs']]):
        pulumi.set(self, "default_cluster_config", value)

    @property
    @pulumi.getter(name="deleteTime")
    def delete_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time the fleet was deleted, in RFC3339 text format.
        """
        return pulumi.get(self, "delete_time")

    @delete_time.setter
    def delete_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "delete_time", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A user-assigned display name of the Fleet. When present, it must be between 4 to 30 characters.
        Allowed characters are: lowercase and uppercase letters, numbers, hyphen, single-quote, double-quote, space, and exclamation point.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def states(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FleetStateArgs']]]]:
        """
        The state of the fleet resource.
        Structure is documented below.
        """
        return pulumi.get(self, "states")

    @states.setter
    def states(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FleetStateArgs']]]]):
        pulumi.set(self, "states", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Google-generated UUID for this resource. This is unique across all
        Fleet resources. If a Fleet resource is deleted and another
        resource with the same name is created, it gets a different uid.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "uid", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time the fleet was last updated, in RFC3339 text format.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:gkehub/fleet:Fleet")
class Fleet(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_cluster_config: Optional[pulumi.Input[Union['FleetDefaultClusterConfigArgs', 'FleetDefaultClusterConfigArgsDict']]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Fleet contains information about a group of clusters.

        To get more information about Fleet, see:

        * [API documentation](https://cloud.google.com/anthos/multicluster-management/reference/rest/v1/projects.locations.fleets)
        * How-to Guides
            * [Registering a Cluster to a Fleet](https://cloud.google.com/anthos/multicluster-management/connect/registering-a-cluster#register_cluster)

        ## Example Usage

        ### Gkehub Fleet Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.gkehub.Fleet("default",
            display_name="my production fleet",
            default_cluster_config={
                "security_posture_config": {
                    "mode": "DISABLED",
                    "vulnerability_mode": "VULNERABILITY_DISABLED",
                },
            })
        ```

        ## Import

        Fleet can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/global/fleets/default`

        * `{{project}}`

        When using the `pulumi import` command, Fleet can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:gkehub/fleet:Fleet default projects/{{project}}/locations/global/fleets/default
        ```

        ```sh
        $ pulumi import gcp:gkehub/fleet:Fleet default {{project}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['FleetDefaultClusterConfigArgs', 'FleetDefaultClusterConfigArgsDict']] default_cluster_config: The default cluster configurations to apply across the fleet.
               Structure is documented below.
        :param pulumi.Input[builtins.str] display_name: A user-assigned display name of the Fleet. When present, it must be between 4 to 30 characters.
               Allowed characters are: lowercase and uppercase letters, numbers, hyphen, single-quote, double-quote, space, and exclamation point.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[FleetArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Fleet contains information about a group of clusters.

        To get more information about Fleet, see:

        * [API documentation](https://cloud.google.com/anthos/multicluster-management/reference/rest/v1/projects.locations.fleets)
        * How-to Guides
            * [Registering a Cluster to a Fleet](https://cloud.google.com/anthos/multicluster-management/connect/registering-a-cluster#register_cluster)

        ## Example Usage

        ### Gkehub Fleet Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.gkehub.Fleet("default",
            display_name="my production fleet",
            default_cluster_config={
                "security_posture_config": {
                    "mode": "DISABLED",
                    "vulnerability_mode": "VULNERABILITY_DISABLED",
                },
            })
        ```

        ## Import

        Fleet can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/global/fleets/default`

        * `{{project}}`

        When using the `pulumi import` command, Fleet can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:gkehub/fleet:Fleet default projects/{{project}}/locations/global/fleets/default
        ```

        ```sh
        $ pulumi import gcp:gkehub/fleet:Fleet default {{project}}
        ```

        :param str resource_name: The name of the resource.
        :param FleetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FleetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_cluster_config: Optional[pulumi.Input[Union['FleetDefaultClusterConfigArgs', 'FleetDefaultClusterConfigArgsDict']]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FleetArgs.__new__(FleetArgs)

            __props__.__dict__["default_cluster_config"] = default_cluster_config
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["project"] = project
            __props__.__dict__["create_time"] = None
            __props__.__dict__["delete_time"] = None
            __props__.__dict__["states"] = None
            __props__.__dict__["uid"] = None
            __props__.__dict__["update_time"] = None
        super(Fleet, __self__).__init__(
            'gcp:gkehub/fleet:Fleet',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            default_cluster_config: Optional[pulumi.Input[Union['FleetDefaultClusterConfigArgs', 'FleetDefaultClusterConfigArgsDict']]] = None,
            delete_time: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            states: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FleetStateArgs', 'FleetStateArgsDict']]]]] = None,
            uid: Optional[pulumi.Input[builtins.str]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None) -> 'Fleet':
        """
        Get an existing Fleet resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] create_time: The time the fleet was created, in RFC3339 text format.
        :param pulumi.Input[Union['FleetDefaultClusterConfigArgs', 'FleetDefaultClusterConfigArgsDict']] default_cluster_config: The default cluster configurations to apply across the fleet.
               Structure is documented below.
        :param pulumi.Input[builtins.str] delete_time: The time the fleet was deleted, in RFC3339 text format.
        :param pulumi.Input[builtins.str] display_name: A user-assigned display name of the Fleet. When present, it must be between 4 to 30 characters.
               Allowed characters are: lowercase and uppercase letters, numbers, hyphen, single-quote, double-quote, space, and exclamation point.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FleetStateArgs', 'FleetStateArgsDict']]]] states: The state of the fleet resource.
               Structure is documented below.
        :param pulumi.Input[builtins.str] uid: Google-generated UUID for this resource. This is unique across all
               Fleet resources. If a Fleet resource is deleted and another
               resource with the same name is created, it gets a different uid.
        :param pulumi.Input[builtins.str] update_time: The time the fleet was last updated, in RFC3339 text format.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FleetState.__new__(_FleetState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["default_cluster_config"] = default_cluster_config
        __props__.__dict__["delete_time"] = delete_time
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["project"] = project
        __props__.__dict__["states"] = states
        __props__.__dict__["uid"] = uid
        __props__.__dict__["update_time"] = update_time
        return Fleet(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        The time the fleet was created, in RFC3339 text format.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="defaultClusterConfig")
    def default_cluster_config(self) -> pulumi.Output[Optional['outputs.FleetDefaultClusterConfig']]:
        """
        The default cluster configurations to apply across the fleet.
        Structure is documented below.
        """
        return pulumi.get(self, "default_cluster_config")

    @property
    @pulumi.getter(name="deleteTime")
    def delete_time(self) -> pulumi.Output[builtins.str]:
        """
        The time the fleet was deleted, in RFC3339 text format.
        """
        return pulumi.get(self, "delete_time")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A user-assigned display name of the Fleet. When present, it must be between 4 to 30 characters.
        Allowed characters are: lowercase and uppercase letters, numbers, hyphen, single-quote, double-quote, space, and exclamation point.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def states(self) -> pulumi.Output[Sequence['outputs.FleetState']]:
        """
        The state of the fleet resource.
        Structure is documented below.
        """
        return pulumi.get(self, "states")

    @property
    @pulumi.getter
    def uid(self) -> pulumi.Output[builtins.str]:
        """
        Google-generated UUID for this resource. This is unique across all
        Fleet resources. If a Fleet resource is deleted and another
        resource with the same name is created, it gets a different uid.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        The time the fleet was last updated, in RFC3339 text format.
        """
        return pulumi.get(self, "update_time")

