# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetFeatureResult',
    'AwaitableGetFeatureResult',
    'get_feature',
    'get_feature_output',
]

@pulumi.output_type
class GetFeatureResult:
    """
    A collection of values returned by getFeature.
    """
    def __init__(__self__, create_time=None, delete_time=None, effective_labels=None, fleet_default_member_configs=None, id=None, labels=None, location=None, name=None, project=None, pulumi_labels=None, resource_states=None, specs=None, states=None, update_time=None):
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if delete_time and not isinstance(delete_time, str):
            raise TypeError("Expected argument 'delete_time' to be a str")
        pulumi.set(__self__, "delete_time", delete_time)
        if effective_labels and not isinstance(effective_labels, dict):
            raise TypeError("Expected argument 'effective_labels' to be a dict")
        pulumi.set(__self__, "effective_labels", effective_labels)
        if fleet_default_member_configs and not isinstance(fleet_default_member_configs, list):
            raise TypeError("Expected argument 'fleet_default_member_configs' to be a list")
        pulumi.set(__self__, "fleet_default_member_configs", fleet_default_member_configs)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if pulumi_labels and not isinstance(pulumi_labels, dict):
            raise TypeError("Expected argument 'pulumi_labels' to be a dict")
        pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if resource_states and not isinstance(resource_states, list):
            raise TypeError("Expected argument 'resource_states' to be a list")
        pulumi.set(__self__, "resource_states", resource_states)
        if specs and not isinstance(specs, list):
            raise TypeError("Expected argument 'specs' to be a list")
        pulumi.set(__self__, "specs", specs)
        if states and not isinstance(states, list):
            raise TypeError("Expected argument 'states' to be a list")
        pulumi.set(__self__, "states", states)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> builtins.str:
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="deleteTime")
    def delete_time(self) -> builtins.str:
        return pulumi.get(self, "delete_time")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Mapping[str, builtins.str]:
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter(name="fleetDefaultMemberConfigs")
    def fleet_default_member_configs(self) -> Sequence['outputs.GetFeatureFleetDefaultMemberConfigResult']:
        return pulumi.get(self, "fleet_default_member_configs")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, builtins.str]:
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> builtins.str:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> Optional[builtins.str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Mapping[str, builtins.str]:
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter(name="resourceStates")
    def resource_states(self) -> Sequence['outputs.GetFeatureResourceStateResult']:
        return pulumi.get(self, "resource_states")

    @property
    @pulumi.getter
    def specs(self) -> Sequence['outputs.GetFeatureSpecResult']:
        return pulumi.get(self, "specs")

    @property
    @pulumi.getter
    def states(self) -> Sequence['outputs.GetFeatureStateResult']:
        return pulumi.get(self, "states")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> builtins.str:
        return pulumi.get(self, "update_time")


class AwaitableGetFeatureResult(GetFeatureResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFeatureResult(
            create_time=self.create_time,
            delete_time=self.delete_time,
            effective_labels=self.effective_labels,
            fleet_default_member_configs=self.fleet_default_member_configs,
            id=self.id,
            labels=self.labels,
            location=self.location,
            name=self.name,
            project=self.project,
            pulumi_labels=self.pulumi_labels,
            resource_states=self.resource_states,
            specs=self.specs,
            states=self.states,
            update_time=self.update_time)


def get_feature(location: Optional[builtins.str] = None,
                name: Optional[builtins.str] = None,
                project: Optional[builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFeatureResult:
    """
    Retrieves the details of a specific GKE Hub Feature. Use this data source to retrieve the feature's configuration and state.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    example = gcp.gkehub.get_feature(location="global",
        name="servicemesh")
    ```


    :param builtins.str location: The location for the GKE Hub Feature.
    :param builtins.str name: The name of the feature you want to know the status of.
    :param builtins.str project: The ID of the project in which the resource belongs.
           If it is not provided, the provider project is used.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['name'] = name
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:gkehub/getFeature:getFeature', __args__, opts=opts, typ=GetFeatureResult).value

    return AwaitableGetFeatureResult(
        create_time=pulumi.get(__ret__, 'create_time'),
        delete_time=pulumi.get(__ret__, 'delete_time'),
        effective_labels=pulumi.get(__ret__, 'effective_labels'),
        fleet_default_member_configs=pulumi.get(__ret__, 'fleet_default_member_configs'),
        id=pulumi.get(__ret__, 'id'),
        labels=pulumi.get(__ret__, 'labels'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        project=pulumi.get(__ret__, 'project'),
        pulumi_labels=pulumi.get(__ret__, 'pulumi_labels'),
        resource_states=pulumi.get(__ret__, 'resource_states'),
        specs=pulumi.get(__ret__, 'specs'),
        states=pulumi.get(__ret__, 'states'),
        update_time=pulumi.get(__ret__, 'update_time'))
def get_feature_output(location: Optional[pulumi.Input[builtins.str]] = None,
                       name: Optional[pulumi.Input[builtins.str]] = None,
                       project: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFeatureResult]:
    """
    Retrieves the details of a specific GKE Hub Feature. Use this data source to retrieve the feature's configuration and state.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    example = gcp.gkehub.get_feature(location="global",
        name="servicemesh")
    ```


    :param builtins.str location: The location for the GKE Hub Feature.
    :param builtins.str name: The name of the feature you want to know the status of.
    :param builtins.str project: The ID of the project in which the resource belongs.
           If it is not provided, the provider project is used.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['name'] = name
    __args__['project'] = project
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:gkehub/getFeature:getFeature', __args__, opts=opts, typ=GetFeatureResult)
    return __ret__.apply(lambda __response__: GetFeatureResult(
        create_time=pulumi.get(__response__, 'create_time'),
        delete_time=pulumi.get(__response__, 'delete_time'),
        effective_labels=pulumi.get(__response__, 'effective_labels'),
        fleet_default_member_configs=pulumi.get(__response__, 'fleet_default_member_configs'),
        id=pulumi.get(__response__, 'id'),
        labels=pulumi.get(__response__, 'labels'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        project=pulumi.get(__response__, 'project'),
        pulumi_labels=pulumi.get(__response__, 'pulumi_labels'),
        resource_states=pulumi.get(__response__, 'resource_states'),
        specs=pulumi.get(__response__, 'specs'),
        states=pulumi.get(__response__, 'states'),
        update_time=pulumi.get(__response__, 'update_time')))
