# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetRuleResult',
    'AwaitableGetRuleResult',
    'get_rule',
    'get_rule_output',
]

@pulumi.output_type
class GetRuleResult:
    """
    A collection of values returned by getRule.
    """
    def __init__(__self__, id=None, included_permissions=None, name=None, stage=None, title=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if included_permissions and not isinstance(included_permissions, list):
            raise TypeError("Expected argument 'included_permissions' to be a list")
        pulumi.set(__self__, "included_permissions", included_permissions)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if stage and not isinstance(stage, str):
            raise TypeError("Expected argument 'stage' to be a str")
        pulumi.set(__self__, "stage", stage)
        if title and not isinstance(title, str):
            raise TypeError("Expected argument 'title' to be a str")
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="includedPermissions")
    def included_permissions(self) -> Sequence[builtins.str]:
        """
        specifies the list of one or more permissions to include in the custom role, such as - `iam.roles.get`
        """
        return pulumi.get(self, "included_permissions")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def stage(self) -> builtins.str:
        """
        indicates the stage of a role in the launch lifecycle, such as `GA`, `BETA` or `ALPHA`.
        """
        return pulumi.get(self, "stage")

    @property
    @pulumi.getter
    def title(self) -> builtins.str:
        """
        is a friendly title for the role, such as "Role Viewer"
        """
        return pulumi.get(self, "title")


class AwaitableGetRuleResult(GetRuleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRuleResult(
            id=self.id,
            included_permissions=self.included_permissions,
            name=self.name,
            stage=self.stage,
            title=self.title)


def get_rule(name: Optional[builtins.str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRuleResult:
    """
    Use this data source to get information about a Google IAM Role.

    ```python
    import pulumi
    import pulumi_gcp as gcp

    roleinfo = gcp.iam.get_rule(name="roles/compute.viewer")
    pulumi.export("theRolePermissions", roleinfo.included_permissions)
    ```


    :param builtins.str name: The name of the Role to lookup in the form `roles/{ROLE_NAME}`, `organizations/{ORGANIZATION_ID}/roles/{ROLE_NAME}` or `projects/{PROJECT_ID}/roles/{ROLE_NAME}`
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:iam/getRule:getRule', __args__, opts=opts, typ=GetRuleResult).value

    return AwaitableGetRuleResult(
        id=pulumi.get(__ret__, 'id'),
        included_permissions=pulumi.get(__ret__, 'included_permissions'),
        name=pulumi.get(__ret__, 'name'),
        stage=pulumi.get(__ret__, 'stage'),
        title=pulumi.get(__ret__, 'title'))
def get_rule_output(name: Optional[pulumi.Input[builtins.str]] = None,
                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRuleResult]:
    """
    Use this data source to get information about a Google IAM Role.

    ```python
    import pulumi
    import pulumi_gcp as gcp

    roleinfo = gcp.iam.get_rule(name="roles/compute.viewer")
    pulumi.export("theRolePermissions", roleinfo.included_permissions)
    ```


    :param builtins.str name: The name of the Role to lookup in the form `roles/{ROLE_NAME}`, `organizations/{ORGANIZATION_ID}/roles/{ROLE_NAME}` or `projects/{PROJECT_ID}/roles/{ROLE_NAME}`
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:iam/getRule:getRule', __args__, opts=opts, typ=GetRuleResult)
    return __ret__.apply(lambda __response__: GetRuleResult(
        id=pulumi.get(__response__, 'id'),
        included_permissions=pulumi.get(__response__, 'included_permissions'),
        name=pulumi.get(__response__, 'name'),
        stage=pulumi.get(__response__, 'stage'),
        title=pulumi.get(__response__, 'title')))
