# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetWorkloadIdentityPoolResult',
    'AwaitableGetWorkloadIdentityPoolResult',
    'get_workload_identity_pool',
    'get_workload_identity_pool_output',
]

@pulumi.output_type
class GetWorkloadIdentityPoolResult:
    """
    A collection of values returned by getWorkloadIdentityPool.
    """
    def __init__(__self__, description=None, disabled=None, display_name=None, id=None, inline_certificate_issuance_configs=None, inline_trust_configs=None, mode=None, name=None, project=None, state=None, workload_identity_pool_id=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if disabled and not isinstance(disabled, bool):
            raise TypeError("Expected argument 'disabled' to be a bool")
        pulumi.set(__self__, "disabled", disabled)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if inline_certificate_issuance_configs and not isinstance(inline_certificate_issuance_configs, list):
            raise TypeError("Expected argument 'inline_certificate_issuance_configs' to be a list")
        pulumi.set(__self__, "inline_certificate_issuance_configs", inline_certificate_issuance_configs)
        if inline_trust_configs and not isinstance(inline_trust_configs, list):
            raise TypeError("Expected argument 'inline_trust_configs' to be a list")
        pulumi.set(__self__, "inline_trust_configs", inline_trust_configs)
        if mode and not isinstance(mode, str):
            raise TypeError("Expected argument 'mode' to be a str")
        pulumi.set(__self__, "mode", mode)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if workload_identity_pool_id and not isinstance(workload_identity_pool_id, str):
            raise TypeError("Expected argument 'workload_identity_pool_id' to be a str")
        pulumi.set(__self__, "workload_identity_pool_id", workload_identity_pool_id)

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def disabled(self) -> builtins.bool:
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="inlineCertificateIssuanceConfigs")
    def inline_certificate_issuance_configs(self) -> Sequence['outputs.GetWorkloadIdentityPoolInlineCertificateIssuanceConfigResult']:
        return pulumi.get(self, "inline_certificate_issuance_configs")

    @property
    @pulumi.getter(name="inlineTrustConfigs")
    def inline_trust_configs(self) -> Sequence['outputs.GetWorkloadIdentityPoolInlineTrustConfigResult']:
        return pulumi.get(self, "inline_trust_configs")

    @property
    @pulumi.getter
    def mode(self) -> builtins.str:
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> Optional[builtins.str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="workloadIdentityPoolId")
    def workload_identity_pool_id(self) -> builtins.str:
        return pulumi.get(self, "workload_identity_pool_id")


class AwaitableGetWorkloadIdentityPoolResult(GetWorkloadIdentityPoolResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetWorkloadIdentityPoolResult(
            description=self.description,
            disabled=self.disabled,
            display_name=self.display_name,
            id=self.id,
            inline_certificate_issuance_configs=self.inline_certificate_issuance_configs,
            inline_trust_configs=self.inline_trust_configs,
            mode=self.mode,
            name=self.name,
            project=self.project,
            state=self.state,
            workload_identity_pool_id=self.workload_identity_pool_id)


def get_workload_identity_pool(project: Optional[builtins.str] = None,
                               workload_identity_pool_id: Optional[builtins.str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetWorkloadIdentityPoolResult:
    """
    Get a IAM workload identity pool from Google Cloud by its id.
    > **Note:** The following resource requires the Beta IAM role `roles/iam.workloadIdentityPoolAdmin` in order to succeed. `OWNER` and `EDITOR` roles do not include the necessary permissions.
    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    foo = gcp.iam.get_workload_identity_pool(workload_identity_pool_id="foo-pool")
    ```


    :param builtins.str project: The project in which the resource belongs. If it
           is not provided, the provider project is used.
    :param builtins.str workload_identity_pool_id: The id of the pool which is the
           final component of the resource name.
           
           - - -
    """
    __args__ = dict()
    __args__['project'] = project
    __args__['workloadIdentityPoolId'] = workload_identity_pool_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:iam/getWorkloadIdentityPool:getWorkloadIdentityPool', __args__, opts=opts, typ=GetWorkloadIdentityPoolResult).value

    return AwaitableGetWorkloadIdentityPoolResult(
        description=pulumi.get(__ret__, 'description'),
        disabled=pulumi.get(__ret__, 'disabled'),
        display_name=pulumi.get(__ret__, 'display_name'),
        id=pulumi.get(__ret__, 'id'),
        inline_certificate_issuance_configs=pulumi.get(__ret__, 'inline_certificate_issuance_configs'),
        inline_trust_configs=pulumi.get(__ret__, 'inline_trust_configs'),
        mode=pulumi.get(__ret__, 'mode'),
        name=pulumi.get(__ret__, 'name'),
        project=pulumi.get(__ret__, 'project'),
        state=pulumi.get(__ret__, 'state'),
        workload_identity_pool_id=pulumi.get(__ret__, 'workload_identity_pool_id'))
def get_workload_identity_pool_output(project: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                      workload_identity_pool_id: Optional[pulumi.Input[builtins.str]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetWorkloadIdentityPoolResult]:
    """
    Get a IAM workload identity pool from Google Cloud by its id.
    > **Note:** The following resource requires the Beta IAM role `roles/iam.workloadIdentityPoolAdmin` in order to succeed. `OWNER` and `EDITOR` roles do not include the necessary permissions.
    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    foo = gcp.iam.get_workload_identity_pool(workload_identity_pool_id="foo-pool")
    ```


    :param builtins.str project: The project in which the resource belongs. If it
           is not provided, the provider project is used.
    :param builtins.str workload_identity_pool_id: The id of the pool which is the
           final component of the resource name.
           
           - - -
    """
    __args__ = dict()
    __args__['project'] = project
    __args__['workloadIdentityPoolId'] = workload_identity_pool_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:iam/getWorkloadIdentityPool:getWorkloadIdentityPool', __args__, opts=opts, typ=GetWorkloadIdentityPoolResult)
    return __ret__.apply(lambda __response__: GetWorkloadIdentityPoolResult(
        description=pulumi.get(__response__, 'description'),
        disabled=pulumi.get(__response__, 'disabled'),
        display_name=pulumi.get(__response__, 'display_name'),
        id=pulumi.get(__response__, 'id'),
        inline_certificate_issuance_configs=pulumi.get(__response__, 'inline_certificate_issuance_configs'),
        inline_trust_configs=pulumi.get(__response__, 'inline_trust_configs'),
        mode=pulumi.get(__response__, 'mode'),
        name=pulumi.get(__response__, 'name'),
        project=pulumi.get(__response__, 'project'),
        state=pulumi.get(__response__, 'state'),
        workload_identity_pool_id=pulumi.get(__response__, 'workload_identity_pool_id')))
