# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['OrganizationsPolicyBindingArgs', 'OrganizationsPolicyBinding']

@pulumi.input_type
class OrganizationsPolicyBindingArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[builtins.str],
                 organization: pulumi.Input[builtins.str],
                 policy: pulumi.Input[builtins.str],
                 policy_binding_id: pulumi.Input[builtins.str],
                 target: pulumi.Input['OrganizationsPolicyBindingTargetArgs'],
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 condition: Optional[pulumi.Input['OrganizationsPolicyBindingConditionArgs']] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 policy_kind: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a OrganizationsPolicyBinding resource.
        :param pulumi.Input[builtins.str] location: The location of the Policy Binding
        :param pulumi.Input[builtins.str] organization: The parent organization of the Policy Binding.
        :param pulumi.Input[builtins.str] policy: Required. Immutable. The resource name of the policy to be bound. The binding parent and policy must belong to the same Organization (or Project).
        :param pulumi.Input[builtins.str] policy_binding_id: The Policy Binding ID.
        :param pulumi.Input['OrganizationsPolicyBindingTargetArgs'] target: Target is the full resource name of the resource to which the policy will be bound. Immutable once set.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] annotations: Optional. User defined annotations. See https://google.aip.dev/148#annotations for more details such as format and size
               limitations **Note**: This field is non-authoritative, and will only manage the annotations present in your
               configuration. Please refer to the field 'effective_annotations' for all of the annotations present on the resource.
        :param pulumi.Input['OrganizationsPolicyBindingConditionArgs'] condition: Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The
               syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: \\"Summary
               size limit\\" description: \\"Determines if a summary is less than 100 chars\\" expression: \\"document.summary.size() <
               100\\" Example (Equality): title: \\"Requestor is owner\\" description: \\"Determines if requestor is the document owner\\"
               expression: \\"document.owner == request.auth.claims.email\\" Example (Logic): title: \\"Public documents\\" description:
               \\"Determine whether the document should be publicly visible\\" expression: \\"document.type != 'private' && document.type
               != 'internal'\\" Example (Data Manipulation): title: \\"Notification string\\" description: \\"Create a notification string
               with a timestamp.\\" expression: \\"'New message received at ' + string(document.create_time)\\" The exact variables and
               functions that may be referenced within an expression are determined by the service that evaluates it. See the service
               documentation for additional information.
        :param pulumi.Input[builtins.str] display_name: Optional. The description of the policy binding. Must be less than or equal to 63 characters.
        :param pulumi.Input[builtins.str] policy_kind: Immutable. The kind of the policy to attach in this binding. This field must be one of the following: - Left empty (will
               be automatically set to the policy kind) - The input policy kind Possible values: POLICY_KIND_UNSPECIFIED
               PRINCIPAL_ACCESS_BOUNDARY ACCESS
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "organization", organization)
        pulumi.set(__self__, "policy", policy)
        pulumi.set(__self__, "policy_binding_id", policy_binding_id)
        pulumi.set(__self__, "target", target)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if policy_kind is not None:
            pulumi.set(__self__, "policy_kind", policy_kind)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        The location of the Policy Binding
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def organization(self) -> pulumi.Input[builtins.str]:
        """
        The parent organization of the Policy Binding.
        """
        return pulumi.get(self, "organization")

    @organization.setter
    def organization(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "organization", value)

    @property
    @pulumi.getter
    def policy(self) -> pulumi.Input[builtins.str]:
        """
        Required. Immutable. The resource name of the policy to be bound. The binding parent and policy must belong to the same Organization (or Project).
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "policy", value)

    @property
    @pulumi.getter(name="policyBindingId")
    def policy_binding_id(self) -> pulumi.Input[builtins.str]:
        """
        The Policy Binding ID.
        """
        return pulumi.get(self, "policy_binding_id")

    @policy_binding_id.setter
    def policy_binding_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "policy_binding_id", value)

    @property
    @pulumi.getter
    def target(self) -> pulumi.Input['OrganizationsPolicyBindingTargetArgs']:
        """
        Target is the full resource name of the resource to which the policy will be bound. Immutable once set.
        Structure is documented below.
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: pulumi.Input['OrganizationsPolicyBindingTargetArgs']):
        pulumi.set(self, "target", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Optional. User defined annotations. See https://google.aip.dev/148#annotations for more details such as format and size
        limitations **Note**: This field is non-authoritative, and will only manage the annotations present in your
        configuration. Please refer to the field 'effective_annotations' for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input['OrganizationsPolicyBindingConditionArgs']]:
        """
        Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The
        syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: \\"Summary
        size limit\\" description: \\"Determines if a summary is less than 100 chars\\" expression: \\"document.summary.size() <
        100\\" Example (Equality): title: \\"Requestor is owner\\" description: \\"Determines if requestor is the document owner\\"
        expression: \\"document.owner == request.auth.claims.email\\" Example (Logic): title: \\"Public documents\\" description:
        \\"Determine whether the document should be publicly visible\\" expression: \\"document.type != 'private' && document.type
        != 'internal'\\" Example (Data Manipulation): title: \\"Notification string\\" description: \\"Create a notification string
        with a timestamp.\\" expression: \\"'New message received at ' + string(document.create_time)\\" The exact variables and
        functions that may be referenced within an expression are determined by the service that evaluates it. See the service
        documentation for additional information.
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input['OrganizationsPolicyBindingConditionArgs']]):
        pulumi.set(self, "condition", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional. The description of the policy binding. Must be less than or equal to 63 characters.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="policyKind")
    def policy_kind(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Immutable. The kind of the policy to attach in this binding. This field must be one of the following: - Left empty (will
        be automatically set to the policy kind) - The input policy kind Possible values: POLICY_KIND_UNSPECIFIED
        PRINCIPAL_ACCESS_BOUNDARY ACCESS
        """
        return pulumi.get(self, "policy_kind")

    @policy_kind.setter
    def policy_kind(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "policy_kind", value)


@pulumi.input_type
class _OrganizationsPolicyBindingState:
    def __init__(__self__, *,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 condition: Optional[pulumi.Input['OrganizationsPolicyBindingConditionArgs']] = None,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 effective_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 etag: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 organization: Optional[pulumi.Input[builtins.str]] = None,
                 policy: Optional[pulumi.Input[builtins.str]] = None,
                 policy_binding_id: Optional[pulumi.Input[builtins.str]] = None,
                 policy_kind: Optional[pulumi.Input[builtins.str]] = None,
                 policy_uid: Optional[pulumi.Input[builtins.str]] = None,
                 target: Optional[pulumi.Input['OrganizationsPolicyBindingTargetArgs']] = None,
                 uid: Optional[pulumi.Input[builtins.str]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering OrganizationsPolicyBinding resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] annotations: Optional. User defined annotations. See https://google.aip.dev/148#annotations for more details such as format and size
               limitations **Note**: This field is non-authoritative, and will only manage the annotations present in your
               configuration. Please refer to the field 'effective_annotations' for all of the annotations present on the resource.
        :param pulumi.Input['OrganizationsPolicyBindingConditionArgs'] condition: Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The
               syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: \\"Summary
               size limit\\" description: \\"Determines if a summary is less than 100 chars\\" expression: \\"document.summary.size() <
               100\\" Example (Equality): title: \\"Requestor is owner\\" description: \\"Determines if requestor is the document owner\\"
               expression: \\"document.owner == request.auth.claims.email\\" Example (Logic): title: \\"Public documents\\" description:
               \\"Determine whether the document should be publicly visible\\" expression: \\"document.type != 'private' && document.type
               != 'internal'\\" Example (Data Manipulation): title: \\"Notification string\\" description: \\"Create a notification string
               with a timestamp.\\" expression: \\"'New message received at ' + string(document.create_time)\\" The exact variables and
               functions that may be referenced within an expression are determined by the service that evaluates it. See the service
               documentation for additional information.
        :param pulumi.Input[builtins.str] create_time: Output only. The time when the policy binding was created.
        :param pulumi.Input[builtins.str] display_name: Optional. The description of the policy binding. Must be less than or equal to 63 characters.
        :param pulumi.Input[builtins.str] etag: Optional. The etag for the policy binding. If this is provided on update, it must match the server's etag.
        :param pulumi.Input[builtins.str] location: The location of the Policy Binding
        :param pulumi.Input[builtins.str] name: The name of the policy binding in the format `{binding_parent/locations/{location}/policyBindings/{policy_binding_id}`
        :param pulumi.Input[builtins.str] organization: The parent organization of the Policy Binding.
        :param pulumi.Input[builtins.str] policy: Required. Immutable. The resource name of the policy to be bound. The binding parent and policy must belong to the same Organization (or Project).
        :param pulumi.Input[builtins.str] policy_binding_id: The Policy Binding ID.
        :param pulumi.Input[builtins.str] policy_kind: Immutable. The kind of the policy to attach in this binding. This field must be one of the following: - Left empty (will
               be automatically set to the policy kind) - The input policy kind Possible values: POLICY_KIND_UNSPECIFIED
               PRINCIPAL_ACCESS_BOUNDARY ACCESS
        :param pulumi.Input[builtins.str] policy_uid: Output only. The globally unique ID of the policy to be bound.
        :param pulumi.Input['OrganizationsPolicyBindingTargetArgs'] target: Target is the full resource name of the resource to which the policy will be bound. Immutable once set.
               Structure is documented below.
        :param pulumi.Input[builtins.str] uid: Output only. The globally unique ID of the policy binding. Assigned when the policy binding is created.
        :param pulumi.Input[builtins.str] update_time: Output only. The time when the policy binding was most recently updated.
        """
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if effective_annotations is not None:
            pulumi.set(__self__, "effective_annotations", effective_annotations)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if organization is not None:
            pulumi.set(__self__, "organization", organization)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if policy_binding_id is not None:
            pulumi.set(__self__, "policy_binding_id", policy_binding_id)
        if policy_kind is not None:
            pulumi.set(__self__, "policy_kind", policy_kind)
        if policy_uid is not None:
            pulumi.set(__self__, "policy_uid", policy_uid)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Optional. User defined annotations. See https://google.aip.dev/148#annotations for more details such as format and size
        limitations **Note**: This field is non-authoritative, and will only manage the annotations present in your
        configuration. Please refer to the field 'effective_annotations' for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input['OrganizationsPolicyBindingConditionArgs']]:
        """
        Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The
        syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: \\"Summary
        size limit\\" description: \\"Determines if a summary is less than 100 chars\\" expression: \\"document.summary.size() <
        100\\" Example (Equality): title: \\"Requestor is owner\\" description: \\"Determines if requestor is the document owner\\"
        expression: \\"document.owner == request.auth.claims.email\\" Example (Logic): title: \\"Public documents\\" description:
        \\"Determine whether the document should be publicly visible\\" expression: \\"document.type != 'private' && document.type
        != 'internal'\\" Example (Data Manipulation): title: \\"Notification string\\" description: \\"Create a notification string
        with a timestamp.\\" expression: \\"'New message received at ' + string(document.create_time)\\" The exact variables and
        functions that may be referenced within an expression are determined by the service that evaluates it. See the service
        documentation for additional information.
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input['OrganizationsPolicyBindingConditionArgs']]):
        pulumi.set(self, "condition", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. The time when the policy binding was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional. The description of the policy binding. Must be less than or equal to 63 characters.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "effective_annotations")

    @effective_annotations.setter
    def effective_annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_annotations", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional. The etag for the policy binding. If this is provided on update, it must match the server's etag.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location of the Policy Binding
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the policy binding in the format `{binding_parent/locations/{location}/policyBindings/{policy_binding_id}`
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def organization(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The parent organization of the Policy Binding.
        """
        return pulumi.get(self, "organization")

    @organization.setter
    def organization(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "organization", value)

    @property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Required. Immutable. The resource name of the policy to be bound. The binding parent and policy must belong to the same Organization (or Project).
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "policy", value)

    @property
    @pulumi.getter(name="policyBindingId")
    def policy_binding_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Policy Binding ID.
        """
        return pulumi.get(self, "policy_binding_id")

    @policy_binding_id.setter
    def policy_binding_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "policy_binding_id", value)

    @property
    @pulumi.getter(name="policyKind")
    def policy_kind(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Immutable. The kind of the policy to attach in this binding. This field must be one of the following: - Left empty (will
        be automatically set to the policy kind) - The input policy kind Possible values: POLICY_KIND_UNSPECIFIED
        PRINCIPAL_ACCESS_BOUNDARY ACCESS
        """
        return pulumi.get(self, "policy_kind")

    @policy_kind.setter
    def policy_kind(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "policy_kind", value)

    @property
    @pulumi.getter(name="policyUid")
    def policy_uid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. The globally unique ID of the policy to be bound.
        """
        return pulumi.get(self, "policy_uid")

    @policy_uid.setter
    def policy_uid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "policy_uid", value)

    @property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input['OrganizationsPolicyBindingTargetArgs']]:
        """
        Target is the full resource name of the resource to which the policy will be bound. Immutable once set.
        Structure is documented below.
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input['OrganizationsPolicyBindingTargetArgs']]):
        pulumi.set(self, "target", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. The globally unique ID of the policy binding. Assigned when the policy binding is created.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "uid", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. The time when the policy binding was most recently updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:iam/organizationsPolicyBinding:OrganizationsPolicyBinding")
class OrganizationsPolicyBinding(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 condition: Optional[pulumi.Input[Union['OrganizationsPolicyBindingConditionArgs', 'OrganizationsPolicyBindingConditionArgsDict']]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 organization: Optional[pulumi.Input[builtins.str]] = None,
                 policy: Optional[pulumi.Input[builtins.str]] = None,
                 policy_binding_id: Optional[pulumi.Input[builtins.str]] = None,
                 policy_kind: Optional[pulumi.Input[builtins.str]] = None,
                 target: Optional[pulumi.Input[Union['OrganizationsPolicyBindingTargetArgs', 'OrganizationsPolicyBindingTargetArgsDict']]] = None,
                 __props__=None):
        """
        ## Example Usage

        ### Iam Organizations Policy Binding

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_time as time

        pab_policy = gcp.iam.PrincipalAccessBoundaryPolicy("pab_policy",
            organization="123456789",
            location="global",
            display_name="binding for all principals in the Organization",
            principal_access_boundary_policy_id="my-pab-policy")
        wait60_seconds = time.index.Sleep("wait_60_seconds", create_duration=60s,
        opts = pulumi.ResourceOptions(depends_on=[pab_policy]))
        binding_for_all_org_principals = gcp.iam.OrganizationsPolicyBinding("binding-for-all-org-principals",
            organization="123456789",
            location="global",
            display_name="binding for all principals in the Organization",
            policy_kind="PRINCIPAL_ACCESS_BOUNDARY",
            policy_binding_id="binding-for-all-org-principals",
            policy=pab_policy.principal_access_boundary_policy_id.apply(lambda principal_access_boundary_policy_id: f"organizations/123456789/locations/global/principalAccessBoundaryPolicies/{principal_access_boundary_policy_id}"),
            target={
                "principal_set": "//cloudresourcemanager.googleapis.com/organizations/123456789",
            },
            opts = pulumi.ResourceOptions(depends_on=[wait60_seconds]))
        ```

        ## Import

        OrganizationsPolicyBinding can be imported using any of these accepted formats:

        * `organizations/{{organization}}/locations/{{location}}/policyBindings/{{policy_binding_id}}`

        * `{{organization}}/{{location}}/{{policy_binding_id}}`

        When using the `pulumi import` command, OrganizationsPolicyBinding can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:iam/organizationsPolicyBinding:OrganizationsPolicyBinding default organizations/{{organization}}/locations/{{location}}/policyBindings/{{policy_binding_id}}
        ```

        ```sh
        $ pulumi import gcp:iam/organizationsPolicyBinding:OrganizationsPolicyBinding default {{organization}}/{{location}}/{{policy_binding_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] annotations: Optional. User defined annotations. See https://google.aip.dev/148#annotations for more details such as format and size
               limitations **Note**: This field is non-authoritative, and will only manage the annotations present in your
               configuration. Please refer to the field 'effective_annotations' for all of the annotations present on the resource.
        :param pulumi.Input[Union['OrganizationsPolicyBindingConditionArgs', 'OrganizationsPolicyBindingConditionArgsDict']] condition: Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The
               syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: \\"Summary
               size limit\\" description: \\"Determines if a summary is less than 100 chars\\" expression: \\"document.summary.size() <
               100\\" Example (Equality): title: \\"Requestor is owner\\" description: \\"Determines if requestor is the document owner\\"
               expression: \\"document.owner == request.auth.claims.email\\" Example (Logic): title: \\"Public documents\\" description:
               \\"Determine whether the document should be publicly visible\\" expression: \\"document.type != 'private' && document.type
               != 'internal'\\" Example (Data Manipulation): title: \\"Notification string\\" description: \\"Create a notification string
               with a timestamp.\\" expression: \\"'New message received at ' + string(document.create_time)\\" The exact variables and
               functions that may be referenced within an expression are determined by the service that evaluates it. See the service
               documentation for additional information.
        :param pulumi.Input[builtins.str] display_name: Optional. The description of the policy binding. Must be less than or equal to 63 characters.
        :param pulumi.Input[builtins.str] location: The location of the Policy Binding
        :param pulumi.Input[builtins.str] organization: The parent organization of the Policy Binding.
        :param pulumi.Input[builtins.str] policy: Required. Immutable. The resource name of the policy to be bound. The binding parent and policy must belong to the same Organization (or Project).
        :param pulumi.Input[builtins.str] policy_binding_id: The Policy Binding ID.
        :param pulumi.Input[builtins.str] policy_kind: Immutable. The kind of the policy to attach in this binding. This field must be one of the following: - Left empty (will
               be automatically set to the policy kind) - The input policy kind Possible values: POLICY_KIND_UNSPECIFIED
               PRINCIPAL_ACCESS_BOUNDARY ACCESS
        :param pulumi.Input[Union['OrganizationsPolicyBindingTargetArgs', 'OrganizationsPolicyBindingTargetArgsDict']] target: Target is the full resource name of the resource to which the policy will be bound. Immutable once set.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OrganizationsPolicyBindingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ### Iam Organizations Policy Binding

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_time as time

        pab_policy = gcp.iam.PrincipalAccessBoundaryPolicy("pab_policy",
            organization="123456789",
            location="global",
            display_name="binding for all principals in the Organization",
            principal_access_boundary_policy_id="my-pab-policy")
        wait60_seconds = time.index.Sleep("wait_60_seconds", create_duration=60s,
        opts = pulumi.ResourceOptions(depends_on=[pab_policy]))
        binding_for_all_org_principals = gcp.iam.OrganizationsPolicyBinding("binding-for-all-org-principals",
            organization="123456789",
            location="global",
            display_name="binding for all principals in the Organization",
            policy_kind="PRINCIPAL_ACCESS_BOUNDARY",
            policy_binding_id="binding-for-all-org-principals",
            policy=pab_policy.principal_access_boundary_policy_id.apply(lambda principal_access_boundary_policy_id: f"organizations/123456789/locations/global/principalAccessBoundaryPolicies/{principal_access_boundary_policy_id}"),
            target={
                "principal_set": "//cloudresourcemanager.googleapis.com/organizations/123456789",
            },
            opts = pulumi.ResourceOptions(depends_on=[wait60_seconds]))
        ```

        ## Import

        OrganizationsPolicyBinding can be imported using any of these accepted formats:

        * `organizations/{{organization}}/locations/{{location}}/policyBindings/{{policy_binding_id}}`

        * `{{organization}}/{{location}}/{{policy_binding_id}}`

        When using the `pulumi import` command, OrganizationsPolicyBinding can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:iam/organizationsPolicyBinding:OrganizationsPolicyBinding default organizations/{{organization}}/locations/{{location}}/policyBindings/{{policy_binding_id}}
        ```

        ```sh
        $ pulumi import gcp:iam/organizationsPolicyBinding:OrganizationsPolicyBinding default {{organization}}/{{location}}/{{policy_binding_id}}
        ```

        :param str resource_name: The name of the resource.
        :param OrganizationsPolicyBindingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OrganizationsPolicyBindingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 condition: Optional[pulumi.Input[Union['OrganizationsPolicyBindingConditionArgs', 'OrganizationsPolicyBindingConditionArgsDict']]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 organization: Optional[pulumi.Input[builtins.str]] = None,
                 policy: Optional[pulumi.Input[builtins.str]] = None,
                 policy_binding_id: Optional[pulumi.Input[builtins.str]] = None,
                 policy_kind: Optional[pulumi.Input[builtins.str]] = None,
                 target: Optional[pulumi.Input[Union['OrganizationsPolicyBindingTargetArgs', 'OrganizationsPolicyBindingTargetArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OrganizationsPolicyBindingArgs.__new__(OrganizationsPolicyBindingArgs)

            __props__.__dict__["annotations"] = annotations
            __props__.__dict__["condition"] = condition
            __props__.__dict__["display_name"] = display_name
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            if organization is None and not opts.urn:
                raise TypeError("Missing required property 'organization'")
            __props__.__dict__["organization"] = organization
            if policy is None and not opts.urn:
                raise TypeError("Missing required property 'policy'")
            __props__.__dict__["policy"] = policy
            if policy_binding_id is None and not opts.urn:
                raise TypeError("Missing required property 'policy_binding_id'")
            __props__.__dict__["policy_binding_id"] = policy_binding_id
            __props__.__dict__["policy_kind"] = policy_kind
            if target is None and not opts.urn:
                raise TypeError("Missing required property 'target'")
            __props__.__dict__["target"] = target
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_annotations"] = None
            __props__.__dict__["etag"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["policy_uid"] = None
            __props__.__dict__["uid"] = None
            __props__.__dict__["update_time"] = None
        super(OrganizationsPolicyBinding, __self__).__init__(
            'gcp:iam/organizationsPolicyBinding:OrganizationsPolicyBinding',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            condition: Optional[pulumi.Input[Union['OrganizationsPolicyBindingConditionArgs', 'OrganizationsPolicyBindingConditionArgsDict']]] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            effective_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            etag: Optional[pulumi.Input[builtins.str]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            organization: Optional[pulumi.Input[builtins.str]] = None,
            policy: Optional[pulumi.Input[builtins.str]] = None,
            policy_binding_id: Optional[pulumi.Input[builtins.str]] = None,
            policy_kind: Optional[pulumi.Input[builtins.str]] = None,
            policy_uid: Optional[pulumi.Input[builtins.str]] = None,
            target: Optional[pulumi.Input[Union['OrganizationsPolicyBindingTargetArgs', 'OrganizationsPolicyBindingTargetArgsDict']]] = None,
            uid: Optional[pulumi.Input[builtins.str]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None) -> 'OrganizationsPolicyBinding':
        """
        Get an existing OrganizationsPolicyBinding resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] annotations: Optional. User defined annotations. See https://google.aip.dev/148#annotations for more details such as format and size
               limitations **Note**: This field is non-authoritative, and will only manage the annotations present in your
               configuration. Please refer to the field 'effective_annotations' for all of the annotations present on the resource.
        :param pulumi.Input[Union['OrganizationsPolicyBindingConditionArgs', 'OrganizationsPolicyBindingConditionArgsDict']] condition: Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The
               syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: \\"Summary
               size limit\\" description: \\"Determines if a summary is less than 100 chars\\" expression: \\"document.summary.size() <
               100\\" Example (Equality): title: \\"Requestor is owner\\" description: \\"Determines if requestor is the document owner\\"
               expression: \\"document.owner == request.auth.claims.email\\" Example (Logic): title: \\"Public documents\\" description:
               \\"Determine whether the document should be publicly visible\\" expression: \\"document.type != 'private' && document.type
               != 'internal'\\" Example (Data Manipulation): title: \\"Notification string\\" description: \\"Create a notification string
               with a timestamp.\\" expression: \\"'New message received at ' + string(document.create_time)\\" The exact variables and
               functions that may be referenced within an expression are determined by the service that evaluates it. See the service
               documentation for additional information.
        :param pulumi.Input[builtins.str] create_time: Output only. The time when the policy binding was created.
        :param pulumi.Input[builtins.str] display_name: Optional. The description of the policy binding. Must be less than or equal to 63 characters.
        :param pulumi.Input[builtins.str] etag: Optional. The etag for the policy binding. If this is provided on update, it must match the server's etag.
        :param pulumi.Input[builtins.str] location: The location of the Policy Binding
        :param pulumi.Input[builtins.str] name: The name of the policy binding in the format `{binding_parent/locations/{location}/policyBindings/{policy_binding_id}`
        :param pulumi.Input[builtins.str] organization: The parent organization of the Policy Binding.
        :param pulumi.Input[builtins.str] policy: Required. Immutable. The resource name of the policy to be bound. The binding parent and policy must belong to the same Organization (or Project).
        :param pulumi.Input[builtins.str] policy_binding_id: The Policy Binding ID.
        :param pulumi.Input[builtins.str] policy_kind: Immutable. The kind of the policy to attach in this binding. This field must be one of the following: - Left empty (will
               be automatically set to the policy kind) - The input policy kind Possible values: POLICY_KIND_UNSPECIFIED
               PRINCIPAL_ACCESS_BOUNDARY ACCESS
        :param pulumi.Input[builtins.str] policy_uid: Output only. The globally unique ID of the policy to be bound.
        :param pulumi.Input[Union['OrganizationsPolicyBindingTargetArgs', 'OrganizationsPolicyBindingTargetArgsDict']] target: Target is the full resource name of the resource to which the policy will be bound. Immutable once set.
               Structure is documented below.
        :param pulumi.Input[builtins.str] uid: Output only. The globally unique ID of the policy binding. Assigned when the policy binding is created.
        :param pulumi.Input[builtins.str] update_time: Output only. The time when the policy binding was most recently updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OrganizationsPolicyBindingState.__new__(_OrganizationsPolicyBindingState)

        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["condition"] = condition
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["effective_annotations"] = effective_annotations
        __props__.__dict__["etag"] = etag
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["organization"] = organization
        __props__.__dict__["policy"] = policy
        __props__.__dict__["policy_binding_id"] = policy_binding_id
        __props__.__dict__["policy_kind"] = policy_kind
        __props__.__dict__["policy_uid"] = policy_uid
        __props__.__dict__["target"] = target
        __props__.__dict__["uid"] = uid
        __props__.__dict__["update_time"] = update_time
        return OrganizationsPolicyBinding(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Optional. User defined annotations. See https://google.aip.dev/148#annotations for more details such as format and size
        limitations **Note**: This field is non-authoritative, and will only manage the annotations present in your
        configuration. Please refer to the field 'effective_annotations' for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def condition(self) -> pulumi.Output[Optional['outputs.OrganizationsPolicyBindingCondition']]:
        """
        Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The
        syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: \\"Summary
        size limit\\" description: \\"Determines if a summary is less than 100 chars\\" expression: \\"document.summary.size() <
        100\\" Example (Equality): title: \\"Requestor is owner\\" description: \\"Determines if requestor is the document owner\\"
        expression: \\"document.owner == request.auth.claims.email\\" Example (Logic): title: \\"Public documents\\" description:
        \\"Determine whether the document should be publicly visible\\" expression: \\"document.type != 'private' && document.type
        != 'internal'\\" Example (Data Manipulation): title: \\"Notification string\\" description: \\"Create a notification string
        with a timestamp.\\" expression: \\"'New message received at ' + string(document.create_time)\\" The exact variables and
        functions that may be referenced within an expression are determined by the service that evaluates it. See the service
        documentation for additional information.
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        Output only. The time when the policy binding was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Optional. The description of the policy binding. Must be less than or equal to 63 characters.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        return pulumi.get(self, "effective_annotations")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[builtins.str]:
        """
        Optional. The etag for the policy binding. If this is provided on update, it must match the server's etag.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The location of the Policy Binding
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the policy binding in the format `{binding_parent/locations/{location}/policyBindings/{policy_binding_id}`
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def organization(self) -> pulumi.Output[builtins.str]:
        """
        The parent organization of the Policy Binding.
        """
        return pulumi.get(self, "organization")

    @property
    @pulumi.getter
    def policy(self) -> pulumi.Output[builtins.str]:
        """
        Required. Immutable. The resource name of the policy to be bound. The binding parent and policy must belong to the same Organization (or Project).
        """
        return pulumi.get(self, "policy")

    @property
    @pulumi.getter(name="policyBindingId")
    def policy_binding_id(self) -> pulumi.Output[builtins.str]:
        """
        The Policy Binding ID.
        """
        return pulumi.get(self, "policy_binding_id")

    @property
    @pulumi.getter(name="policyKind")
    def policy_kind(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Immutable. The kind of the policy to attach in this binding. This field must be one of the following: - Left empty (will
        be automatically set to the policy kind) - The input policy kind Possible values: POLICY_KIND_UNSPECIFIED
        PRINCIPAL_ACCESS_BOUNDARY ACCESS
        """
        return pulumi.get(self, "policy_kind")

    @property
    @pulumi.getter(name="policyUid")
    def policy_uid(self) -> pulumi.Output[builtins.str]:
        """
        Output only. The globally unique ID of the policy to be bound.
        """
        return pulumi.get(self, "policy_uid")

    @property
    @pulumi.getter
    def target(self) -> pulumi.Output['outputs.OrganizationsPolicyBindingTarget']:
        """
        Target is the full resource name of the resource to which the policy will be bound. Immutable once set.
        Structure is documented below.
        """
        return pulumi.get(self, "target")

    @property
    @pulumi.getter
    def uid(self) -> pulumi.Output[builtins.str]:
        """
        Output only. The globally unique ID of the policy binding. Assigned when the policy binding is created.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        Output only. The time when the policy binding was most recently updated.
        """
        return pulumi.get(self, "update_time")

