# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PrincipalAccessBoundaryPolicyArgs', 'PrincipalAccessBoundaryPolicy']

@pulumi.input_type
class PrincipalAccessBoundaryPolicyArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[builtins.str],
                 organization: pulumi.Input[builtins.str],
                 principal_access_boundary_policy_id: pulumi.Input[builtins.str],
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 details: Optional[pulumi.Input['PrincipalAccessBoundaryPolicyDetailsArgs']] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a PrincipalAccessBoundaryPolicy resource.
        :param pulumi.Input[builtins.str] location: The location the principal access boundary policy is in.
        :param pulumi.Input[builtins.str] organization: The parent organization of the principal access boundary policy.
        :param pulumi.Input[builtins.str] principal_access_boundary_policy_id: The ID to use to create the principal access boundary policy.
               This value must start with a lowercase letter followed by up to 62 lowercase letters, numbers, hyphens, or dots. Pattern, /a-z{2,62}/.
               
               
               - - -
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] annotations: User defined annotations. See https://google.aip.dev/148#annotations
               for more details such as format and size limitations
               
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input['PrincipalAccessBoundaryPolicyDetailsArgs'] details: Principal access boundary policy details
               Structure is documented below.
        :param pulumi.Input[builtins.str] display_name: The description of the principal access boundary policy. Must be less than or equal to 63 characters.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "organization", organization)
        pulumi.set(__self__, "principal_access_boundary_policy_id", principal_access_boundary_policy_id)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if details is not None:
            pulumi.set(__self__, "details", details)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        The location the principal access boundary policy is in.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def organization(self) -> pulumi.Input[builtins.str]:
        """
        The parent organization of the principal access boundary policy.
        """
        return pulumi.get(self, "organization")

    @organization.setter
    def organization(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "organization", value)

    @property
    @pulumi.getter(name="principalAccessBoundaryPolicyId")
    def principal_access_boundary_policy_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID to use to create the principal access boundary policy.
        This value must start with a lowercase letter followed by up to 62 lowercase letters, numbers, hyphens, or dots. Pattern, /a-z{2,62}/.


        - - -
        """
        return pulumi.get(self, "principal_access_boundary_policy_id")

    @principal_access_boundary_policy_id.setter
    def principal_access_boundary_policy_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "principal_access_boundary_policy_id", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        User defined annotations. See https://google.aip.dev/148#annotations
        for more details such as format and size limitations

        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter
    def details(self) -> Optional[pulumi.Input['PrincipalAccessBoundaryPolicyDetailsArgs']]:
        """
        Principal access boundary policy details
        Structure is documented below.
        """
        return pulumi.get(self, "details")

    @details.setter
    def details(self, value: Optional[pulumi.Input['PrincipalAccessBoundaryPolicyDetailsArgs']]):
        pulumi.set(self, "details", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the principal access boundary policy. Must be less than or equal to 63 characters.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)


@pulumi.input_type
class _PrincipalAccessBoundaryPolicyState:
    def __init__(__self__, *,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 details: Optional[pulumi.Input['PrincipalAccessBoundaryPolicyDetailsArgs']] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 effective_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 etag: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 organization: Optional[pulumi.Input[builtins.str]] = None,
                 principal_access_boundary_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 uid: Optional[pulumi.Input[builtins.str]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering PrincipalAccessBoundaryPolicy resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] annotations: User defined annotations. See https://google.aip.dev/148#annotations
               for more details such as format and size limitations
               
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[builtins.str] create_time: Output only. The time when the principal access boundary policy was created.
        :param pulumi.Input['PrincipalAccessBoundaryPolicyDetailsArgs'] details: Principal access boundary policy details
               Structure is documented below.
        :param pulumi.Input[builtins.str] display_name: The description of the principal access boundary policy. Must be less than or equal to 63 characters.
        :param pulumi.Input[builtins.str] etag: The etag for the principal access boundary. If this is provided on update, it must match the server's etag.
        :param pulumi.Input[builtins.str] location: The location the principal access boundary policy is in.
        :param pulumi.Input[builtins.str] name: Identifier. The resource name of the principal access boundary policy.  The following format is supported:
               `organizations/{organization_id}/locations/{location}/principalAccessBoundaryPolicies/{policy_id}`
        :param pulumi.Input[builtins.str] organization: The parent organization of the principal access boundary policy.
        :param pulumi.Input[builtins.str] principal_access_boundary_policy_id: The ID to use to create the principal access boundary policy.
               This value must start with a lowercase letter followed by up to 62 lowercase letters, numbers, hyphens, or dots. Pattern, /a-z{2,62}/.
               
               
               - - -
        :param pulumi.Input[builtins.str] uid: Output only. The globally unique ID of the principal access boundary policy.
        :param pulumi.Input[builtins.str] update_time: Output only. The time when the principal access boundary policy was most recently updated.
        """
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if details is not None:
            pulumi.set(__self__, "details", details)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if effective_annotations is not None:
            pulumi.set(__self__, "effective_annotations", effective_annotations)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if organization is not None:
            pulumi.set(__self__, "organization", organization)
        if principal_access_boundary_policy_id is not None:
            pulumi.set(__self__, "principal_access_boundary_policy_id", principal_access_boundary_policy_id)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        User defined annotations. See https://google.aip.dev/148#annotations
        for more details such as format and size limitations

        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. The time when the principal access boundary policy was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def details(self) -> Optional[pulumi.Input['PrincipalAccessBoundaryPolicyDetailsArgs']]:
        """
        Principal access boundary policy details
        Structure is documented below.
        """
        return pulumi.get(self, "details")

    @details.setter
    def details(self, value: Optional[pulumi.Input['PrincipalAccessBoundaryPolicyDetailsArgs']]):
        pulumi.set(self, "details", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the principal access boundary policy. Must be less than or equal to 63 characters.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "effective_annotations")

    @effective_annotations.setter
    def effective_annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_annotations", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The etag for the principal access boundary. If this is provided on update, it must match the server's etag.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location the principal access boundary policy is in.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier. The resource name of the principal access boundary policy.  The following format is supported:
        `organizations/{organization_id}/locations/{location}/principalAccessBoundaryPolicies/{policy_id}`
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def organization(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The parent organization of the principal access boundary policy.
        """
        return pulumi.get(self, "organization")

    @organization.setter
    def organization(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "organization", value)

    @property
    @pulumi.getter(name="principalAccessBoundaryPolicyId")
    def principal_access_boundary_policy_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID to use to create the principal access boundary policy.
        This value must start with a lowercase letter followed by up to 62 lowercase letters, numbers, hyphens, or dots. Pattern, /a-z{2,62}/.


        - - -
        """
        return pulumi.get(self, "principal_access_boundary_policy_id")

    @principal_access_boundary_policy_id.setter
    def principal_access_boundary_policy_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "principal_access_boundary_policy_id", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. The globally unique ID of the principal access boundary policy.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "uid", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. The time when the principal access boundary policy was most recently updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:iam/principalAccessBoundaryPolicy:PrincipalAccessBoundaryPolicy")
class PrincipalAccessBoundaryPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 details: Optional[pulumi.Input[Union['PrincipalAccessBoundaryPolicyDetailsArgs', 'PrincipalAccessBoundaryPolicyDetailsArgsDict']]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 organization: Optional[pulumi.Input[builtins.str]] = None,
                 principal_access_boundary_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ### Iam Principal Access Boundary Policy

        ```python
        import pulumi
        import pulumi_gcp as gcp

        pab_policy_for_org = gcp.iam.PrincipalAccessBoundaryPolicy("pab-policy-for-org",
            organization="123456789",
            location="global",
            display_name="PAB policy for Organization",
            principal_access_boundary_policy_id="pab-policy-for-org")
        ```
        ### Iam Organizations Policy Binding

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_time as time

        pab_policy = gcp.iam.PrincipalAccessBoundaryPolicy("pab_policy",
            organization="123456789",
            location="global",
            display_name="Binding for all principals in the Organization",
            principal_access_boundary_policy_id="my-pab-policy")
        wait60_seconds = time.index.Sleep("wait_60_seconds", create_duration=60s,
        opts = pulumi.ResourceOptions(depends_on=[pab_policy]))
        my_pab_policy = gcp.iam.OrganizationsPolicyBinding("my-pab-policy",
            organization="123456789",
            location="global",
            display_name="Binding for all principals in the Organization",
            policy_kind="PRINCIPAL_ACCESS_BOUNDARY",
            policy_binding_id="binding-for-all-org-principals",
            policy=pab_policy.principal_access_boundary_policy_id.apply(lambda principal_access_boundary_policy_id: f"organizations/123456789/locations/global/principalAccessBoundaryPolicies/{principal_access_boundary_policy_id}"),
            target={
                "principal_set": "//cloudresourcemanager.googleapis.com/organizations/123456789",
            },
            opts = pulumi.ResourceOptions(depends_on=[wait60_seconds]))
        ```

        ## Import

        PrincipalAccessBoundaryPolicy can be imported using any of these accepted formats:

        * `organizations/{{organization}}/locations/{{location}}/principalAccessBoundaryPolicies/{{principal_access_boundary_policy_id}}`

        * `{{organization}}/{{location}}/{{principal_access_boundary_policy_id}}`

        When using the `pulumi import` command, PrincipalAccessBoundaryPolicy can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:iam/principalAccessBoundaryPolicy:PrincipalAccessBoundaryPolicy default organizations/{{organization}}/locations/{{location}}/principalAccessBoundaryPolicies/{{principal_access_boundary_policy_id}}
        ```

        ```sh
        $ pulumi import gcp:iam/principalAccessBoundaryPolicy:PrincipalAccessBoundaryPolicy default {{organization}}/{{location}}/{{principal_access_boundary_policy_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] annotations: User defined annotations. See https://google.aip.dev/148#annotations
               for more details such as format and size limitations
               
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[Union['PrincipalAccessBoundaryPolicyDetailsArgs', 'PrincipalAccessBoundaryPolicyDetailsArgsDict']] details: Principal access boundary policy details
               Structure is documented below.
        :param pulumi.Input[builtins.str] display_name: The description of the principal access boundary policy. Must be less than or equal to 63 characters.
        :param pulumi.Input[builtins.str] location: The location the principal access boundary policy is in.
        :param pulumi.Input[builtins.str] organization: The parent organization of the principal access boundary policy.
        :param pulumi.Input[builtins.str] principal_access_boundary_policy_id: The ID to use to create the principal access boundary policy.
               This value must start with a lowercase letter followed by up to 62 lowercase letters, numbers, hyphens, or dots. Pattern, /a-z{2,62}/.
               
               
               - - -
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PrincipalAccessBoundaryPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ### Iam Principal Access Boundary Policy

        ```python
        import pulumi
        import pulumi_gcp as gcp

        pab_policy_for_org = gcp.iam.PrincipalAccessBoundaryPolicy("pab-policy-for-org",
            organization="123456789",
            location="global",
            display_name="PAB policy for Organization",
            principal_access_boundary_policy_id="pab-policy-for-org")
        ```
        ### Iam Organizations Policy Binding

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_time as time

        pab_policy = gcp.iam.PrincipalAccessBoundaryPolicy("pab_policy",
            organization="123456789",
            location="global",
            display_name="Binding for all principals in the Organization",
            principal_access_boundary_policy_id="my-pab-policy")
        wait60_seconds = time.index.Sleep("wait_60_seconds", create_duration=60s,
        opts = pulumi.ResourceOptions(depends_on=[pab_policy]))
        my_pab_policy = gcp.iam.OrganizationsPolicyBinding("my-pab-policy",
            organization="123456789",
            location="global",
            display_name="Binding for all principals in the Organization",
            policy_kind="PRINCIPAL_ACCESS_BOUNDARY",
            policy_binding_id="binding-for-all-org-principals",
            policy=pab_policy.principal_access_boundary_policy_id.apply(lambda principal_access_boundary_policy_id: f"organizations/123456789/locations/global/principalAccessBoundaryPolicies/{principal_access_boundary_policy_id}"),
            target={
                "principal_set": "//cloudresourcemanager.googleapis.com/organizations/123456789",
            },
            opts = pulumi.ResourceOptions(depends_on=[wait60_seconds]))
        ```

        ## Import

        PrincipalAccessBoundaryPolicy can be imported using any of these accepted formats:

        * `organizations/{{organization}}/locations/{{location}}/principalAccessBoundaryPolicies/{{principal_access_boundary_policy_id}}`

        * `{{organization}}/{{location}}/{{principal_access_boundary_policy_id}}`

        When using the `pulumi import` command, PrincipalAccessBoundaryPolicy can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:iam/principalAccessBoundaryPolicy:PrincipalAccessBoundaryPolicy default organizations/{{organization}}/locations/{{location}}/principalAccessBoundaryPolicies/{{principal_access_boundary_policy_id}}
        ```

        ```sh
        $ pulumi import gcp:iam/principalAccessBoundaryPolicy:PrincipalAccessBoundaryPolicy default {{organization}}/{{location}}/{{principal_access_boundary_policy_id}}
        ```

        :param str resource_name: The name of the resource.
        :param PrincipalAccessBoundaryPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PrincipalAccessBoundaryPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 details: Optional[pulumi.Input[Union['PrincipalAccessBoundaryPolicyDetailsArgs', 'PrincipalAccessBoundaryPolicyDetailsArgsDict']]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 organization: Optional[pulumi.Input[builtins.str]] = None,
                 principal_access_boundary_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PrincipalAccessBoundaryPolicyArgs.__new__(PrincipalAccessBoundaryPolicyArgs)

            __props__.__dict__["annotations"] = annotations
            __props__.__dict__["details"] = details
            __props__.__dict__["display_name"] = display_name
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            if organization is None and not opts.urn:
                raise TypeError("Missing required property 'organization'")
            __props__.__dict__["organization"] = organization
            if principal_access_boundary_policy_id is None and not opts.urn:
                raise TypeError("Missing required property 'principal_access_boundary_policy_id'")
            __props__.__dict__["principal_access_boundary_policy_id"] = principal_access_boundary_policy_id
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_annotations"] = None
            __props__.__dict__["etag"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["uid"] = None
            __props__.__dict__["update_time"] = None
        super(PrincipalAccessBoundaryPolicy, __self__).__init__(
            'gcp:iam/principalAccessBoundaryPolicy:PrincipalAccessBoundaryPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            details: Optional[pulumi.Input[Union['PrincipalAccessBoundaryPolicyDetailsArgs', 'PrincipalAccessBoundaryPolicyDetailsArgsDict']]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            effective_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            etag: Optional[pulumi.Input[builtins.str]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            organization: Optional[pulumi.Input[builtins.str]] = None,
            principal_access_boundary_policy_id: Optional[pulumi.Input[builtins.str]] = None,
            uid: Optional[pulumi.Input[builtins.str]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None) -> 'PrincipalAccessBoundaryPolicy':
        """
        Get an existing PrincipalAccessBoundaryPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] annotations: User defined annotations. See https://google.aip.dev/148#annotations
               for more details such as format and size limitations
               
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[builtins.str] create_time: Output only. The time when the principal access boundary policy was created.
        :param pulumi.Input[Union['PrincipalAccessBoundaryPolicyDetailsArgs', 'PrincipalAccessBoundaryPolicyDetailsArgsDict']] details: Principal access boundary policy details
               Structure is documented below.
        :param pulumi.Input[builtins.str] display_name: The description of the principal access boundary policy. Must be less than or equal to 63 characters.
        :param pulumi.Input[builtins.str] etag: The etag for the principal access boundary. If this is provided on update, it must match the server's etag.
        :param pulumi.Input[builtins.str] location: The location the principal access boundary policy is in.
        :param pulumi.Input[builtins.str] name: Identifier. The resource name of the principal access boundary policy.  The following format is supported:
               `organizations/{organization_id}/locations/{location}/principalAccessBoundaryPolicies/{policy_id}`
        :param pulumi.Input[builtins.str] organization: The parent organization of the principal access boundary policy.
        :param pulumi.Input[builtins.str] principal_access_boundary_policy_id: The ID to use to create the principal access boundary policy.
               This value must start with a lowercase letter followed by up to 62 lowercase letters, numbers, hyphens, or dots. Pattern, /a-z{2,62}/.
               
               
               - - -
        :param pulumi.Input[builtins.str] uid: Output only. The globally unique ID of the principal access boundary policy.
        :param pulumi.Input[builtins.str] update_time: Output only. The time when the principal access boundary policy was most recently updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PrincipalAccessBoundaryPolicyState.__new__(_PrincipalAccessBoundaryPolicyState)

        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["details"] = details
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["effective_annotations"] = effective_annotations
        __props__.__dict__["etag"] = etag
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["organization"] = organization
        __props__.__dict__["principal_access_boundary_policy_id"] = principal_access_boundary_policy_id
        __props__.__dict__["uid"] = uid
        __props__.__dict__["update_time"] = update_time
        return PrincipalAccessBoundaryPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        User defined annotations. See https://google.aip.dev/148#annotations
        for more details such as format and size limitations

        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        Output only. The time when the principal access boundary policy was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def details(self) -> pulumi.Output['outputs.PrincipalAccessBoundaryPolicyDetails']:
        """
        Principal access boundary policy details
        Structure is documented below.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description of the principal access boundary policy. Must be less than or equal to 63 characters.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        return pulumi.get(self, "effective_annotations")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[builtins.str]:
        """
        The etag for the principal access boundary. If this is provided on update, it must match the server's etag.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The location the principal access boundary policy is in.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Identifier. The resource name of the principal access boundary policy.  The following format is supported:
        `organizations/{organization_id}/locations/{location}/principalAccessBoundaryPolicies/{policy_id}`
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def organization(self) -> pulumi.Output[builtins.str]:
        """
        The parent organization of the principal access boundary policy.
        """
        return pulumi.get(self, "organization")

    @property
    @pulumi.getter(name="principalAccessBoundaryPolicyId")
    def principal_access_boundary_policy_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID to use to create the principal access boundary policy.
        This value must start with a lowercase letter followed by up to 62 lowercase letters, numbers, hyphens, or dots. Pattern, /a-z{2,62}/.


        - - -
        """
        return pulumi.get(self, "principal_access_boundary_policy_id")

    @property
    @pulumi.getter
    def uid(self) -> pulumi.Output[builtins.str]:
        """
        Output only. The globally unique ID of the principal access boundary policy.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        Output only. The time when the principal access boundary policy was most recently updated.
        """
        return pulumi.get(self, "update_time")

