# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['WorkloadIdentityPoolManagedIdentityArgs', 'WorkloadIdentityPoolManagedIdentity']

@pulumi.input_type
class WorkloadIdentityPoolManagedIdentityArgs:
    def __init__(__self__, *,
                 workload_identity_pool_id: pulumi.Input[builtins.str],
                 workload_identity_pool_managed_identity_id: pulumi.Input[builtins.str],
                 workload_identity_pool_namespace_id: pulumi.Input[builtins.str],
                 attestation_rules: Optional[pulumi.Input[Sequence[pulumi.Input['WorkloadIdentityPoolManagedIdentityAttestationRuleArgs']]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a WorkloadIdentityPoolManagedIdentity resource.
        :param pulumi.Input[builtins.str] workload_identity_pool_id: The ID to use for the pool, which becomes the final component of the resource name. This
               value should be 4-32 characters, and may contain the characters [a-z0-9-]. The prefix
               `gcp-` is reserved for use by Google, and may not be specified.
        :param pulumi.Input[builtins.str] workload_identity_pool_managed_identity_id: The ID to use for the managed identity. This value must:
               * contain at most 63 characters
               * contain only lowercase alphanumeric characters or `-`
               * start with an alphanumeric character
               * end with an alphanumeric character
               
               The prefix `gcp-` will be reserved for future uses.
               
               
               - - -
        :param pulumi.Input[builtins.str] workload_identity_pool_namespace_id: The ID to use for the namespace. This value must:
               * contain at most 63 characters
               * contain only lowercase alphanumeric characters or `-`
               * start with an alphanumeric character
               * end with an alphanumeric character
               
               The prefix `gcp-` will be reserved for future uses.
        :param pulumi.Input[Sequence[pulumi.Input['WorkloadIdentityPoolManagedIdentityAttestationRuleArgs']]] attestation_rules: Defines which workloads can receive an identity within a pool. When an AttestationRule is
               defined under a managed identity, matching workloads may receive that identity. A maximum of
               50 AttestationRules can be set.
               Structure is documented below.
        :param pulumi.Input[builtins.str] description: A description of the managed identity. Cannot exceed 256 characters.
        :param pulumi.Input[builtins.bool] disabled: Whether the managed identity is disabled. If disabled, credentials may no longer be issued for
               the identity, however existing credentials will still be accepted until they expire.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "workload_identity_pool_id", workload_identity_pool_id)
        pulumi.set(__self__, "workload_identity_pool_managed_identity_id", workload_identity_pool_managed_identity_id)
        pulumi.set(__self__, "workload_identity_pool_namespace_id", workload_identity_pool_namespace_id)
        if attestation_rules is not None:
            pulumi.set(__self__, "attestation_rules", attestation_rules)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="workloadIdentityPoolId")
    def workload_identity_pool_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID to use for the pool, which becomes the final component of the resource name. This
        value should be 4-32 characters, and may contain the characters [a-z0-9-]. The prefix
        `gcp-` is reserved for use by Google, and may not be specified.
        """
        return pulumi.get(self, "workload_identity_pool_id")

    @workload_identity_pool_id.setter
    def workload_identity_pool_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "workload_identity_pool_id", value)

    @property
    @pulumi.getter(name="workloadIdentityPoolManagedIdentityId")
    def workload_identity_pool_managed_identity_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID to use for the managed identity. This value must:
        * contain at most 63 characters
        * contain only lowercase alphanumeric characters or `-`
        * start with an alphanumeric character
        * end with an alphanumeric character

        The prefix `gcp-` will be reserved for future uses.


        - - -
        """
        return pulumi.get(self, "workload_identity_pool_managed_identity_id")

    @workload_identity_pool_managed_identity_id.setter
    def workload_identity_pool_managed_identity_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "workload_identity_pool_managed_identity_id", value)

    @property
    @pulumi.getter(name="workloadIdentityPoolNamespaceId")
    def workload_identity_pool_namespace_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID to use for the namespace. This value must:
        * contain at most 63 characters
        * contain only lowercase alphanumeric characters or `-`
        * start with an alphanumeric character
        * end with an alphanumeric character

        The prefix `gcp-` will be reserved for future uses.
        """
        return pulumi.get(self, "workload_identity_pool_namespace_id")

    @workload_identity_pool_namespace_id.setter
    def workload_identity_pool_namespace_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "workload_identity_pool_namespace_id", value)

    @property
    @pulumi.getter(name="attestationRules")
    def attestation_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkloadIdentityPoolManagedIdentityAttestationRuleArgs']]]]:
        """
        Defines which workloads can receive an identity within a pool. When an AttestationRule is
        defined under a managed identity, matching workloads may receive that identity. A maximum of
        50 AttestationRules can be set.
        Structure is documented below.
        """
        return pulumi.get(self, "attestation_rules")

    @attestation_rules.setter
    def attestation_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkloadIdentityPoolManagedIdentityAttestationRuleArgs']]]]):
        pulumi.set(self, "attestation_rules", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A description of the managed identity. Cannot exceed 256 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the managed identity is disabled. If disabled, credentials may no longer be issued for
        the identity, however existing credentials will still be accepted until they expire.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "disabled", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _WorkloadIdentityPoolManagedIdentityState:
    def __init__(__self__, *,
                 attestation_rules: Optional[pulumi.Input[Sequence[pulumi.Input['WorkloadIdentityPoolManagedIdentityAttestationRuleArgs']]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 workload_identity_pool_id: Optional[pulumi.Input[builtins.str]] = None,
                 workload_identity_pool_managed_identity_id: Optional[pulumi.Input[builtins.str]] = None,
                 workload_identity_pool_namespace_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering WorkloadIdentityPoolManagedIdentity resources.
        :param pulumi.Input[Sequence[pulumi.Input['WorkloadIdentityPoolManagedIdentityAttestationRuleArgs']]] attestation_rules: Defines which workloads can receive an identity within a pool. When an AttestationRule is
               defined under a managed identity, matching workloads may receive that identity. A maximum of
               50 AttestationRules can be set.
               Structure is documented below.
        :param pulumi.Input[builtins.str] description: A description of the managed identity. Cannot exceed 256 characters.
        :param pulumi.Input[builtins.bool] disabled: Whether the managed identity is disabled. If disabled, credentials may no longer be issued for
               the identity, however existing credentials will still be accepted until they expire.
        :param pulumi.Input[builtins.str] name: The resource name of the managed identity as
               `projects/{project_number}/locations/global/workloadIdentityPools/{workload_identity_pool_id}/namespaces/{workload_identity_pool_namespace_id}/managedIdentities/{workload_identity_pool_managed_identity_id}`.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] state: The current state of the managed identity.
               * `ACTIVE`: The managed identity is active.
               * `DELETED`: The managed identity is soft-deleted. Soft-deleted managed identities are
               permanently deleted after approximately 30 days. You can restore a soft-deleted managed
               identity using UndeleteWorkloadIdentityPoolManagedIdentity. You cannot reuse the ID of a
               soft-deleted managed identity until it is permanently deleted.
        :param pulumi.Input[builtins.str] workload_identity_pool_id: The ID to use for the pool, which becomes the final component of the resource name. This
               value should be 4-32 characters, and may contain the characters [a-z0-9-]. The prefix
               `gcp-` is reserved for use by Google, and may not be specified.
        :param pulumi.Input[builtins.str] workload_identity_pool_managed_identity_id: The ID to use for the managed identity. This value must:
               * contain at most 63 characters
               * contain only lowercase alphanumeric characters or `-`
               * start with an alphanumeric character
               * end with an alphanumeric character
               
               The prefix `gcp-` will be reserved for future uses.
               
               
               - - -
        :param pulumi.Input[builtins.str] workload_identity_pool_namespace_id: The ID to use for the namespace. This value must:
               * contain at most 63 characters
               * contain only lowercase alphanumeric characters or `-`
               * start with an alphanumeric character
               * end with an alphanumeric character
               
               The prefix `gcp-` will be reserved for future uses.
        """
        if attestation_rules is not None:
            pulumi.set(__self__, "attestation_rules", attestation_rules)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if workload_identity_pool_id is not None:
            pulumi.set(__self__, "workload_identity_pool_id", workload_identity_pool_id)
        if workload_identity_pool_managed_identity_id is not None:
            pulumi.set(__self__, "workload_identity_pool_managed_identity_id", workload_identity_pool_managed_identity_id)
        if workload_identity_pool_namespace_id is not None:
            pulumi.set(__self__, "workload_identity_pool_namespace_id", workload_identity_pool_namespace_id)

    @property
    @pulumi.getter(name="attestationRules")
    def attestation_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkloadIdentityPoolManagedIdentityAttestationRuleArgs']]]]:
        """
        Defines which workloads can receive an identity within a pool. When an AttestationRule is
        defined under a managed identity, matching workloads may receive that identity. A maximum of
        50 AttestationRules can be set.
        Structure is documented below.
        """
        return pulumi.get(self, "attestation_rules")

    @attestation_rules.setter
    def attestation_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkloadIdentityPoolManagedIdentityAttestationRuleArgs']]]]):
        pulumi.set(self, "attestation_rules", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A description of the managed identity. Cannot exceed 256 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the managed identity is disabled. If disabled, credentials may no longer be issued for
        the identity, however existing credentials will still be accepted until they expire.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "disabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource name of the managed identity as
        `projects/{project_number}/locations/global/workloadIdentityPools/{workload_identity_pool_id}/namespaces/{workload_identity_pool_namespace_id}/managedIdentities/{workload_identity_pool_managed_identity_id}`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current state of the managed identity.
        * `ACTIVE`: The managed identity is active.
        * `DELETED`: The managed identity is soft-deleted. Soft-deleted managed identities are
        permanently deleted after approximately 30 days. You can restore a soft-deleted managed
        identity using UndeleteWorkloadIdentityPoolManagedIdentity. You cannot reuse the ID of a
        soft-deleted managed identity until it is permanently deleted.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="workloadIdentityPoolId")
    def workload_identity_pool_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID to use for the pool, which becomes the final component of the resource name. This
        value should be 4-32 characters, and may contain the characters [a-z0-9-]. The prefix
        `gcp-` is reserved for use by Google, and may not be specified.
        """
        return pulumi.get(self, "workload_identity_pool_id")

    @workload_identity_pool_id.setter
    def workload_identity_pool_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "workload_identity_pool_id", value)

    @property
    @pulumi.getter(name="workloadIdentityPoolManagedIdentityId")
    def workload_identity_pool_managed_identity_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID to use for the managed identity. This value must:
        * contain at most 63 characters
        * contain only lowercase alphanumeric characters or `-`
        * start with an alphanumeric character
        * end with an alphanumeric character

        The prefix `gcp-` will be reserved for future uses.


        - - -
        """
        return pulumi.get(self, "workload_identity_pool_managed_identity_id")

    @workload_identity_pool_managed_identity_id.setter
    def workload_identity_pool_managed_identity_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "workload_identity_pool_managed_identity_id", value)

    @property
    @pulumi.getter(name="workloadIdentityPoolNamespaceId")
    def workload_identity_pool_namespace_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID to use for the namespace. This value must:
        * contain at most 63 characters
        * contain only lowercase alphanumeric characters or `-`
        * start with an alphanumeric character
        * end with an alphanumeric character

        The prefix `gcp-` will be reserved for future uses.
        """
        return pulumi.get(self, "workload_identity_pool_namespace_id")

    @workload_identity_pool_namespace_id.setter
    def workload_identity_pool_namespace_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "workload_identity_pool_namespace_id", value)


@pulumi.type_token("gcp:iam/workloadIdentityPoolManagedIdentity:WorkloadIdentityPoolManagedIdentity")
class WorkloadIdentityPoolManagedIdentity(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attestation_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkloadIdentityPoolManagedIdentityAttestationRuleArgs', 'WorkloadIdentityPoolManagedIdentityAttestationRuleArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 workload_identity_pool_id: Optional[pulumi.Input[builtins.str]] = None,
                 workload_identity_pool_managed_identity_id: Optional[pulumi.Input[builtins.str]] = None,
                 workload_identity_pool_namespace_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ### Iam Workload Identity Pool Managed Identity Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        pool = gcp.iam.WorkloadIdentityPool("pool",
            workload_identity_pool_id="example-pool",
            mode="TRUST_DOMAIN")
        ns = gcp.iam.WorkloadIdentityPoolNamespace("ns",
            workload_identity_pool_id=pool.workload_identity_pool_id,
            workload_identity_pool_namespace_id="example-namespace")
        example = gcp.iam.WorkloadIdentityPoolManagedIdentity("example",
            workload_identity_pool_id=pool.workload_identity_pool_id,
            workload_identity_pool_namespace_id=ns.workload_identity_pool_namespace_id,
            workload_identity_pool_managed_identity_id="example-managed-identity")
        ```
        ### Iam Workload Identity Pool Managed Identity Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        pool = gcp.iam.WorkloadIdentityPool("pool",
            workload_identity_pool_id="example-pool",
            mode="TRUST_DOMAIN")
        ns = gcp.iam.WorkloadIdentityPoolNamespace("ns",
            workload_identity_pool_id=pool.workload_identity_pool_id,
            workload_identity_pool_namespace_id="example-namespace")
        example = gcp.iam.WorkloadIdentityPoolManagedIdentity("example",
            workload_identity_pool_id=pool.workload_identity_pool_id,
            workload_identity_pool_namespace_id=ns.workload_identity_pool_namespace_id,
            workload_identity_pool_managed_identity_id="example-managed-identity",
            description="Example Managed Identity in a Workload Identity Pool Namespace",
            disabled=True,
            attestation_rules=[
                {
                    "google_cloud_resource": "//compute.googleapis.com/projects/1111111111111/uid/zones/us-central1-a/instances/12345678",
                },
                {
                    "google_cloud_resource": "//run.googleapis.com/projects/1111111111111/name/locations/us-east1/services/my-service",
                },
            ])
        ```

        ## Import

        WorkloadIdentityPoolManagedIdentity can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/global/workloadIdentityPools/{{workload_identity_pool_id}}/namespaces/{{workload_identity_pool_namespace_id}}/managedIdentities/{{workload_identity_pool_managed_identity_id}}`

        * `{{project}}/{{workload_identity_pool_id}}/{{workload_identity_pool_namespace_id}}/{{workload_identity_pool_managed_identity_id}}`

        * `{{workload_identity_pool_id}}/{{workload_identity_pool_namespace_id}}/{{workload_identity_pool_managed_identity_id}}`

        When using the `pulumi import` command, WorkloadIdentityPoolManagedIdentity can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:iam/workloadIdentityPoolManagedIdentity:WorkloadIdentityPoolManagedIdentity default projects/{{project}}/locations/global/workloadIdentityPools/{{workload_identity_pool_id}}/namespaces/{{workload_identity_pool_namespace_id}}/managedIdentities/{{workload_identity_pool_managed_identity_id}}
        ```

        ```sh
        $ pulumi import gcp:iam/workloadIdentityPoolManagedIdentity:WorkloadIdentityPoolManagedIdentity default {{project}}/{{workload_identity_pool_id}}/{{workload_identity_pool_namespace_id}}/{{workload_identity_pool_managed_identity_id}}
        ```

        ```sh
        $ pulumi import gcp:iam/workloadIdentityPoolManagedIdentity:WorkloadIdentityPoolManagedIdentity default {{workload_identity_pool_id}}/{{workload_identity_pool_namespace_id}}/{{workload_identity_pool_managed_identity_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkloadIdentityPoolManagedIdentityAttestationRuleArgs', 'WorkloadIdentityPoolManagedIdentityAttestationRuleArgsDict']]]] attestation_rules: Defines which workloads can receive an identity within a pool. When an AttestationRule is
               defined under a managed identity, matching workloads may receive that identity. A maximum of
               50 AttestationRules can be set.
               Structure is documented below.
        :param pulumi.Input[builtins.str] description: A description of the managed identity. Cannot exceed 256 characters.
        :param pulumi.Input[builtins.bool] disabled: Whether the managed identity is disabled. If disabled, credentials may no longer be issued for
               the identity, however existing credentials will still be accepted until they expire.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] workload_identity_pool_id: The ID to use for the pool, which becomes the final component of the resource name. This
               value should be 4-32 characters, and may contain the characters [a-z0-9-]. The prefix
               `gcp-` is reserved for use by Google, and may not be specified.
        :param pulumi.Input[builtins.str] workload_identity_pool_managed_identity_id: The ID to use for the managed identity. This value must:
               * contain at most 63 characters
               * contain only lowercase alphanumeric characters or `-`
               * start with an alphanumeric character
               * end with an alphanumeric character
               
               The prefix `gcp-` will be reserved for future uses.
               
               
               - - -
        :param pulumi.Input[builtins.str] workload_identity_pool_namespace_id: The ID to use for the namespace. This value must:
               * contain at most 63 characters
               * contain only lowercase alphanumeric characters or `-`
               * start with an alphanumeric character
               * end with an alphanumeric character
               
               The prefix `gcp-` will be reserved for future uses.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WorkloadIdentityPoolManagedIdentityArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ### Iam Workload Identity Pool Managed Identity Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        pool = gcp.iam.WorkloadIdentityPool("pool",
            workload_identity_pool_id="example-pool",
            mode="TRUST_DOMAIN")
        ns = gcp.iam.WorkloadIdentityPoolNamespace("ns",
            workload_identity_pool_id=pool.workload_identity_pool_id,
            workload_identity_pool_namespace_id="example-namespace")
        example = gcp.iam.WorkloadIdentityPoolManagedIdentity("example",
            workload_identity_pool_id=pool.workload_identity_pool_id,
            workload_identity_pool_namespace_id=ns.workload_identity_pool_namespace_id,
            workload_identity_pool_managed_identity_id="example-managed-identity")
        ```
        ### Iam Workload Identity Pool Managed Identity Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        pool = gcp.iam.WorkloadIdentityPool("pool",
            workload_identity_pool_id="example-pool",
            mode="TRUST_DOMAIN")
        ns = gcp.iam.WorkloadIdentityPoolNamespace("ns",
            workload_identity_pool_id=pool.workload_identity_pool_id,
            workload_identity_pool_namespace_id="example-namespace")
        example = gcp.iam.WorkloadIdentityPoolManagedIdentity("example",
            workload_identity_pool_id=pool.workload_identity_pool_id,
            workload_identity_pool_namespace_id=ns.workload_identity_pool_namespace_id,
            workload_identity_pool_managed_identity_id="example-managed-identity",
            description="Example Managed Identity in a Workload Identity Pool Namespace",
            disabled=True,
            attestation_rules=[
                {
                    "google_cloud_resource": "//compute.googleapis.com/projects/1111111111111/uid/zones/us-central1-a/instances/12345678",
                },
                {
                    "google_cloud_resource": "//run.googleapis.com/projects/1111111111111/name/locations/us-east1/services/my-service",
                },
            ])
        ```

        ## Import

        WorkloadIdentityPoolManagedIdentity can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/global/workloadIdentityPools/{{workload_identity_pool_id}}/namespaces/{{workload_identity_pool_namespace_id}}/managedIdentities/{{workload_identity_pool_managed_identity_id}}`

        * `{{project}}/{{workload_identity_pool_id}}/{{workload_identity_pool_namespace_id}}/{{workload_identity_pool_managed_identity_id}}`

        * `{{workload_identity_pool_id}}/{{workload_identity_pool_namespace_id}}/{{workload_identity_pool_managed_identity_id}}`

        When using the `pulumi import` command, WorkloadIdentityPoolManagedIdentity can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:iam/workloadIdentityPoolManagedIdentity:WorkloadIdentityPoolManagedIdentity default projects/{{project}}/locations/global/workloadIdentityPools/{{workload_identity_pool_id}}/namespaces/{{workload_identity_pool_namespace_id}}/managedIdentities/{{workload_identity_pool_managed_identity_id}}
        ```

        ```sh
        $ pulumi import gcp:iam/workloadIdentityPoolManagedIdentity:WorkloadIdentityPoolManagedIdentity default {{project}}/{{workload_identity_pool_id}}/{{workload_identity_pool_namespace_id}}/{{workload_identity_pool_managed_identity_id}}
        ```

        ```sh
        $ pulumi import gcp:iam/workloadIdentityPoolManagedIdentity:WorkloadIdentityPoolManagedIdentity default {{workload_identity_pool_id}}/{{workload_identity_pool_namespace_id}}/{{workload_identity_pool_managed_identity_id}}
        ```

        :param str resource_name: The name of the resource.
        :param WorkloadIdentityPoolManagedIdentityArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkloadIdentityPoolManagedIdentityArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attestation_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkloadIdentityPoolManagedIdentityAttestationRuleArgs', 'WorkloadIdentityPoolManagedIdentityAttestationRuleArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 workload_identity_pool_id: Optional[pulumi.Input[builtins.str]] = None,
                 workload_identity_pool_managed_identity_id: Optional[pulumi.Input[builtins.str]] = None,
                 workload_identity_pool_namespace_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkloadIdentityPoolManagedIdentityArgs.__new__(WorkloadIdentityPoolManagedIdentityArgs)

            __props__.__dict__["attestation_rules"] = attestation_rules
            __props__.__dict__["description"] = description
            __props__.__dict__["disabled"] = disabled
            __props__.__dict__["project"] = project
            if workload_identity_pool_id is None and not opts.urn:
                raise TypeError("Missing required property 'workload_identity_pool_id'")
            __props__.__dict__["workload_identity_pool_id"] = workload_identity_pool_id
            if workload_identity_pool_managed_identity_id is None and not opts.urn:
                raise TypeError("Missing required property 'workload_identity_pool_managed_identity_id'")
            __props__.__dict__["workload_identity_pool_managed_identity_id"] = workload_identity_pool_managed_identity_id
            if workload_identity_pool_namespace_id is None and not opts.urn:
                raise TypeError("Missing required property 'workload_identity_pool_namespace_id'")
            __props__.__dict__["workload_identity_pool_namespace_id"] = workload_identity_pool_namespace_id
            __props__.__dict__["name"] = None
            __props__.__dict__["state"] = None
        super(WorkloadIdentityPoolManagedIdentity, __self__).__init__(
            'gcp:iam/workloadIdentityPoolManagedIdentity:WorkloadIdentityPoolManagedIdentity',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            attestation_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkloadIdentityPoolManagedIdentityAttestationRuleArgs', 'WorkloadIdentityPoolManagedIdentityAttestationRuleArgsDict']]]]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            disabled: Optional[pulumi.Input[builtins.bool]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            workload_identity_pool_id: Optional[pulumi.Input[builtins.str]] = None,
            workload_identity_pool_managed_identity_id: Optional[pulumi.Input[builtins.str]] = None,
            workload_identity_pool_namespace_id: Optional[pulumi.Input[builtins.str]] = None) -> 'WorkloadIdentityPoolManagedIdentity':
        """
        Get an existing WorkloadIdentityPoolManagedIdentity resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkloadIdentityPoolManagedIdentityAttestationRuleArgs', 'WorkloadIdentityPoolManagedIdentityAttestationRuleArgsDict']]]] attestation_rules: Defines which workloads can receive an identity within a pool. When an AttestationRule is
               defined under a managed identity, matching workloads may receive that identity. A maximum of
               50 AttestationRules can be set.
               Structure is documented below.
        :param pulumi.Input[builtins.str] description: A description of the managed identity. Cannot exceed 256 characters.
        :param pulumi.Input[builtins.bool] disabled: Whether the managed identity is disabled. If disabled, credentials may no longer be issued for
               the identity, however existing credentials will still be accepted until they expire.
        :param pulumi.Input[builtins.str] name: The resource name of the managed identity as
               `projects/{project_number}/locations/global/workloadIdentityPools/{workload_identity_pool_id}/namespaces/{workload_identity_pool_namespace_id}/managedIdentities/{workload_identity_pool_managed_identity_id}`.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] state: The current state of the managed identity.
               * `ACTIVE`: The managed identity is active.
               * `DELETED`: The managed identity is soft-deleted. Soft-deleted managed identities are
               permanently deleted after approximately 30 days. You can restore a soft-deleted managed
               identity using UndeleteWorkloadIdentityPoolManagedIdentity. You cannot reuse the ID of a
               soft-deleted managed identity until it is permanently deleted.
        :param pulumi.Input[builtins.str] workload_identity_pool_id: The ID to use for the pool, which becomes the final component of the resource name. This
               value should be 4-32 characters, and may contain the characters [a-z0-9-]. The prefix
               `gcp-` is reserved for use by Google, and may not be specified.
        :param pulumi.Input[builtins.str] workload_identity_pool_managed_identity_id: The ID to use for the managed identity. This value must:
               * contain at most 63 characters
               * contain only lowercase alphanumeric characters or `-`
               * start with an alphanumeric character
               * end with an alphanumeric character
               
               The prefix `gcp-` will be reserved for future uses.
               
               
               - - -
        :param pulumi.Input[builtins.str] workload_identity_pool_namespace_id: The ID to use for the namespace. This value must:
               * contain at most 63 characters
               * contain only lowercase alphanumeric characters or `-`
               * start with an alphanumeric character
               * end with an alphanumeric character
               
               The prefix `gcp-` will be reserved for future uses.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WorkloadIdentityPoolManagedIdentityState.__new__(_WorkloadIdentityPoolManagedIdentityState)

        __props__.__dict__["attestation_rules"] = attestation_rules
        __props__.__dict__["description"] = description
        __props__.__dict__["disabled"] = disabled
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["state"] = state
        __props__.__dict__["workload_identity_pool_id"] = workload_identity_pool_id
        __props__.__dict__["workload_identity_pool_managed_identity_id"] = workload_identity_pool_managed_identity_id
        __props__.__dict__["workload_identity_pool_namespace_id"] = workload_identity_pool_namespace_id
        return WorkloadIdentityPoolManagedIdentity(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="attestationRules")
    def attestation_rules(self) -> pulumi.Output[Optional[Sequence['outputs.WorkloadIdentityPoolManagedIdentityAttestationRule']]]:
        """
        Defines which workloads can receive an identity within a pool. When an AttestationRule is
        defined under a managed identity, matching workloads may receive that identity. A maximum of
        50 AttestationRules can be set.
        Structure is documented below.
        """
        return pulumi.get(self, "attestation_rules")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A description of the managed identity. Cannot exceed 256 characters.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def disabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether the managed identity is disabled. If disabled, credentials may no longer be issued for
        the identity, however existing credentials will still be accepted until they expire.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The resource name of the managed identity as
        `projects/{project_number}/locations/global/workloadIdentityPools/{workload_identity_pool_id}/namespaces/{workload_identity_pool_namespace_id}/managedIdentities/{workload_identity_pool_managed_identity_id}`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current state of the managed identity.
        * `ACTIVE`: The managed identity is active.
        * `DELETED`: The managed identity is soft-deleted. Soft-deleted managed identities are
        permanently deleted after approximately 30 days. You can restore a soft-deleted managed
        identity using UndeleteWorkloadIdentityPoolManagedIdentity. You cannot reuse the ID of a
        soft-deleted managed identity until it is permanently deleted.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="workloadIdentityPoolId")
    def workload_identity_pool_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID to use for the pool, which becomes the final component of the resource name. This
        value should be 4-32 characters, and may contain the characters [a-z0-9-]. The prefix
        `gcp-` is reserved for use by Google, and may not be specified.
        """
        return pulumi.get(self, "workload_identity_pool_id")

    @property
    @pulumi.getter(name="workloadIdentityPoolManagedIdentityId")
    def workload_identity_pool_managed_identity_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID to use for the managed identity. This value must:
        * contain at most 63 characters
        * contain only lowercase alphanumeric characters or `-`
        * start with an alphanumeric character
        * end with an alphanumeric character

        The prefix `gcp-` will be reserved for future uses.


        - - -
        """
        return pulumi.get(self, "workload_identity_pool_managed_identity_id")

    @property
    @pulumi.getter(name="workloadIdentityPoolNamespaceId")
    def workload_identity_pool_namespace_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID to use for the namespace. This value must:
        * contain at most 63 characters
        * contain only lowercase alphanumeric characters or `-`
        * start with an alphanumeric character
        * end with an alphanumeric character

        The prefix `gcp-` will be reserved for future uses.
        """
        return pulumi.get(self, "workload_identity_pool_namespace_id")

