# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SettingsArgs', 'Settings']

@pulumi.input_type
class SettingsArgs:
    def __init__(__self__, *,
                 access_settings: Optional[pulumi.Input['SettingsAccessSettingsArgs']] = None,
                 application_settings: Optional[pulumi.Input['SettingsApplicationSettingsArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Settings resource.
        :param pulumi.Input['SettingsAccessSettingsArgs'] access_settings: Top level wrapper for all access related setting in IAP.
               Structure is documented below.
        :param pulumi.Input['SettingsApplicationSettingsArgs'] application_settings: Top level wrapper for all application related settings in IAP.
               Structure is documented below.
        :param pulumi.Input[builtins.str] name: The resource name of the IAP protected resource. Name can have below resources:
               * organizations/{organization_id}
               * folders/{folder_id}
               * projects/{project_id}
               * projects/{project_id}/iap_web
               * projects/{project_id}/iap_web/compute
               * projects/{project_id}/iap_web/compute-{region}
               * projects/{project_id}/iap_web/compute/services/{service_id}
               * projects/{project_id}/iap_web/compute-{region}/services/{service_id}
               * projects/{project_id}/iap_web/appengine-{app_id}
               * projects/{project_id}/iap_web/appengine-{app_id}/services/{service_id}
               * projects/{project_id}/iap_web/appengine-{app_id}/services/{service_id}/version/{version_id}
               
               
               - - -
        """
        if access_settings is not None:
            pulumi.set(__self__, "access_settings", access_settings)
        if application_settings is not None:
            pulumi.set(__self__, "application_settings", application_settings)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="accessSettings")
    def access_settings(self) -> Optional[pulumi.Input['SettingsAccessSettingsArgs']]:
        """
        Top level wrapper for all access related setting in IAP.
        Structure is documented below.
        """
        return pulumi.get(self, "access_settings")

    @access_settings.setter
    def access_settings(self, value: Optional[pulumi.Input['SettingsAccessSettingsArgs']]):
        pulumi.set(self, "access_settings", value)

    @property
    @pulumi.getter(name="applicationSettings")
    def application_settings(self) -> Optional[pulumi.Input['SettingsApplicationSettingsArgs']]:
        """
        Top level wrapper for all application related settings in IAP.
        Structure is documented below.
        """
        return pulumi.get(self, "application_settings")

    @application_settings.setter
    def application_settings(self, value: Optional[pulumi.Input['SettingsApplicationSettingsArgs']]):
        pulumi.set(self, "application_settings", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource name of the IAP protected resource. Name can have below resources:
        * organizations/{organization_id}
        * folders/{folder_id}
        * projects/{project_id}
        * projects/{project_id}/iap_web
        * projects/{project_id}/iap_web/compute
        * projects/{project_id}/iap_web/compute-{region}
        * projects/{project_id}/iap_web/compute/services/{service_id}
        * projects/{project_id}/iap_web/compute-{region}/services/{service_id}
        * projects/{project_id}/iap_web/appengine-{app_id}
        * projects/{project_id}/iap_web/appengine-{app_id}/services/{service_id}
        * projects/{project_id}/iap_web/appengine-{app_id}/services/{service_id}/version/{version_id}


        - - -
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _SettingsState:
    def __init__(__self__, *,
                 access_settings: Optional[pulumi.Input['SettingsAccessSettingsArgs']] = None,
                 application_settings: Optional[pulumi.Input['SettingsApplicationSettingsArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Settings resources.
        :param pulumi.Input['SettingsAccessSettingsArgs'] access_settings: Top level wrapper for all access related setting in IAP.
               Structure is documented below.
        :param pulumi.Input['SettingsApplicationSettingsArgs'] application_settings: Top level wrapper for all application related settings in IAP.
               Structure is documented below.
        :param pulumi.Input[builtins.str] name: The resource name of the IAP protected resource. Name can have below resources:
               * organizations/{organization_id}
               * folders/{folder_id}
               * projects/{project_id}
               * projects/{project_id}/iap_web
               * projects/{project_id}/iap_web/compute
               * projects/{project_id}/iap_web/compute-{region}
               * projects/{project_id}/iap_web/compute/services/{service_id}
               * projects/{project_id}/iap_web/compute-{region}/services/{service_id}
               * projects/{project_id}/iap_web/appengine-{app_id}
               * projects/{project_id}/iap_web/appengine-{app_id}/services/{service_id}
               * projects/{project_id}/iap_web/appengine-{app_id}/services/{service_id}/version/{version_id}
               
               
               - - -
        """
        if access_settings is not None:
            pulumi.set(__self__, "access_settings", access_settings)
        if application_settings is not None:
            pulumi.set(__self__, "application_settings", application_settings)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="accessSettings")
    def access_settings(self) -> Optional[pulumi.Input['SettingsAccessSettingsArgs']]:
        """
        Top level wrapper for all access related setting in IAP.
        Structure is documented below.
        """
        return pulumi.get(self, "access_settings")

    @access_settings.setter
    def access_settings(self, value: Optional[pulumi.Input['SettingsAccessSettingsArgs']]):
        pulumi.set(self, "access_settings", value)

    @property
    @pulumi.getter(name="applicationSettings")
    def application_settings(self) -> Optional[pulumi.Input['SettingsApplicationSettingsArgs']]:
        """
        Top level wrapper for all application related settings in IAP.
        Structure is documented below.
        """
        return pulumi.get(self, "application_settings")

    @application_settings.setter
    def application_settings(self, value: Optional[pulumi.Input['SettingsApplicationSettingsArgs']]):
        pulumi.set(self, "application_settings", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource name of the IAP protected resource. Name can have below resources:
        * organizations/{organization_id}
        * folders/{folder_id}
        * projects/{project_id}
        * projects/{project_id}/iap_web
        * projects/{project_id}/iap_web/compute
        * projects/{project_id}/iap_web/compute-{region}
        * projects/{project_id}/iap_web/compute/services/{service_id}
        * projects/{project_id}/iap_web/compute-{region}/services/{service_id}
        * projects/{project_id}/iap_web/appengine-{app_id}
        * projects/{project_id}/iap_web/appengine-{app_id}/services/{service_id}
        * projects/{project_id}/iap_web/appengine-{app_id}/services/{service_id}/version/{version_id}


        - - -
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.type_token("gcp:iap/settings:Settings")
class Settings(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_settings: Optional[pulumi.Input[Union['SettingsAccessSettingsArgs', 'SettingsAccessSettingsArgsDict']]] = None,
                 application_settings: Optional[pulumi.Input[Union['SettingsApplicationSettingsArgs', 'SettingsApplicationSettingsArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        IAP settings - manage IAP settings

        To get more information about Settings, see:

        * [API documentation](https://cloud.google.com/iap/docs/reference/rest/v1/IapSettings)
        * How-to Guides
            * [Customizing IAP](https://cloud.google.com/iap/docs/customizing)

        ## Example Usage

        ### Iap Settings Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        default_health_check = gcp.compute.HealthCheck("default",
            name="iap-bs-health-check",
            check_interval_sec=1,
            timeout_sec=1,
            tcp_health_check={
                "port": 80,
            })
        default = gcp.compute.RegionBackendService("default",
            name="iap-settings-tf",
            region="us-central1",
            health_checks=default_health_check.id,
            connection_draining_timeout_sec=10,
            session_affinity="CLIENT_IP")
        iap_settings = gcp.iap.Settings("iap_settings",
            name=default.name.apply(lambda name: f"projects/{project.number}/iap_web/compute-us-central1/services/{name}"),
            access_settings={
                "identity_sources": ["WORKFORCE_IDENTITY_FEDERATION"],
                "allowed_domains_settings": {
                    "domains": ["test.abc.com"],
                    "enable": True,
                },
                "cors_settings": {
                    "allow_http_options": True,
                },
                "reauth_settings": {
                    "method": "SECURE_KEY",
                    "max_age": "305s",
                    "policy_type": "MINIMUM",
                },
                "gcip_settings": {
                    "login_page_uri": "https://test.com/?apiKey=abc",
                },
                "oauth_settings": {
                    "login_hint": "test",
                },
                "workforce_identity_settings": {
                    "workforce_pools": "wif-pool",
                    "oauth2": {
                        "client_id": "test-client-id",
                        "client_secret": "test-client-secret",
                    },
                },
            },
            application_settings={
                "cookie_domain": "test.abc.com",
                "csm_settings": {
                    "rctoken_aud": "test-aud-set",
                },
                "access_denied_page_settings": {
                    "access_denied_page_uri": "test-uri",
                    "generate_troubleshooting_uri": True,
                    "remediation_token_generation_enabled": False,
                },
                "attribute_propagation_settings": {
                    "output_credentials": ["HEADER"],
                    "expression": "attributes.saml_attributes.filter(attribute, attribute.name in [\\"test1\\", \\"test2\\"])",
                    "enable": False,
                },
            })
        ```

        ## Import

        Settings can be imported using any of these accepted formats:

        * `{{name}}/iapSettings`

        * `{{name}}`

        When using the `pulumi import` command, Settings can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:iap/settings:Settings default {{name}}/iapSettings
        ```

        ```sh
        $ pulumi import gcp:iap/settings:Settings default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['SettingsAccessSettingsArgs', 'SettingsAccessSettingsArgsDict']] access_settings: Top level wrapper for all access related setting in IAP.
               Structure is documented below.
        :param pulumi.Input[Union['SettingsApplicationSettingsArgs', 'SettingsApplicationSettingsArgsDict']] application_settings: Top level wrapper for all application related settings in IAP.
               Structure is documented below.
        :param pulumi.Input[builtins.str] name: The resource name of the IAP protected resource. Name can have below resources:
               * organizations/{organization_id}
               * folders/{folder_id}
               * projects/{project_id}
               * projects/{project_id}/iap_web
               * projects/{project_id}/iap_web/compute
               * projects/{project_id}/iap_web/compute-{region}
               * projects/{project_id}/iap_web/compute/services/{service_id}
               * projects/{project_id}/iap_web/compute-{region}/services/{service_id}
               * projects/{project_id}/iap_web/appengine-{app_id}
               * projects/{project_id}/iap_web/appengine-{app_id}/services/{service_id}
               * projects/{project_id}/iap_web/appengine-{app_id}/services/{service_id}/version/{version_id}
               
               
               - - -
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[SettingsArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        IAP settings - manage IAP settings

        To get more information about Settings, see:

        * [API documentation](https://cloud.google.com/iap/docs/reference/rest/v1/IapSettings)
        * How-to Guides
            * [Customizing IAP](https://cloud.google.com/iap/docs/customizing)

        ## Example Usage

        ### Iap Settings Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        default_health_check = gcp.compute.HealthCheck("default",
            name="iap-bs-health-check",
            check_interval_sec=1,
            timeout_sec=1,
            tcp_health_check={
                "port": 80,
            })
        default = gcp.compute.RegionBackendService("default",
            name="iap-settings-tf",
            region="us-central1",
            health_checks=default_health_check.id,
            connection_draining_timeout_sec=10,
            session_affinity="CLIENT_IP")
        iap_settings = gcp.iap.Settings("iap_settings",
            name=default.name.apply(lambda name: f"projects/{project.number}/iap_web/compute-us-central1/services/{name}"),
            access_settings={
                "identity_sources": ["WORKFORCE_IDENTITY_FEDERATION"],
                "allowed_domains_settings": {
                    "domains": ["test.abc.com"],
                    "enable": True,
                },
                "cors_settings": {
                    "allow_http_options": True,
                },
                "reauth_settings": {
                    "method": "SECURE_KEY",
                    "max_age": "305s",
                    "policy_type": "MINIMUM",
                },
                "gcip_settings": {
                    "login_page_uri": "https://test.com/?apiKey=abc",
                },
                "oauth_settings": {
                    "login_hint": "test",
                },
                "workforce_identity_settings": {
                    "workforce_pools": "wif-pool",
                    "oauth2": {
                        "client_id": "test-client-id",
                        "client_secret": "test-client-secret",
                    },
                },
            },
            application_settings={
                "cookie_domain": "test.abc.com",
                "csm_settings": {
                    "rctoken_aud": "test-aud-set",
                },
                "access_denied_page_settings": {
                    "access_denied_page_uri": "test-uri",
                    "generate_troubleshooting_uri": True,
                    "remediation_token_generation_enabled": False,
                },
                "attribute_propagation_settings": {
                    "output_credentials": ["HEADER"],
                    "expression": "attributes.saml_attributes.filter(attribute, attribute.name in [\\"test1\\", \\"test2\\"])",
                    "enable": False,
                },
            })
        ```

        ## Import

        Settings can be imported using any of these accepted formats:

        * `{{name}}/iapSettings`

        * `{{name}}`

        When using the `pulumi import` command, Settings can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:iap/settings:Settings default {{name}}/iapSettings
        ```

        ```sh
        $ pulumi import gcp:iap/settings:Settings default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param SettingsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SettingsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_settings: Optional[pulumi.Input[Union['SettingsAccessSettingsArgs', 'SettingsAccessSettingsArgsDict']]] = None,
                 application_settings: Optional[pulumi.Input[Union['SettingsApplicationSettingsArgs', 'SettingsApplicationSettingsArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SettingsArgs.__new__(SettingsArgs)

            __props__.__dict__["access_settings"] = access_settings
            __props__.__dict__["application_settings"] = application_settings
            __props__.__dict__["name"] = name
        super(Settings, __self__).__init__(
            'gcp:iap/settings:Settings',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_settings: Optional[pulumi.Input[Union['SettingsAccessSettingsArgs', 'SettingsAccessSettingsArgsDict']]] = None,
            application_settings: Optional[pulumi.Input[Union['SettingsApplicationSettingsArgs', 'SettingsApplicationSettingsArgsDict']]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None) -> 'Settings':
        """
        Get an existing Settings resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['SettingsAccessSettingsArgs', 'SettingsAccessSettingsArgsDict']] access_settings: Top level wrapper for all access related setting in IAP.
               Structure is documented below.
        :param pulumi.Input[Union['SettingsApplicationSettingsArgs', 'SettingsApplicationSettingsArgsDict']] application_settings: Top level wrapper for all application related settings in IAP.
               Structure is documented below.
        :param pulumi.Input[builtins.str] name: The resource name of the IAP protected resource. Name can have below resources:
               * organizations/{organization_id}
               * folders/{folder_id}
               * projects/{project_id}
               * projects/{project_id}/iap_web
               * projects/{project_id}/iap_web/compute
               * projects/{project_id}/iap_web/compute-{region}
               * projects/{project_id}/iap_web/compute/services/{service_id}
               * projects/{project_id}/iap_web/compute-{region}/services/{service_id}
               * projects/{project_id}/iap_web/appengine-{app_id}
               * projects/{project_id}/iap_web/appengine-{app_id}/services/{service_id}
               * projects/{project_id}/iap_web/appengine-{app_id}/services/{service_id}/version/{version_id}
               
               
               - - -
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SettingsState.__new__(_SettingsState)

        __props__.__dict__["access_settings"] = access_settings
        __props__.__dict__["application_settings"] = application_settings
        __props__.__dict__["name"] = name
        return Settings(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessSettings")
    def access_settings(self) -> pulumi.Output[Optional['outputs.SettingsAccessSettings']]:
        """
        Top level wrapper for all access related setting in IAP.
        Structure is documented below.
        """
        return pulumi.get(self, "access_settings")

    @property
    @pulumi.getter(name="applicationSettings")
    def application_settings(self) -> pulumi.Output[Optional['outputs.SettingsApplicationSettings']]:
        """
        Top level wrapper for all application related settings in IAP.
        Structure is documented below.
        """
        return pulumi.get(self, "application_settings")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The resource name of the IAP protected resource. Name can have below resources:
        * organizations/{organization_id}
        * folders/{folder_id}
        * projects/{project_id}
        * projects/{project_id}/iap_web
        * projects/{project_id}/iap_web/compute
        * projects/{project_id}/iap_web/compute-{region}
        * projects/{project_id}/iap_web/compute/services/{service_id}
        * projects/{project_id}/iap_web/compute-{region}/services/{service_id}
        * projects/{project_id}/iap_web/appengine-{app_id}
        * projects/{project_id}/iap_web/appengine-{app_id}/services/{service_id}
        * projects/{project_id}/iap_web/appengine-{app_id}/services/{service_id}/version/{version_id}


        - - -
        """
        return pulumi.get(self, "name")

