# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ConfigArgs', 'Config']

@pulumi.input_type
class ConfigArgs:
    def __init__(__self__, *,
                 authorized_domains: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 autodelete_anonymous_users: Optional[pulumi.Input[builtins.bool]] = None,
                 blocking_functions: Optional[pulumi.Input['ConfigBlockingFunctionsArgs']] = None,
                 client: Optional[pulumi.Input['ConfigClientArgs']] = None,
                 mfa: Optional[pulumi.Input['ConfigMfaArgs']] = None,
                 monitoring: Optional[pulumi.Input['ConfigMonitoringArgs']] = None,
                 multi_tenant: Optional[pulumi.Input['ConfigMultiTenantArgs']] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 quota: Optional[pulumi.Input['ConfigQuotaArgs']] = None,
                 sign_in: Optional[pulumi.Input['ConfigSignInArgs']] = None,
                 sms_region_config: Optional[pulumi.Input['ConfigSmsRegionConfigArgs']] = None):
        """
        The set of arguments for constructing a Config resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] authorized_domains: List of domains authorized for OAuth redirects.
        :param pulumi.Input[builtins.bool] autodelete_anonymous_users: Whether anonymous users will be auto-deleted after a period of 30 days
        :param pulumi.Input['ConfigBlockingFunctionsArgs'] blocking_functions: Configuration related to blocking functions.
               Structure is documented below.
        :param pulumi.Input['ConfigClientArgs'] client: Options related to how clients making requests on behalf of a project should be configured.
               Structure is documented below.
        :param pulumi.Input['ConfigMfaArgs'] mfa: Options related to how clients making requests on behalf of a project should be configured.
               Structure is documented below.
        :param pulumi.Input['ConfigMonitoringArgs'] monitoring: Configuration related to monitoring project activity.
               Structure is documented below.
        :param pulumi.Input['ConfigMultiTenantArgs'] multi_tenant: Configuration related to multi-tenant functionality.
               Structure is documented below.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['ConfigQuotaArgs'] quota: Configuration related to quotas.
               Structure is documented below.
        :param pulumi.Input['ConfigSignInArgs'] sign_in: Configuration related to local sign in methods.
               Structure is documented below.
        :param pulumi.Input['ConfigSmsRegionConfigArgs'] sms_region_config: Configures the regions where users are allowed to send verification SMS for the project or tenant. This is based on the calling code of the destination phone number.
               Structure is documented below.
        """
        if authorized_domains is not None:
            pulumi.set(__self__, "authorized_domains", authorized_domains)
        if autodelete_anonymous_users is not None:
            pulumi.set(__self__, "autodelete_anonymous_users", autodelete_anonymous_users)
        if blocking_functions is not None:
            pulumi.set(__self__, "blocking_functions", blocking_functions)
        if client is not None:
            pulumi.set(__self__, "client", client)
        if mfa is not None:
            pulumi.set(__self__, "mfa", mfa)
        if monitoring is not None:
            pulumi.set(__self__, "monitoring", monitoring)
        if multi_tenant is not None:
            pulumi.set(__self__, "multi_tenant", multi_tenant)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if quota is not None:
            pulumi.set(__self__, "quota", quota)
        if sign_in is not None:
            pulumi.set(__self__, "sign_in", sign_in)
        if sms_region_config is not None:
            pulumi.set(__self__, "sms_region_config", sms_region_config)

    @property
    @pulumi.getter(name="authorizedDomains")
    def authorized_domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of domains authorized for OAuth redirects.
        """
        return pulumi.get(self, "authorized_domains")

    @authorized_domains.setter
    def authorized_domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "authorized_domains", value)

    @property
    @pulumi.getter(name="autodeleteAnonymousUsers")
    def autodelete_anonymous_users(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether anonymous users will be auto-deleted after a period of 30 days
        """
        return pulumi.get(self, "autodelete_anonymous_users")

    @autodelete_anonymous_users.setter
    def autodelete_anonymous_users(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "autodelete_anonymous_users", value)

    @property
    @pulumi.getter(name="blockingFunctions")
    def blocking_functions(self) -> Optional[pulumi.Input['ConfigBlockingFunctionsArgs']]:
        """
        Configuration related to blocking functions.
        Structure is documented below.
        """
        return pulumi.get(self, "blocking_functions")

    @blocking_functions.setter
    def blocking_functions(self, value: Optional[pulumi.Input['ConfigBlockingFunctionsArgs']]):
        pulumi.set(self, "blocking_functions", value)

    @property
    @pulumi.getter
    def client(self) -> Optional[pulumi.Input['ConfigClientArgs']]:
        """
        Options related to how clients making requests on behalf of a project should be configured.
        Structure is documented below.
        """
        return pulumi.get(self, "client")

    @client.setter
    def client(self, value: Optional[pulumi.Input['ConfigClientArgs']]):
        pulumi.set(self, "client", value)

    @property
    @pulumi.getter
    def mfa(self) -> Optional[pulumi.Input['ConfigMfaArgs']]:
        """
        Options related to how clients making requests on behalf of a project should be configured.
        Structure is documented below.
        """
        return pulumi.get(self, "mfa")

    @mfa.setter
    def mfa(self, value: Optional[pulumi.Input['ConfigMfaArgs']]):
        pulumi.set(self, "mfa", value)

    @property
    @pulumi.getter
    def monitoring(self) -> Optional[pulumi.Input['ConfigMonitoringArgs']]:
        """
        Configuration related to monitoring project activity.
        Structure is documented below.
        """
        return pulumi.get(self, "monitoring")

    @monitoring.setter
    def monitoring(self, value: Optional[pulumi.Input['ConfigMonitoringArgs']]):
        pulumi.set(self, "monitoring", value)

    @property
    @pulumi.getter(name="multiTenant")
    def multi_tenant(self) -> Optional[pulumi.Input['ConfigMultiTenantArgs']]:
        """
        Configuration related to multi-tenant functionality.
        Structure is documented below.
        """
        return pulumi.get(self, "multi_tenant")

    @multi_tenant.setter
    def multi_tenant(self, value: Optional[pulumi.Input['ConfigMultiTenantArgs']]):
        pulumi.set(self, "multi_tenant", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def quota(self) -> Optional[pulumi.Input['ConfigQuotaArgs']]:
        """
        Configuration related to quotas.
        Structure is documented below.
        """
        return pulumi.get(self, "quota")

    @quota.setter
    def quota(self, value: Optional[pulumi.Input['ConfigQuotaArgs']]):
        pulumi.set(self, "quota", value)

    @property
    @pulumi.getter(name="signIn")
    def sign_in(self) -> Optional[pulumi.Input['ConfigSignInArgs']]:
        """
        Configuration related to local sign in methods.
        Structure is documented below.
        """
        return pulumi.get(self, "sign_in")

    @sign_in.setter
    def sign_in(self, value: Optional[pulumi.Input['ConfigSignInArgs']]):
        pulumi.set(self, "sign_in", value)

    @property
    @pulumi.getter(name="smsRegionConfig")
    def sms_region_config(self) -> Optional[pulumi.Input['ConfigSmsRegionConfigArgs']]:
        """
        Configures the regions where users are allowed to send verification SMS for the project or tenant. This is based on the calling code of the destination phone number.
        Structure is documented below.
        """
        return pulumi.get(self, "sms_region_config")

    @sms_region_config.setter
    def sms_region_config(self, value: Optional[pulumi.Input['ConfigSmsRegionConfigArgs']]):
        pulumi.set(self, "sms_region_config", value)


@pulumi.input_type
class _ConfigState:
    def __init__(__self__, *,
                 authorized_domains: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 autodelete_anonymous_users: Optional[pulumi.Input[builtins.bool]] = None,
                 blocking_functions: Optional[pulumi.Input['ConfigBlockingFunctionsArgs']] = None,
                 client: Optional[pulumi.Input['ConfigClientArgs']] = None,
                 mfa: Optional[pulumi.Input['ConfigMfaArgs']] = None,
                 monitoring: Optional[pulumi.Input['ConfigMonitoringArgs']] = None,
                 multi_tenant: Optional[pulumi.Input['ConfigMultiTenantArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 quota: Optional[pulumi.Input['ConfigQuotaArgs']] = None,
                 sign_in: Optional[pulumi.Input['ConfigSignInArgs']] = None,
                 sms_region_config: Optional[pulumi.Input['ConfigSmsRegionConfigArgs']] = None):
        """
        Input properties used for looking up and filtering Config resources.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] authorized_domains: List of domains authorized for OAuth redirects.
        :param pulumi.Input[builtins.bool] autodelete_anonymous_users: Whether anonymous users will be auto-deleted after a period of 30 days
        :param pulumi.Input['ConfigBlockingFunctionsArgs'] blocking_functions: Configuration related to blocking functions.
               Structure is documented below.
        :param pulumi.Input['ConfigClientArgs'] client: Options related to how clients making requests on behalf of a project should be configured.
               Structure is documented below.
        :param pulumi.Input['ConfigMfaArgs'] mfa: Options related to how clients making requests on behalf of a project should be configured.
               Structure is documented below.
        :param pulumi.Input['ConfigMonitoringArgs'] monitoring: Configuration related to monitoring project activity.
               Structure is documented below.
        :param pulumi.Input['ConfigMultiTenantArgs'] multi_tenant: Configuration related to multi-tenant functionality.
               Structure is documented below.
        :param pulumi.Input[builtins.str] name: The name of the Config resource
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['ConfigQuotaArgs'] quota: Configuration related to quotas.
               Structure is documented below.
        :param pulumi.Input['ConfigSignInArgs'] sign_in: Configuration related to local sign in methods.
               Structure is documented below.
        :param pulumi.Input['ConfigSmsRegionConfigArgs'] sms_region_config: Configures the regions where users are allowed to send verification SMS for the project or tenant. This is based on the calling code of the destination phone number.
               Structure is documented below.
        """
        if authorized_domains is not None:
            pulumi.set(__self__, "authorized_domains", authorized_domains)
        if autodelete_anonymous_users is not None:
            pulumi.set(__self__, "autodelete_anonymous_users", autodelete_anonymous_users)
        if blocking_functions is not None:
            pulumi.set(__self__, "blocking_functions", blocking_functions)
        if client is not None:
            pulumi.set(__self__, "client", client)
        if mfa is not None:
            pulumi.set(__self__, "mfa", mfa)
        if monitoring is not None:
            pulumi.set(__self__, "monitoring", monitoring)
        if multi_tenant is not None:
            pulumi.set(__self__, "multi_tenant", multi_tenant)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if quota is not None:
            pulumi.set(__self__, "quota", quota)
        if sign_in is not None:
            pulumi.set(__self__, "sign_in", sign_in)
        if sms_region_config is not None:
            pulumi.set(__self__, "sms_region_config", sms_region_config)

    @property
    @pulumi.getter(name="authorizedDomains")
    def authorized_domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of domains authorized for OAuth redirects.
        """
        return pulumi.get(self, "authorized_domains")

    @authorized_domains.setter
    def authorized_domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "authorized_domains", value)

    @property
    @pulumi.getter(name="autodeleteAnonymousUsers")
    def autodelete_anonymous_users(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether anonymous users will be auto-deleted after a period of 30 days
        """
        return pulumi.get(self, "autodelete_anonymous_users")

    @autodelete_anonymous_users.setter
    def autodelete_anonymous_users(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "autodelete_anonymous_users", value)

    @property
    @pulumi.getter(name="blockingFunctions")
    def blocking_functions(self) -> Optional[pulumi.Input['ConfigBlockingFunctionsArgs']]:
        """
        Configuration related to blocking functions.
        Structure is documented below.
        """
        return pulumi.get(self, "blocking_functions")

    @blocking_functions.setter
    def blocking_functions(self, value: Optional[pulumi.Input['ConfigBlockingFunctionsArgs']]):
        pulumi.set(self, "blocking_functions", value)

    @property
    @pulumi.getter
    def client(self) -> Optional[pulumi.Input['ConfigClientArgs']]:
        """
        Options related to how clients making requests on behalf of a project should be configured.
        Structure is documented below.
        """
        return pulumi.get(self, "client")

    @client.setter
    def client(self, value: Optional[pulumi.Input['ConfigClientArgs']]):
        pulumi.set(self, "client", value)

    @property
    @pulumi.getter
    def mfa(self) -> Optional[pulumi.Input['ConfigMfaArgs']]:
        """
        Options related to how clients making requests on behalf of a project should be configured.
        Structure is documented below.
        """
        return pulumi.get(self, "mfa")

    @mfa.setter
    def mfa(self, value: Optional[pulumi.Input['ConfigMfaArgs']]):
        pulumi.set(self, "mfa", value)

    @property
    @pulumi.getter
    def monitoring(self) -> Optional[pulumi.Input['ConfigMonitoringArgs']]:
        """
        Configuration related to monitoring project activity.
        Structure is documented below.
        """
        return pulumi.get(self, "monitoring")

    @monitoring.setter
    def monitoring(self, value: Optional[pulumi.Input['ConfigMonitoringArgs']]):
        pulumi.set(self, "monitoring", value)

    @property
    @pulumi.getter(name="multiTenant")
    def multi_tenant(self) -> Optional[pulumi.Input['ConfigMultiTenantArgs']]:
        """
        Configuration related to multi-tenant functionality.
        Structure is documented below.
        """
        return pulumi.get(self, "multi_tenant")

    @multi_tenant.setter
    def multi_tenant(self, value: Optional[pulumi.Input['ConfigMultiTenantArgs']]):
        pulumi.set(self, "multi_tenant", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Config resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def quota(self) -> Optional[pulumi.Input['ConfigQuotaArgs']]:
        """
        Configuration related to quotas.
        Structure is documented below.
        """
        return pulumi.get(self, "quota")

    @quota.setter
    def quota(self, value: Optional[pulumi.Input['ConfigQuotaArgs']]):
        pulumi.set(self, "quota", value)

    @property
    @pulumi.getter(name="signIn")
    def sign_in(self) -> Optional[pulumi.Input['ConfigSignInArgs']]:
        """
        Configuration related to local sign in methods.
        Structure is documented below.
        """
        return pulumi.get(self, "sign_in")

    @sign_in.setter
    def sign_in(self, value: Optional[pulumi.Input['ConfigSignInArgs']]):
        pulumi.set(self, "sign_in", value)

    @property
    @pulumi.getter(name="smsRegionConfig")
    def sms_region_config(self) -> Optional[pulumi.Input['ConfigSmsRegionConfigArgs']]:
        """
        Configures the regions where users are allowed to send verification SMS for the project or tenant. This is based on the calling code of the destination phone number.
        Structure is documented below.
        """
        return pulumi.get(self, "sms_region_config")

    @sms_region_config.setter
    def sms_region_config(self, value: Optional[pulumi.Input['ConfigSmsRegionConfigArgs']]):
        pulumi.set(self, "sms_region_config", value)


@pulumi.type_token("gcp:identityplatform/config:Config")
class Config(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authorized_domains: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 autodelete_anonymous_users: Optional[pulumi.Input[builtins.bool]] = None,
                 blocking_functions: Optional[pulumi.Input[Union['ConfigBlockingFunctionsArgs', 'ConfigBlockingFunctionsArgsDict']]] = None,
                 client: Optional[pulumi.Input[Union['ConfigClientArgs', 'ConfigClientArgsDict']]] = None,
                 mfa: Optional[pulumi.Input[Union['ConfigMfaArgs', 'ConfigMfaArgsDict']]] = None,
                 monitoring: Optional[pulumi.Input[Union['ConfigMonitoringArgs', 'ConfigMonitoringArgsDict']]] = None,
                 multi_tenant: Optional[pulumi.Input[Union['ConfigMultiTenantArgs', 'ConfigMultiTenantArgsDict']]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 quota: Optional[pulumi.Input[Union['ConfigQuotaArgs', 'ConfigQuotaArgsDict']]] = None,
                 sign_in: Optional[pulumi.Input[Union['ConfigSignInArgs', 'ConfigSignInArgsDict']]] = None,
                 sms_region_config: Optional[pulumi.Input[Union['ConfigSmsRegionConfigArgs', 'ConfigSmsRegionConfigArgsDict']]] = None,
                 __props__=None):
        """
        Identity Platform configuration for a Cloud project. Identity Platform is an
        end-to-end authentication system for third-party users to access apps
        and services.

        This entity is created only once during intialization and cannot be deleted,
        individual Identity Providers may be disabled instead.  This resource may only
        be created in billing-enabled projects.

        To get more information about Config, see:

        * [API documentation](https://cloud.google.com/identity-platform/docs/reference/rest/v2/Config)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/identity-platform/docs)

        ## Example Usage

        ### Identity Platform Config Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.organizations.Project("default",
            project_id="my-project",
            name="my-project",
            org_id="123456789",
            billing_account="000000-0000000-0000000-000000",
            deletion_policy="DELETE",
            labels={
                "firebase": "enabled",
            })
        identitytoolkit = gcp.projects.Service("identitytoolkit",
            project=default.project_id,
            service="identitytoolkit.googleapis.com")
        default_config = gcp.identityplatform.Config("default",
            project=default.project_id,
            autodelete_anonymous_users=True,
            sign_in={
                "allow_duplicate_emails": True,
                "anonymous": {
                    "enabled": True,
                },
                "email": {
                    "enabled": True,
                    "password_required": False,
                },
                "phone_number": {
                    "enabled": True,
                    "test_phone_numbers": {
                        "+11231231234": "000000",
                    },
                },
            },
            sms_region_config={
                "allowlist_only": {
                    "allowed_regions": [
                        "US",
                        "CA",
                    ],
                },
            },
            blocking_functions={
                "triggers": [{
                    "event_type": "beforeSignIn",
                    "function_uri": "https://us-east1-my-project.cloudfunctions.net/before-sign-in",
                }],
                "forward_inbound_credentials": {
                    "refresh_token": True,
                    "access_token": True,
                    "id_token": True,
                },
            },
            quota={
                "sign_up_quota_config": {
                    "quota": 1000,
                    "start_time": "2014-10-02T15:01:23Z",
                    "quota_duration": "7200s",
                },
            },
            authorized_domains=[
                "localhost",
                "my-project.firebaseapp.com",
                "my-project.web.app",
            ])
        ```

        ## Import

        Config can be imported using any of these accepted formats:

        * `projects/{{project}}/config`

        * `projects/{{project}}`

        * `{{project}}`

        When using the `pulumi import` command, Config can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:identityplatform/config:Config default projects/{{project}}/config
        ```

        ```sh
        $ pulumi import gcp:identityplatform/config:Config default projects/{{project}}
        ```

        ```sh
        $ pulumi import gcp:identityplatform/config:Config default {{project}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] authorized_domains: List of domains authorized for OAuth redirects.
        :param pulumi.Input[builtins.bool] autodelete_anonymous_users: Whether anonymous users will be auto-deleted after a period of 30 days
        :param pulumi.Input[Union['ConfigBlockingFunctionsArgs', 'ConfigBlockingFunctionsArgsDict']] blocking_functions: Configuration related to blocking functions.
               Structure is documented below.
        :param pulumi.Input[Union['ConfigClientArgs', 'ConfigClientArgsDict']] client: Options related to how clients making requests on behalf of a project should be configured.
               Structure is documented below.
        :param pulumi.Input[Union['ConfigMfaArgs', 'ConfigMfaArgsDict']] mfa: Options related to how clients making requests on behalf of a project should be configured.
               Structure is documented below.
        :param pulumi.Input[Union['ConfigMonitoringArgs', 'ConfigMonitoringArgsDict']] monitoring: Configuration related to monitoring project activity.
               Structure is documented below.
        :param pulumi.Input[Union['ConfigMultiTenantArgs', 'ConfigMultiTenantArgsDict']] multi_tenant: Configuration related to multi-tenant functionality.
               Structure is documented below.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['ConfigQuotaArgs', 'ConfigQuotaArgsDict']] quota: Configuration related to quotas.
               Structure is documented below.
        :param pulumi.Input[Union['ConfigSignInArgs', 'ConfigSignInArgsDict']] sign_in: Configuration related to local sign in methods.
               Structure is documented below.
        :param pulumi.Input[Union['ConfigSmsRegionConfigArgs', 'ConfigSmsRegionConfigArgsDict']] sms_region_config: Configures the regions where users are allowed to send verification SMS for the project or tenant. This is based on the calling code of the destination phone number.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ConfigArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Identity Platform configuration for a Cloud project. Identity Platform is an
        end-to-end authentication system for third-party users to access apps
        and services.

        This entity is created only once during intialization and cannot be deleted,
        individual Identity Providers may be disabled instead.  This resource may only
        be created in billing-enabled projects.

        To get more information about Config, see:

        * [API documentation](https://cloud.google.com/identity-platform/docs/reference/rest/v2/Config)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/identity-platform/docs)

        ## Example Usage

        ### Identity Platform Config Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.organizations.Project("default",
            project_id="my-project",
            name="my-project",
            org_id="123456789",
            billing_account="000000-0000000-0000000-000000",
            deletion_policy="DELETE",
            labels={
                "firebase": "enabled",
            })
        identitytoolkit = gcp.projects.Service("identitytoolkit",
            project=default.project_id,
            service="identitytoolkit.googleapis.com")
        default_config = gcp.identityplatform.Config("default",
            project=default.project_id,
            autodelete_anonymous_users=True,
            sign_in={
                "allow_duplicate_emails": True,
                "anonymous": {
                    "enabled": True,
                },
                "email": {
                    "enabled": True,
                    "password_required": False,
                },
                "phone_number": {
                    "enabled": True,
                    "test_phone_numbers": {
                        "+11231231234": "000000",
                    },
                },
            },
            sms_region_config={
                "allowlist_only": {
                    "allowed_regions": [
                        "US",
                        "CA",
                    ],
                },
            },
            blocking_functions={
                "triggers": [{
                    "event_type": "beforeSignIn",
                    "function_uri": "https://us-east1-my-project.cloudfunctions.net/before-sign-in",
                }],
                "forward_inbound_credentials": {
                    "refresh_token": True,
                    "access_token": True,
                    "id_token": True,
                },
            },
            quota={
                "sign_up_quota_config": {
                    "quota": 1000,
                    "start_time": "2014-10-02T15:01:23Z",
                    "quota_duration": "7200s",
                },
            },
            authorized_domains=[
                "localhost",
                "my-project.firebaseapp.com",
                "my-project.web.app",
            ])
        ```

        ## Import

        Config can be imported using any of these accepted formats:

        * `projects/{{project}}/config`

        * `projects/{{project}}`

        * `{{project}}`

        When using the `pulumi import` command, Config can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:identityplatform/config:Config default projects/{{project}}/config
        ```

        ```sh
        $ pulumi import gcp:identityplatform/config:Config default projects/{{project}}
        ```

        ```sh
        $ pulumi import gcp:identityplatform/config:Config default {{project}}
        ```

        :param str resource_name: The name of the resource.
        :param ConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authorized_domains: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 autodelete_anonymous_users: Optional[pulumi.Input[builtins.bool]] = None,
                 blocking_functions: Optional[pulumi.Input[Union['ConfigBlockingFunctionsArgs', 'ConfigBlockingFunctionsArgsDict']]] = None,
                 client: Optional[pulumi.Input[Union['ConfigClientArgs', 'ConfigClientArgsDict']]] = None,
                 mfa: Optional[pulumi.Input[Union['ConfigMfaArgs', 'ConfigMfaArgsDict']]] = None,
                 monitoring: Optional[pulumi.Input[Union['ConfigMonitoringArgs', 'ConfigMonitoringArgsDict']]] = None,
                 multi_tenant: Optional[pulumi.Input[Union['ConfigMultiTenantArgs', 'ConfigMultiTenantArgsDict']]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 quota: Optional[pulumi.Input[Union['ConfigQuotaArgs', 'ConfigQuotaArgsDict']]] = None,
                 sign_in: Optional[pulumi.Input[Union['ConfigSignInArgs', 'ConfigSignInArgsDict']]] = None,
                 sms_region_config: Optional[pulumi.Input[Union['ConfigSmsRegionConfigArgs', 'ConfigSmsRegionConfigArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConfigArgs.__new__(ConfigArgs)

            __props__.__dict__["authorized_domains"] = authorized_domains
            __props__.__dict__["autodelete_anonymous_users"] = autodelete_anonymous_users
            __props__.__dict__["blocking_functions"] = blocking_functions
            __props__.__dict__["client"] = client
            __props__.__dict__["mfa"] = mfa
            __props__.__dict__["monitoring"] = monitoring
            __props__.__dict__["multi_tenant"] = multi_tenant
            __props__.__dict__["project"] = project
            __props__.__dict__["quota"] = quota
            __props__.__dict__["sign_in"] = sign_in
            __props__.__dict__["sms_region_config"] = sms_region_config
            __props__.__dict__["name"] = None
        super(Config, __self__).__init__(
            'gcp:identityplatform/config:Config',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            authorized_domains: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            autodelete_anonymous_users: Optional[pulumi.Input[builtins.bool]] = None,
            blocking_functions: Optional[pulumi.Input[Union['ConfigBlockingFunctionsArgs', 'ConfigBlockingFunctionsArgsDict']]] = None,
            client: Optional[pulumi.Input[Union['ConfigClientArgs', 'ConfigClientArgsDict']]] = None,
            mfa: Optional[pulumi.Input[Union['ConfigMfaArgs', 'ConfigMfaArgsDict']]] = None,
            monitoring: Optional[pulumi.Input[Union['ConfigMonitoringArgs', 'ConfigMonitoringArgsDict']]] = None,
            multi_tenant: Optional[pulumi.Input[Union['ConfigMultiTenantArgs', 'ConfigMultiTenantArgsDict']]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            quota: Optional[pulumi.Input[Union['ConfigQuotaArgs', 'ConfigQuotaArgsDict']]] = None,
            sign_in: Optional[pulumi.Input[Union['ConfigSignInArgs', 'ConfigSignInArgsDict']]] = None,
            sms_region_config: Optional[pulumi.Input[Union['ConfigSmsRegionConfigArgs', 'ConfigSmsRegionConfigArgsDict']]] = None) -> 'Config':
        """
        Get an existing Config resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] authorized_domains: List of domains authorized for OAuth redirects.
        :param pulumi.Input[builtins.bool] autodelete_anonymous_users: Whether anonymous users will be auto-deleted after a period of 30 days
        :param pulumi.Input[Union['ConfigBlockingFunctionsArgs', 'ConfigBlockingFunctionsArgsDict']] blocking_functions: Configuration related to blocking functions.
               Structure is documented below.
        :param pulumi.Input[Union['ConfigClientArgs', 'ConfigClientArgsDict']] client: Options related to how clients making requests on behalf of a project should be configured.
               Structure is documented below.
        :param pulumi.Input[Union['ConfigMfaArgs', 'ConfigMfaArgsDict']] mfa: Options related to how clients making requests on behalf of a project should be configured.
               Structure is documented below.
        :param pulumi.Input[Union['ConfigMonitoringArgs', 'ConfigMonitoringArgsDict']] monitoring: Configuration related to monitoring project activity.
               Structure is documented below.
        :param pulumi.Input[Union['ConfigMultiTenantArgs', 'ConfigMultiTenantArgsDict']] multi_tenant: Configuration related to multi-tenant functionality.
               Structure is documented below.
        :param pulumi.Input[builtins.str] name: The name of the Config resource
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['ConfigQuotaArgs', 'ConfigQuotaArgsDict']] quota: Configuration related to quotas.
               Structure is documented below.
        :param pulumi.Input[Union['ConfigSignInArgs', 'ConfigSignInArgsDict']] sign_in: Configuration related to local sign in methods.
               Structure is documented below.
        :param pulumi.Input[Union['ConfigSmsRegionConfigArgs', 'ConfigSmsRegionConfigArgsDict']] sms_region_config: Configures the regions where users are allowed to send verification SMS for the project or tenant. This is based on the calling code of the destination phone number.
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConfigState.__new__(_ConfigState)

        __props__.__dict__["authorized_domains"] = authorized_domains
        __props__.__dict__["autodelete_anonymous_users"] = autodelete_anonymous_users
        __props__.__dict__["blocking_functions"] = blocking_functions
        __props__.__dict__["client"] = client
        __props__.__dict__["mfa"] = mfa
        __props__.__dict__["monitoring"] = monitoring
        __props__.__dict__["multi_tenant"] = multi_tenant
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["quota"] = quota
        __props__.__dict__["sign_in"] = sign_in
        __props__.__dict__["sms_region_config"] = sms_region_config
        return Config(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="authorizedDomains")
    def authorized_domains(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        List of domains authorized for OAuth redirects.
        """
        return pulumi.get(self, "authorized_domains")

    @property
    @pulumi.getter(name="autodeleteAnonymousUsers")
    def autodelete_anonymous_users(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether anonymous users will be auto-deleted after a period of 30 days
        """
        return pulumi.get(self, "autodelete_anonymous_users")

    @property
    @pulumi.getter(name="blockingFunctions")
    def blocking_functions(self) -> pulumi.Output[Optional['outputs.ConfigBlockingFunctions']]:
        """
        Configuration related to blocking functions.
        Structure is documented below.
        """
        return pulumi.get(self, "blocking_functions")

    @property
    @pulumi.getter
    def client(self) -> pulumi.Output['outputs.ConfigClient']:
        """
        Options related to how clients making requests on behalf of a project should be configured.
        Structure is documented below.
        """
        return pulumi.get(self, "client")

    @property
    @pulumi.getter
    def mfa(self) -> pulumi.Output['outputs.ConfigMfa']:
        """
        Options related to how clients making requests on behalf of a project should be configured.
        Structure is documented below.
        """
        return pulumi.get(self, "mfa")

    @property
    @pulumi.getter
    def monitoring(self) -> pulumi.Output['outputs.ConfigMonitoring']:
        """
        Configuration related to monitoring project activity.
        Structure is documented below.
        """
        return pulumi.get(self, "monitoring")

    @property
    @pulumi.getter(name="multiTenant")
    def multi_tenant(self) -> pulumi.Output[Optional['outputs.ConfigMultiTenant']]:
        """
        Configuration related to multi-tenant functionality.
        Structure is documented below.
        """
        return pulumi.get(self, "multi_tenant")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Config resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def quota(self) -> pulumi.Output[Optional['outputs.ConfigQuota']]:
        """
        Configuration related to quotas.
        Structure is documented below.
        """
        return pulumi.get(self, "quota")

    @property
    @pulumi.getter(name="signIn")
    def sign_in(self) -> pulumi.Output['outputs.ConfigSignIn']:
        """
        Configuration related to local sign in methods.
        Structure is documented below.
        """
        return pulumi.get(self, "sign_in")

    @property
    @pulumi.getter(name="smsRegionConfig")
    def sms_region_config(self) -> pulumi.Output['outputs.ConfigSmsRegionConfig']:
        """
        Configures the regions where users are allowed to send verification SMS for the project or tenant. This is based on the calling code of the destination phone number.
        Structure is documented below.
        """
        return pulumi.get(self, "sms_region_config")

