# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ConfigBlockingFunctions',
    'ConfigBlockingFunctionsForwardInboundCredentials',
    'ConfigBlockingFunctionsTrigger',
    'ConfigClient',
    'ConfigClientPermissions',
    'ConfigMfa',
    'ConfigMfaProviderConfig',
    'ConfigMfaProviderConfigTotpProviderConfig',
    'ConfigMonitoring',
    'ConfigMonitoringRequestLogging',
    'ConfigMultiTenant',
    'ConfigQuota',
    'ConfigQuotaSignUpQuotaConfig',
    'ConfigSignIn',
    'ConfigSignInAnonymous',
    'ConfigSignInEmail',
    'ConfigSignInHashConfig',
    'ConfigSignInPhoneNumber',
    'ConfigSmsRegionConfig',
    'ConfigSmsRegionConfigAllowByDefault',
    'ConfigSmsRegionConfigAllowlistOnly',
    'InboundSamlConfigIdpConfig',
    'InboundSamlConfigIdpConfigIdpCertificate',
    'InboundSamlConfigSpConfig',
    'InboundSamlConfigSpConfigSpCertificate',
    'OauthIdpConfigResponseType',
    'TenantClient',
    'TenantClientPermissions',
    'TenantInboundSamlConfigIdpConfig',
    'TenantInboundSamlConfigIdpConfigIdpCertificate',
    'TenantInboundSamlConfigSpConfig',
    'TenantInboundSamlConfigSpConfigSpCertificate',
]

@pulumi.output_type
class ConfigBlockingFunctions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "forwardInboundCredentials":
            suggest = "forward_inbound_credentials"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigBlockingFunctions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigBlockingFunctions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigBlockingFunctions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 triggers: Sequence['outputs.ConfigBlockingFunctionsTrigger'],
                 forward_inbound_credentials: Optional['outputs.ConfigBlockingFunctionsForwardInboundCredentials'] = None):
        """
        :param Sequence['ConfigBlockingFunctionsTriggerArgs'] triggers: Map of Trigger to event type. Key should be one of the supported event types: "beforeCreate", "beforeSignIn".
               Structure is documented below.
        :param 'ConfigBlockingFunctionsForwardInboundCredentialsArgs' forward_inbound_credentials: The user credentials to include in the JWT payload that is sent to the registered Blocking Functions.
               Structure is documented below.
        """
        pulumi.set(__self__, "triggers", triggers)
        if forward_inbound_credentials is not None:
            pulumi.set(__self__, "forward_inbound_credentials", forward_inbound_credentials)

    @property
    @pulumi.getter
    def triggers(self) -> Sequence['outputs.ConfigBlockingFunctionsTrigger']:
        """
        Map of Trigger to event type. Key should be one of the supported event types: "beforeCreate", "beforeSignIn".
        Structure is documented below.
        """
        return pulumi.get(self, "triggers")

    @property
    @pulumi.getter(name="forwardInboundCredentials")
    def forward_inbound_credentials(self) -> Optional['outputs.ConfigBlockingFunctionsForwardInboundCredentials']:
        """
        The user credentials to include in the JWT payload that is sent to the registered Blocking Functions.
        Structure is documented below.
        """
        return pulumi.get(self, "forward_inbound_credentials")


@pulumi.output_type
class ConfigBlockingFunctionsForwardInboundCredentials(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessToken":
            suggest = "access_token"
        elif key == "idToken":
            suggest = "id_token"
        elif key == "refreshToken":
            suggest = "refresh_token"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigBlockingFunctionsForwardInboundCredentials. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigBlockingFunctionsForwardInboundCredentials.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigBlockingFunctionsForwardInboundCredentials.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_token: Optional[builtins.bool] = None,
                 id_token: Optional[builtins.bool] = None,
                 refresh_token: Optional[builtins.bool] = None):
        """
        :param builtins.bool access_token: Whether to pass the user's OAuth identity provider's access token.
        :param builtins.bool id_token: Whether to pass the user's OIDC identity provider's ID token.
        :param builtins.bool refresh_token: Whether to pass the user's OAuth identity provider's refresh token.
        """
        if access_token is not None:
            pulumi.set(__self__, "access_token", access_token)
        if id_token is not None:
            pulumi.set(__self__, "id_token", id_token)
        if refresh_token is not None:
            pulumi.set(__self__, "refresh_token", refresh_token)

    @property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> Optional[builtins.bool]:
        """
        Whether to pass the user's OAuth identity provider's access token.
        """
        return pulumi.get(self, "access_token")

    @property
    @pulumi.getter(name="idToken")
    def id_token(self) -> Optional[builtins.bool]:
        """
        Whether to pass the user's OIDC identity provider's ID token.
        """
        return pulumi.get(self, "id_token")

    @property
    @pulumi.getter(name="refreshToken")
    def refresh_token(self) -> Optional[builtins.bool]:
        """
        Whether to pass the user's OAuth identity provider's refresh token.
        """
        return pulumi.get(self, "refresh_token")


@pulumi.output_type
class ConfigBlockingFunctionsTrigger(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eventType":
            suggest = "event_type"
        elif key == "functionUri":
            suggest = "function_uri"
        elif key == "updateTime":
            suggest = "update_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigBlockingFunctionsTrigger. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigBlockingFunctionsTrigger.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigBlockingFunctionsTrigger.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 event_type: builtins.str,
                 function_uri: builtins.str,
                 update_time: Optional[builtins.str] = None):
        """
        :param builtins.str event_type: The identifier for this object. Format specified above.
        :param builtins.str function_uri: HTTP URI trigger for the Cloud Function.
        :param builtins.str update_time: (Output)
               When the trigger was changed.
        """
        pulumi.set(__self__, "event_type", event_type)
        pulumi.set(__self__, "function_uri", function_uri)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="eventType")
    def event_type(self) -> builtins.str:
        """
        The identifier for this object. Format specified above.
        """
        return pulumi.get(self, "event_type")

    @property
    @pulumi.getter(name="functionUri")
    def function_uri(self) -> builtins.str:
        """
        HTTP URI trigger for the Cloud Function.
        """
        return pulumi.get(self, "function_uri")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[builtins.str]:
        """
        (Output)
        When the trigger was changed.
        """
        return pulumi.get(self, "update_time")


@pulumi.output_type
class ConfigClient(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiKey":
            suggest = "api_key"
        elif key == "firebaseSubdomain":
            suggest = "firebase_subdomain"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigClient. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigClient.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigClient.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_key: Optional[builtins.str] = None,
                 firebase_subdomain: Optional[builtins.str] = None,
                 permissions: Optional['outputs.ConfigClientPermissions'] = None):
        """
        :param builtins.str api_key: (Output)
               API key that can be used when making requests for this project.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param builtins.str firebase_subdomain: (Output)
               Firebase subdomain.
        :param 'ConfigClientPermissionsArgs' permissions: Configuration related to restricting a user's ability to affect their account.
               Structure is documented below.
        """
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if firebase_subdomain is not None:
            pulumi.set(__self__, "firebase_subdomain", firebase_subdomain)
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[builtins.str]:
        """
        (Output)
        API key that can be used when making requests for this project.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter(name="firebaseSubdomain")
    def firebase_subdomain(self) -> Optional[builtins.str]:
        """
        (Output)
        Firebase subdomain.
        """
        return pulumi.get(self, "firebase_subdomain")

    @property
    @pulumi.getter
    def permissions(self) -> Optional['outputs.ConfigClientPermissions']:
        """
        Configuration related to restricting a user's ability to affect their account.
        Structure is documented below.
        """
        return pulumi.get(self, "permissions")


@pulumi.output_type
class ConfigClientPermissions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "disabledUserDeletion":
            suggest = "disabled_user_deletion"
        elif key == "disabledUserSignup":
            suggest = "disabled_user_signup"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigClientPermissions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigClientPermissions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigClientPermissions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disabled_user_deletion: Optional[builtins.bool] = None,
                 disabled_user_signup: Optional[builtins.bool] = None):
        """
        :param builtins.bool disabled_user_deletion: When true, end users cannot delete their account on the associated project through any of our API methods
        :param builtins.bool disabled_user_signup: When true, end users cannot sign up for a new account on the associated project through any of our API methods
        """
        if disabled_user_deletion is not None:
            pulumi.set(__self__, "disabled_user_deletion", disabled_user_deletion)
        if disabled_user_signup is not None:
            pulumi.set(__self__, "disabled_user_signup", disabled_user_signup)

    @property
    @pulumi.getter(name="disabledUserDeletion")
    def disabled_user_deletion(self) -> Optional[builtins.bool]:
        """
        When true, end users cannot delete their account on the associated project through any of our API methods
        """
        return pulumi.get(self, "disabled_user_deletion")

    @property
    @pulumi.getter(name="disabledUserSignup")
    def disabled_user_signup(self) -> Optional[builtins.bool]:
        """
        When true, end users cannot sign up for a new account on the associated project through any of our API methods
        """
        return pulumi.get(self, "disabled_user_signup")


@pulumi.output_type
class ConfigMfa(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enabledProviders":
            suggest = "enabled_providers"
        elif key == "providerConfigs":
            suggest = "provider_configs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigMfa. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigMfa.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigMfa.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled_providers: Optional[Sequence[builtins.str]] = None,
                 provider_configs: Optional[Sequence['outputs.ConfigMfaProviderConfig']] = None,
                 state: Optional[builtins.str] = None):
        """
        :param Sequence[builtins.str] enabled_providers: A list of usable second factors for this project.
               Each value may be one of: `PHONE_SMS`.
        :param Sequence['ConfigMfaProviderConfigArgs'] provider_configs: A list of usable second factors for this project along with their configurations.
               This field does not support phone based MFA, for that use the 'enabledProviders' field.
               Structure is documented below.
        :param builtins.str state: Whether MultiFactor Authentication has been enabled for this project.
               Possible values are: `DISABLED`, `ENABLED`, `MANDATORY`.
        """
        if enabled_providers is not None:
            pulumi.set(__self__, "enabled_providers", enabled_providers)
        if provider_configs is not None:
            pulumi.set(__self__, "provider_configs", provider_configs)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="enabledProviders")
    def enabled_providers(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of usable second factors for this project.
        Each value may be one of: `PHONE_SMS`.
        """
        return pulumi.get(self, "enabled_providers")

    @property
    @pulumi.getter(name="providerConfigs")
    def provider_configs(self) -> Optional[Sequence['outputs.ConfigMfaProviderConfig']]:
        """
        A list of usable second factors for this project along with their configurations.
        This field does not support phone based MFA, for that use the 'enabledProviders' field.
        Structure is documented below.
        """
        return pulumi.get(self, "provider_configs")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        Whether MultiFactor Authentication has been enabled for this project.
        Possible values are: `DISABLED`, `ENABLED`, `MANDATORY`.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class ConfigMfaProviderConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "totpProviderConfig":
            suggest = "totp_provider_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigMfaProviderConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigMfaProviderConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigMfaProviderConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 state: Optional[builtins.str] = None,
                 totp_provider_config: Optional['outputs.ConfigMfaProviderConfigTotpProviderConfig'] = None):
        """
        :param builtins.str state: Whether MultiFactor Authentication has been enabled for this project.
               Possible values are: `DISABLED`, `ENABLED`, `MANDATORY`.
        :param 'ConfigMfaProviderConfigTotpProviderConfigArgs' totp_provider_config: TOTP MFA provider config for this project.
               Structure is documented below.
        """
        if state is not None:
            pulumi.set(__self__, "state", state)
        if totp_provider_config is not None:
            pulumi.set(__self__, "totp_provider_config", totp_provider_config)

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        Whether MultiFactor Authentication has been enabled for this project.
        Possible values are: `DISABLED`, `ENABLED`, `MANDATORY`.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="totpProviderConfig")
    def totp_provider_config(self) -> Optional['outputs.ConfigMfaProviderConfigTotpProviderConfig']:
        """
        TOTP MFA provider config for this project.
        Structure is documented below.
        """
        return pulumi.get(self, "totp_provider_config")


@pulumi.output_type
class ConfigMfaProviderConfigTotpProviderConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adjacentIntervals":
            suggest = "adjacent_intervals"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigMfaProviderConfigTotpProviderConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigMfaProviderConfigTotpProviderConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigMfaProviderConfigTotpProviderConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 adjacent_intervals: Optional[builtins.int] = None):
        """
        :param builtins.int adjacent_intervals: The allowed number of adjacent intervals that will be used for verification to avoid clock skew.
        """
        if adjacent_intervals is not None:
            pulumi.set(__self__, "adjacent_intervals", adjacent_intervals)

    @property
    @pulumi.getter(name="adjacentIntervals")
    def adjacent_intervals(self) -> Optional[builtins.int]:
        """
        The allowed number of adjacent intervals that will be used for verification to avoid clock skew.
        """
        return pulumi.get(self, "adjacent_intervals")


@pulumi.output_type
class ConfigMonitoring(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "requestLogging":
            suggest = "request_logging"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigMonitoring. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigMonitoring.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigMonitoring.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 request_logging: Optional['outputs.ConfigMonitoringRequestLogging'] = None):
        """
        :param 'ConfigMonitoringRequestLoggingArgs' request_logging: Configuration for logging requests made to this project to Stackdriver Logging
               Structure is documented below.
        """
        if request_logging is not None:
            pulumi.set(__self__, "request_logging", request_logging)

    @property
    @pulumi.getter(name="requestLogging")
    def request_logging(self) -> Optional['outputs.ConfigMonitoringRequestLogging']:
        """
        Configuration for logging requests made to this project to Stackdriver Logging
        Structure is documented below.
        """
        return pulumi.get(self, "request_logging")


@pulumi.output_type
class ConfigMonitoringRequestLogging(dict):
    def __init__(__self__, *,
                 enabled: Optional[builtins.bool] = None):
        """
        :param builtins.bool enabled: Whether logging is enabled for this project or not.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[builtins.bool]:
        """
        Whether logging is enabled for this project or not.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class ConfigMultiTenant(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowTenants":
            suggest = "allow_tenants"
        elif key == "defaultTenantLocation":
            suggest = "default_tenant_location"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigMultiTenant. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigMultiTenant.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigMultiTenant.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_tenants: Optional[builtins.bool] = None,
                 default_tenant_location: Optional[builtins.str] = None):
        """
        :param builtins.bool allow_tenants: Whether this project can have tenants or not.
        :param builtins.str default_tenant_location: The default cloud parent org or folder that the tenant project should be created under.
               The parent resource name should be in the format of "/", such as "folders/123" or "organizations/456".
               If the value is not set, the tenant will be created under the same organization or folder as the agent project.
        """
        if allow_tenants is not None:
            pulumi.set(__self__, "allow_tenants", allow_tenants)
        if default_tenant_location is not None:
            pulumi.set(__self__, "default_tenant_location", default_tenant_location)

    @property
    @pulumi.getter(name="allowTenants")
    def allow_tenants(self) -> Optional[builtins.bool]:
        """
        Whether this project can have tenants or not.
        """
        return pulumi.get(self, "allow_tenants")

    @property
    @pulumi.getter(name="defaultTenantLocation")
    def default_tenant_location(self) -> Optional[builtins.str]:
        """
        The default cloud parent org or folder that the tenant project should be created under.
        The parent resource name should be in the format of "/", such as "folders/123" or "organizations/456".
        If the value is not set, the tenant will be created under the same organization or folder as the agent project.
        """
        return pulumi.get(self, "default_tenant_location")


@pulumi.output_type
class ConfigQuota(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "signUpQuotaConfig":
            suggest = "sign_up_quota_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigQuota. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigQuota.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigQuota.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 sign_up_quota_config: Optional['outputs.ConfigQuotaSignUpQuotaConfig'] = None):
        """
        :param 'ConfigQuotaSignUpQuotaConfigArgs' sign_up_quota_config: Quota for the Signup endpoint, if overwritten. Signup quota is measured in sign ups per project per hour per IP. None of quota, startTime, or quotaDuration can be skipped.
               Structure is documented below.
        """
        if sign_up_quota_config is not None:
            pulumi.set(__self__, "sign_up_quota_config", sign_up_quota_config)

    @property
    @pulumi.getter(name="signUpQuotaConfig")
    def sign_up_quota_config(self) -> Optional['outputs.ConfigQuotaSignUpQuotaConfig']:
        """
        Quota for the Signup endpoint, if overwritten. Signup quota is measured in sign ups per project per hour per IP. None of quota, startTime, or quotaDuration can be skipped.
        Structure is documented below.
        """
        return pulumi.get(self, "sign_up_quota_config")


@pulumi.output_type
class ConfigQuotaSignUpQuotaConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "quotaDuration":
            suggest = "quota_duration"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigQuotaSignUpQuotaConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigQuotaSignUpQuotaConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigQuotaSignUpQuotaConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 quota: Optional[builtins.int] = None,
                 quota_duration: Optional[builtins.str] = None,
                 start_time: Optional[builtins.str] = None):
        """
        :param builtins.int quota: A sign up APIs quota that customers can override temporarily. Value can be in between 1 and 1000.
        :param builtins.str quota_duration: How long this quota will be active for. It is measurred in seconds, e.g., Example: "9.615s".
        :param builtins.str start_time: When this quota will take affect.
        """
        if quota is not None:
            pulumi.set(__self__, "quota", quota)
        if quota_duration is not None:
            pulumi.set(__self__, "quota_duration", quota_duration)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter
    def quota(self) -> Optional[builtins.int]:
        """
        A sign up APIs quota that customers can override temporarily. Value can be in between 1 and 1000.
        """
        return pulumi.get(self, "quota")

    @property
    @pulumi.getter(name="quotaDuration")
    def quota_duration(self) -> Optional[builtins.str]:
        """
        How long this quota will be active for. It is measurred in seconds, e.g., Example: "9.615s".
        """
        return pulumi.get(self, "quota_duration")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[builtins.str]:
        """
        When this quota will take affect.
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class ConfigSignIn(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowDuplicateEmails":
            suggest = "allow_duplicate_emails"
        elif key == "hashConfigs":
            suggest = "hash_configs"
        elif key == "phoneNumber":
            suggest = "phone_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigSignIn. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigSignIn.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigSignIn.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_duplicate_emails: Optional[builtins.bool] = None,
                 anonymous: Optional['outputs.ConfigSignInAnonymous'] = None,
                 email: Optional['outputs.ConfigSignInEmail'] = None,
                 hash_configs: Optional[Sequence['outputs.ConfigSignInHashConfig']] = None,
                 phone_number: Optional['outputs.ConfigSignInPhoneNumber'] = None):
        """
        :param builtins.bool allow_duplicate_emails: Whether to allow more than one account to have the same email.
        :param 'ConfigSignInAnonymousArgs' anonymous: Configuration options related to authenticating an anonymous user.
               Structure is documented below.
        :param 'ConfigSignInEmailArgs' email: Configuration options related to authenticating a user by their email address.
               Structure is documented below.
        :param Sequence['ConfigSignInHashConfigArgs'] hash_configs: (Output)
               Output only. Hash config information.
               Structure is documented below.
        :param 'ConfigSignInPhoneNumberArgs' phone_number: Configuration options related to authenticated a user by their phone number.
               Structure is documented below.
        """
        if allow_duplicate_emails is not None:
            pulumi.set(__self__, "allow_duplicate_emails", allow_duplicate_emails)
        if anonymous is not None:
            pulumi.set(__self__, "anonymous", anonymous)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if hash_configs is not None:
            pulumi.set(__self__, "hash_configs", hash_configs)
        if phone_number is not None:
            pulumi.set(__self__, "phone_number", phone_number)

    @property
    @pulumi.getter(name="allowDuplicateEmails")
    def allow_duplicate_emails(self) -> Optional[builtins.bool]:
        """
        Whether to allow more than one account to have the same email.
        """
        return pulumi.get(self, "allow_duplicate_emails")

    @property
    @pulumi.getter
    def anonymous(self) -> Optional['outputs.ConfigSignInAnonymous']:
        """
        Configuration options related to authenticating an anonymous user.
        Structure is documented below.
        """
        return pulumi.get(self, "anonymous")

    @property
    @pulumi.getter
    def email(self) -> Optional['outputs.ConfigSignInEmail']:
        """
        Configuration options related to authenticating a user by their email address.
        Structure is documented below.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="hashConfigs")
    def hash_configs(self) -> Optional[Sequence['outputs.ConfigSignInHashConfig']]:
        """
        (Output)
        Output only. Hash config information.
        Structure is documented below.
        """
        return pulumi.get(self, "hash_configs")

    @property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> Optional['outputs.ConfigSignInPhoneNumber']:
        """
        Configuration options related to authenticated a user by their phone number.
        Structure is documented below.
        """
        return pulumi.get(self, "phone_number")


@pulumi.output_type
class ConfigSignInAnonymous(dict):
    def __init__(__self__, *,
                 enabled: builtins.bool):
        """
        :param builtins.bool enabled: Whether anonymous user auth is enabled for the project or not.
               
               <a name="nested_sign_in_hash_config"></a>The `hash_config` block contains:
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        Whether anonymous user auth is enabled for the project or not.

        <a name="nested_sign_in_hash_config"></a>The `hash_config` block contains:
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class ConfigSignInEmail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "passwordRequired":
            suggest = "password_required"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigSignInEmail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigSignInEmail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigSignInEmail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: builtins.bool,
                 password_required: Optional[builtins.bool] = None):
        """
        :param builtins.bool enabled: Whether email auth is enabled for the project or not.
        :param builtins.bool password_required: Whether a password is required for email auth or not. If true, both an email and
               password must be provided to sign in. If false, a user may sign in via either
               email/password or email link.
        """
        pulumi.set(__self__, "enabled", enabled)
        if password_required is not None:
            pulumi.set(__self__, "password_required", password_required)

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        Whether email auth is enabled for the project or not.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="passwordRequired")
    def password_required(self) -> Optional[builtins.bool]:
        """
        Whether a password is required for email auth or not. If true, both an email and
        password must be provided to sign in. If false, a user may sign in via either
        email/password or email link.
        """
        return pulumi.get(self, "password_required")


@pulumi.output_type
class ConfigSignInHashConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "memoryCost":
            suggest = "memory_cost"
        elif key == "saltSeparator":
            suggest = "salt_separator"
        elif key == "signerKey":
            suggest = "signer_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigSignInHashConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigSignInHashConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigSignInHashConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 algorithm: Optional[builtins.str] = None,
                 memory_cost: Optional[builtins.int] = None,
                 rounds: Optional[builtins.int] = None,
                 salt_separator: Optional[builtins.str] = None,
                 signer_key: Optional[builtins.str] = None):
        """
        :param builtins.str algorithm: Different password hash algorithms used in Identity Toolkit.
        :param builtins.int memory_cost: Memory cost for hash calculation. Used by scrypt and other similar password derivation algorithms. See https://tools.ietf.org/html/rfc7914 for explanation of field.
        :param builtins.int rounds: How many rounds for hash calculation. Used by scrypt and other similar password derivation algorithms.
        :param builtins.str salt_separator: Non-printable character to be inserted between the salt and plain text password in base64.
        :param builtins.str signer_key: Signer key in base64.
        """
        if algorithm is not None:
            pulumi.set(__self__, "algorithm", algorithm)
        if memory_cost is not None:
            pulumi.set(__self__, "memory_cost", memory_cost)
        if rounds is not None:
            pulumi.set(__self__, "rounds", rounds)
        if salt_separator is not None:
            pulumi.set(__self__, "salt_separator", salt_separator)
        if signer_key is not None:
            pulumi.set(__self__, "signer_key", signer_key)

    @property
    @pulumi.getter
    def algorithm(self) -> Optional[builtins.str]:
        """
        Different password hash algorithms used in Identity Toolkit.
        """
        return pulumi.get(self, "algorithm")

    @property
    @pulumi.getter(name="memoryCost")
    def memory_cost(self) -> Optional[builtins.int]:
        """
        Memory cost for hash calculation. Used by scrypt and other similar password derivation algorithms. See https://tools.ietf.org/html/rfc7914 for explanation of field.
        """
        return pulumi.get(self, "memory_cost")

    @property
    @pulumi.getter
    def rounds(self) -> Optional[builtins.int]:
        """
        How many rounds for hash calculation. Used by scrypt and other similar password derivation algorithms.
        """
        return pulumi.get(self, "rounds")

    @property
    @pulumi.getter(name="saltSeparator")
    def salt_separator(self) -> Optional[builtins.str]:
        """
        Non-printable character to be inserted between the salt and plain text password in base64.
        """
        return pulumi.get(self, "salt_separator")

    @property
    @pulumi.getter(name="signerKey")
    def signer_key(self) -> Optional[builtins.str]:
        """
        Signer key in base64.
        """
        return pulumi.get(self, "signer_key")


@pulumi.output_type
class ConfigSignInPhoneNumber(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "testPhoneNumbers":
            suggest = "test_phone_numbers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigSignInPhoneNumber. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigSignInPhoneNumber.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigSignInPhoneNumber.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: builtins.bool,
                 test_phone_numbers: Optional[Mapping[str, builtins.str]] = None):
        """
        :param builtins.bool enabled: Whether phone number auth is enabled for the project or not.
        :param Mapping[str, builtins.str] test_phone_numbers: A map of <test phone number, fake code> that can be used for phone auth testing.
        """
        pulumi.set(__self__, "enabled", enabled)
        if test_phone_numbers is not None:
            pulumi.set(__self__, "test_phone_numbers", test_phone_numbers)

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        Whether phone number auth is enabled for the project or not.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="testPhoneNumbers")
    def test_phone_numbers(self) -> Optional[Mapping[str, builtins.str]]:
        """
        A map of <test phone number, fake code> that can be used for phone auth testing.
        """
        return pulumi.get(self, "test_phone_numbers")


@pulumi.output_type
class ConfigSmsRegionConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowByDefault":
            suggest = "allow_by_default"
        elif key == "allowlistOnly":
            suggest = "allowlist_only"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigSmsRegionConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigSmsRegionConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigSmsRegionConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_by_default: Optional['outputs.ConfigSmsRegionConfigAllowByDefault'] = None,
                 allowlist_only: Optional['outputs.ConfigSmsRegionConfigAllowlistOnly'] = None):
        """
        :param 'ConfigSmsRegionConfigAllowByDefaultArgs' allow_by_default: A policy of allowing SMS to every region by default and adding disallowed regions to a disallow list.
               Structure is documented below.
        :param 'ConfigSmsRegionConfigAllowlistOnlyArgs' allowlist_only: A policy of only allowing regions by explicitly adding them to an allowlist.
               Structure is documented below.
        """
        if allow_by_default is not None:
            pulumi.set(__self__, "allow_by_default", allow_by_default)
        if allowlist_only is not None:
            pulumi.set(__self__, "allowlist_only", allowlist_only)

    @property
    @pulumi.getter(name="allowByDefault")
    def allow_by_default(self) -> Optional['outputs.ConfigSmsRegionConfigAllowByDefault']:
        """
        A policy of allowing SMS to every region by default and adding disallowed regions to a disallow list.
        Structure is documented below.
        """
        return pulumi.get(self, "allow_by_default")

    @property
    @pulumi.getter(name="allowlistOnly")
    def allowlist_only(self) -> Optional['outputs.ConfigSmsRegionConfigAllowlistOnly']:
        """
        A policy of only allowing regions by explicitly adding them to an allowlist.
        Structure is documented below.
        """
        return pulumi.get(self, "allowlist_only")


@pulumi.output_type
class ConfigSmsRegionConfigAllowByDefault(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "disallowedRegions":
            suggest = "disallowed_regions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigSmsRegionConfigAllowByDefault. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigSmsRegionConfigAllowByDefault.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigSmsRegionConfigAllowByDefault.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disallowed_regions: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence[builtins.str] disallowed_regions: Two letter unicode region codes to disallow as defined by https://cldr.unicode.org/ The full list of these region codes is here: https://github.com/unicode-cldr/cldr-localenames-full/blob/master/main/en/territories.json
        """
        if disallowed_regions is not None:
            pulumi.set(__self__, "disallowed_regions", disallowed_regions)

    @property
    @pulumi.getter(name="disallowedRegions")
    def disallowed_regions(self) -> Optional[Sequence[builtins.str]]:
        """
        Two letter unicode region codes to disallow as defined by https://cldr.unicode.org/ The full list of these region codes is here: https://github.com/unicode-cldr/cldr-localenames-full/blob/master/main/en/territories.json
        """
        return pulumi.get(self, "disallowed_regions")


@pulumi.output_type
class ConfigSmsRegionConfigAllowlistOnly(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedRegions":
            suggest = "allowed_regions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigSmsRegionConfigAllowlistOnly. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigSmsRegionConfigAllowlistOnly.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigSmsRegionConfigAllowlistOnly.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_regions: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence[builtins.str] allowed_regions: Two letter unicode region codes to allow as defined by https://cldr.unicode.org/ The full list of these region codes is here: https://github.com/unicode-cldr/cldr-localenames-full/blob/master/main/en/territories.json
        """
        if allowed_regions is not None:
            pulumi.set(__self__, "allowed_regions", allowed_regions)

    @property
    @pulumi.getter(name="allowedRegions")
    def allowed_regions(self) -> Optional[Sequence[builtins.str]]:
        """
        Two letter unicode region codes to allow as defined by https://cldr.unicode.org/ The full list of these region codes is here: https://github.com/unicode-cldr/cldr-localenames-full/blob/master/main/en/territories.json
        """
        return pulumi.get(self, "allowed_regions")


@pulumi.output_type
class InboundSamlConfigIdpConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "idpCertificates":
            suggest = "idp_certificates"
        elif key == "idpEntityId":
            suggest = "idp_entity_id"
        elif key == "ssoUrl":
            suggest = "sso_url"
        elif key == "signRequest":
            suggest = "sign_request"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InboundSamlConfigIdpConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InboundSamlConfigIdpConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InboundSamlConfigIdpConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 idp_certificates: Sequence['outputs.InboundSamlConfigIdpConfigIdpCertificate'],
                 idp_entity_id: builtins.str,
                 sso_url: builtins.str,
                 sign_request: Optional[builtins.bool] = None):
        """
        :param Sequence['InboundSamlConfigIdpConfigIdpCertificateArgs'] idp_certificates: The IdP's certificate data to verify the signature in the SAMLResponse issued by the IDP.
               Structure is documented below.
        :param builtins.str idp_entity_id: Unique identifier for all SAML entities
        :param builtins.str sso_url: URL to send Authentication request to.
        :param builtins.bool sign_request: Indicates if outbounding SAMLRequest should be signed.
        """
        pulumi.set(__self__, "idp_certificates", idp_certificates)
        pulumi.set(__self__, "idp_entity_id", idp_entity_id)
        pulumi.set(__self__, "sso_url", sso_url)
        if sign_request is not None:
            pulumi.set(__self__, "sign_request", sign_request)

    @property
    @pulumi.getter(name="idpCertificates")
    def idp_certificates(self) -> Sequence['outputs.InboundSamlConfigIdpConfigIdpCertificate']:
        """
        The IdP's certificate data to verify the signature in the SAMLResponse issued by the IDP.
        Structure is documented below.
        """
        return pulumi.get(self, "idp_certificates")

    @property
    @pulumi.getter(name="idpEntityId")
    def idp_entity_id(self) -> builtins.str:
        """
        Unique identifier for all SAML entities
        """
        return pulumi.get(self, "idp_entity_id")

    @property
    @pulumi.getter(name="ssoUrl")
    def sso_url(self) -> builtins.str:
        """
        URL to send Authentication request to.
        """
        return pulumi.get(self, "sso_url")

    @property
    @pulumi.getter(name="signRequest")
    def sign_request(self) -> Optional[builtins.bool]:
        """
        Indicates if outbounding SAMLRequest should be signed.
        """
        return pulumi.get(self, "sign_request")


@pulumi.output_type
class InboundSamlConfigIdpConfigIdpCertificate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "x509Certificate":
            suggest = "x509_certificate"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InboundSamlConfigIdpConfigIdpCertificate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InboundSamlConfigIdpConfigIdpCertificate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InboundSamlConfigIdpConfigIdpCertificate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 x509_certificate: Optional[builtins.str] = None):
        """
        :param builtins.str x509_certificate: The IdP's x509 certificate.
        """
        if x509_certificate is not None:
            pulumi.set(__self__, "x509_certificate", x509_certificate)

    @property
    @pulumi.getter(name="x509Certificate")
    def x509_certificate(self) -> Optional[builtins.str]:
        """
        The IdP's x509 certificate.
        """
        return pulumi.get(self, "x509_certificate")


@pulumi.output_type
class InboundSamlConfigSpConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "callbackUri":
            suggest = "callback_uri"
        elif key == "spCertificates":
            suggest = "sp_certificates"
        elif key == "spEntityId":
            suggest = "sp_entity_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InboundSamlConfigSpConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InboundSamlConfigSpConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InboundSamlConfigSpConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 callback_uri: Optional[builtins.str] = None,
                 sp_certificates: Optional[Sequence['outputs.InboundSamlConfigSpConfigSpCertificate']] = None,
                 sp_entity_id: Optional[builtins.str] = None):
        """
        :param builtins.str callback_uri: Callback URI where responses from IDP are handled. Must start with `https://`.
        :param Sequence['InboundSamlConfigSpConfigSpCertificateArgs'] sp_certificates: (Output)
               The IDP's certificate data to verify the signature in the SAMLResponse issued by the IDP.
               Structure is documented below.
               
               
               <a name="nested_sp_config_sp_certificates"></a>The `sp_certificates` block contains:
        :param builtins.str sp_entity_id: Unique identifier for all SAML entities.
        """
        if callback_uri is not None:
            pulumi.set(__self__, "callback_uri", callback_uri)
        if sp_certificates is not None:
            pulumi.set(__self__, "sp_certificates", sp_certificates)
        if sp_entity_id is not None:
            pulumi.set(__self__, "sp_entity_id", sp_entity_id)

    @property
    @pulumi.getter(name="callbackUri")
    def callback_uri(self) -> Optional[builtins.str]:
        """
        Callback URI where responses from IDP are handled. Must start with `https://`.
        """
        return pulumi.get(self, "callback_uri")

    @property
    @pulumi.getter(name="spCertificates")
    def sp_certificates(self) -> Optional[Sequence['outputs.InboundSamlConfigSpConfigSpCertificate']]:
        """
        (Output)
        The IDP's certificate data to verify the signature in the SAMLResponse issued by the IDP.
        Structure is documented below.


        <a name="nested_sp_config_sp_certificates"></a>The `sp_certificates` block contains:
        """
        return pulumi.get(self, "sp_certificates")

    @property
    @pulumi.getter(name="spEntityId")
    def sp_entity_id(self) -> Optional[builtins.str]:
        """
        Unique identifier for all SAML entities.
        """
        return pulumi.get(self, "sp_entity_id")


@pulumi.output_type
class InboundSamlConfigSpConfigSpCertificate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "x509Certificate":
            suggest = "x509_certificate"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InboundSamlConfigSpConfigSpCertificate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InboundSamlConfigSpConfigSpCertificate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InboundSamlConfigSpConfigSpCertificate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 x509_certificate: Optional[builtins.str] = None):
        """
        :param builtins.str x509_certificate: The x509 certificate
        """
        if x509_certificate is not None:
            pulumi.set(__self__, "x509_certificate", x509_certificate)

    @property
    @pulumi.getter(name="x509Certificate")
    def x509_certificate(self) -> Optional[builtins.str]:
        """
        The x509 certificate
        """
        return pulumi.get(self, "x509_certificate")


@pulumi.output_type
class OauthIdpConfigResponseType(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "idToken":
            suggest = "id_token"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OauthIdpConfigResponseType. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OauthIdpConfigResponseType.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OauthIdpConfigResponseType.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 code: Optional[builtins.bool] = None,
                 id_token: Optional[builtins.bool] = None):
        """
        :param builtins.bool code: If true, authorization code is returned from IdP's authorization endpoint.
        :param builtins.bool id_token: If true, ID token is returned from IdP's authorization endpoint.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if id_token is not None:
            pulumi.set(__self__, "id_token", id_token)

    @property
    @pulumi.getter
    def code(self) -> Optional[builtins.bool]:
        """
        If true, authorization code is returned from IdP's authorization endpoint.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter(name="idToken")
    def id_token(self) -> Optional[builtins.bool]:
        """
        If true, ID token is returned from IdP's authorization endpoint.
        """
        return pulumi.get(self, "id_token")


@pulumi.output_type
class TenantClient(dict):
    def __init__(__self__, *,
                 permissions: Optional['outputs.TenantClientPermissions'] = None):
        """
        :param 'TenantClientPermissionsArgs' permissions: Configuration related to restricting a user's ability to affect their account.
               Structure is documented below.
        """
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)

    @property
    @pulumi.getter
    def permissions(self) -> Optional['outputs.TenantClientPermissions']:
        """
        Configuration related to restricting a user's ability to affect their account.
        Structure is documented below.
        """
        return pulumi.get(self, "permissions")


@pulumi.output_type
class TenantClientPermissions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "disabledUserDeletion":
            suggest = "disabled_user_deletion"
        elif key == "disabledUserSignup":
            suggest = "disabled_user_signup"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TenantClientPermissions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TenantClientPermissions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TenantClientPermissions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disabled_user_deletion: Optional[builtins.bool] = None,
                 disabled_user_signup: Optional[builtins.bool] = None):
        """
        :param builtins.bool disabled_user_deletion: When true, end users cannot delete their account on the associated project through any of our API methods.
        :param builtins.bool disabled_user_signup: When true, end users cannot sign up for a new account on the associated project through any of our API methods.
        """
        if disabled_user_deletion is not None:
            pulumi.set(__self__, "disabled_user_deletion", disabled_user_deletion)
        if disabled_user_signup is not None:
            pulumi.set(__self__, "disabled_user_signup", disabled_user_signup)

    @property
    @pulumi.getter(name="disabledUserDeletion")
    def disabled_user_deletion(self) -> Optional[builtins.bool]:
        """
        When true, end users cannot delete their account on the associated project through any of our API methods.
        """
        return pulumi.get(self, "disabled_user_deletion")

    @property
    @pulumi.getter(name="disabledUserSignup")
    def disabled_user_signup(self) -> Optional[builtins.bool]:
        """
        When true, end users cannot sign up for a new account on the associated project through any of our API methods.
        """
        return pulumi.get(self, "disabled_user_signup")


@pulumi.output_type
class TenantInboundSamlConfigIdpConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "idpCertificates":
            suggest = "idp_certificates"
        elif key == "idpEntityId":
            suggest = "idp_entity_id"
        elif key == "ssoUrl":
            suggest = "sso_url"
        elif key == "signRequest":
            suggest = "sign_request"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TenantInboundSamlConfigIdpConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TenantInboundSamlConfigIdpConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TenantInboundSamlConfigIdpConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 idp_certificates: Sequence['outputs.TenantInboundSamlConfigIdpConfigIdpCertificate'],
                 idp_entity_id: builtins.str,
                 sso_url: builtins.str,
                 sign_request: Optional[builtins.bool] = None):
        """
        :param Sequence['TenantInboundSamlConfigIdpConfigIdpCertificateArgs'] idp_certificates: The IDP's certificate data to verify the signature in the SAMLResponse issued by the IDP.
               Structure is documented below.
        :param builtins.str idp_entity_id: Unique identifier for all SAML entities
        :param builtins.str sso_url: URL to send Authentication request to.
        :param builtins.bool sign_request: Indicates if outbounding SAMLRequest should be signed.
        """
        pulumi.set(__self__, "idp_certificates", idp_certificates)
        pulumi.set(__self__, "idp_entity_id", idp_entity_id)
        pulumi.set(__self__, "sso_url", sso_url)
        if sign_request is not None:
            pulumi.set(__self__, "sign_request", sign_request)

    @property
    @pulumi.getter(name="idpCertificates")
    def idp_certificates(self) -> Sequence['outputs.TenantInboundSamlConfigIdpConfigIdpCertificate']:
        """
        The IDP's certificate data to verify the signature in the SAMLResponse issued by the IDP.
        Structure is documented below.
        """
        return pulumi.get(self, "idp_certificates")

    @property
    @pulumi.getter(name="idpEntityId")
    def idp_entity_id(self) -> builtins.str:
        """
        Unique identifier for all SAML entities
        """
        return pulumi.get(self, "idp_entity_id")

    @property
    @pulumi.getter(name="ssoUrl")
    def sso_url(self) -> builtins.str:
        """
        URL to send Authentication request to.
        """
        return pulumi.get(self, "sso_url")

    @property
    @pulumi.getter(name="signRequest")
    def sign_request(self) -> Optional[builtins.bool]:
        """
        Indicates if outbounding SAMLRequest should be signed.
        """
        return pulumi.get(self, "sign_request")


@pulumi.output_type
class TenantInboundSamlConfigIdpConfigIdpCertificate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "x509Certificate":
            suggest = "x509_certificate"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TenantInboundSamlConfigIdpConfigIdpCertificate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TenantInboundSamlConfigIdpConfigIdpCertificate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TenantInboundSamlConfigIdpConfigIdpCertificate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 x509_certificate: Optional[builtins.str] = None):
        """
        :param builtins.str x509_certificate: The x509 certificate
        """
        if x509_certificate is not None:
            pulumi.set(__self__, "x509_certificate", x509_certificate)

    @property
    @pulumi.getter(name="x509Certificate")
    def x509_certificate(self) -> Optional[builtins.str]:
        """
        The x509 certificate
        """
        return pulumi.get(self, "x509_certificate")


@pulumi.output_type
class TenantInboundSamlConfigSpConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "callbackUri":
            suggest = "callback_uri"
        elif key == "spEntityId":
            suggest = "sp_entity_id"
        elif key == "spCertificates":
            suggest = "sp_certificates"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TenantInboundSamlConfigSpConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TenantInboundSamlConfigSpConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TenantInboundSamlConfigSpConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 callback_uri: builtins.str,
                 sp_entity_id: builtins.str,
                 sp_certificates: Optional[Sequence['outputs.TenantInboundSamlConfigSpConfigSpCertificate']] = None):
        """
        :param builtins.str callback_uri: Callback URI where responses from IDP are handled. Must start with `https://`.
        :param builtins.str sp_entity_id: Unique identifier for all SAML entities.
        :param Sequence['TenantInboundSamlConfigSpConfigSpCertificateArgs'] sp_certificates: (Output)
               The IDP's certificate data to verify the signature in the SAMLResponse issued by the IDP.
               Structure is documented below.
               
               
               <a name="nested_sp_config_sp_certificates"></a>The `sp_certificates` block contains:
        """
        pulumi.set(__self__, "callback_uri", callback_uri)
        pulumi.set(__self__, "sp_entity_id", sp_entity_id)
        if sp_certificates is not None:
            pulumi.set(__self__, "sp_certificates", sp_certificates)

    @property
    @pulumi.getter(name="callbackUri")
    def callback_uri(self) -> builtins.str:
        """
        Callback URI where responses from IDP are handled. Must start with `https://`.
        """
        return pulumi.get(self, "callback_uri")

    @property
    @pulumi.getter(name="spEntityId")
    def sp_entity_id(self) -> builtins.str:
        """
        Unique identifier for all SAML entities.
        """
        return pulumi.get(self, "sp_entity_id")

    @property
    @pulumi.getter(name="spCertificates")
    def sp_certificates(self) -> Optional[Sequence['outputs.TenantInboundSamlConfigSpConfigSpCertificate']]:
        """
        (Output)
        The IDP's certificate data to verify the signature in the SAMLResponse issued by the IDP.
        Structure is documented below.


        <a name="nested_sp_config_sp_certificates"></a>The `sp_certificates` block contains:
        """
        return pulumi.get(self, "sp_certificates")


@pulumi.output_type
class TenantInboundSamlConfigSpConfigSpCertificate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "x509Certificate":
            suggest = "x509_certificate"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TenantInboundSamlConfigSpConfigSpCertificate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TenantInboundSamlConfigSpConfigSpCertificate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TenantInboundSamlConfigSpConfigSpCertificate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 x509_certificate: Optional[builtins.str] = None):
        """
        :param builtins.str x509_certificate: The x509 certificate
        """
        if x509_certificate is not None:
            pulumi.set(__self__, "x509_certificate", x509_certificate)

    @property
    @pulumi.getter(name="x509Certificate")
    def x509_certificate(self) -> Optional[builtins.str]:
        """
        The x509 certificate
        """
        return pulumi.get(self, "x509_certificate")


