# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetCryptoKeyIamPolicyResult',
    'AwaitableGetCryptoKeyIamPolicyResult',
    'get_crypto_key_iam_policy',
    'get_crypto_key_iam_policy_output',
]

@pulumi.output_type
class GetCryptoKeyIamPolicyResult:
    """
    A collection of values returned by getCryptoKeyIamPolicy.
    """
    def __init__(__self__, crypto_key_id=None, etag=None, id=None, policy_data=None):
        if crypto_key_id and not isinstance(crypto_key_id, str):
            raise TypeError("Expected argument 'crypto_key_id' to be a str")
        pulumi.set(__self__, "crypto_key_id", crypto_key_id)
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if policy_data and not isinstance(policy_data, str):
            raise TypeError("Expected argument 'policy_data' to be a str")
        pulumi.set(__self__, "policy_data", policy_data)

    @property
    @pulumi.getter(name="cryptoKeyId")
    def crypto_key_id(self) -> builtins.str:
        return pulumi.get(self, "crypto_key_id")

    @property
    @pulumi.getter
    def etag(self) -> builtins.str:
        """
        (Computed) The etag of the IAM policy.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="policyData")
    def policy_data(self) -> builtins.str:
        """
        (Computed) The policy data
        """
        return pulumi.get(self, "policy_data")


class AwaitableGetCryptoKeyIamPolicyResult(GetCryptoKeyIamPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCryptoKeyIamPolicyResult(
            crypto_key_id=self.crypto_key_id,
            etag=self.etag,
            id=self.id,
            policy_data=self.policy_data)


def get_crypto_key_iam_policy(crypto_key_id: Optional[builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCryptoKeyIamPolicyResult:
    """
    Retrieves the current IAM policy data for a Google Cloud KMS crypto key.

    ## example

    ```python
    import pulumi
    import pulumi_gcp as gcp

    foo = gcp.kms.get_crypto_key_iam_policy(crypto_key_id=crypto_key["id"])
    ```


    :param builtins.str crypto_key_id: The crypto key ID, in the form
    """
    __args__ = dict()
    __args__['cryptoKeyId'] = crypto_key_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:kms/getCryptoKeyIamPolicy:getCryptoKeyIamPolicy', __args__, opts=opts, typ=GetCryptoKeyIamPolicyResult).value

    return AwaitableGetCryptoKeyIamPolicyResult(
        crypto_key_id=pulumi.get(__ret__, 'crypto_key_id'),
        etag=pulumi.get(__ret__, 'etag'),
        id=pulumi.get(__ret__, 'id'),
        policy_data=pulumi.get(__ret__, 'policy_data'))
def get_crypto_key_iam_policy_output(crypto_key_id: Optional[pulumi.Input[builtins.str]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCryptoKeyIamPolicyResult]:
    """
    Retrieves the current IAM policy data for a Google Cloud KMS crypto key.

    ## example

    ```python
    import pulumi
    import pulumi_gcp as gcp

    foo = gcp.kms.get_crypto_key_iam_policy(crypto_key_id=crypto_key["id"])
    ```


    :param builtins.str crypto_key_id: The crypto key ID, in the form
    """
    __args__ = dict()
    __args__['cryptoKeyId'] = crypto_key_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:kms/getCryptoKeyIamPolicy:getCryptoKeyIamPolicy', __args__, opts=opts, typ=GetCryptoKeyIamPolicyResult)
    return __ret__.apply(lambda __response__: GetCryptoKeyIamPolicyResult(
        crypto_key_id=pulumi.get(__response__, 'crypto_key_id'),
        etag=pulumi.get(__response__, 'etag'),
        id=pulumi.get(__response__, 'id'),
        policy_data=pulumi.get(__response__, 'policy_data')))
