# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['BillingAccountExclusionArgs', 'BillingAccountExclusion']

@pulumi.input_type
class BillingAccountExclusionArgs:
    def __init__(__self__, *,
                 billing_account: pulumi.Input[builtins.str],
                 filter: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a BillingAccountExclusion resource.
        :param pulumi.Input[builtins.str] billing_account: The billing account to create the exclusion for.
        :param pulumi.Input[builtins.str] filter: The filter to apply when excluding logs. Only log entries that match the filter are excluded.
               See [Advanced Log Filters](https://cloud.google.com/logging/docs/view/advanced-filters) for information on how to
               write a filter.
        :param pulumi.Input[builtins.str] description: A human-readable description.
        :param pulumi.Input[builtins.bool] disabled: Whether this exclusion rule should be disabled or not. This defaults to
               false.
        :param pulumi.Input[builtins.str] name: The name of the logging exclusion.
        """
        pulumi.set(__self__, "billing_account", billing_account)
        pulumi.set(__self__, "filter", filter)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="billingAccount")
    def billing_account(self) -> pulumi.Input[builtins.str]:
        """
        The billing account to create the exclusion for.
        """
        return pulumi.get(self, "billing_account")

    @billing_account.setter
    def billing_account(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "billing_account", value)

    @property
    @pulumi.getter
    def filter(self) -> pulumi.Input[builtins.str]:
        """
        The filter to apply when excluding logs. Only log entries that match the filter are excluded.
        See [Advanced Log Filters](https://cloud.google.com/logging/docs/view/advanced-filters) for information on how to
        write a filter.
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "filter", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A human-readable description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether this exclusion rule should be disabled or not. This defaults to
        false.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "disabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the logging exclusion.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _BillingAccountExclusionState:
    def __init__(__self__, *,
                 billing_account: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 filter: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering BillingAccountExclusion resources.
        :param pulumi.Input[builtins.str] billing_account: The billing account to create the exclusion for.
        :param pulumi.Input[builtins.str] description: A human-readable description.
        :param pulumi.Input[builtins.bool] disabled: Whether this exclusion rule should be disabled or not. This defaults to
               false.
        :param pulumi.Input[builtins.str] filter: The filter to apply when excluding logs. Only log entries that match the filter are excluded.
               See [Advanced Log Filters](https://cloud.google.com/logging/docs/view/advanced-filters) for information on how to
               write a filter.
        :param pulumi.Input[builtins.str] name: The name of the logging exclusion.
        """
        if billing_account is not None:
            pulumi.set(__self__, "billing_account", billing_account)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="billingAccount")
    def billing_account(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The billing account to create the exclusion for.
        """
        return pulumi.get(self, "billing_account")

    @billing_account.setter
    def billing_account(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "billing_account", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A human-readable description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether this exclusion rule should be disabled or not. This defaults to
        false.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "disabled", value)

    @property
    @pulumi.getter
    def filter(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The filter to apply when excluding logs. Only log entries that match the filter are excluded.
        See [Advanced Log Filters](https://cloud.google.com/logging/docs/view/advanced-filters) for information on how to
        write a filter.
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "filter", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the logging exclusion.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.type_token("gcp:logging/billingAccountExclusion:BillingAccountExclusion")
class BillingAccountExclusion(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 billing_account: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 filter: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_exclusion = gcp.logging.BillingAccountExclusion("my-exclusion",
            name="my-instance-debug-exclusion",
            billing_account="ABCDEF-012345-GHIJKL",
            description="Exclude GCE instance debug logs",
            filter="resource.type = gce_instance AND severity <= DEBUG")
        ```

        ## Import

        Billing account logging exclusions can be imported using their URI, e.g.

        * `billingAccounts/{{billing_account}}/exclusions/{{name}}`

        When using the `pulumi import` command, billing account logging exclusions can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:logging/billingAccountExclusion:BillingAccountExclusion default billingAccounts/{{billing_account}}/exclusions/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] billing_account: The billing account to create the exclusion for.
        :param pulumi.Input[builtins.str] description: A human-readable description.
        :param pulumi.Input[builtins.bool] disabled: Whether this exclusion rule should be disabled or not. This defaults to
               false.
        :param pulumi.Input[builtins.str] filter: The filter to apply when excluding logs. Only log entries that match the filter are excluded.
               See [Advanced Log Filters](https://cloud.google.com/logging/docs/view/advanced-filters) for information on how to
               write a filter.
        :param pulumi.Input[builtins.str] name: The name of the logging exclusion.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BillingAccountExclusionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_exclusion = gcp.logging.BillingAccountExclusion("my-exclusion",
            name="my-instance-debug-exclusion",
            billing_account="ABCDEF-012345-GHIJKL",
            description="Exclude GCE instance debug logs",
            filter="resource.type = gce_instance AND severity <= DEBUG")
        ```

        ## Import

        Billing account logging exclusions can be imported using their URI, e.g.

        * `billingAccounts/{{billing_account}}/exclusions/{{name}}`

        When using the `pulumi import` command, billing account logging exclusions can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:logging/billingAccountExclusion:BillingAccountExclusion default billingAccounts/{{billing_account}}/exclusions/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param BillingAccountExclusionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BillingAccountExclusionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 billing_account: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 filter: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BillingAccountExclusionArgs.__new__(BillingAccountExclusionArgs)

            if billing_account is None and not opts.urn:
                raise TypeError("Missing required property 'billing_account'")
            __props__.__dict__["billing_account"] = billing_account
            __props__.__dict__["description"] = description
            __props__.__dict__["disabled"] = disabled
            if filter is None and not opts.urn:
                raise TypeError("Missing required property 'filter'")
            __props__.__dict__["filter"] = filter
            __props__.__dict__["name"] = name
        super(BillingAccountExclusion, __self__).__init__(
            'gcp:logging/billingAccountExclusion:BillingAccountExclusion',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            billing_account: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            disabled: Optional[pulumi.Input[builtins.bool]] = None,
            filter: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None) -> 'BillingAccountExclusion':
        """
        Get an existing BillingAccountExclusion resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] billing_account: The billing account to create the exclusion for.
        :param pulumi.Input[builtins.str] description: A human-readable description.
        :param pulumi.Input[builtins.bool] disabled: Whether this exclusion rule should be disabled or not. This defaults to
               false.
        :param pulumi.Input[builtins.str] filter: The filter to apply when excluding logs. Only log entries that match the filter are excluded.
               See [Advanced Log Filters](https://cloud.google.com/logging/docs/view/advanced-filters) for information on how to
               write a filter.
        :param pulumi.Input[builtins.str] name: The name of the logging exclusion.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BillingAccountExclusionState.__new__(_BillingAccountExclusionState)

        __props__.__dict__["billing_account"] = billing_account
        __props__.__dict__["description"] = description
        __props__.__dict__["disabled"] = disabled
        __props__.__dict__["filter"] = filter
        __props__.__dict__["name"] = name
        return BillingAccountExclusion(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="billingAccount")
    def billing_account(self) -> pulumi.Output[builtins.str]:
        """
        The billing account to create the exclusion for.
        """
        return pulumi.get(self, "billing_account")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A human-readable description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def disabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether this exclusion rule should be disabled or not. This defaults to
        false.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter
    def filter(self) -> pulumi.Output[builtins.str]:
        """
        The filter to apply when excluding logs. Only log entries that match the filter are excluded.
        See [Advanced Log Filters](https://cloud.google.com/logging/docs/view/advanced-filters) for information on how to
        write a filter.
        """
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the logging exclusion.
        """
        return pulumi.get(self, "name")

