# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['OrganizationBucketConfigArgs', 'OrganizationBucketConfig']

@pulumi.input_type
class OrganizationBucketConfigArgs:
    def __init__(__self__, *,
                 bucket_id: pulumi.Input[builtins.str],
                 location: pulumi.Input[builtins.str],
                 organization: pulumi.Input[builtins.str],
                 cmek_settings: Optional[pulumi.Input['OrganizationBucketConfigCmekSettingsArgs']] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 index_configs: Optional[pulumi.Input[Sequence[pulumi.Input['OrganizationBucketConfigIndexConfigArgs']]]] = None,
                 retention_days: Optional[pulumi.Input[builtins.int]] = None):
        """
        The set of arguments for constructing a OrganizationBucketConfig resource.
        :param pulumi.Input[builtins.str] bucket_id: The name of the logging bucket. Logging automatically creates two log buckets: `_Required` and `_Default`.
        :param pulumi.Input[builtins.str] location: The location of the bucket. The supported locations are: "global" "us-central1"
        :param pulumi.Input[builtins.str] organization: The parent resource that contains the logging bucket.
        :param pulumi.Input['OrganizationBucketConfigCmekSettingsArgs'] cmek_settings: The CMEK settings of the log bucket. If present, new log entries written to this log bucket are encrypted using the CMEK
               key provided in this configuration. If a log bucket has CMEK settings, the CMEK settings cannot be disabled later by
               updating the log bucket. Changing the KMS key is allowed.
        :param pulumi.Input[builtins.str] description: Describes this bucket.
        :param pulumi.Input[Sequence[pulumi.Input['OrganizationBucketConfigIndexConfigArgs']]] index_configs: A list of indexed fields and related configuration data. Structure is documented below.
        :param pulumi.Input[builtins.int] retention_days: Logs will be retained by default for this amount of time, after which they will automatically be deleted. The minimum retention period is 1 day. If this value is set to zero at bucket creation time, the default time of 30 days will be used. Bucket retention can not be increased on buckets outside of projects.
        """
        pulumi.set(__self__, "bucket_id", bucket_id)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "organization", organization)
        if cmek_settings is not None:
            pulumi.set(__self__, "cmek_settings", cmek_settings)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if index_configs is not None:
            pulumi.set(__self__, "index_configs", index_configs)
        if retention_days is not None:
            pulumi.set(__self__, "retention_days", retention_days)

    @property
    @pulumi.getter(name="bucketId")
    def bucket_id(self) -> pulumi.Input[builtins.str]:
        """
        The name of the logging bucket. Logging automatically creates two log buckets: `_Required` and `_Default`.
        """
        return pulumi.get(self, "bucket_id")

    @bucket_id.setter
    def bucket_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "bucket_id", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        The location of the bucket. The supported locations are: "global" "us-central1"
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def organization(self) -> pulumi.Input[builtins.str]:
        """
        The parent resource that contains the logging bucket.
        """
        return pulumi.get(self, "organization")

    @organization.setter
    def organization(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "organization", value)

    @property
    @pulumi.getter(name="cmekSettings")
    def cmek_settings(self) -> Optional[pulumi.Input['OrganizationBucketConfigCmekSettingsArgs']]:
        """
        The CMEK settings of the log bucket. If present, new log entries written to this log bucket are encrypted using the CMEK
        key provided in this configuration. If a log bucket has CMEK settings, the CMEK settings cannot be disabled later by
        updating the log bucket. Changing the KMS key is allowed.
        """
        return pulumi.get(self, "cmek_settings")

    @cmek_settings.setter
    def cmek_settings(self, value: Optional[pulumi.Input['OrganizationBucketConfigCmekSettingsArgs']]):
        pulumi.set(self, "cmek_settings", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Describes this bucket.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="indexConfigs")
    def index_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OrganizationBucketConfigIndexConfigArgs']]]]:
        """
        A list of indexed fields and related configuration data. Structure is documented below.
        """
        return pulumi.get(self, "index_configs")

    @index_configs.setter
    def index_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OrganizationBucketConfigIndexConfigArgs']]]]):
        pulumi.set(self, "index_configs", value)

    @property
    @pulumi.getter(name="retentionDays")
    def retention_days(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Logs will be retained by default for this amount of time, after which they will automatically be deleted. The minimum retention period is 1 day. If this value is set to zero at bucket creation time, the default time of 30 days will be used. Bucket retention can not be increased on buckets outside of projects.
        """
        return pulumi.get(self, "retention_days")

    @retention_days.setter
    def retention_days(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "retention_days", value)


@pulumi.input_type
class _OrganizationBucketConfigState:
    def __init__(__self__, *,
                 bucket_id: Optional[pulumi.Input[builtins.str]] = None,
                 cmek_settings: Optional[pulumi.Input['OrganizationBucketConfigCmekSettingsArgs']] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 index_configs: Optional[pulumi.Input[Sequence[pulumi.Input['OrganizationBucketConfigIndexConfigArgs']]]] = None,
                 lifecycle_state: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 organization: Optional[pulumi.Input[builtins.str]] = None,
                 retention_days: Optional[pulumi.Input[builtins.int]] = None):
        """
        Input properties used for looking up and filtering OrganizationBucketConfig resources.
        :param pulumi.Input[builtins.str] bucket_id: The name of the logging bucket. Logging automatically creates two log buckets: `_Required` and `_Default`.
        :param pulumi.Input['OrganizationBucketConfigCmekSettingsArgs'] cmek_settings: The CMEK settings of the log bucket. If present, new log entries written to this log bucket are encrypted using the CMEK
               key provided in this configuration. If a log bucket has CMEK settings, the CMEK settings cannot be disabled later by
               updating the log bucket. Changing the KMS key is allowed.
        :param pulumi.Input[builtins.str] description: Describes this bucket.
        :param pulumi.Input[Sequence[pulumi.Input['OrganizationBucketConfigIndexConfigArgs']]] index_configs: A list of indexed fields and related configuration data. Structure is documented below.
        :param pulumi.Input[builtins.str] lifecycle_state: The bucket's lifecycle such as active or deleted. See [LifecycleState](https://cloud.google.com/logging/docs/reference/v2/rest/v2/billingAccounts.buckets#LogBucket.LifecycleState).
        :param pulumi.Input[builtins.str] location: The location of the bucket. The supported locations are: "global" "us-central1"
        :param pulumi.Input[builtins.str] name: The resource name of the bucket. For example: "organizations/my-organization-id/locations/my-location/buckets/my-bucket-id"
        :param pulumi.Input[builtins.str] organization: The parent resource that contains the logging bucket.
        :param pulumi.Input[builtins.int] retention_days: Logs will be retained by default for this amount of time, after which they will automatically be deleted. The minimum retention period is 1 day. If this value is set to zero at bucket creation time, the default time of 30 days will be used. Bucket retention can not be increased on buckets outside of projects.
        """
        if bucket_id is not None:
            pulumi.set(__self__, "bucket_id", bucket_id)
        if cmek_settings is not None:
            pulumi.set(__self__, "cmek_settings", cmek_settings)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if index_configs is not None:
            pulumi.set(__self__, "index_configs", index_configs)
        if lifecycle_state is not None:
            pulumi.set(__self__, "lifecycle_state", lifecycle_state)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if organization is not None:
            pulumi.set(__self__, "organization", organization)
        if retention_days is not None:
            pulumi.set(__self__, "retention_days", retention_days)

    @property
    @pulumi.getter(name="bucketId")
    def bucket_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the logging bucket. Logging automatically creates two log buckets: `_Required` and `_Default`.
        """
        return pulumi.get(self, "bucket_id")

    @bucket_id.setter
    def bucket_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "bucket_id", value)

    @property
    @pulumi.getter(name="cmekSettings")
    def cmek_settings(self) -> Optional[pulumi.Input['OrganizationBucketConfigCmekSettingsArgs']]:
        """
        The CMEK settings of the log bucket. If present, new log entries written to this log bucket are encrypted using the CMEK
        key provided in this configuration. If a log bucket has CMEK settings, the CMEK settings cannot be disabled later by
        updating the log bucket. Changing the KMS key is allowed.
        """
        return pulumi.get(self, "cmek_settings")

    @cmek_settings.setter
    def cmek_settings(self, value: Optional[pulumi.Input['OrganizationBucketConfigCmekSettingsArgs']]):
        pulumi.set(self, "cmek_settings", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Describes this bucket.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="indexConfigs")
    def index_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OrganizationBucketConfigIndexConfigArgs']]]]:
        """
        A list of indexed fields and related configuration data. Structure is documented below.
        """
        return pulumi.get(self, "index_configs")

    @index_configs.setter
    def index_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OrganizationBucketConfigIndexConfigArgs']]]]):
        pulumi.set(self, "index_configs", value)

    @property
    @pulumi.getter(name="lifecycleState")
    def lifecycle_state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The bucket's lifecycle such as active or deleted. See [LifecycleState](https://cloud.google.com/logging/docs/reference/v2/rest/v2/billingAccounts.buckets#LogBucket.LifecycleState).
        """
        return pulumi.get(self, "lifecycle_state")

    @lifecycle_state.setter
    def lifecycle_state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lifecycle_state", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location of the bucket. The supported locations are: "global" "us-central1"
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource name of the bucket. For example: "organizations/my-organization-id/locations/my-location/buckets/my-bucket-id"
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def organization(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The parent resource that contains the logging bucket.
        """
        return pulumi.get(self, "organization")

    @organization.setter
    def organization(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "organization", value)

    @property
    @pulumi.getter(name="retentionDays")
    def retention_days(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Logs will be retained by default for this amount of time, after which they will automatically be deleted. The minimum retention period is 1 day. If this value is set to zero at bucket creation time, the default time of 30 days will be used. Bucket retention can not be increased on buckets outside of projects.
        """
        return pulumi.get(self, "retention_days")

    @retention_days.setter
    def retention_days(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "retention_days", value)


@pulumi.type_token("gcp:logging/organizationBucketConfig:OrganizationBucketConfig")
class OrganizationBucketConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bucket_id: Optional[pulumi.Input[builtins.str]] = None,
                 cmek_settings: Optional[pulumi.Input[Union['OrganizationBucketConfigCmekSettingsArgs', 'OrganizationBucketConfigCmekSettingsArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 index_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OrganizationBucketConfigIndexConfigArgs', 'OrganizationBucketConfigIndexConfigArgsDict']]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 organization: Optional[pulumi.Input[builtins.str]] = None,
                 retention_days: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        """
        Manages a organization-level logging bucket config. For more information see
        [the official logging documentation](https://cloud.google.com/logging/docs/) and
        [Storing Logs](https://cloud.google.com/logging/docs/storage).

        > **Note:** Logging buckets are automatically created for a given folder, project, organization, billingAccount and cannot be deleted. Creating a resource of this type will acquire and update the resource that already exists at the desired location. These buckets cannot be removed so deleting this resource will remove the bucket config from your state but will leave the logging bucket unchanged. The buckets that are currently automatically created are "_Default" and "_Required".

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.organizations.get_organization(organization="123456789")
        basic = gcp.logging.OrganizationBucketConfig("basic",
            organization=default.organization,
            location="global",
            retention_days=30,
            bucket_id="_Default",
            index_configs=[{
                "field_path": "jsonPayload.request.status",
                "type": "INDEX_TYPE_STRING",
            }])
        ```

        ## Import

        This resource can be imported using the following format:

        * `organizations/{{organization}}/locations/{{location}}/buckets/{{bucket_id}}`

        When using the `pulumi import` command, this resource can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:logging/organizationBucketConfig:OrganizationBucketConfig default organizations/{{organization}}/locations/{{location}}/buckets/{{bucket_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] bucket_id: The name of the logging bucket. Logging automatically creates two log buckets: `_Required` and `_Default`.
        :param pulumi.Input[Union['OrganizationBucketConfigCmekSettingsArgs', 'OrganizationBucketConfigCmekSettingsArgsDict']] cmek_settings: The CMEK settings of the log bucket. If present, new log entries written to this log bucket are encrypted using the CMEK
               key provided in this configuration. If a log bucket has CMEK settings, the CMEK settings cannot be disabled later by
               updating the log bucket. Changing the KMS key is allowed.
        :param pulumi.Input[builtins.str] description: Describes this bucket.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OrganizationBucketConfigIndexConfigArgs', 'OrganizationBucketConfigIndexConfigArgsDict']]]] index_configs: A list of indexed fields and related configuration data. Structure is documented below.
        :param pulumi.Input[builtins.str] location: The location of the bucket. The supported locations are: "global" "us-central1"
        :param pulumi.Input[builtins.str] organization: The parent resource that contains the logging bucket.
        :param pulumi.Input[builtins.int] retention_days: Logs will be retained by default for this amount of time, after which they will automatically be deleted. The minimum retention period is 1 day. If this value is set to zero at bucket creation time, the default time of 30 days will be used. Bucket retention can not be increased on buckets outside of projects.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OrganizationBucketConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a organization-level logging bucket config. For more information see
        [the official logging documentation](https://cloud.google.com/logging/docs/) and
        [Storing Logs](https://cloud.google.com/logging/docs/storage).

        > **Note:** Logging buckets are automatically created for a given folder, project, organization, billingAccount and cannot be deleted. Creating a resource of this type will acquire and update the resource that already exists at the desired location. These buckets cannot be removed so deleting this resource will remove the bucket config from your state but will leave the logging bucket unchanged. The buckets that are currently automatically created are "_Default" and "_Required".

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.organizations.get_organization(organization="123456789")
        basic = gcp.logging.OrganizationBucketConfig("basic",
            organization=default.organization,
            location="global",
            retention_days=30,
            bucket_id="_Default",
            index_configs=[{
                "field_path": "jsonPayload.request.status",
                "type": "INDEX_TYPE_STRING",
            }])
        ```

        ## Import

        This resource can be imported using the following format:

        * `organizations/{{organization}}/locations/{{location}}/buckets/{{bucket_id}}`

        When using the `pulumi import` command, this resource can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:logging/organizationBucketConfig:OrganizationBucketConfig default organizations/{{organization}}/locations/{{location}}/buckets/{{bucket_id}}
        ```

        :param str resource_name: The name of the resource.
        :param OrganizationBucketConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OrganizationBucketConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bucket_id: Optional[pulumi.Input[builtins.str]] = None,
                 cmek_settings: Optional[pulumi.Input[Union['OrganizationBucketConfigCmekSettingsArgs', 'OrganizationBucketConfigCmekSettingsArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 index_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OrganizationBucketConfigIndexConfigArgs', 'OrganizationBucketConfigIndexConfigArgsDict']]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 organization: Optional[pulumi.Input[builtins.str]] = None,
                 retention_days: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OrganizationBucketConfigArgs.__new__(OrganizationBucketConfigArgs)

            if bucket_id is None and not opts.urn:
                raise TypeError("Missing required property 'bucket_id'")
            __props__.__dict__["bucket_id"] = bucket_id
            __props__.__dict__["cmek_settings"] = cmek_settings
            __props__.__dict__["description"] = description
            __props__.__dict__["index_configs"] = index_configs
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            if organization is None and not opts.urn:
                raise TypeError("Missing required property 'organization'")
            __props__.__dict__["organization"] = organization
            __props__.__dict__["retention_days"] = retention_days
            __props__.__dict__["lifecycle_state"] = None
            __props__.__dict__["name"] = None
        super(OrganizationBucketConfig, __self__).__init__(
            'gcp:logging/organizationBucketConfig:OrganizationBucketConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bucket_id: Optional[pulumi.Input[builtins.str]] = None,
            cmek_settings: Optional[pulumi.Input[Union['OrganizationBucketConfigCmekSettingsArgs', 'OrganizationBucketConfigCmekSettingsArgsDict']]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            index_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OrganizationBucketConfigIndexConfigArgs', 'OrganizationBucketConfigIndexConfigArgsDict']]]]] = None,
            lifecycle_state: Optional[pulumi.Input[builtins.str]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            organization: Optional[pulumi.Input[builtins.str]] = None,
            retention_days: Optional[pulumi.Input[builtins.int]] = None) -> 'OrganizationBucketConfig':
        """
        Get an existing OrganizationBucketConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] bucket_id: The name of the logging bucket. Logging automatically creates two log buckets: `_Required` and `_Default`.
        :param pulumi.Input[Union['OrganizationBucketConfigCmekSettingsArgs', 'OrganizationBucketConfigCmekSettingsArgsDict']] cmek_settings: The CMEK settings of the log bucket. If present, new log entries written to this log bucket are encrypted using the CMEK
               key provided in this configuration. If a log bucket has CMEK settings, the CMEK settings cannot be disabled later by
               updating the log bucket. Changing the KMS key is allowed.
        :param pulumi.Input[builtins.str] description: Describes this bucket.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OrganizationBucketConfigIndexConfigArgs', 'OrganizationBucketConfigIndexConfigArgsDict']]]] index_configs: A list of indexed fields and related configuration data. Structure is documented below.
        :param pulumi.Input[builtins.str] lifecycle_state: The bucket's lifecycle such as active or deleted. See [LifecycleState](https://cloud.google.com/logging/docs/reference/v2/rest/v2/billingAccounts.buckets#LogBucket.LifecycleState).
        :param pulumi.Input[builtins.str] location: The location of the bucket. The supported locations are: "global" "us-central1"
        :param pulumi.Input[builtins.str] name: The resource name of the bucket. For example: "organizations/my-organization-id/locations/my-location/buckets/my-bucket-id"
        :param pulumi.Input[builtins.str] organization: The parent resource that contains the logging bucket.
        :param pulumi.Input[builtins.int] retention_days: Logs will be retained by default for this amount of time, after which they will automatically be deleted. The minimum retention period is 1 day. If this value is set to zero at bucket creation time, the default time of 30 days will be used. Bucket retention can not be increased on buckets outside of projects.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OrganizationBucketConfigState.__new__(_OrganizationBucketConfigState)

        __props__.__dict__["bucket_id"] = bucket_id
        __props__.__dict__["cmek_settings"] = cmek_settings
        __props__.__dict__["description"] = description
        __props__.__dict__["index_configs"] = index_configs
        __props__.__dict__["lifecycle_state"] = lifecycle_state
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["organization"] = organization
        __props__.__dict__["retention_days"] = retention_days
        return OrganizationBucketConfig(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="bucketId")
    def bucket_id(self) -> pulumi.Output[builtins.str]:
        """
        The name of the logging bucket. Logging automatically creates two log buckets: `_Required` and `_Default`.
        """
        return pulumi.get(self, "bucket_id")

    @property
    @pulumi.getter(name="cmekSettings")
    def cmek_settings(self) -> pulumi.Output[Optional['outputs.OrganizationBucketConfigCmekSettings']]:
        """
        The CMEK settings of the log bucket. If present, new log entries written to this log bucket are encrypted using the CMEK
        key provided in this configuration. If a log bucket has CMEK settings, the CMEK settings cannot be disabled later by
        updating the log bucket. Changing the KMS key is allowed.
        """
        return pulumi.get(self, "cmek_settings")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        Describes this bucket.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="indexConfigs")
    def index_configs(self) -> pulumi.Output[Sequence['outputs.OrganizationBucketConfigIndexConfig']]:
        """
        A list of indexed fields and related configuration data. Structure is documented below.
        """
        return pulumi.get(self, "index_configs")

    @property
    @pulumi.getter(name="lifecycleState")
    def lifecycle_state(self) -> pulumi.Output[builtins.str]:
        """
        The bucket's lifecycle such as active or deleted. See [LifecycleState](https://cloud.google.com/logging/docs/reference/v2/rest/v2/billingAccounts.buckets#LogBucket.LifecycleState).
        """
        return pulumi.get(self, "lifecycle_state")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The location of the bucket. The supported locations are: "global" "us-central1"
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The resource name of the bucket. For example: "organizations/my-organization-id/locations/my-location/buckets/my-bucket-id"
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def organization(self) -> pulumi.Output[builtins.str]:
        """
        The parent resource that contains the logging bucket.
        """
        return pulumi.get(self, "organization")

    @property
    @pulumi.getter(name="retentionDays")
    def retention_days(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Logs will be retained by default for this amount of time, after which they will automatically be deleted. The minimum retention period is 1 day. If this value is set to zero at bucket creation time, the default time of 30 days will be used. Bucket retention can not be increased on buckets outside of projects.
        """
        return pulumi.get(self, "retention_days")

