# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ProjectSinkArgs', 'ProjectSink']

@pulumi.input_type
class ProjectSinkArgs:
    def __init__(__self__, *,
                 destination: pulumi.Input[builtins.str],
                 bigquery_options: Optional[pulumi.Input['ProjectSinkBigqueryOptionsArgs']] = None,
                 custom_writer_identity: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 exclusions: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectSinkExclusionArgs']]]] = None,
                 filter: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 unique_writer_identity: Optional[pulumi.Input[builtins.bool]] = None):
        """
        The set of arguments for constructing a ProjectSink resource.
        :param pulumi.Input[builtins.str] destination: The destination of the sink (or, in other words, where logs are written to). Can be a Cloud Storage bucket, a PubSub topic, a BigQuery dataset, a Cloud Logging bucket, or a Google Cloud project. Examples:
               
               - `storage.googleapis.com/[GCS_BUCKET]`
               - `bigquery.googleapis.com/projects/[PROJECT_ID]/datasets/[DATASET]`
               - `pubsub.googleapis.com/projects/[PROJECT_ID]/topics/[TOPIC_ID]`
               - `logging.googleapis.com/projects/[PROJECT_ID]/locations/global/buckets/[BUCKET_ID]`
               - `logging.googleapis.com/projects/[PROJECT_ID]`
               
               The writer associated with the sink must have access to write to the above resource.
        :param pulumi.Input['ProjectSinkBigqueryOptionsArgs'] bigquery_options: Options that affect sinks exporting data to BigQuery. Structure documented below.
        :param pulumi.Input[builtins.str] custom_writer_identity: A user managed service account that will be used to write
               the log entries. The format must be `serviceAccount:some@email`. This field can only be specified if you are
               routing logs to a destination outside this sink's project. If not specified, a Logging service account
               will automatically be generated.
        :param pulumi.Input[builtins.str] description: A description of this sink. The maximum length of the description is 8000 characters.
        :param pulumi.Input[builtins.bool] disabled: If set to True, then this sink is disabled and it does not export any log entries.
        :param pulumi.Input[Sequence[pulumi.Input['ProjectSinkExclusionArgs']]] exclusions: Log entries that match any of the exclusion filters will not be exported. If a log entry is matched by both `filter` and one of `exclusions.filter`, it will not be exported.  Can be repeated multiple times for multiple exclusions. Structure is documented below.
        :param pulumi.Input[builtins.str] filter: The filter to apply when exporting logs. Only log entries that match the filter are exported.
               See [Advanced Log Filters](https://cloud.google.com/logging/docs/view/advanced_filters) for information on how to
               write a filter.
        :param pulumi.Input[builtins.str] name: The name of the logging sink. Logging automatically creates two sinks: `_Required` and `_Default`.
        :param pulumi.Input[builtins.str] project: The ID of the project to create the sink in. If omitted, the project associated with the provider is
               used.
        :param pulumi.Input[builtins.bool] unique_writer_identity: Whether or not to create a unique identity associated with this sink. If `false`, then the `writer_identity` used is `serviceAccount:cloud-logs@system.gserviceaccount.com`. If `true` (the default),
               then a unique service account is created and used for this sink. If you wish to publish logs across projects or utilize
               `bigquery_options`, you must set `unique_writer_identity` to true.
        """
        pulumi.set(__self__, "destination", destination)
        if bigquery_options is not None:
            pulumi.set(__self__, "bigquery_options", bigquery_options)
        if custom_writer_identity is not None:
            pulumi.set(__self__, "custom_writer_identity", custom_writer_identity)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if exclusions is not None:
            pulumi.set(__self__, "exclusions", exclusions)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if unique_writer_identity is not None:
            pulumi.set(__self__, "unique_writer_identity", unique_writer_identity)

    @property
    @pulumi.getter
    def destination(self) -> pulumi.Input[builtins.str]:
        """
        The destination of the sink (or, in other words, where logs are written to). Can be a Cloud Storage bucket, a PubSub topic, a BigQuery dataset, a Cloud Logging bucket, or a Google Cloud project. Examples:

        - `storage.googleapis.com/[GCS_BUCKET]`
        - `bigquery.googleapis.com/projects/[PROJECT_ID]/datasets/[DATASET]`
        - `pubsub.googleapis.com/projects/[PROJECT_ID]/topics/[TOPIC_ID]`
        - `logging.googleapis.com/projects/[PROJECT_ID]/locations/global/buckets/[BUCKET_ID]`
        - `logging.googleapis.com/projects/[PROJECT_ID]`

        The writer associated with the sink must have access to write to the above resource.
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "destination", value)

    @property
    @pulumi.getter(name="bigqueryOptions")
    def bigquery_options(self) -> Optional[pulumi.Input['ProjectSinkBigqueryOptionsArgs']]:
        """
        Options that affect sinks exporting data to BigQuery. Structure documented below.
        """
        return pulumi.get(self, "bigquery_options")

    @bigquery_options.setter
    def bigquery_options(self, value: Optional[pulumi.Input['ProjectSinkBigqueryOptionsArgs']]):
        pulumi.set(self, "bigquery_options", value)

    @property
    @pulumi.getter(name="customWriterIdentity")
    def custom_writer_identity(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A user managed service account that will be used to write
        the log entries. The format must be `serviceAccount:some@email`. This field can only be specified if you are
        routing logs to a destination outside this sink's project. If not specified, a Logging service account
        will automatically be generated.
        """
        return pulumi.get(self, "custom_writer_identity")

    @custom_writer_identity.setter
    def custom_writer_identity(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "custom_writer_identity", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A description of this sink. The maximum length of the description is 8000 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If set to True, then this sink is disabled and it does not export any log entries.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "disabled", value)

    @property
    @pulumi.getter
    def exclusions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProjectSinkExclusionArgs']]]]:
        """
        Log entries that match any of the exclusion filters will not be exported. If a log entry is matched by both `filter` and one of `exclusions.filter`, it will not be exported.  Can be repeated multiple times for multiple exclusions. Structure is documented below.
        """
        return pulumi.get(self, "exclusions")

    @exclusions.setter
    def exclusions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectSinkExclusionArgs']]]]):
        pulumi.set(self, "exclusions", value)

    @property
    @pulumi.getter
    def filter(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The filter to apply when exporting logs. Only log entries that match the filter are exported.
        See [Advanced Log Filters](https://cloud.google.com/logging/docs/view/advanced_filters) for information on how to
        write a filter.
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "filter", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the logging sink. Logging automatically creates two sinks: `_Required` and `_Default`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project to create the sink in. If omitted, the project associated with the provider is
        used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="uniqueWriterIdentity")
    def unique_writer_identity(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether or not to create a unique identity associated with this sink. If `false`, then the `writer_identity` used is `serviceAccount:cloud-logs@system.gserviceaccount.com`. If `true` (the default),
        then a unique service account is created and used for this sink. If you wish to publish logs across projects or utilize
        `bigquery_options`, you must set `unique_writer_identity` to true.
        """
        return pulumi.get(self, "unique_writer_identity")

    @unique_writer_identity.setter
    def unique_writer_identity(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "unique_writer_identity", value)


@pulumi.input_type
class _ProjectSinkState:
    def __init__(__self__, *,
                 bigquery_options: Optional[pulumi.Input['ProjectSinkBigqueryOptionsArgs']] = None,
                 custom_writer_identity: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 destination: Optional[pulumi.Input[builtins.str]] = None,
                 disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 exclusions: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectSinkExclusionArgs']]]] = None,
                 filter: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 unique_writer_identity: Optional[pulumi.Input[builtins.bool]] = None,
                 writer_identity: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ProjectSink resources.
        :param pulumi.Input['ProjectSinkBigqueryOptionsArgs'] bigquery_options: Options that affect sinks exporting data to BigQuery. Structure documented below.
        :param pulumi.Input[builtins.str] custom_writer_identity: A user managed service account that will be used to write
               the log entries. The format must be `serviceAccount:some@email`. This field can only be specified if you are
               routing logs to a destination outside this sink's project. If not specified, a Logging service account
               will automatically be generated.
        :param pulumi.Input[builtins.str] description: A description of this sink. The maximum length of the description is 8000 characters.
        :param pulumi.Input[builtins.str] destination: The destination of the sink (or, in other words, where logs are written to). Can be a Cloud Storage bucket, a PubSub topic, a BigQuery dataset, a Cloud Logging bucket, or a Google Cloud project. Examples:
               
               - `storage.googleapis.com/[GCS_BUCKET]`
               - `bigquery.googleapis.com/projects/[PROJECT_ID]/datasets/[DATASET]`
               - `pubsub.googleapis.com/projects/[PROJECT_ID]/topics/[TOPIC_ID]`
               - `logging.googleapis.com/projects/[PROJECT_ID]/locations/global/buckets/[BUCKET_ID]`
               - `logging.googleapis.com/projects/[PROJECT_ID]`
               
               The writer associated with the sink must have access to write to the above resource.
        :param pulumi.Input[builtins.bool] disabled: If set to True, then this sink is disabled and it does not export any log entries.
        :param pulumi.Input[Sequence[pulumi.Input['ProjectSinkExclusionArgs']]] exclusions: Log entries that match any of the exclusion filters will not be exported. If a log entry is matched by both `filter` and one of `exclusions.filter`, it will not be exported.  Can be repeated multiple times for multiple exclusions. Structure is documented below.
        :param pulumi.Input[builtins.str] filter: The filter to apply when exporting logs. Only log entries that match the filter are exported.
               See [Advanced Log Filters](https://cloud.google.com/logging/docs/view/advanced_filters) for information on how to
               write a filter.
        :param pulumi.Input[builtins.str] name: The name of the logging sink. Logging automatically creates two sinks: `_Required` and `_Default`.
        :param pulumi.Input[builtins.str] project: The ID of the project to create the sink in. If omitted, the project associated with the provider is
               used.
        :param pulumi.Input[builtins.bool] unique_writer_identity: Whether or not to create a unique identity associated with this sink. If `false`, then the `writer_identity` used is `serviceAccount:cloud-logs@system.gserviceaccount.com`. If `true` (the default),
               then a unique service account is created and used for this sink. If you wish to publish logs across projects or utilize
               `bigquery_options`, you must set `unique_writer_identity` to true.
        :param pulumi.Input[builtins.str] writer_identity: The identity associated with this sink. This identity must be granted write access to the
               configured `destination`.
        """
        if bigquery_options is not None:
            pulumi.set(__self__, "bigquery_options", bigquery_options)
        if custom_writer_identity is not None:
            pulumi.set(__self__, "custom_writer_identity", custom_writer_identity)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if exclusions is not None:
            pulumi.set(__self__, "exclusions", exclusions)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if unique_writer_identity is not None:
            pulumi.set(__self__, "unique_writer_identity", unique_writer_identity)
        if writer_identity is not None:
            pulumi.set(__self__, "writer_identity", writer_identity)

    @property
    @pulumi.getter(name="bigqueryOptions")
    def bigquery_options(self) -> Optional[pulumi.Input['ProjectSinkBigqueryOptionsArgs']]:
        """
        Options that affect sinks exporting data to BigQuery. Structure documented below.
        """
        return pulumi.get(self, "bigquery_options")

    @bigquery_options.setter
    def bigquery_options(self, value: Optional[pulumi.Input['ProjectSinkBigqueryOptionsArgs']]):
        pulumi.set(self, "bigquery_options", value)

    @property
    @pulumi.getter(name="customWriterIdentity")
    def custom_writer_identity(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A user managed service account that will be used to write
        the log entries. The format must be `serviceAccount:some@email`. This field can only be specified if you are
        routing logs to a destination outside this sink's project. If not specified, a Logging service account
        will automatically be generated.
        """
        return pulumi.get(self, "custom_writer_identity")

    @custom_writer_identity.setter
    def custom_writer_identity(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "custom_writer_identity", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A description of this sink. The maximum length of the description is 8000 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def destination(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The destination of the sink (or, in other words, where logs are written to). Can be a Cloud Storage bucket, a PubSub topic, a BigQuery dataset, a Cloud Logging bucket, or a Google Cloud project. Examples:

        - `storage.googleapis.com/[GCS_BUCKET]`
        - `bigquery.googleapis.com/projects/[PROJECT_ID]/datasets/[DATASET]`
        - `pubsub.googleapis.com/projects/[PROJECT_ID]/topics/[TOPIC_ID]`
        - `logging.googleapis.com/projects/[PROJECT_ID]/locations/global/buckets/[BUCKET_ID]`
        - `logging.googleapis.com/projects/[PROJECT_ID]`

        The writer associated with the sink must have access to write to the above resource.
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "destination", value)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If set to True, then this sink is disabled and it does not export any log entries.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "disabled", value)

    @property
    @pulumi.getter
    def exclusions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProjectSinkExclusionArgs']]]]:
        """
        Log entries that match any of the exclusion filters will not be exported. If a log entry is matched by both `filter` and one of `exclusions.filter`, it will not be exported.  Can be repeated multiple times for multiple exclusions. Structure is documented below.
        """
        return pulumi.get(self, "exclusions")

    @exclusions.setter
    def exclusions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectSinkExclusionArgs']]]]):
        pulumi.set(self, "exclusions", value)

    @property
    @pulumi.getter
    def filter(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The filter to apply when exporting logs. Only log entries that match the filter are exported.
        See [Advanced Log Filters](https://cloud.google.com/logging/docs/view/advanced_filters) for information on how to
        write a filter.
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "filter", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the logging sink. Logging automatically creates two sinks: `_Required` and `_Default`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project to create the sink in. If omitted, the project associated with the provider is
        used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="uniqueWriterIdentity")
    def unique_writer_identity(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether or not to create a unique identity associated with this sink. If `false`, then the `writer_identity` used is `serviceAccount:cloud-logs@system.gserviceaccount.com`. If `true` (the default),
        then a unique service account is created and used for this sink. If you wish to publish logs across projects or utilize
        `bigquery_options`, you must set `unique_writer_identity` to true.
        """
        return pulumi.get(self, "unique_writer_identity")

    @unique_writer_identity.setter
    def unique_writer_identity(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "unique_writer_identity", value)

    @property
    @pulumi.getter(name="writerIdentity")
    def writer_identity(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The identity associated with this sink. This identity must be granted write access to the
        configured `destination`.
        """
        return pulumi.get(self, "writer_identity")

    @writer_identity.setter
    def writer_identity(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "writer_identity", value)


@pulumi.type_token("gcp:logging/projectSink:ProjectSink")
class ProjectSink(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bigquery_options: Optional[pulumi.Input[Union['ProjectSinkBigqueryOptionsArgs', 'ProjectSinkBigqueryOptionsArgsDict']]] = None,
                 custom_writer_identity: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 destination: Optional[pulumi.Input[builtins.str]] = None,
                 disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 exclusions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectSinkExclusionArgs', 'ProjectSinkExclusionArgsDict']]]]] = None,
                 filter: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 unique_writer_identity: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        """
        ## Import

        Project-level logging sinks can be imported using their URI, e.g.

        * `projects/{{project_id}}/sinks/{{name}}`

        When using the `pulumi import` command, project-level logging sinks can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:logging/projectSink:ProjectSink default projects/{{project_id}}/sinks/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ProjectSinkBigqueryOptionsArgs', 'ProjectSinkBigqueryOptionsArgsDict']] bigquery_options: Options that affect sinks exporting data to BigQuery. Structure documented below.
        :param pulumi.Input[builtins.str] custom_writer_identity: A user managed service account that will be used to write
               the log entries. The format must be `serviceAccount:some@email`. This field can only be specified if you are
               routing logs to a destination outside this sink's project. If not specified, a Logging service account
               will automatically be generated.
        :param pulumi.Input[builtins.str] description: A description of this sink. The maximum length of the description is 8000 characters.
        :param pulumi.Input[builtins.str] destination: The destination of the sink (or, in other words, where logs are written to). Can be a Cloud Storage bucket, a PubSub topic, a BigQuery dataset, a Cloud Logging bucket, or a Google Cloud project. Examples:
               
               - `storage.googleapis.com/[GCS_BUCKET]`
               - `bigquery.googleapis.com/projects/[PROJECT_ID]/datasets/[DATASET]`
               - `pubsub.googleapis.com/projects/[PROJECT_ID]/topics/[TOPIC_ID]`
               - `logging.googleapis.com/projects/[PROJECT_ID]/locations/global/buckets/[BUCKET_ID]`
               - `logging.googleapis.com/projects/[PROJECT_ID]`
               
               The writer associated with the sink must have access to write to the above resource.
        :param pulumi.Input[builtins.bool] disabled: If set to True, then this sink is disabled and it does not export any log entries.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ProjectSinkExclusionArgs', 'ProjectSinkExclusionArgsDict']]]] exclusions: Log entries that match any of the exclusion filters will not be exported. If a log entry is matched by both `filter` and one of `exclusions.filter`, it will not be exported.  Can be repeated multiple times for multiple exclusions. Structure is documented below.
        :param pulumi.Input[builtins.str] filter: The filter to apply when exporting logs. Only log entries that match the filter are exported.
               See [Advanced Log Filters](https://cloud.google.com/logging/docs/view/advanced_filters) for information on how to
               write a filter.
        :param pulumi.Input[builtins.str] name: The name of the logging sink. Logging automatically creates two sinks: `_Required` and `_Default`.
        :param pulumi.Input[builtins.str] project: The ID of the project to create the sink in. If omitted, the project associated with the provider is
               used.
        :param pulumi.Input[builtins.bool] unique_writer_identity: Whether or not to create a unique identity associated with this sink. If `false`, then the `writer_identity` used is `serviceAccount:cloud-logs@system.gserviceaccount.com`. If `true` (the default),
               then a unique service account is created and used for this sink. If you wish to publish logs across projects or utilize
               `bigquery_options`, you must set `unique_writer_identity` to true.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProjectSinkArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        Project-level logging sinks can be imported using their URI, e.g.

        * `projects/{{project_id}}/sinks/{{name}}`

        When using the `pulumi import` command, project-level logging sinks can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:logging/projectSink:ProjectSink default projects/{{project_id}}/sinks/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param ProjectSinkArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProjectSinkArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bigquery_options: Optional[pulumi.Input[Union['ProjectSinkBigqueryOptionsArgs', 'ProjectSinkBigqueryOptionsArgsDict']]] = None,
                 custom_writer_identity: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 destination: Optional[pulumi.Input[builtins.str]] = None,
                 disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 exclusions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectSinkExclusionArgs', 'ProjectSinkExclusionArgsDict']]]]] = None,
                 filter: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 unique_writer_identity: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProjectSinkArgs.__new__(ProjectSinkArgs)

            __props__.__dict__["bigquery_options"] = bigquery_options
            __props__.__dict__["custom_writer_identity"] = custom_writer_identity
            __props__.__dict__["description"] = description
            if destination is None and not opts.urn:
                raise TypeError("Missing required property 'destination'")
            __props__.__dict__["destination"] = destination
            __props__.__dict__["disabled"] = disabled
            __props__.__dict__["exclusions"] = exclusions
            __props__.__dict__["filter"] = filter
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["unique_writer_identity"] = unique_writer_identity
            __props__.__dict__["writer_identity"] = None
        super(ProjectSink, __self__).__init__(
            'gcp:logging/projectSink:ProjectSink',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bigquery_options: Optional[pulumi.Input[Union['ProjectSinkBigqueryOptionsArgs', 'ProjectSinkBigqueryOptionsArgsDict']]] = None,
            custom_writer_identity: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            destination: Optional[pulumi.Input[builtins.str]] = None,
            disabled: Optional[pulumi.Input[builtins.bool]] = None,
            exclusions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectSinkExclusionArgs', 'ProjectSinkExclusionArgsDict']]]]] = None,
            filter: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            unique_writer_identity: Optional[pulumi.Input[builtins.bool]] = None,
            writer_identity: Optional[pulumi.Input[builtins.str]] = None) -> 'ProjectSink':
        """
        Get an existing ProjectSink resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ProjectSinkBigqueryOptionsArgs', 'ProjectSinkBigqueryOptionsArgsDict']] bigquery_options: Options that affect sinks exporting data to BigQuery. Structure documented below.
        :param pulumi.Input[builtins.str] custom_writer_identity: A user managed service account that will be used to write
               the log entries. The format must be `serviceAccount:some@email`. This field can only be specified if you are
               routing logs to a destination outside this sink's project. If not specified, a Logging service account
               will automatically be generated.
        :param pulumi.Input[builtins.str] description: A description of this sink. The maximum length of the description is 8000 characters.
        :param pulumi.Input[builtins.str] destination: The destination of the sink (or, in other words, where logs are written to). Can be a Cloud Storage bucket, a PubSub topic, a BigQuery dataset, a Cloud Logging bucket, or a Google Cloud project. Examples:
               
               - `storage.googleapis.com/[GCS_BUCKET]`
               - `bigquery.googleapis.com/projects/[PROJECT_ID]/datasets/[DATASET]`
               - `pubsub.googleapis.com/projects/[PROJECT_ID]/topics/[TOPIC_ID]`
               - `logging.googleapis.com/projects/[PROJECT_ID]/locations/global/buckets/[BUCKET_ID]`
               - `logging.googleapis.com/projects/[PROJECT_ID]`
               
               The writer associated with the sink must have access to write to the above resource.
        :param pulumi.Input[builtins.bool] disabled: If set to True, then this sink is disabled and it does not export any log entries.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ProjectSinkExclusionArgs', 'ProjectSinkExclusionArgsDict']]]] exclusions: Log entries that match any of the exclusion filters will not be exported. If a log entry is matched by both `filter` and one of `exclusions.filter`, it will not be exported.  Can be repeated multiple times for multiple exclusions. Structure is documented below.
        :param pulumi.Input[builtins.str] filter: The filter to apply when exporting logs. Only log entries that match the filter are exported.
               See [Advanced Log Filters](https://cloud.google.com/logging/docs/view/advanced_filters) for information on how to
               write a filter.
        :param pulumi.Input[builtins.str] name: The name of the logging sink. Logging automatically creates two sinks: `_Required` and `_Default`.
        :param pulumi.Input[builtins.str] project: The ID of the project to create the sink in. If omitted, the project associated with the provider is
               used.
        :param pulumi.Input[builtins.bool] unique_writer_identity: Whether or not to create a unique identity associated with this sink. If `false`, then the `writer_identity` used is `serviceAccount:cloud-logs@system.gserviceaccount.com`. If `true` (the default),
               then a unique service account is created and used for this sink. If you wish to publish logs across projects or utilize
               `bigquery_options`, you must set `unique_writer_identity` to true.
        :param pulumi.Input[builtins.str] writer_identity: The identity associated with this sink. This identity must be granted write access to the
               configured `destination`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProjectSinkState.__new__(_ProjectSinkState)

        __props__.__dict__["bigquery_options"] = bigquery_options
        __props__.__dict__["custom_writer_identity"] = custom_writer_identity
        __props__.__dict__["description"] = description
        __props__.__dict__["destination"] = destination
        __props__.__dict__["disabled"] = disabled
        __props__.__dict__["exclusions"] = exclusions
        __props__.__dict__["filter"] = filter
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["unique_writer_identity"] = unique_writer_identity
        __props__.__dict__["writer_identity"] = writer_identity
        return ProjectSink(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="bigqueryOptions")
    def bigquery_options(self) -> pulumi.Output['outputs.ProjectSinkBigqueryOptions']:
        """
        Options that affect sinks exporting data to BigQuery. Structure documented below.
        """
        return pulumi.get(self, "bigquery_options")

    @property
    @pulumi.getter(name="customWriterIdentity")
    def custom_writer_identity(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A user managed service account that will be used to write
        the log entries. The format must be `serviceAccount:some@email`. This field can only be specified if you are
        routing logs to a destination outside this sink's project. If not specified, a Logging service account
        will automatically be generated.
        """
        return pulumi.get(self, "custom_writer_identity")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A description of this sink. The maximum length of the description is 8000 characters.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def destination(self) -> pulumi.Output[builtins.str]:
        """
        The destination of the sink (or, in other words, where logs are written to). Can be a Cloud Storage bucket, a PubSub topic, a BigQuery dataset, a Cloud Logging bucket, or a Google Cloud project. Examples:

        - `storage.googleapis.com/[GCS_BUCKET]`
        - `bigquery.googleapis.com/projects/[PROJECT_ID]/datasets/[DATASET]`
        - `pubsub.googleapis.com/projects/[PROJECT_ID]/topics/[TOPIC_ID]`
        - `logging.googleapis.com/projects/[PROJECT_ID]/locations/global/buckets/[BUCKET_ID]`
        - `logging.googleapis.com/projects/[PROJECT_ID]`

        The writer associated with the sink must have access to write to the above resource.
        """
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter
    def disabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        If set to True, then this sink is disabled and it does not export any log entries.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter
    def exclusions(self) -> pulumi.Output[Optional[Sequence['outputs.ProjectSinkExclusion']]]:
        """
        Log entries that match any of the exclusion filters will not be exported. If a log entry is matched by both `filter` and one of `exclusions.filter`, it will not be exported.  Can be repeated multiple times for multiple exclusions. Structure is documented below.
        """
        return pulumi.get(self, "exclusions")

    @property
    @pulumi.getter
    def filter(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The filter to apply when exporting logs. Only log entries that match the filter are exported.
        See [Advanced Log Filters](https://cloud.google.com/logging/docs/view/advanced_filters) for information on how to
        write a filter.
        """
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the logging sink. Logging automatically creates two sinks: `_Required` and `_Default`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project to create the sink in. If omitted, the project associated with the provider is
        used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="uniqueWriterIdentity")
    def unique_writer_identity(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether or not to create a unique identity associated with this sink. If `false`, then the `writer_identity` used is `serviceAccount:cloud-logs@system.gserviceaccount.com`. If `true` (the default),
        then a unique service account is created and used for this sink. If you wish to publish logs across projects or utilize
        `bigquery_options`, you must set `unique_writer_identity` to true.
        """
        return pulumi.get(self, "unique_writer_identity")

    @property
    @pulumi.getter(name="writerIdentity")
    def writer_identity(self) -> pulumi.Output[builtins.str]:
        """
        The identity associated with this sink. This identity must be granted write access to the
        configured `destination`.
        """
        return pulumi.get(self, "writer_identity")

