# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 capacity_gib: pulumi.Input[builtins.str],
                 filesystem: pulumi.Input[builtins.str],
                 instance_id: pulumi.Input[builtins.str],
                 location: pulumi.Input[builtins.str],
                 network: pulumi.Input[builtins.str],
                 per_unit_storage_throughput: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 gke_support_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[builtins.str] capacity_gib: The storage capacity of the instance in gibibytes (GiB). Allowed values
               are from `18000` to `954000`, in increments of 9000.
        :param pulumi.Input[builtins.str] filesystem: The filesystem name for this instance. This name is used by client-side
               tools, including when mounting the instance. Must be eight characters or
               less and can only contain letters and numbers.
        :param pulumi.Input[builtins.str] instance_id: The name of the Managed Lustre instance.
               * Must contain only lowercase letters, numbers, and hyphens.
               * Must start with a letter.
               * Must be between 1-63 characters.
               * Must end with a number or a letter.
               
               
               - - -
        :param pulumi.Input[builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[builtins.str] network: The full name of the VPC network to which the instance is connected.
               Must be in the format
               `projects/{project_id}/global/networks/{network_name}`.
        :param pulumi.Input[builtins.str] per_unit_storage_throughput: The throughput of the instance in MB/s/TiB.
               Valid values are 125, 250, 500, 1000.
        :param pulumi.Input[builtins.str] description: A user-readable description of the instance.
        :param pulumi.Input[builtins.bool] gke_support_enabled: Indicates whether you want to enable support for GKE clients. By default,
               GKE clients are not supported.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels as key value pairs.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "capacity_gib", capacity_gib)
        pulumi.set(__self__, "filesystem", filesystem)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "network", network)
        pulumi.set(__self__, "per_unit_storage_throughput", per_unit_storage_throughput)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if gke_support_enabled is not None:
            pulumi.set(__self__, "gke_support_enabled", gke_support_enabled)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="capacityGib")
    def capacity_gib(self) -> pulumi.Input[builtins.str]:
        """
        The storage capacity of the instance in gibibytes (GiB). Allowed values
        are from `18000` to `954000`, in increments of 9000.
        """
        return pulumi.get(self, "capacity_gib")

    @capacity_gib.setter
    def capacity_gib(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "capacity_gib", value)

    @property
    @pulumi.getter
    def filesystem(self) -> pulumi.Input[builtins.str]:
        """
        The filesystem name for this instance. This name is used by client-side
        tools, including when mounting the instance. Must be eight characters or
        less and can only contain letters and numbers.
        """
        return pulumi.get(self, "filesystem")

    @filesystem.setter
    def filesystem(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "filesystem", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[builtins.str]:
        """
        The name of the Managed Lustre instance.
        * Must contain only lowercase letters, numbers, and hyphens.
        * Must start with a letter.
        * Must be between 1-63 characters.
        * Must end with a number or a letter.


        - - -
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def network(self) -> pulumi.Input[builtins.str]:
        """
        The full name of the VPC network to which the instance is connected.
        Must be in the format
        `projects/{project_id}/global/networks/{network_name}`.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="perUnitStorageThroughput")
    def per_unit_storage_throughput(self) -> pulumi.Input[builtins.str]:
        """
        The throughput of the instance in MB/s/TiB.
        Valid values are 125, 250, 500, 1000.
        """
        return pulumi.get(self, "per_unit_storage_throughput")

    @per_unit_storage_throughput.setter
    def per_unit_storage_throughput(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "per_unit_storage_throughput", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A user-readable description of the instance.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="gkeSupportEnabled")
    def gke_support_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether you want to enable support for GKE clients. By default,
        GKE clients are not supported.
        """
        return pulumi.get(self, "gke_support_enabled")

    @gke_support_enabled.setter
    def gke_support_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "gke_support_enabled", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Labels as key value pairs.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 capacity_gib: Optional[pulumi.Input[builtins.str]] = None,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 filesystem: Optional[pulumi.Input[builtins.str]] = None,
                 gke_support_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 instance_id: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 mount_point: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network: Optional[pulumi.Input[builtins.str]] = None,
                 per_unit_storage_throughput: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input[builtins.str] capacity_gib: The storage capacity of the instance in gibibytes (GiB). Allowed values
               are from `18000` to `954000`, in increments of 9000.
        :param pulumi.Input[builtins.str] create_time: Timestamp when the instance was created.
        :param pulumi.Input[builtins.str] description: A user-readable description of the instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.str] filesystem: The filesystem name for this instance. This name is used by client-side
               tools, including when mounting the instance. Must be eight characters or
               less and can only contain letters and numbers.
        :param pulumi.Input[builtins.bool] gke_support_enabled: Indicates whether you want to enable support for GKE clients. By default,
               GKE clients are not supported.
        :param pulumi.Input[builtins.str] instance_id: The name of the Managed Lustre instance.
               * Must contain only lowercase letters, numbers, and hyphens.
               * Must start with a letter.
               * Must be between 1-63 characters.
               * Must end with a number or a letter.
               
               
               - - -
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels as key value pairs.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[builtins.str] mount_point: Mount point of the instance in the format `IP_ADDRESS@tcp:/FILESYSTEM`.
        :param pulumi.Input[builtins.str] name: Identifier. The name of the instance.
        :param pulumi.Input[builtins.str] network: The full name of the VPC network to which the instance is connected.
               Must be in the format
               `projects/{project_id}/global/networks/{network_name}`.
        :param pulumi.Input[builtins.str] per_unit_storage_throughput: The throughput of the instance in MB/s/TiB.
               Valid values are 125, 250, 500, 1000.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.str] state: The state of the instance.
               Possible values:
               STATE_UNSPECIFIED
               ACTIVE
               CREATING
               DELETING
               UPGRADING
               REPAIRING
               STOPPED
        :param pulumi.Input[builtins.str] update_time: Timestamp when the instance was last updated.
        """
        if capacity_gib is not None:
            pulumi.set(__self__, "capacity_gib", capacity_gib)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if filesystem is not None:
            pulumi.set(__self__, "filesystem", filesystem)
        if gke_support_enabled is not None:
            pulumi.set(__self__, "gke_support_enabled", gke_support_enabled)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if mount_point is not None:
            pulumi.set(__self__, "mount_point", mount_point)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if per_unit_storage_throughput is not None:
            pulumi.set(__self__, "per_unit_storage_throughput", per_unit_storage_throughput)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="capacityGib")
    def capacity_gib(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The storage capacity of the instance in gibibytes (GiB). Allowed values
        are from `18000` to `954000`, in increments of 9000.
        """
        return pulumi.get(self, "capacity_gib")

    @capacity_gib.setter
    def capacity_gib(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "capacity_gib", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Timestamp when the instance was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A user-readable description of the instance.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter
    def filesystem(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The filesystem name for this instance. This name is used by client-side
        tools, including when mounting the instance. Must be eight characters or
        less and can only contain letters and numbers.
        """
        return pulumi.get(self, "filesystem")

    @filesystem.setter
    def filesystem(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "filesystem", value)

    @property
    @pulumi.getter(name="gkeSupportEnabled")
    def gke_support_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether you want to enable support for GKE clients. By default,
        GKE clients are not supported.
        """
        return pulumi.get(self, "gke_support_enabled")

    @gke_support_enabled.setter
    def gke_support_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "gke_support_enabled", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Managed Lustre instance.
        * Must contain only lowercase letters, numbers, and hyphens.
        * Must start with a letter.
        * Must be between 1-63 characters.
        * Must end with a number or a letter.


        - - -
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Labels as key value pairs.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="mountPoint")
    def mount_point(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Mount point of the instance in the format `IP_ADDRESS@tcp:/FILESYSTEM`.
        """
        return pulumi.get(self, "mount_point")

    @mount_point.setter
    def mount_point(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "mount_point", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier. The name of the instance.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The full name of the VPC network to which the instance is connected.
        Must be in the format
        `projects/{project_id}/global/networks/{network_name}`.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="perUnitStorageThroughput")
    def per_unit_storage_throughput(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The throughput of the instance in MB/s/TiB.
        Valid values are 125, 250, 500, 1000.
        """
        return pulumi.get(self, "per_unit_storage_throughput")

    @per_unit_storage_throughput.setter
    def per_unit_storage_throughput(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "per_unit_storage_throughput", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The state of the instance.
        Possible values:
        STATE_UNSPECIFIED
        ACTIVE
        CREATING
        DELETING
        UPGRADING
        REPAIRING
        STOPPED
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Timestamp when the instance was last updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:lustre/instance:Instance")
class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 capacity_gib: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 filesystem: Optional[pulumi.Input[builtins.str]] = None,
                 gke_support_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 instance_id: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 network: Optional[pulumi.Input[builtins.str]] = None,
                 per_unit_storage_throughput: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        A Managed Lustre instance

        To get more information about Instance, see:

        * [API documentation](https://cloud.google.com/managed-lustre/docs/reference/rest/v1/projects.locations.instances)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/managed-lustre/docs/create-instance)

        ## Example Usage

        ### Lustre Instance Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        # This example assumes this network already exists.
        # The API creates a tenant network per network authorized for a
        # Lustre instance and that network is not deleted when the user-created
        # network (authorized_network) is deleted, so this prevents issues
        # with tenant network quota.
        # If this network hasn't been created and you are using this example in your
        # config, add an additional network resource or change
        # this from "data"to "resource"
        lustre_network = gcp.compute.get_network(name="my-network")
        instance = gcp.lustre.Instance("instance",
            instance_id="my-instance",
            location="us-central1-a",
            description="test lustre instance",
            filesystem="testfs",
            capacity_gib="18000",
            network=lustre_network.id,
            per_unit_storage_throughput="1000",
            labels={
                "test": "value",
            })
        ```

        ## Import

        Instance can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/instances/{{instance_id}}`

        * `{{project}}/{{location}}/{{instance_id}}`

        * `{{location}}/{{instance_id}}`

        When using the `pulumi import` command, Instance can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:lustre/instance:Instance default projects/{{project}}/locations/{{location}}/instances/{{instance_id}}
        ```

        ```sh
        $ pulumi import gcp:lustre/instance:Instance default {{project}}/{{location}}/{{instance_id}}
        ```

        ```sh
        $ pulumi import gcp:lustre/instance:Instance default {{location}}/{{instance_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] capacity_gib: The storage capacity of the instance in gibibytes (GiB). Allowed values
               are from `18000` to `954000`, in increments of 9000.
        :param pulumi.Input[builtins.str] description: A user-readable description of the instance.
        :param pulumi.Input[builtins.str] filesystem: The filesystem name for this instance. This name is used by client-side
               tools, including when mounting the instance. Must be eight characters or
               less and can only contain letters and numbers.
        :param pulumi.Input[builtins.bool] gke_support_enabled: Indicates whether you want to enable support for GKE clients. By default,
               GKE clients are not supported.
        :param pulumi.Input[builtins.str] instance_id: The name of the Managed Lustre instance.
               * Must contain only lowercase letters, numbers, and hyphens.
               * Must start with a letter.
               * Must be between 1-63 characters.
               * Must end with a number or a letter.
               
               
               - - -
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels as key value pairs.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[builtins.str] network: The full name of the VPC network to which the instance is connected.
               Must be in the format
               `projects/{project_id}/global/networks/{network_name}`.
        :param pulumi.Input[builtins.str] per_unit_storage_throughput: The throughput of the instance in MB/s/TiB.
               Valid values are 125, 250, 500, 1000.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Managed Lustre instance

        To get more information about Instance, see:

        * [API documentation](https://cloud.google.com/managed-lustre/docs/reference/rest/v1/projects.locations.instances)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/managed-lustre/docs/create-instance)

        ## Example Usage

        ### Lustre Instance Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        # This example assumes this network already exists.
        # The API creates a tenant network per network authorized for a
        # Lustre instance and that network is not deleted when the user-created
        # network (authorized_network) is deleted, so this prevents issues
        # with tenant network quota.
        # If this network hasn't been created and you are using this example in your
        # config, add an additional network resource or change
        # this from "data"to "resource"
        lustre_network = gcp.compute.get_network(name="my-network")
        instance = gcp.lustre.Instance("instance",
            instance_id="my-instance",
            location="us-central1-a",
            description="test lustre instance",
            filesystem="testfs",
            capacity_gib="18000",
            network=lustre_network.id,
            per_unit_storage_throughput="1000",
            labels={
                "test": "value",
            })
        ```

        ## Import

        Instance can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/instances/{{instance_id}}`

        * `{{project}}/{{location}}/{{instance_id}}`

        * `{{location}}/{{instance_id}}`

        When using the `pulumi import` command, Instance can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:lustre/instance:Instance default projects/{{project}}/locations/{{location}}/instances/{{instance_id}}
        ```

        ```sh
        $ pulumi import gcp:lustre/instance:Instance default {{project}}/{{location}}/{{instance_id}}
        ```

        ```sh
        $ pulumi import gcp:lustre/instance:Instance default {{location}}/{{instance_id}}
        ```

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 capacity_gib: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 filesystem: Optional[pulumi.Input[builtins.str]] = None,
                 gke_support_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 instance_id: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 network: Optional[pulumi.Input[builtins.str]] = None,
                 per_unit_storage_throughput: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            if capacity_gib is None and not opts.urn:
                raise TypeError("Missing required property 'capacity_gib'")
            __props__.__dict__["capacity_gib"] = capacity_gib
            __props__.__dict__["description"] = description
            if filesystem is None and not opts.urn:
                raise TypeError("Missing required property 'filesystem'")
            __props__.__dict__["filesystem"] = filesystem
            __props__.__dict__["gke_support_enabled"] = gke_support_enabled
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            if network is None and not opts.urn:
                raise TypeError("Missing required property 'network'")
            __props__.__dict__["network"] = network
            if per_unit_storage_throughput is None and not opts.urn:
                raise TypeError("Missing required property 'per_unit_storage_throughput'")
            __props__.__dict__["per_unit_storage_throughput"] = per_unit_storage_throughput
            __props__.__dict__["project"] = project
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["mount_point"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Instance, __self__).__init__(
            'gcp:lustre/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            capacity_gib: Optional[pulumi.Input[builtins.str]] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            filesystem: Optional[pulumi.Input[builtins.str]] = None,
            gke_support_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            instance_id: Optional[pulumi.Input[builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            mount_point: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            network: Optional[pulumi.Input[builtins.str]] = None,
            per_unit_storage_throughput: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] capacity_gib: The storage capacity of the instance in gibibytes (GiB). Allowed values
               are from `18000` to `954000`, in increments of 9000.
        :param pulumi.Input[builtins.str] create_time: Timestamp when the instance was created.
        :param pulumi.Input[builtins.str] description: A user-readable description of the instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.str] filesystem: The filesystem name for this instance. This name is used by client-side
               tools, including when mounting the instance. Must be eight characters or
               less and can only contain letters and numbers.
        :param pulumi.Input[builtins.bool] gke_support_enabled: Indicates whether you want to enable support for GKE clients. By default,
               GKE clients are not supported.
        :param pulumi.Input[builtins.str] instance_id: The name of the Managed Lustre instance.
               * Must contain only lowercase letters, numbers, and hyphens.
               * Must start with a letter.
               * Must be between 1-63 characters.
               * Must end with a number or a letter.
               
               
               - - -
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels as key value pairs.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[builtins.str] mount_point: Mount point of the instance in the format `IP_ADDRESS@tcp:/FILESYSTEM`.
        :param pulumi.Input[builtins.str] name: Identifier. The name of the instance.
        :param pulumi.Input[builtins.str] network: The full name of the VPC network to which the instance is connected.
               Must be in the format
               `projects/{project_id}/global/networks/{network_name}`.
        :param pulumi.Input[builtins.str] per_unit_storage_throughput: The throughput of the instance in MB/s/TiB.
               Valid values are 125, 250, 500, 1000.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.str] state: The state of the instance.
               Possible values:
               STATE_UNSPECIFIED
               ACTIVE
               CREATING
               DELETING
               UPGRADING
               REPAIRING
               STOPPED
        :param pulumi.Input[builtins.str] update_time: Timestamp when the instance was last updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["capacity_gib"] = capacity_gib
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["filesystem"] = filesystem
        __props__.__dict__["gke_support_enabled"] = gke_support_enabled
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["mount_point"] = mount_point
        __props__.__dict__["name"] = name
        __props__.__dict__["network"] = network
        __props__.__dict__["per_unit_storage_throughput"] = per_unit_storage_throughput
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["state"] = state
        __props__.__dict__["update_time"] = update_time
        return Instance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="capacityGib")
    def capacity_gib(self) -> pulumi.Output[builtins.str]:
        """
        The storage capacity of the instance in gibibytes (GiB). Allowed values
        are from `18000` to `954000`, in increments of 9000.
        """
        return pulumi.get(self, "capacity_gib")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        Timestamp when the instance was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A user-readable description of the instance.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter
    def filesystem(self) -> pulumi.Output[builtins.str]:
        """
        The filesystem name for this instance. This name is used by client-side
        tools, including when mounting the instance. Must be eight characters or
        less and can only contain letters and numbers.
        """
        return pulumi.get(self, "filesystem")

    @property
    @pulumi.getter(name="gkeSupportEnabled")
    def gke_support_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Indicates whether you want to enable support for GKE clients. By default,
        GKE clients are not supported.
        """
        return pulumi.get(self, "gke_support_enabled")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Managed Lustre instance.
        * Must contain only lowercase letters, numbers, and hyphens.
        * Must start with a letter.
        * Must be between 1-63 characters.
        * Must end with a number or a letter.


        - - -
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Labels as key value pairs.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="mountPoint")
    def mount_point(self) -> pulumi.Output[builtins.str]:
        """
        Mount point of the instance in the format `IP_ADDRESS@tcp:/FILESYSTEM`.
        """
        return pulumi.get(self, "mount_point")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Identifier. The name of the instance.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def network(self) -> pulumi.Output[builtins.str]:
        """
        The full name of the VPC network to which the instance is connected.
        Must be in the format
        `projects/{project_id}/global/networks/{network_name}`.
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter(name="perUnitStorageThroughput")
    def per_unit_storage_throughput(self) -> pulumi.Output[builtins.str]:
        """
        The throughput of the instance in MB/s/TiB.
        Valid values are 125, 250, 500, 1000.
        """
        return pulumi.get(self, "per_unit_storage_throughput")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The state of the instance.
        Possible values:
        STATE_UNSPECIFIED
        ACTIVE
        CREATING
        DELETING
        UPGRADING
        REPAIRING
        STOPPED
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        Timestamp when the instance was last updated.
        """
        return pulumi.get(self, "update_time")

