# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'AclAclEntryArgs',
    'AclAclEntryArgsDict',
    'ClusterCapacityConfigArgs',
    'ClusterCapacityConfigArgsDict',
    'ClusterGcpConfigArgs',
    'ClusterGcpConfigArgsDict',
    'ClusterGcpConfigAccessConfigArgs',
    'ClusterGcpConfigAccessConfigArgsDict',
    'ClusterGcpConfigAccessConfigNetworkConfigArgs',
    'ClusterGcpConfigAccessConfigNetworkConfigArgsDict',
    'ClusterRebalanceConfigArgs',
    'ClusterRebalanceConfigArgsDict',
    'ConnectClusterCapacityConfigArgs',
    'ConnectClusterCapacityConfigArgsDict',
    'ConnectClusterGcpConfigArgs',
    'ConnectClusterGcpConfigArgsDict',
    'ConnectClusterGcpConfigAccessConfigArgs',
    'ConnectClusterGcpConfigAccessConfigArgsDict',
    'ConnectClusterGcpConfigAccessConfigNetworkConfigArgs',
    'ConnectClusterGcpConfigAccessConfigNetworkConfigArgsDict',
    'ConnectorTaskRestartPolicyArgs',
    'ConnectorTaskRestartPolicyArgsDict',
]

MYPY = False

if not MYPY:
    class AclAclEntryArgsDict(TypedDict):
        operation: pulumi.Input[builtins.str]
        """
        The operation type. Allowed values are (case insensitive): ALL, READ,
        WRITE, CREATE, DELETE, ALTER, DESCRIBE, CLUSTER_ACTION, DESCRIBE_CONFIGS,
        ALTER_CONFIGS, and IDEMPOTENT_WRITE. See https://kafka.apache.org/documentation/#operations_resources_and_protocols
        for valid combinations of resource_type and operation for different Kafka API requests.
        """
        principal: pulumi.Input[builtins.str]
        """
        The principal. Specified as Google Cloud account, with the Kafka StandardAuthorizer prefix User:". For example: "User:test-kafka-client@test-project.iam.gserviceaccount.com". Can be the wildcard "User:*" to refer to all users.
        """
        host: NotRequired[pulumi.Input[builtins.str]]
        """
        The host. Must be set to "*" for Managed Service for Apache Kafka.

        - - -
        """
        permission_type: NotRequired[pulumi.Input[builtins.str]]
        """
        The permission type. Accepted values are (case insensitive): ALLOW, DENY.
        """
elif False:
    AclAclEntryArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AclAclEntryArgs:
    def __init__(__self__, *,
                 operation: pulumi.Input[builtins.str],
                 principal: pulumi.Input[builtins.str],
                 host: Optional[pulumi.Input[builtins.str]] = None,
                 permission_type: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] operation: The operation type. Allowed values are (case insensitive): ALL, READ,
               WRITE, CREATE, DELETE, ALTER, DESCRIBE, CLUSTER_ACTION, DESCRIBE_CONFIGS,
               ALTER_CONFIGS, and IDEMPOTENT_WRITE. See https://kafka.apache.org/documentation/#operations_resources_and_protocols
               for valid combinations of resource_type and operation for different Kafka API requests.
        :param pulumi.Input[builtins.str] principal: The principal. Specified as Google Cloud account, with the Kafka StandardAuthorizer prefix User:". For example: "User:test-kafka-client@test-project.iam.gserviceaccount.com". Can be the wildcard "User:*" to refer to all users.
        :param pulumi.Input[builtins.str] host: The host. Must be set to "*" for Managed Service for Apache Kafka.
               
               - - -
        :param pulumi.Input[builtins.str] permission_type: The permission type. Accepted values are (case insensitive): ALLOW, DENY.
        """
        pulumi.set(__self__, "operation", operation)
        pulumi.set(__self__, "principal", principal)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if permission_type is not None:
            pulumi.set(__self__, "permission_type", permission_type)

    @property
    @pulumi.getter
    def operation(self) -> pulumi.Input[builtins.str]:
        """
        The operation type. Allowed values are (case insensitive): ALL, READ,
        WRITE, CREATE, DELETE, ALTER, DESCRIBE, CLUSTER_ACTION, DESCRIBE_CONFIGS,
        ALTER_CONFIGS, and IDEMPOTENT_WRITE. See https://kafka.apache.org/documentation/#operations_resources_and_protocols
        for valid combinations of resource_type and operation for different Kafka API requests.
        """
        return pulumi.get(self, "operation")

    @operation.setter
    def operation(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "operation", value)

    @property
    @pulumi.getter
    def principal(self) -> pulumi.Input[builtins.str]:
        """
        The principal. Specified as Google Cloud account, with the Kafka StandardAuthorizer prefix User:". For example: "User:test-kafka-client@test-project.iam.gserviceaccount.com". Can be the wildcard "User:*" to refer to all users.
        """
        return pulumi.get(self, "principal")

    @principal.setter
    def principal(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "principal", value)

    @property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The host. Must be set to "*" for Managed Service for Apache Kafka.

        - - -
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter(name="permissionType")
    def permission_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The permission type. Accepted values are (case insensitive): ALLOW, DENY.
        """
        return pulumi.get(self, "permission_type")

    @permission_type.setter
    def permission_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "permission_type", value)


if not MYPY:
    class ClusterCapacityConfigArgsDict(TypedDict):
        memory_bytes: pulumi.Input[builtins.str]
        """
        The memory to provision for the cluster in bytes. The value must be between 1 GiB and 8 GiB per vCPU. Ex. 1024Mi, 4Gi.

        - - -
        """
        vcpu_count: pulumi.Input[builtins.str]
        """
        The number of vCPUs to provision for the cluster. The minimum is 3.
        """
elif False:
    ClusterCapacityConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterCapacityConfigArgs:
    def __init__(__self__, *,
                 memory_bytes: pulumi.Input[builtins.str],
                 vcpu_count: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] memory_bytes: The memory to provision for the cluster in bytes. The value must be between 1 GiB and 8 GiB per vCPU. Ex. 1024Mi, 4Gi.
               
               - - -
        :param pulumi.Input[builtins.str] vcpu_count: The number of vCPUs to provision for the cluster. The minimum is 3.
        """
        pulumi.set(__self__, "memory_bytes", memory_bytes)
        pulumi.set(__self__, "vcpu_count", vcpu_count)

    @property
    @pulumi.getter(name="memoryBytes")
    def memory_bytes(self) -> pulumi.Input[builtins.str]:
        """
        The memory to provision for the cluster in bytes. The value must be between 1 GiB and 8 GiB per vCPU. Ex. 1024Mi, 4Gi.

        - - -
        """
        return pulumi.get(self, "memory_bytes")

    @memory_bytes.setter
    def memory_bytes(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "memory_bytes", value)

    @property
    @pulumi.getter(name="vcpuCount")
    def vcpu_count(self) -> pulumi.Input[builtins.str]:
        """
        The number of vCPUs to provision for the cluster. The minimum is 3.
        """
        return pulumi.get(self, "vcpu_count")

    @vcpu_count.setter
    def vcpu_count(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "vcpu_count", value)


if not MYPY:
    class ClusterGcpConfigArgsDict(TypedDict):
        access_config: pulumi.Input['ClusterGcpConfigAccessConfigArgsDict']
        """
        The configuration of access to the Kafka cluster.
        Structure is documented below.
        """
        kms_key: NotRequired[pulumi.Input[builtins.str]]
        """
        The Cloud KMS Key name to use for encryption. The key must be located in the same region as the cluster and cannot be changed. Must be in the format `projects/PROJECT_ID/locations/LOCATION/keyRings/KEY_RING/cryptoKeys/KEY`.
        """
elif False:
    ClusterGcpConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterGcpConfigArgs:
    def __init__(__self__, *,
                 access_config: pulumi.Input['ClusterGcpConfigAccessConfigArgs'],
                 kms_key: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input['ClusterGcpConfigAccessConfigArgs'] access_config: The configuration of access to the Kafka cluster.
               Structure is documented below.
        :param pulumi.Input[builtins.str] kms_key: The Cloud KMS Key name to use for encryption. The key must be located in the same region as the cluster and cannot be changed. Must be in the format `projects/PROJECT_ID/locations/LOCATION/keyRings/KEY_RING/cryptoKeys/KEY`.
        """
        pulumi.set(__self__, "access_config", access_config)
        if kms_key is not None:
            pulumi.set(__self__, "kms_key", kms_key)

    @property
    @pulumi.getter(name="accessConfig")
    def access_config(self) -> pulumi.Input['ClusterGcpConfigAccessConfigArgs']:
        """
        The configuration of access to the Kafka cluster.
        Structure is documented below.
        """
        return pulumi.get(self, "access_config")

    @access_config.setter
    def access_config(self, value: pulumi.Input['ClusterGcpConfigAccessConfigArgs']):
        pulumi.set(self, "access_config", value)

    @property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Cloud KMS Key name to use for encryption. The key must be located in the same region as the cluster and cannot be changed. Must be in the format `projects/PROJECT_ID/locations/LOCATION/keyRings/KEY_RING/cryptoKeys/KEY`.
        """
        return pulumi.get(self, "kms_key")

    @kms_key.setter
    def kms_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key", value)


if not MYPY:
    class ClusterGcpConfigAccessConfigArgsDict(TypedDict):
        network_configs: pulumi.Input[Sequence[pulumi.Input['ClusterGcpConfigAccessConfigNetworkConfigArgsDict']]]
        """
        Virtual Private Cloud (VPC) subnets where IP addresses for the Kafka cluster are allocated. To make the cluster available in a VPC, you must specify at least one `network_configs` block. Max of 10 subnets per cluster. Additional subnets may be specified with additional `network_configs` blocks.
        Structure is documented below.
        """
elif False:
    ClusterGcpConfigAccessConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterGcpConfigAccessConfigArgs:
    def __init__(__self__, *,
                 network_configs: pulumi.Input[Sequence[pulumi.Input['ClusterGcpConfigAccessConfigNetworkConfigArgs']]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ClusterGcpConfigAccessConfigNetworkConfigArgs']]] network_configs: Virtual Private Cloud (VPC) subnets where IP addresses for the Kafka cluster are allocated. To make the cluster available in a VPC, you must specify at least one `network_configs` block. Max of 10 subnets per cluster. Additional subnets may be specified with additional `network_configs` blocks.
               Structure is documented below.
        """
        pulumi.set(__self__, "network_configs", network_configs)

    @property
    @pulumi.getter(name="networkConfigs")
    def network_configs(self) -> pulumi.Input[Sequence[pulumi.Input['ClusterGcpConfigAccessConfigNetworkConfigArgs']]]:
        """
        Virtual Private Cloud (VPC) subnets where IP addresses for the Kafka cluster are allocated. To make the cluster available in a VPC, you must specify at least one `network_configs` block. Max of 10 subnets per cluster. Additional subnets may be specified with additional `network_configs` blocks.
        Structure is documented below.
        """
        return pulumi.get(self, "network_configs")

    @network_configs.setter
    def network_configs(self, value: pulumi.Input[Sequence[pulumi.Input['ClusterGcpConfigAccessConfigNetworkConfigArgs']]]):
        pulumi.set(self, "network_configs", value)


if not MYPY:
    class ClusterGcpConfigAccessConfigNetworkConfigArgsDict(TypedDict):
        subnet: pulumi.Input[builtins.str]
        """
        Name of the VPC subnet from which the cluster is accessible. Both broker and bootstrap server IP addresses and DNS entries are automatically created in the subnet. There can only be one subnet per network, and the subnet must be located in the same region as the cluster. The project may differ. The name of the subnet must be in the format `projects/PROJECT_ID/regions/REGION/subnetworks/SUBNET`.
        """
elif False:
    ClusterGcpConfigAccessConfigNetworkConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterGcpConfigAccessConfigNetworkConfigArgs:
    def __init__(__self__, *,
                 subnet: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] subnet: Name of the VPC subnet from which the cluster is accessible. Both broker and bootstrap server IP addresses and DNS entries are automatically created in the subnet. There can only be one subnet per network, and the subnet must be located in the same region as the cluster. The project may differ. The name of the subnet must be in the format `projects/PROJECT_ID/regions/REGION/subnetworks/SUBNET`.
        """
        pulumi.set(__self__, "subnet", subnet)

    @property
    @pulumi.getter
    def subnet(self) -> pulumi.Input[builtins.str]:
        """
        Name of the VPC subnet from which the cluster is accessible. Both broker and bootstrap server IP addresses and DNS entries are automatically created in the subnet. There can only be one subnet per network, and the subnet must be located in the same region as the cluster. The project may differ. The name of the subnet must be in the format `projects/PROJECT_ID/regions/REGION/subnetworks/SUBNET`.
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "subnet", value)


if not MYPY:
    class ClusterRebalanceConfigArgsDict(TypedDict):
        mode: NotRequired[pulumi.Input[builtins.str]]
        """
        The rebalance behavior for the cluster. When not specified, defaults to `NO_REBALANCE`. Possible values: `MODE_UNSPECIFIED`, `NO_REBALANCE`, `AUTO_REBALANCE_ON_SCALE_UP`.
        """
elif False:
    ClusterRebalanceConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterRebalanceConfigArgs:
    def __init__(__self__, *,
                 mode: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] mode: The rebalance behavior for the cluster. When not specified, defaults to `NO_REBALANCE`. Possible values: `MODE_UNSPECIFIED`, `NO_REBALANCE`, `AUTO_REBALANCE_ON_SCALE_UP`.
        """
        if mode is not None:
            pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The rebalance behavior for the cluster. When not specified, defaults to `NO_REBALANCE`. Possible values: `MODE_UNSPECIFIED`, `NO_REBALANCE`, `AUTO_REBALANCE_ON_SCALE_UP`.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "mode", value)


if not MYPY:
    class ConnectClusterCapacityConfigArgsDict(TypedDict):
        memory_bytes: pulumi.Input[builtins.str]
        """
        The memory to provision for the cluster in bytes. The CPU:memory ratio (vCPU:GiB) must be between 1:1 and 1:8. Minimum: 3221225472 (3 GiB).
        """
        vcpu_count: pulumi.Input[builtins.str]
        """
        The number of vCPUs to provision for the cluster. The minimum is 3.
        """
elif False:
    ConnectClusterCapacityConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectClusterCapacityConfigArgs:
    def __init__(__self__, *,
                 memory_bytes: pulumi.Input[builtins.str],
                 vcpu_count: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] memory_bytes: The memory to provision for the cluster in bytes. The CPU:memory ratio (vCPU:GiB) must be between 1:1 and 1:8. Minimum: 3221225472 (3 GiB).
        :param pulumi.Input[builtins.str] vcpu_count: The number of vCPUs to provision for the cluster. The minimum is 3.
        """
        pulumi.set(__self__, "memory_bytes", memory_bytes)
        pulumi.set(__self__, "vcpu_count", vcpu_count)

    @property
    @pulumi.getter(name="memoryBytes")
    def memory_bytes(self) -> pulumi.Input[builtins.str]:
        """
        The memory to provision for the cluster in bytes. The CPU:memory ratio (vCPU:GiB) must be between 1:1 and 1:8. Minimum: 3221225472 (3 GiB).
        """
        return pulumi.get(self, "memory_bytes")

    @memory_bytes.setter
    def memory_bytes(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "memory_bytes", value)

    @property
    @pulumi.getter(name="vcpuCount")
    def vcpu_count(self) -> pulumi.Input[builtins.str]:
        """
        The number of vCPUs to provision for the cluster. The minimum is 3.
        """
        return pulumi.get(self, "vcpu_count")

    @vcpu_count.setter
    def vcpu_count(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "vcpu_count", value)


if not MYPY:
    class ConnectClusterGcpConfigArgsDict(TypedDict):
        access_config: pulumi.Input['ConnectClusterGcpConfigAccessConfigArgsDict']
        """
        The configuration of access to the Kafka Connect cluster.
        Structure is documented below.
        """
elif False:
    ConnectClusterGcpConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectClusterGcpConfigArgs:
    def __init__(__self__, *,
                 access_config: pulumi.Input['ConnectClusterGcpConfigAccessConfigArgs']):
        """
        :param pulumi.Input['ConnectClusterGcpConfigAccessConfigArgs'] access_config: The configuration of access to the Kafka Connect cluster.
               Structure is documented below.
        """
        pulumi.set(__self__, "access_config", access_config)

    @property
    @pulumi.getter(name="accessConfig")
    def access_config(self) -> pulumi.Input['ConnectClusterGcpConfigAccessConfigArgs']:
        """
        The configuration of access to the Kafka Connect cluster.
        Structure is documented below.
        """
        return pulumi.get(self, "access_config")

    @access_config.setter
    def access_config(self, value: pulumi.Input['ConnectClusterGcpConfigAccessConfigArgs']):
        pulumi.set(self, "access_config", value)


if not MYPY:
    class ConnectClusterGcpConfigAccessConfigArgsDict(TypedDict):
        network_configs: pulumi.Input[Sequence[pulumi.Input['ConnectClusterGcpConfigAccessConfigNetworkConfigArgsDict']]]
        """
        Virtual Private Cloud (VPC) subnets where IP addresses for the Kafka Connect cluster are allocated. To make the connect cluster available in a VPC, you must specify at least one subnet per network. You must specify between 1 and 10 subnets. Additional subnets may be specified with additional `network_configs` blocks.
        Structure is documented below.
        """
elif False:
    ConnectClusterGcpConfigAccessConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectClusterGcpConfigAccessConfigArgs:
    def __init__(__self__, *,
                 network_configs: pulumi.Input[Sequence[pulumi.Input['ConnectClusterGcpConfigAccessConfigNetworkConfigArgs']]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ConnectClusterGcpConfigAccessConfigNetworkConfigArgs']]] network_configs: Virtual Private Cloud (VPC) subnets where IP addresses for the Kafka Connect cluster are allocated. To make the connect cluster available in a VPC, you must specify at least one subnet per network. You must specify between 1 and 10 subnets. Additional subnets may be specified with additional `network_configs` blocks.
               Structure is documented below.
        """
        pulumi.set(__self__, "network_configs", network_configs)

    @property
    @pulumi.getter(name="networkConfigs")
    def network_configs(self) -> pulumi.Input[Sequence[pulumi.Input['ConnectClusterGcpConfigAccessConfigNetworkConfigArgs']]]:
        """
        Virtual Private Cloud (VPC) subnets where IP addresses for the Kafka Connect cluster are allocated. To make the connect cluster available in a VPC, you must specify at least one subnet per network. You must specify between 1 and 10 subnets. Additional subnets may be specified with additional `network_configs` blocks.
        Structure is documented below.
        """
        return pulumi.get(self, "network_configs")

    @network_configs.setter
    def network_configs(self, value: pulumi.Input[Sequence[pulumi.Input['ConnectClusterGcpConfigAccessConfigNetworkConfigArgs']]]):
        pulumi.set(self, "network_configs", value)


if not MYPY:
    class ConnectClusterGcpConfigAccessConfigNetworkConfigArgsDict(TypedDict):
        primary_subnet: pulumi.Input[builtins.str]
        """
        VPC subnet to make available to the Kafka Connect cluster. Structured like: projects/{project}/regions/{region}/subnetworks/{subnet_id}. It is used to create a Private Service Connect (PSC) interface for the Kafka Connect workers. It must be located in the same region as the Kafka Connect cluster. The CIDR range of the subnet must be within the IPv4 address ranges for private networks, as specified in RFC 1918. The primary subnet CIDR range must have a minimum size of /22 (1024 addresses).
        """
        additional_subnets: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Additional subnets may be specified. They may be in another region, but must be in the same VPC network. The Connect workers can communicate with network endpoints in either the primary or additional subnets.
        """
        dns_domain_names: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Additional DNS domain names from the subnet's network to be made visible to the Connect Cluster. When using MirrorMaker2, it's necessary to add the bootstrap address's dns domain name of the target cluster to make it visible to the connector. For example: my-kafka-cluster.us-central1.managedkafka.my-project.cloud.goog

        - - -
        """
elif False:
    ConnectClusterGcpConfigAccessConfigNetworkConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectClusterGcpConfigAccessConfigNetworkConfigArgs:
    def __init__(__self__, *,
                 primary_subnet: pulumi.Input[builtins.str],
                 additional_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 dns_domain_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input[builtins.str] primary_subnet: VPC subnet to make available to the Kafka Connect cluster. Structured like: projects/{project}/regions/{region}/subnetworks/{subnet_id}. It is used to create a Private Service Connect (PSC) interface for the Kafka Connect workers. It must be located in the same region as the Kafka Connect cluster. The CIDR range of the subnet must be within the IPv4 address ranges for private networks, as specified in RFC 1918. The primary subnet CIDR range must have a minimum size of /22 (1024 addresses).
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] additional_subnets: Additional subnets may be specified. They may be in another region, but must be in the same VPC network. The Connect workers can communicate with network endpoints in either the primary or additional subnets.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] dns_domain_names: Additional DNS domain names from the subnet's network to be made visible to the Connect Cluster. When using MirrorMaker2, it's necessary to add the bootstrap address's dns domain name of the target cluster to make it visible to the connector. For example: my-kafka-cluster.us-central1.managedkafka.my-project.cloud.goog
               
               - - -
        """
        pulumi.set(__self__, "primary_subnet", primary_subnet)
        if additional_subnets is not None:
            pulumi.set(__self__, "additional_subnets", additional_subnets)
        if dns_domain_names is not None:
            pulumi.set(__self__, "dns_domain_names", dns_domain_names)

    @property
    @pulumi.getter(name="primarySubnet")
    def primary_subnet(self) -> pulumi.Input[builtins.str]:
        """
        VPC subnet to make available to the Kafka Connect cluster. Structured like: projects/{project}/regions/{region}/subnetworks/{subnet_id}. It is used to create a Private Service Connect (PSC) interface for the Kafka Connect workers. It must be located in the same region as the Kafka Connect cluster. The CIDR range of the subnet must be within the IPv4 address ranges for private networks, as specified in RFC 1918. The primary subnet CIDR range must have a minimum size of /22 (1024 addresses).
        """
        return pulumi.get(self, "primary_subnet")

    @primary_subnet.setter
    def primary_subnet(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "primary_subnet", value)

    @property
    @pulumi.getter(name="additionalSubnets")
    def additional_subnets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Additional subnets may be specified. They may be in another region, but must be in the same VPC network. The Connect workers can communicate with network endpoints in either the primary or additional subnets.
        """
        return pulumi.get(self, "additional_subnets")

    @additional_subnets.setter
    def additional_subnets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "additional_subnets", value)

    @property
    @pulumi.getter(name="dnsDomainNames")
    def dns_domain_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Additional DNS domain names from the subnet's network to be made visible to the Connect Cluster. When using MirrorMaker2, it's necessary to add the bootstrap address's dns domain name of the target cluster to make it visible to the connector. For example: my-kafka-cluster.us-central1.managedkafka.my-project.cloud.goog

        - - -
        """
        return pulumi.get(self, "dns_domain_names")

    @dns_domain_names.setter
    def dns_domain_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "dns_domain_names", value)


if not MYPY:
    class ConnectorTaskRestartPolicyArgsDict(TypedDict):
        maximum_backoff: NotRequired[pulumi.Input[builtins.str]]
        """
        The maximum amount of time to wait before retrying a failed task. This sets an upper bound for the backoff delay.
        A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        minimum_backoff: NotRequired[pulumi.Input[builtins.str]]
        """
        The minimum amount of time to wait before retrying a failed task. This sets a lower bound for the backoff delay.
        A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
elif False:
    ConnectorTaskRestartPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectorTaskRestartPolicyArgs:
    def __init__(__self__, *,
                 maximum_backoff: Optional[pulumi.Input[builtins.str]] = None,
                 minimum_backoff: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] maximum_backoff: The maximum amount of time to wait before retrying a failed task. This sets an upper bound for the backoff delay.
               A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        :param pulumi.Input[builtins.str] minimum_backoff: The minimum amount of time to wait before retrying a failed task. This sets a lower bound for the backoff delay.
               A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        if maximum_backoff is not None:
            pulumi.set(__self__, "maximum_backoff", maximum_backoff)
        if minimum_backoff is not None:
            pulumi.set(__self__, "minimum_backoff", minimum_backoff)

    @property
    @pulumi.getter(name="maximumBackoff")
    def maximum_backoff(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The maximum amount of time to wait before retrying a failed task. This sets an upper bound for the backoff delay.
        A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "maximum_backoff")

    @maximum_backoff.setter
    def maximum_backoff(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "maximum_backoff", value)

    @property
    @pulumi.getter(name="minimumBackoff")
    def minimum_backoff(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The minimum amount of time to wait before retrying a failed task. This sets a lower bound for the backoff delay.
        A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "minimum_backoff")

    @minimum_backoff.setter
    def minimum_backoff(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "minimum_backoff", value)


