# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AclArgs', 'Acl']

@pulumi.input_type
class AclArgs:
    def __init__(__self__, *,
                 acl_entries: pulumi.Input[Sequence[pulumi.Input['AclAclEntryArgs']]],
                 acl_id: pulumi.Input[builtins.str],
                 cluster: pulumi.Input[builtins.str],
                 location: pulumi.Input[builtins.str],
                 project: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Acl resource.
        :param pulumi.Input[Sequence[pulumi.Input['AclAclEntryArgs']]] acl_entries: The acl entries that apply to the resource pattern. The maximum number of allowed entries is 100.
               Structure is documented below.
        :param pulumi.Input[builtins.str] acl_id: The ID to use for the acl, which will become the final component of the acl's name. The structure of `aclId` defines the Resource Pattern (resource_type, resource_name, pattern_type) of the acl. `aclId` is structured like one of the following:
               For acls on the cluster: `cluster`
               For acls on a single resource within the cluster: `topic/{resource_name}` `consumerGroup/{resource_name}` `transactionalId/{resource_name}`
               For acls on all resources that match a prefix: `topicPrefixed/{resource_name}` `consumerGroupPrefixed/{resource_name}` `transactionalIdPrefixed/{resource_name}`
               For acls on all resources of a given type (i.e. the wildcard literal '*''): `allTopics` (represents `topic/*`) `allConsumerGroups` (represents `consumerGroup/*`) `allTransactionalIds` (represents `transactionalId/*`).
        :param pulumi.Input[builtins.str] cluster: The cluster name.
        :param pulumi.Input[builtins.str] location: ID of the location of the Kafka resource. See https://cloud.google.com/managed-kafka/docs/locations for a list of supported locations.
        """
        pulumi.set(__self__, "acl_entries", acl_entries)
        pulumi.set(__self__, "acl_id", acl_id)
        pulumi.set(__self__, "cluster", cluster)
        pulumi.set(__self__, "location", location)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="aclEntries")
    def acl_entries(self) -> pulumi.Input[Sequence[pulumi.Input['AclAclEntryArgs']]]:
        """
        The acl entries that apply to the resource pattern. The maximum number of allowed entries is 100.
        Structure is documented below.
        """
        return pulumi.get(self, "acl_entries")

    @acl_entries.setter
    def acl_entries(self, value: pulumi.Input[Sequence[pulumi.Input['AclAclEntryArgs']]]):
        pulumi.set(self, "acl_entries", value)

    @property
    @pulumi.getter(name="aclId")
    def acl_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID to use for the acl, which will become the final component of the acl's name. The structure of `aclId` defines the Resource Pattern (resource_type, resource_name, pattern_type) of the acl. `aclId` is structured like one of the following:
        For acls on the cluster: `cluster`
        For acls on a single resource within the cluster: `topic/{resource_name}` `consumerGroup/{resource_name}` `transactionalId/{resource_name}`
        For acls on all resources that match a prefix: `topicPrefixed/{resource_name}` `consumerGroupPrefixed/{resource_name}` `transactionalIdPrefixed/{resource_name}`
        For acls on all resources of a given type (i.e. the wildcard literal '*''): `allTopics` (represents `topic/*`) `allConsumerGroups` (represents `consumerGroup/*`) `allTransactionalIds` (represents `transactionalId/*`).
        """
        return pulumi.get(self, "acl_id")

    @acl_id.setter
    def acl_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "acl_id", value)

    @property
    @pulumi.getter
    def cluster(self) -> pulumi.Input[builtins.str]:
        """
        The cluster name.
        """
        return pulumi.get(self, "cluster")

    @cluster.setter
    def cluster(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "cluster", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        ID of the location of the Kafka resource. See https://cloud.google.com/managed-kafka/docs/locations for a list of supported locations.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _AclState:
    def __init__(__self__, *,
                 acl_entries: Optional[pulumi.Input[Sequence[pulumi.Input['AclAclEntryArgs']]]] = None,
                 acl_id: Optional[pulumi.Input[builtins.str]] = None,
                 cluster: Optional[pulumi.Input[builtins.str]] = None,
                 etag: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 pattern_type: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 resource_name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_type: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Acl resources.
        :param pulumi.Input[Sequence[pulumi.Input['AclAclEntryArgs']]] acl_entries: The acl entries that apply to the resource pattern. The maximum number of allowed entries is 100.
               Structure is documented below.
        :param pulumi.Input[builtins.str] acl_id: The ID to use for the acl, which will become the final component of the acl's name. The structure of `aclId` defines the Resource Pattern (resource_type, resource_name, pattern_type) of the acl. `aclId` is structured like one of the following:
               For acls on the cluster: `cluster`
               For acls on a single resource within the cluster: `topic/{resource_name}` `consumerGroup/{resource_name}` `transactionalId/{resource_name}`
               For acls on all resources that match a prefix: `topicPrefixed/{resource_name}` `consumerGroupPrefixed/{resource_name}` `transactionalIdPrefixed/{resource_name}`
               For acls on all resources of a given type (i.e. the wildcard literal '*''): `allTopics` (represents `topic/*`) `allConsumerGroups` (represents `consumerGroup/*`) `allTransactionalIds` (represents `transactionalId/*`).
        :param pulumi.Input[builtins.str] cluster: The cluster name.
        :param pulumi.Input[builtins.str] etag: `etag` is used for concurrency control. An `etag` is returned in the
               response to `GetAcl` and `CreateAcl`. Callers are required to put that etag
               in the request to `UpdateAcl` to ensure that their change will be applied
               to the same version of the acl that exists in the Kafka Cluster.
               A terminal 'T' character in the etag indicates that the AclEntries were
               truncated due to repeated field limits.
        :param pulumi.Input[builtins.str] location: ID of the location of the Kafka resource. See https://cloud.google.com/managed-kafka/docs/locations for a list of supported locations.
        :param pulumi.Input[builtins.str] name: The name of the acl. The `ACL_ID` segment is used when connecting directly to the cluster. Must be in the format `projects/PROJECT_ID/locations/LOCATION/clusters/CLUSTER_ID/acls/ACL_ID`.
        :param pulumi.Input[builtins.str] pattern_type: The acl pattern type derived from the name. One of: LITERAL, PREFIXED.
        :param pulumi.Input[builtins.str] resource_name: The acl resource name derived from the name. For cluster resource_type, this is always "kafka-cluster". Can be the wildcard literal "*".
        :param pulumi.Input[builtins.str] resource_type: The acl resource type derived from the name. One of: CLUSTER, TOPIC, GROUP, TRANSACTIONAL_ID.
        """
        if acl_entries is not None:
            pulumi.set(__self__, "acl_entries", acl_entries)
        if acl_id is not None:
            pulumi.set(__self__, "acl_id", acl_id)
        if cluster is not None:
            pulumi.set(__self__, "cluster", cluster)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if pattern_type is not None:
            pulumi.set(__self__, "pattern_type", pattern_type)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if resource_name is not None:
            pulumi.set(__self__, "resource_name", resource_name)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)

    @property
    @pulumi.getter(name="aclEntries")
    def acl_entries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AclAclEntryArgs']]]]:
        """
        The acl entries that apply to the resource pattern. The maximum number of allowed entries is 100.
        Structure is documented below.
        """
        return pulumi.get(self, "acl_entries")

    @acl_entries.setter
    def acl_entries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AclAclEntryArgs']]]]):
        pulumi.set(self, "acl_entries", value)

    @property
    @pulumi.getter(name="aclId")
    def acl_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID to use for the acl, which will become the final component of the acl's name. The structure of `aclId` defines the Resource Pattern (resource_type, resource_name, pattern_type) of the acl. `aclId` is structured like one of the following:
        For acls on the cluster: `cluster`
        For acls on a single resource within the cluster: `topic/{resource_name}` `consumerGroup/{resource_name}` `transactionalId/{resource_name}`
        For acls on all resources that match a prefix: `topicPrefixed/{resource_name}` `consumerGroupPrefixed/{resource_name}` `transactionalIdPrefixed/{resource_name}`
        For acls on all resources of a given type (i.e. the wildcard literal '*''): `allTopics` (represents `topic/*`) `allConsumerGroups` (represents `consumerGroup/*`) `allTransactionalIds` (represents `transactionalId/*`).
        """
        return pulumi.get(self, "acl_id")

    @acl_id.setter
    def acl_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "acl_id", value)

    @property
    @pulumi.getter
    def cluster(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The cluster name.
        """
        return pulumi.get(self, "cluster")

    @cluster.setter
    def cluster(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cluster", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `etag` is used for concurrency control. An `etag` is returned in the
        response to `GetAcl` and `CreateAcl`. Callers are required to put that etag
        in the request to `UpdateAcl` to ensure that their change will be applied
        to the same version of the acl that exists in the Kafka Cluster.
        A terminal 'T' character in the etag indicates that the AclEntries were
        truncated due to repeated field limits.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID of the location of the Kafka resource. See https://cloud.google.com/managed-kafka/docs/locations for a list of supported locations.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the acl. The `ACL_ID` segment is used when connecting directly to the cluster. Must be in the format `projects/PROJECT_ID/locations/LOCATION/clusters/CLUSTER_ID/acls/ACL_ID`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="patternType")
    def pattern_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The acl pattern type derived from the name. One of: LITERAL, PREFIXED.
        """
        return pulumi.get(self, "pattern_type")

    @pattern_type.setter
    def pattern_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "pattern_type", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The acl resource name derived from the name. For cluster resource_type, this is always "kafka-cluster". Can be the wildcard literal "*".
        """
        return pulumi.get(self, "resource_name")

    @resource_name.setter
    def resource_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_name", value)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The acl resource type derived from the name. One of: CLUSTER, TOPIC, GROUP, TRANSACTIONAL_ID.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_type", value)


@pulumi.type_token("gcp:managedkafka/acl:Acl")
class Acl(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl_entries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AclAclEntryArgs', 'AclAclEntryArgsDict']]]]] = None,
                 acl_id: Optional[pulumi.Input[builtins.str]] = None,
                 cluster: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        A Managed Service for Apache Kafka ACL. Apache Kafka is a trademark owned by the Apache Software Foundation.

        ## Example Usage

        ### Managedkafka Acl Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        cluster = gcp.managedkafka.Cluster("cluster",
            cluster_id="my-cluster",
            location="us-central1",
            capacity_config={
                "vcpu_count": "3",
                "memory_bytes": "3221225472",
            },
            gcp_config={
                "access_config": {
                    "network_configs": [{
                        "subnet": f"projects/{project.number}/regions/us-central1/subnetworks/default",
                    }],
                },
            })
        example = gcp.managedkafka.Acl("example",
            acl_id="topic/mytopic",
            cluster=cluster.cluster_id,
            location="us-central1",
            acl_entries=[
                {
                    "principal": "User:admin@my-project.iam.gserviceaccount.com",
                    "permission_type": "ALLOW",
                    "operation": "ALL",
                    "host": "*",
                },
                {
                    "principal": "User:producer-client@my-project.iam.gserviceaccount.com",
                    "permission_type": "ALLOW",
                    "operation": "WRITE",
                    "host": "*",
                },
            ])
        ```

        ## Import

        Acl can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/clusters/{{cluster}}/acls/{{acl_id}}`

        When using the `pulumi import` command, Acl can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:managedkafka/acl:Acl default projects/{{project}}/locations/{{location}}/clusters/{{cluster}}/acls/{{acl_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AclAclEntryArgs', 'AclAclEntryArgsDict']]]] acl_entries: The acl entries that apply to the resource pattern. The maximum number of allowed entries is 100.
               Structure is documented below.
        :param pulumi.Input[builtins.str] acl_id: The ID to use for the acl, which will become the final component of the acl's name. The structure of `aclId` defines the Resource Pattern (resource_type, resource_name, pattern_type) of the acl. `aclId` is structured like one of the following:
               For acls on the cluster: `cluster`
               For acls on a single resource within the cluster: `topic/{resource_name}` `consumerGroup/{resource_name}` `transactionalId/{resource_name}`
               For acls on all resources that match a prefix: `topicPrefixed/{resource_name}` `consumerGroupPrefixed/{resource_name}` `transactionalIdPrefixed/{resource_name}`
               For acls on all resources of a given type (i.e. the wildcard literal '*''): `allTopics` (represents `topic/*`) `allConsumerGroups` (represents `consumerGroup/*`) `allTransactionalIds` (represents `transactionalId/*`).
        :param pulumi.Input[builtins.str] cluster: The cluster name.
        :param pulumi.Input[builtins.str] location: ID of the location of the Kafka resource. See https://cloud.google.com/managed-kafka/docs/locations for a list of supported locations.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AclArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Managed Service for Apache Kafka ACL. Apache Kafka is a trademark owned by the Apache Software Foundation.

        ## Example Usage

        ### Managedkafka Acl Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        cluster = gcp.managedkafka.Cluster("cluster",
            cluster_id="my-cluster",
            location="us-central1",
            capacity_config={
                "vcpu_count": "3",
                "memory_bytes": "3221225472",
            },
            gcp_config={
                "access_config": {
                    "network_configs": [{
                        "subnet": f"projects/{project.number}/regions/us-central1/subnetworks/default",
                    }],
                },
            })
        example = gcp.managedkafka.Acl("example",
            acl_id="topic/mytopic",
            cluster=cluster.cluster_id,
            location="us-central1",
            acl_entries=[
                {
                    "principal": "User:admin@my-project.iam.gserviceaccount.com",
                    "permission_type": "ALLOW",
                    "operation": "ALL",
                    "host": "*",
                },
                {
                    "principal": "User:producer-client@my-project.iam.gserviceaccount.com",
                    "permission_type": "ALLOW",
                    "operation": "WRITE",
                    "host": "*",
                },
            ])
        ```

        ## Import

        Acl can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/clusters/{{cluster}}/acls/{{acl_id}}`

        When using the `pulumi import` command, Acl can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:managedkafka/acl:Acl default projects/{{project}}/locations/{{location}}/clusters/{{cluster}}/acls/{{acl_id}}
        ```

        :param str resource_name: The name of the resource.
        :param AclArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AclArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl_entries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AclAclEntryArgs', 'AclAclEntryArgsDict']]]]] = None,
                 acl_id: Optional[pulumi.Input[builtins.str]] = None,
                 cluster: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AclArgs.__new__(AclArgs)

            if acl_entries is None and not opts.urn:
                raise TypeError("Missing required property 'acl_entries'")
            __props__.__dict__["acl_entries"] = acl_entries
            if acl_id is None and not opts.urn:
                raise TypeError("Missing required property 'acl_id'")
            __props__.__dict__["acl_id"] = acl_id
            if cluster is None and not opts.urn:
                raise TypeError("Missing required property 'cluster'")
            __props__.__dict__["cluster"] = cluster
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            __props__.__dict__["etag"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["pattern_type"] = None
            __props__.__dict__["resource_name"] = None
            __props__.__dict__["resource_type"] = None
        super(Acl, __self__).__init__(
            'gcp:managedkafka/acl:Acl',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            acl_entries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AclAclEntryArgs', 'AclAclEntryArgsDict']]]]] = None,
            acl_id: Optional[pulumi.Input[builtins.str]] = None,
            cluster: Optional[pulumi.Input[builtins.str]] = None,
            etag: Optional[pulumi.Input[builtins.str]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            pattern_type: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            resource_name_: Optional[pulumi.Input[builtins.str]] = None,
            resource_type: Optional[pulumi.Input[builtins.str]] = None) -> 'Acl':
        """
        Get an existing Acl resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AclAclEntryArgs', 'AclAclEntryArgsDict']]]] acl_entries: The acl entries that apply to the resource pattern. The maximum number of allowed entries is 100.
               Structure is documented below.
        :param pulumi.Input[builtins.str] acl_id: The ID to use for the acl, which will become the final component of the acl's name. The structure of `aclId` defines the Resource Pattern (resource_type, resource_name, pattern_type) of the acl. `aclId` is structured like one of the following:
               For acls on the cluster: `cluster`
               For acls on a single resource within the cluster: `topic/{resource_name}` `consumerGroup/{resource_name}` `transactionalId/{resource_name}`
               For acls on all resources that match a prefix: `topicPrefixed/{resource_name}` `consumerGroupPrefixed/{resource_name}` `transactionalIdPrefixed/{resource_name}`
               For acls on all resources of a given type (i.e. the wildcard literal '*''): `allTopics` (represents `topic/*`) `allConsumerGroups` (represents `consumerGroup/*`) `allTransactionalIds` (represents `transactionalId/*`).
        :param pulumi.Input[builtins.str] cluster: The cluster name.
        :param pulumi.Input[builtins.str] etag: `etag` is used for concurrency control. An `etag` is returned in the
               response to `GetAcl` and `CreateAcl`. Callers are required to put that etag
               in the request to `UpdateAcl` to ensure that their change will be applied
               to the same version of the acl that exists in the Kafka Cluster.
               A terminal 'T' character in the etag indicates that the AclEntries were
               truncated due to repeated field limits.
        :param pulumi.Input[builtins.str] location: ID of the location of the Kafka resource. See https://cloud.google.com/managed-kafka/docs/locations for a list of supported locations.
        :param pulumi.Input[builtins.str] name: The name of the acl. The `ACL_ID` segment is used when connecting directly to the cluster. Must be in the format `projects/PROJECT_ID/locations/LOCATION/clusters/CLUSTER_ID/acls/ACL_ID`.
        :param pulumi.Input[builtins.str] pattern_type: The acl pattern type derived from the name. One of: LITERAL, PREFIXED.
        :param pulumi.Input[builtins.str] resource_name_: The acl resource name derived from the name. For cluster resource_type, this is always "kafka-cluster". Can be the wildcard literal "*".
        :param pulumi.Input[builtins.str] resource_type: The acl resource type derived from the name. One of: CLUSTER, TOPIC, GROUP, TRANSACTIONAL_ID.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AclState.__new__(_AclState)

        __props__.__dict__["acl_entries"] = acl_entries
        __props__.__dict__["acl_id"] = acl_id
        __props__.__dict__["cluster"] = cluster
        __props__.__dict__["etag"] = etag
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["pattern_type"] = pattern_type
        __props__.__dict__["project"] = project
        __props__.__dict__["resource_name"] = resource_name_
        __props__.__dict__["resource_type"] = resource_type
        return Acl(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="aclEntries")
    def acl_entries(self) -> pulumi.Output[Sequence['outputs.AclAclEntry']]:
        """
        The acl entries that apply to the resource pattern. The maximum number of allowed entries is 100.
        Structure is documented below.
        """
        return pulumi.get(self, "acl_entries")

    @property
    @pulumi.getter(name="aclId")
    def acl_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID to use for the acl, which will become the final component of the acl's name. The structure of `aclId` defines the Resource Pattern (resource_type, resource_name, pattern_type) of the acl. `aclId` is structured like one of the following:
        For acls on the cluster: `cluster`
        For acls on a single resource within the cluster: `topic/{resource_name}` `consumerGroup/{resource_name}` `transactionalId/{resource_name}`
        For acls on all resources that match a prefix: `topicPrefixed/{resource_name}` `consumerGroupPrefixed/{resource_name}` `transactionalIdPrefixed/{resource_name}`
        For acls on all resources of a given type (i.e. the wildcard literal '*''): `allTopics` (represents `topic/*`) `allConsumerGroups` (represents `consumerGroup/*`) `allTransactionalIds` (represents `transactionalId/*`).
        """
        return pulumi.get(self, "acl_id")

    @property
    @pulumi.getter
    def cluster(self) -> pulumi.Output[builtins.str]:
        """
        The cluster name.
        """
        return pulumi.get(self, "cluster")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[builtins.str]:
        """
        `etag` is used for concurrency control. An `etag` is returned in the
        response to `GetAcl` and `CreateAcl`. Callers are required to put that etag
        in the request to `UpdateAcl` to ensure that their change will be applied
        to the same version of the acl that exists in the Kafka Cluster.
        A terminal 'T' character in the etag indicates that the AclEntries were
        truncated due to repeated field limits.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        ID of the location of the Kafka resource. See https://cloud.google.com/managed-kafka/docs/locations for a list of supported locations.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the acl. The `ACL_ID` segment is used when connecting directly to the cluster. Must be in the format `projects/PROJECT_ID/locations/LOCATION/clusters/CLUSTER_ID/acls/ACL_ID`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="patternType")
    def pattern_type(self) -> pulumi.Output[builtins.str]:
        """
        The acl pattern type derived from the name. One of: LITERAL, PREFIXED.
        """
        return pulumi.get(self, "pattern_type")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> pulumi.Output[builtins.str]:
        """
        The acl resource name derived from the name. For cluster resource_type, this is always "kafka-cluster". Can be the wildcard literal "*".
        """
        return pulumi.get(self, "resource_name")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Output[builtins.str]:
        """
        The acl resource type derived from the name. One of: CLUSTER, TOPIC, GROUP, TRANSACTIONAL_ID.
        """
        return pulumi.get(self, "resource_type")

