# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ConnectClusterArgs', 'ConnectCluster']

@pulumi.input_type
class ConnectClusterArgs:
    def __init__(__self__, *,
                 capacity_config: pulumi.Input['ConnectClusterCapacityConfigArgs'],
                 connect_cluster_id: pulumi.Input[builtins.str],
                 gcp_config: pulumi.Input['ConnectClusterGcpConfigArgs'],
                 kafka_cluster: pulumi.Input[builtins.str],
                 location: pulumi.Input[builtins.str],
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a ConnectCluster resource.
        :param pulumi.Input['ConnectClusterCapacityConfigArgs'] capacity_config: A capacity configuration of a Kafka cluster.
               Structure is documented below.
        :param pulumi.Input[builtins.str] connect_cluster_id: The ID to use for the Connect Cluster, which will become the final component of the connect cluster's name. This value is structured like: `my-connect-cluster-id`.
        :param pulumi.Input['ConnectClusterGcpConfigArgs'] gcp_config: Configuration properties for a Kafka Connect cluster deployed to Google Cloud Platform.
               Structure is documented below.
        :param pulumi.Input[builtins.str] kafka_cluster: The name of the Kafka cluster this Kafka Connect cluster is attached to. Structured like: `projects/PROJECT_ID/locations/LOCATION/clusters/CLUSTER_ID`.
        :param pulumi.Input[builtins.str] location: ID of the location of the Kafka Connect resource. See https://cloud.google.com/managed-kafka/docs/locations for a list of supported locations.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: List of label KEY=VALUE pairs to add. Keys must start with a lowercase character and contain only hyphens (-),
               underscores ( ), lowercase characters, and numbers. Values must contain only hyphens (-), underscores ( ), lowercase
               characters, and numbers. **Note**: This field is non-authoritative, and will only manage the labels present in your
               configuration. Please refer to the field 'effective_labels' for all of the labels present on the resource.
        """
        pulumi.set(__self__, "capacity_config", capacity_config)
        pulumi.set(__self__, "connect_cluster_id", connect_cluster_id)
        pulumi.set(__self__, "gcp_config", gcp_config)
        pulumi.set(__self__, "kafka_cluster", kafka_cluster)
        pulumi.set(__self__, "location", location)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="capacityConfig")
    def capacity_config(self) -> pulumi.Input['ConnectClusterCapacityConfigArgs']:
        """
        A capacity configuration of a Kafka cluster.
        Structure is documented below.
        """
        return pulumi.get(self, "capacity_config")

    @capacity_config.setter
    def capacity_config(self, value: pulumi.Input['ConnectClusterCapacityConfigArgs']):
        pulumi.set(self, "capacity_config", value)

    @property
    @pulumi.getter(name="connectClusterId")
    def connect_cluster_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID to use for the Connect Cluster, which will become the final component of the connect cluster's name. This value is structured like: `my-connect-cluster-id`.
        """
        return pulumi.get(self, "connect_cluster_id")

    @connect_cluster_id.setter
    def connect_cluster_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "connect_cluster_id", value)

    @property
    @pulumi.getter(name="gcpConfig")
    def gcp_config(self) -> pulumi.Input['ConnectClusterGcpConfigArgs']:
        """
        Configuration properties for a Kafka Connect cluster deployed to Google Cloud Platform.
        Structure is documented below.
        """
        return pulumi.get(self, "gcp_config")

    @gcp_config.setter
    def gcp_config(self, value: pulumi.Input['ConnectClusterGcpConfigArgs']):
        pulumi.set(self, "gcp_config", value)

    @property
    @pulumi.getter(name="kafkaCluster")
    def kafka_cluster(self) -> pulumi.Input[builtins.str]:
        """
        The name of the Kafka cluster this Kafka Connect cluster is attached to. Structured like: `projects/PROJECT_ID/locations/LOCATION/clusters/CLUSTER_ID`.
        """
        return pulumi.get(self, "kafka_cluster")

    @kafka_cluster.setter
    def kafka_cluster(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "kafka_cluster", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        ID of the location of the Kafka Connect resource. See https://cloud.google.com/managed-kafka/docs/locations for a list of supported locations.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        List of label KEY=VALUE pairs to add. Keys must start with a lowercase character and contain only hyphens (-),
        underscores ( ), lowercase characters, and numbers. Values must contain only hyphens (-), underscores ( ), lowercase
        characters, and numbers. **Note**: This field is non-authoritative, and will only manage the labels present in your
        configuration. Please refer to the field 'effective_labels' for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _ConnectClusterState:
    def __init__(__self__, *,
                 capacity_config: Optional[pulumi.Input['ConnectClusterCapacityConfigArgs']] = None,
                 connect_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 gcp_config: Optional[pulumi.Input['ConnectClusterGcpConfigArgs']] = None,
                 kafka_cluster: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ConnectCluster resources.
        :param pulumi.Input['ConnectClusterCapacityConfigArgs'] capacity_config: A capacity configuration of a Kafka cluster.
               Structure is documented below.
        :param pulumi.Input[builtins.str] connect_cluster_id: The ID to use for the Connect Cluster, which will become the final component of the connect cluster's name. This value is structured like: `my-connect-cluster-id`.
        :param pulumi.Input[builtins.str] create_time: The time when the cluster was created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input['ConnectClusterGcpConfigArgs'] gcp_config: Configuration properties for a Kafka Connect cluster deployed to Google Cloud Platform.
               Structure is documented below.
        :param pulumi.Input[builtins.str] kafka_cluster: The name of the Kafka cluster this Kafka Connect cluster is attached to. Structured like: `projects/PROJECT_ID/locations/LOCATION/clusters/CLUSTER_ID`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: List of label KEY=VALUE pairs to add. Keys must start with a lowercase character and contain only hyphens (-),
               underscores ( ), lowercase characters, and numbers. Values must contain only hyphens (-), underscores ( ), lowercase
               characters, and numbers. **Note**: This field is non-authoritative, and will only manage the labels present in your
               configuration. Please refer to the field 'effective_labels' for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: ID of the location of the Kafka Connect resource. See https://cloud.google.com/managed-kafka/docs/locations for a list of supported locations.
        :param pulumi.Input[builtins.str] name: The name of the connect cluster. Structured like: `projects/PROJECT_ID/locations/LOCATION/connectClusters/CONNECT_CLUSTER_ID`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.str] state: The current state of the connect cluster. Possible values: `STATE_UNSPECIFIED`, `CREATING`, `ACTIVE`, `DELETING`.
        :param pulumi.Input[builtins.str] update_time: The time when the cluster was last updated.
        """
        if capacity_config is not None:
            pulumi.set(__self__, "capacity_config", capacity_config)
        if connect_cluster_id is not None:
            pulumi.set(__self__, "connect_cluster_id", connect_cluster_id)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if gcp_config is not None:
            pulumi.set(__self__, "gcp_config", gcp_config)
        if kafka_cluster is not None:
            pulumi.set(__self__, "kafka_cluster", kafka_cluster)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="capacityConfig")
    def capacity_config(self) -> Optional[pulumi.Input['ConnectClusterCapacityConfigArgs']]:
        """
        A capacity configuration of a Kafka cluster.
        Structure is documented below.
        """
        return pulumi.get(self, "capacity_config")

    @capacity_config.setter
    def capacity_config(self, value: Optional[pulumi.Input['ConnectClusterCapacityConfigArgs']]):
        pulumi.set(self, "capacity_config", value)

    @property
    @pulumi.getter(name="connectClusterId")
    def connect_cluster_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID to use for the Connect Cluster, which will become the final component of the connect cluster's name. This value is structured like: `my-connect-cluster-id`.
        """
        return pulumi.get(self, "connect_cluster_id")

    @connect_cluster_id.setter
    def connect_cluster_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "connect_cluster_id", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time when the cluster was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter(name="gcpConfig")
    def gcp_config(self) -> Optional[pulumi.Input['ConnectClusterGcpConfigArgs']]:
        """
        Configuration properties for a Kafka Connect cluster deployed to Google Cloud Platform.
        Structure is documented below.
        """
        return pulumi.get(self, "gcp_config")

    @gcp_config.setter
    def gcp_config(self, value: Optional[pulumi.Input['ConnectClusterGcpConfigArgs']]):
        pulumi.set(self, "gcp_config", value)

    @property
    @pulumi.getter(name="kafkaCluster")
    def kafka_cluster(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Kafka cluster this Kafka Connect cluster is attached to. Structured like: `projects/PROJECT_ID/locations/LOCATION/clusters/CLUSTER_ID`.
        """
        return pulumi.get(self, "kafka_cluster")

    @kafka_cluster.setter
    def kafka_cluster(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kafka_cluster", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        List of label KEY=VALUE pairs to add. Keys must start with a lowercase character and contain only hyphens (-),
        underscores ( ), lowercase characters, and numbers. Values must contain only hyphens (-), underscores ( ), lowercase
        characters, and numbers. **Note**: This field is non-authoritative, and will only manage the labels present in your
        configuration. Please refer to the field 'effective_labels' for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID of the location of the Kafka Connect resource. See https://cloud.google.com/managed-kafka/docs/locations for a list of supported locations.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the connect cluster. Structured like: `projects/PROJECT_ID/locations/LOCATION/connectClusters/CONNECT_CLUSTER_ID`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current state of the connect cluster. Possible values: `STATE_UNSPECIFIED`, `CREATING`, `ACTIVE`, `DELETING`.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time when the cluster was last updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:managedkafka/connectCluster:ConnectCluster")
class ConnectCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 capacity_config: Optional[pulumi.Input[Union['ConnectClusterCapacityConfigArgs', 'ConnectClusterCapacityConfigArgsDict']]] = None,
                 connect_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                 gcp_config: Optional[pulumi.Input[Union['ConnectClusterGcpConfigArgs', 'ConnectClusterGcpConfigArgsDict']]] = None,
                 kafka_cluster: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ### Managedkafka Connect Cluster Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_time as time

        project = gcp.organizations.Project("project",
            project_id="tf-test_62793",
            name="tf-test_55438",
            org_id="123456789",
            billing_account="000000-0000000-0000000-000000",
            deletion_policy="DELETE")
        wait60_seconds = time.index.Sleep("wait_60_seconds", create_duration=60s,
        opts = pulumi.ResourceOptions(depends_on=[project]))
        compute = gcp.projects.Service("compute",
            project=project.project_id,
            service="compute.googleapis.com",
            opts = pulumi.ResourceOptions(depends_on=[wait60_seconds]))
        managedkafka = gcp.projects.Service("managedkafka",
            project=project.project_id,
            service="managedkafka.googleapis.com",
            opts = pulumi.ResourceOptions(depends_on=[compute]))
        wait120_seconds = time.index.Sleep("wait_120_seconds", create_duration=120s,
        opts = pulumi.ResourceOptions(depends_on=[managedkafka]))
        mkc_secondary_subnet = gcp.compute.Subnetwork("mkc_secondary_subnet",
            project=project.project_id,
            name="my-secondary-subnetwork",
            ip_cidr_range="10.3.0.0/16",
            region="us-central1",
            network="default",
            opts = pulumi.ResourceOptions(depends_on=[wait120_seconds]))
        gmk_cluster = gcp.managedkafka.Cluster("gmk_cluster",
            project=project.project_id,
            cluster_id="my-cluster",
            location="us-central1",
            capacity_config={
                "vcpu_count": "3",
                "memory_bytes": "3221225472",
            },
            gcp_config={
                "access_config": {
                    "network_configs": [{
                        "subnet": project.project_id.apply(lambda project_id: f"projects/{project_id}/regions/us-central1/subnetworks/default"),
                    }],
                },
            },
            opts = pulumi.ResourceOptions(depends_on=[managedkafka]))
        example = gcp.managedkafka.ConnectCluster("example",
            project=project.project_id,
            connect_cluster_id="my-connect-cluster",
            kafka_cluster=pulumi.Output.all(
                project_id=project.project_id,
                cluster_id=gmk_cluster.cluster_id
        ).apply(lambda resolved_outputs: f"projects/{resolved_outputs['project_id']}/locations/us-central1/clusters/{resolved_outputs['cluster_id']}")
        ,
            location="us-central1",
            capacity_config={
                "vcpu_count": "12",
                "memory_bytes": "21474836480",
            },
            gcp_config={
                "access_config": {
                    "network_configs": [{
                        "primary_subnet": project.project_id.apply(lambda project_id: f"projects/{project_id}/regions/us-central1/subnetworks/default"),
                        "additional_subnets": [mkc_secondary_subnet.id],
                        "dns_domain_names": [pulumi.Output.all(
                            cluster_id=gmk_cluster.cluster_id,
                            project_id=project.project_id
        ).apply(lambda resolved_outputs: f"{resolved_outputs['cluster_id']}.us-central1.managedkafka.{resolved_outputs['project_id']}.cloud.goog")
        ],
                    }],
                },
            },
            labels={
                "key": "value",
            },
            opts = pulumi.ResourceOptions(depends_on=[managedkafka]))
        ```

        ## Import

        ConnectCluster can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/connectClusters/{{connect_cluster_id}}`

        * `{{project}}/{{location}}/{{connect_cluster_id}}`

        * `{{location}}/{{connect_cluster_id}}`

        When using the `pulumi import` command, ConnectCluster can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:managedkafka/connectCluster:ConnectCluster default projects/{{project}}/locations/{{location}}/connectClusters/{{connect_cluster_id}}
        ```

        ```sh
        $ pulumi import gcp:managedkafka/connectCluster:ConnectCluster default {{project}}/{{location}}/{{connect_cluster_id}}
        ```

        ```sh
        $ pulumi import gcp:managedkafka/connectCluster:ConnectCluster default {{location}}/{{connect_cluster_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ConnectClusterCapacityConfigArgs', 'ConnectClusterCapacityConfigArgsDict']] capacity_config: A capacity configuration of a Kafka cluster.
               Structure is documented below.
        :param pulumi.Input[builtins.str] connect_cluster_id: The ID to use for the Connect Cluster, which will become the final component of the connect cluster's name. This value is structured like: `my-connect-cluster-id`.
        :param pulumi.Input[Union['ConnectClusterGcpConfigArgs', 'ConnectClusterGcpConfigArgsDict']] gcp_config: Configuration properties for a Kafka Connect cluster deployed to Google Cloud Platform.
               Structure is documented below.
        :param pulumi.Input[builtins.str] kafka_cluster: The name of the Kafka cluster this Kafka Connect cluster is attached to. Structured like: `projects/PROJECT_ID/locations/LOCATION/clusters/CLUSTER_ID`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: List of label KEY=VALUE pairs to add. Keys must start with a lowercase character and contain only hyphens (-),
               underscores ( ), lowercase characters, and numbers. Values must contain only hyphens (-), underscores ( ), lowercase
               characters, and numbers. **Note**: This field is non-authoritative, and will only manage the labels present in your
               configuration. Please refer to the field 'effective_labels' for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: ID of the location of the Kafka Connect resource. See https://cloud.google.com/managed-kafka/docs/locations for a list of supported locations.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConnectClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ### Managedkafka Connect Cluster Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_time as time

        project = gcp.organizations.Project("project",
            project_id="tf-test_62793",
            name="tf-test_55438",
            org_id="123456789",
            billing_account="000000-0000000-0000000-000000",
            deletion_policy="DELETE")
        wait60_seconds = time.index.Sleep("wait_60_seconds", create_duration=60s,
        opts = pulumi.ResourceOptions(depends_on=[project]))
        compute = gcp.projects.Service("compute",
            project=project.project_id,
            service="compute.googleapis.com",
            opts = pulumi.ResourceOptions(depends_on=[wait60_seconds]))
        managedkafka = gcp.projects.Service("managedkafka",
            project=project.project_id,
            service="managedkafka.googleapis.com",
            opts = pulumi.ResourceOptions(depends_on=[compute]))
        wait120_seconds = time.index.Sleep("wait_120_seconds", create_duration=120s,
        opts = pulumi.ResourceOptions(depends_on=[managedkafka]))
        mkc_secondary_subnet = gcp.compute.Subnetwork("mkc_secondary_subnet",
            project=project.project_id,
            name="my-secondary-subnetwork",
            ip_cidr_range="10.3.0.0/16",
            region="us-central1",
            network="default",
            opts = pulumi.ResourceOptions(depends_on=[wait120_seconds]))
        gmk_cluster = gcp.managedkafka.Cluster("gmk_cluster",
            project=project.project_id,
            cluster_id="my-cluster",
            location="us-central1",
            capacity_config={
                "vcpu_count": "3",
                "memory_bytes": "3221225472",
            },
            gcp_config={
                "access_config": {
                    "network_configs": [{
                        "subnet": project.project_id.apply(lambda project_id: f"projects/{project_id}/regions/us-central1/subnetworks/default"),
                    }],
                },
            },
            opts = pulumi.ResourceOptions(depends_on=[managedkafka]))
        example = gcp.managedkafka.ConnectCluster("example",
            project=project.project_id,
            connect_cluster_id="my-connect-cluster",
            kafka_cluster=pulumi.Output.all(
                project_id=project.project_id,
                cluster_id=gmk_cluster.cluster_id
        ).apply(lambda resolved_outputs: f"projects/{resolved_outputs['project_id']}/locations/us-central1/clusters/{resolved_outputs['cluster_id']}")
        ,
            location="us-central1",
            capacity_config={
                "vcpu_count": "12",
                "memory_bytes": "21474836480",
            },
            gcp_config={
                "access_config": {
                    "network_configs": [{
                        "primary_subnet": project.project_id.apply(lambda project_id: f"projects/{project_id}/regions/us-central1/subnetworks/default"),
                        "additional_subnets": [mkc_secondary_subnet.id],
                        "dns_domain_names": [pulumi.Output.all(
                            cluster_id=gmk_cluster.cluster_id,
                            project_id=project.project_id
        ).apply(lambda resolved_outputs: f"{resolved_outputs['cluster_id']}.us-central1.managedkafka.{resolved_outputs['project_id']}.cloud.goog")
        ],
                    }],
                },
            },
            labels={
                "key": "value",
            },
            opts = pulumi.ResourceOptions(depends_on=[managedkafka]))
        ```

        ## Import

        ConnectCluster can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/connectClusters/{{connect_cluster_id}}`

        * `{{project}}/{{location}}/{{connect_cluster_id}}`

        * `{{location}}/{{connect_cluster_id}}`

        When using the `pulumi import` command, ConnectCluster can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:managedkafka/connectCluster:ConnectCluster default projects/{{project}}/locations/{{location}}/connectClusters/{{connect_cluster_id}}
        ```

        ```sh
        $ pulumi import gcp:managedkafka/connectCluster:ConnectCluster default {{project}}/{{location}}/{{connect_cluster_id}}
        ```

        ```sh
        $ pulumi import gcp:managedkafka/connectCluster:ConnectCluster default {{location}}/{{connect_cluster_id}}
        ```

        :param str resource_name: The name of the resource.
        :param ConnectClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConnectClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 capacity_config: Optional[pulumi.Input[Union['ConnectClusterCapacityConfigArgs', 'ConnectClusterCapacityConfigArgsDict']]] = None,
                 connect_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                 gcp_config: Optional[pulumi.Input[Union['ConnectClusterGcpConfigArgs', 'ConnectClusterGcpConfigArgsDict']]] = None,
                 kafka_cluster: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConnectClusterArgs.__new__(ConnectClusterArgs)

            if capacity_config is None and not opts.urn:
                raise TypeError("Missing required property 'capacity_config'")
            __props__.__dict__["capacity_config"] = capacity_config
            if connect_cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'connect_cluster_id'")
            __props__.__dict__["connect_cluster_id"] = connect_cluster_id
            if gcp_config is None and not opts.urn:
                raise TypeError("Missing required property 'gcp_config'")
            __props__.__dict__["gcp_config"] = gcp_config
            if kafka_cluster is None and not opts.urn:
                raise TypeError("Missing required property 'kafka_cluster'")
            __props__.__dict__["kafka_cluster"] = kafka_cluster
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ConnectCluster, __self__).__init__(
            'gcp:managedkafka/connectCluster:ConnectCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            capacity_config: Optional[pulumi.Input[Union['ConnectClusterCapacityConfigArgs', 'ConnectClusterCapacityConfigArgsDict']]] = None,
            connect_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            gcp_config: Optional[pulumi.Input[Union['ConnectClusterGcpConfigArgs', 'ConnectClusterGcpConfigArgsDict']]] = None,
            kafka_cluster: Optional[pulumi.Input[builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None) -> 'ConnectCluster':
        """
        Get an existing ConnectCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ConnectClusterCapacityConfigArgs', 'ConnectClusterCapacityConfigArgsDict']] capacity_config: A capacity configuration of a Kafka cluster.
               Structure is documented below.
        :param pulumi.Input[builtins.str] connect_cluster_id: The ID to use for the Connect Cluster, which will become the final component of the connect cluster's name. This value is structured like: `my-connect-cluster-id`.
        :param pulumi.Input[builtins.str] create_time: The time when the cluster was created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Union['ConnectClusterGcpConfigArgs', 'ConnectClusterGcpConfigArgsDict']] gcp_config: Configuration properties for a Kafka Connect cluster deployed to Google Cloud Platform.
               Structure is documented below.
        :param pulumi.Input[builtins.str] kafka_cluster: The name of the Kafka cluster this Kafka Connect cluster is attached to. Structured like: `projects/PROJECT_ID/locations/LOCATION/clusters/CLUSTER_ID`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: List of label KEY=VALUE pairs to add. Keys must start with a lowercase character and contain only hyphens (-),
               underscores ( ), lowercase characters, and numbers. Values must contain only hyphens (-), underscores ( ), lowercase
               characters, and numbers. **Note**: This field is non-authoritative, and will only manage the labels present in your
               configuration. Please refer to the field 'effective_labels' for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: ID of the location of the Kafka Connect resource. See https://cloud.google.com/managed-kafka/docs/locations for a list of supported locations.
        :param pulumi.Input[builtins.str] name: The name of the connect cluster. Structured like: `projects/PROJECT_ID/locations/LOCATION/connectClusters/CONNECT_CLUSTER_ID`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.str] state: The current state of the connect cluster. Possible values: `STATE_UNSPECIFIED`, `CREATING`, `ACTIVE`, `DELETING`.
        :param pulumi.Input[builtins.str] update_time: The time when the cluster was last updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConnectClusterState.__new__(_ConnectClusterState)

        __props__.__dict__["capacity_config"] = capacity_config
        __props__.__dict__["connect_cluster_id"] = connect_cluster_id
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["gcp_config"] = gcp_config
        __props__.__dict__["kafka_cluster"] = kafka_cluster
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["state"] = state
        __props__.__dict__["update_time"] = update_time
        return ConnectCluster(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="capacityConfig")
    def capacity_config(self) -> pulumi.Output['outputs.ConnectClusterCapacityConfig']:
        """
        A capacity configuration of a Kafka cluster.
        Structure is documented below.
        """
        return pulumi.get(self, "capacity_config")

    @property
    @pulumi.getter(name="connectClusterId")
    def connect_cluster_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID to use for the Connect Cluster, which will become the final component of the connect cluster's name. This value is structured like: `my-connect-cluster-id`.
        """
        return pulumi.get(self, "connect_cluster_id")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        The time when the cluster was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter(name="gcpConfig")
    def gcp_config(self) -> pulumi.Output['outputs.ConnectClusterGcpConfig']:
        """
        Configuration properties for a Kafka Connect cluster deployed to Google Cloud Platform.
        Structure is documented below.
        """
        return pulumi.get(self, "gcp_config")

    @property
    @pulumi.getter(name="kafkaCluster")
    def kafka_cluster(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Kafka cluster this Kafka Connect cluster is attached to. Structured like: `projects/PROJECT_ID/locations/LOCATION/clusters/CLUSTER_ID`.
        """
        return pulumi.get(self, "kafka_cluster")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        List of label KEY=VALUE pairs to add. Keys must start with a lowercase character and contain only hyphens (-),
        underscores ( ), lowercase characters, and numbers. Values must contain only hyphens (-), underscores ( ), lowercase
        characters, and numbers. **Note**: This field is non-authoritative, and will only manage the labels present in your
        configuration. Please refer to the field 'effective_labels' for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        ID of the location of the Kafka Connect resource. See https://cloud.google.com/managed-kafka/docs/locations for a list of supported locations.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the connect cluster. Structured like: `projects/PROJECT_ID/locations/LOCATION/connectClusters/CONNECT_CLUSTER_ID`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current state of the connect cluster. Possible values: `STATE_UNSPECIFIED`, `CREATING`, `ACTIVE`, `DELETING`.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        The time when the cluster was last updated.
        """
        return pulumi.get(self, "update_time")

