# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EngineModelArgs', 'EngineModel']

@pulumi.input_type
class EngineModelArgs:
    def __init__(__self__, *,
                 default_version: Optional[pulumi.Input['EngineModelDefaultVersionArgs']] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 online_prediction_console_logging: Optional[pulumi.Input[builtins.bool]] = None,
                 online_prediction_logging: Optional[pulumi.Input[builtins.bool]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 regions: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a EngineModel resource.
        :param pulumi.Input['EngineModelDefaultVersionArgs'] default_version: The default version of the model. This version will be used to handle
               prediction requests that do not specify a version.
               Structure is documented below.
        :param pulumi.Input[builtins.str] description: The description specified for the model when it was created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: One or more labels that you can add, to organize your models.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] name: The name specified for the model.
               
               
               - - -
        :param pulumi.Input[builtins.bool] online_prediction_console_logging: If true, online prediction nodes send stderr and stdout streams to Stackdriver Logging
        :param pulumi.Input[builtins.bool] online_prediction_logging: If true, online prediction access logs are sent to StackDriver Logging.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] regions: The list of regions where the model is going to be deployed.
               Currently only one region per model is supported
        """
        if default_version is not None:
            pulumi.set(__self__, "default_version", default_version)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if online_prediction_console_logging is not None:
            pulumi.set(__self__, "online_prediction_console_logging", online_prediction_console_logging)
        if online_prediction_logging is not None:
            pulumi.set(__self__, "online_prediction_logging", online_prediction_logging)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if regions is not None:
            pulumi.set(__self__, "regions", regions)

    @property
    @pulumi.getter(name="defaultVersion")
    def default_version(self) -> Optional[pulumi.Input['EngineModelDefaultVersionArgs']]:
        """
        The default version of the model. This version will be used to handle
        prediction requests that do not specify a version.
        Structure is documented below.
        """
        return pulumi.get(self, "default_version")

    @default_version.setter
    def default_version(self, value: Optional[pulumi.Input['EngineModelDefaultVersionArgs']]):
        pulumi.set(self, "default_version", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description specified for the model when it was created.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        One or more labels that you can add, to organize your models.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name specified for the model.


        - - -
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="onlinePredictionConsoleLogging")
    def online_prediction_console_logging(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If true, online prediction nodes send stderr and stdout streams to Stackdriver Logging
        """
        return pulumi.get(self, "online_prediction_console_logging")

    @online_prediction_console_logging.setter
    def online_prediction_console_logging(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "online_prediction_console_logging", value)

    @property
    @pulumi.getter(name="onlinePredictionLogging")
    def online_prediction_logging(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If true, online prediction access logs are sent to StackDriver Logging.
        """
        return pulumi.get(self, "online_prediction_logging")

    @online_prediction_logging.setter
    def online_prediction_logging(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "online_prediction_logging", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def regions(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The list of regions where the model is going to be deployed.
        Currently only one region per model is supported
        """
        return pulumi.get(self, "regions")

    @regions.setter
    def regions(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "regions", value)


@pulumi.input_type
class _EngineModelState:
    def __init__(__self__, *,
                 default_version: Optional[pulumi.Input['EngineModelDefaultVersionArgs']] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 online_prediction_console_logging: Optional[pulumi.Input[builtins.bool]] = None,
                 online_prediction_logging: Optional[pulumi.Input[builtins.bool]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 regions: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering EngineModel resources.
        :param pulumi.Input['EngineModelDefaultVersionArgs'] default_version: The default version of the model. This version will be used to handle
               prediction requests that do not specify a version.
               Structure is documented below.
        :param pulumi.Input[builtins.str] description: The description specified for the model when it was created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: One or more labels that you can add, to organize your models.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] name: The name specified for the model.
               
               
               - - -
        :param pulumi.Input[builtins.bool] online_prediction_console_logging: If true, online prediction nodes send stderr and stdout streams to Stackdriver Logging
        :param pulumi.Input[builtins.bool] online_prediction_logging: If true, online prediction access logs are sent to StackDriver Logging.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.str] regions: The list of regions where the model is going to be deployed.
               Currently only one region per model is supported
        """
        if default_version is not None:
            pulumi.set(__self__, "default_version", default_version)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if online_prediction_console_logging is not None:
            pulumi.set(__self__, "online_prediction_console_logging", online_prediction_console_logging)
        if online_prediction_logging is not None:
            pulumi.set(__self__, "online_prediction_logging", online_prediction_logging)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if regions is not None:
            pulumi.set(__self__, "regions", regions)

    @property
    @pulumi.getter(name="defaultVersion")
    def default_version(self) -> Optional[pulumi.Input['EngineModelDefaultVersionArgs']]:
        """
        The default version of the model. This version will be used to handle
        prediction requests that do not specify a version.
        Structure is documented below.
        """
        return pulumi.get(self, "default_version")

    @default_version.setter
    def default_version(self, value: Optional[pulumi.Input['EngineModelDefaultVersionArgs']]):
        pulumi.set(self, "default_version", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description specified for the model when it was created.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        One or more labels that you can add, to organize your models.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name specified for the model.


        - - -
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="onlinePredictionConsoleLogging")
    def online_prediction_console_logging(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If true, online prediction nodes send stderr and stdout streams to Stackdriver Logging
        """
        return pulumi.get(self, "online_prediction_console_logging")

    @online_prediction_console_logging.setter
    def online_prediction_console_logging(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "online_prediction_console_logging", value)

    @property
    @pulumi.getter(name="onlinePredictionLogging")
    def online_prediction_logging(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If true, online prediction access logs are sent to StackDriver Logging.
        """
        return pulumi.get(self, "online_prediction_logging")

    @online_prediction_logging.setter
    def online_prediction_logging(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "online_prediction_logging", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter
    def regions(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The list of regions where the model is going to be deployed.
        Currently only one region per model is supported
        """
        return pulumi.get(self, "regions")

    @regions.setter
    def regions(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "regions", value)


@pulumi.type_token("gcp:ml/engineModel:EngineModel")
class EngineModel(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_version: Optional[pulumi.Input[Union['EngineModelDefaultVersionArgs', 'EngineModelDefaultVersionArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 online_prediction_console_logging: Optional[pulumi.Input[builtins.bool]] = None,
                 online_prediction_logging: Optional[pulumi.Input[builtins.bool]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 regions: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ### Ml Model Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.ml.EngineModel("default",
            name="default",
            description="My model",
            regions="us-central1")
        ```
        ### Ml Model Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.ml.EngineModel("default",
            name="default",
            description="My model",
            regions="us-central1",
            labels={
                "my_model": "foo",
            },
            online_prediction_logging=True,
            online_prediction_console_logging=True)
        ```

        ## Import

        Model can be imported using any of these accepted formats:

        * `projects/{{project}}/models/{{name}}`

        * `{{project}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, Model can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:ml/engineModel:EngineModel default projects/{{project}}/models/{{name}}
        ```

        ```sh
        $ pulumi import gcp:ml/engineModel:EngineModel default {{project}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:ml/engineModel:EngineModel default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['EngineModelDefaultVersionArgs', 'EngineModelDefaultVersionArgsDict']] default_version: The default version of the model. This version will be used to handle
               prediction requests that do not specify a version.
               Structure is documented below.
        :param pulumi.Input[builtins.str] description: The description specified for the model when it was created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: One or more labels that you can add, to organize your models.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] name: The name specified for the model.
               
               
               - - -
        :param pulumi.Input[builtins.bool] online_prediction_console_logging: If true, online prediction nodes send stderr and stdout streams to Stackdriver Logging
        :param pulumi.Input[builtins.bool] online_prediction_logging: If true, online prediction access logs are sent to StackDriver Logging.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] regions: The list of regions where the model is going to be deployed.
               Currently only one region per model is supported
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[EngineModelArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ### Ml Model Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.ml.EngineModel("default",
            name="default",
            description="My model",
            regions="us-central1")
        ```
        ### Ml Model Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.ml.EngineModel("default",
            name="default",
            description="My model",
            regions="us-central1",
            labels={
                "my_model": "foo",
            },
            online_prediction_logging=True,
            online_prediction_console_logging=True)
        ```

        ## Import

        Model can be imported using any of these accepted formats:

        * `projects/{{project}}/models/{{name}}`

        * `{{project}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, Model can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:ml/engineModel:EngineModel default projects/{{project}}/models/{{name}}
        ```

        ```sh
        $ pulumi import gcp:ml/engineModel:EngineModel default {{project}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:ml/engineModel:EngineModel default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param EngineModelArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EngineModelArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_version: Optional[pulumi.Input[Union['EngineModelDefaultVersionArgs', 'EngineModelDefaultVersionArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 online_prediction_console_logging: Optional[pulumi.Input[builtins.bool]] = None,
                 online_prediction_logging: Optional[pulumi.Input[builtins.bool]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 regions: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EngineModelArgs.__new__(EngineModelArgs)

            __props__.__dict__["default_version"] = default_version
            __props__.__dict__["description"] = description
            __props__.__dict__["labels"] = labels
            __props__.__dict__["name"] = name
            __props__.__dict__["online_prediction_console_logging"] = online_prediction_console_logging
            __props__.__dict__["online_prediction_logging"] = online_prediction_logging
            __props__.__dict__["project"] = project
            __props__.__dict__["regions"] = regions
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["pulumi_labels"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(EngineModel, __self__).__init__(
            'gcp:ml/engineModel:EngineModel',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            default_version: Optional[pulumi.Input[Union['EngineModelDefaultVersionArgs', 'EngineModelDefaultVersionArgsDict']]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            online_prediction_console_logging: Optional[pulumi.Input[builtins.bool]] = None,
            online_prediction_logging: Optional[pulumi.Input[builtins.bool]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            regions: Optional[pulumi.Input[builtins.str]] = None) -> 'EngineModel':
        """
        Get an existing EngineModel resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['EngineModelDefaultVersionArgs', 'EngineModelDefaultVersionArgsDict']] default_version: The default version of the model. This version will be used to handle
               prediction requests that do not specify a version.
               Structure is documented below.
        :param pulumi.Input[builtins.str] description: The description specified for the model when it was created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: One or more labels that you can add, to organize your models.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] name: The name specified for the model.
               
               
               - - -
        :param pulumi.Input[builtins.bool] online_prediction_console_logging: If true, online prediction nodes send stderr and stdout streams to Stackdriver Logging
        :param pulumi.Input[builtins.bool] online_prediction_logging: If true, online prediction access logs are sent to StackDriver Logging.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.str] regions: The list of regions where the model is going to be deployed.
               Currently only one region per model is supported
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EngineModelState.__new__(_EngineModelState)

        __props__.__dict__["default_version"] = default_version
        __props__.__dict__["description"] = description
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["labels"] = labels
        __props__.__dict__["name"] = name
        __props__.__dict__["online_prediction_console_logging"] = online_prediction_console_logging
        __props__.__dict__["online_prediction_logging"] = online_prediction_logging
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["regions"] = regions
        return EngineModel(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="defaultVersion")
    def default_version(self) -> pulumi.Output[Optional['outputs.EngineModelDefaultVersion']]:
        """
        The default version of the model. This version will be used to handle
        prediction requests that do not specify a version.
        Structure is documented below.
        """
        return pulumi.get(self, "default_version")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description specified for the model when it was created.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        One or more labels that you can add, to organize your models.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name specified for the model.


        - - -
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="onlinePredictionConsoleLogging")
    def online_prediction_console_logging(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        If true, online prediction nodes send stderr and stdout streams to Stackdriver Logging
        """
        return pulumi.get(self, "online_prediction_console_logging")

    @property
    @pulumi.getter(name="onlinePredictionLogging")
    def online_prediction_logging(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        If true, online prediction access logs are sent to StackDriver Logging.
        """
        return pulumi.get(self, "online_prediction_logging")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter
    def regions(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The list of regions where the model is going to be deployed.
        Currently only one region per model is supported
        """
        return pulumi.get(self, "regions")

