# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetSecretVersionResult',
    'AwaitableGetSecretVersionResult',
    'get_secret_version',
    'get_secret_version_output',
]

warnings.warn("""gcp.monitoring.getSecretVersion has been deprecated in favor of gcp.secretmanager.getSecretVersion""", DeprecationWarning)

@pulumi.output_type
class GetSecretVersionResult:
    """
    A collection of values returned by getSecretVersion.
    """
    def __init__(__self__, create_time=None, destroy_time=None, enabled=None, id=None, is_secret_data_base64=None, name=None, project=None, secret=None, secret_data=None, version=None):
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if destroy_time and not isinstance(destroy_time, str):
            raise TypeError("Expected argument 'destroy_time' to be a str")
        pulumi.set(__self__, "destroy_time", destroy_time)
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        pulumi.set(__self__, "enabled", enabled)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_secret_data_base64 and not isinstance(is_secret_data_base64, bool):
            raise TypeError("Expected argument 'is_secret_data_base64' to be a bool")
        pulumi.set(__self__, "is_secret_data_base64", is_secret_data_base64)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if secret and not isinstance(secret, str):
            raise TypeError("Expected argument 'secret' to be a str")
        pulumi.set(__self__, "secret", secret)
        if secret_data and not isinstance(secret_data, str):
            raise TypeError("Expected argument 'secret_data' to be a str")
        pulumi.set(__self__, "secret_data", secret_data)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> builtins.str:
        """
        The time at which the Secret was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="destroyTime")
    def destroy_time(self) -> builtins.str:
        """
        The time at which the Secret was destroyed. Only present if state is DESTROYED.
        """
        return pulumi.get(self, "destroy_time")

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        True if the current state of the SecretVersion is enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isSecretDataBase64")
    def is_secret_data_base64(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "is_secret_data_base64")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The resource name of the SecretVersion. Format:
        `projects/{{project}}/secrets/{{secret_id}}/versions/{{version}}`
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> builtins.str:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def secret(self) -> builtins.str:
        return pulumi.get(self, "secret")

    @property
    @pulumi.getter(name="secretData")
    def secret_data(self) -> builtins.str:
        """
        The secret data. No larger than 64KiB.
        """
        return pulumi.get(self, "secret_data")

    @property
    @pulumi.getter
    def version(self) -> builtins.str:
        return pulumi.get(self, "version")


class AwaitableGetSecretVersionResult(GetSecretVersionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSecretVersionResult(
            create_time=self.create_time,
            destroy_time=self.destroy_time,
            enabled=self.enabled,
            id=self.id,
            is_secret_data_base64=self.is_secret_data_base64,
            name=self.name,
            project=self.project,
            secret=self.secret,
            secret_data=self.secret_data,
            version=self.version)


def get_secret_version(is_secret_data_base64: Optional[builtins.bool] = None,
                       project: Optional[builtins.str] = None,
                       secret: Optional[builtins.str] = None,
                       version: Optional[builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSecretVersionResult:
    """
    Get the value and metadata from a Secret Manager secret version. For more information see the [official documentation](https://cloud.google.com/secret-manager/docs/) and [API](https://cloud.google.com/secret-manager/docs/reference/rest/v1/projects.secrets.versions). If you don't need the metadata (i.e., if you want to use a more limited role to access the secret version only), see also the secretmanager_get_secret_version_access datasource.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    basic = gcp.secretmanager.get_secret_version(secret="my-secret")
    ```


    :param builtins.bool is_secret_data_base64: If set to 'true', the secret data is
           expected to be base64-encoded string.
    :param builtins.str project: The project to get the secret version for. If it
           is not provided, the provider project is used.
    :param builtins.str secret: The secret to get the secret version for.
    :param builtins.str version: The version of the secret to get. If it
           is not provided, the latest version is retrieved.
    """
    pulumi.log.warn("""get_secret_version is deprecated: gcp.monitoring.getSecretVersion has been deprecated in favor of gcp.secretmanager.getSecretVersion""")
    __args__ = dict()
    __args__['isSecretDataBase64'] = is_secret_data_base64
    __args__['project'] = project
    __args__['secret'] = secret
    __args__['version'] = version
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:monitoring/getSecretVersion:getSecretVersion', __args__, opts=opts, typ=GetSecretVersionResult).value

    return AwaitableGetSecretVersionResult(
        create_time=pulumi.get(__ret__, 'create_time'),
        destroy_time=pulumi.get(__ret__, 'destroy_time'),
        enabled=pulumi.get(__ret__, 'enabled'),
        id=pulumi.get(__ret__, 'id'),
        is_secret_data_base64=pulumi.get(__ret__, 'is_secret_data_base64'),
        name=pulumi.get(__ret__, 'name'),
        project=pulumi.get(__ret__, 'project'),
        secret=pulumi.get(__ret__, 'secret'),
        secret_data=pulumi.get(__ret__, 'secret_data'),
        version=pulumi.get(__ret__, 'version'))
def get_secret_version_output(is_secret_data_base64: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                              project: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                              secret: Optional[pulumi.Input[builtins.str]] = None,
                              version: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSecretVersionResult]:
    """
    Get the value and metadata from a Secret Manager secret version. For more information see the [official documentation](https://cloud.google.com/secret-manager/docs/) and [API](https://cloud.google.com/secret-manager/docs/reference/rest/v1/projects.secrets.versions). If you don't need the metadata (i.e., if you want to use a more limited role to access the secret version only), see also the secretmanager_get_secret_version_access datasource.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    basic = gcp.secretmanager.get_secret_version(secret="my-secret")
    ```


    :param builtins.bool is_secret_data_base64: If set to 'true', the secret data is
           expected to be base64-encoded string.
    :param builtins.str project: The project to get the secret version for. If it
           is not provided, the provider project is used.
    :param builtins.str secret: The secret to get the secret version for.
    :param builtins.str version: The version of the secret to get. If it
           is not provided, the latest version is retrieved.
    """
    pulumi.log.warn("""get_secret_version is deprecated: gcp.monitoring.getSecretVersion has been deprecated in favor of gcp.secretmanager.getSecretVersion""")
    __args__ = dict()
    __args__['isSecretDataBase64'] = is_secret_data_base64
    __args__['project'] = project
    __args__['secret'] = secret
    __args__['version'] = version
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:monitoring/getSecretVersion:getSecretVersion', __args__, opts=opts, typ=GetSecretVersionResult)
    return __ret__.apply(lambda __response__: GetSecretVersionResult(
        create_time=pulumi.get(__response__, 'create_time'),
        destroy_time=pulumi.get(__response__, 'destroy_time'),
        enabled=pulumi.get(__response__, 'enabled'),
        id=pulumi.get(__response__, 'id'),
        is_secret_data_base64=pulumi.get(__response__, 'is_secret_data_base64'),
        name=pulumi.get(__response__, 'name'),
        project=pulumi.get(__response__, 'project'),
        secret=pulumi.get(__response__, 'secret'),
        secret_data=pulumi.get(__response__, 'secret_data'),
        version=pulumi.get(__response__, 'version')))
