# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['GroupArgs', 'Group']

@pulumi.input_type
class GroupArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[builtins.str],
                 filter: pulumi.Input[builtins.str],
                 is_cluster: Optional[pulumi.Input[builtins.bool]] = None,
                 parent_name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Group resource.
        :param pulumi.Input[builtins.str] display_name: A user-assigned name for this group, used only for display
               purposes.
        :param pulumi.Input[builtins.str] filter: The filter used to determine which monitored resources
               belong to this group.
               
               
               - - -
        :param pulumi.Input[builtins.bool] is_cluster: If true, the members of this group are considered to be a
               cluster. The system can perform additional analysis on
               groups that are clusters.
        :param pulumi.Input[builtins.str] parent_name: The name of the group's parent, if it has one. The format is
               "projects/{project_id_or_number}/groups/{group_id}". For
               groups with no parent, parentName is the empty string, "".
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "filter", filter)
        if is_cluster is not None:
            pulumi.set(__self__, "is_cluster", is_cluster)
        if parent_name is not None:
            pulumi.set(__self__, "parent_name", parent_name)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[builtins.str]:
        """
        A user-assigned name for this group, used only for display
        purposes.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def filter(self) -> pulumi.Input[builtins.str]:
        """
        The filter used to determine which monitored resources
        belong to this group.


        - - -
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "filter", value)

    @property
    @pulumi.getter(name="isCluster")
    def is_cluster(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If true, the members of this group are considered to be a
        cluster. The system can perform additional analysis on
        groups that are clusters.
        """
        return pulumi.get(self, "is_cluster")

    @is_cluster.setter
    def is_cluster(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_cluster", value)

    @property
    @pulumi.getter(name="parentName")
    def parent_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the group's parent, if it has one. The format is
        "projects/{project_id_or_number}/groups/{group_id}". For
        groups with no parent, parentName is the empty string, "".
        """
        return pulumi.get(self, "parent_name")

    @parent_name.setter
    def parent_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "parent_name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _GroupState:
    def __init__(__self__, *,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 filter: Optional[pulumi.Input[builtins.str]] = None,
                 is_cluster: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 parent_name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Group resources.
        :param pulumi.Input[builtins.str] display_name: A user-assigned name for this group, used only for display
               purposes.
        :param pulumi.Input[builtins.str] filter: The filter used to determine which monitored resources
               belong to this group.
               
               
               - - -
        :param pulumi.Input[builtins.bool] is_cluster: If true, the members of this group are considered to be a
               cluster. The system can perform additional analysis on
               groups that are clusters.
        :param pulumi.Input[builtins.str] name: A unique identifier for this group. The format is
               "projects/{project_id_or_number}/groups/{group_id}".
        :param pulumi.Input[builtins.str] parent_name: The name of the group's parent, if it has one. The format is
               "projects/{project_id_or_number}/groups/{group_id}". For
               groups with no parent, parentName is the empty string, "".
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if is_cluster is not None:
            pulumi.set(__self__, "is_cluster", is_cluster)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent_name is not None:
            pulumi.set(__self__, "parent_name", parent_name)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A user-assigned name for this group, used only for display
        purposes.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def filter(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The filter used to determine which monitored resources
        belong to this group.


        - - -
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "filter", value)

    @property
    @pulumi.getter(name="isCluster")
    def is_cluster(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If true, the members of this group are considered to be a
        cluster. The system can perform additional analysis on
        groups that are clusters.
        """
        return pulumi.get(self, "is_cluster")

    @is_cluster.setter
    def is_cluster(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_cluster", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A unique identifier for this group. The format is
        "projects/{project_id_or_number}/groups/{group_id}".
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="parentName")
    def parent_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the group's parent, if it has one. The format is
        "projects/{project_id_or_number}/groups/{group_id}". For
        groups with no parent, parentName is the empty string, "".
        """
        return pulumi.get(self, "parent_name")

    @parent_name.setter
    def parent_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "parent_name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.type_token("gcp:monitoring/group:Group")
class Group(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 filter: Optional[pulumi.Input[builtins.str]] = None,
                 is_cluster: Optional[pulumi.Input[builtins.bool]] = None,
                 parent_name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        The description of a dynamic collection of monitored resources. Each group
        has a filter that is matched against monitored resources and their
        associated metadata. If a group's filter matches an available monitored
        resource, then that resource is a member of that group.

        To get more information about Group, see:

        * [API documentation](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.groups)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/monitoring/groups/)

        ## Example Usage

        ### Monitoring Group Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic = gcp.monitoring.Group("basic",
            display_name="tf-test MonitoringGroup",
            filter="resource.metadata.region=\\"europe-west2\\"")
        ```
        ### Monitoring Group Subgroup

        ```python
        import pulumi
        import pulumi_gcp as gcp

        parent = gcp.monitoring.Group("parent",
            display_name="tf-test MonitoringParentGroup",
            filter="resource.metadata.region=\\"europe-west2\\"")
        subgroup = gcp.monitoring.Group("subgroup",
            display_name="tf-test MonitoringSubGroup",
            filter="resource.metadata.region=\\"europe-west2\\"",
            parent_name=parent.name)
        ```

        ## Import

        Group can be imported using any of these accepted formats:

        * `{{project}}/{{name}}`

        * `{{project}} {{name}}`

        * `{{name}}`

        When using the `pulumi import` command, Group can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:monitoring/group:Group default {{project}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:monitoring/group:Group default "{{project}} {{name}}"
        ```

        ```sh
        $ pulumi import gcp:monitoring/group:Group default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] display_name: A user-assigned name for this group, used only for display
               purposes.
        :param pulumi.Input[builtins.str] filter: The filter used to determine which monitored resources
               belong to this group.
               
               
               - - -
        :param pulumi.Input[builtins.bool] is_cluster: If true, the members of this group are considered to be a
               cluster. The system can perform additional analysis on
               groups that are clusters.
        :param pulumi.Input[builtins.str] parent_name: The name of the group's parent, if it has one. The format is
               "projects/{project_id_or_number}/groups/{group_id}". For
               groups with no parent, parentName is the empty string, "".
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The description of a dynamic collection of monitored resources. Each group
        has a filter that is matched against monitored resources and their
        associated metadata. If a group's filter matches an available monitored
        resource, then that resource is a member of that group.

        To get more information about Group, see:

        * [API documentation](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.groups)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/monitoring/groups/)

        ## Example Usage

        ### Monitoring Group Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic = gcp.monitoring.Group("basic",
            display_name="tf-test MonitoringGroup",
            filter="resource.metadata.region=\\"europe-west2\\"")
        ```
        ### Monitoring Group Subgroup

        ```python
        import pulumi
        import pulumi_gcp as gcp

        parent = gcp.monitoring.Group("parent",
            display_name="tf-test MonitoringParentGroup",
            filter="resource.metadata.region=\\"europe-west2\\"")
        subgroup = gcp.monitoring.Group("subgroup",
            display_name="tf-test MonitoringSubGroup",
            filter="resource.metadata.region=\\"europe-west2\\"",
            parent_name=parent.name)
        ```

        ## Import

        Group can be imported using any of these accepted formats:

        * `{{project}}/{{name}}`

        * `{{project}} {{name}}`

        * `{{name}}`

        When using the `pulumi import` command, Group can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:monitoring/group:Group default {{project}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:monitoring/group:Group default "{{project}} {{name}}"
        ```

        ```sh
        $ pulumi import gcp:monitoring/group:Group default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param GroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 filter: Optional[pulumi.Input[builtins.str]] = None,
                 is_cluster: Optional[pulumi.Input[builtins.bool]] = None,
                 parent_name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GroupArgs.__new__(GroupArgs)

            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            if filter is None and not opts.urn:
                raise TypeError("Missing required property 'filter'")
            __props__.__dict__["filter"] = filter
            __props__.__dict__["is_cluster"] = is_cluster
            __props__.__dict__["parent_name"] = parent_name
            __props__.__dict__["project"] = project
            __props__.__dict__["name"] = None
        super(Group, __self__).__init__(
            'gcp:monitoring/group:Group',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            filter: Optional[pulumi.Input[builtins.str]] = None,
            is_cluster: Optional[pulumi.Input[builtins.bool]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            parent_name: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None) -> 'Group':
        """
        Get an existing Group resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] display_name: A user-assigned name for this group, used only for display
               purposes.
        :param pulumi.Input[builtins.str] filter: The filter used to determine which monitored resources
               belong to this group.
               
               
               - - -
        :param pulumi.Input[builtins.bool] is_cluster: If true, the members of this group are considered to be a
               cluster. The system can perform additional analysis on
               groups that are clusters.
        :param pulumi.Input[builtins.str] name: A unique identifier for this group. The format is
               "projects/{project_id_or_number}/groups/{group_id}".
        :param pulumi.Input[builtins.str] parent_name: The name of the group's parent, if it has one. The format is
               "projects/{project_id_or_number}/groups/{group_id}". For
               groups with no parent, parentName is the empty string, "".
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GroupState.__new__(_GroupState)

        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["filter"] = filter
        __props__.__dict__["is_cluster"] = is_cluster
        __props__.__dict__["name"] = name
        __props__.__dict__["parent_name"] = parent_name
        __props__.__dict__["project"] = project
        return Group(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        A user-assigned name for this group, used only for display
        purposes.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filter(self) -> pulumi.Output[builtins.str]:
        """
        The filter used to determine which monitored resources
        belong to this group.


        - - -
        """
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter(name="isCluster")
    def is_cluster(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        If true, the members of this group are considered to be a
        cluster. The system can perform additional analysis on
        groups that are clusters.
        """
        return pulumi.get(self, "is_cluster")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        A unique identifier for this group. The format is
        "projects/{project_id_or_number}/groups/{group_id}".
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="parentName")
    def parent_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of the group's parent, if it has one. The format is
        "projects/{project_id_or_number}/groups/{group_id}". For
        groups with no parent, parentName is the empty string, "".
        """
        return pulumi.get(self, "parent_name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

