# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['UptimeCheckConfigArgs', 'UptimeCheckConfig']

@pulumi.input_type
class UptimeCheckConfigArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[builtins.str],
                 timeout: pulumi.Input[builtins.str],
                 checker_type: Optional[pulumi.Input[builtins.str]] = None,
                 content_matchers: Optional[pulumi.Input[Sequence[pulumi.Input['UptimeCheckConfigContentMatcherArgs']]]] = None,
                 http_check: Optional[pulumi.Input['UptimeCheckConfigHttpCheckArgs']] = None,
                 log_check_failures: Optional[pulumi.Input[builtins.bool]] = None,
                 monitored_resource: Optional[pulumi.Input['UptimeCheckConfigMonitoredResourceArgs']] = None,
                 period: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group: Optional[pulumi.Input['UptimeCheckConfigResourceGroupArgs']] = None,
                 selected_regions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 synthetic_monitor: Optional[pulumi.Input['UptimeCheckConfigSyntheticMonitorArgs']] = None,
                 tcp_check: Optional[pulumi.Input['UptimeCheckConfigTcpCheckArgs']] = None,
                 user_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a UptimeCheckConfig resource.
        :param pulumi.Input[builtins.str] display_name: A human-friendly name for the uptime check configuration. The display name should be unique within a Stackdriver Workspace in order to make it easier to identify; however, uniqueness is not enforced.
        :param pulumi.Input[builtins.str] timeout: The maximum amount of time to wait for the request to complete (must be between 1 and 60 seconds). See the accepted formats
               
               
               - - -
        :param pulumi.Input[builtins.str] checker_type: The checker type to use for the check. If the monitored resource type is `servicedirectory_service`, `checker_type` must be set to `VPC_CHECKERS`.
               Possible values are: `STATIC_IP_CHECKERS`, `VPC_CHECKERS`.
        :param pulumi.Input[Sequence[pulumi.Input['UptimeCheckConfigContentMatcherArgs']]] content_matchers: The expected content on the page the check is run against. Currently, only the first entry in the list is supported, and other entries will be ignored. The server will look for an exact match of the string in the page response's content. This field is optional and should only be specified if a content match is required.
               Structure is documented below.
        :param pulumi.Input['UptimeCheckConfigHttpCheckArgs'] http_check: Contains information needed to make an HTTP or HTTPS check.
               Structure is documented below.
        :param pulumi.Input[builtins.bool] log_check_failures: Specifies whether to log the results of failed probes to Cloud Logging.
        :param pulumi.Input['UptimeCheckConfigMonitoredResourceArgs'] monitored_resource: The [monitored resource]
               (https://cloud.google.com/monitoring/api/resources) associated with the
               configuration. The following monitored resource types are supported for
               uptime checks:
        :param pulumi.Input[builtins.str] period: How often, in seconds, the uptime check is performed. Currently, the only supported values are 60s (1 minute), 300s (5 minutes), 600s (10 minutes), and 900s (15 minutes). Optional, defaults to 300s.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['UptimeCheckConfigResourceGroupArgs'] resource_group: The group resource associated with the configuration.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] selected_regions: The list of regions from which the check will be run. Some regions contain one location, and others contain more than one. If this field is specified, enough regions to include a minimum of 3 locations must be provided, or an error message is returned. Not specifying this field will result in uptime checks running from all regions.
        :param pulumi.Input['UptimeCheckConfigSyntheticMonitorArgs'] synthetic_monitor: A Synthetic Monitor deployed to a Cloud Functions V2 instance.
               Structure is documented below.
        :param pulumi.Input['UptimeCheckConfigTcpCheckArgs'] tcp_check: Contains information needed to make a TCP check.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] user_labels: User-supplied key/value data to be used for organizing and identifying the `UptimeCheckConfig` objects. The field can contain up to 64 entries. Each key and value is limited to 63 Unicode characters or 128 bytes, whichever is smaller. Labels and values can contain only lowercase letters, numerals, underscores, and dashes. Keys must begin with a letter.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "timeout", timeout)
        if checker_type is not None:
            pulumi.set(__self__, "checker_type", checker_type)
        if content_matchers is not None:
            pulumi.set(__self__, "content_matchers", content_matchers)
        if http_check is not None:
            pulumi.set(__self__, "http_check", http_check)
        if log_check_failures is not None:
            pulumi.set(__self__, "log_check_failures", log_check_failures)
        if monitored_resource is not None:
            pulumi.set(__self__, "monitored_resource", monitored_resource)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if selected_regions is not None:
            pulumi.set(__self__, "selected_regions", selected_regions)
        if synthetic_monitor is not None:
            pulumi.set(__self__, "synthetic_monitor", synthetic_monitor)
        if tcp_check is not None:
            pulumi.set(__self__, "tcp_check", tcp_check)
        if user_labels is not None:
            pulumi.set(__self__, "user_labels", user_labels)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[builtins.str]:
        """
        A human-friendly name for the uptime check configuration. The display name should be unique within a Stackdriver Workspace in order to make it easier to identify; however, uniqueness is not enforced.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def timeout(self) -> pulumi.Input[builtins.str]:
        """
        The maximum amount of time to wait for the request to complete (must be between 1 and 60 seconds). See the accepted formats


        - - -
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter(name="checkerType")
    def checker_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The checker type to use for the check. If the monitored resource type is `servicedirectory_service`, `checker_type` must be set to `VPC_CHECKERS`.
        Possible values are: `STATIC_IP_CHECKERS`, `VPC_CHECKERS`.
        """
        return pulumi.get(self, "checker_type")

    @checker_type.setter
    def checker_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "checker_type", value)

    @property
    @pulumi.getter(name="contentMatchers")
    def content_matchers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UptimeCheckConfigContentMatcherArgs']]]]:
        """
        The expected content on the page the check is run against. Currently, only the first entry in the list is supported, and other entries will be ignored. The server will look for an exact match of the string in the page response's content. This field is optional and should only be specified if a content match is required.
        Structure is documented below.
        """
        return pulumi.get(self, "content_matchers")

    @content_matchers.setter
    def content_matchers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UptimeCheckConfigContentMatcherArgs']]]]):
        pulumi.set(self, "content_matchers", value)

    @property
    @pulumi.getter(name="httpCheck")
    def http_check(self) -> Optional[pulumi.Input['UptimeCheckConfigHttpCheckArgs']]:
        """
        Contains information needed to make an HTTP or HTTPS check.
        Structure is documented below.
        """
        return pulumi.get(self, "http_check")

    @http_check.setter
    def http_check(self, value: Optional[pulumi.Input['UptimeCheckConfigHttpCheckArgs']]):
        pulumi.set(self, "http_check", value)

    @property
    @pulumi.getter(name="logCheckFailures")
    def log_check_failures(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether to log the results of failed probes to Cloud Logging.
        """
        return pulumi.get(self, "log_check_failures")

    @log_check_failures.setter
    def log_check_failures(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "log_check_failures", value)

    @property
    @pulumi.getter(name="monitoredResource")
    def monitored_resource(self) -> Optional[pulumi.Input['UptimeCheckConfigMonitoredResourceArgs']]:
        """
        The [monitored resource]
        (https://cloud.google.com/monitoring/api/resources) associated with the
        configuration. The following monitored resource types are supported for
        uptime checks:
        """
        return pulumi.get(self, "monitored_resource")

    @monitored_resource.setter
    def monitored_resource(self, value: Optional[pulumi.Input['UptimeCheckConfigMonitoredResourceArgs']]):
        pulumi.set(self, "monitored_resource", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        How often, in seconds, the uptime check is performed. Currently, the only supported values are 60s (1 minute), 300s (5 minutes), 600s (10 minutes), and 900s (15 minutes). Optional, defaults to 300s.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[pulumi.Input['UptimeCheckConfigResourceGroupArgs']]:
        """
        The group resource associated with the configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "resource_group")

    @resource_group.setter
    def resource_group(self, value: Optional[pulumi.Input['UptimeCheckConfigResourceGroupArgs']]):
        pulumi.set(self, "resource_group", value)

    @property
    @pulumi.getter(name="selectedRegions")
    def selected_regions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The list of regions from which the check will be run. Some regions contain one location, and others contain more than one. If this field is specified, enough regions to include a minimum of 3 locations must be provided, or an error message is returned. Not specifying this field will result in uptime checks running from all regions.
        """
        return pulumi.get(self, "selected_regions")

    @selected_regions.setter
    def selected_regions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "selected_regions", value)

    @property
    @pulumi.getter(name="syntheticMonitor")
    def synthetic_monitor(self) -> Optional[pulumi.Input['UptimeCheckConfigSyntheticMonitorArgs']]:
        """
        A Synthetic Monitor deployed to a Cloud Functions V2 instance.
        Structure is documented below.
        """
        return pulumi.get(self, "synthetic_monitor")

    @synthetic_monitor.setter
    def synthetic_monitor(self, value: Optional[pulumi.Input['UptimeCheckConfigSyntheticMonitorArgs']]):
        pulumi.set(self, "synthetic_monitor", value)

    @property
    @pulumi.getter(name="tcpCheck")
    def tcp_check(self) -> Optional[pulumi.Input['UptimeCheckConfigTcpCheckArgs']]:
        """
        Contains information needed to make a TCP check.
        Structure is documented below.
        """
        return pulumi.get(self, "tcp_check")

    @tcp_check.setter
    def tcp_check(self, value: Optional[pulumi.Input['UptimeCheckConfigTcpCheckArgs']]):
        pulumi.set(self, "tcp_check", value)

    @property
    @pulumi.getter(name="userLabels")
    def user_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        User-supplied key/value data to be used for organizing and identifying the `UptimeCheckConfig` objects. The field can contain up to 64 entries. Each key and value is limited to 63 Unicode characters or 128 bytes, whichever is smaller. Labels and values can contain only lowercase letters, numerals, underscores, and dashes. Keys must begin with a letter.
        """
        return pulumi.get(self, "user_labels")

    @user_labels.setter
    def user_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "user_labels", value)


@pulumi.input_type
class _UptimeCheckConfigState:
    def __init__(__self__, *,
                 checker_type: Optional[pulumi.Input[builtins.str]] = None,
                 content_matchers: Optional[pulumi.Input[Sequence[pulumi.Input['UptimeCheckConfigContentMatcherArgs']]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 http_check: Optional[pulumi.Input['UptimeCheckConfigHttpCheckArgs']] = None,
                 log_check_failures: Optional[pulumi.Input[builtins.bool]] = None,
                 monitored_resource: Optional[pulumi.Input['UptimeCheckConfigMonitoredResourceArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 period: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group: Optional[pulumi.Input['UptimeCheckConfigResourceGroupArgs']] = None,
                 selected_regions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 synthetic_monitor: Optional[pulumi.Input['UptimeCheckConfigSyntheticMonitorArgs']] = None,
                 tcp_check: Optional[pulumi.Input['UptimeCheckConfigTcpCheckArgs']] = None,
                 timeout: Optional[pulumi.Input[builtins.str]] = None,
                 uptime_check_id: Optional[pulumi.Input[builtins.str]] = None,
                 user_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering UptimeCheckConfig resources.
        :param pulumi.Input[builtins.str] checker_type: The checker type to use for the check. If the monitored resource type is `servicedirectory_service`, `checker_type` must be set to `VPC_CHECKERS`.
               Possible values are: `STATIC_IP_CHECKERS`, `VPC_CHECKERS`.
        :param pulumi.Input[Sequence[pulumi.Input['UptimeCheckConfigContentMatcherArgs']]] content_matchers: The expected content on the page the check is run against. Currently, only the first entry in the list is supported, and other entries will be ignored. The server will look for an exact match of the string in the page response's content. This field is optional and should only be specified if a content match is required.
               Structure is documented below.
        :param pulumi.Input[builtins.str] display_name: A human-friendly name for the uptime check configuration. The display name should be unique within a Stackdriver Workspace in order to make it easier to identify; however, uniqueness is not enforced.
        :param pulumi.Input['UptimeCheckConfigHttpCheckArgs'] http_check: Contains information needed to make an HTTP or HTTPS check.
               Structure is documented below.
        :param pulumi.Input[builtins.bool] log_check_failures: Specifies whether to log the results of failed probes to Cloud Logging.
        :param pulumi.Input['UptimeCheckConfigMonitoredResourceArgs'] monitored_resource: The [monitored resource]
               (https://cloud.google.com/monitoring/api/resources) associated with the
               configuration. The following monitored resource types are supported for
               uptime checks:
        :param pulumi.Input[builtins.str] name: A unique resource name for this UptimeCheckConfig. The format is `projects/[PROJECT_ID]/uptimeCheckConfigs/[UPTIME_CHECK_ID]`.
        :param pulumi.Input[builtins.str] period: How often, in seconds, the uptime check is performed. Currently, the only supported values are 60s (1 minute), 300s (5 minutes), 600s (10 minutes), and 900s (15 minutes). Optional, defaults to 300s.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['UptimeCheckConfigResourceGroupArgs'] resource_group: The group resource associated with the configuration.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] selected_regions: The list of regions from which the check will be run. Some regions contain one location, and others contain more than one. If this field is specified, enough regions to include a minimum of 3 locations must be provided, or an error message is returned. Not specifying this field will result in uptime checks running from all regions.
        :param pulumi.Input['UptimeCheckConfigSyntheticMonitorArgs'] synthetic_monitor: A Synthetic Monitor deployed to a Cloud Functions V2 instance.
               Structure is documented below.
        :param pulumi.Input['UptimeCheckConfigTcpCheckArgs'] tcp_check: Contains information needed to make a TCP check.
               Structure is documented below.
        :param pulumi.Input[builtins.str] timeout: The maximum amount of time to wait for the request to complete (must be between 1 and 60 seconds). See the accepted formats
               
               
               - - -
        :param pulumi.Input[builtins.str] uptime_check_id: The id of the uptime check
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] user_labels: User-supplied key/value data to be used for organizing and identifying the `UptimeCheckConfig` objects. The field can contain up to 64 entries. Each key and value is limited to 63 Unicode characters or 128 bytes, whichever is smaller. Labels and values can contain only lowercase letters, numerals, underscores, and dashes. Keys must begin with a letter.
        """
        if checker_type is not None:
            pulumi.set(__self__, "checker_type", checker_type)
        if content_matchers is not None:
            pulumi.set(__self__, "content_matchers", content_matchers)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if http_check is not None:
            pulumi.set(__self__, "http_check", http_check)
        if log_check_failures is not None:
            pulumi.set(__self__, "log_check_failures", log_check_failures)
        if monitored_resource is not None:
            pulumi.set(__self__, "monitored_resource", monitored_resource)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if selected_regions is not None:
            pulumi.set(__self__, "selected_regions", selected_regions)
        if synthetic_monitor is not None:
            pulumi.set(__self__, "synthetic_monitor", synthetic_monitor)
        if tcp_check is not None:
            pulumi.set(__self__, "tcp_check", tcp_check)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if uptime_check_id is not None:
            pulumi.set(__self__, "uptime_check_id", uptime_check_id)
        if user_labels is not None:
            pulumi.set(__self__, "user_labels", user_labels)

    @property
    @pulumi.getter(name="checkerType")
    def checker_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The checker type to use for the check. If the monitored resource type is `servicedirectory_service`, `checker_type` must be set to `VPC_CHECKERS`.
        Possible values are: `STATIC_IP_CHECKERS`, `VPC_CHECKERS`.
        """
        return pulumi.get(self, "checker_type")

    @checker_type.setter
    def checker_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "checker_type", value)

    @property
    @pulumi.getter(name="contentMatchers")
    def content_matchers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UptimeCheckConfigContentMatcherArgs']]]]:
        """
        The expected content on the page the check is run against. Currently, only the first entry in the list is supported, and other entries will be ignored. The server will look for an exact match of the string in the page response's content. This field is optional and should only be specified if a content match is required.
        Structure is documented below.
        """
        return pulumi.get(self, "content_matchers")

    @content_matchers.setter
    def content_matchers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UptimeCheckConfigContentMatcherArgs']]]]):
        pulumi.set(self, "content_matchers", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A human-friendly name for the uptime check configuration. The display name should be unique within a Stackdriver Workspace in order to make it easier to identify; however, uniqueness is not enforced.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="httpCheck")
    def http_check(self) -> Optional[pulumi.Input['UptimeCheckConfigHttpCheckArgs']]:
        """
        Contains information needed to make an HTTP or HTTPS check.
        Structure is documented below.
        """
        return pulumi.get(self, "http_check")

    @http_check.setter
    def http_check(self, value: Optional[pulumi.Input['UptimeCheckConfigHttpCheckArgs']]):
        pulumi.set(self, "http_check", value)

    @property
    @pulumi.getter(name="logCheckFailures")
    def log_check_failures(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether to log the results of failed probes to Cloud Logging.
        """
        return pulumi.get(self, "log_check_failures")

    @log_check_failures.setter
    def log_check_failures(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "log_check_failures", value)

    @property
    @pulumi.getter(name="monitoredResource")
    def monitored_resource(self) -> Optional[pulumi.Input['UptimeCheckConfigMonitoredResourceArgs']]:
        """
        The [monitored resource]
        (https://cloud.google.com/monitoring/api/resources) associated with the
        configuration. The following monitored resource types are supported for
        uptime checks:
        """
        return pulumi.get(self, "monitored_resource")

    @monitored_resource.setter
    def monitored_resource(self, value: Optional[pulumi.Input['UptimeCheckConfigMonitoredResourceArgs']]):
        pulumi.set(self, "monitored_resource", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A unique resource name for this UptimeCheckConfig. The format is `projects/[PROJECT_ID]/uptimeCheckConfigs/[UPTIME_CHECK_ID]`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        How often, in seconds, the uptime check is performed. Currently, the only supported values are 60s (1 minute), 300s (5 minutes), 600s (10 minutes), and 900s (15 minutes). Optional, defaults to 300s.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[pulumi.Input['UptimeCheckConfigResourceGroupArgs']]:
        """
        The group resource associated with the configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "resource_group")

    @resource_group.setter
    def resource_group(self, value: Optional[pulumi.Input['UptimeCheckConfigResourceGroupArgs']]):
        pulumi.set(self, "resource_group", value)

    @property
    @pulumi.getter(name="selectedRegions")
    def selected_regions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The list of regions from which the check will be run. Some regions contain one location, and others contain more than one. If this field is specified, enough regions to include a minimum of 3 locations must be provided, or an error message is returned. Not specifying this field will result in uptime checks running from all regions.
        """
        return pulumi.get(self, "selected_regions")

    @selected_regions.setter
    def selected_regions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "selected_regions", value)

    @property
    @pulumi.getter(name="syntheticMonitor")
    def synthetic_monitor(self) -> Optional[pulumi.Input['UptimeCheckConfigSyntheticMonitorArgs']]:
        """
        A Synthetic Monitor deployed to a Cloud Functions V2 instance.
        Structure is documented below.
        """
        return pulumi.get(self, "synthetic_monitor")

    @synthetic_monitor.setter
    def synthetic_monitor(self, value: Optional[pulumi.Input['UptimeCheckConfigSyntheticMonitorArgs']]):
        pulumi.set(self, "synthetic_monitor", value)

    @property
    @pulumi.getter(name="tcpCheck")
    def tcp_check(self) -> Optional[pulumi.Input['UptimeCheckConfigTcpCheckArgs']]:
        """
        Contains information needed to make a TCP check.
        Structure is documented below.
        """
        return pulumi.get(self, "tcp_check")

    @tcp_check.setter
    def tcp_check(self, value: Optional[pulumi.Input['UptimeCheckConfigTcpCheckArgs']]):
        pulumi.set(self, "tcp_check", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The maximum amount of time to wait for the request to complete (must be between 1 and 60 seconds). See the accepted formats


        - - -
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter(name="uptimeCheckId")
    def uptime_check_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The id of the uptime check
        """
        return pulumi.get(self, "uptime_check_id")

    @uptime_check_id.setter
    def uptime_check_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "uptime_check_id", value)

    @property
    @pulumi.getter(name="userLabels")
    def user_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        User-supplied key/value data to be used for organizing and identifying the `UptimeCheckConfig` objects. The field can contain up to 64 entries. Each key and value is limited to 63 Unicode characters or 128 bytes, whichever is smaller. Labels and values can contain only lowercase letters, numerals, underscores, and dashes. Keys must begin with a letter.
        """
        return pulumi.get(self, "user_labels")

    @user_labels.setter
    def user_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "user_labels", value)


@pulumi.type_token("gcp:monitoring/uptimeCheckConfig:UptimeCheckConfig")
class UptimeCheckConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 checker_type: Optional[pulumi.Input[builtins.str]] = None,
                 content_matchers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UptimeCheckConfigContentMatcherArgs', 'UptimeCheckConfigContentMatcherArgsDict']]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 http_check: Optional[pulumi.Input[Union['UptimeCheckConfigHttpCheckArgs', 'UptimeCheckConfigHttpCheckArgsDict']]] = None,
                 log_check_failures: Optional[pulumi.Input[builtins.bool]] = None,
                 monitored_resource: Optional[pulumi.Input[Union['UptimeCheckConfigMonitoredResourceArgs', 'UptimeCheckConfigMonitoredResourceArgsDict']]] = None,
                 period: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group: Optional[pulumi.Input[Union['UptimeCheckConfigResourceGroupArgs', 'UptimeCheckConfigResourceGroupArgsDict']]] = None,
                 selected_regions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 synthetic_monitor: Optional[pulumi.Input[Union['UptimeCheckConfigSyntheticMonitorArgs', 'UptimeCheckConfigSyntheticMonitorArgsDict']]] = None,
                 tcp_check: Optional[pulumi.Input[Union['UptimeCheckConfigTcpCheckArgs', 'UptimeCheckConfigTcpCheckArgsDict']]] = None,
                 timeout: Optional[pulumi.Input[builtins.str]] = None,
                 user_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        This message configures which resources and services to monitor for availability.

        To get more information about UptimeCheckConfig, see:

        * [API documentation](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.uptimeCheckConfigs)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/monitoring/uptime-checks/)

        ## Example Usage

        ### Uptime Check Config Http

        ```python
        import pulumi
        import pulumi_gcp as gcp

        http = gcp.monitoring.UptimeCheckConfig("http",
            display_name="http-uptime-check",
            timeout="60s",
            log_check_failures=True,
            user_labels={
                "example-key": "example-value",
            },
            http_check={
                "path": "some-path",
                "port": 8010,
                "request_method": "POST",
                "content_type": "USER_PROVIDED",
                "custom_content_type": "application/json",
                "body": "Zm9vJTI1M0RiYXI=",
                "ping_config": {
                    "pings_count": 1,
                },
            },
            monitored_resource={
                "type": "uptime_url",
                "labels": {
                    "project_id": "my-project-name",
                    "host": "192.168.1.1",
                },
            },
            content_matchers=[{
                "content": "\\"example\\"",
                "matcher": "MATCHES_JSON_PATH",
                "json_path_matcher": {
                    "json_path": "$.path",
                    "json_matcher": "EXACT_MATCH",
                },
            }],
            checker_type="STATIC_IP_CHECKERS")
        ```
        ### Uptime Check Config Status Code

        ```python
        import pulumi
        import pulumi_gcp as gcp

        status_code = gcp.monitoring.UptimeCheckConfig("status_code",
            display_name="http-uptime-check",
            timeout="60s",
            http_check={
                "path": "some-path",
                "port": 8010,
                "request_method": "POST",
                "content_type": "URL_ENCODED",
                "body": "Zm9vJTI1M0RiYXI=",
                "accepted_response_status_codes": [
                    {
                        "status_class": "STATUS_CLASS_2XX",
                    },
                    {
                        "status_value": 301,
                    },
                    {
                        "status_value": 302,
                    },
                ],
            },
            monitored_resource={
                "type": "uptime_url",
                "labels": {
                    "project_id": "my-project-name",
                    "host": "192.168.1.1",
                },
            },
            content_matchers=[{
                "content": "\\"example\\"",
                "matcher": "MATCHES_JSON_PATH",
                "json_path_matcher": {
                    "json_path": "$.path",
                    "json_matcher": "EXACT_MATCH",
                },
            }],
            checker_type="STATIC_IP_CHECKERS")
        ```
        ### Uptime Check Config Https

        ```python
        import pulumi
        import pulumi_gcp as gcp

        https = gcp.monitoring.UptimeCheckConfig("https",
            display_name="https-uptime-check",
            timeout="60s",
            http_check={
                "path": "/some-path",
                "port": 443,
                "use_ssl": True,
                "validate_ssl": True,
                "service_agent_authentication": {
                    "type": "OIDC_TOKEN",
                },
            },
            monitored_resource={
                "type": "uptime_url",
                "labels": {
                    "project_id": "my-project-name",
                    "host": "192.168.1.1",
                },
            },
            content_matchers=[{
                "content": "example",
                "matcher": "MATCHES_JSON_PATH",
                "json_path_matcher": {
                    "json_path": "$.path",
                    "json_matcher": "REGEX_MATCH",
                },
            }])
        ```
        ### Uptime Check Tcp

        ```python
        import pulumi
        import pulumi_gcp as gcp

        check = gcp.monitoring.Group("check",
            display_name="uptime-check-group",
            filter="resource.metadata.name=has_substring(\\"foo\\")")
        tcp_group = gcp.monitoring.UptimeCheckConfig("tcp_group",
            display_name="tcp-uptime-check",
            timeout="60s",
            tcp_check={
                "port": 888,
                "ping_config": {
                    "pings_count": 2,
                },
            },
            resource_group={
                "resource_type": "INSTANCE",
                "group_id": check.name,
            })
        ```
        ### Uptime Check Config Synthetic Monitor

        ```python
        import pulumi
        import pulumi_gcp as gcp

        bucket = gcp.storage.Bucket("bucket",
            name="my-project-name-gcf-source",
            location="US",
            uniform_bucket_level_access=True)
        object = gcp.storage.BucketObject("object",
            name="function-source.zip",
            bucket=bucket.name,
            source=pulumi.FileAsset("synthetic-fn-source.zip"))
        function = gcp.cloudfunctionsv2.Function("function",
            name="synthetic_function",
            location="us-central1",
            build_config={
                "runtime": "nodejs20",
                "entry_point": "SyntheticFunction",
                "source": {
                    "storage_source": {
                        "bucket": bucket.name,
                        "object": object.name,
                    },
                },
            },
            service_config={
                "max_instance_count": 1,
                "available_memory": "256M",
                "timeout_seconds": 60,
            })
        synthetic_monitor = gcp.monitoring.UptimeCheckConfig("synthetic_monitor",
            display_name="synthetic_monitor",
            timeout="60s",
            synthetic_monitor={
                "cloud_function_v2": {
                    "name": function.id,
                },
            })
        ```

        ## Ephemeral Attributes Reference

        The following write-only attributes are supported:

        ## Import

        UptimeCheckConfig can be imported using any of these accepted formats:

        * `{{project}}/{{name}}`

        * `{{project}} {{name}}`

        * `{{name}}`

        When using the `pulumi import` command, UptimeCheckConfig can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:monitoring/uptimeCheckConfig:UptimeCheckConfig default {{project}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:monitoring/uptimeCheckConfig:UptimeCheckConfig default "{{project}} {{name}}"
        ```

        ```sh
        $ pulumi import gcp:monitoring/uptimeCheckConfig:UptimeCheckConfig default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] checker_type: The checker type to use for the check. If the monitored resource type is `servicedirectory_service`, `checker_type` must be set to `VPC_CHECKERS`.
               Possible values are: `STATIC_IP_CHECKERS`, `VPC_CHECKERS`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['UptimeCheckConfigContentMatcherArgs', 'UptimeCheckConfigContentMatcherArgsDict']]]] content_matchers: The expected content on the page the check is run against. Currently, only the first entry in the list is supported, and other entries will be ignored. The server will look for an exact match of the string in the page response's content. This field is optional and should only be specified if a content match is required.
               Structure is documented below.
        :param pulumi.Input[builtins.str] display_name: A human-friendly name for the uptime check configuration. The display name should be unique within a Stackdriver Workspace in order to make it easier to identify; however, uniqueness is not enforced.
        :param pulumi.Input[Union['UptimeCheckConfigHttpCheckArgs', 'UptimeCheckConfigHttpCheckArgsDict']] http_check: Contains information needed to make an HTTP or HTTPS check.
               Structure is documented below.
        :param pulumi.Input[builtins.bool] log_check_failures: Specifies whether to log the results of failed probes to Cloud Logging.
        :param pulumi.Input[Union['UptimeCheckConfigMonitoredResourceArgs', 'UptimeCheckConfigMonitoredResourceArgsDict']] monitored_resource: The [monitored resource]
               (https://cloud.google.com/monitoring/api/resources) associated with the
               configuration. The following monitored resource types are supported for
               uptime checks:
        :param pulumi.Input[builtins.str] period: How often, in seconds, the uptime check is performed. Currently, the only supported values are 60s (1 minute), 300s (5 minutes), 600s (10 minutes), and 900s (15 minutes). Optional, defaults to 300s.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['UptimeCheckConfigResourceGroupArgs', 'UptimeCheckConfigResourceGroupArgsDict']] resource_group: The group resource associated with the configuration.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] selected_regions: The list of regions from which the check will be run. Some regions contain one location, and others contain more than one. If this field is specified, enough regions to include a minimum of 3 locations must be provided, or an error message is returned. Not specifying this field will result in uptime checks running from all regions.
        :param pulumi.Input[Union['UptimeCheckConfigSyntheticMonitorArgs', 'UptimeCheckConfigSyntheticMonitorArgsDict']] synthetic_monitor: A Synthetic Monitor deployed to a Cloud Functions V2 instance.
               Structure is documented below.
        :param pulumi.Input[Union['UptimeCheckConfigTcpCheckArgs', 'UptimeCheckConfigTcpCheckArgsDict']] tcp_check: Contains information needed to make a TCP check.
               Structure is documented below.
        :param pulumi.Input[builtins.str] timeout: The maximum amount of time to wait for the request to complete (must be between 1 and 60 seconds). See the accepted formats
               
               
               - - -
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] user_labels: User-supplied key/value data to be used for organizing and identifying the `UptimeCheckConfig` objects. The field can contain up to 64 entries. Each key and value is limited to 63 Unicode characters or 128 bytes, whichever is smaller. Labels and values can contain only lowercase letters, numerals, underscores, and dashes. Keys must begin with a letter.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UptimeCheckConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This message configures which resources and services to monitor for availability.

        To get more information about UptimeCheckConfig, see:

        * [API documentation](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.uptimeCheckConfigs)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/monitoring/uptime-checks/)

        ## Example Usage

        ### Uptime Check Config Http

        ```python
        import pulumi
        import pulumi_gcp as gcp

        http = gcp.monitoring.UptimeCheckConfig("http",
            display_name="http-uptime-check",
            timeout="60s",
            log_check_failures=True,
            user_labels={
                "example-key": "example-value",
            },
            http_check={
                "path": "some-path",
                "port": 8010,
                "request_method": "POST",
                "content_type": "USER_PROVIDED",
                "custom_content_type": "application/json",
                "body": "Zm9vJTI1M0RiYXI=",
                "ping_config": {
                    "pings_count": 1,
                },
            },
            monitored_resource={
                "type": "uptime_url",
                "labels": {
                    "project_id": "my-project-name",
                    "host": "192.168.1.1",
                },
            },
            content_matchers=[{
                "content": "\\"example\\"",
                "matcher": "MATCHES_JSON_PATH",
                "json_path_matcher": {
                    "json_path": "$.path",
                    "json_matcher": "EXACT_MATCH",
                },
            }],
            checker_type="STATIC_IP_CHECKERS")
        ```
        ### Uptime Check Config Status Code

        ```python
        import pulumi
        import pulumi_gcp as gcp

        status_code = gcp.monitoring.UptimeCheckConfig("status_code",
            display_name="http-uptime-check",
            timeout="60s",
            http_check={
                "path": "some-path",
                "port": 8010,
                "request_method": "POST",
                "content_type": "URL_ENCODED",
                "body": "Zm9vJTI1M0RiYXI=",
                "accepted_response_status_codes": [
                    {
                        "status_class": "STATUS_CLASS_2XX",
                    },
                    {
                        "status_value": 301,
                    },
                    {
                        "status_value": 302,
                    },
                ],
            },
            monitored_resource={
                "type": "uptime_url",
                "labels": {
                    "project_id": "my-project-name",
                    "host": "192.168.1.1",
                },
            },
            content_matchers=[{
                "content": "\\"example\\"",
                "matcher": "MATCHES_JSON_PATH",
                "json_path_matcher": {
                    "json_path": "$.path",
                    "json_matcher": "EXACT_MATCH",
                },
            }],
            checker_type="STATIC_IP_CHECKERS")
        ```
        ### Uptime Check Config Https

        ```python
        import pulumi
        import pulumi_gcp as gcp

        https = gcp.monitoring.UptimeCheckConfig("https",
            display_name="https-uptime-check",
            timeout="60s",
            http_check={
                "path": "/some-path",
                "port": 443,
                "use_ssl": True,
                "validate_ssl": True,
                "service_agent_authentication": {
                    "type": "OIDC_TOKEN",
                },
            },
            monitored_resource={
                "type": "uptime_url",
                "labels": {
                    "project_id": "my-project-name",
                    "host": "192.168.1.1",
                },
            },
            content_matchers=[{
                "content": "example",
                "matcher": "MATCHES_JSON_PATH",
                "json_path_matcher": {
                    "json_path": "$.path",
                    "json_matcher": "REGEX_MATCH",
                },
            }])
        ```
        ### Uptime Check Tcp

        ```python
        import pulumi
        import pulumi_gcp as gcp

        check = gcp.monitoring.Group("check",
            display_name="uptime-check-group",
            filter="resource.metadata.name=has_substring(\\"foo\\")")
        tcp_group = gcp.monitoring.UptimeCheckConfig("tcp_group",
            display_name="tcp-uptime-check",
            timeout="60s",
            tcp_check={
                "port": 888,
                "ping_config": {
                    "pings_count": 2,
                },
            },
            resource_group={
                "resource_type": "INSTANCE",
                "group_id": check.name,
            })
        ```
        ### Uptime Check Config Synthetic Monitor

        ```python
        import pulumi
        import pulumi_gcp as gcp

        bucket = gcp.storage.Bucket("bucket",
            name="my-project-name-gcf-source",
            location="US",
            uniform_bucket_level_access=True)
        object = gcp.storage.BucketObject("object",
            name="function-source.zip",
            bucket=bucket.name,
            source=pulumi.FileAsset("synthetic-fn-source.zip"))
        function = gcp.cloudfunctionsv2.Function("function",
            name="synthetic_function",
            location="us-central1",
            build_config={
                "runtime": "nodejs20",
                "entry_point": "SyntheticFunction",
                "source": {
                    "storage_source": {
                        "bucket": bucket.name,
                        "object": object.name,
                    },
                },
            },
            service_config={
                "max_instance_count": 1,
                "available_memory": "256M",
                "timeout_seconds": 60,
            })
        synthetic_monitor = gcp.monitoring.UptimeCheckConfig("synthetic_monitor",
            display_name="synthetic_monitor",
            timeout="60s",
            synthetic_monitor={
                "cloud_function_v2": {
                    "name": function.id,
                },
            })
        ```

        ## Ephemeral Attributes Reference

        The following write-only attributes are supported:

        ## Import

        UptimeCheckConfig can be imported using any of these accepted formats:

        * `{{project}}/{{name}}`

        * `{{project}} {{name}}`

        * `{{name}}`

        When using the `pulumi import` command, UptimeCheckConfig can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:monitoring/uptimeCheckConfig:UptimeCheckConfig default {{project}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:monitoring/uptimeCheckConfig:UptimeCheckConfig default "{{project}} {{name}}"
        ```

        ```sh
        $ pulumi import gcp:monitoring/uptimeCheckConfig:UptimeCheckConfig default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param UptimeCheckConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UptimeCheckConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 checker_type: Optional[pulumi.Input[builtins.str]] = None,
                 content_matchers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UptimeCheckConfigContentMatcherArgs', 'UptimeCheckConfigContentMatcherArgsDict']]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 http_check: Optional[pulumi.Input[Union['UptimeCheckConfigHttpCheckArgs', 'UptimeCheckConfigHttpCheckArgsDict']]] = None,
                 log_check_failures: Optional[pulumi.Input[builtins.bool]] = None,
                 monitored_resource: Optional[pulumi.Input[Union['UptimeCheckConfigMonitoredResourceArgs', 'UptimeCheckConfigMonitoredResourceArgsDict']]] = None,
                 period: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group: Optional[pulumi.Input[Union['UptimeCheckConfigResourceGroupArgs', 'UptimeCheckConfigResourceGroupArgsDict']]] = None,
                 selected_regions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 synthetic_monitor: Optional[pulumi.Input[Union['UptimeCheckConfigSyntheticMonitorArgs', 'UptimeCheckConfigSyntheticMonitorArgsDict']]] = None,
                 tcp_check: Optional[pulumi.Input[Union['UptimeCheckConfigTcpCheckArgs', 'UptimeCheckConfigTcpCheckArgsDict']]] = None,
                 timeout: Optional[pulumi.Input[builtins.str]] = None,
                 user_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UptimeCheckConfigArgs.__new__(UptimeCheckConfigArgs)

            __props__.__dict__["checker_type"] = checker_type
            __props__.__dict__["content_matchers"] = content_matchers
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["http_check"] = http_check
            __props__.__dict__["log_check_failures"] = log_check_failures
            __props__.__dict__["monitored_resource"] = monitored_resource
            __props__.__dict__["period"] = period
            __props__.__dict__["project"] = project
            __props__.__dict__["resource_group"] = resource_group
            __props__.__dict__["selected_regions"] = selected_regions
            __props__.__dict__["synthetic_monitor"] = synthetic_monitor
            __props__.__dict__["tcp_check"] = tcp_check
            if timeout is None and not opts.urn:
                raise TypeError("Missing required property 'timeout'")
            __props__.__dict__["timeout"] = timeout
            __props__.__dict__["user_labels"] = user_labels
            __props__.__dict__["name"] = None
            __props__.__dict__["uptime_check_id"] = None
        super(UptimeCheckConfig, __self__).__init__(
            'gcp:monitoring/uptimeCheckConfig:UptimeCheckConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            checker_type: Optional[pulumi.Input[builtins.str]] = None,
            content_matchers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UptimeCheckConfigContentMatcherArgs', 'UptimeCheckConfigContentMatcherArgsDict']]]]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            http_check: Optional[pulumi.Input[Union['UptimeCheckConfigHttpCheckArgs', 'UptimeCheckConfigHttpCheckArgsDict']]] = None,
            log_check_failures: Optional[pulumi.Input[builtins.bool]] = None,
            monitored_resource: Optional[pulumi.Input[Union['UptimeCheckConfigMonitoredResourceArgs', 'UptimeCheckConfigMonitoredResourceArgsDict']]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            period: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            resource_group: Optional[pulumi.Input[Union['UptimeCheckConfigResourceGroupArgs', 'UptimeCheckConfigResourceGroupArgsDict']]] = None,
            selected_regions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            synthetic_monitor: Optional[pulumi.Input[Union['UptimeCheckConfigSyntheticMonitorArgs', 'UptimeCheckConfigSyntheticMonitorArgsDict']]] = None,
            tcp_check: Optional[pulumi.Input[Union['UptimeCheckConfigTcpCheckArgs', 'UptimeCheckConfigTcpCheckArgsDict']]] = None,
            timeout: Optional[pulumi.Input[builtins.str]] = None,
            uptime_check_id: Optional[pulumi.Input[builtins.str]] = None,
            user_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None) -> 'UptimeCheckConfig':
        """
        Get an existing UptimeCheckConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] checker_type: The checker type to use for the check. If the monitored resource type is `servicedirectory_service`, `checker_type` must be set to `VPC_CHECKERS`.
               Possible values are: `STATIC_IP_CHECKERS`, `VPC_CHECKERS`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['UptimeCheckConfigContentMatcherArgs', 'UptimeCheckConfigContentMatcherArgsDict']]]] content_matchers: The expected content on the page the check is run against. Currently, only the first entry in the list is supported, and other entries will be ignored. The server will look for an exact match of the string in the page response's content. This field is optional and should only be specified if a content match is required.
               Structure is documented below.
        :param pulumi.Input[builtins.str] display_name: A human-friendly name for the uptime check configuration. The display name should be unique within a Stackdriver Workspace in order to make it easier to identify; however, uniqueness is not enforced.
        :param pulumi.Input[Union['UptimeCheckConfigHttpCheckArgs', 'UptimeCheckConfigHttpCheckArgsDict']] http_check: Contains information needed to make an HTTP or HTTPS check.
               Structure is documented below.
        :param pulumi.Input[builtins.bool] log_check_failures: Specifies whether to log the results of failed probes to Cloud Logging.
        :param pulumi.Input[Union['UptimeCheckConfigMonitoredResourceArgs', 'UptimeCheckConfigMonitoredResourceArgsDict']] monitored_resource: The [monitored resource]
               (https://cloud.google.com/monitoring/api/resources) associated with the
               configuration. The following monitored resource types are supported for
               uptime checks:
        :param pulumi.Input[builtins.str] name: A unique resource name for this UptimeCheckConfig. The format is `projects/[PROJECT_ID]/uptimeCheckConfigs/[UPTIME_CHECK_ID]`.
        :param pulumi.Input[builtins.str] period: How often, in seconds, the uptime check is performed. Currently, the only supported values are 60s (1 minute), 300s (5 minutes), 600s (10 minutes), and 900s (15 minutes). Optional, defaults to 300s.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['UptimeCheckConfigResourceGroupArgs', 'UptimeCheckConfigResourceGroupArgsDict']] resource_group: The group resource associated with the configuration.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] selected_regions: The list of regions from which the check will be run. Some regions contain one location, and others contain more than one. If this field is specified, enough regions to include a minimum of 3 locations must be provided, or an error message is returned. Not specifying this field will result in uptime checks running from all regions.
        :param pulumi.Input[Union['UptimeCheckConfigSyntheticMonitorArgs', 'UptimeCheckConfigSyntheticMonitorArgsDict']] synthetic_monitor: A Synthetic Monitor deployed to a Cloud Functions V2 instance.
               Structure is documented below.
        :param pulumi.Input[Union['UptimeCheckConfigTcpCheckArgs', 'UptimeCheckConfigTcpCheckArgsDict']] tcp_check: Contains information needed to make a TCP check.
               Structure is documented below.
        :param pulumi.Input[builtins.str] timeout: The maximum amount of time to wait for the request to complete (must be between 1 and 60 seconds). See the accepted formats
               
               
               - - -
        :param pulumi.Input[builtins.str] uptime_check_id: The id of the uptime check
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] user_labels: User-supplied key/value data to be used for organizing and identifying the `UptimeCheckConfig` objects. The field can contain up to 64 entries. Each key and value is limited to 63 Unicode characters or 128 bytes, whichever is smaller. Labels and values can contain only lowercase letters, numerals, underscores, and dashes. Keys must begin with a letter.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UptimeCheckConfigState.__new__(_UptimeCheckConfigState)

        __props__.__dict__["checker_type"] = checker_type
        __props__.__dict__["content_matchers"] = content_matchers
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["http_check"] = http_check
        __props__.__dict__["log_check_failures"] = log_check_failures
        __props__.__dict__["monitored_resource"] = monitored_resource
        __props__.__dict__["name"] = name
        __props__.__dict__["period"] = period
        __props__.__dict__["project"] = project
        __props__.__dict__["resource_group"] = resource_group
        __props__.__dict__["selected_regions"] = selected_regions
        __props__.__dict__["synthetic_monitor"] = synthetic_monitor
        __props__.__dict__["tcp_check"] = tcp_check
        __props__.__dict__["timeout"] = timeout
        __props__.__dict__["uptime_check_id"] = uptime_check_id
        __props__.__dict__["user_labels"] = user_labels
        return UptimeCheckConfig(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="checkerType")
    def checker_type(self) -> pulumi.Output[builtins.str]:
        """
        The checker type to use for the check. If the monitored resource type is `servicedirectory_service`, `checker_type` must be set to `VPC_CHECKERS`.
        Possible values are: `STATIC_IP_CHECKERS`, `VPC_CHECKERS`.
        """
        return pulumi.get(self, "checker_type")

    @property
    @pulumi.getter(name="contentMatchers")
    def content_matchers(self) -> pulumi.Output[Optional[Sequence['outputs.UptimeCheckConfigContentMatcher']]]:
        """
        The expected content on the page the check is run against. Currently, only the first entry in the list is supported, and other entries will be ignored. The server will look for an exact match of the string in the page response's content. This field is optional and should only be specified if a content match is required.
        Structure is documented below.
        """
        return pulumi.get(self, "content_matchers")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        A human-friendly name for the uptime check configuration. The display name should be unique within a Stackdriver Workspace in order to make it easier to identify; however, uniqueness is not enforced.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="httpCheck")
    def http_check(self) -> pulumi.Output[Optional['outputs.UptimeCheckConfigHttpCheck']]:
        """
        Contains information needed to make an HTTP or HTTPS check.
        Structure is documented below.
        """
        return pulumi.get(self, "http_check")

    @property
    @pulumi.getter(name="logCheckFailures")
    def log_check_failures(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Specifies whether to log the results of failed probes to Cloud Logging.
        """
        return pulumi.get(self, "log_check_failures")

    @property
    @pulumi.getter(name="monitoredResource")
    def monitored_resource(self) -> pulumi.Output[Optional['outputs.UptimeCheckConfigMonitoredResource']]:
        """
        The [monitored resource]
        (https://cloud.google.com/monitoring/api/resources) associated with the
        configuration. The following monitored resource types are supported for
        uptime checks:
        """
        return pulumi.get(self, "monitored_resource")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        A unique resource name for this UptimeCheckConfig. The format is `projects/[PROJECT_ID]/uptimeCheckConfigs/[UPTIME_CHECK_ID]`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        How often, in seconds, the uptime check is performed. Currently, the only supported values are 60s (1 minute), 300s (5 minutes), 600s (10 minutes), and 900s (15 minutes). Optional, defaults to 300s.
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> pulumi.Output[Optional['outputs.UptimeCheckConfigResourceGroup']]:
        """
        The group resource associated with the configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "resource_group")

    @property
    @pulumi.getter(name="selectedRegions")
    def selected_regions(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        The list of regions from which the check will be run. Some regions contain one location, and others contain more than one. If this field is specified, enough regions to include a minimum of 3 locations must be provided, or an error message is returned. Not specifying this field will result in uptime checks running from all regions.
        """
        return pulumi.get(self, "selected_regions")

    @property
    @pulumi.getter(name="syntheticMonitor")
    def synthetic_monitor(self) -> pulumi.Output[Optional['outputs.UptimeCheckConfigSyntheticMonitor']]:
        """
        A Synthetic Monitor deployed to a Cloud Functions V2 instance.
        Structure is documented below.
        """
        return pulumi.get(self, "synthetic_monitor")

    @property
    @pulumi.getter(name="tcpCheck")
    def tcp_check(self) -> pulumi.Output[Optional['outputs.UptimeCheckConfigTcpCheck']]:
        """
        Contains information needed to make a TCP check.
        Structure is documented below.
        """
        return pulumi.get(self, "tcp_check")

    @property
    @pulumi.getter
    def timeout(self) -> pulumi.Output[builtins.str]:
        """
        The maximum amount of time to wait for the request to complete (must be between 1 and 60 seconds). See the accepted formats


        - - -
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter(name="uptimeCheckId")
    def uptime_check_id(self) -> pulumi.Output[builtins.str]:
        """
        The id of the uptime check
        """
        return pulumi.get(self, "uptime_check_id")

    @property
    @pulumi.getter(name="userLabels")
    def user_labels(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        User-supplied key/value data to be used for organizing and identifying the `UptimeCheckConfig` objects. The field can contain up to 64 entries. Each key and value is limited to 63 Unicode characters or 128 bytes, whichever is smaller. Labels and values can contain only lowercase letters, numerals, underscores, and dashes. Keys must begin with a letter.
        """
        return pulumi.get(self, "user_labels")

