# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'BackupVaultBackupRetentionPolicy',
    'VolumeBackupConfig',
    'VolumeExportPolicy',
    'VolumeExportPolicyRule',
    'VolumeHybridReplicationParameters',
    'VolumeMountOption',
    'VolumeReplicationDestinationVolumeParameters',
    'VolumeReplicationDestinationVolumeParametersTieringPolicy',
    'VolumeReplicationHybridPeeringDetail',
    'VolumeReplicationTransferStat',
    'VolumeRestoreParameters',
    'VolumeSnapshotPolicy',
    'VolumeSnapshotPolicyDailySchedule',
    'VolumeSnapshotPolicyHourlySchedule',
    'VolumeSnapshotPolicyMonthlySchedule',
    'VolumeSnapshotPolicyWeeklySchedule',
    'VolumeTieringPolicy',
]

@pulumi.output_type
class BackupVaultBackupRetentionPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupMinimumEnforcedRetentionDays":
            suggest = "backup_minimum_enforced_retention_days"
        elif key == "dailyBackupImmutable":
            suggest = "daily_backup_immutable"
        elif key == "manualBackupImmutable":
            suggest = "manual_backup_immutable"
        elif key == "monthlyBackupImmutable":
            suggest = "monthly_backup_immutable"
        elif key == "weeklyBackupImmutable":
            suggest = "weekly_backup_immutable"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupVaultBackupRetentionPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupVaultBackupRetentionPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupVaultBackupRetentionPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_minimum_enforced_retention_days: builtins.int,
                 daily_backup_immutable: Optional[builtins.bool] = None,
                 manual_backup_immutable: Optional[builtins.bool] = None,
                 monthly_backup_immutable: Optional[builtins.bool] = None,
                 weekly_backup_immutable: Optional[builtins.bool] = None):
        """
        :param builtins.int backup_minimum_enforced_retention_days: Minimum retention duration in days for backups in the backup vault.
        :param builtins.bool daily_backup_immutable: Indicates if the daily backups are immutable. At least one of daily_backup_immutable, weekly_backup_immutable, monthly_backup_immutable and manual_backup_immutable must be true.
        :param builtins.bool manual_backup_immutable: Indicates if the manual backups are immutable. At least one of daily_backup_immutable, weekly_backup_immutable, monthly_backup_immutable and manual_backup_immutable must be true.
        :param builtins.bool monthly_backup_immutable: Indicates if the monthly backups are immutable. At least one of daily_backup_immutable, weekly_backup_immutable, monthly_backup_immutable and manual_backup_immutable must be true.
        :param builtins.bool weekly_backup_immutable: Indicates if the weekly backups are immutable. At least one of daily_backup_immutable, weekly_backup_immutable, monthly_backup_immutable and manual_backup_immutable must be true.
        """
        pulumi.set(__self__, "backup_minimum_enforced_retention_days", backup_minimum_enforced_retention_days)
        if daily_backup_immutable is not None:
            pulumi.set(__self__, "daily_backup_immutable", daily_backup_immutable)
        if manual_backup_immutable is not None:
            pulumi.set(__self__, "manual_backup_immutable", manual_backup_immutable)
        if monthly_backup_immutable is not None:
            pulumi.set(__self__, "monthly_backup_immutable", monthly_backup_immutable)
        if weekly_backup_immutable is not None:
            pulumi.set(__self__, "weekly_backup_immutable", weekly_backup_immutable)

    @property
    @pulumi.getter(name="backupMinimumEnforcedRetentionDays")
    def backup_minimum_enforced_retention_days(self) -> builtins.int:
        """
        Minimum retention duration in days for backups in the backup vault.
        """
        return pulumi.get(self, "backup_minimum_enforced_retention_days")

    @property
    @pulumi.getter(name="dailyBackupImmutable")
    def daily_backup_immutable(self) -> Optional[builtins.bool]:
        """
        Indicates if the daily backups are immutable. At least one of daily_backup_immutable, weekly_backup_immutable, monthly_backup_immutable and manual_backup_immutable must be true.
        """
        return pulumi.get(self, "daily_backup_immutable")

    @property
    @pulumi.getter(name="manualBackupImmutable")
    def manual_backup_immutable(self) -> Optional[builtins.bool]:
        """
        Indicates if the manual backups are immutable. At least one of daily_backup_immutable, weekly_backup_immutable, monthly_backup_immutable and manual_backup_immutable must be true.
        """
        return pulumi.get(self, "manual_backup_immutable")

    @property
    @pulumi.getter(name="monthlyBackupImmutable")
    def monthly_backup_immutable(self) -> Optional[builtins.bool]:
        """
        Indicates if the monthly backups are immutable. At least one of daily_backup_immutable, weekly_backup_immutable, monthly_backup_immutable and manual_backup_immutable must be true.
        """
        return pulumi.get(self, "monthly_backup_immutable")

    @property
    @pulumi.getter(name="weeklyBackupImmutable")
    def weekly_backup_immutable(self) -> Optional[builtins.bool]:
        """
        Indicates if the weekly backups are immutable. At least one of daily_backup_immutable, weekly_backup_immutable, monthly_backup_immutable and manual_backup_immutable must be true.
        """
        return pulumi.get(self, "weekly_backup_immutable")


@pulumi.output_type
class VolumeBackupConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupPolicies":
            suggest = "backup_policies"
        elif key == "backupVault":
            suggest = "backup_vault"
        elif key == "scheduledBackupEnabled":
            suggest = "scheduled_backup_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeBackupConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeBackupConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeBackupConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_policies: Optional[Sequence[builtins.str]] = None,
                 backup_vault: Optional[builtins.str] = None,
                 scheduled_backup_enabled: Optional[builtins.bool] = None):
        """
        :param Sequence[builtins.str] backup_policies: Specify a single backup policy ID for scheduled backups. Format: `projects/{{projectId}}/locations/{{location}}/backupPolicies/{{backupPolicyName}}`
        :param builtins.str backup_vault: ID of the backup vault to use. A backup vault is reqired to create manual or scheduled backups.
               Format: `projects/{{projectId}}/locations/{{location}}/backupVaults/{{backupVaultName}}`
        :param builtins.bool scheduled_backup_enabled: When set to true, scheduled backup is enabled on the volume. Omit if no backup_policy is specified.
        """
        if backup_policies is not None:
            pulumi.set(__self__, "backup_policies", backup_policies)
        if backup_vault is not None:
            pulumi.set(__self__, "backup_vault", backup_vault)
        if scheduled_backup_enabled is not None:
            pulumi.set(__self__, "scheduled_backup_enabled", scheduled_backup_enabled)

    @property
    @pulumi.getter(name="backupPolicies")
    def backup_policies(self) -> Optional[Sequence[builtins.str]]:
        """
        Specify a single backup policy ID for scheduled backups. Format: `projects/{{projectId}}/locations/{{location}}/backupPolicies/{{backupPolicyName}}`
        """
        return pulumi.get(self, "backup_policies")

    @property
    @pulumi.getter(name="backupVault")
    def backup_vault(self) -> Optional[builtins.str]:
        """
        ID of the backup vault to use. A backup vault is reqired to create manual or scheduled backups.
        Format: `projects/{{projectId}}/locations/{{location}}/backupVaults/{{backupVaultName}}`
        """
        return pulumi.get(self, "backup_vault")

    @property
    @pulumi.getter(name="scheduledBackupEnabled")
    def scheduled_backup_enabled(self) -> Optional[builtins.bool]:
        """
        When set to true, scheduled backup is enabled on the volume. Omit if no backup_policy is specified.
        """
        return pulumi.get(self, "scheduled_backup_enabled")


@pulumi.output_type
class VolumeExportPolicy(dict):
    def __init__(__self__, *,
                 rules: Sequence['outputs.VolumeExportPolicyRule']):
        """
        :param Sequence['VolumeExportPolicyRuleArgs'] rules: Export rules (up to 5) control NFS volume access.
               Structure is documented below.
        """
        pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.VolumeExportPolicyRule']:
        """
        Export rules (up to 5) control NFS volume access.
        Structure is documented below.
        """
        return pulumi.get(self, "rules")


@pulumi.output_type
class VolumeExportPolicyRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessType":
            suggest = "access_type"
        elif key == "allowedClients":
            suggest = "allowed_clients"
        elif key == "hasRootAccess":
            suggest = "has_root_access"
        elif key == "kerberos5ReadOnly":
            suggest = "kerberos5_read_only"
        elif key == "kerberos5ReadWrite":
            suggest = "kerberos5_read_write"
        elif key == "kerberos5iReadOnly":
            suggest = "kerberos5i_read_only"
        elif key == "kerberos5iReadWrite":
            suggest = "kerberos5i_read_write"
        elif key == "kerberos5pReadOnly":
            suggest = "kerberos5p_read_only"
        elif key == "kerberos5pReadWrite":
            suggest = "kerberos5p_read_write"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeExportPolicyRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeExportPolicyRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeExportPolicyRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_type: Optional[builtins.str] = None,
                 allowed_clients: Optional[builtins.str] = None,
                 has_root_access: Optional[builtins.str] = None,
                 kerberos5_read_only: Optional[builtins.bool] = None,
                 kerberos5_read_write: Optional[builtins.bool] = None,
                 kerberos5i_read_only: Optional[builtins.bool] = None,
                 kerberos5i_read_write: Optional[builtins.bool] = None,
                 kerberos5p_read_only: Optional[builtins.bool] = None,
                 kerberos5p_read_write: Optional[builtins.bool] = None,
                 nfsv3: Optional[builtins.bool] = None,
                 nfsv4: Optional[builtins.bool] = None):
        """
        :param builtins.str access_type: Defines the access type for clients matching the `allowedClients` specification.
               Possible values are: `READ_ONLY`, `READ_WRITE`, `READ_NONE`.
        :param builtins.str allowed_clients: Defines the client ingress specification (allowed clients) as a comma separated list with IPv4 CIDRs or IPv4 host addresses.
        :param builtins.str has_root_access: If enabled, the root user (UID = 0) of the specified clients doesn't get mapped to nobody (UID = 65534). This is also known as no_root_squash.
        :param builtins.bool kerberos5_read_only: If enabled (true) the rule defines a read only access for clients matching the 'allowedClients' specification. It enables nfs clients to mount using 'authentication' kerberos security mode.
        :param builtins.bool kerberos5_read_write: If enabled (true) the rule defines read and write access for clients matching the 'allowedClients' specification. It enables nfs clients to mount using 'authentication' kerberos security mode. The 'kerberos5ReadOnly' value is ignored if this is enabled.
        :param builtins.bool kerberos5i_read_only: If enabled (true) the rule defines a read only access for clients matching the 'allowedClients' specification. It enables nfs clients to mount using 'integrity' kerberos security mode.
        :param builtins.bool kerberos5i_read_write: If enabled (true) the rule defines read and write access for clients matching the 'allowedClients' specification. It enables nfs clients to mount using 'integrity' kerberos security mode. The 'kerberos5iReadOnly' value is ignored if this is enabled.
        :param builtins.bool kerberos5p_read_only: If enabled (true) the rule defines a read only access for clients matching the 'allowedClients' specification. It enables nfs clients to mount using 'privacy' kerberos security mode.
        :param builtins.bool kerberos5p_read_write: If enabled (true) the rule defines read and write access for clients matching the 'allowedClients' specification. It enables nfs clients to mount using 'privacy' kerberos security mode. The 'kerberos5pReadOnly' value is ignored if this is enabled.
        :param builtins.bool nfsv3: Enable to apply the export rule to NFSV3 clients.
        :param builtins.bool nfsv4: Enable to apply the export rule to NFSV4.1 clients.
        """
        if access_type is not None:
            pulumi.set(__self__, "access_type", access_type)
        if allowed_clients is not None:
            pulumi.set(__self__, "allowed_clients", allowed_clients)
        if has_root_access is not None:
            pulumi.set(__self__, "has_root_access", has_root_access)
        if kerberos5_read_only is not None:
            pulumi.set(__self__, "kerberos5_read_only", kerberos5_read_only)
        if kerberos5_read_write is not None:
            pulumi.set(__self__, "kerberos5_read_write", kerberos5_read_write)
        if kerberos5i_read_only is not None:
            pulumi.set(__self__, "kerberos5i_read_only", kerberos5i_read_only)
        if kerberos5i_read_write is not None:
            pulumi.set(__self__, "kerberos5i_read_write", kerberos5i_read_write)
        if kerberos5p_read_only is not None:
            pulumi.set(__self__, "kerberos5p_read_only", kerberos5p_read_only)
        if kerberos5p_read_write is not None:
            pulumi.set(__self__, "kerberos5p_read_write", kerberos5p_read_write)
        if nfsv3 is not None:
            pulumi.set(__self__, "nfsv3", nfsv3)
        if nfsv4 is not None:
            pulumi.set(__self__, "nfsv4", nfsv4)

    @property
    @pulumi.getter(name="accessType")
    def access_type(self) -> Optional[builtins.str]:
        """
        Defines the access type for clients matching the `allowedClients` specification.
        Possible values are: `READ_ONLY`, `READ_WRITE`, `READ_NONE`.
        """
        return pulumi.get(self, "access_type")

    @property
    @pulumi.getter(name="allowedClients")
    def allowed_clients(self) -> Optional[builtins.str]:
        """
        Defines the client ingress specification (allowed clients) as a comma separated list with IPv4 CIDRs or IPv4 host addresses.
        """
        return pulumi.get(self, "allowed_clients")

    @property
    @pulumi.getter(name="hasRootAccess")
    def has_root_access(self) -> Optional[builtins.str]:
        """
        If enabled, the root user (UID = 0) of the specified clients doesn't get mapped to nobody (UID = 65534). This is also known as no_root_squash.
        """
        return pulumi.get(self, "has_root_access")

    @property
    @pulumi.getter(name="kerberos5ReadOnly")
    def kerberos5_read_only(self) -> Optional[builtins.bool]:
        """
        If enabled (true) the rule defines a read only access for clients matching the 'allowedClients' specification. It enables nfs clients to mount using 'authentication' kerberos security mode.
        """
        return pulumi.get(self, "kerberos5_read_only")

    @property
    @pulumi.getter(name="kerberos5ReadWrite")
    def kerberos5_read_write(self) -> Optional[builtins.bool]:
        """
        If enabled (true) the rule defines read and write access for clients matching the 'allowedClients' specification. It enables nfs clients to mount using 'authentication' kerberos security mode. The 'kerberos5ReadOnly' value is ignored if this is enabled.
        """
        return pulumi.get(self, "kerberos5_read_write")

    @property
    @pulumi.getter(name="kerberos5iReadOnly")
    def kerberos5i_read_only(self) -> Optional[builtins.bool]:
        """
        If enabled (true) the rule defines a read only access for clients matching the 'allowedClients' specification. It enables nfs clients to mount using 'integrity' kerberos security mode.
        """
        return pulumi.get(self, "kerberos5i_read_only")

    @property
    @pulumi.getter(name="kerberos5iReadWrite")
    def kerberos5i_read_write(self) -> Optional[builtins.bool]:
        """
        If enabled (true) the rule defines read and write access for clients matching the 'allowedClients' specification. It enables nfs clients to mount using 'integrity' kerberos security mode. The 'kerberos5iReadOnly' value is ignored if this is enabled.
        """
        return pulumi.get(self, "kerberos5i_read_write")

    @property
    @pulumi.getter(name="kerberos5pReadOnly")
    def kerberos5p_read_only(self) -> Optional[builtins.bool]:
        """
        If enabled (true) the rule defines a read only access for clients matching the 'allowedClients' specification. It enables nfs clients to mount using 'privacy' kerberos security mode.
        """
        return pulumi.get(self, "kerberos5p_read_only")

    @property
    @pulumi.getter(name="kerberos5pReadWrite")
    def kerberos5p_read_write(self) -> Optional[builtins.bool]:
        """
        If enabled (true) the rule defines read and write access for clients matching the 'allowedClients' specification. It enables nfs clients to mount using 'privacy' kerberos security mode. The 'kerberos5pReadOnly' value is ignored if this is enabled.
        """
        return pulumi.get(self, "kerberos5p_read_write")

    @property
    @pulumi.getter
    def nfsv3(self) -> Optional[builtins.bool]:
        """
        Enable to apply the export rule to NFSV3 clients.
        """
        return pulumi.get(self, "nfsv3")

    @property
    @pulumi.getter
    def nfsv4(self) -> Optional[builtins.bool]:
        """
        Enable to apply the export rule to NFSV4.1 clients.
        """
        return pulumi.get(self, "nfsv4")


@pulumi.output_type
class VolumeHybridReplicationParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterLocation":
            suggest = "cluster_location"
        elif key == "peerClusterName":
            suggest = "peer_cluster_name"
        elif key == "peerIpAddresses":
            suggest = "peer_ip_addresses"
        elif key == "peerSvmName":
            suggest = "peer_svm_name"
        elif key == "peerVolumeName":
            suggest = "peer_volume_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeHybridReplicationParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeHybridReplicationParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeHybridReplicationParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_location: Optional[builtins.str] = None,
                 description: Optional[builtins.str] = None,
                 labels: Optional[Mapping[str, builtins.str]] = None,
                 peer_cluster_name: Optional[builtins.str] = None,
                 peer_ip_addresses: Optional[builtins.str] = None,
                 peer_svm_name: Optional[builtins.str] = None,
                 peer_volume_name: Optional[builtins.str] = None,
                 replication: Optional[builtins.str] = None):
        """
        :param builtins.str cluster_location: Optional. Name of source cluster location associated with the Hybrid replication. This is a free-form field for the display purpose only.
        :param builtins.str description: Optional. Description of the replication.
        :param Mapping[str, builtins.str] labels: Optional. Labels to be added to the replication as the key value pairs.
               An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
        :param builtins.str peer_cluster_name: Required. Name of the user's local source cluster to be peered with the destination cluster.
        :param builtins.str peer_ip_addresses: Required. List of node ip addresses to be peered with.
        :param builtins.str peer_svm_name: Required. Name of the user's local source vserver svm to be peered with the destination vserver svm.
        :param builtins.str peer_volume_name: Required. Name of the user's local source volume to be peered with the destination volume.
        :param builtins.str replication: Required. Desired name for the replication of this volume.
        """
        if cluster_location is not None:
            pulumi.set(__self__, "cluster_location", cluster_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if peer_cluster_name is not None:
            pulumi.set(__self__, "peer_cluster_name", peer_cluster_name)
        if peer_ip_addresses is not None:
            pulumi.set(__self__, "peer_ip_addresses", peer_ip_addresses)
        if peer_svm_name is not None:
            pulumi.set(__self__, "peer_svm_name", peer_svm_name)
        if peer_volume_name is not None:
            pulumi.set(__self__, "peer_volume_name", peer_volume_name)
        if replication is not None:
            pulumi.set(__self__, "replication", replication)

    @property
    @pulumi.getter(name="clusterLocation")
    def cluster_location(self) -> Optional[builtins.str]:
        """
        Optional. Name of source cluster location associated with the Hybrid replication. This is a free-form field for the display purpose only.
        """
        return pulumi.get(self, "cluster_location")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        Optional. Description of the replication.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Optional. Labels to be added to the replication as the key value pairs.
        An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="peerClusterName")
    def peer_cluster_name(self) -> Optional[builtins.str]:
        """
        Required. Name of the user's local source cluster to be peered with the destination cluster.
        """
        return pulumi.get(self, "peer_cluster_name")

    @property
    @pulumi.getter(name="peerIpAddresses")
    def peer_ip_addresses(self) -> Optional[builtins.str]:
        """
        Required. List of node ip addresses to be peered with.
        """
        return pulumi.get(self, "peer_ip_addresses")

    @property
    @pulumi.getter(name="peerSvmName")
    def peer_svm_name(self) -> Optional[builtins.str]:
        """
        Required. Name of the user's local source vserver svm to be peered with the destination vserver svm.
        """
        return pulumi.get(self, "peer_svm_name")

    @property
    @pulumi.getter(name="peerVolumeName")
    def peer_volume_name(self) -> Optional[builtins.str]:
        """
        Required. Name of the user's local source volume to be peered with the destination volume.
        """
        return pulumi.get(self, "peer_volume_name")

    @property
    @pulumi.getter
    def replication(self) -> Optional[builtins.str]:
        """
        Required. Desired name for the replication of this volume.
        """
        return pulumi.get(self, "replication")


@pulumi.output_type
class VolumeMountOption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exportFull":
            suggest = "export_full"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeMountOption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeMountOption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeMountOption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 export: Optional[builtins.str] = None,
                 export_full: Optional[builtins.str] = None,
                 instructions: Optional[builtins.str] = None,
                 protocol: Optional[builtins.str] = None):
        """
        :param builtins.str export: (Output)
               Export path of the volume.
        :param builtins.str export_full: (Output)
               Full export path of the volume.
               Format for NFS volumes: `<export_ip>:/<shareName>`
               Format for SMB volumes: `\\\\\\\\netbios_prefix-four_random_hex_letters.domain_name\\\\shareName`
        :param builtins.str instructions: (Output)
               Human-readable mount instructions.
        :param builtins.str protocol: (Output)
               Protocol to mount with.
        """
        if export is not None:
            pulumi.set(__self__, "export", export)
        if export_full is not None:
            pulumi.set(__self__, "export_full", export_full)
        if instructions is not None:
            pulumi.set(__self__, "instructions", instructions)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter
    def export(self) -> Optional[builtins.str]:
        """
        (Output)
        Export path of the volume.
        """
        return pulumi.get(self, "export")

    @property
    @pulumi.getter(name="exportFull")
    def export_full(self) -> Optional[builtins.str]:
        """
        (Output)
        Full export path of the volume.
        Format for NFS volumes: `<export_ip>:/<shareName>`
        Format for SMB volumes: `\\\\\\\\netbios_prefix-four_random_hex_letters.domain_name\\\\shareName`
        """
        return pulumi.get(self, "export_full")

    @property
    @pulumi.getter
    def instructions(self) -> Optional[builtins.str]:
        """
        (Output)
        Human-readable mount instructions.
        """
        return pulumi.get(self, "instructions")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[builtins.str]:
        """
        (Output)
        Protocol to mount with.
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class VolumeReplicationDestinationVolumeParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storagePool":
            suggest = "storage_pool"
        elif key == "shareName":
            suggest = "share_name"
        elif key == "tieringPolicy":
            suggest = "tiering_policy"
        elif key == "volumeId":
            suggest = "volume_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeReplicationDestinationVolumeParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeReplicationDestinationVolumeParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeReplicationDestinationVolumeParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 storage_pool: builtins.str,
                 description: Optional[builtins.str] = None,
                 share_name: Optional[builtins.str] = None,
                 tiering_policy: Optional['outputs.VolumeReplicationDestinationVolumeParametersTieringPolicy'] = None,
                 volume_id: Optional[builtins.str] = None):
        """
        :param builtins.str storage_pool: Name of an existing storage pool for the destination volume with format: `projects/{{project}}/locations/{{location}}/storagePools/{{poolId}}`
        :param builtins.str description: Description for the destination volume.
        :param builtins.str share_name: Share name for destination volume. If not specified, name of source volume's share name will be used.
        :param 'VolumeReplicationDestinationVolumeParametersTieringPolicyArgs' tiering_policy: Tiering policy for the volume.
               Structure is documented below.
        :param builtins.str volume_id: Name for the destination volume to be created. If not specified, the name of the source volume will be used.
        """
        pulumi.set(__self__, "storage_pool", storage_pool)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if share_name is not None:
            pulumi.set(__self__, "share_name", share_name)
        if tiering_policy is not None:
            pulumi.set(__self__, "tiering_policy", tiering_policy)
        if volume_id is not None:
            pulumi.set(__self__, "volume_id", volume_id)

    @property
    @pulumi.getter(name="storagePool")
    def storage_pool(self) -> builtins.str:
        """
        Name of an existing storage pool for the destination volume with format: `projects/{{project}}/locations/{{location}}/storagePools/{{poolId}}`
        """
        return pulumi.get(self, "storage_pool")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        Description for the destination volume.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="shareName")
    def share_name(self) -> Optional[builtins.str]:
        """
        Share name for destination volume. If not specified, name of source volume's share name will be used.
        """
        return pulumi.get(self, "share_name")

    @property
    @pulumi.getter(name="tieringPolicy")
    def tiering_policy(self) -> Optional['outputs.VolumeReplicationDestinationVolumeParametersTieringPolicy']:
        """
        Tiering policy for the volume.
        Structure is documented below.
        """
        return pulumi.get(self, "tiering_policy")

    @property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> Optional[builtins.str]:
        """
        Name for the destination volume to be created. If not specified, the name of the source volume will be used.
        """
        return pulumi.get(self, "volume_id")


@pulumi.output_type
class VolumeReplicationDestinationVolumeParametersTieringPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "coolingThresholdDays":
            suggest = "cooling_threshold_days"
        elif key == "tierAction":
            suggest = "tier_action"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeReplicationDestinationVolumeParametersTieringPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeReplicationDestinationVolumeParametersTieringPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeReplicationDestinationVolumeParametersTieringPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cooling_threshold_days: Optional[builtins.int] = None,
                 tier_action: Optional[builtins.str] = None):
        """
        :param builtins.int cooling_threshold_days: Optional. Time in days to mark the volume's data block as cold and make it eligible for tiering, can be range from 2-183.
               Default is 31.
        :param builtins.str tier_action: Optional. Flag indicating if the volume has tiering policy enable/pause. Default is PAUSED.
               Default value is `PAUSED`.
               Possible values are: `ENABLED`, `PAUSED`.
        """
        if cooling_threshold_days is not None:
            pulumi.set(__self__, "cooling_threshold_days", cooling_threshold_days)
        if tier_action is not None:
            pulumi.set(__self__, "tier_action", tier_action)

    @property
    @pulumi.getter(name="coolingThresholdDays")
    def cooling_threshold_days(self) -> Optional[builtins.int]:
        """
        Optional. Time in days to mark the volume's data block as cold and make it eligible for tiering, can be range from 2-183.
        Default is 31.
        """
        return pulumi.get(self, "cooling_threshold_days")

    @property
    @pulumi.getter(name="tierAction")
    def tier_action(self) -> Optional[builtins.str]:
        """
        Optional. Flag indicating if the volume has tiering policy enable/pause. Default is PAUSED.
        Default value is `PAUSED`.
        Possible values are: `ENABLED`, `PAUSED`.
        """
        return pulumi.get(self, "tier_action")


@pulumi.output_type
class VolumeReplicationHybridPeeringDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "commandExpiryTime":
            suggest = "command_expiry_time"
        elif key == "peerClusterName":
            suggest = "peer_cluster_name"
        elif key == "peerSvmName":
            suggest = "peer_svm_name"
        elif key == "peerVolumeName":
            suggest = "peer_volume_name"
        elif key == "subnetIp":
            suggest = "subnet_ip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeReplicationHybridPeeringDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeReplicationHybridPeeringDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeReplicationHybridPeeringDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 command: Optional[builtins.str] = None,
                 command_expiry_time: Optional[builtins.str] = None,
                 passphrase: Optional[builtins.str] = None,
                 peer_cluster_name: Optional[builtins.str] = None,
                 peer_svm_name: Optional[builtins.str] = None,
                 peer_volume_name: Optional[builtins.str] = None,
                 subnet_ip: Optional[builtins.str] = None):
        """
        :param builtins.str command: (Output)
               Optional. Copy-paste-able commands to be used on user's ONTAP to accept peering requests.
        :param builtins.str command_expiry_time: (Output)
               Optional. Expiration time for the peering command to be executed on user's ONTAP.
               Uses RFC 3339, where generated output will always be Z-normalized and uses 0, 3, 6 or 9 fractional digits. Offsets other than "Z" are also accepted.
        :param builtins.str passphrase: (Output)
               Optional. Temporary passphrase generated to accept cluster peering command.
        :param builtins.str peer_cluster_name: (Output)
               Optional. Name of the user's local source cluster to be peered with the destination cluster.
        :param builtins.str peer_svm_name: (Output)
               Optional. Name of the user's local source vserver svm to be peered with the destination vserver svm.
        :param builtins.str peer_volume_name: (Output)
               Optional. Name of the user's local source volume to be peered with the destination volume.
        :param builtins.str subnet_ip: (Output)
               Optional. IP address of the subnet.
        """
        if command is not None:
            pulumi.set(__self__, "command", command)
        if command_expiry_time is not None:
            pulumi.set(__self__, "command_expiry_time", command_expiry_time)
        if passphrase is not None:
            pulumi.set(__self__, "passphrase", passphrase)
        if peer_cluster_name is not None:
            pulumi.set(__self__, "peer_cluster_name", peer_cluster_name)
        if peer_svm_name is not None:
            pulumi.set(__self__, "peer_svm_name", peer_svm_name)
        if peer_volume_name is not None:
            pulumi.set(__self__, "peer_volume_name", peer_volume_name)
        if subnet_ip is not None:
            pulumi.set(__self__, "subnet_ip", subnet_ip)

    @property
    @pulumi.getter
    def command(self) -> Optional[builtins.str]:
        """
        (Output)
        Optional. Copy-paste-able commands to be used on user's ONTAP to accept peering requests.
        """
        return pulumi.get(self, "command")

    @property
    @pulumi.getter(name="commandExpiryTime")
    def command_expiry_time(self) -> Optional[builtins.str]:
        """
        (Output)
        Optional. Expiration time for the peering command to be executed on user's ONTAP.
        Uses RFC 3339, where generated output will always be Z-normalized and uses 0, 3, 6 or 9 fractional digits. Offsets other than "Z" are also accepted.
        """
        return pulumi.get(self, "command_expiry_time")

    @property
    @pulumi.getter
    def passphrase(self) -> Optional[builtins.str]:
        """
        (Output)
        Optional. Temporary passphrase generated to accept cluster peering command.
        """
        return pulumi.get(self, "passphrase")

    @property
    @pulumi.getter(name="peerClusterName")
    def peer_cluster_name(self) -> Optional[builtins.str]:
        """
        (Output)
        Optional. Name of the user's local source cluster to be peered with the destination cluster.
        """
        return pulumi.get(self, "peer_cluster_name")

    @property
    @pulumi.getter(name="peerSvmName")
    def peer_svm_name(self) -> Optional[builtins.str]:
        """
        (Output)
        Optional. Name of the user's local source vserver svm to be peered with the destination vserver svm.
        """
        return pulumi.get(self, "peer_svm_name")

    @property
    @pulumi.getter(name="peerVolumeName")
    def peer_volume_name(self) -> Optional[builtins.str]:
        """
        (Output)
        Optional. Name of the user's local source volume to be peered with the destination volume.
        """
        return pulumi.get(self, "peer_volume_name")

    @property
    @pulumi.getter(name="subnetIp")
    def subnet_ip(self) -> Optional[builtins.str]:
        """
        (Output)
        Optional. IP address of the subnet.
        """
        return pulumi.get(self, "subnet_ip")


@pulumi.output_type
class VolumeReplicationTransferStat(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lagDuration":
            suggest = "lag_duration"
        elif key == "lastTransferBytes":
            suggest = "last_transfer_bytes"
        elif key == "lastTransferDuration":
            suggest = "last_transfer_duration"
        elif key == "lastTransferEndTime":
            suggest = "last_transfer_end_time"
        elif key == "lastTransferError":
            suggest = "last_transfer_error"
        elif key == "totalTransferDuration":
            suggest = "total_transfer_duration"
        elif key == "transferBytes":
            suggest = "transfer_bytes"
        elif key == "updateTime":
            suggest = "update_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeReplicationTransferStat. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeReplicationTransferStat.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeReplicationTransferStat.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 lag_duration: Optional[builtins.str] = None,
                 last_transfer_bytes: Optional[builtins.str] = None,
                 last_transfer_duration: Optional[builtins.str] = None,
                 last_transfer_end_time: Optional[builtins.str] = None,
                 last_transfer_error: Optional[builtins.str] = None,
                 total_transfer_duration: Optional[builtins.str] = None,
                 transfer_bytes: Optional[builtins.str] = None,
                 update_time: Optional[builtins.str] = None):
        """
        :param builtins.str lag_duration: (Output)
               The elapsed time since the creation of the snapshot on the source volume that was last replicated
               to the destination volume. Lag time represents the difference in age of the destination volume
               data in relation to the source volume data.
        :param builtins.str last_transfer_bytes: (Output)
               Size of last completed transfer in bytes.
        :param builtins.str last_transfer_duration: (Output)
               Time taken during last completed transfer.
        :param builtins.str last_transfer_end_time: (Output)
               Time when last transfer completed. A timestamp in RFC3339 UTC "Zulu" format. Examples: "2023-06-22T09:13:01.617Z".
        :param builtins.str last_transfer_error: (Output)
               A message describing the cause of the last transfer failure.
        :param builtins.str total_transfer_duration: (Output)
               Cumulative time taken across all transfers for the replication relationship.
        :param builtins.str transfer_bytes: (Output)
               Cumulative bytes transferred so far for the replication relationship.
        :param builtins.str update_time: (Output)
               Time when progress was updated last. A timestamp in RFC3339 UTC "Zulu" format. Examples: "2023-06-22T09:13:01.617Z".
        """
        if lag_duration is not None:
            pulumi.set(__self__, "lag_duration", lag_duration)
        if last_transfer_bytes is not None:
            pulumi.set(__self__, "last_transfer_bytes", last_transfer_bytes)
        if last_transfer_duration is not None:
            pulumi.set(__self__, "last_transfer_duration", last_transfer_duration)
        if last_transfer_end_time is not None:
            pulumi.set(__self__, "last_transfer_end_time", last_transfer_end_time)
        if last_transfer_error is not None:
            pulumi.set(__self__, "last_transfer_error", last_transfer_error)
        if total_transfer_duration is not None:
            pulumi.set(__self__, "total_transfer_duration", total_transfer_duration)
        if transfer_bytes is not None:
            pulumi.set(__self__, "transfer_bytes", transfer_bytes)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="lagDuration")
    def lag_duration(self) -> Optional[builtins.str]:
        """
        (Output)
        The elapsed time since the creation of the snapshot on the source volume that was last replicated
        to the destination volume. Lag time represents the difference in age of the destination volume
        data in relation to the source volume data.
        """
        return pulumi.get(self, "lag_duration")

    @property
    @pulumi.getter(name="lastTransferBytes")
    def last_transfer_bytes(self) -> Optional[builtins.str]:
        """
        (Output)
        Size of last completed transfer in bytes.
        """
        return pulumi.get(self, "last_transfer_bytes")

    @property
    @pulumi.getter(name="lastTransferDuration")
    def last_transfer_duration(self) -> Optional[builtins.str]:
        """
        (Output)
        Time taken during last completed transfer.
        """
        return pulumi.get(self, "last_transfer_duration")

    @property
    @pulumi.getter(name="lastTransferEndTime")
    def last_transfer_end_time(self) -> Optional[builtins.str]:
        """
        (Output)
        Time when last transfer completed. A timestamp in RFC3339 UTC "Zulu" format. Examples: "2023-06-22T09:13:01.617Z".
        """
        return pulumi.get(self, "last_transfer_end_time")

    @property
    @pulumi.getter(name="lastTransferError")
    def last_transfer_error(self) -> Optional[builtins.str]:
        """
        (Output)
        A message describing the cause of the last transfer failure.
        """
        return pulumi.get(self, "last_transfer_error")

    @property
    @pulumi.getter(name="totalTransferDuration")
    def total_transfer_duration(self) -> Optional[builtins.str]:
        """
        (Output)
        Cumulative time taken across all transfers for the replication relationship.
        """
        return pulumi.get(self, "total_transfer_duration")

    @property
    @pulumi.getter(name="transferBytes")
    def transfer_bytes(self) -> Optional[builtins.str]:
        """
        (Output)
        Cumulative bytes transferred so far for the replication relationship.
        """
        return pulumi.get(self, "transfer_bytes")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[builtins.str]:
        """
        (Output)
        Time when progress was updated last. A timestamp in RFC3339 UTC "Zulu" format. Examples: "2023-06-22T09:13:01.617Z".
        """
        return pulumi.get(self, "update_time")


@pulumi.output_type
class VolumeRestoreParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceBackup":
            suggest = "source_backup"
        elif key == "sourceSnapshot":
            suggest = "source_snapshot"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeRestoreParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeRestoreParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeRestoreParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_backup: Optional[builtins.str] = None,
                 source_snapshot: Optional[builtins.str] = None):
        """
        :param builtins.str source_backup: Full name of the backup to use for creating this volume.
               `source_snapshot` and `source_backup` cannot be used simultaneously.
               Format: `projects/{{project}}/locations/{{location}}/backupVaults/{{backupVaultId}}/backups/{{backup}}`.
        :param builtins.str source_snapshot: Full name of the snapshot to use for creating this volume.
               `source_snapshot` and `source_backup` cannot be used simultaneously.
               Format: `projects/{{project}}/locations/{{location}}/volumes/{{volume}}/snapshots/{{snapshot}}`.
        """
        if source_backup is not None:
            pulumi.set(__self__, "source_backup", source_backup)
        if source_snapshot is not None:
            pulumi.set(__self__, "source_snapshot", source_snapshot)

    @property
    @pulumi.getter(name="sourceBackup")
    def source_backup(self) -> Optional[builtins.str]:
        """
        Full name of the backup to use for creating this volume.
        `source_snapshot` and `source_backup` cannot be used simultaneously.
        Format: `projects/{{project}}/locations/{{location}}/backupVaults/{{backupVaultId}}/backups/{{backup}}`.
        """
        return pulumi.get(self, "source_backup")

    @property
    @pulumi.getter(name="sourceSnapshot")
    def source_snapshot(self) -> Optional[builtins.str]:
        """
        Full name of the snapshot to use for creating this volume.
        `source_snapshot` and `source_backup` cannot be used simultaneously.
        Format: `projects/{{project}}/locations/{{location}}/volumes/{{volume}}/snapshots/{{snapshot}}`.
        """
        return pulumi.get(self, "source_snapshot")


@pulumi.output_type
class VolumeSnapshotPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dailySchedule":
            suggest = "daily_schedule"
        elif key == "hourlySchedule":
            suggest = "hourly_schedule"
        elif key == "monthlySchedule":
            suggest = "monthly_schedule"
        elif key == "weeklySchedule":
            suggest = "weekly_schedule"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeSnapshotPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeSnapshotPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeSnapshotPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 daily_schedule: Optional['outputs.VolumeSnapshotPolicyDailySchedule'] = None,
                 enabled: Optional[builtins.bool] = None,
                 hourly_schedule: Optional['outputs.VolumeSnapshotPolicyHourlySchedule'] = None,
                 monthly_schedule: Optional['outputs.VolumeSnapshotPolicyMonthlySchedule'] = None,
                 weekly_schedule: Optional['outputs.VolumeSnapshotPolicyWeeklySchedule'] = None):
        """
        :param 'VolumeSnapshotPolicyDailyScheduleArgs' daily_schedule: Daily schedule policy.
               Structure is documented below.
        :param builtins.bool enabled: Enables automated snapshot creation according to defined schedule. Default is false.
               To disable automatic snapshot creation you have to remove the whole snapshot_policy block.
        :param 'VolumeSnapshotPolicyHourlyScheduleArgs' hourly_schedule: Hourly schedule policy.
               Structure is documented below.
        :param 'VolumeSnapshotPolicyMonthlyScheduleArgs' monthly_schedule: Monthly schedule policy.
               Structure is documented below.
        :param 'VolumeSnapshotPolicyWeeklyScheduleArgs' weekly_schedule: Weekly schedule policy.
               Structure is documented below.
        """
        if daily_schedule is not None:
            pulumi.set(__self__, "daily_schedule", daily_schedule)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if hourly_schedule is not None:
            pulumi.set(__self__, "hourly_schedule", hourly_schedule)
        if monthly_schedule is not None:
            pulumi.set(__self__, "monthly_schedule", monthly_schedule)
        if weekly_schedule is not None:
            pulumi.set(__self__, "weekly_schedule", weekly_schedule)

    @property
    @pulumi.getter(name="dailySchedule")
    def daily_schedule(self) -> Optional['outputs.VolumeSnapshotPolicyDailySchedule']:
        """
        Daily schedule policy.
        Structure is documented below.
        """
        return pulumi.get(self, "daily_schedule")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[builtins.bool]:
        """
        Enables automated snapshot creation according to defined schedule. Default is false.
        To disable automatic snapshot creation you have to remove the whole snapshot_policy block.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="hourlySchedule")
    def hourly_schedule(self) -> Optional['outputs.VolumeSnapshotPolicyHourlySchedule']:
        """
        Hourly schedule policy.
        Structure is documented below.
        """
        return pulumi.get(self, "hourly_schedule")

    @property
    @pulumi.getter(name="monthlySchedule")
    def monthly_schedule(self) -> Optional['outputs.VolumeSnapshotPolicyMonthlySchedule']:
        """
        Monthly schedule policy.
        Structure is documented below.
        """
        return pulumi.get(self, "monthly_schedule")

    @property
    @pulumi.getter(name="weeklySchedule")
    def weekly_schedule(self) -> Optional['outputs.VolumeSnapshotPolicyWeeklySchedule']:
        """
        Weekly schedule policy.
        Structure is documented below.
        """
        return pulumi.get(self, "weekly_schedule")


@pulumi.output_type
class VolumeSnapshotPolicyDailySchedule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "snapshotsToKeep":
            suggest = "snapshots_to_keep"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeSnapshotPolicyDailySchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeSnapshotPolicyDailySchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeSnapshotPolicyDailySchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 snapshots_to_keep: builtins.int,
                 hour: Optional[builtins.int] = None,
                 minute: Optional[builtins.int] = None):
        """
        :param builtins.int snapshots_to_keep: The maximum number of snapshots to keep for the daily schedule.
        :param builtins.int hour: Set the hour to create the snapshot (0-23), defaults to midnight (0).
        :param builtins.int minute: Set the minute of the hour to create the snapshot (0-59), defaults to the top of the hour (0).
        """
        pulumi.set(__self__, "snapshots_to_keep", snapshots_to_keep)
        if hour is not None:
            pulumi.set(__self__, "hour", hour)
        if minute is not None:
            pulumi.set(__self__, "minute", minute)

    @property
    @pulumi.getter(name="snapshotsToKeep")
    def snapshots_to_keep(self) -> builtins.int:
        """
        The maximum number of snapshots to keep for the daily schedule.
        """
        return pulumi.get(self, "snapshots_to_keep")

    @property
    @pulumi.getter
    def hour(self) -> Optional[builtins.int]:
        """
        Set the hour to create the snapshot (0-23), defaults to midnight (0).
        """
        return pulumi.get(self, "hour")

    @property
    @pulumi.getter
    def minute(self) -> Optional[builtins.int]:
        """
        Set the minute of the hour to create the snapshot (0-59), defaults to the top of the hour (0).
        """
        return pulumi.get(self, "minute")


@pulumi.output_type
class VolumeSnapshotPolicyHourlySchedule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "snapshotsToKeep":
            suggest = "snapshots_to_keep"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeSnapshotPolicyHourlySchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeSnapshotPolicyHourlySchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeSnapshotPolicyHourlySchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 snapshots_to_keep: builtins.int,
                 minute: Optional[builtins.int] = None):
        """
        :param builtins.int snapshots_to_keep: The maximum number of snapshots to keep for the hourly schedule.
        :param builtins.int minute: Set the minute of the hour to create the snapshot (0-59), defaults to the top of the hour (0).
        """
        pulumi.set(__self__, "snapshots_to_keep", snapshots_to_keep)
        if minute is not None:
            pulumi.set(__self__, "minute", minute)

    @property
    @pulumi.getter(name="snapshotsToKeep")
    def snapshots_to_keep(self) -> builtins.int:
        """
        The maximum number of snapshots to keep for the hourly schedule.
        """
        return pulumi.get(self, "snapshots_to_keep")

    @property
    @pulumi.getter
    def minute(self) -> Optional[builtins.int]:
        """
        Set the minute of the hour to create the snapshot (0-59), defaults to the top of the hour (0).
        """
        return pulumi.get(self, "minute")


@pulumi.output_type
class VolumeSnapshotPolicyMonthlySchedule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "snapshotsToKeep":
            suggest = "snapshots_to_keep"
        elif key == "daysOfMonth":
            suggest = "days_of_month"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeSnapshotPolicyMonthlySchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeSnapshotPolicyMonthlySchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeSnapshotPolicyMonthlySchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 snapshots_to_keep: builtins.int,
                 days_of_month: Optional[builtins.str] = None,
                 hour: Optional[builtins.int] = None,
                 minute: Optional[builtins.int] = None):
        """
        :param builtins.int snapshots_to_keep: The maximum number of snapshots to keep for the monthly schedule
        :param builtins.str days_of_month: Set the day or days of the month to make a snapshot (1-31). Accepts a comma separated number of days. Defaults to '1'.
        :param builtins.int hour: Set the hour to create the snapshot (0-23), defaults to midnight (0).
        :param builtins.int minute: Set the minute of the hour to create the snapshot (0-59), defaults to the top of the hour (0).
        """
        pulumi.set(__self__, "snapshots_to_keep", snapshots_to_keep)
        if days_of_month is not None:
            pulumi.set(__self__, "days_of_month", days_of_month)
        if hour is not None:
            pulumi.set(__self__, "hour", hour)
        if minute is not None:
            pulumi.set(__self__, "minute", minute)

    @property
    @pulumi.getter(name="snapshotsToKeep")
    def snapshots_to_keep(self) -> builtins.int:
        """
        The maximum number of snapshots to keep for the monthly schedule
        """
        return pulumi.get(self, "snapshots_to_keep")

    @property
    @pulumi.getter(name="daysOfMonth")
    def days_of_month(self) -> Optional[builtins.str]:
        """
        Set the day or days of the month to make a snapshot (1-31). Accepts a comma separated number of days. Defaults to '1'.
        """
        return pulumi.get(self, "days_of_month")

    @property
    @pulumi.getter
    def hour(self) -> Optional[builtins.int]:
        """
        Set the hour to create the snapshot (0-23), defaults to midnight (0).
        """
        return pulumi.get(self, "hour")

    @property
    @pulumi.getter
    def minute(self) -> Optional[builtins.int]:
        """
        Set the minute of the hour to create the snapshot (0-59), defaults to the top of the hour (0).
        """
        return pulumi.get(self, "minute")


@pulumi.output_type
class VolumeSnapshotPolicyWeeklySchedule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "snapshotsToKeep":
            suggest = "snapshots_to_keep"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeSnapshotPolicyWeeklySchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeSnapshotPolicyWeeklySchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeSnapshotPolicyWeeklySchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 snapshots_to_keep: builtins.int,
                 day: Optional[builtins.str] = None,
                 hour: Optional[builtins.int] = None,
                 minute: Optional[builtins.int] = None):
        """
        :param builtins.int snapshots_to_keep: The maximum number of snapshots to keep for the weekly schedule.
        :param builtins.str day: Set the day or days of the week to make a snapshot. Accepts a comma separated days of the week. Defaults to 'Sunday'.
        :param builtins.int hour: Set the hour to create the snapshot (0-23), defaults to midnight (0).
        :param builtins.int minute: Set the minute of the hour to create the snapshot (0-59), defaults to the top of the hour (0).
        """
        pulumi.set(__self__, "snapshots_to_keep", snapshots_to_keep)
        if day is not None:
            pulumi.set(__self__, "day", day)
        if hour is not None:
            pulumi.set(__self__, "hour", hour)
        if minute is not None:
            pulumi.set(__self__, "minute", minute)

    @property
    @pulumi.getter(name="snapshotsToKeep")
    def snapshots_to_keep(self) -> builtins.int:
        """
        The maximum number of snapshots to keep for the weekly schedule.
        """
        return pulumi.get(self, "snapshots_to_keep")

    @property
    @pulumi.getter
    def day(self) -> Optional[builtins.str]:
        """
        Set the day or days of the week to make a snapshot. Accepts a comma separated days of the week. Defaults to 'Sunday'.
        """
        return pulumi.get(self, "day")

    @property
    @pulumi.getter
    def hour(self) -> Optional[builtins.int]:
        """
        Set the hour to create the snapshot (0-23), defaults to midnight (0).
        """
        return pulumi.get(self, "hour")

    @property
    @pulumi.getter
    def minute(self) -> Optional[builtins.int]:
        """
        Set the minute of the hour to create the snapshot (0-59), defaults to the top of the hour (0).
        """
        return pulumi.get(self, "minute")


@pulumi.output_type
class VolumeTieringPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "coolingThresholdDays":
            suggest = "cooling_threshold_days"
        elif key == "hotTierBypassModeEnabled":
            suggest = "hot_tier_bypass_mode_enabled"
        elif key == "tierAction":
            suggest = "tier_action"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeTieringPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeTieringPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeTieringPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cooling_threshold_days: Optional[builtins.int] = None,
                 hot_tier_bypass_mode_enabled: Optional[builtins.bool] = None,
                 tier_action: Optional[builtins.str] = None):
        """
        :param builtins.int cooling_threshold_days: Optional. Time in days to mark the volume's data block as cold and make it eligible for tiering, can be range from 2-183.
               Default is 31.
        :param builtins.bool hot_tier_bypass_mode_enabled: Optional. Flag indicating that the hot tier bypass mode is enabled. Default is false.
               Only applicable to Flex service level.
        :param builtins.str tier_action: Optional. Flag indicating if the volume has tiering policy enable/pause. Default is PAUSED.
               Default value is `PAUSED`.
               Possible values are: `ENABLED`, `PAUSED`.
        """
        if cooling_threshold_days is not None:
            pulumi.set(__self__, "cooling_threshold_days", cooling_threshold_days)
        if hot_tier_bypass_mode_enabled is not None:
            pulumi.set(__self__, "hot_tier_bypass_mode_enabled", hot_tier_bypass_mode_enabled)
        if tier_action is not None:
            pulumi.set(__self__, "tier_action", tier_action)

    @property
    @pulumi.getter(name="coolingThresholdDays")
    def cooling_threshold_days(self) -> Optional[builtins.int]:
        """
        Optional. Time in days to mark the volume's data block as cold and make it eligible for tiering, can be range from 2-183.
        Default is 31.
        """
        return pulumi.get(self, "cooling_threshold_days")

    @property
    @pulumi.getter(name="hotTierBypassModeEnabled")
    def hot_tier_bypass_mode_enabled(self) -> Optional[builtins.bool]:
        """
        Optional. Flag indicating that the hot tier bypass mode is enabled. Default is false.
        Only applicable to Flex service level.
        """
        return pulumi.get(self, "hot_tier_bypass_mode_enabled")

    @property
    @pulumi.getter(name="tierAction")
    def tier_action(self) -> Optional[builtins.str]:
        """
        Optional. Flag indicating if the volume has tiering policy enable/pause. Default is PAUSED.
        Default value is `PAUSED`.
        Possible values are: `ENABLED`, `PAUSED`.
        """
        return pulumi.get(self, "tier_action")


