# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServiceConnectionPolicyArgs', 'ServiceConnectionPolicy']

@pulumi.input_type
class ServiceConnectionPolicyArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[builtins.str],
                 network: pulumi.Input[builtins.str],
                 service_class: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 psc_config: Optional[pulumi.Input['ServiceConnectionPolicyPscConfigArgs']] = None):
        """
        The set of arguments for constructing a ServiceConnectionPolicy resource.
        :param pulumi.Input[builtins.str] location: The location of the ServiceConnectionPolicy.
               
               
               - - -
        :param pulumi.Input[builtins.str] network: The resource path of the consumer network. Example: - projects/{projectNumOrId}/global/networks/{resourceId}.
        :param pulumi.Input[builtins.str] service_class: The service class identifier for which this ServiceConnectionPolicy is for. The service class identifier is a unique, symbolic representation of a ServiceClass.
               It is provided by the Service Producer. Google services have a prefix of gcp. For example, gcp-cloud-sql. 3rd party services do not. For example, test-service-a3dfcx.
        :param pulumi.Input[builtins.str] description: Free-text description of the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: User-defined labels.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] name: The name of a ServiceConnectionPolicy. Format: projects/{project}/locations/{location}/serviceConnectionPolicies/{service_connection_policy} See: https://google.aip.dev/122#fields-representing-resource-names
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['ServiceConnectionPolicyPscConfigArgs'] psc_config: Configuration used for Private Service Connect connections. Used when Infrastructure is PSC.
               Structure is documented below.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "network", network)
        pulumi.set(__self__, "service_class", service_class)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if psc_config is not None:
            pulumi.set(__self__, "psc_config", psc_config)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        The location of the ServiceConnectionPolicy.


        - - -
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def network(self) -> pulumi.Input[builtins.str]:
        """
        The resource path of the consumer network. Example: - projects/{projectNumOrId}/global/networks/{resourceId}.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="serviceClass")
    def service_class(self) -> pulumi.Input[builtins.str]:
        """
        The service class identifier for which this ServiceConnectionPolicy is for. The service class identifier is a unique, symbolic representation of a ServiceClass.
        It is provided by the Service Producer. Google services have a prefix of gcp. For example, gcp-cloud-sql. 3rd party services do not. For example, test-service-a3dfcx.
        """
        return pulumi.get(self, "service_class")

    @service_class.setter
    def service_class(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "service_class", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Free-text description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        User-defined labels.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of a ServiceConnectionPolicy. Format: projects/{project}/locations/{location}/serviceConnectionPolicies/{service_connection_policy} See: https://google.aip.dev/122#fields-representing-resource-names
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pscConfig")
    def psc_config(self) -> Optional[pulumi.Input['ServiceConnectionPolicyPscConfigArgs']]:
        """
        Configuration used for Private Service Connect connections. Used when Infrastructure is PSC.
        Structure is documented below.
        """
        return pulumi.get(self, "psc_config")

    @psc_config.setter
    def psc_config(self, value: Optional[pulumi.Input['ServiceConnectionPolicyPscConfigArgs']]):
        pulumi.set(self, "psc_config", value)


@pulumi.input_type
class _ServiceConnectionPolicyState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 etag: Optional[pulumi.Input[builtins.str]] = None,
                 infrastructure: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 psc_config: Optional[pulumi.Input['ServiceConnectionPolicyPscConfigArgs']] = None,
                 psc_connections: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceConnectionPolicyPscConnectionArgs']]]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 service_class: Optional[pulumi.Input[builtins.str]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ServiceConnectionPolicy resources.
        :param pulumi.Input[builtins.str] create_time: The timestamp when the resource was created.
        :param pulumi.Input[builtins.str] description: Free-text description of the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.str] etag: The etag is computed by the server, and may be sent on update and delete requests to ensure the client has an up-to-date value before proceeding.
        :param pulumi.Input[builtins.str] infrastructure: The type of underlying resources used to create the connection.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: User-defined labels.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The location of the ServiceConnectionPolicy.
               
               
               - - -
        :param pulumi.Input[builtins.str] name: The name of a ServiceConnectionPolicy. Format: projects/{project}/locations/{location}/serviceConnectionPolicies/{service_connection_policy} See: https://google.aip.dev/122#fields-representing-resource-names
        :param pulumi.Input[builtins.str] network: The resource path of the consumer network. Example: - projects/{projectNumOrId}/global/networks/{resourceId}.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['ServiceConnectionPolicyPscConfigArgs'] psc_config: Configuration used for Private Service Connect connections. Used when Infrastructure is PSC.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceConnectionPolicyPscConnectionArgs']]] psc_connections: Information about each Private Service Connect connection.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.str] service_class: The service class identifier for which this ServiceConnectionPolicy is for. The service class identifier is a unique, symbolic representation of a ServiceClass.
               It is provided by the Service Producer. Google services have a prefix of gcp. For example, gcp-cloud-sql. 3rd party services do not. For example, test-service-a3dfcx.
        :param pulumi.Input[builtins.str] update_time: The timestamp when the resource was updated.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if infrastructure is not None:
            pulumi.set(__self__, "infrastructure", infrastructure)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if psc_config is not None:
            pulumi.set(__self__, "psc_config", psc_config)
        if psc_connections is not None:
            pulumi.set(__self__, "psc_connections", psc_connections)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if service_class is not None:
            pulumi.set(__self__, "service_class", service_class)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The timestamp when the resource was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Free-text description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The etag is computed by the server, and may be sent on update and delete requests to ensure the client has an up-to-date value before proceeding.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter
    def infrastructure(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of underlying resources used to create the connection.
        """
        return pulumi.get(self, "infrastructure")

    @infrastructure.setter
    def infrastructure(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "infrastructure", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        User-defined labels.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location of the ServiceConnectionPolicy.


        - - -
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of a ServiceConnectionPolicy. Format: projects/{project}/locations/{location}/serviceConnectionPolicies/{service_connection_policy} See: https://google.aip.dev/122#fields-representing-resource-names
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource path of the consumer network. Example: - projects/{projectNumOrId}/global/networks/{resourceId}.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pscConfig")
    def psc_config(self) -> Optional[pulumi.Input['ServiceConnectionPolicyPscConfigArgs']]:
        """
        Configuration used for Private Service Connect connections. Used when Infrastructure is PSC.
        Structure is documented below.
        """
        return pulumi.get(self, "psc_config")

    @psc_config.setter
    def psc_config(self, value: Optional[pulumi.Input['ServiceConnectionPolicyPscConfigArgs']]):
        pulumi.set(self, "psc_config", value)

    @property
    @pulumi.getter(name="pscConnections")
    def psc_connections(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceConnectionPolicyPscConnectionArgs']]]]:
        """
        Information about each Private Service Connect connection.
        Structure is documented below.
        """
        return pulumi.get(self, "psc_connections")

    @psc_connections.setter
    def psc_connections(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceConnectionPolicyPscConnectionArgs']]]]):
        pulumi.set(self, "psc_connections", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter(name="serviceClass")
    def service_class(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The service class identifier for which this ServiceConnectionPolicy is for. The service class identifier is a unique, symbolic representation of a ServiceClass.
        It is provided by the Service Producer. Google services have a prefix of gcp. For example, gcp-cloud-sql. 3rd party services do not. For example, test-service-a3dfcx.
        """
        return pulumi.get(self, "service_class")

    @service_class.setter
    def service_class(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_class", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The timestamp when the resource was updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:networkconnectivity/serviceConnectionPolicy:ServiceConnectionPolicy")
class ServiceConnectionPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 psc_config: Optional[pulumi.Input[Union['ServiceConnectionPolicyPscConfigArgs', 'ServiceConnectionPolicyPscConfigArgsDict']]] = None,
                 service_class: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manage Service Connection Policies.

        To get more information about ServiceConnectionPolicy, see:

        * [API documentation](https://cloud.google.com/network-connectivity/docs/reference/networkconnectivity/rest/v1/projects.locations.serviceConnectionPolicies)
        * How-to Guides
            * [About Service Connection Policies](https://cloud.google.com/vpc/docs/about-service-connection-policies#service-policies)
            * [About Service Connectivity Automation](https://cloud.google.com/vpc/docs/about-service-connectivity-automation)

        ## Example Usage

        ### Network Connectivity Policy Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        producer_net = gcp.compute.Network("producer_net",
            name="producer-net",
            auto_create_subnetworks=False)
        producer_subnet = gcp.compute.Subnetwork("producer_subnet",
            name="producer-subnet",
            ip_cidr_range="10.0.0.0/16",
            region="us-central1",
            network=producer_net.id)
        default = gcp.networkconnectivity.ServiceConnectionPolicy("default",
            name="my-network-connectivity-policy",
            location="us-central1",
            service_class="my-basic-service-class",
            description="my basic service connection policy",
            network=producer_net.id,
            psc_config={
                "subnetworks": [producer_subnet.id],
                "limit": "2",
            })
        ```

        ## Import

        ServiceConnectionPolicy can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/serviceConnectionPolicies/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, ServiceConnectionPolicy can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:networkconnectivity/serviceConnectionPolicy:ServiceConnectionPolicy default projects/{{project}}/locations/{{location}}/serviceConnectionPolicies/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networkconnectivity/serviceConnectionPolicy:ServiceConnectionPolicy default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networkconnectivity/serviceConnectionPolicy:ServiceConnectionPolicy default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: Free-text description of the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: User-defined labels.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The location of the ServiceConnectionPolicy.
               
               
               - - -
        :param pulumi.Input[builtins.str] name: The name of a ServiceConnectionPolicy. Format: projects/{project}/locations/{location}/serviceConnectionPolicies/{service_connection_policy} See: https://google.aip.dev/122#fields-representing-resource-names
        :param pulumi.Input[builtins.str] network: The resource path of the consumer network. Example: - projects/{projectNumOrId}/global/networks/{resourceId}.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['ServiceConnectionPolicyPscConfigArgs', 'ServiceConnectionPolicyPscConfigArgsDict']] psc_config: Configuration used for Private Service Connect connections. Used when Infrastructure is PSC.
               Structure is documented below.
        :param pulumi.Input[builtins.str] service_class: The service class identifier for which this ServiceConnectionPolicy is for. The service class identifier is a unique, symbolic representation of a ServiceClass.
               It is provided by the Service Producer. Google services have a prefix of gcp. For example, gcp-cloud-sql. 3rd party services do not. For example, test-service-a3dfcx.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceConnectionPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manage Service Connection Policies.

        To get more information about ServiceConnectionPolicy, see:

        * [API documentation](https://cloud.google.com/network-connectivity/docs/reference/networkconnectivity/rest/v1/projects.locations.serviceConnectionPolicies)
        * How-to Guides
            * [About Service Connection Policies](https://cloud.google.com/vpc/docs/about-service-connection-policies#service-policies)
            * [About Service Connectivity Automation](https://cloud.google.com/vpc/docs/about-service-connectivity-automation)

        ## Example Usage

        ### Network Connectivity Policy Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        producer_net = gcp.compute.Network("producer_net",
            name="producer-net",
            auto_create_subnetworks=False)
        producer_subnet = gcp.compute.Subnetwork("producer_subnet",
            name="producer-subnet",
            ip_cidr_range="10.0.0.0/16",
            region="us-central1",
            network=producer_net.id)
        default = gcp.networkconnectivity.ServiceConnectionPolicy("default",
            name="my-network-connectivity-policy",
            location="us-central1",
            service_class="my-basic-service-class",
            description="my basic service connection policy",
            network=producer_net.id,
            psc_config={
                "subnetworks": [producer_subnet.id],
                "limit": "2",
            })
        ```

        ## Import

        ServiceConnectionPolicy can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/serviceConnectionPolicies/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, ServiceConnectionPolicy can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:networkconnectivity/serviceConnectionPolicy:ServiceConnectionPolicy default projects/{{project}}/locations/{{location}}/serviceConnectionPolicies/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networkconnectivity/serviceConnectionPolicy:ServiceConnectionPolicy default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networkconnectivity/serviceConnectionPolicy:ServiceConnectionPolicy default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param ServiceConnectionPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceConnectionPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 psc_config: Optional[pulumi.Input[Union['ServiceConnectionPolicyPscConfigArgs', 'ServiceConnectionPolicyPscConfigArgsDict']]] = None,
                 service_class: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceConnectionPolicyArgs.__new__(ServiceConnectionPolicyArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            if network is None and not opts.urn:
                raise TypeError("Missing required property 'network'")
            __props__.__dict__["network"] = network
            __props__.__dict__["project"] = project
            __props__.__dict__["psc_config"] = psc_config
            if service_class is None and not opts.urn:
                raise TypeError("Missing required property 'service_class'")
            __props__.__dict__["service_class"] = service_class
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["etag"] = None
            __props__.__dict__["infrastructure"] = None
            __props__.__dict__["psc_connections"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ServiceConnectionPolicy, __self__).__init__(
            'gcp:networkconnectivity/serviceConnectionPolicy:ServiceConnectionPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            etag: Optional[pulumi.Input[builtins.str]] = None,
            infrastructure: Optional[pulumi.Input[builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            network: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            psc_config: Optional[pulumi.Input[Union['ServiceConnectionPolicyPscConfigArgs', 'ServiceConnectionPolicyPscConfigArgsDict']]] = None,
            psc_connections: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceConnectionPolicyPscConnectionArgs', 'ServiceConnectionPolicyPscConnectionArgsDict']]]]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            service_class: Optional[pulumi.Input[builtins.str]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None) -> 'ServiceConnectionPolicy':
        """
        Get an existing ServiceConnectionPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] create_time: The timestamp when the resource was created.
        :param pulumi.Input[builtins.str] description: Free-text description of the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.str] etag: The etag is computed by the server, and may be sent on update and delete requests to ensure the client has an up-to-date value before proceeding.
        :param pulumi.Input[builtins.str] infrastructure: The type of underlying resources used to create the connection.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: User-defined labels.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The location of the ServiceConnectionPolicy.
               
               
               - - -
        :param pulumi.Input[builtins.str] name: The name of a ServiceConnectionPolicy. Format: projects/{project}/locations/{location}/serviceConnectionPolicies/{service_connection_policy} See: https://google.aip.dev/122#fields-representing-resource-names
        :param pulumi.Input[builtins.str] network: The resource path of the consumer network. Example: - projects/{projectNumOrId}/global/networks/{resourceId}.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['ServiceConnectionPolicyPscConfigArgs', 'ServiceConnectionPolicyPscConfigArgsDict']] psc_config: Configuration used for Private Service Connect connections. Used when Infrastructure is PSC.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceConnectionPolicyPscConnectionArgs', 'ServiceConnectionPolicyPscConnectionArgsDict']]]] psc_connections: Information about each Private Service Connect connection.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.str] service_class: The service class identifier for which this ServiceConnectionPolicy is for. The service class identifier is a unique, symbolic representation of a ServiceClass.
               It is provided by the Service Producer. Google services have a prefix of gcp. For example, gcp-cloud-sql. 3rd party services do not. For example, test-service-a3dfcx.
        :param pulumi.Input[builtins.str] update_time: The timestamp when the resource was updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceConnectionPolicyState.__new__(_ServiceConnectionPolicyState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["etag"] = etag
        __props__.__dict__["infrastructure"] = infrastructure
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["network"] = network
        __props__.__dict__["project"] = project
        __props__.__dict__["psc_config"] = psc_config
        __props__.__dict__["psc_connections"] = psc_connections
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["service_class"] = service_class
        __props__.__dict__["update_time"] = update_time
        return ServiceConnectionPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        The timestamp when the resource was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Free-text description of the resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[builtins.str]:
        """
        The etag is computed by the server, and may be sent on update and delete requests to ensure the client has an up-to-date value before proceeding.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def infrastructure(self) -> pulumi.Output[builtins.str]:
        """
        The type of underlying resources used to create the connection.
        """
        return pulumi.get(self, "infrastructure")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        User-defined labels.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The location of the ServiceConnectionPolicy.


        - - -
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of a ServiceConnectionPolicy. Format: projects/{project}/locations/{location}/serviceConnectionPolicies/{service_connection_policy} See: https://google.aip.dev/122#fields-representing-resource-names
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def network(self) -> pulumi.Output[builtins.str]:
        """
        The resource path of the consumer network. Example: - projects/{projectNumOrId}/global/networks/{resourceId}.
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pscConfig")
    def psc_config(self) -> pulumi.Output[Optional['outputs.ServiceConnectionPolicyPscConfig']]:
        """
        Configuration used for Private Service Connect connections. Used when Infrastructure is PSC.
        Structure is documented below.
        """
        return pulumi.get(self, "psc_config")

    @property
    @pulumi.getter(name="pscConnections")
    def psc_connections(self) -> pulumi.Output[Sequence['outputs.ServiceConnectionPolicyPscConnection']]:
        """
        Information about each Private Service Connect connection.
        Structure is documented below.
        """
        return pulumi.get(self, "psc_connections")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter(name="serviceClass")
    def service_class(self) -> pulumi.Output[builtins.str]:
        """
        The service class identifier for which this ServiceConnectionPolicy is for. The service class identifier is a unique, symbolic representation of a ServiceClass.
        It is provided by the Service Producer. Google services have a prefix of gcp. For example, gcp-cloud-sql. 3rd party services do not. For example, test-service-a3dfcx.
        """
        return pulumi.get(self, "service_class")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        The timestamp when the resource was updated.
        """
        return pulumi.get(self, "update_time")

