# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['TlsInspectionPolicyArgs', 'TlsInspectionPolicy']

@pulumi.input_type
class TlsInspectionPolicyArgs:
    def __init__(__self__, *,
                 ca_pool: pulumi.Input[builtins.str],
                 custom_tls_features: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 exclude_public_ca_set: Optional[pulumi.Input[builtins.bool]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 min_tls_version: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 tls_feature_profile: Optional[pulumi.Input[builtins.str]] = None,
                 trust_config: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a TlsInspectionPolicy resource.
        :param pulumi.Input[builtins.str] ca_pool: A CA pool resource used to issue interception certificates.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] custom_tls_features: List of custom TLS cipher suites selected. This field is valid only if the selected tls_feature_profile is CUSTOM. The compute.SslPoliciesService.ListAvailableFeatures method returns the set of features that can be specified in this list. Note that Secure Web Proxy does not yet honor this field.
        :param pulumi.Input[builtins.str] description: Free-text description of the resource.
        :param pulumi.Input[builtins.bool] exclude_public_ca_set: If FALSE (the default), use our default set of public CAs in addition to any CAs specified in trustConfig. These public CAs are currently based on the Mozilla Root Program and are subject to change over time. If TRUE, do not accept our default set of public CAs. Only CAs specified in trustConfig will be accepted.
        :param pulumi.Input[builtins.str] location: The location of the tls inspection policy.
        :param pulumi.Input[builtins.str] min_tls_version: Minimum TLS version that the firewall should use when negotiating connections with both clients and servers. If this is not set, then the default value is to allow the broadest set of clients and servers (TLS 1.0 or higher). Setting this to more restrictive values may improve security, but may also prevent the firewall from connecting to some clients or servers. Note that Secure Web Proxy does not yet honor this field.
               Default value is `TLS_VERSION_UNSPECIFIED`.
               Possible values are: `TLS_VERSION_UNSPECIFIED`, `TLS_1_0`, `TLS_1_1`, `TLS_1_2`, `TLS_1_3`.
        :param pulumi.Input[builtins.str] name: Short name of the TlsInspectionPolicy resource to be created.
               
               
               - - -
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] tls_feature_profile: The selected Profile. If this is not set, then the default value is to allow the broadest set of clients and servers (\\"PROFILE_COMPATIBLE\\"). Setting this to more restrictive values may improve security, but may also prevent the TLS inspection proxy from connecting to some clients or servers. Note that Secure Web Proxy does not yet honor this field.
               Default value is `PROFILE_UNSPECIFIED`.
               Possible values are: `PROFILE_UNSPECIFIED`, `PROFILE_COMPATIBLE`, `PROFILE_MODERN`, `PROFILE_RESTRICTED`, `PROFILE_CUSTOM`.
        :param pulumi.Input[builtins.str] trust_config: A TrustConfig resource used when making a connection to the TLS server. This is a relative resource path following the form \\"projects/{project}/locations/{location}/trustConfigs/{trust_config}\\". This is necessary to intercept TLS connections to servers with certificates signed by a private CA or self-signed certificates. Trust config and the TLS inspection policy must be in the same region. Note that Secure Web Proxy does not yet honor this field.
        """
        pulumi.set(__self__, "ca_pool", ca_pool)
        if custom_tls_features is not None:
            pulumi.set(__self__, "custom_tls_features", custom_tls_features)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if exclude_public_ca_set is not None:
            pulumi.set(__self__, "exclude_public_ca_set", exclude_public_ca_set)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if min_tls_version is not None:
            pulumi.set(__self__, "min_tls_version", min_tls_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if tls_feature_profile is not None:
            pulumi.set(__self__, "tls_feature_profile", tls_feature_profile)
        if trust_config is not None:
            pulumi.set(__self__, "trust_config", trust_config)

    @property
    @pulumi.getter(name="caPool")
    def ca_pool(self) -> pulumi.Input[builtins.str]:
        """
        A CA pool resource used to issue interception certificates.
        """
        return pulumi.get(self, "ca_pool")

    @ca_pool.setter
    def ca_pool(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "ca_pool", value)

    @property
    @pulumi.getter(name="customTlsFeatures")
    def custom_tls_features(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of custom TLS cipher suites selected. This field is valid only if the selected tls_feature_profile is CUSTOM. The compute.SslPoliciesService.ListAvailableFeatures method returns the set of features that can be specified in this list. Note that Secure Web Proxy does not yet honor this field.
        """
        return pulumi.get(self, "custom_tls_features")

    @custom_tls_features.setter
    def custom_tls_features(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "custom_tls_features", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Free-text description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="excludePublicCaSet")
    def exclude_public_ca_set(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If FALSE (the default), use our default set of public CAs in addition to any CAs specified in trustConfig. These public CAs are currently based on the Mozilla Root Program and are subject to change over time. If TRUE, do not accept our default set of public CAs. Only CAs specified in trustConfig will be accepted.
        """
        return pulumi.get(self, "exclude_public_ca_set")

    @exclude_public_ca_set.setter
    def exclude_public_ca_set(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "exclude_public_ca_set", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location of the tls inspection policy.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="minTlsVersion")
    def min_tls_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Minimum TLS version that the firewall should use when negotiating connections with both clients and servers. If this is not set, then the default value is to allow the broadest set of clients and servers (TLS 1.0 or higher). Setting this to more restrictive values may improve security, but may also prevent the firewall from connecting to some clients or servers. Note that Secure Web Proxy does not yet honor this field.
        Default value is `TLS_VERSION_UNSPECIFIED`.
        Possible values are: `TLS_VERSION_UNSPECIFIED`, `TLS_1_0`, `TLS_1_1`, `TLS_1_2`, `TLS_1_3`.
        """
        return pulumi.get(self, "min_tls_version")

    @min_tls_version.setter
    def min_tls_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "min_tls_version", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Short name of the TlsInspectionPolicy resource to be created.


        - - -
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="tlsFeatureProfile")
    def tls_feature_profile(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The selected Profile. If this is not set, then the default value is to allow the broadest set of clients and servers (\\"PROFILE_COMPATIBLE\\"). Setting this to more restrictive values may improve security, but may also prevent the TLS inspection proxy from connecting to some clients or servers. Note that Secure Web Proxy does not yet honor this field.
        Default value is `PROFILE_UNSPECIFIED`.
        Possible values are: `PROFILE_UNSPECIFIED`, `PROFILE_COMPATIBLE`, `PROFILE_MODERN`, `PROFILE_RESTRICTED`, `PROFILE_CUSTOM`.
        """
        return pulumi.get(self, "tls_feature_profile")

    @tls_feature_profile.setter
    def tls_feature_profile(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tls_feature_profile", value)

    @property
    @pulumi.getter(name="trustConfig")
    def trust_config(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A TrustConfig resource used when making a connection to the TLS server. This is a relative resource path following the form \\"projects/{project}/locations/{location}/trustConfigs/{trust_config}\\". This is necessary to intercept TLS connections to servers with certificates signed by a private CA or self-signed certificates. Trust config and the TLS inspection policy must be in the same region. Note that Secure Web Proxy does not yet honor this field.
        """
        return pulumi.get(self, "trust_config")

    @trust_config.setter
    def trust_config(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "trust_config", value)


@pulumi.input_type
class _TlsInspectionPolicyState:
    def __init__(__self__, *,
                 ca_pool: Optional[pulumi.Input[builtins.str]] = None,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 custom_tls_features: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 exclude_public_ca_set: Optional[pulumi.Input[builtins.bool]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 min_tls_version: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 tls_feature_profile: Optional[pulumi.Input[builtins.str]] = None,
                 trust_config: Optional[pulumi.Input[builtins.str]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering TlsInspectionPolicy resources.
        :param pulumi.Input[builtins.str] ca_pool: A CA pool resource used to issue interception certificates.
        :param pulumi.Input[builtins.str] create_time: The timestamp when the resource was created.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] custom_tls_features: List of custom TLS cipher suites selected. This field is valid only if the selected tls_feature_profile is CUSTOM. The compute.SslPoliciesService.ListAvailableFeatures method returns the set of features that can be specified in this list. Note that Secure Web Proxy does not yet honor this field.
        :param pulumi.Input[builtins.str] description: Free-text description of the resource.
        :param pulumi.Input[builtins.bool] exclude_public_ca_set: If FALSE (the default), use our default set of public CAs in addition to any CAs specified in trustConfig. These public CAs are currently based on the Mozilla Root Program and are subject to change over time. If TRUE, do not accept our default set of public CAs. Only CAs specified in trustConfig will be accepted.
        :param pulumi.Input[builtins.str] location: The location of the tls inspection policy.
        :param pulumi.Input[builtins.str] min_tls_version: Minimum TLS version that the firewall should use when negotiating connections with both clients and servers. If this is not set, then the default value is to allow the broadest set of clients and servers (TLS 1.0 or higher). Setting this to more restrictive values may improve security, but may also prevent the firewall from connecting to some clients or servers. Note that Secure Web Proxy does not yet honor this field.
               Default value is `TLS_VERSION_UNSPECIFIED`.
               Possible values are: `TLS_VERSION_UNSPECIFIED`, `TLS_1_0`, `TLS_1_1`, `TLS_1_2`, `TLS_1_3`.
        :param pulumi.Input[builtins.str] name: Short name of the TlsInspectionPolicy resource to be created.
               
               
               - - -
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] tls_feature_profile: The selected Profile. If this is not set, then the default value is to allow the broadest set of clients and servers (\\"PROFILE_COMPATIBLE\\"). Setting this to more restrictive values may improve security, but may also prevent the TLS inspection proxy from connecting to some clients or servers. Note that Secure Web Proxy does not yet honor this field.
               Default value is `PROFILE_UNSPECIFIED`.
               Possible values are: `PROFILE_UNSPECIFIED`, `PROFILE_COMPATIBLE`, `PROFILE_MODERN`, `PROFILE_RESTRICTED`, `PROFILE_CUSTOM`.
        :param pulumi.Input[builtins.str] trust_config: A TrustConfig resource used when making a connection to the TLS server. This is a relative resource path following the form \\"projects/{project}/locations/{location}/trustConfigs/{trust_config}\\". This is necessary to intercept TLS connections to servers with certificates signed by a private CA or self-signed certificates. Trust config and the TLS inspection policy must be in the same region. Note that Secure Web Proxy does not yet honor this field.
        :param pulumi.Input[builtins.str] update_time: The timestamp when the resource was updated.
        """
        if ca_pool is not None:
            pulumi.set(__self__, "ca_pool", ca_pool)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if custom_tls_features is not None:
            pulumi.set(__self__, "custom_tls_features", custom_tls_features)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if exclude_public_ca_set is not None:
            pulumi.set(__self__, "exclude_public_ca_set", exclude_public_ca_set)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if min_tls_version is not None:
            pulumi.set(__self__, "min_tls_version", min_tls_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if tls_feature_profile is not None:
            pulumi.set(__self__, "tls_feature_profile", tls_feature_profile)
        if trust_config is not None:
            pulumi.set(__self__, "trust_config", trust_config)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="caPool")
    def ca_pool(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A CA pool resource used to issue interception certificates.
        """
        return pulumi.get(self, "ca_pool")

    @ca_pool.setter
    def ca_pool(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ca_pool", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The timestamp when the resource was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="customTlsFeatures")
    def custom_tls_features(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of custom TLS cipher suites selected. This field is valid only if the selected tls_feature_profile is CUSTOM. The compute.SslPoliciesService.ListAvailableFeatures method returns the set of features that can be specified in this list. Note that Secure Web Proxy does not yet honor this field.
        """
        return pulumi.get(self, "custom_tls_features")

    @custom_tls_features.setter
    def custom_tls_features(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "custom_tls_features", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Free-text description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="excludePublicCaSet")
    def exclude_public_ca_set(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If FALSE (the default), use our default set of public CAs in addition to any CAs specified in trustConfig. These public CAs are currently based on the Mozilla Root Program and are subject to change over time. If TRUE, do not accept our default set of public CAs. Only CAs specified in trustConfig will be accepted.
        """
        return pulumi.get(self, "exclude_public_ca_set")

    @exclude_public_ca_set.setter
    def exclude_public_ca_set(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "exclude_public_ca_set", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location of the tls inspection policy.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="minTlsVersion")
    def min_tls_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Minimum TLS version that the firewall should use when negotiating connections with both clients and servers. If this is not set, then the default value is to allow the broadest set of clients and servers (TLS 1.0 or higher). Setting this to more restrictive values may improve security, but may also prevent the firewall from connecting to some clients or servers. Note that Secure Web Proxy does not yet honor this field.
        Default value is `TLS_VERSION_UNSPECIFIED`.
        Possible values are: `TLS_VERSION_UNSPECIFIED`, `TLS_1_0`, `TLS_1_1`, `TLS_1_2`, `TLS_1_3`.
        """
        return pulumi.get(self, "min_tls_version")

    @min_tls_version.setter
    def min_tls_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "min_tls_version", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Short name of the TlsInspectionPolicy resource to be created.


        - - -
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="tlsFeatureProfile")
    def tls_feature_profile(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The selected Profile. If this is not set, then the default value is to allow the broadest set of clients and servers (\\"PROFILE_COMPATIBLE\\"). Setting this to more restrictive values may improve security, but may also prevent the TLS inspection proxy from connecting to some clients or servers. Note that Secure Web Proxy does not yet honor this field.
        Default value is `PROFILE_UNSPECIFIED`.
        Possible values are: `PROFILE_UNSPECIFIED`, `PROFILE_COMPATIBLE`, `PROFILE_MODERN`, `PROFILE_RESTRICTED`, `PROFILE_CUSTOM`.
        """
        return pulumi.get(self, "tls_feature_profile")

    @tls_feature_profile.setter
    def tls_feature_profile(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tls_feature_profile", value)

    @property
    @pulumi.getter(name="trustConfig")
    def trust_config(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A TrustConfig resource used when making a connection to the TLS server. This is a relative resource path following the form \\"projects/{project}/locations/{location}/trustConfigs/{trust_config}\\". This is necessary to intercept TLS connections to servers with certificates signed by a private CA or self-signed certificates. Trust config and the TLS inspection policy must be in the same region. Note that Secure Web Proxy does not yet honor this field.
        """
        return pulumi.get(self, "trust_config")

    @trust_config.setter
    def trust_config(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "trust_config", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The timestamp when the resource was updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:networksecurity/tlsInspectionPolicy:TlsInspectionPolicy")
class TlsInspectionPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ca_pool: Optional[pulumi.Input[builtins.str]] = None,
                 custom_tls_features: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 exclude_public_ca_set: Optional[pulumi.Input[builtins.bool]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 min_tls_version: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 tls_feature_profile: Optional[pulumi.Input[builtins.str]] = None,
                 trust_config: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        The TlsInspectionPolicy resource contains references to CA pools in Certificate Authority Service and associated metadata.

        To get more information about TlsInspectionPolicy, see:

        * [API documentation](https://cloud.google.com/secure-web-proxy/docs/reference/network-security/rest/v1/projects.locations.tlsInspectionPolicies)
        * How-to Guides
            * [Use TlsInspectionPolicy](https://cloud.google.com/secure-web-proxy/docs/tls-inspection-overview)

        ## Example Usage

        ### Network Security Tls Inspection Policy Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.certificateauthority.CaPool("default",
            name="my-basic-ca-pool",
            location="us-central1",
            tier="DEVOPS",
            publishing_options={
                "publish_ca_cert": False,
                "publish_crl": False,
            },
            issuance_policy={
                "maximum_lifetime": "1209600s",
                "baseline_values": {
                    "ca_options": {
                        "is_ca": False,
                    },
                    "key_usage": {
                        "base_key_usage": {},
                        "extended_key_usage": {
                            "server_auth": True,
                        },
                    },
                },
            })
        default_authority = gcp.certificateauthority.Authority("default",
            pool=default.name,
            certificate_authority_id="my-basic-certificate-authority",
            location="us-central1",
            lifetime="86400s",
            type="SELF_SIGNED",
            deletion_protection=False,
            skip_grace_period=True,
            ignore_active_certificates_on_deletion=True,
            config={
                "subject_config": {
                    "subject": {
                        "organization": "Test LLC",
                        "common_name": "my-ca",
                    },
                },
                "x509_config": {
                    "ca_options": {
                        "is_ca": True,
                    },
                    "key_usage": {
                        "base_key_usage": {
                            "cert_sign": True,
                            "crl_sign": True,
                        },
                        "extended_key_usage": {
                            "server_auth": False,
                        },
                    },
                },
            },
            key_spec={
                "algorithm": "RSA_PKCS1_4096_SHA256",
            })
        project = gcp.organizations.get_project()
        tls_inspection_permission = gcp.certificateauthority.CaPoolIamMember("tls_inspection_permission",
            ca_pool=default.id,
            role="roles/privateca.certificateManager",
            member=f"serviceAccount:service-{project.number}@gcp-sa-networksecurity.iam.gserviceaccount.com")
        default_tls_inspection_policy = gcp.networksecurity.TlsInspectionPolicy("default",
            name="my-tls-inspection-policy",
            location="us-central1",
            ca_pool=default.id,
            exclude_public_ca_set=False,
            opts = pulumi.ResourceOptions(depends_on=[
                    default,
                    default_authority,
                    tls_inspection_permission,
                ]))
        ```
        ### Network Security Tls Inspection Policy Custom

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        default = gcp.certificateauthority.CaPool("default",
            name="my-basic-ca-pool",
            location="us-central1",
            tier="DEVOPS",
            publishing_options={
                "publish_ca_cert": False,
                "publish_crl": False,
            },
            issuance_policy={
                "maximum_lifetime": "1209600s",
                "baseline_values": {
                    "ca_options": {
                        "is_ca": False,
                    },
                    "key_usage": {
                        "base_key_usage": {},
                        "extended_key_usage": {
                            "server_auth": True,
                        },
                    },
                },
            })
        default_authority = gcp.certificateauthority.Authority("default",
            pool=default.name,
            certificate_authority_id="my-basic-certificate-authority",
            location="us-central1",
            lifetime="86400s",
            type="SELF_SIGNED",
            deletion_protection=False,
            skip_grace_period=True,
            ignore_active_certificates_on_deletion=True,
            config={
                "subject_config": {
                    "subject": {
                        "organization": "Test LLC",
                        "common_name": "my-ca",
                    },
                },
                "x509_config": {
                    "ca_options": {
                        "is_ca": True,
                    },
                    "key_usage": {
                        "base_key_usage": {
                            "cert_sign": True,
                            "crl_sign": True,
                        },
                        "extended_key_usage": {
                            "server_auth": False,
                        },
                    },
                },
            },
            key_spec={
                "algorithm": "RSA_PKCS1_4096_SHA256",
            })
        ns_sa = gcp.projects.ServiceIdentity("ns_sa", service="networksecurity.googleapis.com")
        default_ca_pool_iam_member = gcp.certificateauthority.CaPoolIamMember("default",
            ca_pool=default.id,
            role="roles/privateca.certificateManager",
            member=ns_sa.member)
        default_trust_config = gcp.certificatemanager.TrustConfig("default",
            name="my-trust-config",
            description="sample trust config description",
            location="us-central1",
            trust_stores=[{
                "trust_anchors": [{
                    "pem_certificate": std.file(input="test-fixtures/ca_cert.pem").result,
                }],
                "intermediate_cas": [{
                    "pem_certificate": std.file(input="test-fixtures/ca_cert.pem").result,
                }],
            }])
        default_tls_inspection_policy = gcp.networksecurity.TlsInspectionPolicy("default",
            name="my-tls-inspection-policy",
            location="us-central1",
            ca_pool=default.id,
            exclude_public_ca_set=False,
            min_tls_version="TLS_1_0",
            trust_config=default_trust_config.id,
            tls_feature_profile="PROFILE_CUSTOM",
            custom_tls_features=[
                "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA",
                "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256",
                "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA",
                "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384",
                "TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256",
                "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA",
                "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256",
                "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA",
                "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384",
                "TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256",
                "TLS_RSA_WITH_3DES_EDE_CBC_SHA",
                "TLS_RSA_WITH_AES_128_CBC_SHA",
                "TLS_RSA_WITH_AES_128_GCM_SHA256",
                "TLS_RSA_WITH_AES_256_CBC_SHA",
                "TLS_RSA_WITH_AES_256_GCM_SHA384",
            ],
            opts = pulumi.ResourceOptions(depends_on=[
                    default_authority,
                    default_ca_pool_iam_member,
                ]))
        ```

        ## Import

        TlsInspectionPolicy can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/tlsInspectionPolicies/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, TlsInspectionPolicy can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:networksecurity/tlsInspectionPolicy:TlsInspectionPolicy default projects/{{project}}/locations/{{location}}/tlsInspectionPolicies/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networksecurity/tlsInspectionPolicy:TlsInspectionPolicy default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networksecurity/tlsInspectionPolicy:TlsInspectionPolicy default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] ca_pool: A CA pool resource used to issue interception certificates.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] custom_tls_features: List of custom TLS cipher suites selected. This field is valid only if the selected tls_feature_profile is CUSTOM. The compute.SslPoliciesService.ListAvailableFeatures method returns the set of features that can be specified in this list. Note that Secure Web Proxy does not yet honor this field.
        :param pulumi.Input[builtins.str] description: Free-text description of the resource.
        :param pulumi.Input[builtins.bool] exclude_public_ca_set: If FALSE (the default), use our default set of public CAs in addition to any CAs specified in trustConfig. These public CAs are currently based on the Mozilla Root Program and are subject to change over time. If TRUE, do not accept our default set of public CAs. Only CAs specified in trustConfig will be accepted.
        :param pulumi.Input[builtins.str] location: The location of the tls inspection policy.
        :param pulumi.Input[builtins.str] min_tls_version: Minimum TLS version that the firewall should use when negotiating connections with both clients and servers. If this is not set, then the default value is to allow the broadest set of clients and servers (TLS 1.0 or higher). Setting this to more restrictive values may improve security, but may also prevent the firewall from connecting to some clients or servers. Note that Secure Web Proxy does not yet honor this field.
               Default value is `TLS_VERSION_UNSPECIFIED`.
               Possible values are: `TLS_VERSION_UNSPECIFIED`, `TLS_1_0`, `TLS_1_1`, `TLS_1_2`, `TLS_1_3`.
        :param pulumi.Input[builtins.str] name: Short name of the TlsInspectionPolicy resource to be created.
               
               
               - - -
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] tls_feature_profile: The selected Profile. If this is not set, then the default value is to allow the broadest set of clients and servers (\\"PROFILE_COMPATIBLE\\"). Setting this to more restrictive values may improve security, but may also prevent the TLS inspection proxy from connecting to some clients or servers. Note that Secure Web Proxy does not yet honor this field.
               Default value is `PROFILE_UNSPECIFIED`.
               Possible values are: `PROFILE_UNSPECIFIED`, `PROFILE_COMPATIBLE`, `PROFILE_MODERN`, `PROFILE_RESTRICTED`, `PROFILE_CUSTOM`.
        :param pulumi.Input[builtins.str] trust_config: A TrustConfig resource used when making a connection to the TLS server. This is a relative resource path following the form \\"projects/{project}/locations/{location}/trustConfigs/{trust_config}\\". This is necessary to intercept TLS connections to servers with certificates signed by a private CA or self-signed certificates. Trust config and the TLS inspection policy must be in the same region. Note that Secure Web Proxy does not yet honor this field.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TlsInspectionPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The TlsInspectionPolicy resource contains references to CA pools in Certificate Authority Service and associated metadata.

        To get more information about TlsInspectionPolicy, see:

        * [API documentation](https://cloud.google.com/secure-web-proxy/docs/reference/network-security/rest/v1/projects.locations.tlsInspectionPolicies)
        * How-to Guides
            * [Use TlsInspectionPolicy](https://cloud.google.com/secure-web-proxy/docs/tls-inspection-overview)

        ## Example Usage

        ### Network Security Tls Inspection Policy Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.certificateauthority.CaPool("default",
            name="my-basic-ca-pool",
            location="us-central1",
            tier="DEVOPS",
            publishing_options={
                "publish_ca_cert": False,
                "publish_crl": False,
            },
            issuance_policy={
                "maximum_lifetime": "1209600s",
                "baseline_values": {
                    "ca_options": {
                        "is_ca": False,
                    },
                    "key_usage": {
                        "base_key_usage": {},
                        "extended_key_usage": {
                            "server_auth": True,
                        },
                    },
                },
            })
        default_authority = gcp.certificateauthority.Authority("default",
            pool=default.name,
            certificate_authority_id="my-basic-certificate-authority",
            location="us-central1",
            lifetime="86400s",
            type="SELF_SIGNED",
            deletion_protection=False,
            skip_grace_period=True,
            ignore_active_certificates_on_deletion=True,
            config={
                "subject_config": {
                    "subject": {
                        "organization": "Test LLC",
                        "common_name": "my-ca",
                    },
                },
                "x509_config": {
                    "ca_options": {
                        "is_ca": True,
                    },
                    "key_usage": {
                        "base_key_usage": {
                            "cert_sign": True,
                            "crl_sign": True,
                        },
                        "extended_key_usage": {
                            "server_auth": False,
                        },
                    },
                },
            },
            key_spec={
                "algorithm": "RSA_PKCS1_4096_SHA256",
            })
        project = gcp.organizations.get_project()
        tls_inspection_permission = gcp.certificateauthority.CaPoolIamMember("tls_inspection_permission",
            ca_pool=default.id,
            role="roles/privateca.certificateManager",
            member=f"serviceAccount:service-{project.number}@gcp-sa-networksecurity.iam.gserviceaccount.com")
        default_tls_inspection_policy = gcp.networksecurity.TlsInspectionPolicy("default",
            name="my-tls-inspection-policy",
            location="us-central1",
            ca_pool=default.id,
            exclude_public_ca_set=False,
            opts = pulumi.ResourceOptions(depends_on=[
                    default,
                    default_authority,
                    tls_inspection_permission,
                ]))
        ```
        ### Network Security Tls Inspection Policy Custom

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        default = gcp.certificateauthority.CaPool("default",
            name="my-basic-ca-pool",
            location="us-central1",
            tier="DEVOPS",
            publishing_options={
                "publish_ca_cert": False,
                "publish_crl": False,
            },
            issuance_policy={
                "maximum_lifetime": "1209600s",
                "baseline_values": {
                    "ca_options": {
                        "is_ca": False,
                    },
                    "key_usage": {
                        "base_key_usage": {},
                        "extended_key_usage": {
                            "server_auth": True,
                        },
                    },
                },
            })
        default_authority = gcp.certificateauthority.Authority("default",
            pool=default.name,
            certificate_authority_id="my-basic-certificate-authority",
            location="us-central1",
            lifetime="86400s",
            type="SELF_SIGNED",
            deletion_protection=False,
            skip_grace_period=True,
            ignore_active_certificates_on_deletion=True,
            config={
                "subject_config": {
                    "subject": {
                        "organization": "Test LLC",
                        "common_name": "my-ca",
                    },
                },
                "x509_config": {
                    "ca_options": {
                        "is_ca": True,
                    },
                    "key_usage": {
                        "base_key_usage": {
                            "cert_sign": True,
                            "crl_sign": True,
                        },
                        "extended_key_usage": {
                            "server_auth": False,
                        },
                    },
                },
            },
            key_spec={
                "algorithm": "RSA_PKCS1_4096_SHA256",
            })
        ns_sa = gcp.projects.ServiceIdentity("ns_sa", service="networksecurity.googleapis.com")
        default_ca_pool_iam_member = gcp.certificateauthority.CaPoolIamMember("default",
            ca_pool=default.id,
            role="roles/privateca.certificateManager",
            member=ns_sa.member)
        default_trust_config = gcp.certificatemanager.TrustConfig("default",
            name="my-trust-config",
            description="sample trust config description",
            location="us-central1",
            trust_stores=[{
                "trust_anchors": [{
                    "pem_certificate": std.file(input="test-fixtures/ca_cert.pem").result,
                }],
                "intermediate_cas": [{
                    "pem_certificate": std.file(input="test-fixtures/ca_cert.pem").result,
                }],
            }])
        default_tls_inspection_policy = gcp.networksecurity.TlsInspectionPolicy("default",
            name="my-tls-inspection-policy",
            location="us-central1",
            ca_pool=default.id,
            exclude_public_ca_set=False,
            min_tls_version="TLS_1_0",
            trust_config=default_trust_config.id,
            tls_feature_profile="PROFILE_CUSTOM",
            custom_tls_features=[
                "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA",
                "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256",
                "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA",
                "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384",
                "TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256",
                "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA",
                "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256",
                "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA",
                "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384",
                "TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256",
                "TLS_RSA_WITH_3DES_EDE_CBC_SHA",
                "TLS_RSA_WITH_AES_128_CBC_SHA",
                "TLS_RSA_WITH_AES_128_GCM_SHA256",
                "TLS_RSA_WITH_AES_256_CBC_SHA",
                "TLS_RSA_WITH_AES_256_GCM_SHA384",
            ],
            opts = pulumi.ResourceOptions(depends_on=[
                    default_authority,
                    default_ca_pool_iam_member,
                ]))
        ```

        ## Import

        TlsInspectionPolicy can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/tlsInspectionPolicies/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, TlsInspectionPolicy can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:networksecurity/tlsInspectionPolicy:TlsInspectionPolicy default projects/{{project}}/locations/{{location}}/tlsInspectionPolicies/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networksecurity/tlsInspectionPolicy:TlsInspectionPolicy default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networksecurity/tlsInspectionPolicy:TlsInspectionPolicy default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param TlsInspectionPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TlsInspectionPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ca_pool: Optional[pulumi.Input[builtins.str]] = None,
                 custom_tls_features: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 exclude_public_ca_set: Optional[pulumi.Input[builtins.bool]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 min_tls_version: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 tls_feature_profile: Optional[pulumi.Input[builtins.str]] = None,
                 trust_config: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TlsInspectionPolicyArgs.__new__(TlsInspectionPolicyArgs)

            if ca_pool is None and not opts.urn:
                raise TypeError("Missing required property 'ca_pool'")
            __props__.__dict__["ca_pool"] = ca_pool
            __props__.__dict__["custom_tls_features"] = custom_tls_features
            __props__.__dict__["description"] = description
            __props__.__dict__["exclude_public_ca_set"] = exclude_public_ca_set
            __props__.__dict__["location"] = location
            __props__.__dict__["min_tls_version"] = min_tls_version
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["tls_feature_profile"] = tls_feature_profile
            __props__.__dict__["trust_config"] = trust_config
            __props__.__dict__["create_time"] = None
            __props__.__dict__["update_time"] = None
        super(TlsInspectionPolicy, __self__).__init__(
            'gcp:networksecurity/tlsInspectionPolicy:TlsInspectionPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            ca_pool: Optional[pulumi.Input[builtins.str]] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            custom_tls_features: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            exclude_public_ca_set: Optional[pulumi.Input[builtins.bool]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            min_tls_version: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            tls_feature_profile: Optional[pulumi.Input[builtins.str]] = None,
            trust_config: Optional[pulumi.Input[builtins.str]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None) -> 'TlsInspectionPolicy':
        """
        Get an existing TlsInspectionPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] ca_pool: A CA pool resource used to issue interception certificates.
        :param pulumi.Input[builtins.str] create_time: The timestamp when the resource was created.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] custom_tls_features: List of custom TLS cipher suites selected. This field is valid only if the selected tls_feature_profile is CUSTOM. The compute.SslPoliciesService.ListAvailableFeatures method returns the set of features that can be specified in this list. Note that Secure Web Proxy does not yet honor this field.
        :param pulumi.Input[builtins.str] description: Free-text description of the resource.
        :param pulumi.Input[builtins.bool] exclude_public_ca_set: If FALSE (the default), use our default set of public CAs in addition to any CAs specified in trustConfig. These public CAs are currently based on the Mozilla Root Program and are subject to change over time. If TRUE, do not accept our default set of public CAs. Only CAs specified in trustConfig will be accepted.
        :param pulumi.Input[builtins.str] location: The location of the tls inspection policy.
        :param pulumi.Input[builtins.str] min_tls_version: Minimum TLS version that the firewall should use when negotiating connections with both clients and servers. If this is not set, then the default value is to allow the broadest set of clients and servers (TLS 1.0 or higher). Setting this to more restrictive values may improve security, but may also prevent the firewall from connecting to some clients or servers. Note that Secure Web Proxy does not yet honor this field.
               Default value is `TLS_VERSION_UNSPECIFIED`.
               Possible values are: `TLS_VERSION_UNSPECIFIED`, `TLS_1_0`, `TLS_1_1`, `TLS_1_2`, `TLS_1_3`.
        :param pulumi.Input[builtins.str] name: Short name of the TlsInspectionPolicy resource to be created.
               
               
               - - -
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] tls_feature_profile: The selected Profile. If this is not set, then the default value is to allow the broadest set of clients and servers (\\"PROFILE_COMPATIBLE\\"). Setting this to more restrictive values may improve security, but may also prevent the TLS inspection proxy from connecting to some clients or servers. Note that Secure Web Proxy does not yet honor this field.
               Default value is `PROFILE_UNSPECIFIED`.
               Possible values are: `PROFILE_UNSPECIFIED`, `PROFILE_COMPATIBLE`, `PROFILE_MODERN`, `PROFILE_RESTRICTED`, `PROFILE_CUSTOM`.
        :param pulumi.Input[builtins.str] trust_config: A TrustConfig resource used when making a connection to the TLS server. This is a relative resource path following the form \\"projects/{project}/locations/{location}/trustConfigs/{trust_config}\\". This is necessary to intercept TLS connections to servers with certificates signed by a private CA or self-signed certificates. Trust config and the TLS inspection policy must be in the same region. Note that Secure Web Proxy does not yet honor this field.
        :param pulumi.Input[builtins.str] update_time: The timestamp when the resource was updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TlsInspectionPolicyState.__new__(_TlsInspectionPolicyState)

        __props__.__dict__["ca_pool"] = ca_pool
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["custom_tls_features"] = custom_tls_features
        __props__.__dict__["description"] = description
        __props__.__dict__["exclude_public_ca_set"] = exclude_public_ca_set
        __props__.__dict__["location"] = location
        __props__.__dict__["min_tls_version"] = min_tls_version
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["tls_feature_profile"] = tls_feature_profile
        __props__.__dict__["trust_config"] = trust_config
        __props__.__dict__["update_time"] = update_time
        return TlsInspectionPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="caPool")
    def ca_pool(self) -> pulumi.Output[builtins.str]:
        """
        A CA pool resource used to issue interception certificates.
        """
        return pulumi.get(self, "ca_pool")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        The timestamp when the resource was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="customTlsFeatures")
    def custom_tls_features(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        List of custom TLS cipher suites selected. This field is valid only if the selected tls_feature_profile is CUSTOM. The compute.SslPoliciesService.ListAvailableFeatures method returns the set of features that can be specified in this list. Note that Secure Web Proxy does not yet honor this field.
        """
        return pulumi.get(self, "custom_tls_features")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Free-text description of the resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="excludePublicCaSet")
    def exclude_public_ca_set(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        If FALSE (the default), use our default set of public CAs in addition to any CAs specified in trustConfig. These public CAs are currently based on the Mozilla Root Program and are subject to change over time. If TRUE, do not accept our default set of public CAs. Only CAs specified in trustConfig will be accepted.
        """
        return pulumi.get(self, "exclude_public_ca_set")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The location of the tls inspection policy.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="minTlsVersion")
    def min_tls_version(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Minimum TLS version that the firewall should use when negotiating connections with both clients and servers. If this is not set, then the default value is to allow the broadest set of clients and servers (TLS 1.0 or higher). Setting this to more restrictive values may improve security, but may also prevent the firewall from connecting to some clients or servers. Note that Secure Web Proxy does not yet honor this field.
        Default value is `TLS_VERSION_UNSPECIFIED`.
        Possible values are: `TLS_VERSION_UNSPECIFIED`, `TLS_1_0`, `TLS_1_1`, `TLS_1_2`, `TLS_1_3`.
        """
        return pulumi.get(self, "min_tls_version")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Short name of the TlsInspectionPolicy resource to be created.


        - - -
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="tlsFeatureProfile")
    def tls_feature_profile(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The selected Profile. If this is not set, then the default value is to allow the broadest set of clients and servers (\\"PROFILE_COMPATIBLE\\"). Setting this to more restrictive values may improve security, but may also prevent the TLS inspection proxy from connecting to some clients or servers. Note that Secure Web Proxy does not yet honor this field.
        Default value is `PROFILE_UNSPECIFIED`.
        Possible values are: `PROFILE_UNSPECIFIED`, `PROFILE_COMPATIBLE`, `PROFILE_MODERN`, `PROFILE_RESTRICTED`, `PROFILE_CUSTOM`.
        """
        return pulumi.get(self, "tls_feature_profile")

    @property
    @pulumi.getter(name="trustConfig")
    def trust_config(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A TrustConfig resource used when making a connection to the TLS server. This is a relative resource path following the form \\"projects/{project}/locations/{location}/trustConfigs/{trust_config}\\". This is necessary to intercept TLS connections to servers with certificates signed by a private CA or self-signed certificates. Trust config and the TLS inspection policy must be in the same region. Note that Secure Web Proxy does not yet honor this field.
        """
        return pulumi.get(self, "trust_config")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        The timestamp when the resource was updated.
        """
        return pulumi.get(self, "update_time")

