# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AuthzExtensionArgs', 'AuthzExtension']

@pulumi.input_type
class AuthzExtensionArgs:
    def __init__(__self__, *,
                 authority: pulumi.Input[builtins.str],
                 load_balancing_scheme: pulumi.Input[builtins.str],
                 location: pulumi.Input[builtins.str],
                 service: pulumi.Input[builtins.str],
                 timeout: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 fail_open: Optional[pulumi.Input[builtins.bool]] = None,
                 forward_headers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 wire_format: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a AuthzExtension resource.
        :param pulumi.Input[builtins.str] authority: The :authority header in the gRPC request sent from Envoy to the extension service.
        :param pulumi.Input[builtins.str] load_balancing_scheme: All backend services and forwarding rules referenced by this extension must share the same load balancing scheme.
               For more information, refer to [Backend services overview](https://cloud.google.com/load-balancing/docs/backend-service).
               Possible values are: `INTERNAL_MANAGED`, `EXTERNAL_MANAGED`.
        :param pulumi.Input[builtins.str] location: The location of the resource.
               
               
               - - -
        :param pulumi.Input[builtins.str] service: The reference to the service that runs the extension.
               To configure a callout extension, service must be a fully-qualified reference to a [backend service](https://cloud.google.com/compute/docs/reference/rest/v1/backendServices) in the format:
               https://www.googleapis.com/compute/v1/projects/{project}/regions/{region}/backendServices/{backendService} or https://www.googleapis.com/compute/v1/projects/{project}/global/backendServices/{backendService}.
        :param pulumi.Input[builtins.str] timeout: Specifies the timeout for each individual message on the stream. The timeout must be between 10-10000 milliseconds.
        :param pulumi.Input[builtins.str] description: A human-readable description of the resource.
        :param pulumi.Input[builtins.bool] fail_open: Determines how the proxy behaves if the call to the extension fails or times out.
               When set to TRUE, request or response processing continues without error. Any subsequent extensions in the extension chain are also executed. When set to FALSE or the default setting of FALSE is used, one of the following happens:
               * If response headers have not been delivered to the downstream client, a generic 500 error is returned to the client. The error response can be tailored by configuring a custom error response in the load balancer.
               * If response headers have been delivered, then the HTTP stream to the downstream client is reset.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] forward_headers: List of the HTTP headers to forward to the extension (from the client). If omitted, all headers are sent. Each element is a string indicating the header name.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Set of labels associated with the AuthzExtension resource.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] metadata: The metadata provided here is included as part of the metadata_context (of type google.protobuf.Struct) in the ProcessingRequest message sent to the extension server. The metadata is available under the namespace com.google.authz_extension.<resourceName>. The following variables are supported in the metadata Struct:
               {forwarding_rule_id} - substituted with the forwarding rule's fully qualified resource name.
        :param pulumi.Input[builtins.str] name: Identifier. Name of the AuthzExtension resource.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] wire_format: The format of communication supported by the callout extension. Will be set to EXT_PROC_GRPC by the backend if no value is set.
               Possible values are: `WIRE_FORMAT_UNSPECIFIED`, `EXT_PROC_GRPC`.
        """
        pulumi.set(__self__, "authority", authority)
        pulumi.set(__self__, "load_balancing_scheme", load_balancing_scheme)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "service", service)
        pulumi.set(__self__, "timeout", timeout)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if fail_open is not None:
            pulumi.set(__self__, "fail_open", fail_open)
        if forward_headers is not None:
            pulumi.set(__self__, "forward_headers", forward_headers)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if wire_format is not None:
            pulumi.set(__self__, "wire_format", wire_format)

    @property
    @pulumi.getter
    def authority(self) -> pulumi.Input[builtins.str]:
        """
        The :authority header in the gRPC request sent from Envoy to the extension service.
        """
        return pulumi.get(self, "authority")

    @authority.setter
    def authority(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "authority", value)

    @property
    @pulumi.getter(name="loadBalancingScheme")
    def load_balancing_scheme(self) -> pulumi.Input[builtins.str]:
        """
        All backend services and forwarding rules referenced by this extension must share the same load balancing scheme.
        For more information, refer to [Backend services overview](https://cloud.google.com/load-balancing/docs/backend-service).
        Possible values are: `INTERNAL_MANAGED`, `EXTERNAL_MANAGED`.
        """
        return pulumi.get(self, "load_balancing_scheme")

    @load_balancing_scheme.setter
    def load_balancing_scheme(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "load_balancing_scheme", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        The location of the resource.


        - - -
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def service(self) -> pulumi.Input[builtins.str]:
        """
        The reference to the service that runs the extension.
        To configure a callout extension, service must be a fully-qualified reference to a [backend service](https://cloud.google.com/compute/docs/reference/rest/v1/backendServices) in the format:
        https://www.googleapis.com/compute/v1/projects/{project}/regions/{region}/backendServices/{backendService} or https://www.googleapis.com/compute/v1/projects/{project}/global/backendServices/{backendService}.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "service", value)

    @property
    @pulumi.getter
    def timeout(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the timeout for each individual message on the stream. The timeout must be between 10-10000 milliseconds.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A human-readable description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="failOpen")
    def fail_open(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Determines how the proxy behaves if the call to the extension fails or times out.
        When set to TRUE, request or response processing continues without error. Any subsequent extensions in the extension chain are also executed. When set to FALSE or the default setting of FALSE is used, one of the following happens:
        * If response headers have not been delivered to the downstream client, a generic 500 error is returned to the client. The error response can be tailored by configuring a custom error response in the load balancer.
        * If response headers have been delivered, then the HTTP stream to the downstream client is reset.
        """
        return pulumi.get(self, "fail_open")

    @fail_open.setter
    def fail_open(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "fail_open", value)

    @property
    @pulumi.getter(name="forwardHeaders")
    def forward_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of the HTTP headers to forward to the extension (from the client). If omitted, all headers are sent. Each element is a string indicating the header name.
        """
        return pulumi.get(self, "forward_headers")

    @forward_headers.setter
    def forward_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "forward_headers", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Set of labels associated with the AuthzExtension resource.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The metadata provided here is included as part of the metadata_context (of type google.protobuf.Struct) in the ProcessingRequest message sent to the extension server. The metadata is available under the namespace com.google.authz_extension.<resourceName>. The following variables are supported in the metadata Struct:
        {forwarding_rule_id} - substituted with the forwarding rule's fully qualified resource name.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier. Name of the AuthzExtension resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="wireFormat")
    def wire_format(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The format of communication supported by the callout extension. Will be set to EXT_PROC_GRPC by the backend if no value is set.
        Possible values are: `WIRE_FORMAT_UNSPECIFIED`, `EXT_PROC_GRPC`.
        """
        return pulumi.get(self, "wire_format")

    @wire_format.setter
    def wire_format(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "wire_format", value)


@pulumi.input_type
class _AuthzExtensionState:
    def __init__(__self__, *,
                 authority: Optional[pulumi.Input[builtins.str]] = None,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 fail_open: Optional[pulumi.Input[builtins.bool]] = None,
                 forward_headers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 load_balancing_scheme: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 service: Optional[pulumi.Input[builtins.str]] = None,
                 timeout: Optional[pulumi.Input[builtins.str]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None,
                 wire_format: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering AuthzExtension resources.
        :param pulumi.Input[builtins.str] authority: The :authority header in the gRPC request sent from Envoy to the extension service.
        :param pulumi.Input[builtins.str] create_time: The timestamp when the resource was created.
        :param pulumi.Input[builtins.str] description: A human-readable description of the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.bool] fail_open: Determines how the proxy behaves if the call to the extension fails or times out.
               When set to TRUE, request or response processing continues without error. Any subsequent extensions in the extension chain are also executed. When set to FALSE or the default setting of FALSE is used, one of the following happens:
               * If response headers have not been delivered to the downstream client, a generic 500 error is returned to the client. The error response can be tailored by configuring a custom error response in the load balancer.
               * If response headers have been delivered, then the HTTP stream to the downstream client is reset.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] forward_headers: List of the HTTP headers to forward to the extension (from the client). If omitted, all headers are sent. Each element is a string indicating the header name.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Set of labels associated with the AuthzExtension resource.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] load_balancing_scheme: All backend services and forwarding rules referenced by this extension must share the same load balancing scheme.
               For more information, refer to [Backend services overview](https://cloud.google.com/load-balancing/docs/backend-service).
               Possible values are: `INTERNAL_MANAGED`, `EXTERNAL_MANAGED`.
        :param pulumi.Input[builtins.str] location: The location of the resource.
               
               
               - - -
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] metadata: The metadata provided here is included as part of the metadata_context (of type google.protobuf.Struct) in the ProcessingRequest message sent to the extension server. The metadata is available under the namespace com.google.authz_extension.<resourceName>. The following variables are supported in the metadata Struct:
               {forwarding_rule_id} - substituted with the forwarding rule's fully qualified resource name.
        :param pulumi.Input[builtins.str] name: Identifier. Name of the AuthzExtension resource.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.str] service: The reference to the service that runs the extension.
               To configure a callout extension, service must be a fully-qualified reference to a [backend service](https://cloud.google.com/compute/docs/reference/rest/v1/backendServices) in the format:
               https://www.googleapis.com/compute/v1/projects/{project}/regions/{region}/backendServices/{backendService} or https://www.googleapis.com/compute/v1/projects/{project}/global/backendServices/{backendService}.
        :param pulumi.Input[builtins.str] timeout: Specifies the timeout for each individual message on the stream. The timeout must be between 10-10000 milliseconds.
        :param pulumi.Input[builtins.str] update_time: The timestamp when the resource was updated.
        :param pulumi.Input[builtins.str] wire_format: The format of communication supported by the callout extension. Will be set to EXT_PROC_GRPC by the backend if no value is set.
               Possible values are: `WIRE_FORMAT_UNSPECIFIED`, `EXT_PROC_GRPC`.
        """
        if authority is not None:
            pulumi.set(__self__, "authority", authority)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if fail_open is not None:
            pulumi.set(__self__, "fail_open", fail_open)
        if forward_headers is not None:
            pulumi.set(__self__, "forward_headers", forward_headers)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if load_balancing_scheme is not None:
            pulumi.set(__self__, "load_balancing_scheme", load_balancing_scheme)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if service is not None:
            pulumi.set(__self__, "service", service)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if wire_format is not None:
            pulumi.set(__self__, "wire_format", wire_format)

    @property
    @pulumi.getter
    def authority(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The :authority header in the gRPC request sent from Envoy to the extension service.
        """
        return pulumi.get(self, "authority")

    @authority.setter
    def authority(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authority", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The timestamp when the resource was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A human-readable description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter(name="failOpen")
    def fail_open(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Determines how the proxy behaves if the call to the extension fails or times out.
        When set to TRUE, request or response processing continues without error. Any subsequent extensions in the extension chain are also executed. When set to FALSE or the default setting of FALSE is used, one of the following happens:
        * If response headers have not been delivered to the downstream client, a generic 500 error is returned to the client. The error response can be tailored by configuring a custom error response in the load balancer.
        * If response headers have been delivered, then the HTTP stream to the downstream client is reset.
        """
        return pulumi.get(self, "fail_open")

    @fail_open.setter
    def fail_open(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "fail_open", value)

    @property
    @pulumi.getter(name="forwardHeaders")
    def forward_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of the HTTP headers to forward to the extension (from the client). If omitted, all headers are sent. Each element is a string indicating the header name.
        """
        return pulumi.get(self, "forward_headers")

    @forward_headers.setter
    def forward_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "forward_headers", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Set of labels associated with the AuthzExtension resource.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="loadBalancingScheme")
    def load_balancing_scheme(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        All backend services and forwarding rules referenced by this extension must share the same load balancing scheme.
        For more information, refer to [Backend services overview](https://cloud.google.com/load-balancing/docs/backend-service).
        Possible values are: `INTERNAL_MANAGED`, `EXTERNAL_MANAGED`.
        """
        return pulumi.get(self, "load_balancing_scheme")

    @load_balancing_scheme.setter
    def load_balancing_scheme(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "load_balancing_scheme", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location of the resource.


        - - -
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The metadata provided here is included as part of the metadata_context (of type google.protobuf.Struct) in the ProcessingRequest message sent to the extension server. The metadata is available under the namespace com.google.authz_extension.<resourceName>. The following variables are supported in the metadata Struct:
        {forwarding_rule_id} - substituted with the forwarding rule's fully qualified resource name.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier. Name of the AuthzExtension resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter
    def service(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The reference to the service that runs the extension.
        To configure a callout extension, service must be a fully-qualified reference to a [backend service](https://cloud.google.com/compute/docs/reference/rest/v1/backendServices) in the format:
        https://www.googleapis.com/compute/v1/projects/{project}/regions/{region}/backendServices/{backendService} or https://www.googleapis.com/compute/v1/projects/{project}/global/backendServices/{backendService}.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the timeout for each individual message on the stream. The timeout must be between 10-10000 milliseconds.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The timestamp when the resource was updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)

    @property
    @pulumi.getter(name="wireFormat")
    def wire_format(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The format of communication supported by the callout extension. Will be set to EXT_PROC_GRPC by the backend if no value is set.
        Possible values are: `WIRE_FORMAT_UNSPECIFIED`, `EXT_PROC_GRPC`.
        """
        return pulumi.get(self, "wire_format")

    @wire_format.setter
    def wire_format(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "wire_format", value)


@pulumi.type_token("gcp:networkservices/authzExtension:AuthzExtension")
class AuthzExtension(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authority: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 fail_open: Optional[pulumi.Input[builtins.bool]] = None,
                 forward_headers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 load_balancing_scheme: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 service: Optional[pulumi.Input[builtins.str]] = None,
                 timeout: Optional[pulumi.Input[builtins.str]] = None,
                 wire_format: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        AuthzExtension is a resource that allows traffic forwarding to a callout backend service to make an authorization decision.

        To get more information about AuthzExtension, see:

        * [API documentation](https://cloud.google.com/service-extensions/docs/reference/rest/v1beta1/projects.locations.authzExtensions)

        ## Example Usage

        ### Network Services Authz Extension Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.RegionBackendService("default",
            name="authz-service",
            project="my-project-name",
            region="us-west1",
            protocol="HTTP2",
            load_balancing_scheme="INTERNAL_MANAGED",
            port_name="grpc")
        default_authz_extension = gcp.networkservices.AuthzExtension("default",
            name="my-authz-ext",
            project="my-project-name",
            location="us-west1",
            description="my description",
            load_balancing_scheme="INTERNAL_MANAGED",
            authority="ext11.com",
            service=default.self_link,
            timeout="0.1s",
            fail_open=False,
            forward_headers=["Authorization"])
        ```

        ## Import

        AuthzExtension can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/authzExtensions/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, AuthzExtension can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:networkservices/authzExtension:AuthzExtension default projects/{{project}}/locations/{{location}}/authzExtensions/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networkservices/authzExtension:AuthzExtension default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networkservices/authzExtension:AuthzExtension default {{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networkservices/authzExtension:AuthzExtension default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] authority: The :authority header in the gRPC request sent from Envoy to the extension service.
        :param pulumi.Input[builtins.str] description: A human-readable description of the resource.
        :param pulumi.Input[builtins.bool] fail_open: Determines how the proxy behaves if the call to the extension fails or times out.
               When set to TRUE, request or response processing continues without error. Any subsequent extensions in the extension chain are also executed. When set to FALSE or the default setting of FALSE is used, one of the following happens:
               * If response headers have not been delivered to the downstream client, a generic 500 error is returned to the client. The error response can be tailored by configuring a custom error response in the load balancer.
               * If response headers have been delivered, then the HTTP stream to the downstream client is reset.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] forward_headers: List of the HTTP headers to forward to the extension (from the client). If omitted, all headers are sent. Each element is a string indicating the header name.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Set of labels associated with the AuthzExtension resource.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] load_balancing_scheme: All backend services and forwarding rules referenced by this extension must share the same load balancing scheme.
               For more information, refer to [Backend services overview](https://cloud.google.com/load-balancing/docs/backend-service).
               Possible values are: `INTERNAL_MANAGED`, `EXTERNAL_MANAGED`.
        :param pulumi.Input[builtins.str] location: The location of the resource.
               
               
               - - -
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] metadata: The metadata provided here is included as part of the metadata_context (of type google.protobuf.Struct) in the ProcessingRequest message sent to the extension server. The metadata is available under the namespace com.google.authz_extension.<resourceName>. The following variables are supported in the metadata Struct:
               {forwarding_rule_id} - substituted with the forwarding rule's fully qualified resource name.
        :param pulumi.Input[builtins.str] name: Identifier. Name of the AuthzExtension resource.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] service: The reference to the service that runs the extension.
               To configure a callout extension, service must be a fully-qualified reference to a [backend service](https://cloud.google.com/compute/docs/reference/rest/v1/backendServices) in the format:
               https://www.googleapis.com/compute/v1/projects/{project}/regions/{region}/backendServices/{backendService} or https://www.googleapis.com/compute/v1/projects/{project}/global/backendServices/{backendService}.
        :param pulumi.Input[builtins.str] timeout: Specifies the timeout for each individual message on the stream. The timeout must be between 10-10000 milliseconds.
        :param pulumi.Input[builtins.str] wire_format: The format of communication supported by the callout extension. Will be set to EXT_PROC_GRPC by the backend if no value is set.
               Possible values are: `WIRE_FORMAT_UNSPECIFIED`, `EXT_PROC_GRPC`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AuthzExtensionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        AuthzExtension is a resource that allows traffic forwarding to a callout backend service to make an authorization decision.

        To get more information about AuthzExtension, see:

        * [API documentation](https://cloud.google.com/service-extensions/docs/reference/rest/v1beta1/projects.locations.authzExtensions)

        ## Example Usage

        ### Network Services Authz Extension Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.RegionBackendService("default",
            name="authz-service",
            project="my-project-name",
            region="us-west1",
            protocol="HTTP2",
            load_balancing_scheme="INTERNAL_MANAGED",
            port_name="grpc")
        default_authz_extension = gcp.networkservices.AuthzExtension("default",
            name="my-authz-ext",
            project="my-project-name",
            location="us-west1",
            description="my description",
            load_balancing_scheme="INTERNAL_MANAGED",
            authority="ext11.com",
            service=default.self_link,
            timeout="0.1s",
            fail_open=False,
            forward_headers=["Authorization"])
        ```

        ## Import

        AuthzExtension can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/authzExtensions/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, AuthzExtension can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:networkservices/authzExtension:AuthzExtension default projects/{{project}}/locations/{{location}}/authzExtensions/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networkservices/authzExtension:AuthzExtension default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networkservices/authzExtension:AuthzExtension default {{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networkservices/authzExtension:AuthzExtension default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param AuthzExtensionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AuthzExtensionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authority: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 fail_open: Optional[pulumi.Input[builtins.bool]] = None,
                 forward_headers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 load_balancing_scheme: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 service: Optional[pulumi.Input[builtins.str]] = None,
                 timeout: Optional[pulumi.Input[builtins.str]] = None,
                 wire_format: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AuthzExtensionArgs.__new__(AuthzExtensionArgs)

            if authority is None and not opts.urn:
                raise TypeError("Missing required property 'authority'")
            __props__.__dict__["authority"] = authority
            __props__.__dict__["description"] = description
            __props__.__dict__["fail_open"] = fail_open
            __props__.__dict__["forward_headers"] = forward_headers
            __props__.__dict__["labels"] = labels
            if load_balancing_scheme is None and not opts.urn:
                raise TypeError("Missing required property 'load_balancing_scheme'")
            __props__.__dict__["load_balancing_scheme"] = load_balancing_scheme
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["metadata"] = metadata
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            if service is None and not opts.urn:
                raise TypeError("Missing required property 'service'")
            __props__.__dict__["service"] = service
            if timeout is None and not opts.urn:
                raise TypeError("Missing required property 'timeout'")
            __props__.__dict__["timeout"] = timeout
            __props__.__dict__["wire_format"] = wire_format
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(AuthzExtension, __self__).__init__(
            'gcp:networkservices/authzExtension:AuthzExtension',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            authority: Optional[pulumi.Input[builtins.str]] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            fail_open: Optional[pulumi.Input[builtins.bool]] = None,
            forward_headers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            load_balancing_scheme: Optional[pulumi.Input[builtins.str]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            service: Optional[pulumi.Input[builtins.str]] = None,
            timeout: Optional[pulumi.Input[builtins.str]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None,
            wire_format: Optional[pulumi.Input[builtins.str]] = None) -> 'AuthzExtension':
        """
        Get an existing AuthzExtension resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] authority: The :authority header in the gRPC request sent from Envoy to the extension service.
        :param pulumi.Input[builtins.str] create_time: The timestamp when the resource was created.
        :param pulumi.Input[builtins.str] description: A human-readable description of the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.bool] fail_open: Determines how the proxy behaves if the call to the extension fails or times out.
               When set to TRUE, request or response processing continues without error. Any subsequent extensions in the extension chain are also executed. When set to FALSE or the default setting of FALSE is used, one of the following happens:
               * If response headers have not been delivered to the downstream client, a generic 500 error is returned to the client. The error response can be tailored by configuring a custom error response in the load balancer.
               * If response headers have been delivered, then the HTTP stream to the downstream client is reset.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] forward_headers: List of the HTTP headers to forward to the extension (from the client). If omitted, all headers are sent. Each element is a string indicating the header name.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Set of labels associated with the AuthzExtension resource.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] load_balancing_scheme: All backend services and forwarding rules referenced by this extension must share the same load balancing scheme.
               For more information, refer to [Backend services overview](https://cloud.google.com/load-balancing/docs/backend-service).
               Possible values are: `INTERNAL_MANAGED`, `EXTERNAL_MANAGED`.
        :param pulumi.Input[builtins.str] location: The location of the resource.
               
               
               - - -
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] metadata: The metadata provided here is included as part of the metadata_context (of type google.protobuf.Struct) in the ProcessingRequest message sent to the extension server. The metadata is available under the namespace com.google.authz_extension.<resourceName>. The following variables are supported in the metadata Struct:
               {forwarding_rule_id} - substituted with the forwarding rule's fully qualified resource name.
        :param pulumi.Input[builtins.str] name: Identifier. Name of the AuthzExtension resource.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.str] service: The reference to the service that runs the extension.
               To configure a callout extension, service must be a fully-qualified reference to a [backend service](https://cloud.google.com/compute/docs/reference/rest/v1/backendServices) in the format:
               https://www.googleapis.com/compute/v1/projects/{project}/regions/{region}/backendServices/{backendService} or https://www.googleapis.com/compute/v1/projects/{project}/global/backendServices/{backendService}.
        :param pulumi.Input[builtins.str] timeout: Specifies the timeout for each individual message on the stream. The timeout must be between 10-10000 milliseconds.
        :param pulumi.Input[builtins.str] update_time: The timestamp when the resource was updated.
        :param pulumi.Input[builtins.str] wire_format: The format of communication supported by the callout extension. Will be set to EXT_PROC_GRPC by the backend if no value is set.
               Possible values are: `WIRE_FORMAT_UNSPECIFIED`, `EXT_PROC_GRPC`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AuthzExtensionState.__new__(_AuthzExtensionState)

        __props__.__dict__["authority"] = authority
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["fail_open"] = fail_open
        __props__.__dict__["forward_headers"] = forward_headers
        __props__.__dict__["labels"] = labels
        __props__.__dict__["load_balancing_scheme"] = load_balancing_scheme
        __props__.__dict__["location"] = location
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["service"] = service
        __props__.__dict__["timeout"] = timeout
        __props__.__dict__["update_time"] = update_time
        __props__.__dict__["wire_format"] = wire_format
        return AuthzExtension(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def authority(self) -> pulumi.Output[builtins.str]:
        """
        The :authority header in the gRPC request sent from Envoy to the extension service.
        """
        return pulumi.get(self, "authority")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        The timestamp when the resource was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A human-readable description of the resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter(name="failOpen")
    def fail_open(self) -> pulumi.Output[builtins.bool]:
        """
        Determines how the proxy behaves if the call to the extension fails or times out.
        When set to TRUE, request or response processing continues without error. Any subsequent extensions in the extension chain are also executed. When set to FALSE or the default setting of FALSE is used, one of the following happens:
        * If response headers have not been delivered to the downstream client, a generic 500 error is returned to the client. The error response can be tailored by configuring a custom error response in the load balancer.
        * If response headers have been delivered, then the HTTP stream to the downstream client is reset.
        """
        return pulumi.get(self, "fail_open")

    @property
    @pulumi.getter(name="forwardHeaders")
    def forward_headers(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        List of the HTTP headers to forward to the extension (from the client). If omitted, all headers are sent. Each element is a string indicating the header name.
        """
        return pulumi.get(self, "forward_headers")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Set of labels associated with the AuthzExtension resource.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="loadBalancingScheme")
    def load_balancing_scheme(self) -> pulumi.Output[builtins.str]:
        """
        All backend services and forwarding rules referenced by this extension must share the same load balancing scheme.
        For more information, refer to [Backend services overview](https://cloud.google.com/load-balancing/docs/backend-service).
        Possible values are: `INTERNAL_MANAGED`, `EXTERNAL_MANAGED`.
        """
        return pulumi.get(self, "load_balancing_scheme")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The location of the resource.


        - - -
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        The metadata provided here is included as part of the metadata_context (of type google.protobuf.Struct) in the ProcessingRequest message sent to the extension server. The metadata is available under the namespace com.google.authz_extension.<resourceName>. The following variables are supported in the metadata Struct:
        {forwarding_rule_id} - substituted with the forwarding rule's fully qualified resource name.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Identifier. Name of the AuthzExtension resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter
    def service(self) -> pulumi.Output[builtins.str]:
        """
        The reference to the service that runs the extension.
        To configure a callout extension, service must be a fully-qualified reference to a [backend service](https://cloud.google.com/compute/docs/reference/rest/v1/backendServices) in the format:
        https://www.googleapis.com/compute/v1/projects/{project}/regions/{region}/backendServices/{backendService} or https://www.googleapis.com/compute/v1/projects/{project}/global/backendServices/{backendService}.
        """
        return pulumi.get(self, "service")

    @property
    @pulumi.getter
    def timeout(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the timeout for each individual message on the stream. The timeout must be between 10-10000 milliseconds.
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        The timestamp when the resource was updated.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter(name="wireFormat")
    def wire_format(self) -> pulumi.Output[builtins.str]:
        """
        The format of communication supported by the callout extension. Will be set to EXT_PROC_GRPC by the backend if no value is set.
        Possible values are: `WIRE_FORMAT_UNSPECIFIED`, `EXT_PROC_GRPC`.
        """
        return pulumi.get(self, "wire_format")

