# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EndpointPolicyArgs', 'EndpointPolicy']

@pulumi.input_type
class EndpointPolicyArgs:
    def __init__(__self__, *,
                 endpoint_matcher: pulumi.Input['EndpointPolicyEndpointMatcherArgs'],
                 type: pulumi.Input[builtins.str],
                 authorization_policy: Optional[pulumi.Input[builtins.str]] = None,
                 client_tls_policy: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 server_tls_policy: Optional[pulumi.Input[builtins.str]] = None,
                 traffic_port_selector: Optional[pulumi.Input['EndpointPolicyTrafficPortSelectorArgs']] = None):
        """
        The set of arguments for constructing a EndpointPolicy resource.
        :param pulumi.Input['EndpointPolicyEndpointMatcherArgs'] endpoint_matcher: Required. A matcher that selects endpoints to which the policies should be applied.
               Structure is documented below.
        :param pulumi.Input[builtins.str] type: The type of endpoint policy. This is primarily used to validate the configuration.
               Possible values are: `SIDECAR_PROXY`, `GRPC_SERVER`.
        :param pulumi.Input[builtins.str] authorization_policy: This field specifies the URL of AuthorizationPolicy resource that applies authorization policies to the inbound traffic
               at the matched endpoints.
        :param pulumi.Input[builtins.str] client_tls_policy: A URL referring to a ClientTlsPolicy resource. ClientTlsPolicy can be set to specify the authentication for traffic from
               the proxy to the actual endpoints.
        :param pulumi.Input[builtins.str] description: A free-text description of the resource. Max length 1024 characters.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Set of label tags associated with the TcpRoute resource. **Note**: This field is non-authoritative, and will only manage
               the labels present in your configuration. Please refer to the field 'effective_labels' for all of the labels present on
               the resource.
        :param pulumi.Input[builtins.str] name: Name of the EndpointPolicy resource.
        :param pulumi.Input[builtins.str] server_tls_policy: A URL referring to ServerTlsPolicy resource. ServerTlsPolicy is used to determine the authentication policy to be
               applied to terminate the inbound traffic at the identified backends.
        :param pulumi.Input['EndpointPolicyTrafficPortSelectorArgs'] traffic_port_selector: Port selector for the (matched) endpoints. If no port selector is provided, the matched config is applied to all ports.
        """
        pulumi.set(__self__, "endpoint_matcher", endpoint_matcher)
        pulumi.set(__self__, "type", type)
        if authorization_policy is not None:
            pulumi.set(__self__, "authorization_policy", authorization_policy)
        if client_tls_policy is not None:
            pulumi.set(__self__, "client_tls_policy", client_tls_policy)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if server_tls_policy is not None:
            pulumi.set(__self__, "server_tls_policy", server_tls_policy)
        if traffic_port_selector is not None:
            pulumi.set(__self__, "traffic_port_selector", traffic_port_selector)

    @property
    @pulumi.getter(name="endpointMatcher")
    def endpoint_matcher(self) -> pulumi.Input['EndpointPolicyEndpointMatcherArgs']:
        """
        Required. A matcher that selects endpoints to which the policies should be applied.
        Structure is documented below.
        """
        return pulumi.get(self, "endpoint_matcher")

    @endpoint_matcher.setter
    def endpoint_matcher(self, value: pulumi.Input['EndpointPolicyEndpointMatcherArgs']):
        pulumi.set(self, "endpoint_matcher", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        The type of endpoint policy. This is primarily used to validate the configuration.
        Possible values are: `SIDECAR_PROXY`, `GRPC_SERVER`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="authorizationPolicy")
    def authorization_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        This field specifies the URL of AuthorizationPolicy resource that applies authorization policies to the inbound traffic
        at the matched endpoints.
        """
        return pulumi.get(self, "authorization_policy")

    @authorization_policy.setter
    def authorization_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authorization_policy", value)

    @property
    @pulumi.getter(name="clientTlsPolicy")
    def client_tls_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A URL referring to a ClientTlsPolicy resource. ClientTlsPolicy can be set to specify the authentication for traffic from
        the proxy to the actual endpoints.
        """
        return pulumi.get(self, "client_tls_policy")

    @client_tls_policy.setter
    def client_tls_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_tls_policy", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A free-text description of the resource. Max length 1024 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Set of label tags associated with the TcpRoute resource. **Note**: This field is non-authoritative, and will only manage
        the labels present in your configuration. Please refer to the field 'effective_labels' for all of the labels present on
        the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the EndpointPolicy resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="serverTlsPolicy")
    def server_tls_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A URL referring to ServerTlsPolicy resource. ServerTlsPolicy is used to determine the authentication policy to be
        applied to terminate the inbound traffic at the identified backends.
        """
        return pulumi.get(self, "server_tls_policy")

    @server_tls_policy.setter
    def server_tls_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "server_tls_policy", value)

    @property
    @pulumi.getter(name="trafficPortSelector")
    def traffic_port_selector(self) -> Optional[pulumi.Input['EndpointPolicyTrafficPortSelectorArgs']]:
        """
        Port selector for the (matched) endpoints. If no port selector is provided, the matched config is applied to all ports.
        """
        return pulumi.get(self, "traffic_port_selector")

    @traffic_port_selector.setter
    def traffic_port_selector(self, value: Optional[pulumi.Input['EndpointPolicyTrafficPortSelectorArgs']]):
        pulumi.set(self, "traffic_port_selector", value)


@pulumi.input_type
class _EndpointPolicyState:
    def __init__(__self__, *,
                 authorization_policy: Optional[pulumi.Input[builtins.str]] = None,
                 client_tls_policy: Optional[pulumi.Input[builtins.str]] = None,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 endpoint_matcher: Optional[pulumi.Input['EndpointPolicyEndpointMatcherArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 server_tls_policy: Optional[pulumi.Input[builtins.str]] = None,
                 traffic_port_selector: Optional[pulumi.Input['EndpointPolicyTrafficPortSelectorArgs']] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering EndpointPolicy resources.
        :param pulumi.Input[builtins.str] authorization_policy: This field specifies the URL of AuthorizationPolicy resource that applies authorization policies to the inbound traffic
               at the matched endpoints.
        :param pulumi.Input[builtins.str] client_tls_policy: A URL referring to a ClientTlsPolicy resource. ClientTlsPolicy can be set to specify the authentication for traffic from
               the proxy to the actual endpoints.
        :param pulumi.Input[builtins.str] create_time: Time the TcpRoute was created in UTC.
        :param pulumi.Input[builtins.str] description: A free-text description of the resource. Max length 1024 characters.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input['EndpointPolicyEndpointMatcherArgs'] endpoint_matcher: Required. A matcher that selects endpoints to which the policies should be applied.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Set of label tags associated with the TcpRoute resource. **Note**: This field is non-authoritative, and will only manage
               the labels present in your configuration. Please refer to the field 'effective_labels' for all of the labels present on
               the resource.
        :param pulumi.Input[builtins.str] name: Name of the EndpointPolicy resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.str] server_tls_policy: A URL referring to ServerTlsPolicy resource. ServerTlsPolicy is used to determine the authentication policy to be
               applied to terminate the inbound traffic at the identified backends.
        :param pulumi.Input['EndpointPolicyTrafficPortSelectorArgs'] traffic_port_selector: Port selector for the (matched) endpoints. If no port selector is provided, the matched config is applied to all ports.
        :param pulumi.Input[builtins.str] type: The type of endpoint policy. This is primarily used to validate the configuration.
               Possible values are: `SIDECAR_PROXY`, `GRPC_SERVER`.
        :param pulumi.Input[builtins.str] update_time: Time the TcpRoute was updated in UTC.
        """
        if authorization_policy is not None:
            pulumi.set(__self__, "authorization_policy", authorization_policy)
        if client_tls_policy is not None:
            pulumi.set(__self__, "client_tls_policy", client_tls_policy)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if endpoint_matcher is not None:
            pulumi.set(__self__, "endpoint_matcher", endpoint_matcher)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if server_tls_policy is not None:
            pulumi.set(__self__, "server_tls_policy", server_tls_policy)
        if traffic_port_selector is not None:
            pulumi.set(__self__, "traffic_port_selector", traffic_port_selector)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="authorizationPolicy")
    def authorization_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        This field specifies the URL of AuthorizationPolicy resource that applies authorization policies to the inbound traffic
        at the matched endpoints.
        """
        return pulumi.get(self, "authorization_policy")

    @authorization_policy.setter
    def authorization_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authorization_policy", value)

    @property
    @pulumi.getter(name="clientTlsPolicy")
    def client_tls_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A URL referring to a ClientTlsPolicy resource. ClientTlsPolicy can be set to specify the authentication for traffic from
        the proxy to the actual endpoints.
        """
        return pulumi.get(self, "client_tls_policy")

    @client_tls_policy.setter
    def client_tls_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_tls_policy", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Time the TcpRoute was created in UTC.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A free-text description of the resource. Max length 1024 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter(name="endpointMatcher")
    def endpoint_matcher(self) -> Optional[pulumi.Input['EndpointPolicyEndpointMatcherArgs']]:
        """
        Required. A matcher that selects endpoints to which the policies should be applied.
        Structure is documented below.
        """
        return pulumi.get(self, "endpoint_matcher")

    @endpoint_matcher.setter
    def endpoint_matcher(self, value: Optional[pulumi.Input['EndpointPolicyEndpointMatcherArgs']]):
        pulumi.set(self, "endpoint_matcher", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Set of label tags associated with the TcpRoute resource. **Note**: This field is non-authoritative, and will only manage
        the labels present in your configuration. Please refer to the field 'effective_labels' for all of the labels present on
        the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the EndpointPolicy resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter(name="serverTlsPolicy")
    def server_tls_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A URL referring to ServerTlsPolicy resource. ServerTlsPolicy is used to determine the authentication policy to be
        applied to terminate the inbound traffic at the identified backends.
        """
        return pulumi.get(self, "server_tls_policy")

    @server_tls_policy.setter
    def server_tls_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "server_tls_policy", value)

    @property
    @pulumi.getter(name="trafficPortSelector")
    def traffic_port_selector(self) -> Optional[pulumi.Input['EndpointPolicyTrafficPortSelectorArgs']]:
        """
        Port selector for the (matched) endpoints. If no port selector is provided, the matched config is applied to all ports.
        """
        return pulumi.get(self, "traffic_port_selector")

    @traffic_port_selector.setter
    def traffic_port_selector(self, value: Optional[pulumi.Input['EndpointPolicyTrafficPortSelectorArgs']]):
        pulumi.set(self, "traffic_port_selector", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of endpoint policy. This is primarily used to validate the configuration.
        Possible values are: `SIDECAR_PROXY`, `GRPC_SERVER`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Time the TcpRoute was updated in UTC.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:networkservices/endpointPolicy:EndpointPolicy")
class EndpointPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authorization_policy: Optional[pulumi.Input[builtins.str]] = None,
                 client_tls_policy: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint_matcher: Optional[pulumi.Input[Union['EndpointPolicyEndpointMatcherArgs', 'EndpointPolicyEndpointMatcherArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 server_tls_policy: Optional[pulumi.Input[builtins.str]] = None,
                 traffic_port_selector: Optional[pulumi.Input[Union['EndpointPolicyTrafficPortSelectorArgs', 'EndpointPolicyTrafficPortSelectorArgsDict']]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        EndpointPolicy is a resource that helps apply desired configuration on the endpoints that match specific criteria.

        To get more information about EndpointPolicy, see:

        * [API documentation](https://cloud.google.com/traffic-director/docs/reference/network-services/rest/v1beta1/projects.locations.endpointPolicies)

        ## Example Usage

        ### Network Services Endpoint Policy Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.networkservices.EndpointPolicy("default",
            name="my-endpoint-policy",
            labels={
                "foo": "bar",
            },
            description="my description",
            type="SIDECAR_PROXY",
            traffic_port_selector={
                "ports": ["8081"],
            },
            endpoint_matcher={
                "metadata_label_matcher": {
                    "metadata_label_match_criteria": "MATCH_ANY",
                    "metadata_labels": [{
                        "label_name": "foo",
                        "label_value": "bar",
                    }],
                },
            })
        ```
        ### Network Services Endpoint Policy Empty Match

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.networkservices.EndpointPolicy("default",
            name="my-endpoint-policy",
            labels={
                "foo": "bar",
            },
            description="my description",
            type="SIDECAR_PROXY",
            traffic_port_selector={
                "ports": ["8081"],
            },
            endpoint_matcher={
                "metadata_label_matcher": {
                    "metadata_label_match_criteria": "MATCH_ANY",
                },
            })
        ```

        ## Import

        EndpointPolicy can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/global/endpointPolicies/{{name}}`

        * `{{project}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, EndpointPolicy can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:networkservices/endpointPolicy:EndpointPolicy default projects/{{project}}/locations/global/endpointPolicies/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networkservices/endpointPolicy:EndpointPolicy default {{project}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networkservices/endpointPolicy:EndpointPolicy default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] authorization_policy: This field specifies the URL of AuthorizationPolicy resource that applies authorization policies to the inbound traffic
               at the matched endpoints.
        :param pulumi.Input[builtins.str] client_tls_policy: A URL referring to a ClientTlsPolicy resource. ClientTlsPolicy can be set to specify the authentication for traffic from
               the proxy to the actual endpoints.
        :param pulumi.Input[builtins.str] description: A free-text description of the resource. Max length 1024 characters.
        :param pulumi.Input[Union['EndpointPolicyEndpointMatcherArgs', 'EndpointPolicyEndpointMatcherArgsDict']] endpoint_matcher: Required. A matcher that selects endpoints to which the policies should be applied.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Set of label tags associated with the TcpRoute resource. **Note**: This field is non-authoritative, and will only manage
               the labels present in your configuration. Please refer to the field 'effective_labels' for all of the labels present on
               the resource.
        :param pulumi.Input[builtins.str] name: Name of the EndpointPolicy resource.
        :param pulumi.Input[builtins.str] server_tls_policy: A URL referring to ServerTlsPolicy resource. ServerTlsPolicy is used to determine the authentication policy to be
               applied to terminate the inbound traffic at the identified backends.
        :param pulumi.Input[Union['EndpointPolicyTrafficPortSelectorArgs', 'EndpointPolicyTrafficPortSelectorArgsDict']] traffic_port_selector: Port selector for the (matched) endpoints. If no port selector is provided, the matched config is applied to all ports.
        :param pulumi.Input[builtins.str] type: The type of endpoint policy. This is primarily used to validate the configuration.
               Possible values are: `SIDECAR_PROXY`, `GRPC_SERVER`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EndpointPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        EndpointPolicy is a resource that helps apply desired configuration on the endpoints that match specific criteria.

        To get more information about EndpointPolicy, see:

        * [API documentation](https://cloud.google.com/traffic-director/docs/reference/network-services/rest/v1beta1/projects.locations.endpointPolicies)

        ## Example Usage

        ### Network Services Endpoint Policy Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.networkservices.EndpointPolicy("default",
            name="my-endpoint-policy",
            labels={
                "foo": "bar",
            },
            description="my description",
            type="SIDECAR_PROXY",
            traffic_port_selector={
                "ports": ["8081"],
            },
            endpoint_matcher={
                "metadata_label_matcher": {
                    "metadata_label_match_criteria": "MATCH_ANY",
                    "metadata_labels": [{
                        "label_name": "foo",
                        "label_value": "bar",
                    }],
                },
            })
        ```
        ### Network Services Endpoint Policy Empty Match

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.networkservices.EndpointPolicy("default",
            name="my-endpoint-policy",
            labels={
                "foo": "bar",
            },
            description="my description",
            type="SIDECAR_PROXY",
            traffic_port_selector={
                "ports": ["8081"],
            },
            endpoint_matcher={
                "metadata_label_matcher": {
                    "metadata_label_match_criteria": "MATCH_ANY",
                },
            })
        ```

        ## Import

        EndpointPolicy can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/global/endpointPolicies/{{name}}`

        * `{{project}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, EndpointPolicy can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:networkservices/endpointPolicy:EndpointPolicy default projects/{{project}}/locations/global/endpointPolicies/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networkservices/endpointPolicy:EndpointPolicy default {{project}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networkservices/endpointPolicy:EndpointPolicy default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param EndpointPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EndpointPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authorization_policy: Optional[pulumi.Input[builtins.str]] = None,
                 client_tls_policy: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint_matcher: Optional[pulumi.Input[Union['EndpointPolicyEndpointMatcherArgs', 'EndpointPolicyEndpointMatcherArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 server_tls_policy: Optional[pulumi.Input[builtins.str]] = None,
                 traffic_port_selector: Optional[pulumi.Input[Union['EndpointPolicyTrafficPortSelectorArgs', 'EndpointPolicyTrafficPortSelectorArgsDict']]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EndpointPolicyArgs.__new__(EndpointPolicyArgs)

            __props__.__dict__["authorization_policy"] = authorization_policy
            __props__.__dict__["client_tls_policy"] = client_tls_policy
            __props__.__dict__["description"] = description
            if endpoint_matcher is None and not opts.urn:
                raise TypeError("Missing required property 'endpoint_matcher'")
            __props__.__dict__["endpoint_matcher"] = endpoint_matcher
            __props__.__dict__["labels"] = labels
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["server_tls_policy"] = server_tls_policy
            __props__.__dict__["traffic_port_selector"] = traffic_port_selector
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(EndpointPolicy, __self__).__init__(
            'gcp:networkservices/endpointPolicy:EndpointPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            authorization_policy: Optional[pulumi.Input[builtins.str]] = None,
            client_tls_policy: Optional[pulumi.Input[builtins.str]] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            endpoint_matcher: Optional[pulumi.Input[Union['EndpointPolicyEndpointMatcherArgs', 'EndpointPolicyEndpointMatcherArgsDict']]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            server_tls_policy: Optional[pulumi.Input[builtins.str]] = None,
            traffic_port_selector: Optional[pulumi.Input[Union['EndpointPolicyTrafficPortSelectorArgs', 'EndpointPolicyTrafficPortSelectorArgsDict']]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None) -> 'EndpointPolicy':
        """
        Get an existing EndpointPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] authorization_policy: This field specifies the URL of AuthorizationPolicy resource that applies authorization policies to the inbound traffic
               at the matched endpoints.
        :param pulumi.Input[builtins.str] client_tls_policy: A URL referring to a ClientTlsPolicy resource. ClientTlsPolicy can be set to specify the authentication for traffic from
               the proxy to the actual endpoints.
        :param pulumi.Input[builtins.str] create_time: Time the TcpRoute was created in UTC.
        :param pulumi.Input[builtins.str] description: A free-text description of the resource. Max length 1024 characters.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Union['EndpointPolicyEndpointMatcherArgs', 'EndpointPolicyEndpointMatcherArgsDict']] endpoint_matcher: Required. A matcher that selects endpoints to which the policies should be applied.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Set of label tags associated with the TcpRoute resource. **Note**: This field is non-authoritative, and will only manage
               the labels present in your configuration. Please refer to the field 'effective_labels' for all of the labels present on
               the resource.
        :param pulumi.Input[builtins.str] name: Name of the EndpointPolicy resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.str] server_tls_policy: A URL referring to ServerTlsPolicy resource. ServerTlsPolicy is used to determine the authentication policy to be
               applied to terminate the inbound traffic at the identified backends.
        :param pulumi.Input[Union['EndpointPolicyTrafficPortSelectorArgs', 'EndpointPolicyTrafficPortSelectorArgsDict']] traffic_port_selector: Port selector for the (matched) endpoints. If no port selector is provided, the matched config is applied to all ports.
        :param pulumi.Input[builtins.str] type: The type of endpoint policy. This is primarily used to validate the configuration.
               Possible values are: `SIDECAR_PROXY`, `GRPC_SERVER`.
        :param pulumi.Input[builtins.str] update_time: Time the TcpRoute was updated in UTC.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EndpointPolicyState.__new__(_EndpointPolicyState)

        __props__.__dict__["authorization_policy"] = authorization_policy
        __props__.__dict__["client_tls_policy"] = client_tls_policy
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["endpoint_matcher"] = endpoint_matcher
        __props__.__dict__["labels"] = labels
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["server_tls_policy"] = server_tls_policy
        __props__.__dict__["traffic_port_selector"] = traffic_port_selector
        __props__.__dict__["type"] = type
        __props__.__dict__["update_time"] = update_time
        return EndpointPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="authorizationPolicy")
    def authorization_policy(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        This field specifies the URL of AuthorizationPolicy resource that applies authorization policies to the inbound traffic
        at the matched endpoints.
        """
        return pulumi.get(self, "authorization_policy")

    @property
    @pulumi.getter(name="clientTlsPolicy")
    def client_tls_policy(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A URL referring to a ClientTlsPolicy resource. ClientTlsPolicy can be set to specify the authentication for traffic from
        the proxy to the actual endpoints.
        """
        return pulumi.get(self, "client_tls_policy")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        Time the TcpRoute was created in UTC.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A free-text description of the resource. Max length 1024 characters.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter(name="endpointMatcher")
    def endpoint_matcher(self) -> pulumi.Output['outputs.EndpointPolicyEndpointMatcher']:
        """
        Required. A matcher that selects endpoints to which the policies should be applied.
        Structure is documented below.
        """
        return pulumi.get(self, "endpoint_matcher")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Set of label tags associated with the TcpRoute resource. **Note**: This field is non-authoritative, and will only manage
        the labels present in your configuration. Please refer to the field 'effective_labels' for all of the labels present on
        the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the EndpointPolicy resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter(name="serverTlsPolicy")
    def server_tls_policy(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A URL referring to ServerTlsPolicy resource. ServerTlsPolicy is used to determine the authentication policy to be
        applied to terminate the inbound traffic at the identified backends.
        """
        return pulumi.get(self, "server_tls_policy")

    @property
    @pulumi.getter(name="trafficPortSelector")
    def traffic_port_selector(self) -> pulumi.Output[Optional['outputs.EndpointPolicyTrafficPortSelector']]:
        """
        Port selector for the (matched) endpoints. If no port selector is provided, the matched config is applied to all ports.
        """
        return pulumi.get(self, "traffic_port_selector")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[builtins.str]:
        """
        The type of endpoint policy. This is primarily used to validate the configuration.
        Possible values are: `SIDECAR_PROXY`, `GRPC_SERVER`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        Time the TcpRoute was updated in UTC.
        """
        return pulumi.get(self, "update_time")

