# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'EdgeCacheKeysetPublicKey',
    'EdgeCacheKeysetValidationSharedKey',
    'EdgeCacheOriginAwsV4Authentication',
    'EdgeCacheOriginFlexShielding',
    'EdgeCacheOriginOriginOverrideAction',
    'EdgeCacheOriginOriginOverrideActionHeaderAction',
    'EdgeCacheOriginOriginOverrideActionHeaderActionRequestHeadersToAdd',
    'EdgeCacheOriginOriginOverrideActionUrlRewrite',
    'EdgeCacheOriginOriginRedirect',
    'EdgeCacheOriginTimeout',
    'EdgeCacheServiceLogConfig',
    'EdgeCacheServiceRouting',
    'EdgeCacheServiceRoutingHostRule',
    'EdgeCacheServiceRoutingPathMatcher',
    'EdgeCacheServiceRoutingPathMatcherRouteRule',
    'EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderAction',
    'EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionRequestHeaderToAdd',
    'EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionRequestHeaderToRemove',
    'EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToAdd',
    'EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToRemove',
    'EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRule',
    'EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleHeaderMatch',
    'EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleQueryParameterMatch',
    'EdgeCacheServiceRoutingPathMatcherRouteRuleRouteAction',
    'EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicy',
    'EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyAddSignatures',
    'EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyCacheKeyPolicy',
    'EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicySignedTokenOptions',
    'EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCorsPolicy',
    'EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionUrlRewrite',
    'EdgeCacheServiceRoutingPathMatcherRouteRuleRouteMethods',
    'EdgeCacheServiceRoutingPathMatcherRouteRuleUrlRedirect',
    'EndpointPolicyEndpointMatcher',
    'EndpointPolicyEndpointMatcherMetadataLabelMatcher',
    'EndpointPolicyEndpointMatcherMetadataLabelMatcherMetadataLabel',
    'EndpointPolicyTrafficPortSelector',
    'GrpcRouteRule',
    'GrpcRouteRuleAction',
    'GrpcRouteRuleActionDestination',
    'GrpcRouteRuleActionFaultInjectionPolicy',
    'GrpcRouteRuleActionFaultInjectionPolicyAbort',
    'GrpcRouteRuleActionFaultInjectionPolicyDelay',
    'GrpcRouteRuleActionRetryPolicy',
    'GrpcRouteRuleMatch',
    'GrpcRouteRuleMatchHeader',
    'GrpcRouteRuleMatchMethod',
    'HttpRouteRule',
    'HttpRouteRuleAction',
    'HttpRouteRuleActionCorsPolicy',
    'HttpRouteRuleActionDestination',
    'HttpRouteRuleActionFaultInjectionPolicy',
    'HttpRouteRuleActionFaultInjectionPolicyAbort',
    'HttpRouteRuleActionFaultInjectionPolicyDelay',
    'HttpRouteRuleActionRedirect',
    'HttpRouteRuleActionRequestHeaderModifier',
    'HttpRouteRuleActionRequestMirrorPolicy',
    'HttpRouteRuleActionRequestMirrorPolicyDestination',
    'HttpRouteRuleActionResponseHeaderModifier',
    'HttpRouteRuleActionRetryPolicy',
    'HttpRouteRuleActionUrlRewrite',
    'HttpRouteRuleMatch',
    'HttpRouteRuleMatchHeader',
    'HttpRouteRuleMatchHeaderRangeMatch',
    'HttpRouteRuleMatchQueryParameter',
    'LbRouteExtensionExtensionChain',
    'LbRouteExtensionExtensionChainExtension',
    'LbRouteExtensionExtensionChainMatchCondition',
    'LbTrafficExtensionExtensionChain',
    'LbTrafficExtensionExtensionChainExtension',
    'LbTrafficExtensionExtensionChainMatchCondition',
    'ServiceLbPoliciesAutoCapacityDrain',
    'ServiceLbPoliciesFailoverConfig',
    'TcpRouteRule',
    'TcpRouteRuleAction',
    'TcpRouteRuleActionDestination',
    'TcpRouteRuleMatch',
    'TlsRouteRule',
    'TlsRouteRuleAction',
    'TlsRouteRuleActionDestination',
    'TlsRouteRuleMatch',
]

@pulumi.output_type
class EdgeCacheKeysetPublicKey(dict):
    def __init__(__self__, *,
                 id: builtins.str,
                 managed: Optional[builtins.bool] = None,
                 value: Optional[builtins.str] = None):
        """
        :param builtins.str id: The ID of the public key. The ID must be 1-63 characters long, and comply with RFC1035.
               The name must be 1-64 characters long, and match the regular expression [a-zA-Z][a-zA-Z0-9_-]*
               which means the first character must be a letter, and all following characters must be a dash, underscore, letter or digit.
        :param builtins.bool managed: Set to true to have the CDN automatically manage this public key value.
        :param builtins.str value: The base64-encoded value of the Ed25519 public key. The base64 encoding can be padded (44 bytes) or unpadded (43 bytes).
               Representations or encodings of the public key other than this will be rejected with an error.
               **Note**: This property is sensitive and will not be displayed in the plan.
        """
        pulumi.set(__self__, "id", id)
        if managed is not None:
            pulumi.set(__self__, "managed", managed)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The ID of the public key. The ID must be 1-63 characters long, and comply with RFC1035.
        The name must be 1-64 characters long, and match the regular expression [a-zA-Z][a-zA-Z0-9_-]*
        which means the first character must be a letter, and all following characters must be a dash, underscore, letter or digit.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def managed(self) -> Optional[builtins.bool]:
        """
        Set to true to have the CDN automatically manage this public key value.
        """
        return pulumi.get(self, "managed")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        """
        The base64-encoded value of the Ed25519 public key. The base64 encoding can be padded (44 bytes) or unpadded (43 bytes).
        Representations or encodings of the public key other than this will be rejected with an error.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class EdgeCacheKeysetValidationSharedKey(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretVersion":
            suggest = "secret_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdgeCacheKeysetValidationSharedKey. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdgeCacheKeysetValidationSharedKey.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdgeCacheKeysetValidationSharedKey.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_version: builtins.str):
        """
        :param builtins.str secret_version: The name of the secret version in Secret Manager.
               The resource name of the secret version must be in the format `projects/*/secrets/*/versions/*` where the `*` values are replaced by the secrets themselves.
               The secrets must be at least 16 bytes large.  The recommended secret size depends on the signature algorithm you are using.
               * If you are using HMAC-SHA1, we suggest 20-byte secrets.
               * If you are using HMAC-SHA256, we suggest 32-byte secrets.
               See RFC 2104, Section 3 for more details on these recommendations.
        """
        pulumi.set(__self__, "secret_version", secret_version)

    @property
    @pulumi.getter(name="secretVersion")
    def secret_version(self) -> builtins.str:
        """
        The name of the secret version in Secret Manager.
        The resource name of the secret version must be in the format `projects/*/secrets/*/versions/*` where the `*` values are replaced by the secrets themselves.
        The secrets must be at least 16 bytes large.  The recommended secret size depends on the signature algorithm you are using.
        * If you are using HMAC-SHA1, we suggest 20-byte secrets.
        * If you are using HMAC-SHA256, we suggest 32-byte secrets.
        See RFC 2104, Section 3 for more details on these recommendations.
        """
        return pulumi.get(self, "secret_version")


@pulumi.output_type
class EdgeCacheOriginAwsV4Authentication(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessKeyId":
            suggest = "access_key_id"
        elif key == "originRegion":
            suggest = "origin_region"
        elif key == "secretAccessKeyVersion":
            suggest = "secret_access_key_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdgeCacheOriginAwsV4Authentication. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdgeCacheOriginAwsV4Authentication.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdgeCacheOriginAwsV4Authentication.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_key_id: builtins.str,
                 origin_region: builtins.str,
                 secret_access_key_version: builtins.str):
        """
        :param builtins.str access_key_id: The access key ID your origin uses to identify the key.
        :param builtins.str origin_region: The name of the AWS region that your origin is in.
        :param builtins.str secret_access_key_version: The Secret Manager secret version of the secret access key used by your origin.
               
               This is the resource name of the secret version in the format 'projects/*/secrets/*/versions/*' where the '*' values are replaced by the project, secret, and version you require.
        """
        pulumi.set(__self__, "access_key_id", access_key_id)
        pulumi.set(__self__, "origin_region", origin_region)
        pulumi.set(__self__, "secret_access_key_version", secret_access_key_version)

    @property
    @pulumi.getter(name="accessKeyId")
    def access_key_id(self) -> builtins.str:
        """
        The access key ID your origin uses to identify the key.
        """
        return pulumi.get(self, "access_key_id")

    @property
    @pulumi.getter(name="originRegion")
    def origin_region(self) -> builtins.str:
        """
        The name of the AWS region that your origin is in.
        """
        return pulumi.get(self, "origin_region")

    @property
    @pulumi.getter(name="secretAccessKeyVersion")
    def secret_access_key_version(self) -> builtins.str:
        """
        The Secret Manager secret version of the secret access key used by your origin.

        This is the resource name of the secret version in the format 'projects/*/secrets/*/versions/*' where the '*' values are replaced by the project, secret, and version you require.
        """
        return pulumi.get(self, "secret_access_key_version")


@pulumi.output_type
class EdgeCacheOriginFlexShielding(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "flexShieldingRegions":
            suggest = "flex_shielding_regions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdgeCacheOriginFlexShielding. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdgeCacheOriginFlexShielding.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdgeCacheOriginFlexShielding.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 flex_shielding_regions: Optional[builtins.str] = None):
        """
        :param builtins.str flex_shielding_regions: Whenever possible, content will be fetched from origin and cached in or
               near the specified origin. Best effort.
               You must specify exactly one FlexShieldingRegion.
               Each value may be one of: `AFRICA_SOUTH1`, `ME_CENTRAL1`.
        """
        if flex_shielding_regions is not None:
            pulumi.set(__self__, "flex_shielding_regions", flex_shielding_regions)

    @property
    @pulumi.getter(name="flexShieldingRegions")
    def flex_shielding_regions(self) -> Optional[builtins.str]:
        """
        Whenever possible, content will be fetched from origin and cached in or
        near the specified origin. Best effort.
        You must specify exactly one FlexShieldingRegion.
        Each value may be one of: `AFRICA_SOUTH1`, `ME_CENTRAL1`.
        """
        return pulumi.get(self, "flex_shielding_regions")


@pulumi.output_type
class EdgeCacheOriginOriginOverrideAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "headerAction":
            suggest = "header_action"
        elif key == "urlRewrite":
            suggest = "url_rewrite"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdgeCacheOriginOriginOverrideAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdgeCacheOriginOriginOverrideAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdgeCacheOriginOriginOverrideAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 header_action: Optional['outputs.EdgeCacheOriginOriginOverrideActionHeaderAction'] = None,
                 url_rewrite: Optional['outputs.EdgeCacheOriginOriginOverrideActionUrlRewrite'] = None):
        """
        :param 'EdgeCacheOriginOriginOverrideActionHeaderActionArgs' header_action: The header actions, including adding and removing
               headers, for request handled by this origin.
               Structure is documented below.
        :param 'EdgeCacheOriginOriginOverrideActionUrlRewriteArgs' url_rewrite: The URL rewrite configuration for request that are
               handled by this origin.
               Structure is documented below.
        """
        if header_action is not None:
            pulumi.set(__self__, "header_action", header_action)
        if url_rewrite is not None:
            pulumi.set(__self__, "url_rewrite", url_rewrite)

    @property
    @pulumi.getter(name="headerAction")
    def header_action(self) -> Optional['outputs.EdgeCacheOriginOriginOverrideActionHeaderAction']:
        """
        The header actions, including adding and removing
        headers, for request handled by this origin.
        Structure is documented below.
        """
        return pulumi.get(self, "header_action")

    @property
    @pulumi.getter(name="urlRewrite")
    def url_rewrite(self) -> Optional['outputs.EdgeCacheOriginOriginOverrideActionUrlRewrite']:
        """
        The URL rewrite configuration for request that are
        handled by this origin.
        Structure is documented below.
        """
        return pulumi.get(self, "url_rewrite")


@pulumi.output_type
class EdgeCacheOriginOriginOverrideActionHeaderAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "requestHeadersToAdds":
            suggest = "request_headers_to_adds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdgeCacheOriginOriginOverrideActionHeaderAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdgeCacheOriginOriginOverrideActionHeaderAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdgeCacheOriginOriginOverrideActionHeaderAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 request_headers_to_adds: Optional[Sequence['outputs.EdgeCacheOriginOriginOverrideActionHeaderActionRequestHeadersToAdd']] = None):
        """
        :param Sequence['EdgeCacheOriginOriginOverrideActionHeaderActionRequestHeadersToAddArgs'] request_headers_to_adds: Describes a header to add.
               You may add a maximum of 25 request headers.
               Structure is documented below.
        """
        if request_headers_to_adds is not None:
            pulumi.set(__self__, "request_headers_to_adds", request_headers_to_adds)

    @property
    @pulumi.getter(name="requestHeadersToAdds")
    def request_headers_to_adds(self) -> Optional[Sequence['outputs.EdgeCacheOriginOriginOverrideActionHeaderActionRequestHeadersToAdd']]:
        """
        Describes a header to add.
        You may add a maximum of 25 request headers.
        Structure is documented below.
        """
        return pulumi.get(self, "request_headers_to_adds")


@pulumi.output_type
class EdgeCacheOriginOriginOverrideActionHeaderActionRequestHeadersToAdd(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "headerName":
            suggest = "header_name"
        elif key == "headerValue":
            suggest = "header_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdgeCacheOriginOriginOverrideActionHeaderActionRequestHeadersToAdd. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdgeCacheOriginOriginOverrideActionHeaderActionRequestHeadersToAdd.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdgeCacheOriginOriginOverrideActionHeaderActionRequestHeadersToAdd.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 header_name: builtins.str,
                 header_value: builtins.str,
                 replace: Optional[builtins.bool] = None):
        """
        :param builtins.str header_name: The name of the header to add.
        :param builtins.str header_value: The value of the header to add.
        :param builtins.bool replace: Whether to replace all existing headers with the same name.
               By default, added header values are appended
               to the response or request headers with the
               same field names. The added values are
               separated by commas.
               To overwrite existing values, set `replace` to `true`.
        """
        pulumi.set(__self__, "header_name", header_name)
        pulumi.set(__self__, "header_value", header_value)
        if replace is not None:
            pulumi.set(__self__, "replace", replace)

    @property
    @pulumi.getter(name="headerName")
    def header_name(self) -> builtins.str:
        """
        The name of the header to add.
        """
        return pulumi.get(self, "header_name")

    @property
    @pulumi.getter(name="headerValue")
    def header_value(self) -> builtins.str:
        """
        The value of the header to add.
        """
        return pulumi.get(self, "header_value")

    @property
    @pulumi.getter
    def replace(self) -> Optional[builtins.bool]:
        """
        Whether to replace all existing headers with the same name.
        By default, added header values are appended
        to the response or request headers with the
        same field names. The added values are
        separated by commas.
        To overwrite existing values, set `replace` to `true`.
        """
        return pulumi.get(self, "replace")


@pulumi.output_type
class EdgeCacheOriginOriginOverrideActionUrlRewrite(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hostRewrite":
            suggest = "host_rewrite"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdgeCacheOriginOriginOverrideActionUrlRewrite. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdgeCacheOriginOriginOverrideActionUrlRewrite.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdgeCacheOriginOriginOverrideActionUrlRewrite.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host_rewrite: Optional[builtins.str] = None):
        """
        :param builtins.str host_rewrite: Prior to forwarding the request to the selected
               origin, the request's host header is replaced with
               contents of the hostRewrite.
               This value must be between 1 and 255 characters.
        """
        if host_rewrite is not None:
            pulumi.set(__self__, "host_rewrite", host_rewrite)

    @property
    @pulumi.getter(name="hostRewrite")
    def host_rewrite(self) -> Optional[builtins.str]:
        """
        Prior to forwarding the request to the selected
        origin, the request's host header is replaced with
        contents of the hostRewrite.
        This value must be between 1 and 255 characters.
        """
        return pulumi.get(self, "host_rewrite")


@pulumi.output_type
class EdgeCacheOriginOriginRedirect(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "redirectConditions":
            suggest = "redirect_conditions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdgeCacheOriginOriginRedirect. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdgeCacheOriginOriginRedirect.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdgeCacheOriginOriginRedirect.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 redirect_conditions: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence[builtins.str] redirect_conditions: The set of redirect response codes that the CDN
               follows. Values of
               [RedirectConditions](https://cloud.google.com/media-cdn/docs/reference/rest/v1/projects.locations.edgeCacheOrigins#redirectconditions)
               are accepted.
        """
        if redirect_conditions is not None:
            pulumi.set(__self__, "redirect_conditions", redirect_conditions)

    @property
    @pulumi.getter(name="redirectConditions")
    def redirect_conditions(self) -> Optional[Sequence[builtins.str]]:
        """
        The set of redirect response codes that the CDN
        follows. Values of
        [RedirectConditions](https://cloud.google.com/media-cdn/docs/reference/rest/v1/projects.locations.edgeCacheOrigins#redirectconditions)
        are accepted.
        """
        return pulumi.get(self, "redirect_conditions")


@pulumi.output_type
class EdgeCacheOriginTimeout(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectTimeout":
            suggest = "connect_timeout"
        elif key == "maxAttemptsTimeout":
            suggest = "max_attempts_timeout"
        elif key == "readTimeout":
            suggest = "read_timeout"
        elif key == "responseTimeout":
            suggest = "response_timeout"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdgeCacheOriginTimeout. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdgeCacheOriginTimeout.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdgeCacheOriginTimeout.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connect_timeout: Optional[builtins.str] = None,
                 max_attempts_timeout: Optional[builtins.str] = None,
                 read_timeout: Optional[builtins.str] = None,
                 response_timeout: Optional[builtins.str] = None):
        """
        :param builtins.str connect_timeout: The maximum duration to wait for a single origin connection to be established, including DNS lookup, TLS handshake and TCP/QUIC connection establishment.
               Defaults to 5 seconds. The timeout must be a value between 1s and 15s.
               The connectTimeout capped by the deadline set by the request's maxAttemptsTimeout.  The last connection attempt may have a smaller connectTimeout in order to adhere to the overall maxAttemptsTimeout.
        :param builtins.str max_attempts_timeout: The maximum time across all connection attempts to the origin, including failover origins, before returning an error to the client. A HTTP 504 will be returned if the timeout is reached before a response is returned.
               Defaults to 15 seconds. The timeout must be a value between 1s and 30s.
               If a failoverOrigin is specified, the maxAttemptsTimeout of the first configured origin sets the deadline for all connection attempts across all failoverOrigins.
        :param builtins.str read_timeout: The maximum duration to wait between reads of a single HTTP connection/stream.
               Defaults to 15 seconds.  The timeout must be a value between 1s and 30s.
               The readTimeout is capped by the responseTimeout.  All reads of the HTTP connection/stream must be completed by the deadline set by the responseTimeout.
               If the response headers have already been written to the connection, the response will be truncated and logged.
               
               <a name="nested_aws_v4_authentication"></a>The `aws_v4_authentication` block supports:
        :param builtins.str response_timeout: The maximum duration to wait for the last byte of a response to arrive when reading from the HTTP connection/stream.
               Defaults to 30 seconds. The timeout must be a value between 1s and 120s.
               The responseTimeout starts after the connection has been established.
               This also applies to HTTP Chunked Transfer Encoding responses, and/or when an open-ended Range request is made to the origin. Origins that take longer to write additional bytes to the response than the configured responseTimeout will result in an error being returned to the client.
               If the response headers have already been written to the connection, the response will be truncated and logged.
        """
        if connect_timeout is not None:
            pulumi.set(__self__, "connect_timeout", connect_timeout)
        if max_attempts_timeout is not None:
            pulumi.set(__self__, "max_attempts_timeout", max_attempts_timeout)
        if read_timeout is not None:
            pulumi.set(__self__, "read_timeout", read_timeout)
        if response_timeout is not None:
            pulumi.set(__self__, "response_timeout", response_timeout)

    @property
    @pulumi.getter(name="connectTimeout")
    def connect_timeout(self) -> Optional[builtins.str]:
        """
        The maximum duration to wait for a single origin connection to be established, including DNS lookup, TLS handshake and TCP/QUIC connection establishment.
        Defaults to 5 seconds. The timeout must be a value between 1s and 15s.
        The connectTimeout capped by the deadline set by the request's maxAttemptsTimeout.  The last connection attempt may have a smaller connectTimeout in order to adhere to the overall maxAttemptsTimeout.
        """
        return pulumi.get(self, "connect_timeout")

    @property
    @pulumi.getter(name="maxAttemptsTimeout")
    def max_attempts_timeout(self) -> Optional[builtins.str]:
        """
        The maximum time across all connection attempts to the origin, including failover origins, before returning an error to the client. A HTTP 504 will be returned if the timeout is reached before a response is returned.
        Defaults to 15 seconds. The timeout must be a value between 1s and 30s.
        If a failoverOrigin is specified, the maxAttemptsTimeout of the first configured origin sets the deadline for all connection attempts across all failoverOrigins.
        """
        return pulumi.get(self, "max_attempts_timeout")

    @property
    @pulumi.getter(name="readTimeout")
    def read_timeout(self) -> Optional[builtins.str]:
        """
        The maximum duration to wait between reads of a single HTTP connection/stream.
        Defaults to 15 seconds.  The timeout must be a value between 1s and 30s.
        The readTimeout is capped by the responseTimeout.  All reads of the HTTP connection/stream must be completed by the deadline set by the responseTimeout.
        If the response headers have already been written to the connection, the response will be truncated and logged.

        <a name="nested_aws_v4_authentication"></a>The `aws_v4_authentication` block supports:
        """
        return pulumi.get(self, "read_timeout")

    @property
    @pulumi.getter(name="responseTimeout")
    def response_timeout(self) -> Optional[builtins.str]:
        """
        The maximum duration to wait for the last byte of a response to arrive when reading from the HTTP connection/stream.
        Defaults to 30 seconds. The timeout must be a value between 1s and 120s.
        The responseTimeout starts after the connection has been established.
        This also applies to HTTP Chunked Transfer Encoding responses, and/or when an open-ended Range request is made to the origin. Origins that take longer to write additional bytes to the response than the configured responseTimeout will result in an error being returned to the client.
        If the response headers have already been written to the connection, the response will be truncated and logged.
        """
        return pulumi.get(self, "response_timeout")


@pulumi.output_type
class EdgeCacheServiceLogConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sampleRate":
            suggest = "sample_rate"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdgeCacheServiceLogConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdgeCacheServiceLogConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdgeCacheServiceLogConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable: Optional[builtins.bool] = None,
                 sample_rate: Optional[builtins.float] = None):
        """
        :param builtins.bool enable: Specifies whether to enable logging for traffic served by this service.
        :param builtins.float sample_rate: Configures the sampling rate of requests, where 1.0 means all logged requests are reported and 0.0 means no logged requests are reported. The default value is 1.0, and the value of the field must be in [0, 1].
               This field can only be specified if logging is enabled for this service.
        """
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if sample_rate is not None:
            pulumi.set(__self__, "sample_rate", sample_rate)

    @property
    @pulumi.getter
    def enable(self) -> Optional[builtins.bool]:
        """
        Specifies whether to enable logging for traffic served by this service.
        """
        return pulumi.get(self, "enable")

    @property
    @pulumi.getter(name="sampleRate")
    def sample_rate(self) -> Optional[builtins.float]:
        """
        Configures the sampling rate of requests, where 1.0 means all logged requests are reported and 0.0 means no logged requests are reported. The default value is 1.0, and the value of the field must be in [0, 1].
        This field can only be specified if logging is enabled for this service.
        """
        return pulumi.get(self, "sample_rate")


@pulumi.output_type
class EdgeCacheServiceRouting(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hostRules":
            suggest = "host_rules"
        elif key == "pathMatchers":
            suggest = "path_matchers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdgeCacheServiceRouting. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdgeCacheServiceRouting.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdgeCacheServiceRouting.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host_rules: Sequence['outputs.EdgeCacheServiceRoutingHostRule'],
                 path_matchers: Sequence['outputs.EdgeCacheServiceRoutingPathMatcher']):
        """
        :param Sequence['EdgeCacheServiceRoutingHostRuleArgs'] host_rules: The list of hostRules to match against. These rules define which hostnames the EdgeCacheService will match against, and which route configurations apply.
               Structure is documented below.
        :param Sequence['EdgeCacheServiceRoutingPathMatcherArgs'] path_matchers: The list of pathMatchers referenced via name by hostRules. PathMatcher is used to match the path portion of the URL when a HostRule matches the URL's host portion.
               Structure is documented below.
        """
        pulumi.set(__self__, "host_rules", host_rules)
        pulumi.set(__self__, "path_matchers", path_matchers)

    @property
    @pulumi.getter(name="hostRules")
    def host_rules(self) -> Sequence['outputs.EdgeCacheServiceRoutingHostRule']:
        """
        The list of hostRules to match against. These rules define which hostnames the EdgeCacheService will match against, and which route configurations apply.
        Structure is documented below.
        """
        return pulumi.get(self, "host_rules")

    @property
    @pulumi.getter(name="pathMatchers")
    def path_matchers(self) -> Sequence['outputs.EdgeCacheServiceRoutingPathMatcher']:
        """
        The list of pathMatchers referenced via name by hostRules. PathMatcher is used to match the path portion of the URL when a HostRule matches the URL's host portion.
        Structure is documented below.
        """
        return pulumi.get(self, "path_matchers")


@pulumi.output_type
class EdgeCacheServiceRoutingHostRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pathMatcher":
            suggest = "path_matcher"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdgeCacheServiceRoutingHostRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdgeCacheServiceRoutingHostRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdgeCacheServiceRoutingHostRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hosts: Sequence[builtins.str],
                 path_matcher: builtins.str,
                 description: Optional[builtins.str] = None):
        """
        :param Sequence[builtins.str] hosts: The list of host patterns to match.
               Host patterns must be valid hostnames. Ports are not allowed. Wildcard hosts are supported in the suffix or prefix form. * matches any string of ([a-z0-9-.]*). It does not match the empty string.
               When multiple hosts are specified, hosts are matched in the following priority:
               1. Exact domain names: ``www.foo.com``.
               2. Suffix domain wildcards: ``*.foo.com`` or ``*-bar.foo.com``.
               3. Prefix domain wildcards: ``foo.*`` or ``foo-*``.
               4. Special wildcard ``*`` matching any domain.
               Notes:
               The wildcard will not match the empty string. e.g. ``*-bar.foo.com`` will match ``baz-bar.foo.com`` but not ``-bar.foo.com``. The longest wildcards match first. Only a single host in the entire service can match on ``*``. A domain must be unique across all configured hosts within a service.
               Hosts are matched against the HTTP Host header, or for HTTP/2 and HTTP/3, the ":authority" header, from the incoming request.
               You may specify up to 10 hosts.
        :param builtins.str path_matcher: The name of the pathMatcher associated with this hostRule.
        :param builtins.str description: A human-readable description of the hostRule.
        """
        pulumi.set(__self__, "hosts", hosts)
        pulumi.set(__self__, "path_matcher", path_matcher)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def hosts(self) -> Sequence[builtins.str]:
        """
        The list of host patterns to match.
        Host patterns must be valid hostnames. Ports are not allowed. Wildcard hosts are supported in the suffix or prefix form. * matches any string of ([a-z0-9-.]*). It does not match the empty string.
        When multiple hosts are specified, hosts are matched in the following priority:
        1. Exact domain names: ``www.foo.com``.
        2. Suffix domain wildcards: ``*.foo.com`` or ``*-bar.foo.com``.
        3. Prefix domain wildcards: ``foo.*`` or ``foo-*``.
        4. Special wildcard ``*`` matching any domain.
        Notes:
        The wildcard will not match the empty string. e.g. ``*-bar.foo.com`` will match ``baz-bar.foo.com`` but not ``-bar.foo.com``. The longest wildcards match first. Only a single host in the entire service can match on ``*``. A domain must be unique across all configured hosts within a service.
        Hosts are matched against the HTTP Host header, or for HTTP/2 and HTTP/3, the ":authority" header, from the incoming request.
        You may specify up to 10 hosts.
        """
        return pulumi.get(self, "hosts")

    @property
    @pulumi.getter(name="pathMatcher")
    def path_matcher(self) -> builtins.str:
        """
        The name of the pathMatcher associated with this hostRule.
        """
        return pulumi.get(self, "path_matcher")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        A human-readable description of the hostRule.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class EdgeCacheServiceRoutingPathMatcher(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "routeRules":
            suggest = "route_rules"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdgeCacheServiceRoutingPathMatcher. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdgeCacheServiceRoutingPathMatcher.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdgeCacheServiceRoutingPathMatcher.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 route_rules: Sequence['outputs.EdgeCacheServiceRoutingPathMatcherRouteRule'],
                 description: Optional[builtins.str] = None):
        """
        :param builtins.str name: The name to which this PathMatcher is referred by the HostRule.
        :param Sequence['EdgeCacheServiceRoutingPathMatcherRouteRuleArgs'] route_rules: The routeRules to match against. routeRules support advanced routing behaviour, and can match on paths, headers and query parameters, as well as status codes and HTTP methods.
               Structure is documented below.
        :param builtins.str description: A human-readable description of the resource.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "route_rules", route_rules)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name to which this PathMatcher is referred by the HostRule.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="routeRules")
    def route_rules(self) -> Sequence['outputs.EdgeCacheServiceRoutingPathMatcherRouteRule']:
        """
        The routeRules to match against. routeRules support advanced routing behaviour, and can match on paths, headers and query parameters, as well as status codes and HTTP methods.
        Structure is documented below.
        """
        return pulumi.get(self, "route_rules")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        A human-readable description of the resource.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class EdgeCacheServiceRoutingPathMatcherRouteRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "matchRules":
            suggest = "match_rules"
        elif key == "headerAction":
            suggest = "header_action"
        elif key == "routeAction":
            suggest = "route_action"
        elif key == "routeMethods":
            suggest = "route_methods"
        elif key == "urlRedirect":
            suggest = "url_redirect"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdgeCacheServiceRoutingPathMatcherRouteRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdgeCacheServiceRoutingPathMatcherRouteRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdgeCacheServiceRoutingPathMatcherRouteRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 match_rules: Sequence['outputs.EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRule'],
                 priority: builtins.str,
                 description: Optional[builtins.str] = None,
                 header_action: Optional['outputs.EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderAction'] = None,
                 origin: Optional[builtins.str] = None,
                 route_action: Optional['outputs.EdgeCacheServiceRoutingPathMatcherRouteRuleRouteAction'] = None,
                 route_methods: Optional['outputs.EdgeCacheServiceRoutingPathMatcherRouteRuleRouteMethods'] = None,
                 url_redirect: Optional['outputs.EdgeCacheServiceRoutingPathMatcherRouteRuleUrlRedirect'] = None):
        """
        :param Sequence['EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleArgs'] match_rules: The list of criteria for matching attributes of a request to this routeRule. This list has OR semantics: the request matches this routeRule when any of the matchRules are satisfied. However predicates
               within a given matchRule have AND semantics. All predicates within a matchRule must match for the request to match the rule.
               Structure is documented below.
        :param builtins.str priority: The priority of this route rule, where 1 is the highest priority.
               You cannot configure two or more routeRules with the same priority. Priority for each rule must be set to a number between 1 and 999 inclusive.
               Priority numbers can have gaps, which enable you to add or remove rules in the future without affecting the rest of the rules. For example, 1, 2, 3, 4, 5, 9, 12, 16 is a valid series of priority numbers
               to which you could add rules numbered from 6 to 8, 10 to 11, and 13 to 15 in the future without any impact on existing rules.
        :param builtins.str description: A human-readable description of the routeRule.
        :param 'EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionArgs' header_action: The header actions, including adding & removing headers, for requests that match this route.
               Structure is documented below.
        :param builtins.str origin: The Origin resource that requests to this route should fetch from when a matching response is not in cache. Origins can be defined as short names ("my-origin") or fully-qualified resource URLs - e.g. "networkservices.googleapis.com/projects/my-project/global/edgecacheorigins/my-origin"
               Only one of origin or urlRedirect can be set.
        :param 'EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionArgs' route_action: In response to a matching path, the routeAction performs advanced routing actions like URL rewrites, header transformations, etc. prior to forwarding the request to the selected origin.
               Structure is documented below.
        :param 'EdgeCacheServiceRoutingPathMatcherRouteRuleRouteMethodsArgs' route_methods: Allow overriding the set of methods that are allowed for this route.
               When not set, Media CDN allows only "GET", "HEAD", and "OPTIONS".
               Structure is documented below.
        :param 'EdgeCacheServiceRoutingPathMatcherRouteRuleUrlRedirectArgs' url_redirect: The URL redirect configuration for requests that match this route.
               Structure is documented below.
        """
        pulumi.set(__self__, "match_rules", match_rules)
        pulumi.set(__self__, "priority", priority)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if header_action is not None:
            pulumi.set(__self__, "header_action", header_action)
        if origin is not None:
            pulumi.set(__self__, "origin", origin)
        if route_action is not None:
            pulumi.set(__self__, "route_action", route_action)
        if route_methods is not None:
            pulumi.set(__self__, "route_methods", route_methods)
        if url_redirect is not None:
            pulumi.set(__self__, "url_redirect", url_redirect)

    @property
    @pulumi.getter(name="matchRules")
    def match_rules(self) -> Sequence['outputs.EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRule']:
        """
        The list of criteria for matching attributes of a request to this routeRule. This list has OR semantics: the request matches this routeRule when any of the matchRules are satisfied. However predicates
        within a given matchRule have AND semantics. All predicates within a matchRule must match for the request to match the rule.
        Structure is documented below.
        """
        return pulumi.get(self, "match_rules")

    @property
    @pulumi.getter
    def priority(self) -> builtins.str:
        """
        The priority of this route rule, where 1 is the highest priority.
        You cannot configure two or more routeRules with the same priority. Priority for each rule must be set to a number between 1 and 999 inclusive.
        Priority numbers can have gaps, which enable you to add or remove rules in the future without affecting the rest of the rules. For example, 1, 2, 3, 4, 5, 9, 12, 16 is a valid series of priority numbers
        to which you could add rules numbered from 6 to 8, 10 to 11, and 13 to 15 in the future without any impact on existing rules.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        A human-readable description of the routeRule.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="headerAction")
    def header_action(self) -> Optional['outputs.EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderAction']:
        """
        The header actions, including adding & removing headers, for requests that match this route.
        Structure is documented below.
        """
        return pulumi.get(self, "header_action")

    @property
    @pulumi.getter
    def origin(self) -> Optional[builtins.str]:
        """
        The Origin resource that requests to this route should fetch from when a matching response is not in cache. Origins can be defined as short names ("my-origin") or fully-qualified resource URLs - e.g. "networkservices.googleapis.com/projects/my-project/global/edgecacheorigins/my-origin"
        Only one of origin or urlRedirect can be set.
        """
        return pulumi.get(self, "origin")

    @property
    @pulumi.getter(name="routeAction")
    def route_action(self) -> Optional['outputs.EdgeCacheServiceRoutingPathMatcherRouteRuleRouteAction']:
        """
        In response to a matching path, the routeAction performs advanced routing actions like URL rewrites, header transformations, etc. prior to forwarding the request to the selected origin.
        Structure is documented below.
        """
        return pulumi.get(self, "route_action")

    @property
    @pulumi.getter(name="routeMethods")
    def route_methods(self) -> Optional['outputs.EdgeCacheServiceRoutingPathMatcherRouteRuleRouteMethods']:
        """
        Allow overriding the set of methods that are allowed for this route.
        When not set, Media CDN allows only "GET", "HEAD", and "OPTIONS".
        Structure is documented below.
        """
        return pulumi.get(self, "route_methods")

    @property
    @pulumi.getter(name="urlRedirect")
    def url_redirect(self) -> Optional['outputs.EdgeCacheServiceRoutingPathMatcherRouteRuleUrlRedirect']:
        """
        The URL redirect configuration for requests that match this route.
        Structure is documented below.
        """
        return pulumi.get(self, "url_redirect")


@pulumi.output_type
class EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "requestHeaderToAdds":
            suggest = "request_header_to_adds"
        elif key == "requestHeaderToRemoves":
            suggest = "request_header_to_removes"
        elif key == "responseHeaderToAdds":
            suggest = "response_header_to_adds"
        elif key == "responseHeaderToRemoves":
            suggest = "response_header_to_removes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 request_header_to_adds: Optional[Sequence['outputs.EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionRequestHeaderToAdd']] = None,
                 request_header_to_removes: Optional[Sequence['outputs.EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionRequestHeaderToRemove']] = None,
                 response_header_to_adds: Optional[Sequence['outputs.EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToAdd']] = None,
                 response_header_to_removes: Optional[Sequence['outputs.EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToRemove']] = None):
        """
        :param Sequence['EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionRequestHeaderToAddArgs'] request_header_to_adds: Describes a header to add.
               Structure is documented below.
        :param Sequence['EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionRequestHeaderToRemoveArgs'] request_header_to_removes: A list of header names for headers that need to be removed from the request prior to forwarding the request to the origin.
               Structure is documented below.
        :param Sequence['EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToAddArgs'] response_header_to_adds: Headers to add to the response prior to sending it back to the client.
               Response headers are only sent to the client, and do not have an effect on the cache serving the response.
               Structure is documented below.
        :param Sequence['EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToRemoveArgs'] response_header_to_removes: A list of header names for headers that need to be removed from the request prior to forwarding the request to the origin.
               Structure is documented below.
        """
        if request_header_to_adds is not None:
            pulumi.set(__self__, "request_header_to_adds", request_header_to_adds)
        if request_header_to_removes is not None:
            pulumi.set(__self__, "request_header_to_removes", request_header_to_removes)
        if response_header_to_adds is not None:
            pulumi.set(__self__, "response_header_to_adds", response_header_to_adds)
        if response_header_to_removes is not None:
            pulumi.set(__self__, "response_header_to_removes", response_header_to_removes)

    @property
    @pulumi.getter(name="requestHeaderToAdds")
    def request_header_to_adds(self) -> Optional[Sequence['outputs.EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionRequestHeaderToAdd']]:
        """
        Describes a header to add.
        Structure is documented below.
        """
        return pulumi.get(self, "request_header_to_adds")

    @property
    @pulumi.getter(name="requestHeaderToRemoves")
    def request_header_to_removes(self) -> Optional[Sequence['outputs.EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionRequestHeaderToRemove']]:
        """
        A list of header names for headers that need to be removed from the request prior to forwarding the request to the origin.
        Structure is documented below.
        """
        return pulumi.get(self, "request_header_to_removes")

    @property
    @pulumi.getter(name="responseHeaderToAdds")
    def response_header_to_adds(self) -> Optional[Sequence['outputs.EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToAdd']]:
        """
        Headers to add to the response prior to sending it back to the client.
        Response headers are only sent to the client, and do not have an effect on the cache serving the response.
        Structure is documented below.
        """
        return pulumi.get(self, "response_header_to_adds")

    @property
    @pulumi.getter(name="responseHeaderToRemoves")
    def response_header_to_removes(self) -> Optional[Sequence['outputs.EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToRemove']]:
        """
        A list of header names for headers that need to be removed from the request prior to forwarding the request to the origin.
        Structure is documented below.
        """
        return pulumi.get(self, "response_header_to_removes")


@pulumi.output_type
class EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionRequestHeaderToAdd(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "headerName":
            suggest = "header_name"
        elif key == "headerValue":
            suggest = "header_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionRequestHeaderToAdd. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionRequestHeaderToAdd.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionRequestHeaderToAdd.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 header_name: builtins.str,
                 header_value: builtins.str,
                 replace: Optional[builtins.bool] = None):
        """
        :param builtins.str header_name: The name of the header to add.
        :param builtins.str header_value: The value of the header to add.
        :param builtins.bool replace: Whether to replace all existing headers with the same name.
        """
        pulumi.set(__self__, "header_name", header_name)
        pulumi.set(__self__, "header_value", header_value)
        if replace is not None:
            pulumi.set(__self__, "replace", replace)

    @property
    @pulumi.getter(name="headerName")
    def header_name(self) -> builtins.str:
        """
        The name of the header to add.
        """
        return pulumi.get(self, "header_name")

    @property
    @pulumi.getter(name="headerValue")
    def header_value(self) -> builtins.str:
        """
        The value of the header to add.
        """
        return pulumi.get(self, "header_value")

    @property
    @pulumi.getter
    def replace(self) -> Optional[builtins.bool]:
        """
        Whether to replace all existing headers with the same name.
        """
        return pulumi.get(self, "replace")


@pulumi.output_type
class EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionRequestHeaderToRemove(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "headerName":
            suggest = "header_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionRequestHeaderToRemove. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionRequestHeaderToRemove.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionRequestHeaderToRemove.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 header_name: builtins.str):
        """
        :param builtins.str header_name: The name of the header to remove.
        """
        pulumi.set(__self__, "header_name", header_name)

    @property
    @pulumi.getter(name="headerName")
    def header_name(self) -> builtins.str:
        """
        The name of the header to remove.
        """
        return pulumi.get(self, "header_name")


@pulumi.output_type
class EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToAdd(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "headerName":
            suggest = "header_name"
        elif key == "headerValue":
            suggest = "header_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToAdd. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToAdd.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToAdd.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 header_name: builtins.str,
                 header_value: builtins.str,
                 replace: Optional[builtins.bool] = None):
        """
        :param builtins.str header_name: The name of the header to add.
        :param builtins.str header_value: The value of the header to add.
        :param builtins.bool replace: Whether to replace all existing headers with the same name.
        """
        pulumi.set(__self__, "header_name", header_name)
        pulumi.set(__self__, "header_value", header_value)
        if replace is not None:
            pulumi.set(__self__, "replace", replace)

    @property
    @pulumi.getter(name="headerName")
    def header_name(self) -> builtins.str:
        """
        The name of the header to add.
        """
        return pulumi.get(self, "header_name")

    @property
    @pulumi.getter(name="headerValue")
    def header_value(self) -> builtins.str:
        """
        The value of the header to add.
        """
        return pulumi.get(self, "header_value")

    @property
    @pulumi.getter
    def replace(self) -> Optional[builtins.bool]:
        """
        Whether to replace all existing headers with the same name.
        """
        return pulumi.get(self, "replace")


@pulumi.output_type
class EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToRemove(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "headerName":
            suggest = "header_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToRemove. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToRemove.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToRemove.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 header_name: builtins.str):
        """
        :param builtins.str header_name: Headers to remove from the response prior to sending it back to the client.
               Response headers are only sent to the client, and do not have an effect on the cache serving the response.
        """
        pulumi.set(__self__, "header_name", header_name)

    @property
    @pulumi.getter(name="headerName")
    def header_name(self) -> builtins.str:
        """
        Headers to remove from the response prior to sending it back to the client.
        Response headers are only sent to the client, and do not have an effect on the cache serving the response.
        """
        return pulumi.get(self, "header_name")


@pulumi.output_type
class EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fullPathMatch":
            suggest = "full_path_match"
        elif key == "headerMatches":
            suggest = "header_matches"
        elif key == "ignoreCase":
            suggest = "ignore_case"
        elif key == "pathTemplateMatch":
            suggest = "path_template_match"
        elif key == "prefixMatch":
            suggest = "prefix_match"
        elif key == "queryParameterMatches":
            suggest = "query_parameter_matches"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 full_path_match: Optional[builtins.str] = None,
                 header_matches: Optional[Sequence['outputs.EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleHeaderMatch']] = None,
                 ignore_case: Optional[builtins.bool] = None,
                 path_template_match: Optional[builtins.str] = None,
                 prefix_match: Optional[builtins.str] = None,
                 query_parameter_matches: Optional[Sequence['outputs.EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleQueryParameterMatch']] = None):
        """
        :param builtins.str full_path_match: For satisfying the matchRule condition, the path of the request must exactly match the value specified in fullPathMatch after removing any query parameters and anchor that may be part of the original URL.
        :param Sequence['EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleHeaderMatchArgs'] header_matches: Specifies a list of header match criteria, all of which must match corresponding headers in the request.
               Structure is documented below.
        :param builtins.bool ignore_case: Specifies that prefixMatch and fullPathMatch matches are case sensitive.
        :param builtins.str path_template_match: For satisfying the matchRule condition, the path of the request
               must match the wildcard pattern specified in pathTemplateMatch
               after removing any query parameters and anchor that may be part
               of the original URL.
               pathTemplateMatch must be between 1 and 255 characters
               (inclusive).  The pattern specified by pathTemplateMatch may
               have at most 5 wildcard operators and at most 5 variable
               captures in total.
        :param builtins.str prefix_match: For satisfying the matchRule condition, the request's path must begin with the specified prefixMatch. prefixMatch must begin with a /.
        :param Sequence['EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleQueryParameterMatchArgs'] query_parameter_matches: Specifies a list of query parameter match criteria, all of which must match corresponding query parameters in the request.
               Structure is documented below.
        """
        if full_path_match is not None:
            pulumi.set(__self__, "full_path_match", full_path_match)
        if header_matches is not None:
            pulumi.set(__self__, "header_matches", header_matches)
        if ignore_case is not None:
            pulumi.set(__self__, "ignore_case", ignore_case)
        if path_template_match is not None:
            pulumi.set(__self__, "path_template_match", path_template_match)
        if prefix_match is not None:
            pulumi.set(__self__, "prefix_match", prefix_match)
        if query_parameter_matches is not None:
            pulumi.set(__self__, "query_parameter_matches", query_parameter_matches)

    @property
    @pulumi.getter(name="fullPathMatch")
    def full_path_match(self) -> Optional[builtins.str]:
        """
        For satisfying the matchRule condition, the path of the request must exactly match the value specified in fullPathMatch after removing any query parameters and anchor that may be part of the original URL.
        """
        return pulumi.get(self, "full_path_match")

    @property
    @pulumi.getter(name="headerMatches")
    def header_matches(self) -> Optional[Sequence['outputs.EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleHeaderMatch']]:
        """
        Specifies a list of header match criteria, all of which must match corresponding headers in the request.
        Structure is documented below.
        """
        return pulumi.get(self, "header_matches")

    @property
    @pulumi.getter(name="ignoreCase")
    def ignore_case(self) -> Optional[builtins.bool]:
        """
        Specifies that prefixMatch and fullPathMatch matches are case sensitive.
        """
        return pulumi.get(self, "ignore_case")

    @property
    @pulumi.getter(name="pathTemplateMatch")
    def path_template_match(self) -> Optional[builtins.str]:
        """
        For satisfying the matchRule condition, the path of the request
        must match the wildcard pattern specified in pathTemplateMatch
        after removing any query parameters and anchor that may be part
        of the original URL.
        pathTemplateMatch must be between 1 and 255 characters
        (inclusive).  The pattern specified by pathTemplateMatch may
        have at most 5 wildcard operators and at most 5 variable
        captures in total.
        """
        return pulumi.get(self, "path_template_match")

    @property
    @pulumi.getter(name="prefixMatch")
    def prefix_match(self) -> Optional[builtins.str]:
        """
        For satisfying the matchRule condition, the request's path must begin with the specified prefixMatch. prefixMatch must begin with a /.
        """
        return pulumi.get(self, "prefix_match")

    @property
    @pulumi.getter(name="queryParameterMatches")
    def query_parameter_matches(self) -> Optional[Sequence['outputs.EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleQueryParameterMatch']]:
        """
        Specifies a list of query parameter match criteria, all of which must match corresponding query parameters in the request.
        Structure is documented below.
        """
        return pulumi.get(self, "query_parameter_matches")


@pulumi.output_type
class EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleHeaderMatch(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "headerName":
            suggest = "header_name"
        elif key == "exactMatch":
            suggest = "exact_match"
        elif key == "invertMatch":
            suggest = "invert_match"
        elif key == "prefixMatch":
            suggest = "prefix_match"
        elif key == "presentMatch":
            suggest = "present_match"
        elif key == "suffixMatch":
            suggest = "suffix_match"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleHeaderMatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleHeaderMatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleHeaderMatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 header_name: builtins.str,
                 exact_match: Optional[builtins.str] = None,
                 invert_match: Optional[builtins.bool] = None,
                 prefix_match: Optional[builtins.str] = None,
                 present_match: Optional[builtins.bool] = None,
                 suffix_match: Optional[builtins.str] = None):
        """
        :param builtins.str header_name: The header name to match on.
        :param builtins.str exact_match: The value of the header should exactly match contents of exactMatch.
        :param builtins.bool invert_match: If set to false (default), the headerMatch is considered a match if the match criteria above are met.
               If set to true, the headerMatch is considered a match if the match criteria above are NOT met.
        :param builtins.str prefix_match: The value of the header must start with the contents of prefixMatch.
        :param builtins.bool present_match: A header with the contents of headerName must exist. The match takes place whether or not the request's header has a value.
        :param builtins.str suffix_match: The value of the header must end with the contents of suffixMatch.
        """
        pulumi.set(__self__, "header_name", header_name)
        if exact_match is not None:
            pulumi.set(__self__, "exact_match", exact_match)
        if invert_match is not None:
            pulumi.set(__self__, "invert_match", invert_match)
        if prefix_match is not None:
            pulumi.set(__self__, "prefix_match", prefix_match)
        if present_match is not None:
            pulumi.set(__self__, "present_match", present_match)
        if suffix_match is not None:
            pulumi.set(__self__, "suffix_match", suffix_match)

    @property
    @pulumi.getter(name="headerName")
    def header_name(self) -> builtins.str:
        """
        The header name to match on.
        """
        return pulumi.get(self, "header_name")

    @property
    @pulumi.getter(name="exactMatch")
    def exact_match(self) -> Optional[builtins.str]:
        """
        The value of the header should exactly match contents of exactMatch.
        """
        return pulumi.get(self, "exact_match")

    @property
    @pulumi.getter(name="invertMatch")
    def invert_match(self) -> Optional[builtins.bool]:
        """
        If set to false (default), the headerMatch is considered a match if the match criteria above are met.
        If set to true, the headerMatch is considered a match if the match criteria above are NOT met.
        """
        return pulumi.get(self, "invert_match")

    @property
    @pulumi.getter(name="prefixMatch")
    def prefix_match(self) -> Optional[builtins.str]:
        """
        The value of the header must start with the contents of prefixMatch.
        """
        return pulumi.get(self, "prefix_match")

    @property
    @pulumi.getter(name="presentMatch")
    def present_match(self) -> Optional[builtins.bool]:
        """
        A header with the contents of headerName must exist. The match takes place whether or not the request's header has a value.
        """
        return pulumi.get(self, "present_match")

    @property
    @pulumi.getter(name="suffixMatch")
    def suffix_match(self) -> Optional[builtins.str]:
        """
        The value of the header must end with the contents of suffixMatch.
        """
        return pulumi.get(self, "suffix_match")


@pulumi.output_type
class EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleQueryParameterMatch(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exactMatch":
            suggest = "exact_match"
        elif key == "presentMatch":
            suggest = "present_match"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleQueryParameterMatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleQueryParameterMatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleQueryParameterMatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 exact_match: Optional[builtins.str] = None,
                 present_match: Optional[builtins.bool] = None):
        """
        :param builtins.str name: The name of the query parameter to match. The query parameter must exist in the request, in the absence of which the request match fails.
        :param builtins.str exact_match: The queryParameterMatch matches if the value of the parameter exactly matches the contents of exactMatch.
        :param builtins.bool present_match: Specifies that the queryParameterMatch matches if the request contains the query parameter, irrespective of whether the parameter has a value or not.
        """
        pulumi.set(__self__, "name", name)
        if exact_match is not None:
            pulumi.set(__self__, "exact_match", exact_match)
        if present_match is not None:
            pulumi.set(__self__, "present_match", present_match)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the query parameter to match. The query parameter must exist in the request, in the absence of which the request match fails.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="exactMatch")
    def exact_match(self) -> Optional[builtins.str]:
        """
        The queryParameterMatch matches if the value of the parameter exactly matches the contents of exactMatch.
        """
        return pulumi.get(self, "exact_match")

    @property
    @pulumi.getter(name="presentMatch")
    def present_match(self) -> Optional[builtins.bool]:
        """
        Specifies that the queryParameterMatch matches if the request contains the query parameter, irrespective of whether the parameter has a value or not.
        """
        return pulumi.get(self, "present_match")


@pulumi.output_type
class EdgeCacheServiceRoutingPathMatcherRouteRuleRouteAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cdnPolicy":
            suggest = "cdn_policy"
        elif key == "compressionMode":
            suggest = "compression_mode"
        elif key == "corsPolicy":
            suggest = "cors_policy"
        elif key == "urlRewrite":
            suggest = "url_rewrite"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdgeCacheServiceRoutingPathMatcherRouteRuleRouteAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdgeCacheServiceRoutingPathMatcherRouteRuleRouteAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdgeCacheServiceRoutingPathMatcherRouteRuleRouteAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cdn_policy: Optional['outputs.EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicy'] = None,
                 compression_mode: Optional[builtins.str] = None,
                 cors_policy: Optional['outputs.EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCorsPolicy'] = None,
                 url_rewrite: Optional['outputs.EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionUrlRewrite'] = None):
        """
        :param 'EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyArgs' cdn_policy: The policy to use for defining caching and signed request behaviour for requests that match this route.
               Structure is documented below.
        :param builtins.str compression_mode: Setting the compression mode to automatic enables dynamic compression for every eligible response.
               When dynamic compression is enabled, it is recommended to also set a cache policy to maximize efficiency.
               Possible values are: `DISABLED`, `AUTOMATIC`.
        :param 'EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCorsPolicyArgs' cors_policy: CORSPolicy defines Cross-Origin-Resource-Sharing configuration, including which CORS response headers will be set.
               Structure is documented below.
        :param 'EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionUrlRewriteArgs' url_rewrite: The URL rewrite configuration for requests that match this route.
               Structure is documented below.
        """
        if cdn_policy is not None:
            pulumi.set(__self__, "cdn_policy", cdn_policy)
        if compression_mode is not None:
            pulumi.set(__self__, "compression_mode", compression_mode)
        if cors_policy is not None:
            pulumi.set(__self__, "cors_policy", cors_policy)
        if url_rewrite is not None:
            pulumi.set(__self__, "url_rewrite", url_rewrite)

    @property
    @pulumi.getter(name="cdnPolicy")
    def cdn_policy(self) -> Optional['outputs.EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicy']:
        """
        The policy to use for defining caching and signed request behaviour for requests that match this route.
        Structure is documented below.
        """
        return pulumi.get(self, "cdn_policy")

    @property
    @pulumi.getter(name="compressionMode")
    def compression_mode(self) -> Optional[builtins.str]:
        """
        Setting the compression mode to automatic enables dynamic compression for every eligible response.
        When dynamic compression is enabled, it is recommended to also set a cache policy to maximize efficiency.
        Possible values are: `DISABLED`, `AUTOMATIC`.
        """
        return pulumi.get(self, "compression_mode")

    @property
    @pulumi.getter(name="corsPolicy")
    def cors_policy(self) -> Optional['outputs.EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCorsPolicy']:
        """
        CORSPolicy defines Cross-Origin-Resource-Sharing configuration, including which CORS response headers will be set.
        Structure is documented below.
        """
        return pulumi.get(self, "cors_policy")

    @property
    @pulumi.getter(name="urlRewrite")
    def url_rewrite(self) -> Optional['outputs.EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionUrlRewrite']:
        """
        The URL rewrite configuration for requests that match this route.
        Structure is documented below.
        """
        return pulumi.get(self, "url_rewrite")


@pulumi.output_type
class EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "addSignatures":
            suggest = "add_signatures"
        elif key == "cacheKeyPolicy":
            suggest = "cache_key_policy"
        elif key == "cacheMode":
            suggest = "cache_mode"
        elif key == "clientTtl":
            suggest = "client_ttl"
        elif key == "defaultTtl":
            suggest = "default_ttl"
        elif key == "maxTtl":
            suggest = "max_ttl"
        elif key == "negativeCaching":
            suggest = "negative_caching"
        elif key == "negativeCachingPolicy":
            suggest = "negative_caching_policy"
        elif key == "signedRequestKeyset":
            suggest = "signed_request_keyset"
        elif key == "signedRequestMaximumExpirationTtl":
            suggest = "signed_request_maximum_expiration_ttl"
        elif key == "signedRequestMode":
            suggest = "signed_request_mode"
        elif key == "signedTokenOptions":
            suggest = "signed_token_options"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 add_signatures: Optional['outputs.EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyAddSignatures'] = None,
                 cache_key_policy: Optional['outputs.EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyCacheKeyPolicy'] = None,
                 cache_mode: Optional[builtins.str] = None,
                 client_ttl: Optional[builtins.str] = None,
                 default_ttl: Optional[builtins.str] = None,
                 max_ttl: Optional[builtins.str] = None,
                 negative_caching: Optional[builtins.bool] = None,
                 negative_caching_policy: Optional[Mapping[str, builtins.str]] = None,
                 signed_request_keyset: Optional[builtins.str] = None,
                 signed_request_maximum_expiration_ttl: Optional[builtins.str] = None,
                 signed_request_mode: Optional[builtins.str] = None,
                 signed_token_options: Optional['outputs.EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicySignedTokenOptions'] = None):
        """
        :param 'EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyAddSignaturesArgs' add_signatures: Enable signature generation or propagation on this route.
               This field may only be specified when signedRequestMode is set to REQUIRE_TOKENS.
               Structure is documented below.
        :param 'EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyCacheKeyPolicyArgs' cache_key_policy: Defines the request parameters that contribute to the cache key.
               Structure is documented below.
        :param builtins.str cache_mode: Cache modes allow users to control the behaviour of the cache, what content it should cache automatically, whether to respect origin headers, or whether to unconditionally cache all responses.
               For all cache modes, Cache-Control headers will be passed to the client. Use clientTtl to override what is sent to the client.
               Possible values are: `CACHE_ALL_STATIC`, `USE_ORIGIN_HEADERS`, `FORCE_CACHE_ALL`, `BYPASS_CACHE`.
        :param builtins.str client_ttl: Specifies a separate client (e.g. browser client) TTL, separate from the TTL used by the edge caches. Leaving this empty will use the same cache TTL for both the CDN and the client-facing response.
               - The TTL must be > 0 and <= 86400s (1 day)
               - The clientTtl cannot be larger than the defaultTtl (if set)
               - Fractions of a second are not allowed.
               Omit this field to use the defaultTtl, or the max-age set by the origin, as the client-facing TTL.
               When the cache mode is set to "USE_ORIGIN_HEADERS" or "BYPASS_CACHE", you must omit this field.
               A duration in seconds terminated by 's'. Example: "3s".
        :param builtins.str default_ttl: Specifies the default TTL for cached content served by this origin for responses that do not have an existing valid TTL (max-age or s-max-age).
               Defaults to 3600s (1 hour).
               - The TTL must be >= 0 and <= 31,536,000 seconds (1 year)
               - Setting a TTL of "0" means "always revalidate" (equivalent to must-revalidate)
               - The value of defaultTTL cannot be set to a value greater than that of maxTTL.
               - Fractions of a second are not allowed.
               - When the cacheMode is set to FORCE_CACHE_ALL, the defaultTTL will overwrite the TTL set in all responses.
               Note that infrequently accessed objects may be evicted from the cache before the defined TTL. Objects that expire will be revalidated with the origin.
               When the cache mode is set to "USE_ORIGIN_HEADERS" or "BYPASS_CACHE", you must omit this field.
               A duration in seconds terminated by 's'. Example: "3s".
        :param builtins.str max_ttl: Specifies the maximum allowed TTL for cached content served by this origin.
               Defaults to 86400s (1 day).
               Cache directives that attempt to set a max-age or s-maxage higher than this, or an Expires header more than maxTtl seconds in the future will be capped at the value of maxTTL, as if it were the value of an s-maxage Cache-Control directive.
               - The TTL must be >= 0 and <= 31,536,000 seconds (1 year)
               - Setting a TTL of "0" means "always revalidate"
               - The value of maxTtl must be equal to or greater than defaultTtl.
               - Fractions of a second are not allowed.
               When the cache mode is set to "USE_ORIGIN_HEADERS", "FORCE_CACHE_ALL", or "BYPASS_CACHE", you must omit this field.
               A duration in seconds terminated by 's'. Example: "3s".
        :param builtins.bool negative_caching: Negative caching allows per-status code TTLs to be set, in order to apply fine-grained caching for common errors or redirects. This can reduce the load on your origin and improve end-user experience by reducing response latency.
               By default, the CDNPolicy will apply the following default TTLs to these status codes:
               - HTTP 300 (Multiple Choice), 301, 308 (Permanent Redirects): 10m
               - HTTP 404 (Not Found), 410 (Gone), 451 (Unavailable For Legal Reasons): 120s
               - HTTP 405 (Method Not Found), 414 (URI Too Long), 501 (Not Implemented): 60s
               These defaults can be overridden in negativeCachingPolicy
        :param Mapping[str, builtins.str] negative_caching_policy: Sets a cache TTL for the specified HTTP status code. negativeCaching must be enabled to configure negativeCachingPolicy.
               - Omitting the policy and leaving negativeCaching enabled will use the default TTLs for each status code, defined in negativeCaching.
               - TTLs must be >= 0 (where 0 is "always revalidate") and <= 86400s (1 day)
               Note that when specifying an explicit negativeCachingPolicy, you should take care to specify a cache TTL for all response codes that you wish to cache. The CDNPolicy will not apply any default negative caching when a policy exists.
        :param builtins.str signed_request_keyset: The EdgeCacheKeyset containing the set of public keys used to validate signed requests at the edge.
        :param builtins.str signed_request_maximum_expiration_ttl: Limit how far into the future the expiration time of a signed request may be.
               When set, a signed request is rejected if its expiration time is later than now + signedRequestMaximumExpirationTtl, where now is the time at which the signed request is first handled by the CDN.
               - The TTL must be > 0.
               - Fractions of a second are not allowed.
               By default, signedRequestMaximumExpirationTtl is not set and the expiration time of a signed request may be arbitrarily far into future.
        :param builtins.str signed_request_mode: Whether to enforce signed requests. The default value is DISABLED, which means all content is public, and does not authorize access.
               You must also set a signedRequestKeyset to enable signed requests.
               When set to REQUIRE_SIGNATURES, all matching requests will have their signature validated. Requests that were not signed with the corresponding private key, or that are otherwise invalid (expired, do not match the signature, IP address, or header) will be rejected with a HTTP 403 and (if enabled) logged.
               Possible values are: `DISABLED`, `REQUIRE_SIGNATURES`, `REQUIRE_TOKENS`.
        :param 'EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicySignedTokenOptionsArgs' signed_token_options: Additional options for signed tokens.
               signedTokenOptions may only be specified when signedRequestMode is REQUIRE_TOKENS.
               Structure is documented below.
        """
        if add_signatures is not None:
            pulumi.set(__self__, "add_signatures", add_signatures)
        if cache_key_policy is not None:
            pulumi.set(__self__, "cache_key_policy", cache_key_policy)
        if cache_mode is not None:
            pulumi.set(__self__, "cache_mode", cache_mode)
        if client_ttl is not None:
            pulumi.set(__self__, "client_ttl", client_ttl)
        if default_ttl is not None:
            pulumi.set(__self__, "default_ttl", default_ttl)
        if max_ttl is not None:
            pulumi.set(__self__, "max_ttl", max_ttl)
        if negative_caching is not None:
            pulumi.set(__self__, "negative_caching", negative_caching)
        if negative_caching_policy is not None:
            pulumi.set(__self__, "negative_caching_policy", negative_caching_policy)
        if signed_request_keyset is not None:
            pulumi.set(__self__, "signed_request_keyset", signed_request_keyset)
        if signed_request_maximum_expiration_ttl is not None:
            pulumi.set(__self__, "signed_request_maximum_expiration_ttl", signed_request_maximum_expiration_ttl)
        if signed_request_mode is not None:
            pulumi.set(__self__, "signed_request_mode", signed_request_mode)
        if signed_token_options is not None:
            pulumi.set(__self__, "signed_token_options", signed_token_options)

    @property
    @pulumi.getter(name="addSignatures")
    def add_signatures(self) -> Optional['outputs.EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyAddSignatures']:
        """
        Enable signature generation or propagation on this route.
        This field may only be specified when signedRequestMode is set to REQUIRE_TOKENS.
        Structure is documented below.
        """
        return pulumi.get(self, "add_signatures")

    @property
    @pulumi.getter(name="cacheKeyPolicy")
    def cache_key_policy(self) -> Optional['outputs.EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyCacheKeyPolicy']:
        """
        Defines the request parameters that contribute to the cache key.
        Structure is documented below.
        """
        return pulumi.get(self, "cache_key_policy")

    @property
    @pulumi.getter(name="cacheMode")
    def cache_mode(self) -> Optional[builtins.str]:
        """
        Cache modes allow users to control the behaviour of the cache, what content it should cache automatically, whether to respect origin headers, or whether to unconditionally cache all responses.
        For all cache modes, Cache-Control headers will be passed to the client. Use clientTtl to override what is sent to the client.
        Possible values are: `CACHE_ALL_STATIC`, `USE_ORIGIN_HEADERS`, `FORCE_CACHE_ALL`, `BYPASS_CACHE`.
        """
        return pulumi.get(self, "cache_mode")

    @property
    @pulumi.getter(name="clientTtl")
    def client_ttl(self) -> Optional[builtins.str]:
        """
        Specifies a separate client (e.g. browser client) TTL, separate from the TTL used by the edge caches. Leaving this empty will use the same cache TTL for both the CDN and the client-facing response.
        - The TTL must be > 0 and <= 86400s (1 day)
        - The clientTtl cannot be larger than the defaultTtl (if set)
        - Fractions of a second are not allowed.
        Omit this field to use the defaultTtl, or the max-age set by the origin, as the client-facing TTL.
        When the cache mode is set to "USE_ORIGIN_HEADERS" or "BYPASS_CACHE", you must omit this field.
        A duration in seconds terminated by 's'. Example: "3s".
        """
        return pulumi.get(self, "client_ttl")

    @property
    @pulumi.getter(name="defaultTtl")
    def default_ttl(self) -> Optional[builtins.str]:
        """
        Specifies the default TTL for cached content served by this origin for responses that do not have an existing valid TTL (max-age or s-max-age).
        Defaults to 3600s (1 hour).
        - The TTL must be >= 0 and <= 31,536,000 seconds (1 year)
        - Setting a TTL of "0" means "always revalidate" (equivalent to must-revalidate)
        - The value of defaultTTL cannot be set to a value greater than that of maxTTL.
        - Fractions of a second are not allowed.
        - When the cacheMode is set to FORCE_CACHE_ALL, the defaultTTL will overwrite the TTL set in all responses.
        Note that infrequently accessed objects may be evicted from the cache before the defined TTL. Objects that expire will be revalidated with the origin.
        When the cache mode is set to "USE_ORIGIN_HEADERS" or "BYPASS_CACHE", you must omit this field.
        A duration in seconds terminated by 's'. Example: "3s".
        """
        return pulumi.get(self, "default_ttl")

    @property
    @pulumi.getter(name="maxTtl")
    def max_ttl(self) -> Optional[builtins.str]:
        """
        Specifies the maximum allowed TTL for cached content served by this origin.
        Defaults to 86400s (1 day).
        Cache directives that attempt to set a max-age or s-maxage higher than this, or an Expires header more than maxTtl seconds in the future will be capped at the value of maxTTL, as if it were the value of an s-maxage Cache-Control directive.
        - The TTL must be >= 0 and <= 31,536,000 seconds (1 year)
        - Setting a TTL of "0" means "always revalidate"
        - The value of maxTtl must be equal to or greater than defaultTtl.
        - Fractions of a second are not allowed.
        When the cache mode is set to "USE_ORIGIN_HEADERS", "FORCE_CACHE_ALL", or "BYPASS_CACHE", you must omit this field.
        A duration in seconds terminated by 's'. Example: "3s".
        """
        return pulumi.get(self, "max_ttl")

    @property
    @pulumi.getter(name="negativeCaching")
    def negative_caching(self) -> Optional[builtins.bool]:
        """
        Negative caching allows per-status code TTLs to be set, in order to apply fine-grained caching for common errors or redirects. This can reduce the load on your origin and improve end-user experience by reducing response latency.
        By default, the CDNPolicy will apply the following default TTLs to these status codes:
        - HTTP 300 (Multiple Choice), 301, 308 (Permanent Redirects): 10m
        - HTTP 404 (Not Found), 410 (Gone), 451 (Unavailable For Legal Reasons): 120s
        - HTTP 405 (Method Not Found), 414 (URI Too Long), 501 (Not Implemented): 60s
        These defaults can be overridden in negativeCachingPolicy
        """
        return pulumi.get(self, "negative_caching")

    @property
    @pulumi.getter(name="negativeCachingPolicy")
    def negative_caching_policy(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Sets a cache TTL for the specified HTTP status code. negativeCaching must be enabled to configure negativeCachingPolicy.
        - Omitting the policy and leaving negativeCaching enabled will use the default TTLs for each status code, defined in negativeCaching.
        - TTLs must be >= 0 (where 0 is "always revalidate") and <= 86400s (1 day)
        Note that when specifying an explicit negativeCachingPolicy, you should take care to specify a cache TTL for all response codes that you wish to cache. The CDNPolicy will not apply any default negative caching when a policy exists.
        """
        return pulumi.get(self, "negative_caching_policy")

    @property
    @pulumi.getter(name="signedRequestKeyset")
    def signed_request_keyset(self) -> Optional[builtins.str]:
        """
        The EdgeCacheKeyset containing the set of public keys used to validate signed requests at the edge.
        """
        return pulumi.get(self, "signed_request_keyset")

    @property
    @pulumi.getter(name="signedRequestMaximumExpirationTtl")
    def signed_request_maximum_expiration_ttl(self) -> Optional[builtins.str]:
        """
        Limit how far into the future the expiration time of a signed request may be.
        When set, a signed request is rejected if its expiration time is later than now + signedRequestMaximumExpirationTtl, where now is the time at which the signed request is first handled by the CDN.
        - The TTL must be > 0.
        - Fractions of a second are not allowed.
        By default, signedRequestMaximumExpirationTtl is not set and the expiration time of a signed request may be arbitrarily far into future.
        """
        return pulumi.get(self, "signed_request_maximum_expiration_ttl")

    @property
    @pulumi.getter(name="signedRequestMode")
    def signed_request_mode(self) -> Optional[builtins.str]:
        """
        Whether to enforce signed requests. The default value is DISABLED, which means all content is public, and does not authorize access.
        You must also set a signedRequestKeyset to enable signed requests.
        When set to REQUIRE_SIGNATURES, all matching requests will have their signature validated. Requests that were not signed with the corresponding private key, or that are otherwise invalid (expired, do not match the signature, IP address, or header) will be rejected with a HTTP 403 and (if enabled) logged.
        Possible values are: `DISABLED`, `REQUIRE_SIGNATURES`, `REQUIRE_TOKENS`.
        """
        return pulumi.get(self, "signed_request_mode")

    @property
    @pulumi.getter(name="signedTokenOptions")
    def signed_token_options(self) -> Optional['outputs.EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicySignedTokenOptions']:
        """
        Additional options for signed tokens.
        signedTokenOptions may only be specified when signedRequestMode is REQUIRE_TOKENS.
        Structure is documented below.
        """
        return pulumi.get(self, "signed_token_options")


@pulumi.output_type
class EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyAddSignatures(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "copiedParameters":
            suggest = "copied_parameters"
        elif key == "tokenQueryParameter":
            suggest = "token_query_parameter"
        elif key == "tokenTtl":
            suggest = "token_ttl"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyAddSignatures. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyAddSignatures.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyAddSignatures.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 actions: builtins.str,
                 copied_parameters: Optional[Sequence[builtins.str]] = None,
                 keyset: Optional[builtins.str] = None,
                 token_query_parameter: Optional[builtins.str] = None,
                 token_ttl: Optional[builtins.str] = None):
        """
        :param builtins.str actions: The actions to take to add signatures to responses.
               Each value may be one of: `GENERATE_COOKIE`, `GENERATE_TOKEN_HLS_COOKIELESS`, `PROPAGATE_TOKEN_HLS_COOKIELESS`.
        :param Sequence[builtins.str] copied_parameters: The parameters to copy from the verified token to the generated token.
               Only the following parameters may be copied:
               * `PathGlobs`
        :param builtins.str keyset: The keyset to use for signature generation.
               The following are both valid paths to an EdgeCacheKeyset resource:
               * `projects/project/locations/global/edgeCacheKeysets/yourKeyset`
               * `yourKeyset`
               This must be specified when the GENERATE_COOKIE or GENERATE_TOKEN_HLS_COOKIELESS actions are specified.  This field may not be specified otherwise.
        :param builtins.str token_query_parameter: The query parameter in which to put the generated token.
               If not specified, defaults to `edge-cache-token`.
               If specified, the name must be 1-64 characters long and match the regular expression `a-zA-Z*` which means the first character must be a letter, and all following characters must be a dash, underscore, letter or digit.
               This field may only be set when the GENERATE_TOKEN_HLS_COOKIELESS or PROPAGATE_TOKEN_HLS_COOKIELESS actions are specified.
        :param builtins.str token_ttl: The duration the token is valid starting from the moment the token is first generated.
               Defaults to `86400s` (1 day).
               The TTL must be >= 0 and <= 604,800 seconds (1 week).
               This field may only be specified when the GENERATE_COOKIE or GENERATE_TOKEN_HLS_COOKIELESS actions are specified.
               A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        pulumi.set(__self__, "actions", actions)
        if copied_parameters is not None:
            pulumi.set(__self__, "copied_parameters", copied_parameters)
        if keyset is not None:
            pulumi.set(__self__, "keyset", keyset)
        if token_query_parameter is not None:
            pulumi.set(__self__, "token_query_parameter", token_query_parameter)
        if token_ttl is not None:
            pulumi.set(__self__, "token_ttl", token_ttl)

    @property
    @pulumi.getter
    def actions(self) -> builtins.str:
        """
        The actions to take to add signatures to responses.
        Each value may be one of: `GENERATE_COOKIE`, `GENERATE_TOKEN_HLS_COOKIELESS`, `PROPAGATE_TOKEN_HLS_COOKIELESS`.
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter(name="copiedParameters")
    def copied_parameters(self) -> Optional[Sequence[builtins.str]]:
        """
        The parameters to copy from the verified token to the generated token.
        Only the following parameters may be copied:
        * `PathGlobs`
        """
        return pulumi.get(self, "copied_parameters")

    @property
    @pulumi.getter
    def keyset(self) -> Optional[builtins.str]:
        """
        The keyset to use for signature generation.
        The following are both valid paths to an EdgeCacheKeyset resource:
        * `projects/project/locations/global/edgeCacheKeysets/yourKeyset`
        * `yourKeyset`
        This must be specified when the GENERATE_COOKIE or GENERATE_TOKEN_HLS_COOKIELESS actions are specified.  This field may not be specified otherwise.
        """
        return pulumi.get(self, "keyset")

    @property
    @pulumi.getter(name="tokenQueryParameter")
    def token_query_parameter(self) -> Optional[builtins.str]:
        """
        The query parameter in which to put the generated token.
        If not specified, defaults to `edge-cache-token`.
        If specified, the name must be 1-64 characters long and match the regular expression `a-zA-Z*` which means the first character must be a letter, and all following characters must be a dash, underscore, letter or digit.
        This field may only be set when the GENERATE_TOKEN_HLS_COOKIELESS or PROPAGATE_TOKEN_HLS_COOKIELESS actions are specified.
        """
        return pulumi.get(self, "token_query_parameter")

    @property
    @pulumi.getter(name="tokenTtl")
    def token_ttl(self) -> Optional[builtins.str]:
        """
        The duration the token is valid starting from the moment the token is first generated.
        Defaults to `86400s` (1 day).
        The TTL must be >= 0 and <= 604,800 seconds (1 week).
        This field may only be specified when the GENERATE_COOKIE or GENERATE_TOKEN_HLS_COOKIELESS actions are specified.
        A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "token_ttl")


@pulumi.output_type
class EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyCacheKeyPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "excludeHost":
            suggest = "exclude_host"
        elif key == "excludeQueryString":
            suggest = "exclude_query_string"
        elif key == "excludedQueryParameters":
            suggest = "excluded_query_parameters"
        elif key == "includeProtocol":
            suggest = "include_protocol"
        elif key == "includedCookieNames":
            suggest = "included_cookie_names"
        elif key == "includedHeaderNames":
            suggest = "included_header_names"
        elif key == "includedQueryParameters":
            suggest = "included_query_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyCacheKeyPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyCacheKeyPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyCacheKeyPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exclude_host: Optional[builtins.bool] = None,
                 exclude_query_string: Optional[builtins.bool] = None,
                 excluded_query_parameters: Optional[Sequence[builtins.str]] = None,
                 include_protocol: Optional[builtins.bool] = None,
                 included_cookie_names: Optional[Sequence[builtins.str]] = None,
                 included_header_names: Optional[Sequence[builtins.str]] = None,
                 included_query_parameters: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.bool exclude_host: If true, requests to different hosts will be cached separately.
               Note: this should only be enabled if hosts share the same origin and content. Removing the host from the cache key may inadvertently result in different objects being cached than intended, depending on which route the first user matched.
        :param builtins.bool exclude_query_string: If true, exclude query string parameters from the cache key
               If false (the default), include the query string parameters in
               the cache key according to includeQueryParameters and
               excludeQueryParameters. If neither includeQueryParameters nor
               excludeQueryParameters is set, the entire query string will be
               included.
        :param Sequence[builtins.str] excluded_query_parameters: Names of query string parameters to exclude from cache keys. All other parameters will be included.
               Either specify includedQueryParameters or excludedQueryParameters, not both. '&' and '=' will be percent encoded and not treated as delimiters.
        :param builtins.bool include_protocol: If true, http and https requests will be cached separately.
        :param Sequence[builtins.str] included_cookie_names: Names of Cookies to include in cache keys.  The cookie name and cookie value of each cookie named will be used as part of the cache key.
               Cookie names:
               - must be valid RFC 6265 "cookie-name" tokens
               - are case sensitive
               - cannot start with "Edge-Cache-" (case insensitive)
               Note that specifying several cookies, and/or cookies that have a large range of values (e.g., per-user) will dramatically impact the cache hit rate, and may result in a higher eviction rate and reduced performance.
               You may specify up to three cookie names.
        :param Sequence[builtins.str] included_header_names: Names of HTTP request headers to include in cache keys. The value of the header field will be used as part of the cache key.
               - Header names must be valid HTTP RFC 7230 header field values.
               - Header field names are case insensitive
               - To include the HTTP method, use ":method"
               Note that specifying several headers, and/or headers that have a large range of values (e.g. per-user) will dramatically impact the cache hit rate, and may result in a higher eviction rate and reduced performance.
        :param Sequence[builtins.str] included_query_parameters: Names of query string parameters to include in cache keys. All other parameters will be excluded.
               Either specify includedQueryParameters or excludedQueryParameters, not both. '&' and '=' will be percent encoded and not treated as delimiters.
        """
        if exclude_host is not None:
            pulumi.set(__self__, "exclude_host", exclude_host)
        if exclude_query_string is not None:
            pulumi.set(__self__, "exclude_query_string", exclude_query_string)
        if excluded_query_parameters is not None:
            pulumi.set(__self__, "excluded_query_parameters", excluded_query_parameters)
        if include_protocol is not None:
            pulumi.set(__self__, "include_protocol", include_protocol)
        if included_cookie_names is not None:
            pulumi.set(__self__, "included_cookie_names", included_cookie_names)
        if included_header_names is not None:
            pulumi.set(__self__, "included_header_names", included_header_names)
        if included_query_parameters is not None:
            pulumi.set(__self__, "included_query_parameters", included_query_parameters)

    @property
    @pulumi.getter(name="excludeHost")
    def exclude_host(self) -> Optional[builtins.bool]:
        """
        If true, requests to different hosts will be cached separately.
        Note: this should only be enabled if hosts share the same origin and content. Removing the host from the cache key may inadvertently result in different objects being cached than intended, depending on which route the first user matched.
        """
        return pulumi.get(self, "exclude_host")

    @property
    @pulumi.getter(name="excludeQueryString")
    def exclude_query_string(self) -> Optional[builtins.bool]:
        """
        If true, exclude query string parameters from the cache key
        If false (the default), include the query string parameters in
        the cache key according to includeQueryParameters and
        excludeQueryParameters. If neither includeQueryParameters nor
        excludeQueryParameters is set, the entire query string will be
        included.
        """
        return pulumi.get(self, "exclude_query_string")

    @property
    @pulumi.getter(name="excludedQueryParameters")
    def excluded_query_parameters(self) -> Optional[Sequence[builtins.str]]:
        """
        Names of query string parameters to exclude from cache keys. All other parameters will be included.
        Either specify includedQueryParameters or excludedQueryParameters, not both. '&' and '=' will be percent encoded and not treated as delimiters.
        """
        return pulumi.get(self, "excluded_query_parameters")

    @property
    @pulumi.getter(name="includeProtocol")
    def include_protocol(self) -> Optional[builtins.bool]:
        """
        If true, http and https requests will be cached separately.
        """
        return pulumi.get(self, "include_protocol")

    @property
    @pulumi.getter(name="includedCookieNames")
    def included_cookie_names(self) -> Optional[Sequence[builtins.str]]:
        """
        Names of Cookies to include in cache keys.  The cookie name and cookie value of each cookie named will be used as part of the cache key.
        Cookie names:
        - must be valid RFC 6265 "cookie-name" tokens
        - are case sensitive
        - cannot start with "Edge-Cache-" (case insensitive)
        Note that specifying several cookies, and/or cookies that have a large range of values (e.g., per-user) will dramatically impact the cache hit rate, and may result in a higher eviction rate and reduced performance.
        You may specify up to three cookie names.
        """
        return pulumi.get(self, "included_cookie_names")

    @property
    @pulumi.getter(name="includedHeaderNames")
    def included_header_names(self) -> Optional[Sequence[builtins.str]]:
        """
        Names of HTTP request headers to include in cache keys. The value of the header field will be used as part of the cache key.
        - Header names must be valid HTTP RFC 7230 header field values.
        - Header field names are case insensitive
        - To include the HTTP method, use ":method"
        Note that specifying several headers, and/or headers that have a large range of values (e.g. per-user) will dramatically impact the cache hit rate, and may result in a higher eviction rate and reduced performance.
        """
        return pulumi.get(self, "included_header_names")

    @property
    @pulumi.getter(name="includedQueryParameters")
    def included_query_parameters(self) -> Optional[Sequence[builtins.str]]:
        """
        Names of query string parameters to include in cache keys. All other parameters will be excluded.
        Either specify includedQueryParameters or excludedQueryParameters, not both. '&' and '=' will be percent encoded and not treated as delimiters.
        """
        return pulumi.get(self, "included_query_parameters")


@pulumi.output_type
class EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicySignedTokenOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedSignatureAlgorithms":
            suggest = "allowed_signature_algorithms"
        elif key == "tokenQueryParameter":
            suggest = "token_query_parameter"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicySignedTokenOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicySignedTokenOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicySignedTokenOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_signature_algorithms: Optional[Sequence[builtins.str]] = None,
                 token_query_parameter: Optional[builtins.str] = None):
        """
        :param Sequence[builtins.str] allowed_signature_algorithms: The allowed signature algorithms to use.
               Defaults to using only ED25519.
               You may specify up to 3 signature algorithms to use.
               Each value may be one of: `ED25519`, `HMAC_SHA_256`, `HMAC_SHA1`.
        :param builtins.str token_query_parameter: The query parameter in which to find the token.
               The name must be 1-64 characters long and match the regular expression `a-zA-Z*` which means the first character must be a letter, and all following characters must be a dash, underscore, letter or digit.
               Defaults to `edge-cache-token`.
        """
        if allowed_signature_algorithms is not None:
            pulumi.set(__self__, "allowed_signature_algorithms", allowed_signature_algorithms)
        if token_query_parameter is not None:
            pulumi.set(__self__, "token_query_parameter", token_query_parameter)

    @property
    @pulumi.getter(name="allowedSignatureAlgorithms")
    def allowed_signature_algorithms(self) -> Optional[Sequence[builtins.str]]:
        """
        The allowed signature algorithms to use.
        Defaults to using only ED25519.
        You may specify up to 3 signature algorithms to use.
        Each value may be one of: `ED25519`, `HMAC_SHA_256`, `HMAC_SHA1`.
        """
        return pulumi.get(self, "allowed_signature_algorithms")

    @property
    @pulumi.getter(name="tokenQueryParameter")
    def token_query_parameter(self) -> Optional[builtins.str]:
        """
        The query parameter in which to find the token.
        The name must be 1-64 characters long and match the regular expression `a-zA-Z*` which means the first character must be a letter, and all following characters must be a dash, underscore, letter or digit.
        Defaults to `edge-cache-token`.
        """
        return pulumi.get(self, "token_query_parameter")


@pulumi.output_type
class EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCorsPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxAge":
            suggest = "max_age"
        elif key == "allowCredentials":
            suggest = "allow_credentials"
        elif key == "allowHeaders":
            suggest = "allow_headers"
        elif key == "allowMethods":
            suggest = "allow_methods"
        elif key == "allowOrigins":
            suggest = "allow_origins"
        elif key == "exposeHeaders":
            suggest = "expose_headers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCorsPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCorsPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCorsPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_age: builtins.str,
                 allow_credentials: Optional[builtins.bool] = None,
                 allow_headers: Optional[Sequence[builtins.str]] = None,
                 allow_methods: Optional[Sequence[builtins.str]] = None,
                 allow_origins: Optional[Sequence[builtins.str]] = None,
                 disabled: Optional[builtins.bool] = None,
                 expose_headers: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str max_age: Specifies how long results of a preflight request can be cached by a client in seconds. Note that many browser clients enforce a maximum TTL of 600s (10 minutes).
               - Setting the value to -1 forces a pre-flight check for all requests (not recommended)
               - A maximum TTL of 86400s can be set, but note that (as above) some clients may force pre-flight checks at a more regular interval.
               - This translates to the Access-Control-Max-Age header.
               A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        :param builtins.bool allow_credentials: In response to a preflight request, setting this to true indicates that the actual request can include user credentials.
               This translates to the Access-Control-Allow-Credentials response header.
        :param Sequence[builtins.str] allow_headers: Specifies the content for the Access-Control-Allow-Headers response header.
        :param Sequence[builtins.str] allow_methods: Specifies the content for the Access-Control-Allow-Methods response header.
        :param Sequence[builtins.str] allow_origins: Specifies the list of origins that will be allowed to do CORS requests.
               This translates to the Access-Control-Allow-Origin response header.
        :param builtins.bool disabled: If true, specifies the CORS policy is disabled. The default value is false, which indicates that the CORS policy is in effect.
        :param Sequence[builtins.str] expose_headers: Specifies the content for the Access-Control-Allow-Headers response header.
        """
        pulumi.set(__self__, "max_age", max_age)
        if allow_credentials is not None:
            pulumi.set(__self__, "allow_credentials", allow_credentials)
        if allow_headers is not None:
            pulumi.set(__self__, "allow_headers", allow_headers)
        if allow_methods is not None:
            pulumi.set(__self__, "allow_methods", allow_methods)
        if allow_origins is not None:
            pulumi.set(__self__, "allow_origins", allow_origins)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if expose_headers is not None:
            pulumi.set(__self__, "expose_headers", expose_headers)

    @property
    @pulumi.getter(name="maxAge")
    def max_age(self) -> builtins.str:
        """
        Specifies how long results of a preflight request can be cached by a client in seconds. Note that many browser clients enforce a maximum TTL of 600s (10 minutes).
        - Setting the value to -1 forces a pre-flight check for all requests (not recommended)
        - A maximum TTL of 86400s can be set, but note that (as above) some clients may force pre-flight checks at a more regular interval.
        - This translates to the Access-Control-Max-Age header.
        A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "max_age")

    @property
    @pulumi.getter(name="allowCredentials")
    def allow_credentials(self) -> Optional[builtins.bool]:
        """
        In response to a preflight request, setting this to true indicates that the actual request can include user credentials.
        This translates to the Access-Control-Allow-Credentials response header.
        """
        return pulumi.get(self, "allow_credentials")

    @property
    @pulumi.getter(name="allowHeaders")
    def allow_headers(self) -> Optional[Sequence[builtins.str]]:
        """
        Specifies the content for the Access-Control-Allow-Headers response header.
        """
        return pulumi.get(self, "allow_headers")

    @property
    @pulumi.getter(name="allowMethods")
    def allow_methods(self) -> Optional[Sequence[builtins.str]]:
        """
        Specifies the content for the Access-Control-Allow-Methods response header.
        """
        return pulumi.get(self, "allow_methods")

    @property
    @pulumi.getter(name="allowOrigins")
    def allow_origins(self) -> Optional[Sequence[builtins.str]]:
        """
        Specifies the list of origins that will be allowed to do CORS requests.
        This translates to the Access-Control-Allow-Origin response header.
        """
        return pulumi.get(self, "allow_origins")

    @property
    @pulumi.getter
    def disabled(self) -> Optional[builtins.bool]:
        """
        If true, specifies the CORS policy is disabled. The default value is false, which indicates that the CORS policy is in effect.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter(name="exposeHeaders")
    def expose_headers(self) -> Optional[Sequence[builtins.str]]:
        """
        Specifies the content for the Access-Control-Allow-Headers response header.
        """
        return pulumi.get(self, "expose_headers")


@pulumi.output_type
class EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionUrlRewrite(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hostRewrite":
            suggest = "host_rewrite"
        elif key == "pathPrefixRewrite":
            suggest = "path_prefix_rewrite"
        elif key == "pathTemplateRewrite":
            suggest = "path_template_rewrite"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionUrlRewrite. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionUrlRewrite.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionUrlRewrite.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host_rewrite: Optional[builtins.str] = None,
                 path_prefix_rewrite: Optional[builtins.str] = None,
                 path_template_rewrite: Optional[builtins.str] = None):
        """
        :param builtins.str host_rewrite: Prior to forwarding the request to the selected origin, the request's host header is replaced with contents of hostRewrite.
        :param builtins.str path_prefix_rewrite: Prior to forwarding the request to the selected origin, the matching portion of the request's path is replaced by pathPrefixRewrite.
        :param builtins.str path_template_rewrite: Prior to forwarding the request to the selected origin, if the
               request matched a pathTemplateMatch, the matching portion of the
               request's path is replaced re-written using the pattern specified
               by pathTemplateRewrite.
               pathTemplateRewrite must be between 1 and 255 characters
               (inclusive), must start with a '/', and must only use variables
               captured by the route's pathTemplate matchers.
               pathTemplateRewrite may only be used when all of a route's
               MatchRules specify pathTemplate.
               Only one of pathPrefixRewrite and pathTemplateRewrite may be
               specified.
        """
        if host_rewrite is not None:
            pulumi.set(__self__, "host_rewrite", host_rewrite)
        if path_prefix_rewrite is not None:
            pulumi.set(__self__, "path_prefix_rewrite", path_prefix_rewrite)
        if path_template_rewrite is not None:
            pulumi.set(__self__, "path_template_rewrite", path_template_rewrite)

    @property
    @pulumi.getter(name="hostRewrite")
    def host_rewrite(self) -> Optional[builtins.str]:
        """
        Prior to forwarding the request to the selected origin, the request's host header is replaced with contents of hostRewrite.
        """
        return pulumi.get(self, "host_rewrite")

    @property
    @pulumi.getter(name="pathPrefixRewrite")
    def path_prefix_rewrite(self) -> Optional[builtins.str]:
        """
        Prior to forwarding the request to the selected origin, the matching portion of the request's path is replaced by pathPrefixRewrite.
        """
        return pulumi.get(self, "path_prefix_rewrite")

    @property
    @pulumi.getter(name="pathTemplateRewrite")
    def path_template_rewrite(self) -> Optional[builtins.str]:
        """
        Prior to forwarding the request to the selected origin, if the
        request matched a pathTemplateMatch, the matching portion of the
        request's path is replaced re-written using the pattern specified
        by pathTemplateRewrite.
        pathTemplateRewrite must be between 1 and 255 characters
        (inclusive), must start with a '/', and must only use variables
        captured by the route's pathTemplate matchers.
        pathTemplateRewrite may only be used when all of a route's
        MatchRules specify pathTemplate.
        Only one of pathPrefixRewrite and pathTemplateRewrite may be
        specified.
        """
        return pulumi.get(self, "path_template_rewrite")


@pulumi.output_type
class EdgeCacheServiceRoutingPathMatcherRouteRuleRouteMethods(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedMethods":
            suggest = "allowed_methods"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdgeCacheServiceRoutingPathMatcherRouteRuleRouteMethods. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdgeCacheServiceRoutingPathMatcherRouteRuleRouteMethods.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdgeCacheServiceRoutingPathMatcherRouteRuleRouteMethods.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_methods: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence[builtins.str] allowed_methods: The non-empty set of HTTP methods that are allowed for this route.
               Any combination of "GET", "HEAD", "OPTIONS", "PUT", "POST", "DELETE", and "PATCH".
        """
        if allowed_methods is not None:
            pulumi.set(__self__, "allowed_methods", allowed_methods)

    @property
    @pulumi.getter(name="allowedMethods")
    def allowed_methods(self) -> Optional[Sequence[builtins.str]]:
        """
        The non-empty set of HTTP methods that are allowed for this route.
        Any combination of "GET", "HEAD", "OPTIONS", "PUT", "POST", "DELETE", and "PATCH".
        """
        return pulumi.get(self, "allowed_methods")


@pulumi.output_type
class EdgeCacheServiceRoutingPathMatcherRouteRuleUrlRedirect(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hostRedirect":
            suggest = "host_redirect"
        elif key == "httpsRedirect":
            suggest = "https_redirect"
        elif key == "pathRedirect":
            suggest = "path_redirect"
        elif key == "prefixRedirect":
            suggest = "prefix_redirect"
        elif key == "redirectResponseCode":
            suggest = "redirect_response_code"
        elif key == "stripQuery":
            suggest = "strip_query"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdgeCacheServiceRoutingPathMatcherRouteRuleUrlRedirect. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdgeCacheServiceRoutingPathMatcherRouteRuleUrlRedirect.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdgeCacheServiceRoutingPathMatcherRouteRuleUrlRedirect.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host_redirect: Optional[builtins.str] = None,
                 https_redirect: Optional[builtins.bool] = None,
                 path_redirect: Optional[builtins.str] = None,
                 prefix_redirect: Optional[builtins.str] = None,
                 redirect_response_code: Optional[builtins.str] = None,
                 strip_query: Optional[builtins.bool] = None):
        """
        :param builtins.str host_redirect: The host that will be used in the redirect response instead of the one that was supplied in the request.
        :param builtins.bool https_redirect: If set to true, the URL scheme in the redirected request is set to https. If set to false, the URL scheme of the redirected request will remain the same as that of the request.
               This can only be set if there is at least one (1) edgeSslCertificate set on the service.
        :param builtins.str path_redirect: The path that will be used in the redirect response instead of the one that was supplied in the request.
               pathRedirect cannot be supplied together with prefixRedirect. Supply one alone or neither. If neither is supplied, the path of the original request will be used for the redirect.
               The path value must be between 1 and 1024 characters.
        :param builtins.str prefix_redirect: The prefix that replaces the prefixMatch specified in the routeRule, retaining the remaining portion of the URL before redirecting the request.
               prefixRedirect cannot be supplied together with pathRedirect. Supply one alone or neither. If neither is supplied, the path of the original request will be used for the redirect.
        :param builtins.str redirect_response_code: The HTTP Status code to use for this RedirectAction.
               The supported values are:
               - `MOVED_PERMANENTLY_DEFAULT`, which is the default value and corresponds to 301.
               - `FOUND`, which corresponds to 302.
               - `SEE_OTHER` which corresponds to 303.
               - `TEMPORARY_REDIRECT`, which corresponds to 307. in this case, the request method will be retained.
               - `PERMANENT_REDIRECT`, which corresponds to 308. in this case, the request method will be retained.
               Possible values are: `MOVED_PERMANENTLY_DEFAULT`, `FOUND`, `SEE_OTHER`, `TEMPORARY_REDIRECT`, `PERMANENT_REDIRECT`.
        :param builtins.bool strip_query: If set to true, any accompanying query portion of the original URL is removed prior to redirecting the request. If set to false, the query portion of the original URL is retained.
               
               - - -
        """
        if host_redirect is not None:
            pulumi.set(__self__, "host_redirect", host_redirect)
        if https_redirect is not None:
            pulumi.set(__self__, "https_redirect", https_redirect)
        if path_redirect is not None:
            pulumi.set(__self__, "path_redirect", path_redirect)
        if prefix_redirect is not None:
            pulumi.set(__self__, "prefix_redirect", prefix_redirect)
        if redirect_response_code is not None:
            pulumi.set(__self__, "redirect_response_code", redirect_response_code)
        if strip_query is not None:
            pulumi.set(__self__, "strip_query", strip_query)

    @property
    @pulumi.getter(name="hostRedirect")
    def host_redirect(self) -> Optional[builtins.str]:
        """
        The host that will be used in the redirect response instead of the one that was supplied in the request.
        """
        return pulumi.get(self, "host_redirect")

    @property
    @pulumi.getter(name="httpsRedirect")
    def https_redirect(self) -> Optional[builtins.bool]:
        """
        If set to true, the URL scheme in the redirected request is set to https. If set to false, the URL scheme of the redirected request will remain the same as that of the request.
        This can only be set if there is at least one (1) edgeSslCertificate set on the service.
        """
        return pulumi.get(self, "https_redirect")

    @property
    @pulumi.getter(name="pathRedirect")
    def path_redirect(self) -> Optional[builtins.str]:
        """
        The path that will be used in the redirect response instead of the one that was supplied in the request.
        pathRedirect cannot be supplied together with prefixRedirect. Supply one alone or neither. If neither is supplied, the path of the original request will be used for the redirect.
        The path value must be between 1 and 1024 characters.
        """
        return pulumi.get(self, "path_redirect")

    @property
    @pulumi.getter(name="prefixRedirect")
    def prefix_redirect(self) -> Optional[builtins.str]:
        """
        The prefix that replaces the prefixMatch specified in the routeRule, retaining the remaining portion of the URL before redirecting the request.
        prefixRedirect cannot be supplied together with pathRedirect. Supply one alone or neither. If neither is supplied, the path of the original request will be used for the redirect.
        """
        return pulumi.get(self, "prefix_redirect")

    @property
    @pulumi.getter(name="redirectResponseCode")
    def redirect_response_code(self) -> Optional[builtins.str]:
        """
        The HTTP Status code to use for this RedirectAction.
        The supported values are:
        - `MOVED_PERMANENTLY_DEFAULT`, which is the default value and corresponds to 301.
        - `FOUND`, which corresponds to 302.
        - `SEE_OTHER` which corresponds to 303.
        - `TEMPORARY_REDIRECT`, which corresponds to 307. in this case, the request method will be retained.
        - `PERMANENT_REDIRECT`, which corresponds to 308. in this case, the request method will be retained.
        Possible values are: `MOVED_PERMANENTLY_DEFAULT`, `FOUND`, `SEE_OTHER`, `TEMPORARY_REDIRECT`, `PERMANENT_REDIRECT`.
        """
        return pulumi.get(self, "redirect_response_code")

    @property
    @pulumi.getter(name="stripQuery")
    def strip_query(self) -> Optional[builtins.bool]:
        """
        If set to true, any accompanying query portion of the original URL is removed prior to redirecting the request. If set to false, the query portion of the original URL is retained.

        - - -
        """
        return pulumi.get(self, "strip_query")


@pulumi.output_type
class EndpointPolicyEndpointMatcher(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metadataLabelMatcher":
            suggest = "metadata_label_matcher"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointPolicyEndpointMatcher. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointPolicyEndpointMatcher.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointPolicyEndpointMatcher.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metadata_label_matcher: 'outputs.EndpointPolicyEndpointMatcherMetadataLabelMatcher'):
        """
        :param 'EndpointPolicyEndpointMatcherMetadataLabelMatcherArgs' metadata_label_matcher: The matcher is based on node metadata presented by xDS clients.
               Structure is documented below.
        """
        pulumi.set(__self__, "metadata_label_matcher", metadata_label_matcher)

    @property
    @pulumi.getter(name="metadataLabelMatcher")
    def metadata_label_matcher(self) -> 'outputs.EndpointPolicyEndpointMatcherMetadataLabelMatcher':
        """
        The matcher is based on node metadata presented by xDS clients.
        Structure is documented below.
        """
        return pulumi.get(self, "metadata_label_matcher")


@pulumi.output_type
class EndpointPolicyEndpointMatcherMetadataLabelMatcher(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metadataLabelMatchCriteria":
            suggest = "metadata_label_match_criteria"
        elif key == "metadataLabels":
            suggest = "metadata_labels"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointPolicyEndpointMatcherMetadataLabelMatcher. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointPolicyEndpointMatcherMetadataLabelMatcher.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointPolicyEndpointMatcherMetadataLabelMatcher.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metadata_label_match_criteria: builtins.str,
                 metadata_labels: Optional[Sequence['outputs.EndpointPolicyEndpointMatcherMetadataLabelMatcherMetadataLabel']] = None):
        """
        :param builtins.str metadata_label_match_criteria: Specifies how matching should be done.
               Possible values are: `MATCH_ANY`, `MATCH_ALL`.
        :param Sequence['EndpointPolicyEndpointMatcherMetadataLabelMatcherMetadataLabelArgs'] metadata_labels: The list of label value pairs that must match labels in the provided metadata based on filterMatchCriteria
               Structure is documented below.
        """
        pulumi.set(__self__, "metadata_label_match_criteria", metadata_label_match_criteria)
        if metadata_labels is not None:
            pulumi.set(__self__, "metadata_labels", metadata_labels)

    @property
    @pulumi.getter(name="metadataLabelMatchCriteria")
    def metadata_label_match_criteria(self) -> builtins.str:
        """
        Specifies how matching should be done.
        Possible values are: `MATCH_ANY`, `MATCH_ALL`.
        """
        return pulumi.get(self, "metadata_label_match_criteria")

    @property
    @pulumi.getter(name="metadataLabels")
    def metadata_labels(self) -> Optional[Sequence['outputs.EndpointPolicyEndpointMatcherMetadataLabelMatcherMetadataLabel']]:
        """
        The list of label value pairs that must match labels in the provided metadata based on filterMatchCriteria
        Structure is documented below.
        """
        return pulumi.get(self, "metadata_labels")


@pulumi.output_type
class EndpointPolicyEndpointMatcherMetadataLabelMatcherMetadataLabel(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "labelName":
            suggest = "label_name"
        elif key == "labelValue":
            suggest = "label_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointPolicyEndpointMatcherMetadataLabelMatcherMetadataLabel. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointPolicyEndpointMatcherMetadataLabelMatcherMetadataLabel.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointPolicyEndpointMatcherMetadataLabelMatcherMetadataLabel.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 label_name: builtins.str,
                 label_value: builtins.str):
        """
        :param builtins.str label_name: Required. Label name presented as key in xDS Node Metadata.
        :param builtins.str label_value: Required. Label value presented as value corresponding to the above key, in xDS Node Metadata.
               
               - - -
        """
        pulumi.set(__self__, "label_name", label_name)
        pulumi.set(__self__, "label_value", label_value)

    @property
    @pulumi.getter(name="labelName")
    def label_name(self) -> builtins.str:
        """
        Required. Label name presented as key in xDS Node Metadata.
        """
        return pulumi.get(self, "label_name")

    @property
    @pulumi.getter(name="labelValue")
    def label_value(self) -> builtins.str:
        """
        Required. Label value presented as value corresponding to the above key, in xDS Node Metadata.

        - - -
        """
        return pulumi.get(self, "label_value")


@pulumi.output_type
class EndpointPolicyTrafficPortSelector(dict):
    def __init__(__self__, *,
                 ports: Sequence[builtins.str]):
        """
        :param Sequence[builtins.str] ports: List of ports. Can be port numbers or port range (example, [80-90] specifies all ports from 80 to 90, including 80 and 90) or named ports or * to specify all ports. If the list is empty, all ports are selected.
        """
        pulumi.set(__self__, "ports", ports)

    @property
    @pulumi.getter
    def ports(self) -> Sequence[builtins.str]:
        """
        List of ports. Can be port numbers or port range (example, [80-90] specifies all ports from 80 to 90, including 80 and 90) or named ports or * to specify all ports. If the list is empty, all ports are selected.
        """
        return pulumi.get(self, "ports")


@pulumi.output_type
class GrpcRouteRule(dict):
    def __init__(__self__, *,
                 action: Optional['outputs.GrpcRouteRuleAction'] = None,
                 matches: Optional[Sequence['outputs.GrpcRouteRuleMatch']] = None):
        """
        :param 'GrpcRouteRuleActionArgs' action: Required. A detailed rule defining how to route traffic.
               Structure is documented below.
        :param Sequence['GrpcRouteRuleMatchArgs'] matches: Matches define conditions used for matching the rule against incoming gRPC requests.
               Structure is documented below.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if matches is not None:
            pulumi.set(__self__, "matches", matches)

    @property
    @pulumi.getter
    def action(self) -> Optional['outputs.GrpcRouteRuleAction']:
        """
        Required. A detailed rule defining how to route traffic.
        Structure is documented below.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def matches(self) -> Optional[Sequence['outputs.GrpcRouteRuleMatch']]:
        """
        Matches define conditions used for matching the rule against incoming gRPC requests.
        Structure is documented below.
        """
        return pulumi.get(self, "matches")


@pulumi.output_type
class GrpcRouteRuleAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "faultInjectionPolicy":
            suggest = "fault_injection_policy"
        elif key == "retryPolicy":
            suggest = "retry_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GrpcRouteRuleAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GrpcRouteRuleAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GrpcRouteRuleAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destinations: Optional[Sequence['outputs.GrpcRouteRuleActionDestination']] = None,
                 fault_injection_policy: Optional['outputs.GrpcRouteRuleActionFaultInjectionPolicy'] = None,
                 retry_policy: Optional['outputs.GrpcRouteRuleActionRetryPolicy'] = None,
                 timeout: Optional[builtins.str] = None):
        """
        :param Sequence['GrpcRouteRuleActionDestinationArgs'] destinations: The destination to which traffic should be forwarded.
               Structure is documented below.
        :param 'GrpcRouteRuleActionFaultInjectionPolicyArgs' fault_injection_policy: The specification for fault injection introduced into traffic to test the resiliency of clients to backend service failure.
               Structure is documented below.
        :param 'GrpcRouteRuleActionRetryPolicyArgs' retry_policy: Specifies the retry policy associated with this route.
               Structure is documented below.
        :param builtins.str timeout: Specifies the timeout for selected route.
        """
        if destinations is not None:
            pulumi.set(__self__, "destinations", destinations)
        if fault_injection_policy is not None:
            pulumi.set(__self__, "fault_injection_policy", fault_injection_policy)
        if retry_policy is not None:
            pulumi.set(__self__, "retry_policy", retry_policy)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter
    def destinations(self) -> Optional[Sequence['outputs.GrpcRouteRuleActionDestination']]:
        """
        The destination to which traffic should be forwarded.
        Structure is documented below.
        """
        return pulumi.get(self, "destinations")

    @property
    @pulumi.getter(name="faultInjectionPolicy")
    def fault_injection_policy(self) -> Optional['outputs.GrpcRouteRuleActionFaultInjectionPolicy']:
        """
        The specification for fault injection introduced into traffic to test the resiliency of clients to backend service failure.
        Structure is documented below.
        """
        return pulumi.get(self, "fault_injection_policy")

    @property
    @pulumi.getter(name="retryPolicy")
    def retry_policy(self) -> Optional['outputs.GrpcRouteRuleActionRetryPolicy']:
        """
        Specifies the retry policy associated with this route.
        Structure is documented below.
        """
        return pulumi.get(self, "retry_policy")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[builtins.str]:
        """
        Specifies the timeout for selected route.
        """
        return pulumi.get(self, "timeout")


@pulumi.output_type
class GrpcRouteRuleActionDestination(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serviceName":
            suggest = "service_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GrpcRouteRuleActionDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GrpcRouteRuleActionDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GrpcRouteRuleActionDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 service_name: Optional[builtins.str] = None,
                 weight: Optional[builtins.int] = None):
        """
        :param builtins.str service_name: The URL of a BackendService to route traffic to.
        :param builtins.int weight: Specifies the proportion of requests forwarded to the backend referenced by the serviceName field.
        """
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[builtins.str]:
        """
        The URL of a BackendService to route traffic to.
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter
    def weight(self) -> Optional[builtins.int]:
        """
        Specifies the proportion of requests forwarded to the backend referenced by the serviceName field.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class GrpcRouteRuleActionFaultInjectionPolicy(dict):
    def __init__(__self__, *,
                 abort: Optional['outputs.GrpcRouteRuleActionFaultInjectionPolicyAbort'] = None,
                 delay: Optional['outputs.GrpcRouteRuleActionFaultInjectionPolicyDelay'] = None):
        """
        :param 'GrpcRouteRuleActionFaultInjectionPolicyAbortArgs' abort: Specification of how client requests are aborted as part of fault injection before being sent to a destination.
               Structure is documented below.
        :param 'GrpcRouteRuleActionFaultInjectionPolicyDelayArgs' delay: Specification of how client requests are delayed as part of fault injection before being sent to a destination.
               Structure is documented below.
        """
        if abort is not None:
            pulumi.set(__self__, "abort", abort)
        if delay is not None:
            pulumi.set(__self__, "delay", delay)

    @property
    @pulumi.getter
    def abort(self) -> Optional['outputs.GrpcRouteRuleActionFaultInjectionPolicyAbort']:
        """
        Specification of how client requests are aborted as part of fault injection before being sent to a destination.
        Structure is documented below.
        """
        return pulumi.get(self, "abort")

    @property
    @pulumi.getter
    def delay(self) -> Optional['outputs.GrpcRouteRuleActionFaultInjectionPolicyDelay']:
        """
        Specification of how client requests are delayed as part of fault injection before being sent to a destination.
        Structure is documented below.
        """
        return pulumi.get(self, "delay")


@pulumi.output_type
class GrpcRouteRuleActionFaultInjectionPolicyAbort(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "httpStatus":
            suggest = "http_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GrpcRouteRuleActionFaultInjectionPolicyAbort. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GrpcRouteRuleActionFaultInjectionPolicyAbort.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GrpcRouteRuleActionFaultInjectionPolicyAbort.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 http_status: Optional[builtins.int] = None,
                 percentage: Optional[builtins.int] = None):
        """
        :param builtins.int http_status: The HTTP status code used to abort the request.
        :param builtins.int percentage: The percentage of traffic which will be aborted.
        """
        if http_status is not None:
            pulumi.set(__self__, "http_status", http_status)
        if percentage is not None:
            pulumi.set(__self__, "percentage", percentage)

    @property
    @pulumi.getter(name="httpStatus")
    def http_status(self) -> Optional[builtins.int]:
        """
        The HTTP status code used to abort the request.
        """
        return pulumi.get(self, "http_status")

    @property
    @pulumi.getter
    def percentage(self) -> Optional[builtins.int]:
        """
        The percentage of traffic which will be aborted.
        """
        return pulumi.get(self, "percentage")


@pulumi.output_type
class GrpcRouteRuleActionFaultInjectionPolicyDelay(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fixedDelay":
            suggest = "fixed_delay"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GrpcRouteRuleActionFaultInjectionPolicyDelay. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GrpcRouteRuleActionFaultInjectionPolicyDelay.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GrpcRouteRuleActionFaultInjectionPolicyDelay.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fixed_delay: Optional[builtins.str] = None,
                 percentage: Optional[builtins.int] = None):
        """
        :param builtins.str fixed_delay: Specify a fixed delay before forwarding the request.
        :param builtins.int percentage: The percentage of traffic on which delay will be injected.
        """
        if fixed_delay is not None:
            pulumi.set(__self__, "fixed_delay", fixed_delay)
        if percentage is not None:
            pulumi.set(__self__, "percentage", percentage)

    @property
    @pulumi.getter(name="fixedDelay")
    def fixed_delay(self) -> Optional[builtins.str]:
        """
        Specify a fixed delay before forwarding the request.
        """
        return pulumi.get(self, "fixed_delay")

    @property
    @pulumi.getter
    def percentage(self) -> Optional[builtins.int]:
        """
        The percentage of traffic on which delay will be injected.
        """
        return pulumi.get(self, "percentage")


@pulumi.output_type
class GrpcRouteRuleActionRetryPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "numRetries":
            suggest = "num_retries"
        elif key == "retryConditions":
            suggest = "retry_conditions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GrpcRouteRuleActionRetryPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GrpcRouteRuleActionRetryPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GrpcRouteRuleActionRetryPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 num_retries: Optional[builtins.int] = None,
                 retry_conditions: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.int num_retries: Specifies the allowed number of retries.
               
               - - -
        :param Sequence[builtins.str] retry_conditions: Specifies one or more conditions when this retry policy applies.
               Each value may be one of: `connect-failure`, `refused-stream`, `cancelled`, `deadline-exceeded`, `resource-exhausted`, `unavailable`.
        """
        if num_retries is not None:
            pulumi.set(__self__, "num_retries", num_retries)
        if retry_conditions is not None:
            pulumi.set(__self__, "retry_conditions", retry_conditions)

    @property
    @pulumi.getter(name="numRetries")
    def num_retries(self) -> Optional[builtins.int]:
        """
        Specifies the allowed number of retries.

        - - -
        """
        return pulumi.get(self, "num_retries")

    @property
    @pulumi.getter(name="retryConditions")
    def retry_conditions(self) -> Optional[Sequence[builtins.str]]:
        """
        Specifies one or more conditions when this retry policy applies.
        Each value may be one of: `connect-failure`, `refused-stream`, `cancelled`, `deadline-exceeded`, `resource-exhausted`, `unavailable`.
        """
        return pulumi.get(self, "retry_conditions")


@pulumi.output_type
class GrpcRouteRuleMatch(dict):
    def __init__(__self__, *,
                 headers: Optional[Sequence['outputs.GrpcRouteRuleMatchHeader']] = None,
                 method: Optional['outputs.GrpcRouteRuleMatchMethod'] = None):
        """
        :param Sequence['GrpcRouteRuleMatchHeaderArgs'] headers: Specifies a list of HTTP request headers to match against.
               Structure is documented below.
        :param 'GrpcRouteRuleMatchMethodArgs' method: A gRPC method to match against. If this field is empty or omitted, will match all methods.
               Structure is documented below.
        """
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if method is not None:
            pulumi.set(__self__, "method", method)

    @property
    @pulumi.getter
    def headers(self) -> Optional[Sequence['outputs.GrpcRouteRuleMatchHeader']]:
        """
        Specifies a list of HTTP request headers to match against.
        Structure is documented below.
        """
        return pulumi.get(self, "headers")

    @property
    @pulumi.getter
    def method(self) -> Optional['outputs.GrpcRouteRuleMatchMethod']:
        """
        A gRPC method to match against. If this field is empty or omitted, will match all methods.
        Structure is documented below.
        """
        return pulumi.get(self, "method")


@pulumi.output_type
class GrpcRouteRuleMatchHeader(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 value: builtins.str,
                 type: Optional[builtins.str] = None):
        """
        :param builtins.str key: Required. The key of the header.
        :param builtins.str value: Required. The value of the header.
        :param builtins.str type: The type of match.
               Default value is `EXACT`.
               Possible values are: `TYPE_UNSPECIFIED`, `EXACT`, `REGULAR_EXPRESSION`.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        Required. The key of the header.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        Required. The value of the header.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def type(self) -> Optional[builtins.str]:
        """
        The type of match.
        Default value is `EXACT`.
        Possible values are: `TYPE_UNSPECIFIED`, `EXACT`, `REGULAR_EXPRESSION`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GrpcRouteRuleMatchMethod(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "grpcMethod":
            suggest = "grpc_method"
        elif key == "grpcService":
            suggest = "grpc_service"
        elif key == "caseSensitive":
            suggest = "case_sensitive"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GrpcRouteRuleMatchMethod. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GrpcRouteRuleMatchMethod.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GrpcRouteRuleMatchMethod.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 grpc_method: builtins.str,
                 grpc_service: builtins.str,
                 case_sensitive: Optional[builtins.bool] = None):
        """
        :param builtins.str grpc_method: Required. Name of the method to match against.
        :param builtins.str grpc_service: Required. Name of the service to match against.
        :param builtins.bool case_sensitive: Specifies that matches are case sensitive. The default value is true.
        """
        pulumi.set(__self__, "grpc_method", grpc_method)
        pulumi.set(__self__, "grpc_service", grpc_service)
        if case_sensitive is not None:
            pulumi.set(__self__, "case_sensitive", case_sensitive)

    @property
    @pulumi.getter(name="grpcMethod")
    def grpc_method(self) -> builtins.str:
        """
        Required. Name of the method to match against.
        """
        return pulumi.get(self, "grpc_method")

    @property
    @pulumi.getter(name="grpcService")
    def grpc_service(self) -> builtins.str:
        """
        Required. Name of the service to match against.
        """
        return pulumi.get(self, "grpc_service")

    @property
    @pulumi.getter(name="caseSensitive")
    def case_sensitive(self) -> Optional[builtins.bool]:
        """
        Specifies that matches are case sensitive. The default value is true.
        """
        return pulumi.get(self, "case_sensitive")


@pulumi.output_type
class HttpRouteRule(dict):
    def __init__(__self__, *,
                 action: Optional['outputs.HttpRouteRuleAction'] = None,
                 matches: Optional[Sequence['outputs.HttpRouteRuleMatch']] = None):
        """
        :param 'HttpRouteRuleActionArgs' action: The detailed rule defining how to route matched traffic.
               Structure is documented below.
        :param Sequence['HttpRouteRuleMatchArgs'] matches: A list of matches define conditions used for matching the rule against incoming HTTP requests. Each match is independent, i.e. this rule will be matched if ANY one of the matches is satisfied.
               If no matches field is specified, this rule will unconditionally match traffic.
               If a default rule is desired to be configured, add a rule with no matches specified to the end of the rules list.
               Structure is documented below.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if matches is not None:
            pulumi.set(__self__, "matches", matches)

    @property
    @pulumi.getter
    def action(self) -> Optional['outputs.HttpRouteRuleAction']:
        """
        The detailed rule defining how to route matched traffic.
        Structure is documented below.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def matches(self) -> Optional[Sequence['outputs.HttpRouteRuleMatch']]:
        """
        A list of matches define conditions used for matching the rule against incoming HTTP requests. Each match is independent, i.e. this rule will be matched if ANY one of the matches is satisfied.
        If no matches field is specified, this rule will unconditionally match traffic.
        If a default rule is desired to be configured, add a rule with no matches specified to the end of the rules list.
        Structure is documented below.
        """
        return pulumi.get(self, "matches")


@pulumi.output_type
class HttpRouteRuleAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "corsPolicy":
            suggest = "cors_policy"
        elif key == "faultInjectionPolicy":
            suggest = "fault_injection_policy"
        elif key == "requestHeaderModifier":
            suggest = "request_header_modifier"
        elif key == "requestMirrorPolicy":
            suggest = "request_mirror_policy"
        elif key == "responseHeaderModifier":
            suggest = "response_header_modifier"
        elif key == "retryPolicy":
            suggest = "retry_policy"
        elif key == "urlRewrite":
            suggest = "url_rewrite"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HttpRouteRuleAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HttpRouteRuleAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HttpRouteRuleAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cors_policy: Optional['outputs.HttpRouteRuleActionCorsPolicy'] = None,
                 destinations: Optional[Sequence['outputs.HttpRouteRuleActionDestination']] = None,
                 fault_injection_policy: Optional['outputs.HttpRouteRuleActionFaultInjectionPolicy'] = None,
                 redirect: Optional['outputs.HttpRouteRuleActionRedirect'] = None,
                 request_header_modifier: Optional['outputs.HttpRouteRuleActionRequestHeaderModifier'] = None,
                 request_mirror_policy: Optional['outputs.HttpRouteRuleActionRequestMirrorPolicy'] = None,
                 response_header_modifier: Optional['outputs.HttpRouteRuleActionResponseHeaderModifier'] = None,
                 retry_policy: Optional['outputs.HttpRouteRuleActionRetryPolicy'] = None,
                 timeout: Optional[builtins.str] = None,
                 url_rewrite: Optional['outputs.HttpRouteRuleActionUrlRewrite'] = None):
        """
        :param 'HttpRouteRuleActionCorsPolicyArgs' cors_policy: The specification for allowing client side cross-origin requests.
               Structure is documented below.
        :param Sequence['HttpRouteRuleActionDestinationArgs'] destinations: The destination to which traffic should be forwarded.
               Structure is documented below.
        :param 'HttpRouteRuleActionFaultInjectionPolicyArgs' fault_injection_policy: The specification for fault injection introduced into traffic to test the resiliency of clients to backend service failure.
               Structure is documented below.
        :param 'HttpRouteRuleActionRedirectArgs' redirect: If set, the request is directed as configured by this field.
               Structure is documented below.
        :param 'HttpRouteRuleActionRequestHeaderModifierArgs' request_header_modifier: The specification for modifying the headers of a matching request prior to delivery of the request to the destination.
               Structure is documented below.
        :param 'HttpRouteRuleActionRequestMirrorPolicyArgs' request_mirror_policy: Specifies the policy on how requests intended for the routes destination are shadowed to a separate mirrored destination.
               Structure is documented below.
        :param 'HttpRouteRuleActionResponseHeaderModifierArgs' response_header_modifier: The specification for modifying the headers of a response prior to sending the response back to the client.
               Structure is documented below.
        :param 'HttpRouteRuleActionRetryPolicyArgs' retry_policy: Specifies the retry policy associated with this route.
               Structure is documented below.
        :param builtins.str timeout: Specifies the timeout for selected route.
        :param 'HttpRouteRuleActionUrlRewriteArgs' url_rewrite: The specification for rewrite URL before forwarding requests to the destination.
               Structure is documented below.
        """
        if cors_policy is not None:
            pulumi.set(__self__, "cors_policy", cors_policy)
        if destinations is not None:
            pulumi.set(__self__, "destinations", destinations)
        if fault_injection_policy is not None:
            pulumi.set(__self__, "fault_injection_policy", fault_injection_policy)
        if redirect is not None:
            pulumi.set(__self__, "redirect", redirect)
        if request_header_modifier is not None:
            pulumi.set(__self__, "request_header_modifier", request_header_modifier)
        if request_mirror_policy is not None:
            pulumi.set(__self__, "request_mirror_policy", request_mirror_policy)
        if response_header_modifier is not None:
            pulumi.set(__self__, "response_header_modifier", response_header_modifier)
        if retry_policy is not None:
            pulumi.set(__self__, "retry_policy", retry_policy)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if url_rewrite is not None:
            pulumi.set(__self__, "url_rewrite", url_rewrite)

    @property
    @pulumi.getter(name="corsPolicy")
    def cors_policy(self) -> Optional['outputs.HttpRouteRuleActionCorsPolicy']:
        """
        The specification for allowing client side cross-origin requests.
        Structure is documented below.
        """
        return pulumi.get(self, "cors_policy")

    @property
    @pulumi.getter
    def destinations(self) -> Optional[Sequence['outputs.HttpRouteRuleActionDestination']]:
        """
        The destination to which traffic should be forwarded.
        Structure is documented below.
        """
        return pulumi.get(self, "destinations")

    @property
    @pulumi.getter(name="faultInjectionPolicy")
    def fault_injection_policy(self) -> Optional['outputs.HttpRouteRuleActionFaultInjectionPolicy']:
        """
        The specification for fault injection introduced into traffic to test the resiliency of clients to backend service failure.
        Structure is documented below.
        """
        return pulumi.get(self, "fault_injection_policy")

    @property
    @pulumi.getter
    def redirect(self) -> Optional['outputs.HttpRouteRuleActionRedirect']:
        """
        If set, the request is directed as configured by this field.
        Structure is documented below.
        """
        return pulumi.get(self, "redirect")

    @property
    @pulumi.getter(name="requestHeaderModifier")
    def request_header_modifier(self) -> Optional['outputs.HttpRouteRuleActionRequestHeaderModifier']:
        """
        The specification for modifying the headers of a matching request prior to delivery of the request to the destination.
        Structure is documented below.
        """
        return pulumi.get(self, "request_header_modifier")

    @property
    @pulumi.getter(name="requestMirrorPolicy")
    def request_mirror_policy(self) -> Optional['outputs.HttpRouteRuleActionRequestMirrorPolicy']:
        """
        Specifies the policy on how requests intended for the routes destination are shadowed to a separate mirrored destination.
        Structure is documented below.
        """
        return pulumi.get(self, "request_mirror_policy")

    @property
    @pulumi.getter(name="responseHeaderModifier")
    def response_header_modifier(self) -> Optional['outputs.HttpRouteRuleActionResponseHeaderModifier']:
        """
        The specification for modifying the headers of a response prior to sending the response back to the client.
        Structure is documented below.
        """
        return pulumi.get(self, "response_header_modifier")

    @property
    @pulumi.getter(name="retryPolicy")
    def retry_policy(self) -> Optional['outputs.HttpRouteRuleActionRetryPolicy']:
        """
        Specifies the retry policy associated with this route.
        Structure is documented below.
        """
        return pulumi.get(self, "retry_policy")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[builtins.str]:
        """
        Specifies the timeout for selected route.
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter(name="urlRewrite")
    def url_rewrite(self) -> Optional['outputs.HttpRouteRuleActionUrlRewrite']:
        """
        The specification for rewrite URL before forwarding requests to the destination.
        Structure is documented below.
        """
        return pulumi.get(self, "url_rewrite")


@pulumi.output_type
class HttpRouteRuleActionCorsPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowCredentials":
            suggest = "allow_credentials"
        elif key == "allowHeaders":
            suggest = "allow_headers"
        elif key == "allowMethods":
            suggest = "allow_methods"
        elif key == "allowOriginRegexes":
            suggest = "allow_origin_regexes"
        elif key == "allowOrigins":
            suggest = "allow_origins"
        elif key == "exposeHeaders":
            suggest = "expose_headers"
        elif key == "maxAge":
            suggest = "max_age"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HttpRouteRuleActionCorsPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HttpRouteRuleActionCorsPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HttpRouteRuleActionCorsPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_credentials: Optional[builtins.bool] = None,
                 allow_headers: Optional[Sequence[builtins.str]] = None,
                 allow_methods: Optional[Sequence[builtins.str]] = None,
                 allow_origin_regexes: Optional[Sequence[builtins.str]] = None,
                 allow_origins: Optional[Sequence[builtins.str]] = None,
                 disabled: Optional[builtins.bool] = None,
                 expose_headers: Optional[Sequence[builtins.str]] = None,
                 max_age: Optional[builtins.str] = None):
        """
        :param builtins.bool allow_credentials: In response to a preflight request, setting this to true indicates that the actual request can include user credentials.
        :param Sequence[builtins.str] allow_headers: Specifies the content for Access-Control-Allow-Headers header.
        :param Sequence[builtins.str] allow_methods: Specifies the content for Access-Control-Allow-Methods header.
        :param Sequence[builtins.str] allow_origin_regexes: Specifies the regular expression patterns that match allowed origins.
        :param Sequence[builtins.str] allow_origins: Specifies the list of origins that will be allowed to do CORS requests.
        :param builtins.bool disabled: If true, the CORS policy is disabled. The default value is false, which indicates that the CORS policy is in effect.
               
               - - -
        :param Sequence[builtins.str] expose_headers: Specifies the content for Access-Control-Expose-Headers header.
        :param builtins.str max_age: Specifies how long result of a preflight request can be cached in seconds.
        """
        if allow_credentials is not None:
            pulumi.set(__self__, "allow_credentials", allow_credentials)
        if allow_headers is not None:
            pulumi.set(__self__, "allow_headers", allow_headers)
        if allow_methods is not None:
            pulumi.set(__self__, "allow_methods", allow_methods)
        if allow_origin_regexes is not None:
            pulumi.set(__self__, "allow_origin_regexes", allow_origin_regexes)
        if allow_origins is not None:
            pulumi.set(__self__, "allow_origins", allow_origins)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if expose_headers is not None:
            pulumi.set(__self__, "expose_headers", expose_headers)
        if max_age is not None:
            pulumi.set(__self__, "max_age", max_age)

    @property
    @pulumi.getter(name="allowCredentials")
    def allow_credentials(self) -> Optional[builtins.bool]:
        """
        In response to a preflight request, setting this to true indicates that the actual request can include user credentials.
        """
        return pulumi.get(self, "allow_credentials")

    @property
    @pulumi.getter(name="allowHeaders")
    def allow_headers(self) -> Optional[Sequence[builtins.str]]:
        """
        Specifies the content for Access-Control-Allow-Headers header.
        """
        return pulumi.get(self, "allow_headers")

    @property
    @pulumi.getter(name="allowMethods")
    def allow_methods(self) -> Optional[Sequence[builtins.str]]:
        """
        Specifies the content for Access-Control-Allow-Methods header.
        """
        return pulumi.get(self, "allow_methods")

    @property
    @pulumi.getter(name="allowOriginRegexes")
    def allow_origin_regexes(self) -> Optional[Sequence[builtins.str]]:
        """
        Specifies the regular expression patterns that match allowed origins.
        """
        return pulumi.get(self, "allow_origin_regexes")

    @property
    @pulumi.getter(name="allowOrigins")
    def allow_origins(self) -> Optional[Sequence[builtins.str]]:
        """
        Specifies the list of origins that will be allowed to do CORS requests.
        """
        return pulumi.get(self, "allow_origins")

    @property
    @pulumi.getter
    def disabled(self) -> Optional[builtins.bool]:
        """
        If true, the CORS policy is disabled. The default value is false, which indicates that the CORS policy is in effect.

        - - -
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter(name="exposeHeaders")
    def expose_headers(self) -> Optional[Sequence[builtins.str]]:
        """
        Specifies the content for Access-Control-Expose-Headers header.
        """
        return pulumi.get(self, "expose_headers")

    @property
    @pulumi.getter(name="maxAge")
    def max_age(self) -> Optional[builtins.str]:
        """
        Specifies how long result of a preflight request can be cached in seconds.
        """
        return pulumi.get(self, "max_age")


@pulumi.output_type
class HttpRouteRuleActionDestination(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serviceName":
            suggest = "service_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HttpRouteRuleActionDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HttpRouteRuleActionDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HttpRouteRuleActionDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 service_name: Optional[builtins.str] = None,
                 weight: Optional[builtins.int] = None):
        """
        :param builtins.str service_name: The URL of a BackendService to route traffic to.
        :param builtins.int weight: Specifies the proportion of requests forwarded to the backend referenced by the serviceName field. This is computed as: weight/Sum(weights in this destination list). For non-zero values, there may be some epsilon from the exact proportion defined here depending on the precision an implementation supports.
               If only one serviceName is specified and it has a weight greater than 0, 100% of the traffic is forwarded to that backend.
               If weights are specified for any one service name, they need to be specified for all of them.
               If weights are unspecified for all services, then, traffic is distributed in equal proportions to all of them.
        """
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[builtins.str]:
        """
        The URL of a BackendService to route traffic to.
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter
    def weight(self) -> Optional[builtins.int]:
        """
        Specifies the proportion of requests forwarded to the backend referenced by the serviceName field. This is computed as: weight/Sum(weights in this destination list). For non-zero values, there may be some epsilon from the exact proportion defined here depending on the precision an implementation supports.
        If only one serviceName is specified and it has a weight greater than 0, 100% of the traffic is forwarded to that backend.
        If weights are specified for any one service name, they need to be specified for all of them.
        If weights are unspecified for all services, then, traffic is distributed in equal proportions to all of them.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class HttpRouteRuleActionFaultInjectionPolicy(dict):
    def __init__(__self__, *,
                 abort: Optional['outputs.HttpRouteRuleActionFaultInjectionPolicyAbort'] = None,
                 delay: Optional['outputs.HttpRouteRuleActionFaultInjectionPolicyDelay'] = None):
        """
        :param 'HttpRouteRuleActionFaultInjectionPolicyAbortArgs' abort: Specification of how client requests are aborted as part of fault injection before being sent to a destination.
               Structure is documented below.
        :param 'HttpRouteRuleActionFaultInjectionPolicyDelayArgs' delay: Specification of how client requests are delayed as part of fault injection before being sent to a destination.
               Structure is documented below.
        """
        if abort is not None:
            pulumi.set(__self__, "abort", abort)
        if delay is not None:
            pulumi.set(__self__, "delay", delay)

    @property
    @pulumi.getter
    def abort(self) -> Optional['outputs.HttpRouteRuleActionFaultInjectionPolicyAbort']:
        """
        Specification of how client requests are aborted as part of fault injection before being sent to a destination.
        Structure is documented below.
        """
        return pulumi.get(self, "abort")

    @property
    @pulumi.getter
    def delay(self) -> Optional['outputs.HttpRouteRuleActionFaultInjectionPolicyDelay']:
        """
        Specification of how client requests are delayed as part of fault injection before being sent to a destination.
        Structure is documented below.
        """
        return pulumi.get(self, "delay")


@pulumi.output_type
class HttpRouteRuleActionFaultInjectionPolicyAbort(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "httpStatus":
            suggest = "http_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HttpRouteRuleActionFaultInjectionPolicyAbort. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HttpRouteRuleActionFaultInjectionPolicyAbort.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HttpRouteRuleActionFaultInjectionPolicyAbort.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 http_status: Optional[builtins.int] = None,
                 percentage: Optional[builtins.int] = None):
        """
        :param builtins.int http_status: The HTTP status code used to abort the request.
        :param builtins.int percentage: The percentage of traffic which will be aborted.
        """
        if http_status is not None:
            pulumi.set(__self__, "http_status", http_status)
        if percentage is not None:
            pulumi.set(__self__, "percentage", percentage)

    @property
    @pulumi.getter(name="httpStatus")
    def http_status(self) -> Optional[builtins.int]:
        """
        The HTTP status code used to abort the request.
        """
        return pulumi.get(self, "http_status")

    @property
    @pulumi.getter
    def percentage(self) -> Optional[builtins.int]:
        """
        The percentage of traffic which will be aborted.
        """
        return pulumi.get(self, "percentage")


@pulumi.output_type
class HttpRouteRuleActionFaultInjectionPolicyDelay(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fixedDelay":
            suggest = "fixed_delay"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HttpRouteRuleActionFaultInjectionPolicyDelay. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HttpRouteRuleActionFaultInjectionPolicyDelay.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HttpRouteRuleActionFaultInjectionPolicyDelay.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fixed_delay: Optional[builtins.str] = None,
                 percentage: Optional[builtins.int] = None):
        """
        :param builtins.str fixed_delay: Specify a fixed delay before forwarding the request.
        :param builtins.int percentage: The percentage of traffic on which delay will be injected.
        """
        if fixed_delay is not None:
            pulumi.set(__self__, "fixed_delay", fixed_delay)
        if percentage is not None:
            pulumi.set(__self__, "percentage", percentage)

    @property
    @pulumi.getter(name="fixedDelay")
    def fixed_delay(self) -> Optional[builtins.str]:
        """
        Specify a fixed delay before forwarding the request.
        """
        return pulumi.get(self, "fixed_delay")

    @property
    @pulumi.getter
    def percentage(self) -> Optional[builtins.int]:
        """
        The percentage of traffic on which delay will be injected.
        """
        return pulumi.get(self, "percentage")


@pulumi.output_type
class HttpRouteRuleActionRedirect(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hostRedirect":
            suggest = "host_redirect"
        elif key == "httpsRedirect":
            suggest = "https_redirect"
        elif key == "pathRedirect":
            suggest = "path_redirect"
        elif key == "portRedirect":
            suggest = "port_redirect"
        elif key == "prefixRewrite":
            suggest = "prefix_rewrite"
        elif key == "responseCode":
            suggest = "response_code"
        elif key == "stripQuery":
            suggest = "strip_query"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HttpRouteRuleActionRedirect. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HttpRouteRuleActionRedirect.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HttpRouteRuleActionRedirect.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host_redirect: Optional[builtins.str] = None,
                 https_redirect: Optional[builtins.bool] = None,
                 path_redirect: Optional[builtins.str] = None,
                 port_redirect: Optional[builtins.int] = None,
                 prefix_rewrite: Optional[builtins.str] = None,
                 response_code: Optional[builtins.str] = None,
                 strip_query: Optional[builtins.bool] = None):
        """
        :param builtins.str host_redirect: The host that will be used in the redirect response instead of the one that was supplied in the request.
        :param builtins.bool https_redirect: If set to true, the URL scheme in the redirected request is set to https.
        :param builtins.str path_redirect: The path that will be used in the redirect response instead of the one that was supplied in the request. pathRedirect can not be supplied together with prefixRedirect. Supply one alone or neither. If neither is supplied, the path of the original request will be used for the redirect.
        :param builtins.int port_redirect: The port that will be used in the redirected request instead of the one that was supplied in the request.
        :param builtins.str prefix_rewrite: Indicates that during redirection, the matched prefix (or path) should be swapped with this value.
        :param builtins.str response_code: The HTTP Status code to use for the redirect.
        :param builtins.bool strip_query: If set to true, any accompanying query portion of the original URL is removed prior to redirecting the request.
        """
        if host_redirect is not None:
            pulumi.set(__self__, "host_redirect", host_redirect)
        if https_redirect is not None:
            pulumi.set(__self__, "https_redirect", https_redirect)
        if path_redirect is not None:
            pulumi.set(__self__, "path_redirect", path_redirect)
        if port_redirect is not None:
            pulumi.set(__self__, "port_redirect", port_redirect)
        if prefix_rewrite is not None:
            pulumi.set(__self__, "prefix_rewrite", prefix_rewrite)
        if response_code is not None:
            pulumi.set(__self__, "response_code", response_code)
        if strip_query is not None:
            pulumi.set(__self__, "strip_query", strip_query)

    @property
    @pulumi.getter(name="hostRedirect")
    def host_redirect(self) -> Optional[builtins.str]:
        """
        The host that will be used in the redirect response instead of the one that was supplied in the request.
        """
        return pulumi.get(self, "host_redirect")

    @property
    @pulumi.getter(name="httpsRedirect")
    def https_redirect(self) -> Optional[builtins.bool]:
        """
        If set to true, the URL scheme in the redirected request is set to https.
        """
        return pulumi.get(self, "https_redirect")

    @property
    @pulumi.getter(name="pathRedirect")
    def path_redirect(self) -> Optional[builtins.str]:
        """
        The path that will be used in the redirect response instead of the one that was supplied in the request. pathRedirect can not be supplied together with prefixRedirect. Supply one alone or neither. If neither is supplied, the path of the original request will be used for the redirect.
        """
        return pulumi.get(self, "path_redirect")

    @property
    @pulumi.getter(name="portRedirect")
    def port_redirect(self) -> Optional[builtins.int]:
        """
        The port that will be used in the redirected request instead of the one that was supplied in the request.
        """
        return pulumi.get(self, "port_redirect")

    @property
    @pulumi.getter(name="prefixRewrite")
    def prefix_rewrite(self) -> Optional[builtins.str]:
        """
        Indicates that during redirection, the matched prefix (or path) should be swapped with this value.
        """
        return pulumi.get(self, "prefix_rewrite")

    @property
    @pulumi.getter(name="responseCode")
    def response_code(self) -> Optional[builtins.str]:
        """
        The HTTP Status code to use for the redirect.
        """
        return pulumi.get(self, "response_code")

    @property
    @pulumi.getter(name="stripQuery")
    def strip_query(self) -> Optional[builtins.bool]:
        """
        If set to true, any accompanying query portion of the original URL is removed prior to redirecting the request.
        """
        return pulumi.get(self, "strip_query")


@pulumi.output_type
class HttpRouteRuleActionRequestHeaderModifier(dict):
    def __init__(__self__, *,
                 add: Optional[Mapping[str, builtins.str]] = None,
                 removes: Optional[Sequence[builtins.str]] = None,
                 set: Optional[Mapping[str, builtins.str]] = None):
        """
        :param Mapping[str, builtins.str] add: Add the headers with given map where key is the name of the header, value is the value of the header.
        :param Sequence[builtins.str] removes: Remove headers (matching by header names) specified in the list.
        :param Mapping[str, builtins.str] set: Completely overwrite/replace the headers with given map where key is the name of the header, value is the value of the header.
        """
        if add is not None:
            pulumi.set(__self__, "add", add)
        if removes is not None:
            pulumi.set(__self__, "removes", removes)
        if set is not None:
            pulumi.set(__self__, "set", set)

    @property
    @pulumi.getter
    def add(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Add the headers with given map where key is the name of the header, value is the value of the header.
        """
        return pulumi.get(self, "add")

    @property
    @pulumi.getter
    def removes(self) -> Optional[Sequence[builtins.str]]:
        """
        Remove headers (matching by header names) specified in the list.
        """
        return pulumi.get(self, "removes")

    @property
    @pulumi.getter
    def set(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Completely overwrite/replace the headers with given map where key is the name of the header, value is the value of the header.
        """
        return pulumi.get(self, "set")


@pulumi.output_type
class HttpRouteRuleActionRequestMirrorPolicy(dict):
    def __init__(__self__, *,
                 destination: Optional['outputs.HttpRouteRuleActionRequestMirrorPolicyDestination'] = None):
        """
        :param 'HttpRouteRuleActionRequestMirrorPolicyDestinationArgs' destination: The destination the requests will be mirrored to.
               Structure is documented below.
        """
        if destination is not None:
            pulumi.set(__self__, "destination", destination)

    @property
    @pulumi.getter
    def destination(self) -> Optional['outputs.HttpRouteRuleActionRequestMirrorPolicyDestination']:
        """
        The destination the requests will be mirrored to.
        Structure is documented below.
        """
        return pulumi.get(self, "destination")


@pulumi.output_type
class HttpRouteRuleActionRequestMirrorPolicyDestination(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serviceName":
            suggest = "service_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HttpRouteRuleActionRequestMirrorPolicyDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HttpRouteRuleActionRequestMirrorPolicyDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HttpRouteRuleActionRequestMirrorPolicyDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 service_name: Optional[builtins.str] = None,
                 weight: Optional[builtins.int] = None):
        """
        :param builtins.str service_name: The URL of a BackendService to route traffic to.
        :param builtins.int weight: Specifies the proportion of requests forwarded to the backend referenced by the serviceName field. This is computed as: weight/Sum(weights in this destination list). For non-zero values, there may be some epsilon from the exact proportion defined here depending on the precision an implementation supports.
               If only one serviceName is specified and it has a weight greater than 0, 100% of the traffic is forwarded to that backend.
               If weights are specified for any one service name, they need to be specified for all of them.
               If weights are unspecified for all services, then, traffic is distributed in equal proportions to all of them.
        """
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[builtins.str]:
        """
        The URL of a BackendService to route traffic to.
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter
    def weight(self) -> Optional[builtins.int]:
        """
        Specifies the proportion of requests forwarded to the backend referenced by the serviceName field. This is computed as: weight/Sum(weights in this destination list). For non-zero values, there may be some epsilon from the exact proportion defined here depending on the precision an implementation supports.
        If only one serviceName is specified and it has a weight greater than 0, 100% of the traffic is forwarded to that backend.
        If weights are specified for any one service name, they need to be specified for all of them.
        If weights are unspecified for all services, then, traffic is distributed in equal proportions to all of them.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class HttpRouteRuleActionResponseHeaderModifier(dict):
    def __init__(__self__, *,
                 add: Optional[Mapping[str, builtins.str]] = None,
                 removes: Optional[Sequence[builtins.str]] = None,
                 set: Optional[Mapping[str, builtins.str]] = None):
        """
        :param Mapping[str, builtins.str] add: Add the headers with given map where key is the name of the header, value is the value of the header.
        :param Sequence[builtins.str] removes: Remove headers (matching by header names) specified in the list.
        :param Mapping[str, builtins.str] set: Completely overwrite/replace the headers with given map where key is the name of the header, value is the value of the header.
        """
        if add is not None:
            pulumi.set(__self__, "add", add)
        if removes is not None:
            pulumi.set(__self__, "removes", removes)
        if set is not None:
            pulumi.set(__self__, "set", set)

    @property
    @pulumi.getter
    def add(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Add the headers with given map where key is the name of the header, value is the value of the header.
        """
        return pulumi.get(self, "add")

    @property
    @pulumi.getter
    def removes(self) -> Optional[Sequence[builtins.str]]:
        """
        Remove headers (matching by header names) specified in the list.
        """
        return pulumi.get(self, "removes")

    @property
    @pulumi.getter
    def set(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Completely overwrite/replace the headers with given map where key is the name of the header, value is the value of the header.
        """
        return pulumi.get(self, "set")


@pulumi.output_type
class HttpRouteRuleActionRetryPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "numRetries":
            suggest = "num_retries"
        elif key == "perTryTimeout":
            suggest = "per_try_timeout"
        elif key == "retryConditions":
            suggest = "retry_conditions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HttpRouteRuleActionRetryPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HttpRouteRuleActionRetryPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HttpRouteRuleActionRetryPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 num_retries: Optional[builtins.int] = None,
                 per_try_timeout: Optional[builtins.str] = None,
                 retry_conditions: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.int num_retries: Specifies the allowed number of retries.
        :param builtins.str per_try_timeout: Specifies a non-zero timeout per retry attempt. A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        :param Sequence[builtins.str] retry_conditions: Specifies one or more conditions when this retry policy applies.
        """
        if num_retries is not None:
            pulumi.set(__self__, "num_retries", num_retries)
        if per_try_timeout is not None:
            pulumi.set(__self__, "per_try_timeout", per_try_timeout)
        if retry_conditions is not None:
            pulumi.set(__self__, "retry_conditions", retry_conditions)

    @property
    @pulumi.getter(name="numRetries")
    def num_retries(self) -> Optional[builtins.int]:
        """
        Specifies the allowed number of retries.
        """
        return pulumi.get(self, "num_retries")

    @property
    @pulumi.getter(name="perTryTimeout")
    def per_try_timeout(self) -> Optional[builtins.str]:
        """
        Specifies a non-zero timeout per retry attempt. A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        """
        return pulumi.get(self, "per_try_timeout")

    @property
    @pulumi.getter(name="retryConditions")
    def retry_conditions(self) -> Optional[Sequence[builtins.str]]:
        """
        Specifies one or more conditions when this retry policy applies.
        """
        return pulumi.get(self, "retry_conditions")


@pulumi.output_type
class HttpRouteRuleActionUrlRewrite(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hostRewrite":
            suggest = "host_rewrite"
        elif key == "pathPrefixRewrite":
            suggest = "path_prefix_rewrite"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HttpRouteRuleActionUrlRewrite. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HttpRouteRuleActionUrlRewrite.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HttpRouteRuleActionUrlRewrite.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host_rewrite: Optional[builtins.str] = None,
                 path_prefix_rewrite: Optional[builtins.str] = None):
        """
        :param builtins.str host_rewrite: Prior to forwarding the request to the selected destination, the requests host header is replaced by this value.
        :param builtins.str path_prefix_rewrite: Prior to forwarding the request to the selected destination, the matching portion of the requests path is replaced by this value.
        """
        if host_rewrite is not None:
            pulumi.set(__self__, "host_rewrite", host_rewrite)
        if path_prefix_rewrite is not None:
            pulumi.set(__self__, "path_prefix_rewrite", path_prefix_rewrite)

    @property
    @pulumi.getter(name="hostRewrite")
    def host_rewrite(self) -> Optional[builtins.str]:
        """
        Prior to forwarding the request to the selected destination, the requests host header is replaced by this value.
        """
        return pulumi.get(self, "host_rewrite")

    @property
    @pulumi.getter(name="pathPrefixRewrite")
    def path_prefix_rewrite(self) -> Optional[builtins.str]:
        """
        Prior to forwarding the request to the selected destination, the matching portion of the requests path is replaced by this value.
        """
        return pulumi.get(self, "path_prefix_rewrite")


@pulumi.output_type
class HttpRouteRuleMatch(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fullPathMatch":
            suggest = "full_path_match"
        elif key == "ignoreCase":
            suggest = "ignore_case"
        elif key == "prefixMatch":
            suggest = "prefix_match"
        elif key == "queryParameters":
            suggest = "query_parameters"
        elif key == "regexMatch":
            suggest = "regex_match"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HttpRouteRuleMatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HttpRouteRuleMatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HttpRouteRuleMatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 full_path_match: Optional[builtins.str] = None,
                 headers: Optional[Sequence['outputs.HttpRouteRuleMatchHeader']] = None,
                 ignore_case: Optional[builtins.bool] = None,
                 prefix_match: Optional[builtins.str] = None,
                 query_parameters: Optional[Sequence['outputs.HttpRouteRuleMatchQueryParameter']] = None,
                 regex_match: Optional[builtins.str] = None):
        """
        :param builtins.str full_path_match: The HTTP request path value should exactly match this value.
        :param Sequence['HttpRouteRuleMatchHeaderArgs'] headers: Specifies a list of HTTP request headers to match against.
               Structure is documented below.
        :param builtins.bool ignore_case: Specifies if prefixMatch and fullPathMatch matches are case sensitive. The default value is false.
        :param builtins.str prefix_match: The HTTP request path value must begin with specified prefixMatch. prefixMatch must begin with a /.
        :param Sequence['HttpRouteRuleMatchQueryParameterArgs'] query_parameters: Specifies a list of query parameters to match against.
               Structure is documented below.
        :param builtins.str regex_match: The HTTP request path value must satisfy the regular expression specified by regexMatch after removing any query parameters and anchor supplied with the original URL. For regular expression grammar, please see https://github.com/google/re2/wiki/Syntax
        """
        if full_path_match is not None:
            pulumi.set(__self__, "full_path_match", full_path_match)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if ignore_case is not None:
            pulumi.set(__self__, "ignore_case", ignore_case)
        if prefix_match is not None:
            pulumi.set(__self__, "prefix_match", prefix_match)
        if query_parameters is not None:
            pulumi.set(__self__, "query_parameters", query_parameters)
        if regex_match is not None:
            pulumi.set(__self__, "regex_match", regex_match)

    @property
    @pulumi.getter(name="fullPathMatch")
    def full_path_match(self) -> Optional[builtins.str]:
        """
        The HTTP request path value should exactly match this value.
        """
        return pulumi.get(self, "full_path_match")

    @property
    @pulumi.getter
    def headers(self) -> Optional[Sequence['outputs.HttpRouteRuleMatchHeader']]:
        """
        Specifies a list of HTTP request headers to match against.
        Structure is documented below.
        """
        return pulumi.get(self, "headers")

    @property
    @pulumi.getter(name="ignoreCase")
    def ignore_case(self) -> Optional[builtins.bool]:
        """
        Specifies if prefixMatch and fullPathMatch matches are case sensitive. The default value is false.
        """
        return pulumi.get(self, "ignore_case")

    @property
    @pulumi.getter(name="prefixMatch")
    def prefix_match(self) -> Optional[builtins.str]:
        """
        The HTTP request path value must begin with specified prefixMatch. prefixMatch must begin with a /.
        """
        return pulumi.get(self, "prefix_match")

    @property
    @pulumi.getter(name="queryParameters")
    def query_parameters(self) -> Optional[Sequence['outputs.HttpRouteRuleMatchQueryParameter']]:
        """
        Specifies a list of query parameters to match against.
        Structure is documented below.
        """
        return pulumi.get(self, "query_parameters")

    @property
    @pulumi.getter(name="regexMatch")
    def regex_match(self) -> Optional[builtins.str]:
        """
        The HTTP request path value must satisfy the regular expression specified by regexMatch after removing any query parameters and anchor supplied with the original URL. For regular expression grammar, please see https://github.com/google/re2/wiki/Syntax
        """
        return pulumi.get(self, "regex_match")


@pulumi.output_type
class HttpRouteRuleMatchHeader(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exactMatch":
            suggest = "exact_match"
        elif key == "invertMatch":
            suggest = "invert_match"
        elif key == "prefixMatch":
            suggest = "prefix_match"
        elif key == "presentMatch":
            suggest = "present_match"
        elif key == "rangeMatch":
            suggest = "range_match"
        elif key == "regexMatch":
            suggest = "regex_match"
        elif key == "suffixMatch":
            suggest = "suffix_match"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HttpRouteRuleMatchHeader. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HttpRouteRuleMatchHeader.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HttpRouteRuleMatchHeader.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exact_match: Optional[builtins.str] = None,
                 header: Optional[builtins.str] = None,
                 invert_match: Optional[builtins.bool] = None,
                 prefix_match: Optional[builtins.str] = None,
                 present_match: Optional[builtins.bool] = None,
                 range_match: Optional['outputs.HttpRouteRuleMatchHeaderRangeMatch'] = None,
                 regex_match: Optional[builtins.str] = None,
                 suffix_match: Optional[builtins.str] = None):
        """
        :param builtins.str exact_match: The value of the header should match exactly the content of exactMatch.
        :param builtins.str header: The name of the HTTP header to match against.
        :param builtins.bool invert_match: If specified, the match result will be inverted before checking. Default value is set to false.
        :param builtins.str prefix_match: The value of the header must start with the contents of prefixMatch.
        :param builtins.bool present_match: A header with headerName must exist. The match takes place whether or not the header has a value.
        :param 'HttpRouteRuleMatchHeaderRangeMatchArgs' range_match: If specified, the rule will match if the request header value is within the range.
               Structure is documented below.
        :param builtins.str regex_match: The value of the header must match the regular expression specified in regexMatch.
        :param builtins.str suffix_match: The value of the header must end with the contents of suffixMatch.
        """
        if exact_match is not None:
            pulumi.set(__self__, "exact_match", exact_match)
        if header is not None:
            pulumi.set(__self__, "header", header)
        if invert_match is not None:
            pulumi.set(__self__, "invert_match", invert_match)
        if prefix_match is not None:
            pulumi.set(__self__, "prefix_match", prefix_match)
        if present_match is not None:
            pulumi.set(__self__, "present_match", present_match)
        if range_match is not None:
            pulumi.set(__self__, "range_match", range_match)
        if regex_match is not None:
            pulumi.set(__self__, "regex_match", regex_match)
        if suffix_match is not None:
            pulumi.set(__self__, "suffix_match", suffix_match)

    @property
    @pulumi.getter(name="exactMatch")
    def exact_match(self) -> Optional[builtins.str]:
        """
        The value of the header should match exactly the content of exactMatch.
        """
        return pulumi.get(self, "exact_match")

    @property
    @pulumi.getter
    def header(self) -> Optional[builtins.str]:
        """
        The name of the HTTP header to match against.
        """
        return pulumi.get(self, "header")

    @property
    @pulumi.getter(name="invertMatch")
    def invert_match(self) -> Optional[builtins.bool]:
        """
        If specified, the match result will be inverted before checking. Default value is set to false.
        """
        return pulumi.get(self, "invert_match")

    @property
    @pulumi.getter(name="prefixMatch")
    def prefix_match(self) -> Optional[builtins.str]:
        """
        The value of the header must start with the contents of prefixMatch.
        """
        return pulumi.get(self, "prefix_match")

    @property
    @pulumi.getter(name="presentMatch")
    def present_match(self) -> Optional[builtins.bool]:
        """
        A header with headerName must exist. The match takes place whether or not the header has a value.
        """
        return pulumi.get(self, "present_match")

    @property
    @pulumi.getter(name="rangeMatch")
    def range_match(self) -> Optional['outputs.HttpRouteRuleMatchHeaderRangeMatch']:
        """
        If specified, the rule will match if the request header value is within the range.
        Structure is documented below.
        """
        return pulumi.get(self, "range_match")

    @property
    @pulumi.getter(name="regexMatch")
    def regex_match(self) -> Optional[builtins.str]:
        """
        The value of the header must match the regular expression specified in regexMatch.
        """
        return pulumi.get(self, "regex_match")

    @property
    @pulumi.getter(name="suffixMatch")
    def suffix_match(self) -> Optional[builtins.str]:
        """
        The value of the header must end with the contents of suffixMatch.
        """
        return pulumi.get(self, "suffix_match")


@pulumi.output_type
class HttpRouteRuleMatchHeaderRangeMatch(dict):
    def __init__(__self__, *,
                 end: builtins.int,
                 start: builtins.int):
        """
        :param builtins.int end: End of the range (exclusive).
        :param builtins.int start: Start of the range (inclusive).
        """
        pulumi.set(__self__, "end", end)
        pulumi.set(__self__, "start", start)

    @property
    @pulumi.getter
    def end(self) -> builtins.int:
        """
        End of the range (exclusive).
        """
        return pulumi.get(self, "end")

    @property
    @pulumi.getter
    def start(self) -> builtins.int:
        """
        Start of the range (inclusive).
        """
        return pulumi.get(self, "start")


@pulumi.output_type
class HttpRouteRuleMatchQueryParameter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exactMatch":
            suggest = "exact_match"
        elif key == "presentMatch":
            suggest = "present_match"
        elif key == "queryParameter":
            suggest = "query_parameter"
        elif key == "regexMatch":
            suggest = "regex_match"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HttpRouteRuleMatchQueryParameter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HttpRouteRuleMatchQueryParameter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HttpRouteRuleMatchQueryParameter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exact_match: Optional[builtins.str] = None,
                 present_match: Optional[builtins.bool] = None,
                 query_parameter: Optional[builtins.str] = None,
                 regex_match: Optional[builtins.str] = None):
        """
        :param builtins.str exact_match: The value of the query parameter must exactly match the contents of exactMatch.
        :param builtins.bool present_match: Specifies that the QueryParameterMatcher matches if request contains query parameter, irrespective of whether the parameter has a value or not.
        :param builtins.str query_parameter: The name of the query parameter to match.
        :param builtins.str regex_match: The value of the query parameter must match the regular expression specified by regexMatch.For regular expression grammar, please see https://github.com/google/re2/wiki/Syntax
        """
        if exact_match is not None:
            pulumi.set(__self__, "exact_match", exact_match)
        if present_match is not None:
            pulumi.set(__self__, "present_match", present_match)
        if query_parameter is not None:
            pulumi.set(__self__, "query_parameter", query_parameter)
        if regex_match is not None:
            pulumi.set(__self__, "regex_match", regex_match)

    @property
    @pulumi.getter(name="exactMatch")
    def exact_match(self) -> Optional[builtins.str]:
        """
        The value of the query parameter must exactly match the contents of exactMatch.
        """
        return pulumi.get(self, "exact_match")

    @property
    @pulumi.getter(name="presentMatch")
    def present_match(self) -> Optional[builtins.bool]:
        """
        Specifies that the QueryParameterMatcher matches if request contains query parameter, irrespective of whether the parameter has a value or not.
        """
        return pulumi.get(self, "present_match")

    @property
    @pulumi.getter(name="queryParameter")
    def query_parameter(self) -> Optional[builtins.str]:
        """
        The name of the query parameter to match.
        """
        return pulumi.get(self, "query_parameter")

    @property
    @pulumi.getter(name="regexMatch")
    def regex_match(self) -> Optional[builtins.str]:
        """
        The value of the query parameter must match the regular expression specified by regexMatch.For regular expression grammar, please see https://github.com/google/re2/wiki/Syntax
        """
        return pulumi.get(self, "regex_match")


@pulumi.output_type
class LbRouteExtensionExtensionChain(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "matchCondition":
            suggest = "match_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LbRouteExtensionExtensionChain. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LbRouteExtensionExtensionChain.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LbRouteExtensionExtensionChain.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 extensions: Sequence['outputs.LbRouteExtensionExtensionChainExtension'],
                 match_condition: 'outputs.LbRouteExtensionExtensionChainMatchCondition',
                 name: builtins.str):
        """
        :param Sequence['LbRouteExtensionExtensionChainExtensionArgs'] extensions: A set of extensions to execute for the matching request.
               At least one extension is required. Up to 3 extensions can be defined for each extension chain for
               LbTrafficExtension resource. LbRouteExtension chains are limited to 1 extension per extension chain.
               Structure is documented below.
        :param 'LbRouteExtensionExtensionChainMatchConditionArgs' match_condition: Conditions under which this chain is invoked for a request.
               Structure is documented below.
        :param builtins.str name: The name for this extension chain. The name is logged as part of the HTTP request logs.
               The name must conform with RFC-1034, is restricted to lower-cased letters, numbers and hyphens,
               and can have a maximum length of 63 characters. Additionally, the first character must be a letter
               and the last character must be a letter or a number.
        """
        pulumi.set(__self__, "extensions", extensions)
        pulumi.set(__self__, "match_condition", match_condition)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def extensions(self) -> Sequence['outputs.LbRouteExtensionExtensionChainExtension']:
        """
        A set of extensions to execute for the matching request.
        At least one extension is required. Up to 3 extensions can be defined for each extension chain for
        LbTrafficExtension resource. LbRouteExtension chains are limited to 1 extension per extension chain.
        Structure is documented below.
        """
        return pulumi.get(self, "extensions")

    @property
    @pulumi.getter(name="matchCondition")
    def match_condition(self) -> 'outputs.LbRouteExtensionExtensionChainMatchCondition':
        """
        Conditions under which this chain is invoked for a request.
        Structure is documented below.
        """
        return pulumi.get(self, "match_condition")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name for this extension chain. The name is logged as part of the HTTP request logs.
        The name must conform with RFC-1034, is restricted to lower-cased letters, numbers and hyphens,
        and can have a maximum length of 63 characters. Additionally, the first character must be a letter
        and the last character must be a letter or a number.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class LbRouteExtensionExtensionChainExtension(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failOpen":
            suggest = "fail_open"
        elif key == "forwardHeaders":
            suggest = "forward_headers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LbRouteExtensionExtensionChainExtension. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LbRouteExtensionExtensionChainExtension.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LbRouteExtensionExtensionChainExtension.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 service: builtins.str,
                 authority: Optional[builtins.str] = None,
                 fail_open: Optional[builtins.bool] = None,
                 forward_headers: Optional[Sequence[builtins.str]] = None,
                 timeout: Optional[builtins.str] = None):
        """
        :param builtins.str name: The name for this extension. The name is logged as part of the HTTP request logs.
               The name must conform with RFC-1034, is restricted to lower-cased letters, numbers and hyphens,
               and can have a maximum length of 63 characters. Additionally, the first character must be a letter
               and the last a letter or a number.
        :param builtins.str service: The reference to the service that runs the extension. Must be a reference to a backend service
        :param builtins.str authority: The :authority header in the gRPC request sent from Envoy to the extension service.
        :param builtins.bool fail_open: Determines how the proxy behaves if the call to the extension fails or times out.
               When set to TRUE, request or response processing continues without error.
               Any subsequent extensions in the extension chain are also executed.
               When set to FALSE: * If response headers have not been delivered to the downstream client,
               a generic 500 error is returned to the client. The error response can be tailored by
               configuring a custom error response in the load balancer.
        :param Sequence[builtins.str] forward_headers: List of the HTTP headers to forward to the extension (from the client or backend).
               If omitted, all headers are sent. Each element is a string indicating the header name.
               
               - - -
        :param builtins.str timeout: Specifies the timeout for each individual message on the stream. The timeout must be between 10-1000 milliseconds.
               A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "service", service)
        if authority is not None:
            pulumi.set(__self__, "authority", authority)
        if fail_open is not None:
            pulumi.set(__self__, "fail_open", fail_open)
        if forward_headers is not None:
            pulumi.set(__self__, "forward_headers", forward_headers)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name for this extension. The name is logged as part of the HTTP request logs.
        The name must conform with RFC-1034, is restricted to lower-cased letters, numbers and hyphens,
        and can have a maximum length of 63 characters. Additionally, the first character must be a letter
        and the last a letter or a number.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def service(self) -> builtins.str:
        """
        The reference to the service that runs the extension. Must be a reference to a backend service
        """
        return pulumi.get(self, "service")

    @property
    @pulumi.getter
    def authority(self) -> Optional[builtins.str]:
        """
        The :authority header in the gRPC request sent from Envoy to the extension service.
        """
        return pulumi.get(self, "authority")

    @property
    @pulumi.getter(name="failOpen")
    def fail_open(self) -> Optional[builtins.bool]:
        """
        Determines how the proxy behaves if the call to the extension fails or times out.
        When set to TRUE, request or response processing continues without error.
        Any subsequent extensions in the extension chain are also executed.
        When set to FALSE: * If response headers have not been delivered to the downstream client,
        a generic 500 error is returned to the client. The error response can be tailored by
        configuring a custom error response in the load balancer.
        """
        return pulumi.get(self, "fail_open")

    @property
    @pulumi.getter(name="forwardHeaders")
    def forward_headers(self) -> Optional[Sequence[builtins.str]]:
        """
        List of the HTTP headers to forward to the extension (from the client or backend).
        If omitted, all headers are sent. Each element is a string indicating the header name.

        - - -
        """
        return pulumi.get(self, "forward_headers")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[builtins.str]:
        """
        Specifies the timeout for each individual message on the stream. The timeout must be between 10-1000 milliseconds.
        A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        """
        return pulumi.get(self, "timeout")


@pulumi.output_type
class LbRouteExtensionExtensionChainMatchCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "celExpression":
            suggest = "cel_expression"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LbRouteExtensionExtensionChainMatchCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LbRouteExtensionExtensionChainMatchCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LbRouteExtensionExtensionChainMatchCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cel_expression: builtins.str):
        """
        :param builtins.str cel_expression: A Common Expression Language (CEL) expression that is used to match requests for which the extension chain is executed.
        """
        pulumi.set(__self__, "cel_expression", cel_expression)

    @property
    @pulumi.getter(name="celExpression")
    def cel_expression(self) -> builtins.str:
        """
        A Common Expression Language (CEL) expression that is used to match requests for which the extension chain is executed.
        """
        return pulumi.get(self, "cel_expression")


@pulumi.output_type
class LbTrafficExtensionExtensionChain(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "matchCondition":
            suggest = "match_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LbTrafficExtensionExtensionChain. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LbTrafficExtensionExtensionChain.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LbTrafficExtensionExtensionChain.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 extensions: Sequence['outputs.LbTrafficExtensionExtensionChainExtension'],
                 match_condition: 'outputs.LbTrafficExtensionExtensionChainMatchCondition',
                 name: builtins.str):
        """
        :param Sequence['LbTrafficExtensionExtensionChainExtensionArgs'] extensions: A set of extensions to execute for the matching request.
               At least one extension is required. Up to 3 extensions can be defined for each extension chain for
               LbTrafficExtension resource. LbRouteExtension chains are limited to 1 extension per extension chain.
               Further documentation to be found at https://cloud.google.com/service-extensions/docs/reference/rest/v1/ExtensionChain#Extension
               Structure is documented below.
        :param 'LbTrafficExtensionExtensionChainMatchConditionArgs' match_condition: Conditions under which this chain is invoked for a request.
               Structure is documented below.
        :param builtins.str name: The name for this extension chain. The name is logged as part of the HTTP request logs.
               The name must conform with RFC-1034, is restricted to lower-cased letters, numbers and hyphens,
               and can have a maximum length of 63 characters. Additionally, the first character must be a letter
               and the last a letter or a number.
        """
        pulumi.set(__self__, "extensions", extensions)
        pulumi.set(__self__, "match_condition", match_condition)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def extensions(self) -> Sequence['outputs.LbTrafficExtensionExtensionChainExtension']:
        """
        A set of extensions to execute for the matching request.
        At least one extension is required. Up to 3 extensions can be defined for each extension chain for
        LbTrafficExtension resource. LbRouteExtension chains are limited to 1 extension per extension chain.
        Further documentation to be found at https://cloud.google.com/service-extensions/docs/reference/rest/v1/ExtensionChain#Extension
        Structure is documented below.
        """
        return pulumi.get(self, "extensions")

    @property
    @pulumi.getter(name="matchCondition")
    def match_condition(self) -> 'outputs.LbTrafficExtensionExtensionChainMatchCondition':
        """
        Conditions under which this chain is invoked for a request.
        Structure is documented below.
        """
        return pulumi.get(self, "match_condition")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name for this extension chain. The name is logged as part of the HTTP request logs.
        The name must conform with RFC-1034, is restricted to lower-cased letters, numbers and hyphens,
        and can have a maximum length of 63 characters. Additionally, the first character must be a letter
        and the last a letter or a number.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class LbTrafficExtensionExtensionChainExtension(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failOpen":
            suggest = "fail_open"
        elif key == "forwardHeaders":
            suggest = "forward_headers"
        elif key == "supportedEvents":
            suggest = "supported_events"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LbTrafficExtensionExtensionChainExtension. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LbTrafficExtensionExtensionChainExtension.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LbTrafficExtensionExtensionChainExtension.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 service: builtins.str,
                 authority: Optional[builtins.str] = None,
                 fail_open: Optional[builtins.bool] = None,
                 forward_headers: Optional[Sequence[builtins.str]] = None,
                 metadata: Optional[Mapping[str, builtins.str]] = None,
                 supported_events: Optional[Sequence[builtins.str]] = None,
                 timeout: Optional[builtins.str] = None):
        """
        :param builtins.str name: The name for this extension. The name is logged as part of the HTTP request logs.
               The name must conform with RFC-1034, is restricted to lower-cased letters, numbers and hyphens,
               and can have a maximum length of 63 characters. Additionally, the first character must be a letter
               and the last a letter or a number.
        :param builtins.str service: The reference to the service that runs the extension. Must be a reference to a backend service
        :param builtins.str authority: The :authority header in the gRPC request sent from Envoy to the extension service.
        :param builtins.bool fail_open: Determines how the proxy behaves if the call to the extension fails or times out.
               When set to TRUE, request or response processing continues without error.
               Any subsequent extensions in the extension chain are also executed.
               When set to FALSE: * If response headers have not been delivered to the downstream client,
               a generic 500 error is returned to the client. The error response can be tailored by
               configuring a custom error response in the load balancer.
        :param Sequence[builtins.str] forward_headers: List of the HTTP headers to forward to the extension (from the client or backend).
               If omitted, all headers are sent. Each element is a string indicating the header name.
        :param Mapping[str, builtins.str] metadata: Metadata associated with the extension. This field is used to pass metadata to the extension service.
               You can set up key value pairs for metadata as you like and need.
               f.e. {"key": "value", "key2": "value2"}.
               
               - - -
        :param Sequence[builtins.str] supported_events: A set of events during request or response processing for which this extension is called.
               This field is required for the LbTrafficExtension resource. It's not relevant for the LbRouteExtension
               resource. Possible values:`EVENT_TYPE_UNSPECIFIED`, `REQUEST_HEADERS`, `REQUEST_BODY`, `RESPONSE_HEADERS`,
               `RESPONSE_BODY`, `RESPONSE_BODY` and `RESPONSE_BODY`.
        :param builtins.str timeout: Specifies the timeout for each individual message on the stream. The timeout must be between 10-1000 milliseconds.
               A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "service", service)
        if authority is not None:
            pulumi.set(__self__, "authority", authority)
        if fail_open is not None:
            pulumi.set(__self__, "fail_open", fail_open)
        if forward_headers is not None:
            pulumi.set(__self__, "forward_headers", forward_headers)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if supported_events is not None:
            pulumi.set(__self__, "supported_events", supported_events)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name for this extension. The name is logged as part of the HTTP request logs.
        The name must conform with RFC-1034, is restricted to lower-cased letters, numbers and hyphens,
        and can have a maximum length of 63 characters. Additionally, the first character must be a letter
        and the last a letter or a number.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def service(self) -> builtins.str:
        """
        The reference to the service that runs the extension. Must be a reference to a backend service
        """
        return pulumi.get(self, "service")

    @property
    @pulumi.getter
    def authority(self) -> Optional[builtins.str]:
        """
        The :authority header in the gRPC request sent from Envoy to the extension service.
        """
        return pulumi.get(self, "authority")

    @property
    @pulumi.getter(name="failOpen")
    def fail_open(self) -> Optional[builtins.bool]:
        """
        Determines how the proxy behaves if the call to the extension fails or times out.
        When set to TRUE, request or response processing continues without error.
        Any subsequent extensions in the extension chain are also executed.
        When set to FALSE: * If response headers have not been delivered to the downstream client,
        a generic 500 error is returned to the client. The error response can be tailored by
        configuring a custom error response in the load balancer.
        """
        return pulumi.get(self, "fail_open")

    @property
    @pulumi.getter(name="forwardHeaders")
    def forward_headers(self) -> Optional[Sequence[builtins.str]]:
        """
        List of the HTTP headers to forward to the extension (from the client or backend).
        If omitted, all headers are sent. Each element is a string indicating the header name.
        """
        return pulumi.get(self, "forward_headers")

    @property
    @pulumi.getter
    def metadata(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Metadata associated with the extension. This field is used to pass metadata to the extension service.
        You can set up key value pairs for metadata as you like and need.
        f.e. {"key": "value", "key2": "value2"}.

        - - -
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter(name="supportedEvents")
    def supported_events(self) -> Optional[Sequence[builtins.str]]:
        """
        A set of events during request or response processing for which this extension is called.
        This field is required for the LbTrafficExtension resource. It's not relevant for the LbRouteExtension
        resource. Possible values:`EVENT_TYPE_UNSPECIFIED`, `REQUEST_HEADERS`, `REQUEST_BODY`, `RESPONSE_HEADERS`,
        `RESPONSE_BODY`, `RESPONSE_BODY` and `RESPONSE_BODY`.
        """
        return pulumi.get(self, "supported_events")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[builtins.str]:
        """
        Specifies the timeout for each individual message on the stream. The timeout must be between 10-1000 milliseconds.
        A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        """
        return pulumi.get(self, "timeout")


@pulumi.output_type
class LbTrafficExtensionExtensionChainMatchCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "celExpression":
            suggest = "cel_expression"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LbTrafficExtensionExtensionChainMatchCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LbTrafficExtensionExtensionChainMatchCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LbTrafficExtensionExtensionChainMatchCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cel_expression: builtins.str):
        """
        :param builtins.str cel_expression: A Common Expression Language (CEL) expression that is used to match requests for which the extension chain is executed.
        """
        pulumi.set(__self__, "cel_expression", cel_expression)

    @property
    @pulumi.getter(name="celExpression")
    def cel_expression(self) -> builtins.str:
        """
        A Common Expression Language (CEL) expression that is used to match requests for which the extension chain is executed.
        """
        return pulumi.get(self, "cel_expression")


@pulumi.output_type
class ServiceLbPoliciesAutoCapacityDrain(dict):
    def __init__(__self__, *,
                 enable: Optional[builtins.bool] = None):
        """
        :param builtins.bool enable: Optional. If set to 'True', an unhealthy MIG/NEG will be set as drained. - An MIG/NEG is considered unhealthy if less than 25% of the instances/endpoints in the MIG/NEG are healthy. - This option will never result in draining more than 50% of the configured IGs/NEGs for the Backend Service.
        """
        if enable is not None:
            pulumi.set(__self__, "enable", enable)

    @property
    @pulumi.getter
    def enable(self) -> Optional[builtins.bool]:
        """
        Optional. If set to 'True', an unhealthy MIG/NEG will be set as drained. - An MIG/NEG is considered unhealthy if less than 25% of the instances/endpoints in the MIG/NEG are healthy. - This option will never result in draining more than 50% of the configured IGs/NEGs for the Backend Service.
        """
        return pulumi.get(self, "enable")


@pulumi.output_type
class ServiceLbPoliciesFailoverConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failoverHealthThreshold":
            suggest = "failover_health_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceLbPoliciesFailoverConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceLbPoliciesFailoverConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceLbPoliciesFailoverConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 failover_health_threshold: builtins.int):
        """
        :param builtins.int failover_health_threshold: Optional. The percentage threshold that a load balancer will begin to send traffic to failover backends. If the percentage of endpoints in a MIG/NEG is smaller than this value, traffic would be sent to failover backends if possible. This field should be set to a value between 1 and 99. The default value is 50 for Global external HTTP(S) load balancer (classic) and Proxyless service mesh, and 70 for others.
        """
        pulumi.set(__self__, "failover_health_threshold", failover_health_threshold)

    @property
    @pulumi.getter(name="failoverHealthThreshold")
    def failover_health_threshold(self) -> builtins.int:
        """
        Optional. The percentage threshold that a load balancer will begin to send traffic to failover backends. If the percentage of endpoints in a MIG/NEG is smaller than this value, traffic would be sent to failover backends if possible. This field should be set to a value between 1 and 99. The default value is 50 for Global external HTTP(S) load balancer (classic) and Proxyless service mesh, and 70 for others.
        """
        return pulumi.get(self, "failover_health_threshold")


@pulumi.output_type
class TcpRouteRule(dict):
    def __init__(__self__, *,
                 action: 'outputs.TcpRouteRuleAction',
                 matches: Optional[Sequence['outputs.TcpRouteRuleMatch']] = None):
        """
        :param 'TcpRouteRuleActionArgs' action: A detailed rule defining how to route traffic.
               Structure is documented below.
        :param Sequence['TcpRouteRuleMatchArgs'] matches: RouteMatch defines the predicate used to match requests to a given action. Multiple match types are "OR"ed for evaluation.
               If no routeMatch field is specified, this rule will unconditionally match traffic.
               Structure is documented below.
        """
        pulumi.set(__self__, "action", action)
        if matches is not None:
            pulumi.set(__self__, "matches", matches)

    @property
    @pulumi.getter
    def action(self) -> 'outputs.TcpRouteRuleAction':
        """
        A detailed rule defining how to route traffic.
        Structure is documented below.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def matches(self) -> Optional[Sequence['outputs.TcpRouteRuleMatch']]:
        """
        RouteMatch defines the predicate used to match requests to a given action. Multiple match types are "OR"ed for evaluation.
        If no routeMatch field is specified, this rule will unconditionally match traffic.
        Structure is documented below.
        """
        return pulumi.get(self, "matches")


@pulumi.output_type
class TcpRouteRuleAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "idleTimeout":
            suggest = "idle_timeout"
        elif key == "originalDestination":
            suggest = "original_destination"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TcpRouteRuleAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TcpRouteRuleAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TcpRouteRuleAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destinations: Optional[Sequence['outputs.TcpRouteRuleActionDestination']] = None,
                 idle_timeout: Optional[builtins.str] = None,
                 original_destination: Optional[builtins.bool] = None):
        """
        :param Sequence['TcpRouteRuleActionDestinationArgs'] destinations: The destination services to which traffic should be forwarded. At least one destination service is required.
               Structure is documented below.
        :param builtins.str idle_timeout: Specifies the idle timeout for the selected route. The idle timeout is defined as the period in which there are no bytes sent or received on either the upstream or downstream connection. If not set, the default idle timeout is 30 seconds. If set to 0s, the timeout will be disabled.
               A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        :param builtins.bool original_destination: If true, Router will use the destination IP and port of the original connection as the destination of the request.
        """
        if destinations is not None:
            pulumi.set(__self__, "destinations", destinations)
        if idle_timeout is not None:
            pulumi.set(__self__, "idle_timeout", idle_timeout)
        if original_destination is not None:
            pulumi.set(__self__, "original_destination", original_destination)

    @property
    @pulumi.getter
    def destinations(self) -> Optional[Sequence['outputs.TcpRouteRuleActionDestination']]:
        """
        The destination services to which traffic should be forwarded. At least one destination service is required.
        Structure is documented below.
        """
        return pulumi.get(self, "destinations")

    @property
    @pulumi.getter(name="idleTimeout")
    def idle_timeout(self) -> Optional[builtins.str]:
        """
        Specifies the idle timeout for the selected route. The idle timeout is defined as the period in which there are no bytes sent or received on either the upstream or downstream connection. If not set, the default idle timeout is 30 seconds. If set to 0s, the timeout will be disabled.
        A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        """
        return pulumi.get(self, "idle_timeout")

    @property
    @pulumi.getter(name="originalDestination")
    def original_destination(self) -> Optional[builtins.bool]:
        """
        If true, Router will use the destination IP and port of the original connection as the destination of the request.
        """
        return pulumi.get(self, "original_destination")


@pulumi.output_type
class TcpRouteRuleActionDestination(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serviceName":
            suggest = "service_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TcpRouteRuleActionDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TcpRouteRuleActionDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TcpRouteRuleActionDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 service_name: Optional[builtins.str] = None,
                 weight: Optional[builtins.int] = None):
        """
        :param builtins.str service_name: The URL of a BackendService to route traffic to.
        :param builtins.int weight: Specifies the proportion of requests forwarded to the backend referenced by the serviceName field. This is computed as: weight/Sum(weights in this destination list). For non-zero values, there may be some epsilon from the exact proportion defined here depending on the precision an implementation supports.
               If only one serviceName is specified and it has a weight greater than 0, 100% of the traffic is forwarded to that backend.
               If weights are specified for any one service name, they need to be specified for all of them.
               If weights are unspecified for all services, then, traffic is distributed in equal proportions to all of them.
               
               - - -
        """
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[builtins.str]:
        """
        The URL of a BackendService to route traffic to.
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter
    def weight(self) -> Optional[builtins.int]:
        """
        Specifies the proportion of requests forwarded to the backend referenced by the serviceName field. This is computed as: weight/Sum(weights in this destination list). For non-zero values, there may be some epsilon from the exact proportion defined here depending on the precision an implementation supports.
        If only one serviceName is specified and it has a weight greater than 0, 100% of the traffic is forwarded to that backend.
        If weights are specified for any one service name, they need to be specified for all of them.
        If weights are unspecified for all services, then, traffic is distributed in equal proportions to all of them.

        - - -
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class TcpRouteRuleMatch(dict):
    def __init__(__self__, *,
                 address: builtins.str,
                 port: builtins.str):
        """
        :param builtins.str address: Must be specified in the CIDR range format. A CIDR range consists of an IP Address and a prefix length to construct the subnet mask.
               By default, the prefix length is 32 (i.e. matches a single IP address). Only IPV4 addresses are supported. Examples: "10.0.0.1" - matches against this exact IP address. "10.0.0.0/8" - matches against any IP address within the 10.0.0.0 subnet and 255.255.255.0 mask. "0.0.0.0/0" - matches against any IP address'.
        :param builtins.str port: Specifies the destination port to match against.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def address(self) -> builtins.str:
        """
        Must be specified in the CIDR range format. A CIDR range consists of an IP Address and a prefix length to construct the subnet mask.
        By default, the prefix length is 32 (i.e. matches a single IP address). Only IPV4 addresses are supported. Examples: "10.0.0.1" - matches against this exact IP address. "10.0.0.0/8" - matches against any IP address within the 10.0.0.0 subnet and 255.255.255.0 mask. "0.0.0.0/0" - matches against any IP address'.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def port(self) -> builtins.str:
        """
        Specifies the destination port to match against.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class TlsRouteRule(dict):
    def __init__(__self__, *,
                 action: 'outputs.TlsRouteRuleAction',
                 matches: Sequence['outputs.TlsRouteRuleMatch']):
        """
        :param 'TlsRouteRuleActionArgs' action: Required. A detailed rule defining how to route traffic.
               Structure is documented below.
        :param Sequence['TlsRouteRuleMatchArgs'] matches: Matches define the predicate used to match requests to a given action.
               Structure is documented below.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "matches", matches)

    @property
    @pulumi.getter
    def action(self) -> 'outputs.TlsRouteRuleAction':
        """
        Required. A detailed rule defining how to route traffic.
        Structure is documented below.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def matches(self) -> Sequence['outputs.TlsRouteRuleMatch']:
        """
        Matches define the predicate used to match requests to a given action.
        Structure is documented below.
        """
        return pulumi.get(self, "matches")


@pulumi.output_type
class TlsRouteRuleAction(dict):
    def __init__(__self__, *,
                 destinations: Optional[Sequence['outputs.TlsRouteRuleActionDestination']] = None):
        """
        :param Sequence['TlsRouteRuleActionDestinationArgs'] destinations: The destination to which traffic should be forwarded.
               Structure is documented below.
        """
        if destinations is not None:
            pulumi.set(__self__, "destinations", destinations)

    @property
    @pulumi.getter
    def destinations(self) -> Optional[Sequence['outputs.TlsRouteRuleActionDestination']]:
        """
        The destination to which traffic should be forwarded.
        Structure is documented below.
        """
        return pulumi.get(self, "destinations")


@pulumi.output_type
class TlsRouteRuleActionDestination(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serviceName":
            suggest = "service_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TlsRouteRuleActionDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TlsRouteRuleActionDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TlsRouteRuleActionDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 service_name: Optional[builtins.str] = None,
                 weight: Optional[builtins.int] = None):
        """
        :param builtins.str service_name: The URL of a BackendService to route traffic to.
        :param builtins.int weight: Specifies the proportion of requests forwarded to the backend referenced by the serviceName field.
               
               - - -
        """
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[builtins.str]:
        """
        The URL of a BackendService to route traffic to.
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter
    def weight(self) -> Optional[builtins.int]:
        """
        Specifies the proportion of requests forwarded to the backend referenced by the serviceName field.

        - - -
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class TlsRouteRuleMatch(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sniHosts":
            suggest = "sni_hosts"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TlsRouteRuleMatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TlsRouteRuleMatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TlsRouteRuleMatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alpns: Optional[Sequence[builtins.str]] = None,
                 sni_hosts: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence[builtins.str] alpns: ALPN (Application-Layer Protocol Negotiation) to match against. Examples: "http/1.1", "h2". At least one of sniHost and alpn is required. Up to 5 alpns across all matches can be set.
        :param Sequence[builtins.str] sni_hosts: SNI (server name indicator) to match against. SNI will be matched against all wildcard domains, i.e. www.example.com will be first matched against www.example.com, then *.example.com, then *.com.
               Partial wildcards are not supported, and values like *w.example.com are invalid. At least one of sniHost and alpn is required. Up to 5 sni hosts across all matches can be set.
        """
        if alpns is not None:
            pulumi.set(__self__, "alpns", alpns)
        if sni_hosts is not None:
            pulumi.set(__self__, "sni_hosts", sni_hosts)

    @property
    @pulumi.getter
    def alpns(self) -> Optional[Sequence[builtins.str]]:
        """
        ALPN (Application-Layer Protocol Negotiation) to match against. Examples: "http/1.1", "h2". At least one of sniHost and alpn is required. Up to 5 alpns across all matches can be set.
        """
        return pulumi.get(self, "alpns")

    @property
    @pulumi.getter(name="sniHosts")
    def sni_hosts(self) -> Optional[Sequence[builtins.str]]:
        """
        SNI (server name indicator) to match against. SNI will be matched against all wildcard domains, i.e. www.example.com will be first matched against www.example.com, then *.example.com, then *.com.
        Partial wildcards are not supported, and values like *w.example.com are invalid. At least one of sniHost and alpn is required. Up to 5 sni hosts across all matches can be set.
        """
        return pulumi.get(self, "sni_hosts")


