# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TcpRouteArgs', 'TcpRoute']

@pulumi.input_type
class TcpRouteArgs:
    def __init__(__self__, *,
                 rules: pulumi.Input[Sequence[pulumi.Input['TcpRouteRuleArgs']]],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 gateways: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 meshes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a TcpRoute resource.
        :param pulumi.Input[Sequence[pulumi.Input['TcpRouteRuleArgs']]] rules: Rules that define how traffic is routed and handled. At least one RouteRule must be supplied.
               If there are multiple rules then the action taken will be the first rule to match.
               Structure is documented below.
        :param pulumi.Input[builtins.str] description: A free-text description of the resource. Max length 1024 characters.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] gateways: Gateways defines a list of gateways this TcpRoute is attached to, as one of the routing rules to route the requests
               served by the gateway. Each gateway reference should match the pattern:
               projects/*/locations/global/gateways/<gateway_name>
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Set of label tags associated with the TcpRoute resource. **Note**: This field is non-authoritative, and will only manage
               the labels present in your configuration. Please refer to the field 'effective_labels' for all of the labels present on
               the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] meshes: Meshes defines a list of meshes this TcpRoute is attached to, as one of the routing rules to route the requests served
               by the mesh. Each mesh reference should match the pattern: projects/*/locations/global/meshes/<mesh_name> The attached
               Mesh should be of a type SIDECAR
        :param pulumi.Input[builtins.str] name: Name of the TcpRoute resource.
        """
        pulumi.set(__self__, "rules", rules)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if gateways is not None:
            pulumi.set(__self__, "gateways", gateways)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if meshes is not None:
            pulumi.set(__self__, "meshes", meshes)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter
    def rules(self) -> pulumi.Input[Sequence[pulumi.Input['TcpRouteRuleArgs']]]:
        """
        Rules that define how traffic is routed and handled. At least one RouteRule must be supplied.
        If there are multiple rules then the action taken will be the first rule to match.
        Structure is documented below.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: pulumi.Input[Sequence[pulumi.Input['TcpRouteRuleArgs']]]):
        pulumi.set(self, "rules", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A free-text description of the resource. Max length 1024 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def gateways(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Gateways defines a list of gateways this TcpRoute is attached to, as one of the routing rules to route the requests
        served by the gateway. Each gateway reference should match the pattern:
        projects/*/locations/global/gateways/<gateway_name>
        """
        return pulumi.get(self, "gateways")

    @gateways.setter
    def gateways(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "gateways", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Set of label tags associated with the TcpRoute resource. **Note**: This field is non-authoritative, and will only manage
        the labels present in your configuration. Please refer to the field 'effective_labels' for all of the labels present on
        the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def meshes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Meshes defines a list of meshes this TcpRoute is attached to, as one of the routing rules to route the requests served
        by the mesh. Each mesh reference should match the pattern: projects/*/locations/global/meshes/<mesh_name> The attached
        Mesh should be of a type SIDECAR
        """
        return pulumi.get(self, "meshes")

    @meshes.setter
    def meshes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "meshes", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the TcpRoute resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _TcpRouteState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 gateways: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 meshes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['TcpRouteRuleArgs']]]] = None,
                 self_link: Optional[pulumi.Input[builtins.str]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering TcpRoute resources.
        :param pulumi.Input[builtins.str] create_time: Time the TcpRoute was created in UTC.
        :param pulumi.Input[builtins.str] description: A free-text description of the resource. Max length 1024 characters.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] gateways: Gateways defines a list of gateways this TcpRoute is attached to, as one of the routing rules to route the requests
               served by the gateway. Each gateway reference should match the pattern:
               projects/*/locations/global/gateways/<gateway_name>
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Set of label tags associated with the TcpRoute resource. **Note**: This field is non-authoritative, and will only manage
               the labels present in your configuration. Please refer to the field 'effective_labels' for all of the labels present on
               the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] meshes: Meshes defines a list of meshes this TcpRoute is attached to, as one of the routing rules to route the requests served
               by the mesh. Each mesh reference should match the pattern: projects/*/locations/global/meshes/<mesh_name> The attached
               Mesh should be of a type SIDECAR
        :param pulumi.Input[builtins.str] name: Name of the TcpRoute resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[Sequence[pulumi.Input['TcpRouteRuleArgs']]] rules: Rules that define how traffic is routed and handled. At least one RouteRule must be supplied.
               If there are multiple rules then the action taken will be the first rule to match.
               Structure is documented below.
        :param pulumi.Input[builtins.str] self_link: Server-defined URL of this resource.
        :param pulumi.Input[builtins.str] update_time: Time the TcpRoute was updated in UTC.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if gateways is not None:
            pulumi.set(__self__, "gateways", gateways)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if meshes is not None:
            pulumi.set(__self__, "meshes", meshes)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Time the TcpRoute was created in UTC.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A free-text description of the resource. Max length 1024 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter
    def gateways(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Gateways defines a list of gateways this TcpRoute is attached to, as one of the routing rules to route the requests
        served by the gateway. Each gateway reference should match the pattern:
        projects/*/locations/global/gateways/<gateway_name>
        """
        return pulumi.get(self, "gateways")

    @gateways.setter
    def gateways(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "gateways", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Set of label tags associated with the TcpRoute resource. **Note**: This field is non-authoritative, and will only manage
        the labels present in your configuration. Please refer to the field 'effective_labels' for all of the labels present on
        the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def meshes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Meshes defines a list of meshes this TcpRoute is attached to, as one of the routing rules to route the requests served
        by the mesh. Each mesh reference should match the pattern: projects/*/locations/global/meshes/<mesh_name> The attached
        Mesh should be of a type SIDECAR
        """
        return pulumi.get(self, "meshes")

    @meshes.setter
    def meshes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "meshes", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the TcpRoute resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TcpRouteRuleArgs']]]]:
        """
        Rules that define how traffic is routed and handled. At least one RouteRule must be supplied.
        If there are multiple rules then the action taken will be the first rule to match.
        Structure is documented below.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TcpRouteRuleArgs']]]]):
        pulumi.set(self, "rules", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Server-defined URL of this resource.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "self_link", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Time the TcpRoute was updated in UTC.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:networkservices/tcpRoute:TcpRoute")
class TcpRoute(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 gateways: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 meshes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TcpRouteRuleArgs', 'TcpRouteRuleArgsDict']]]]] = None,
                 __props__=None):
        """
        TcpRoute is the resource defining how TCP traffic should be routed by a Mesh/Gateway resource.

        To get more information about TcpRoute, see:

        * [API documentation](https://cloud.google.com/traffic-director/docs/reference/network-services/rest/v1beta1/projects.locations.tcpRoutes)
        * How-to Guides
            * [Setup TCP Services](https://cloud.google.com/traffic-director/docs/set-up-tcp-route)

        ## Example Usage

        ### Network Services Tcp Route Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_http_health_check = gcp.compute.HttpHealthCheck("default",
            name="backend-service-health-check",
            request_path="/",
            check_interval_sec=1,
            timeout_sec=1)
        default = gcp.compute.BackendService("default",
            name="my-backend-service",
            health_checks=default_http_health_check.id)
        default_tcp_route = gcp.networkservices.TcpRoute("default",
            name="my-tcp-route",
            labels={
                "foo": "bar",
            },
            description="my description",
            rules=[{
                "matches": [{
                    "address": "10.0.0.1/32",
                    "port": "8081",
                }],
                "action": {
                    "destinations": [{
                        "service_name": default.id,
                        "weight": 1,
                    }],
                    "original_destination": False,
                },
            }])
        ```
        ### Network Services Tcp Route Actions

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_http_health_check = gcp.compute.HttpHealthCheck("default",
            name="backend-service-health-check",
            request_path="/",
            check_interval_sec=1,
            timeout_sec=1)
        default = gcp.compute.BackendService("default",
            name="my-backend-service",
            health_checks=default_http_health_check.id)
        default_tcp_route = gcp.networkservices.TcpRoute("default",
            name="my-tcp-route",
            labels={
                "foo": "bar",
            },
            description="my description",
            rules=[{
                "action": {
                    "destinations": [{
                        "service_name": default.id,
                        "weight": 1,
                    }],
                    "original_destination": False,
                    "idle_timeout": "60s",
                },
            }])
        ```
        ### Network Services Tcp Route Mesh Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_http_health_check = gcp.compute.HttpHealthCheck("default",
            name="backend-service-health-check",
            request_path="/",
            check_interval_sec=1,
            timeout_sec=1)
        default = gcp.compute.BackendService("default",
            name="my-backend-service",
            health_checks=default_http_health_check.id)
        default_mesh = gcp.networkservices.Mesh("default",
            name="my-tcp-route",
            labels={
                "foo": "bar",
            },
            description="my description")
        default_tcp_route = gcp.networkservices.TcpRoute("default",
            name="my-tcp-route",
            labels={
                "foo": "bar",
            },
            description="my description",
            meshes=[default_mesh.id],
            rules=[{
                "matches": [{
                    "address": "10.0.0.1/32",
                    "port": "8081",
                }],
                "action": {
                    "destinations": [{
                        "service_name": default.id,
                        "weight": 1,
                    }],
                    "original_destination": False,
                },
            }])
        ```
        ### Network Services Tcp Route Gateway Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_http_health_check = gcp.compute.HttpHealthCheck("default",
            name="backend-service-health-check",
            request_path="/",
            check_interval_sec=1,
            timeout_sec=1)
        default = gcp.compute.BackendService("default",
            name="my-backend-service",
            health_checks=default_http_health_check.id)
        default_gateway = gcp.networkservices.Gateway("default",
            name="my-tcp-route",
            labels={
                "foo": "bar",
            },
            description="my description",
            scope="my-scope",
            type="OPEN_MESH",
            ports=[443])
        default_tcp_route = gcp.networkservices.TcpRoute("default",
            name="my-tcp-route",
            labels={
                "foo": "bar",
            },
            description="my description",
            gateways=[default_gateway.id],
            rules=[{
                "matches": [{
                    "address": "10.0.0.1/32",
                    "port": "8081",
                }],
                "action": {
                    "destinations": [{
                        "service_name": default.id,
                        "weight": 1,
                    }],
                    "original_destination": False,
                },
            }])
        ```

        ## Import

        TcpRoute can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/global/tcpRoutes/{{name}}`

        * `{{project}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, TcpRoute can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:networkservices/tcpRoute:TcpRoute default projects/{{project}}/locations/global/tcpRoutes/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networkservices/tcpRoute:TcpRoute default {{project}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networkservices/tcpRoute:TcpRoute default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: A free-text description of the resource. Max length 1024 characters.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] gateways: Gateways defines a list of gateways this TcpRoute is attached to, as one of the routing rules to route the requests
               served by the gateway. Each gateway reference should match the pattern:
               projects/*/locations/global/gateways/<gateway_name>
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Set of label tags associated with the TcpRoute resource. **Note**: This field is non-authoritative, and will only manage
               the labels present in your configuration. Please refer to the field 'effective_labels' for all of the labels present on
               the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] meshes: Meshes defines a list of meshes this TcpRoute is attached to, as one of the routing rules to route the requests served
               by the mesh. Each mesh reference should match the pattern: projects/*/locations/global/meshes/<mesh_name> The attached
               Mesh should be of a type SIDECAR
        :param pulumi.Input[builtins.str] name: Name of the TcpRoute resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TcpRouteRuleArgs', 'TcpRouteRuleArgsDict']]]] rules: Rules that define how traffic is routed and handled. At least one RouteRule must be supplied.
               If there are multiple rules then the action taken will be the first rule to match.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TcpRouteArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        TcpRoute is the resource defining how TCP traffic should be routed by a Mesh/Gateway resource.

        To get more information about TcpRoute, see:

        * [API documentation](https://cloud.google.com/traffic-director/docs/reference/network-services/rest/v1beta1/projects.locations.tcpRoutes)
        * How-to Guides
            * [Setup TCP Services](https://cloud.google.com/traffic-director/docs/set-up-tcp-route)

        ## Example Usage

        ### Network Services Tcp Route Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_http_health_check = gcp.compute.HttpHealthCheck("default",
            name="backend-service-health-check",
            request_path="/",
            check_interval_sec=1,
            timeout_sec=1)
        default = gcp.compute.BackendService("default",
            name="my-backend-service",
            health_checks=default_http_health_check.id)
        default_tcp_route = gcp.networkservices.TcpRoute("default",
            name="my-tcp-route",
            labels={
                "foo": "bar",
            },
            description="my description",
            rules=[{
                "matches": [{
                    "address": "10.0.0.1/32",
                    "port": "8081",
                }],
                "action": {
                    "destinations": [{
                        "service_name": default.id,
                        "weight": 1,
                    }],
                    "original_destination": False,
                },
            }])
        ```
        ### Network Services Tcp Route Actions

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_http_health_check = gcp.compute.HttpHealthCheck("default",
            name="backend-service-health-check",
            request_path="/",
            check_interval_sec=1,
            timeout_sec=1)
        default = gcp.compute.BackendService("default",
            name="my-backend-service",
            health_checks=default_http_health_check.id)
        default_tcp_route = gcp.networkservices.TcpRoute("default",
            name="my-tcp-route",
            labels={
                "foo": "bar",
            },
            description="my description",
            rules=[{
                "action": {
                    "destinations": [{
                        "service_name": default.id,
                        "weight": 1,
                    }],
                    "original_destination": False,
                    "idle_timeout": "60s",
                },
            }])
        ```
        ### Network Services Tcp Route Mesh Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_http_health_check = gcp.compute.HttpHealthCheck("default",
            name="backend-service-health-check",
            request_path="/",
            check_interval_sec=1,
            timeout_sec=1)
        default = gcp.compute.BackendService("default",
            name="my-backend-service",
            health_checks=default_http_health_check.id)
        default_mesh = gcp.networkservices.Mesh("default",
            name="my-tcp-route",
            labels={
                "foo": "bar",
            },
            description="my description")
        default_tcp_route = gcp.networkservices.TcpRoute("default",
            name="my-tcp-route",
            labels={
                "foo": "bar",
            },
            description="my description",
            meshes=[default_mesh.id],
            rules=[{
                "matches": [{
                    "address": "10.0.0.1/32",
                    "port": "8081",
                }],
                "action": {
                    "destinations": [{
                        "service_name": default.id,
                        "weight": 1,
                    }],
                    "original_destination": False,
                },
            }])
        ```
        ### Network Services Tcp Route Gateway Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_http_health_check = gcp.compute.HttpHealthCheck("default",
            name="backend-service-health-check",
            request_path="/",
            check_interval_sec=1,
            timeout_sec=1)
        default = gcp.compute.BackendService("default",
            name="my-backend-service",
            health_checks=default_http_health_check.id)
        default_gateway = gcp.networkservices.Gateway("default",
            name="my-tcp-route",
            labels={
                "foo": "bar",
            },
            description="my description",
            scope="my-scope",
            type="OPEN_MESH",
            ports=[443])
        default_tcp_route = gcp.networkservices.TcpRoute("default",
            name="my-tcp-route",
            labels={
                "foo": "bar",
            },
            description="my description",
            gateways=[default_gateway.id],
            rules=[{
                "matches": [{
                    "address": "10.0.0.1/32",
                    "port": "8081",
                }],
                "action": {
                    "destinations": [{
                        "service_name": default.id,
                        "weight": 1,
                    }],
                    "original_destination": False,
                },
            }])
        ```

        ## Import

        TcpRoute can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/global/tcpRoutes/{{name}}`

        * `{{project}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, TcpRoute can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:networkservices/tcpRoute:TcpRoute default projects/{{project}}/locations/global/tcpRoutes/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networkservices/tcpRoute:TcpRoute default {{project}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networkservices/tcpRoute:TcpRoute default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param TcpRouteArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TcpRouteArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 gateways: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 meshes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TcpRouteRuleArgs', 'TcpRouteRuleArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TcpRouteArgs.__new__(TcpRouteArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["gateways"] = gateways
            __props__.__dict__["labels"] = labels
            __props__.__dict__["meshes"] = meshes
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            if rules is None and not opts.urn:
                raise TypeError("Missing required property 'rules'")
            __props__.__dict__["rules"] = rules
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["self_link"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(TcpRoute, __self__).__init__(
            'gcp:networkservices/tcpRoute:TcpRoute',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            gateways: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            meshes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TcpRouteRuleArgs', 'TcpRouteRuleArgsDict']]]]] = None,
            self_link: Optional[pulumi.Input[builtins.str]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None) -> 'TcpRoute':
        """
        Get an existing TcpRoute resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] create_time: Time the TcpRoute was created in UTC.
        :param pulumi.Input[builtins.str] description: A free-text description of the resource. Max length 1024 characters.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] gateways: Gateways defines a list of gateways this TcpRoute is attached to, as one of the routing rules to route the requests
               served by the gateway. Each gateway reference should match the pattern:
               projects/*/locations/global/gateways/<gateway_name>
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Set of label tags associated with the TcpRoute resource. **Note**: This field is non-authoritative, and will only manage
               the labels present in your configuration. Please refer to the field 'effective_labels' for all of the labels present on
               the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] meshes: Meshes defines a list of meshes this TcpRoute is attached to, as one of the routing rules to route the requests served
               by the mesh. Each mesh reference should match the pattern: projects/*/locations/global/meshes/<mesh_name> The attached
               Mesh should be of a type SIDECAR
        :param pulumi.Input[builtins.str] name: Name of the TcpRoute resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TcpRouteRuleArgs', 'TcpRouteRuleArgsDict']]]] rules: Rules that define how traffic is routed and handled. At least one RouteRule must be supplied.
               If there are multiple rules then the action taken will be the first rule to match.
               Structure is documented below.
        :param pulumi.Input[builtins.str] self_link: Server-defined URL of this resource.
        :param pulumi.Input[builtins.str] update_time: Time the TcpRoute was updated in UTC.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TcpRouteState.__new__(_TcpRouteState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["gateways"] = gateways
        __props__.__dict__["labels"] = labels
        __props__.__dict__["meshes"] = meshes
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["rules"] = rules
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["update_time"] = update_time
        return TcpRoute(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        Time the TcpRoute was created in UTC.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A free-text description of the resource. Max length 1024 characters.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter
    def gateways(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Gateways defines a list of gateways this TcpRoute is attached to, as one of the routing rules to route the requests
        served by the gateway. Each gateway reference should match the pattern:
        projects/*/locations/global/gateways/<gateway_name>
        """
        return pulumi.get(self, "gateways")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Set of label tags associated with the TcpRoute resource. **Note**: This field is non-authoritative, and will only manage
        the labels present in your configuration. Please refer to the field 'effective_labels' for all of the labels present on
        the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def meshes(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Meshes defines a list of meshes this TcpRoute is attached to, as one of the routing rules to route the requests served
        by the mesh. Each mesh reference should match the pattern: projects/*/locations/global/meshes/<mesh_name> The attached
        Mesh should be of a type SIDECAR
        """
        return pulumi.get(self, "meshes")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the TcpRoute resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter
    def rules(self) -> pulumi.Output[Sequence['outputs.TcpRouteRule']]:
        """
        Rules that define how traffic is routed and handled. At least one RouteRule must be supplied.
        If there are multiple rules then the action taken will be the first rule to match.
        Structure is documented below.
        """
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[builtins.str]:
        """
        Server-defined URL of this resource.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        Time the TcpRoute was updated in UTC.
        """
        return pulumi.get(self, "update_time")

