# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CloudExadataInfrastructureArgs', 'CloudExadataInfrastructure']

@pulumi.input_type
class CloudExadataInfrastructureArgs:
    def __init__(__self__, *,
                 cloud_exadata_infrastructure_id: pulumi.Input[builtins.str],
                 location: pulumi.Input[builtins.str],
                 deletion_protection: Optional[pulumi.Input[builtins.bool]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 gcp_oracle_zone: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 properties: Optional[pulumi.Input['CloudExadataInfrastructurePropertiesArgs']] = None):
        """
        The set of arguments for constructing a CloudExadataInfrastructure resource.
        :param pulumi.Input[builtins.str] cloud_exadata_infrastructure_id: The ID of the Exadata Infrastructure to create. This value is restricted
               to (^a-z?$) and must be a maximum of 63
               characters in length. The value must start with a letter and end with
               a letter or a number.
               
               
               - - -
        :param pulumi.Input[builtins.str] location: Resource ID segment making up resource `name`. See documentation for resource type `oracledatabase.googleapis.com/DbServer`.
        :param pulumi.Input[builtins.str] display_name: User friendly name for this resource.
        :param pulumi.Input[builtins.str] gcp_oracle_zone: GCP location where Oracle Exadata is hosted.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels or tags associated with the resource.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['CloudExadataInfrastructurePropertiesArgs'] properties: Various properties of Exadata Infrastructure.
               Structure is documented below.
        """
        pulumi.set(__self__, "cloud_exadata_infrastructure_id", cloud_exadata_infrastructure_id)
        pulumi.set(__self__, "location", location)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if gcp_oracle_zone is not None:
            pulumi.set(__self__, "gcp_oracle_zone", gcp_oracle_zone)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="cloudExadataInfrastructureId")
    def cloud_exadata_infrastructure_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Exadata Infrastructure to create. This value is restricted
        to (^a-z?$) and must be a maximum of 63
        characters in length. The value must start with a letter and end with
        a letter or a number.


        - - -
        """
        return pulumi.get(self, "cloud_exadata_infrastructure_id")

    @cloud_exadata_infrastructure_id.setter
    def cloud_exadata_infrastructure_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "cloud_exadata_infrastructure_id", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        Resource ID segment making up resource `name`. See documentation for resource type `oracledatabase.googleapis.com/DbServer`.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User friendly name for this resource.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="gcpOracleZone")
    def gcp_oracle_zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        GCP location where Oracle Exadata is hosted.
        """
        return pulumi.get(self, "gcp_oracle_zone")

    @gcp_oracle_zone.setter
    def gcp_oracle_zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "gcp_oracle_zone", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Labels or tags associated with the resource.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['CloudExadataInfrastructurePropertiesArgs']]:
        """
        Various properties of Exadata Infrastructure.
        Structure is documented below.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['CloudExadataInfrastructurePropertiesArgs']]):
        pulumi.set(self, "properties", value)


@pulumi.input_type
class _CloudExadataInfrastructureState:
    def __init__(__self__, *,
                 cloud_exadata_infrastructure_id: Optional[pulumi.Input[builtins.str]] = None,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[builtins.bool]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 entitlement_id: Optional[pulumi.Input[builtins.str]] = None,
                 gcp_oracle_zone: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 properties: Optional[pulumi.Input['CloudExadataInfrastructurePropertiesArgs']] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering CloudExadataInfrastructure resources.
        :param pulumi.Input[builtins.str] cloud_exadata_infrastructure_id: The ID of the Exadata Infrastructure to create. This value is restricted
               to (^a-z?$) and must be a maximum of 63
               characters in length. The value must start with a letter and end with
               a letter or a number.
               
               
               - - -
        :param pulumi.Input[builtins.str] create_time: The date and time that the Exadata Infrastructure was created.
        :param pulumi.Input[builtins.str] display_name: User friendly name for this resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.str] entitlement_id: Entitlement ID of the private offer against which this infrastructure
               resource is provisioned.
        :param pulumi.Input[builtins.str] gcp_oracle_zone: GCP location where Oracle Exadata is hosted.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels or tags associated with the resource.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: Resource ID segment making up resource `name`. See documentation for resource type `oracledatabase.googleapis.com/DbServer`.
        :param pulumi.Input[builtins.str] name: Identifier. The name of the Exadata Infrastructure resource with the following format:
               projects/{project}/locations/{region}/cloudExadataInfrastructures/{cloud_exadata_infrastructure}
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['CloudExadataInfrastructurePropertiesArgs'] properties: Various properties of Exadata Infrastructure.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        """
        if cloud_exadata_infrastructure_id is not None:
            pulumi.set(__self__, "cloud_exadata_infrastructure_id", cloud_exadata_infrastructure_id)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if entitlement_id is not None:
            pulumi.set(__self__, "entitlement_id", entitlement_id)
        if gcp_oracle_zone is not None:
            pulumi.set(__self__, "gcp_oracle_zone", gcp_oracle_zone)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)

    @property
    @pulumi.getter(name="cloudExadataInfrastructureId")
    def cloud_exadata_infrastructure_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Exadata Infrastructure to create. This value is restricted
        to (^a-z?$) and must be a maximum of 63
        characters in length. The value must start with a letter and end with
        a letter or a number.


        - - -
        """
        return pulumi.get(self, "cloud_exadata_infrastructure_id")

    @cloud_exadata_infrastructure_id.setter
    def cloud_exadata_infrastructure_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cloud_exadata_infrastructure_id", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time that the Exadata Infrastructure was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User friendly name for this resource.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter(name="entitlementId")
    def entitlement_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Entitlement ID of the private offer against which this infrastructure
        resource is provisioned.
        """
        return pulumi.get(self, "entitlement_id")

    @entitlement_id.setter
    def entitlement_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "entitlement_id", value)

    @property
    @pulumi.getter(name="gcpOracleZone")
    def gcp_oracle_zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        GCP location where Oracle Exadata is hosted.
        """
        return pulumi.get(self, "gcp_oracle_zone")

    @gcp_oracle_zone.setter
    def gcp_oracle_zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "gcp_oracle_zone", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Labels or tags associated with the resource.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Resource ID segment making up resource `name`. See documentation for resource type `oracledatabase.googleapis.com/DbServer`.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier. The name of the Exadata Infrastructure resource with the following format:
        projects/{project}/locations/{region}/cloudExadataInfrastructures/{cloud_exadata_infrastructure}
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['CloudExadataInfrastructurePropertiesArgs']]:
        """
        Various properties of Exadata Infrastructure.
        Structure is documented below.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['CloudExadataInfrastructurePropertiesArgs']]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)


@pulumi.type_token("gcp:oracledatabase/cloudExadataInfrastructure:CloudExadataInfrastructure")
class CloudExadataInfrastructure(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloud_exadata_infrastructure_id: Optional[pulumi.Input[builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[builtins.bool]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 gcp_oracle_zone: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 properties: Optional[pulumi.Input[Union['CloudExadataInfrastructurePropertiesArgs', 'CloudExadataInfrastructurePropertiesArgsDict']]] = None,
                 __props__=None):
        """
        A CloudExadataInfrastructure resource.

        To get more information about CloudExadataInfrastructure, see:

        * [API documentation](https://cloud.google.com/oracle/database/docs/reference/rest/v1/projects.locations.cloudExadataInfrastructures)
        * How-to Guides
            * [Create Exadata Infrastructure instances](https://cloud.google.com/oracle/database/docs/create-instances)

        ## Example Usage

        ### Oracledatabase Cloud Exadata Infrastructure Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_cloud_exadata = gcp.oracledatabase.CloudExadataInfrastructure("my-cloud-exadata",
            cloud_exadata_infrastructure_id="my-instance",
            display_name="my-instance displayname",
            location="us-east4",
            project="my-project",
            properties={
                "shape": "Exadata.X9M",
                "compute_count": 2,
                "storage_count": 3,
            },
            deletion_protection=True)
        ```
        ### Oracledatabase Cloud Exadata Infrastructure Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_cloud_exadata = gcp.oracledatabase.CloudExadataInfrastructure("my-cloud-exadata",
            cloud_exadata_infrastructure_id="my-instance",
            display_name="my-instance displayname",
            location="us-east4",
            project="my-project",
            gcp_oracle_zone="us-east4-b-r1",
            properties={
                "shape": "Exadata.X9M",
                "compute_count": 2,
                "storage_count": 3,
                "customer_contacts": [{
                    "email": "xyz@example.com",
                }],
                "maintenance_window": {
                    "custom_action_timeout_mins": 20,
                    "days_of_weeks": ["SUNDAY"],
                    "hours_of_days": [4],
                    "is_custom_action_timeout_enabled": False,
                    "lead_time_week": 1,
                    "months": [
                        "JANUARY",
                        "APRIL",
                        "MAY",
                        "OCTOBER",
                    ],
                    "patching_mode": "ROLLING",
                    "preference": "CUSTOM_PREFERENCE",
                    "weeks_of_months": [4],
                },
                "total_storage_size_gb": 196608,
            },
            labels={
                "label-one": "value-one",
            },
            deletion_protection=True)
        ```

        ## Import

        CloudExadataInfrastructure can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/cloudExadataInfrastructures/{{cloud_exadata_infrastructure_id}}`

        * `{{project}}/{{location}}/{{cloud_exadata_infrastructure_id}}`

        * `{{location}}/{{cloud_exadata_infrastructure_id}}`

        When using the `pulumi import` command, CloudExadataInfrastructure can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:oracledatabase/cloudExadataInfrastructure:CloudExadataInfrastructure default projects/{{project}}/locations/{{location}}/cloudExadataInfrastructures/{{cloud_exadata_infrastructure_id}}
        ```

        ```sh
        $ pulumi import gcp:oracledatabase/cloudExadataInfrastructure:CloudExadataInfrastructure default {{project}}/{{location}}/{{cloud_exadata_infrastructure_id}}
        ```

        ```sh
        $ pulumi import gcp:oracledatabase/cloudExadataInfrastructure:CloudExadataInfrastructure default {{location}}/{{cloud_exadata_infrastructure_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] cloud_exadata_infrastructure_id: The ID of the Exadata Infrastructure to create. This value is restricted
               to (^a-z?$) and must be a maximum of 63
               characters in length. The value must start with a letter and end with
               a letter or a number.
               
               
               - - -
        :param pulumi.Input[builtins.str] display_name: User friendly name for this resource.
        :param pulumi.Input[builtins.str] gcp_oracle_zone: GCP location where Oracle Exadata is hosted.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels or tags associated with the resource.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: Resource ID segment making up resource `name`. See documentation for resource type `oracledatabase.googleapis.com/DbServer`.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['CloudExadataInfrastructurePropertiesArgs', 'CloudExadataInfrastructurePropertiesArgsDict']] properties: Various properties of Exadata Infrastructure.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CloudExadataInfrastructureArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A CloudExadataInfrastructure resource.

        To get more information about CloudExadataInfrastructure, see:

        * [API documentation](https://cloud.google.com/oracle/database/docs/reference/rest/v1/projects.locations.cloudExadataInfrastructures)
        * How-to Guides
            * [Create Exadata Infrastructure instances](https://cloud.google.com/oracle/database/docs/create-instances)

        ## Example Usage

        ### Oracledatabase Cloud Exadata Infrastructure Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_cloud_exadata = gcp.oracledatabase.CloudExadataInfrastructure("my-cloud-exadata",
            cloud_exadata_infrastructure_id="my-instance",
            display_name="my-instance displayname",
            location="us-east4",
            project="my-project",
            properties={
                "shape": "Exadata.X9M",
                "compute_count": 2,
                "storage_count": 3,
            },
            deletion_protection=True)
        ```
        ### Oracledatabase Cloud Exadata Infrastructure Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_cloud_exadata = gcp.oracledatabase.CloudExadataInfrastructure("my-cloud-exadata",
            cloud_exadata_infrastructure_id="my-instance",
            display_name="my-instance displayname",
            location="us-east4",
            project="my-project",
            gcp_oracle_zone="us-east4-b-r1",
            properties={
                "shape": "Exadata.X9M",
                "compute_count": 2,
                "storage_count": 3,
                "customer_contacts": [{
                    "email": "xyz@example.com",
                }],
                "maintenance_window": {
                    "custom_action_timeout_mins": 20,
                    "days_of_weeks": ["SUNDAY"],
                    "hours_of_days": [4],
                    "is_custom_action_timeout_enabled": False,
                    "lead_time_week": 1,
                    "months": [
                        "JANUARY",
                        "APRIL",
                        "MAY",
                        "OCTOBER",
                    ],
                    "patching_mode": "ROLLING",
                    "preference": "CUSTOM_PREFERENCE",
                    "weeks_of_months": [4],
                },
                "total_storage_size_gb": 196608,
            },
            labels={
                "label-one": "value-one",
            },
            deletion_protection=True)
        ```

        ## Import

        CloudExadataInfrastructure can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/cloudExadataInfrastructures/{{cloud_exadata_infrastructure_id}}`

        * `{{project}}/{{location}}/{{cloud_exadata_infrastructure_id}}`

        * `{{location}}/{{cloud_exadata_infrastructure_id}}`

        When using the `pulumi import` command, CloudExadataInfrastructure can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:oracledatabase/cloudExadataInfrastructure:CloudExadataInfrastructure default projects/{{project}}/locations/{{location}}/cloudExadataInfrastructures/{{cloud_exadata_infrastructure_id}}
        ```

        ```sh
        $ pulumi import gcp:oracledatabase/cloudExadataInfrastructure:CloudExadataInfrastructure default {{project}}/{{location}}/{{cloud_exadata_infrastructure_id}}
        ```

        ```sh
        $ pulumi import gcp:oracledatabase/cloudExadataInfrastructure:CloudExadataInfrastructure default {{location}}/{{cloud_exadata_infrastructure_id}}
        ```

        :param str resource_name: The name of the resource.
        :param CloudExadataInfrastructureArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CloudExadataInfrastructureArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloud_exadata_infrastructure_id: Optional[pulumi.Input[builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[builtins.bool]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 gcp_oracle_zone: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 properties: Optional[pulumi.Input[Union['CloudExadataInfrastructurePropertiesArgs', 'CloudExadataInfrastructurePropertiesArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CloudExadataInfrastructureArgs.__new__(CloudExadataInfrastructureArgs)

            if cloud_exadata_infrastructure_id is None and not opts.urn:
                raise TypeError("Missing required property 'cloud_exadata_infrastructure_id'")
            __props__.__dict__["cloud_exadata_infrastructure_id"] = cloud_exadata_infrastructure_id
            __props__.__dict__["deletion_protection"] = deletion_protection
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["gcp_oracle_zone"] = gcp_oracle_zone
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            __props__.__dict__["properties"] = properties
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["entitlement_id"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["pulumi_labels"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(CloudExadataInfrastructure, __self__).__init__(
            'gcp:oracledatabase/cloudExadataInfrastructure:CloudExadataInfrastructure',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cloud_exadata_infrastructure_id: Optional[pulumi.Input[builtins.str]] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            deletion_protection: Optional[pulumi.Input[builtins.bool]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            entitlement_id: Optional[pulumi.Input[builtins.str]] = None,
            gcp_oracle_zone: Optional[pulumi.Input[builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            properties: Optional[pulumi.Input[Union['CloudExadataInfrastructurePropertiesArgs', 'CloudExadataInfrastructurePropertiesArgsDict']]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None) -> 'CloudExadataInfrastructure':
        """
        Get an existing CloudExadataInfrastructure resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] cloud_exadata_infrastructure_id: The ID of the Exadata Infrastructure to create. This value is restricted
               to (^a-z?$) and must be a maximum of 63
               characters in length. The value must start with a letter and end with
               a letter or a number.
               
               
               - - -
        :param pulumi.Input[builtins.str] create_time: The date and time that the Exadata Infrastructure was created.
        :param pulumi.Input[builtins.str] display_name: User friendly name for this resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.str] entitlement_id: Entitlement ID of the private offer against which this infrastructure
               resource is provisioned.
        :param pulumi.Input[builtins.str] gcp_oracle_zone: GCP location where Oracle Exadata is hosted.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels or tags associated with the resource.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: Resource ID segment making up resource `name`. See documentation for resource type `oracledatabase.googleapis.com/DbServer`.
        :param pulumi.Input[builtins.str] name: Identifier. The name of the Exadata Infrastructure resource with the following format:
               projects/{project}/locations/{region}/cloudExadataInfrastructures/{cloud_exadata_infrastructure}
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['CloudExadataInfrastructurePropertiesArgs', 'CloudExadataInfrastructurePropertiesArgsDict']] properties: Various properties of Exadata Infrastructure.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CloudExadataInfrastructureState.__new__(_CloudExadataInfrastructureState)

        __props__.__dict__["cloud_exadata_infrastructure_id"] = cloud_exadata_infrastructure_id
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["deletion_protection"] = deletion_protection
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["entitlement_id"] = entitlement_id
        __props__.__dict__["gcp_oracle_zone"] = gcp_oracle_zone
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["properties"] = properties
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        return CloudExadataInfrastructure(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="cloudExadataInfrastructureId")
    def cloud_exadata_infrastructure_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Exadata Infrastructure to create. This value is restricted
        to (^a-z?$) and must be a maximum of 63
        characters in length. The value must start with a letter and end with
        a letter or a number.


        - - -
        """
        return pulumi.get(self, "cloud_exadata_infrastructure_id")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        The date and time that the Exadata Infrastructure was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[Optional[builtins.bool]]:
        return pulumi.get(self, "deletion_protection")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        User friendly name for this resource.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter(name="entitlementId")
    def entitlement_id(self) -> pulumi.Output[builtins.str]:
        """
        Entitlement ID of the private offer against which this infrastructure
        resource is provisioned.
        """
        return pulumi.get(self, "entitlement_id")

    @property
    @pulumi.getter(name="gcpOracleZone")
    def gcp_oracle_zone(self) -> pulumi.Output[builtins.str]:
        """
        GCP location where Oracle Exadata is hosted.
        """
        return pulumi.get(self, "gcp_oracle_zone")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Labels or tags associated with the resource.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        Resource ID segment making up resource `name`. See documentation for resource type `oracledatabase.googleapis.com/DbServer`.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Identifier. The name of the Exadata Infrastructure resource with the following format:
        projects/{project}/locations/{region}/cloudExadataInfrastructures/{cloud_exadata_infrastructure}
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def properties(self) -> pulumi.Output[Optional['outputs.CloudExadataInfrastructureProperties']]:
        """
        Various properties of Exadata Infrastructure.
        Structure is documented below.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

