# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CloudVmClusterArgs', 'CloudVmCluster']

@pulumi.input_type
class CloudVmClusterArgs:
    def __init__(__self__, *,
                 backup_subnet_cidr: pulumi.Input[builtins.str],
                 cidr: pulumi.Input[builtins.str],
                 cloud_vm_cluster_id: pulumi.Input[builtins.str],
                 exadata_infrastructure: pulumi.Input[builtins.str],
                 location: pulumi.Input[builtins.str],
                 network: pulumi.Input[builtins.str],
                 deletion_protection: Optional[pulumi.Input[builtins.bool]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 properties: Optional[pulumi.Input['CloudVmClusterPropertiesArgs']] = None):
        """
        The set of arguments for constructing a CloudVmCluster resource.
        :param pulumi.Input[builtins.str] backup_subnet_cidr: CIDR range of the backup subnet.
        :param pulumi.Input[builtins.str] cidr: Network settings. CIDR to use for cluster IP allocation.
        :param pulumi.Input[builtins.str] cloud_vm_cluster_id: The ID of the VM Cluster to create. This value is restricted
               to (^a-z?$) and must be a maximum of 63
               characters in length. The value must start with a letter and end with
               a letter or a number.
               
               
               - - -
        :param pulumi.Input[builtins.str] exadata_infrastructure: The name of the Exadata Infrastructure resource on which VM cluster
               resource is created, in the following format:
               projects/{project}/locations/{region}/cloudExadataInfrastuctures/{cloud_extradata_infrastructure}
        :param pulumi.Input[builtins.str] location: Resource ID segment making up resource `name`. See documentation for resource type `oracledatabase.googleapis.com/DbNode`.
        :param pulumi.Input[builtins.str] network: The name of the VPC network.
               Format: projects/{project}/global/networks/{network}
        :param pulumi.Input[builtins.str] display_name: User friendly name for this resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels or tags associated with the VM Cluster.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['CloudVmClusterPropertiesArgs'] properties: Various properties and settings associated with Exadata VM cluster.
               Structure is documented below.
        """
        pulumi.set(__self__, "backup_subnet_cidr", backup_subnet_cidr)
        pulumi.set(__self__, "cidr", cidr)
        pulumi.set(__self__, "cloud_vm_cluster_id", cloud_vm_cluster_id)
        pulumi.set(__self__, "exadata_infrastructure", exadata_infrastructure)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "network", network)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="backupSubnetCidr")
    def backup_subnet_cidr(self) -> pulumi.Input[builtins.str]:
        """
        CIDR range of the backup subnet.
        """
        return pulumi.get(self, "backup_subnet_cidr")

    @backup_subnet_cidr.setter
    def backup_subnet_cidr(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "backup_subnet_cidr", value)

    @property
    @pulumi.getter
    def cidr(self) -> pulumi.Input[builtins.str]:
        """
        Network settings. CIDR to use for cluster IP allocation.
        """
        return pulumi.get(self, "cidr")

    @cidr.setter
    def cidr(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "cidr", value)

    @property
    @pulumi.getter(name="cloudVmClusterId")
    def cloud_vm_cluster_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the VM Cluster to create. This value is restricted
        to (^a-z?$) and must be a maximum of 63
        characters in length. The value must start with a letter and end with
        a letter or a number.


        - - -
        """
        return pulumi.get(self, "cloud_vm_cluster_id")

    @cloud_vm_cluster_id.setter
    def cloud_vm_cluster_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "cloud_vm_cluster_id", value)

    @property
    @pulumi.getter(name="exadataInfrastructure")
    def exadata_infrastructure(self) -> pulumi.Input[builtins.str]:
        """
        The name of the Exadata Infrastructure resource on which VM cluster
        resource is created, in the following format:
        projects/{project}/locations/{region}/cloudExadataInfrastuctures/{cloud_extradata_infrastructure}
        """
        return pulumi.get(self, "exadata_infrastructure")

    @exadata_infrastructure.setter
    def exadata_infrastructure(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "exadata_infrastructure", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        Resource ID segment making up resource `name`. See documentation for resource type `oracledatabase.googleapis.com/DbNode`.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def network(self) -> pulumi.Input[builtins.str]:
        """
        The name of the VPC network.
        Format: projects/{project}/global/networks/{network}
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User friendly name for this resource.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Labels or tags associated with the VM Cluster.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['CloudVmClusterPropertiesArgs']]:
        """
        Various properties and settings associated with Exadata VM cluster.
        Structure is documented below.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['CloudVmClusterPropertiesArgs']]):
        pulumi.set(self, "properties", value)


@pulumi.input_type
class _CloudVmClusterState:
    def __init__(__self__, *,
                 backup_subnet_cidr: Optional[pulumi.Input[builtins.str]] = None,
                 cidr: Optional[pulumi.Input[builtins.str]] = None,
                 cloud_vm_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[builtins.bool]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 exadata_infrastructure: Optional[pulumi.Input[builtins.str]] = None,
                 gcp_oracle_zone: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 properties: Optional[pulumi.Input['CloudVmClusterPropertiesArgs']] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering CloudVmCluster resources.
        :param pulumi.Input[builtins.str] backup_subnet_cidr: CIDR range of the backup subnet.
        :param pulumi.Input[builtins.str] cidr: Network settings. CIDR to use for cluster IP allocation.
        :param pulumi.Input[builtins.str] cloud_vm_cluster_id: The ID of the VM Cluster to create. This value is restricted
               to (^a-z?$) and must be a maximum of 63
               characters in length. The value must start with a letter and end with
               a letter or a number.
               
               
               - - -
        :param pulumi.Input[builtins.str] create_time: The date and time that the VM cluster was created.
        :param pulumi.Input[builtins.str] display_name: User friendly name for this resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.str] exadata_infrastructure: The name of the Exadata Infrastructure resource on which VM cluster
               resource is created, in the following format:
               projects/{project}/locations/{region}/cloudExadataInfrastuctures/{cloud_extradata_infrastructure}
        :param pulumi.Input[builtins.str] gcp_oracle_zone: GCP location where Oracle Exadata is hosted. It is same as GCP Oracle zone
               of Exadata infrastructure.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels or tags associated with the VM Cluster.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: Resource ID segment making up resource `name`. See documentation for resource type `oracledatabase.googleapis.com/DbNode`.
        :param pulumi.Input[builtins.str] name: Identifier. The name of the VM Cluster resource with the format:
               projects/{project}/locations/{region}/cloudVmClusters/{cloud_vm_cluster}
        :param pulumi.Input[builtins.str] network: The name of the VPC network.
               Format: projects/{project}/global/networks/{network}
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['CloudVmClusterPropertiesArgs'] properties: Various properties and settings associated with Exadata VM cluster.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        """
        if backup_subnet_cidr is not None:
            pulumi.set(__self__, "backup_subnet_cidr", backup_subnet_cidr)
        if cidr is not None:
            pulumi.set(__self__, "cidr", cidr)
        if cloud_vm_cluster_id is not None:
            pulumi.set(__self__, "cloud_vm_cluster_id", cloud_vm_cluster_id)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if exadata_infrastructure is not None:
            pulumi.set(__self__, "exadata_infrastructure", exadata_infrastructure)
        if gcp_oracle_zone is not None:
            pulumi.set(__self__, "gcp_oracle_zone", gcp_oracle_zone)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)

    @property
    @pulumi.getter(name="backupSubnetCidr")
    def backup_subnet_cidr(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        CIDR range of the backup subnet.
        """
        return pulumi.get(self, "backup_subnet_cidr")

    @backup_subnet_cidr.setter
    def backup_subnet_cidr(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "backup_subnet_cidr", value)

    @property
    @pulumi.getter
    def cidr(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Network settings. CIDR to use for cluster IP allocation.
        """
        return pulumi.get(self, "cidr")

    @cidr.setter
    def cidr(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cidr", value)

    @property
    @pulumi.getter(name="cloudVmClusterId")
    def cloud_vm_cluster_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the VM Cluster to create. This value is restricted
        to (^a-z?$) and must be a maximum of 63
        characters in length. The value must start with a letter and end with
        a letter or a number.


        - - -
        """
        return pulumi.get(self, "cloud_vm_cluster_id")

    @cloud_vm_cluster_id.setter
    def cloud_vm_cluster_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cloud_vm_cluster_id", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time that the VM cluster was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User friendly name for this resource.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter(name="exadataInfrastructure")
    def exadata_infrastructure(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Exadata Infrastructure resource on which VM cluster
        resource is created, in the following format:
        projects/{project}/locations/{region}/cloudExadataInfrastuctures/{cloud_extradata_infrastructure}
        """
        return pulumi.get(self, "exadata_infrastructure")

    @exadata_infrastructure.setter
    def exadata_infrastructure(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "exadata_infrastructure", value)

    @property
    @pulumi.getter(name="gcpOracleZone")
    def gcp_oracle_zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        GCP location where Oracle Exadata is hosted. It is same as GCP Oracle zone
        of Exadata infrastructure.
        """
        return pulumi.get(self, "gcp_oracle_zone")

    @gcp_oracle_zone.setter
    def gcp_oracle_zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "gcp_oracle_zone", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Labels or tags associated with the VM Cluster.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Resource ID segment making up resource `name`. See documentation for resource type `oracledatabase.googleapis.com/DbNode`.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier. The name of the VM Cluster resource with the format:
        projects/{project}/locations/{region}/cloudVmClusters/{cloud_vm_cluster}
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the VPC network.
        Format: projects/{project}/global/networks/{network}
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['CloudVmClusterPropertiesArgs']]:
        """
        Various properties and settings associated with Exadata VM cluster.
        Structure is documented below.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['CloudVmClusterPropertiesArgs']]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)


@pulumi.type_token("gcp:oracledatabase/cloudVmCluster:CloudVmCluster")
class CloudVmCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_subnet_cidr: Optional[pulumi.Input[builtins.str]] = None,
                 cidr: Optional[pulumi.Input[builtins.str]] = None,
                 cloud_vm_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[builtins.bool]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 exadata_infrastructure: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 network: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 properties: Optional[pulumi.Input[Union['CloudVmClusterPropertiesArgs', 'CloudVmClusterPropertiesArgsDict']]] = None,
                 __props__=None):
        """
        A CloudVmCluster resource.

        To get more information about CloudVmCluster, see:

        * [API documentation](https://cloud.google.com/oracle/database/docs/reference/rest/v1/projects.locations.cloudVmClusters)
        * How-to Guides
            * [Create VM clusters](https://cloud.google.com/oracle/database/docs/create-clusters)

        ## Example Usage

        ### Oracledatabase Cloud Vmcluster Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        cloud_exadata_infrastructures = gcp.oracledatabase.CloudExadataInfrastructure("cloudExadataInfrastructures",
            cloud_exadata_infrastructure_id="my-exadata",
            display_name="my-exadata displayname",
            location="us-east4",
            project="my-project",
            properties={
                "shape": "Exadata.X9M",
                "compute_count": 2,
                "storage_count": 3,
            },
            deletion_protection=True)
        default = gcp.compute.get_network(name="new",
            project="my-project")
        my_vmcluster = gcp.oracledatabase.CloudVmCluster("my_vmcluster",
            cloud_vm_cluster_id="my-instance",
            display_name="my-instance displayname",
            location="us-east4",
            project="my-project",
            exadata_infrastructure=cloud_exadata_infrastructures.id,
            network=default.id,
            cidr="10.5.0.0/24",
            backup_subnet_cidr="10.6.0.0/24",
            properties={
                "license_type": "LICENSE_INCLUDED",
                "ssh_public_keys": ["ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAACAQCz1X2744t+6vRLmE5u6nHi6/QWh8bQDgHmd+OIxRQIGA/IWUtCs2FnaCNZcqvZkaeyjk5v0lTA/n+9jvO42Ipib53athrfVG8gRt8fzPL66C6ZqHq+6zZophhrCdfJh/0G4x9xJh5gdMprlaCR1P8yAaVvhBQSKGc4SiIkyMNBcHJ5YTtMQMTfxaB4G1sHZ6SDAY9a6Cq/zNjDwfPapWLsiP4mRhE5SSjJX6l6EYbkm0JeLQg+AbJiNEPvrvDp1wtTxzlPJtIivthmLMThFxK7+DkrYFuLvN5AHUdo9KTDLvHtDCvV70r8v0gafsrKkM/OE9Jtzoo0e1N/5K/ZdyFRbAkFT4QSF3nwpbmBWLf2Evg//YyEuxnz4CwPqFST2mucnrCCGCVWp1vnHZ0y30nM35njLOmWdRDFy5l27pKUTwLp02y3UYiiZyP7d3/u5pKiN4vC27VuvzprSdJxWoAvluOiDeRh+/oeQDowxoT/Oop8DzB9uJmjktXw8jyMW2+Rpg+ENQqeNgF1OGlEzypaWiRskEFlkpLb4v/s3ZDYkL1oW0Nv/J8LTjTOTEaYt2Udjoe9x2xWiGnQixhdChWuG+MaoWffzUgx1tsVj/DBXijR5DjkPkrA1GA98zd3q8GKEaAdcDenJjHhNYSd4+rE9pIsnYn7fo5X/tFfcQH1XQ== nobody@google.com"],
                "cpu_core_count": 4,
                "gi_version": "19.0.0.0",
                "hostname_prefix": "hostname1",
            },
            deletion_protection=True)
        ```
        ### Oracledatabase Cloud Vmcluster Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        cloud_exadata_infrastructures = gcp.oracledatabase.CloudExadataInfrastructure("cloudExadataInfrastructures",
            cloud_exadata_infrastructure_id="my-exadata",
            display_name="my-exadata displayname",
            location="us-east4",
            project="my-project",
            properties={
                "shape": "Exadata.X9M",
                "compute_count": 2,
                "storage_count": 3,
            },
            deletion_protection=True)
        default = gcp.compute.get_network(name="new",
            project="my-project")
        mydbserver = gcp.oracledatabase.get_db_servers_output(location="us-east4",
            project="my-project",
            cloud_exadata_infrastructure=cloud_exadata_infrastructures.cloud_exadata_infrastructure_id)
        my_vmcluster = gcp.oracledatabase.CloudVmCluster("my_vmcluster",
            cloud_vm_cluster_id="my-instance",
            display_name="my-instance displayname",
            location="us-east4",
            project="my-project",
            exadata_infrastructure=cloud_exadata_infrastructures.id,
            network=default.id,
            cidr="10.5.0.0/24",
            backup_subnet_cidr="10.6.0.0/24",
            labels={
                "label-one": "value-one",
            },
            properties={
                "license_type": "LICENSE_INCLUDED",
                "ssh_public_keys": ["ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAACAQCz1X2744t+6vRLmE5u6nHi6/QWh8bQDgHmd+OIxRQIGA/IWUtCs2FnaCNZcqvZkaeyjk5v0lTA/n+9jvO42Ipib53athrfVG8gRt8fzPL66C6ZqHq+6zZophhrCdfJh/0G4x9xJh5gdMprlaCR1P8yAaVvhBQSKGc4SiIkyMNBcHJ5YTtMQMTfxaB4G1sHZ6SDAY9a6Cq/zNjDwfPapWLsiP4mRhE5SSjJX6l6EYbkm0JeLQg+AbJiNEPvrvDp1wtTxzlPJtIivthmLMThFxK7+DkrYFuLvN5AHUdo9KTDLvHtDCvV70r8v0gafsrKkM/OE9Jtzoo0e1N/5K/ZdyFRbAkFT4QSF3nwpbmBWLf2Evg//YyEuxnz4CwPqFST2mucnrCCGCVWp1vnHZ0y30nM35njLOmWdRDFy5l27pKUTwLp02y3UYiiZyP7d3/u5pKiN4vC27VuvzprSdJxWoAvluOiDeRh+/oeQDowxoT/Oop8DzB9uJmjktXw8jyMW2+Rpg+ENQqeNgF1OGlEzypaWiRskEFlkpLb4v/s3ZDYkL1oW0Nv/J8LTjTOTEaYt2Udjoe9x2xWiGnQixhdChWuG+MaoWffzUgx1tsVj/DBXijR5DjkPkrA1GA98zd3q8GKEaAdcDenJjHhNYSd4+rE9pIsnYn7fo5X/tFfcQH1XQ== nobody@google.com"],
                "cpu_core_count": 4,
                "gi_version": "19.0.0.0",
                "time_zone": {
                    "id": "UTC",
                },
                "node_count": 2,
                "ocpu_count": 4,
                "data_storage_size_tb": 2,
                "db_node_storage_size_gb": 120,
                "db_server_ocids": [
                    mydbserver.db_servers[0].properties[0].ocid,
                    mydbserver.db_servers[1].properties[0].ocid,
                ],
                "disk_redundancy": "HIGH",
                "sparse_diskgroup_enabled": False,
                "local_backup_enabled": False,
                "cluster_name": "pq-ppat4",
                "hostname_prefix": "hostname1",
                "diagnostics_data_collection_options": {
                    "diagnostics_events_enabled": True,
                    "health_monitoring_enabled": True,
                    "incident_logs_enabled": True,
                },
                "memory_size_gb": 60,
            },
            deletion_protection=True)
        ```

        ## Import

        CloudVmCluster can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/cloudVmClusters/{{cloud_vm_cluster_id}}`

        * `{{project}}/{{location}}/{{cloud_vm_cluster_id}}`

        * `{{location}}/{{cloud_vm_cluster_id}}`

        When using the `pulumi import` command, CloudVmCluster can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:oracledatabase/cloudVmCluster:CloudVmCluster default projects/{{project}}/locations/{{location}}/cloudVmClusters/{{cloud_vm_cluster_id}}
        ```

        ```sh
        $ pulumi import gcp:oracledatabase/cloudVmCluster:CloudVmCluster default {{project}}/{{location}}/{{cloud_vm_cluster_id}}
        ```

        ```sh
        $ pulumi import gcp:oracledatabase/cloudVmCluster:CloudVmCluster default {{location}}/{{cloud_vm_cluster_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] backup_subnet_cidr: CIDR range of the backup subnet.
        :param pulumi.Input[builtins.str] cidr: Network settings. CIDR to use for cluster IP allocation.
        :param pulumi.Input[builtins.str] cloud_vm_cluster_id: The ID of the VM Cluster to create. This value is restricted
               to (^a-z?$) and must be a maximum of 63
               characters in length. The value must start with a letter and end with
               a letter or a number.
               
               
               - - -
        :param pulumi.Input[builtins.str] display_name: User friendly name for this resource.
        :param pulumi.Input[builtins.str] exadata_infrastructure: The name of the Exadata Infrastructure resource on which VM cluster
               resource is created, in the following format:
               projects/{project}/locations/{region}/cloudExadataInfrastuctures/{cloud_extradata_infrastructure}
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels or tags associated with the VM Cluster.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: Resource ID segment making up resource `name`. See documentation for resource type `oracledatabase.googleapis.com/DbNode`.
        :param pulumi.Input[builtins.str] network: The name of the VPC network.
               Format: projects/{project}/global/networks/{network}
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['CloudVmClusterPropertiesArgs', 'CloudVmClusterPropertiesArgsDict']] properties: Various properties and settings associated with Exadata VM cluster.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CloudVmClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A CloudVmCluster resource.

        To get more information about CloudVmCluster, see:

        * [API documentation](https://cloud.google.com/oracle/database/docs/reference/rest/v1/projects.locations.cloudVmClusters)
        * How-to Guides
            * [Create VM clusters](https://cloud.google.com/oracle/database/docs/create-clusters)

        ## Example Usage

        ### Oracledatabase Cloud Vmcluster Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        cloud_exadata_infrastructures = gcp.oracledatabase.CloudExadataInfrastructure("cloudExadataInfrastructures",
            cloud_exadata_infrastructure_id="my-exadata",
            display_name="my-exadata displayname",
            location="us-east4",
            project="my-project",
            properties={
                "shape": "Exadata.X9M",
                "compute_count": 2,
                "storage_count": 3,
            },
            deletion_protection=True)
        default = gcp.compute.get_network(name="new",
            project="my-project")
        my_vmcluster = gcp.oracledatabase.CloudVmCluster("my_vmcluster",
            cloud_vm_cluster_id="my-instance",
            display_name="my-instance displayname",
            location="us-east4",
            project="my-project",
            exadata_infrastructure=cloud_exadata_infrastructures.id,
            network=default.id,
            cidr="10.5.0.0/24",
            backup_subnet_cidr="10.6.0.0/24",
            properties={
                "license_type": "LICENSE_INCLUDED",
                "ssh_public_keys": ["ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAACAQCz1X2744t+6vRLmE5u6nHi6/QWh8bQDgHmd+OIxRQIGA/IWUtCs2FnaCNZcqvZkaeyjk5v0lTA/n+9jvO42Ipib53athrfVG8gRt8fzPL66C6ZqHq+6zZophhrCdfJh/0G4x9xJh5gdMprlaCR1P8yAaVvhBQSKGc4SiIkyMNBcHJ5YTtMQMTfxaB4G1sHZ6SDAY9a6Cq/zNjDwfPapWLsiP4mRhE5SSjJX6l6EYbkm0JeLQg+AbJiNEPvrvDp1wtTxzlPJtIivthmLMThFxK7+DkrYFuLvN5AHUdo9KTDLvHtDCvV70r8v0gafsrKkM/OE9Jtzoo0e1N/5K/ZdyFRbAkFT4QSF3nwpbmBWLf2Evg//YyEuxnz4CwPqFST2mucnrCCGCVWp1vnHZ0y30nM35njLOmWdRDFy5l27pKUTwLp02y3UYiiZyP7d3/u5pKiN4vC27VuvzprSdJxWoAvluOiDeRh+/oeQDowxoT/Oop8DzB9uJmjktXw8jyMW2+Rpg+ENQqeNgF1OGlEzypaWiRskEFlkpLb4v/s3ZDYkL1oW0Nv/J8LTjTOTEaYt2Udjoe9x2xWiGnQixhdChWuG+MaoWffzUgx1tsVj/DBXijR5DjkPkrA1GA98zd3q8GKEaAdcDenJjHhNYSd4+rE9pIsnYn7fo5X/tFfcQH1XQ== nobody@google.com"],
                "cpu_core_count": 4,
                "gi_version": "19.0.0.0",
                "hostname_prefix": "hostname1",
            },
            deletion_protection=True)
        ```
        ### Oracledatabase Cloud Vmcluster Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        cloud_exadata_infrastructures = gcp.oracledatabase.CloudExadataInfrastructure("cloudExadataInfrastructures",
            cloud_exadata_infrastructure_id="my-exadata",
            display_name="my-exadata displayname",
            location="us-east4",
            project="my-project",
            properties={
                "shape": "Exadata.X9M",
                "compute_count": 2,
                "storage_count": 3,
            },
            deletion_protection=True)
        default = gcp.compute.get_network(name="new",
            project="my-project")
        mydbserver = gcp.oracledatabase.get_db_servers_output(location="us-east4",
            project="my-project",
            cloud_exadata_infrastructure=cloud_exadata_infrastructures.cloud_exadata_infrastructure_id)
        my_vmcluster = gcp.oracledatabase.CloudVmCluster("my_vmcluster",
            cloud_vm_cluster_id="my-instance",
            display_name="my-instance displayname",
            location="us-east4",
            project="my-project",
            exadata_infrastructure=cloud_exadata_infrastructures.id,
            network=default.id,
            cidr="10.5.0.0/24",
            backup_subnet_cidr="10.6.0.0/24",
            labels={
                "label-one": "value-one",
            },
            properties={
                "license_type": "LICENSE_INCLUDED",
                "ssh_public_keys": ["ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAACAQCz1X2744t+6vRLmE5u6nHi6/QWh8bQDgHmd+OIxRQIGA/IWUtCs2FnaCNZcqvZkaeyjk5v0lTA/n+9jvO42Ipib53athrfVG8gRt8fzPL66C6ZqHq+6zZophhrCdfJh/0G4x9xJh5gdMprlaCR1P8yAaVvhBQSKGc4SiIkyMNBcHJ5YTtMQMTfxaB4G1sHZ6SDAY9a6Cq/zNjDwfPapWLsiP4mRhE5SSjJX6l6EYbkm0JeLQg+AbJiNEPvrvDp1wtTxzlPJtIivthmLMThFxK7+DkrYFuLvN5AHUdo9KTDLvHtDCvV70r8v0gafsrKkM/OE9Jtzoo0e1N/5K/ZdyFRbAkFT4QSF3nwpbmBWLf2Evg//YyEuxnz4CwPqFST2mucnrCCGCVWp1vnHZ0y30nM35njLOmWdRDFy5l27pKUTwLp02y3UYiiZyP7d3/u5pKiN4vC27VuvzprSdJxWoAvluOiDeRh+/oeQDowxoT/Oop8DzB9uJmjktXw8jyMW2+Rpg+ENQqeNgF1OGlEzypaWiRskEFlkpLb4v/s3ZDYkL1oW0Nv/J8LTjTOTEaYt2Udjoe9x2xWiGnQixhdChWuG+MaoWffzUgx1tsVj/DBXijR5DjkPkrA1GA98zd3q8GKEaAdcDenJjHhNYSd4+rE9pIsnYn7fo5X/tFfcQH1XQ== nobody@google.com"],
                "cpu_core_count": 4,
                "gi_version": "19.0.0.0",
                "time_zone": {
                    "id": "UTC",
                },
                "node_count": 2,
                "ocpu_count": 4,
                "data_storage_size_tb": 2,
                "db_node_storage_size_gb": 120,
                "db_server_ocids": [
                    mydbserver.db_servers[0].properties[0].ocid,
                    mydbserver.db_servers[1].properties[0].ocid,
                ],
                "disk_redundancy": "HIGH",
                "sparse_diskgroup_enabled": False,
                "local_backup_enabled": False,
                "cluster_name": "pq-ppat4",
                "hostname_prefix": "hostname1",
                "diagnostics_data_collection_options": {
                    "diagnostics_events_enabled": True,
                    "health_monitoring_enabled": True,
                    "incident_logs_enabled": True,
                },
                "memory_size_gb": 60,
            },
            deletion_protection=True)
        ```

        ## Import

        CloudVmCluster can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/cloudVmClusters/{{cloud_vm_cluster_id}}`

        * `{{project}}/{{location}}/{{cloud_vm_cluster_id}}`

        * `{{location}}/{{cloud_vm_cluster_id}}`

        When using the `pulumi import` command, CloudVmCluster can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:oracledatabase/cloudVmCluster:CloudVmCluster default projects/{{project}}/locations/{{location}}/cloudVmClusters/{{cloud_vm_cluster_id}}
        ```

        ```sh
        $ pulumi import gcp:oracledatabase/cloudVmCluster:CloudVmCluster default {{project}}/{{location}}/{{cloud_vm_cluster_id}}
        ```

        ```sh
        $ pulumi import gcp:oracledatabase/cloudVmCluster:CloudVmCluster default {{location}}/{{cloud_vm_cluster_id}}
        ```

        :param str resource_name: The name of the resource.
        :param CloudVmClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CloudVmClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_subnet_cidr: Optional[pulumi.Input[builtins.str]] = None,
                 cidr: Optional[pulumi.Input[builtins.str]] = None,
                 cloud_vm_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[builtins.bool]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 exadata_infrastructure: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 network: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 properties: Optional[pulumi.Input[Union['CloudVmClusterPropertiesArgs', 'CloudVmClusterPropertiesArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CloudVmClusterArgs.__new__(CloudVmClusterArgs)

            if backup_subnet_cidr is None and not opts.urn:
                raise TypeError("Missing required property 'backup_subnet_cidr'")
            __props__.__dict__["backup_subnet_cidr"] = backup_subnet_cidr
            if cidr is None and not opts.urn:
                raise TypeError("Missing required property 'cidr'")
            __props__.__dict__["cidr"] = cidr
            if cloud_vm_cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'cloud_vm_cluster_id'")
            __props__.__dict__["cloud_vm_cluster_id"] = cloud_vm_cluster_id
            __props__.__dict__["deletion_protection"] = deletion_protection
            __props__.__dict__["display_name"] = display_name
            if exadata_infrastructure is None and not opts.urn:
                raise TypeError("Missing required property 'exadata_infrastructure'")
            __props__.__dict__["exadata_infrastructure"] = exadata_infrastructure
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            if network is None and not opts.urn:
                raise TypeError("Missing required property 'network'")
            __props__.__dict__["network"] = network
            __props__.__dict__["project"] = project
            __props__.__dict__["properties"] = properties
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["gcp_oracle_zone"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["pulumi_labels"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(CloudVmCluster, __self__).__init__(
            'gcp:oracledatabase/cloudVmCluster:CloudVmCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backup_subnet_cidr: Optional[pulumi.Input[builtins.str]] = None,
            cidr: Optional[pulumi.Input[builtins.str]] = None,
            cloud_vm_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            deletion_protection: Optional[pulumi.Input[builtins.bool]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            exadata_infrastructure: Optional[pulumi.Input[builtins.str]] = None,
            gcp_oracle_zone: Optional[pulumi.Input[builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            network: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            properties: Optional[pulumi.Input[Union['CloudVmClusterPropertiesArgs', 'CloudVmClusterPropertiesArgsDict']]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None) -> 'CloudVmCluster':
        """
        Get an existing CloudVmCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] backup_subnet_cidr: CIDR range of the backup subnet.
        :param pulumi.Input[builtins.str] cidr: Network settings. CIDR to use for cluster IP allocation.
        :param pulumi.Input[builtins.str] cloud_vm_cluster_id: The ID of the VM Cluster to create. This value is restricted
               to (^a-z?$) and must be a maximum of 63
               characters in length. The value must start with a letter and end with
               a letter or a number.
               
               
               - - -
        :param pulumi.Input[builtins.str] create_time: The date and time that the VM cluster was created.
        :param pulumi.Input[builtins.str] display_name: User friendly name for this resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.str] exadata_infrastructure: The name of the Exadata Infrastructure resource on which VM cluster
               resource is created, in the following format:
               projects/{project}/locations/{region}/cloudExadataInfrastuctures/{cloud_extradata_infrastructure}
        :param pulumi.Input[builtins.str] gcp_oracle_zone: GCP location where Oracle Exadata is hosted. It is same as GCP Oracle zone
               of Exadata infrastructure.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels or tags associated with the VM Cluster.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: Resource ID segment making up resource `name`. See documentation for resource type `oracledatabase.googleapis.com/DbNode`.
        :param pulumi.Input[builtins.str] name: Identifier. The name of the VM Cluster resource with the format:
               projects/{project}/locations/{region}/cloudVmClusters/{cloud_vm_cluster}
        :param pulumi.Input[builtins.str] network: The name of the VPC network.
               Format: projects/{project}/global/networks/{network}
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['CloudVmClusterPropertiesArgs', 'CloudVmClusterPropertiesArgsDict']] properties: Various properties and settings associated with Exadata VM cluster.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CloudVmClusterState.__new__(_CloudVmClusterState)

        __props__.__dict__["backup_subnet_cidr"] = backup_subnet_cidr
        __props__.__dict__["cidr"] = cidr
        __props__.__dict__["cloud_vm_cluster_id"] = cloud_vm_cluster_id
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["deletion_protection"] = deletion_protection
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["exadata_infrastructure"] = exadata_infrastructure
        __props__.__dict__["gcp_oracle_zone"] = gcp_oracle_zone
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["network"] = network
        __props__.__dict__["project"] = project
        __props__.__dict__["properties"] = properties
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        return CloudVmCluster(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="backupSubnetCidr")
    def backup_subnet_cidr(self) -> pulumi.Output[builtins.str]:
        """
        CIDR range of the backup subnet.
        """
        return pulumi.get(self, "backup_subnet_cidr")

    @property
    @pulumi.getter
    def cidr(self) -> pulumi.Output[builtins.str]:
        """
        Network settings. CIDR to use for cluster IP allocation.
        """
        return pulumi.get(self, "cidr")

    @property
    @pulumi.getter(name="cloudVmClusterId")
    def cloud_vm_cluster_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the VM Cluster to create. This value is restricted
        to (^a-z?$) and must be a maximum of 63
        characters in length. The value must start with a letter and end with
        a letter or a number.


        - - -
        """
        return pulumi.get(self, "cloud_vm_cluster_id")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        The date and time that the VM cluster was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[Optional[builtins.bool]]:
        return pulumi.get(self, "deletion_protection")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        User friendly name for this resource.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter(name="exadataInfrastructure")
    def exadata_infrastructure(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Exadata Infrastructure resource on which VM cluster
        resource is created, in the following format:
        projects/{project}/locations/{region}/cloudExadataInfrastuctures/{cloud_extradata_infrastructure}
        """
        return pulumi.get(self, "exadata_infrastructure")

    @property
    @pulumi.getter(name="gcpOracleZone")
    def gcp_oracle_zone(self) -> pulumi.Output[builtins.str]:
        """
        GCP location where Oracle Exadata is hosted. It is same as GCP Oracle zone
        of Exadata infrastructure.
        """
        return pulumi.get(self, "gcp_oracle_zone")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Labels or tags associated with the VM Cluster.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        Resource ID segment making up resource `name`. See documentation for resource type `oracledatabase.googleapis.com/DbNode`.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Identifier. The name of the VM Cluster resource with the format:
        projects/{project}/locations/{region}/cloudVmClusters/{cloud_vm_cluster}
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def network(self) -> pulumi.Output[builtins.str]:
        """
        The name of the VPC network.
        Format: projects/{project}/global/networks/{network}
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def properties(self) -> pulumi.Output[Optional['outputs.CloudVmClusterProperties']]:
        """
        Various properties and settings associated with Exadata VM cluster.
        Structure is documented below.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

