# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetSResult',
    'AwaitableGetSResult',
    'get_s',
    'get_s_output',
]

@pulumi.output_type
class GetSResult:
    """
    A collection of values returned by getS.
    """
    def __init__(__self__, filter=None, id=None, organizations=None):
        if filter and not isinstance(filter, str):
            raise TypeError("Expected argument 'filter' to be a str")
        pulumi.set(__self__, "filter", filter)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if organizations and not isinstance(organizations, list):
            raise TypeError("Expected argument 'organizations' to be a list")
        pulumi.set(__self__, "organizations", organizations)

    @property
    @pulumi.getter
    def filter(self) -> Optional[builtins.str]:
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def organizations(self) -> Sequence['outputs.GetSOrganizationResult']:
        """
        A list of all retrieved organizations. Structure is defined below.
        """
        return pulumi.get(self, "organizations")


class AwaitableGetSResult(GetSResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSResult(
            filter=self.filter,
            id=self.id,
            organizations=self.organizations)


def get_s(filter: Optional[builtins.str] = None,
          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSResult:
    """
    Gets a list of all organizations.
    See [the official documentation](https://cloud.google.com/resource-manager/docs/creating-managing-organization)
    and [API](https://cloud.google.com/resource-manager/reference/rest/v1/organizations/search).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    example = gcp.organizations.get_s(filter="domain:example.com")
    ```


    :param builtins.str filter: An optional query string used to filter the Organizations to return in the response. Filter rules are case-insensitive. Further information can be found in the [REST API](https://cloud.google.com/resource-manager/reference/rest/v1/organizations/search#request-body).
    """
    __args__ = dict()
    __args__['filter'] = filter
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:organizations/getS:getS', __args__, opts=opts, typ=GetSResult).value

    return AwaitableGetSResult(
        filter=pulumi.get(__ret__, 'filter'),
        id=pulumi.get(__ret__, 'id'),
        organizations=pulumi.get(__ret__, 'organizations'))
def get_s_output(filter: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSResult]:
    """
    Gets a list of all organizations.
    See [the official documentation](https://cloud.google.com/resource-manager/docs/creating-managing-organization)
    and [API](https://cloud.google.com/resource-manager/reference/rest/v1/organizations/search).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    example = gcp.organizations.get_s(filter="domain:example.com")
    ```


    :param builtins.str filter: An optional query string used to filter the Organizations to return in the response. Filter rules are case-insensitive. Further information can be found in the [REST API](https://cloud.google.com/resource-manager/reference/rest/v1/organizations/search#request-body).
    """
    __args__ = dict()
    __args__['filter'] = filter
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:organizations/getS:getS', __args__, opts=opts, typ=GetSResult)
    return __ret__.apply(lambda __response__: GetSResult(
        filter=pulumi.get(__response__, 'filter'),
        id=pulumi.get(__response__, 'id'),
        organizations=pulumi.get(__response__, 'organizations')))
